/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/


/* Include files for CSL */
#include <csl.h>
#include <csl_intc.h>
#include <csl_tcp2.h>
#include <csl_vcp2.h>

/* Coprocessor specifics */
#define VCP2_UserData Uint8*
#define VCP2_NUM_IC 6
#define VCP2_NUM_OP 2

#define TCP2_UserData Uint8*
#define TCP2_NUM_IC 16
#define TCP2_NUM_OP 3

/* Device specific */
#define GLOBAL_L2_MASK  0x00000000
#define GLOBAL_EDMA_EVT CSL_INTC_EVENTID_EDMA3CC_GINT
#define REGION_EDMA     CSL_EDMA3_REGION_1
#define REGION_EDMA_EVT CSL_INTC_EVENTID_EDMA3CC_INT1 // linked to previous def of DMA region

extern Uint32 vcp2DecAddress;

/* Prototype declarations */

Uint32 Vcp2Test(VCP2_Params *hVcpConfigParms, VCP2_ConfigIc *hVcpConfigIc,VCP2_UserData hVcpUserData,
				Uint32* hVcpDecisions,Uint32* hVcpOutParms);

Uint32 Tcp2Test(TCP2_Params *hTcpParameters, TCP2_ConfigIc *hTcpConfigIc, TCP2_UserData hTcpUserDataRate5,
                Uint16 *hTcpInterleaverTable, Uint32* hTcpDecisions,Uint32* hTcpOutParms);

Uint32 VCP2_getSoftRes(const Uint32 rate, const Uint32 K);

void VCP2_quantizeSoft(Uint32 * restrict in, Uint32 * restrict out, const Uint32 softInputResolution,
                      const Uint32 length);

void TCP2_quantizeSoft(Uint32 *restrict in,Uint32 *restrict out, const Uint8 scale_fixpt,
                      const Uint32 length);

void TCP2_deintUnpunctSoft3(Int8 *restrict UserData, Uint32 *restrict UserDataRate5,
                           Uint16 *restrict hTcpInterleaverTable, const Uint32 length);

Uint32
edma3Release();

Uint32
edma3Init();

Uint32
tcpvcp2_init();


