/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/

/***************************************************************************\
Here is a table with the most common 3GPP rates:

	Rate Type		ClassA3	ClassB3	ClassC2	Control3	RACH2	ConvData3
	_____________________________________________________________________
NB-AMR-DTX			47		0		0		164			-		-
 (SID-Update)
 + 3.4DCCH
	_____________________________________________________________________ 
12.2K NB-AMR		93		103		60		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
10.2K NB-AMR		77		90		40		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
7.95K NB-AMR		87		84		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
7.4K NB-AMR			73		87		0		164			-		-
  + 3.4DCCH
	_____________________________________________________________________  
6.7K NB-AMR			70		76		0		164			-		-
  + 3.4DCCH
	_____________________________________________________________________  
5.9K NB-AMR			67		63		0		90			-		-
  + 1.7DCCH
	_____________________________________________________________________  
5.15K NB-AMR		61		54		0		90			-		-
 + 1.7DCCH
	_____________________________________________________________________ 
4.75K NB-AMR		54		53		0		90			-		-
 + 1.7DCCH
	_____________________________________________________________________ 
6.60K WB-AMR		66		78		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
8.85K WB-AMR		76		113		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
12.65K WB-AMR		84		181		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
14.25K WB-AMR		84		213		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________
15.85K WB-AMR		84		245		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
18.25K WB-AMR		84		293		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________ 
19.85K WB-AMR		84		325		0		164			-		-
 + 3.4DCCH
 	_____________________________________________________________________ 
23.05K WB-AMR		84		389		0		164			-		-
 + 3.4DCCH
	_____________________________________________________________________  
23.85K WB-AMR		84		405		0		164			-		-
 + 3.4DCCH
 	_____________________________________________________________________ 
WB-AMR-DTX			52		0		0		164			-		-
 + 3.4DCCH
 	_____________________________________________________________________ 
AMR-DTX (No-Update)	0		0		0		164			-		-
 + 3.4DCCH
 	_____________________________________________________________________ 
SMS 13.6DCCH		0		0		0		164			-		-
	_____________________________________________________________________ 
32K Convolution		-		-		-		164			-		328
 Data + 3.4DCCH
 	_____________________________________________________________________ 
RACH				-		-		-		-			184		-
	_____________________________________________________________________ 
RACH				-		-		-		-			376		-
	_____________________________________________________________________ 	 
		
Default values
#define VCP2_K 9  constraint length 
#define VCP2_OUTPUT_PARAMETERS_READ_FLAG EBoolean_False  no read 
#define VCP2_DECISIONS VCP2_DECISION_HARD  hard decisions
#define VCP2_YAMTHRESHOLD 0  yamamoto algorithm disabled 
#define VCP2_INITIALMAXSMINDEX 0  initial index for maximum state metric IMAXS 
#define VCP2_NUMBER_OF_OUTPUT_PARMS_WORDS 2		


\***************************************************************************/

#include <csl.h>
#include <csl_vcp2.h>

#define VCP2_NUM_CURVES              32
#define VCP2_K 9 
#define VCP2_OUTPUT_PARAMETERS_READ_FLAG 0
#define VCP2_DECISIONS VCP2_DECISION_HARD
#define VCP2_YAMTHRESHOLD 0  
#define VCP2_INITIALMAXSMINDEX 0 



typedef struct {
   Uint16       frameLen;
   VCP2_Rate     rate;
   Uint8        constLen;
   Uint16       yamTh;
   Uint8        stateNum;   
   Uint8        readFlag;
   Uint8        decision;
   Uint32 		nBitThreshold;
   Uint32 		nErroneousFrameThreshold;
   double		 sigmaMin;
   double		 sigmaMax;
} VCP2BERCurve;

/* 	This BER framework is based on a common sigma to all type of frames
	sigma = sqrt(rate/(2*10^(SNR/10))
	SNR = 10*log(sigma^2*2/rate)
	we look at rates between 2 -> 4
	we expect SNR from 0 dB -> 3.5 dB		
		Range on sigma for rate 2 :	0.65 -> 1.00
		Range on sigma for rate 3 :	0.80 -> 1.20
		Range on sigma for rate 4 :	0.95 -> 1.40	
	You can have two modes if SNR is high (sigma <= 0.15):
	SATURATE_ON_HIGH_SNR defined: symbols are saturated to -128 and +127
	SATURATE_ON_HIGH_SNR  not defined:	no noise added on symbols
	(preprossessing symbol in compile options)
	
	Note that a BER point is valid if at least 10 frames are corrupted.
	That means that for high SNRs you may need to generate more frames.
*/

VCPBER2Curve VcpCurveParameters[VCP2_NUM_CURVES] = {

/* # -------------------- 10.2K NB-AMR - class C  ------------------ # */
{    
	70,			/* Frame length........... */
	2, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	10000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },                     
/* # -------------------- NB-AMR-DTX - class A  ------------------ # */
{    
	47,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	0, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },                     
/* # -------------------- WB-AMR-DTX - class A  ------------------ # */
{    
	52,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },                     
/* # --------------------    4.75K NB-AMR - class B  ------------------ # */
{    
	53,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   5.15K NB-AMR  - class B  ------------------ # */
{    
	54,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   12.2K NB-AMR  - class C  ------------------ # */
{    
	60,			/* Frame length........... */
	2, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   5.15K NB-AMR  - class A  ------------------ # */
{    
	61,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   5.9K NB-AMR  - class B  ------------------ # */
{    
	63,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   6.60K WB-AMR  - class A  ------------------ # */
{    
	66,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   5.9K NB-AMR  - class A  ------------------ # */
{    
	67,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   6.7K NB-AMR  - class A  ------------------ # */
{    
	70,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   7.4K NB-AMR  - class A  ------------------ # */
{    
	73,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   6.7K NB-AMR  - class B  ------------------ # */
{    
	76,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   10.2K NB-AMR  - class A  ------------------ # */
{    
	77,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   6.60K WB-AMR  - class A  ------------------ # */
{    
	78,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	200, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   14.25K WB-AMR  - class A  ------------------ # */
{    
	389,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },
/* # --------------------   23.85K WB-AMR - Class B  ------------------ # */
{    
	405,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.05, 		/* sigma mininimum ....... */
	0.10, 		/* sigma maximumum ....... */
    },    
/* # --------------------   10.2K NB-AMR  - class B  ------------------ # */
{    
	90,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   12.2K NB-AMR  - class A  ------------------ # */
{    
	93,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   12.2K NB-AMR  - class B  ------------------ # */
{    
	103,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   8.85K WB-AMR  - class B  ------------------ # */
{    
	113,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   3.4DCCH  ------------------ # */
{    
	164,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   12.65K WB-AMR - Class B  ------------------ # */
{    
	181,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   RACH  ------------------ # */
{    
	184,			/* Frame length........... */
	2, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.65, 		/* sigma mininimum ....... */
	1.00, 		/* sigma maximumum ....... */
    },    
/* # --------------------   14.25K WB-AMR - Class B  ------------------ # */
{    
	213,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   15.85K WB-AMR - Class B  ------------------ # */
{    
	245,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   18.25K WB-AMR - Class B  ------------------ # */
{    
	293,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   19.85K WB-AMR - Class B  ------------------ # */
{    
	325,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   32.2 kbps - conv. data  ------------------ # */
{    
	328,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },    
/* # --------------------   RACH  ------------------ # */
{    
	376,			/* Frame length........... */
	2, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.65, 		/* sigma mininimum ....... */
	1.00, 		/* sigma maximumum ....... */
    },    
/* # --------------------   23.05K WB-AMR   - Class B  ------------------ # */
{    
	389,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    },
/* # --------------------   23.85K WB-AMR - Class B  ------------------ # */
{    
	405,			/* Frame length........... */
	3, 			/* rate .................. */
	9, 			/* k ..................... */
	0,  		/* yamt .................. */
	0, 			/* imaxi ................. */
	1, 			/* outf .................. */
	0, 			/* sdhd .................. */
	1000000, 	/* nbits thresh .......... */
	1000, 		/* erroneous frame thresh  */
	0.80, 		/* sigma mininimum ....... */
	1.20, 		/* sigma maximumum ....... */
    }
};


