/****************************************************************************\
 *           Copyright (C) 2000 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
 ****************************************************************************
 *                                                                          *
 * Written by :                                                             *
 *            Sebastien Tomas  (VCP2/TCP2)                                  *
 *            Texas Instruments                                             * 
 *            12 May, 2005                                                  *
 *                                                                          *
 * The purpose of this test is to evaluate Bit-Error Rate performance for   *
 * both VCP2 and TCP2 co-processors in the TCI6482 (Himalaya)               *
 *									                                        *
 * This test should not be redistributed for any reason without             *
 * permission.                                                              *
 *                                                                          *
\***************************************************************************/

MEMORY
{
   /* 16K L1 cache  length = 0x3FFF 
      32K L1 cache  length = 0x7FFF
   */
   VECS     o=0x00E00000 l=0x00000200
   L1P:     o=0x00E00200 l=0x00007DFF
   L1D:     o=0x00F00000 l=0x00007FFF

   /* 32K  L2 cache length = 0xF7DFF
      64K  L2 cache length = 0xEFDFF
      128K L2 cache length = 0xDFDFF
      256K L2 cache length = 0xBFDFF
   */
   L2:      o=0x00800000 l=0x001EFFFF   
   SDRAM:   o=0x80000000 l=0x00800000
}

SECTIONS
{    
  .csl_vect	  > L2
  .bss        > L2
  .far        > L2
  .data       > L2
  .text       > L2
  .cio        > L2
  .cinit      > L2
  .boot       > L2
  .const      > L2
  .stack      > L2
  .sysmem     > L2 
  .switch     > L2
}

