//------------------------------------------------------------------------------
// File edma3.h
//------------------------------------------------------------------------------
// Copyright (c) 2010, Texas Instruments Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice,
//       this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Texas Instruments Inc. nor the names of its
//       contributors may be used to endorse or promote products derived from
//       this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//------------------------------------------------------------------------------

#ifndef _EDMA3_H_
#define _EDMA3_H_

#include "tistdtypes.h"
#include "ti/pspiom/cslr/soc_C6747.h"
#include "ti/pspiom/cslr/cslr_edma3cc.h"

#define EDMA_MCASPTXCH       1   // EDMA channel for McASP1 TX
#define EDMA_MCASPRXCH       0   // EDMA channel for McASP1 RX

#define EDMA_XMTPING         32
#define EDMA_XMTPONG         33
#define EDMA_RCVPING         34
#define EDMA_RCVPONG         35

#define EDMA_RCV_PING_TCC    1
#define EDMA_RCV_PONG_TCC    2
#define EDMA_XMT_PING_TCC    3
#define EDMA_XMT_PONG_TCC    4


void edmaInit();
void setup_edma_pingpong_xmt(void *src_ping, void *src_pong, void *dst,
                             Uint32 acnt, Uint32 bcnt);
void setup_edma_pingpong_rcv(void *src, void *dst_ping, void *dst_pong,
                             Uint32 acnt, Uint32 bcnt);

void edmaWritePaRAM(Int ParamNum, CSL_Edma3ccParamSetRegs *ptrParamInfo);
void edmaSetEvent(Int channelNumber);
void EdmaIntClear(Int channelNumber);
void EdmaIntEnable(Int intNumber);
void EdmaIntDisable(Int intNumber);
void EdmaEnableChannel(Int channelNumber, Int QueueNumber);
void EdmaDisableChannel(Int channelNumber);

#endif  // #ifndef _EDMA3_H_

//------------------------------------------------------------------------------
// End of File edma3.h
//------------------------------------------------------------------------------
