/*
 * cslr_mcasp.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/** ============================================================================
 *   @file  cslr_mcasp.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for MCASP
 *          The mcasp module is made up from 2 distinct modules "bolted"
 *          together to act as one.The modules are:
 *          (1) a basic McASP module
 *          (2) a McASP buffer/FIFO module.
 *          The McASP module has it's own MMR port and the McASP buffer (AFIFO)
 *          block has both a MMR port and a Data-in port in config memory space.
 *          The AFIFO Data-out port is connected directly to the McASP Data-in
 *          port. Hence there are 3 structs defined in this file.
 *  ============================================================================
 */
#ifndef _CSLR_MCASP_H_
#define _CSLR_MCASP_H_

#include "cslr.h"
#include "tistdtypes.h"

/**************************************************************************\
* AFIFO Data-IN Register Overlay Structure (buffer block)
\**************************************************************************/
typedef struct  {
    volatile Uint32 DATA_PORT;
    volatile Uint32 RSVD_04;
    volatile Uint32 RSVD_08;
    volatile Uint32 RSVD_0C;
} CSL_AdataRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_AdataRegs         *CSL_AdataRegsOvly;

/**************************************************************************\
* AFIFO MMR Register Overlay Structure (buffer block)
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 RSVD_04;
    volatile Uint32 RSVD_08;
    volatile Uint32 RSVD_0C;
    volatile Uint32 WFIFOCTL;
    volatile Uint32 WFIFOSTS;
    volatile Uint32 RFIFOCTL;
    volatile Uint32 RFIFOSTS;
} CSL_AfifoRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_AfifoRegs         *CSL_AfifoRegsOvly;

/* Minimum unit = 1 byte */

/**************************************************************************\
* McASP Register Overlay Structure (module block)
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 RSVD0[3];
    volatile Uint32 PFUNC;
    volatile Uint32 PDIR;
    volatile Uint32 PDOUT;
    volatile Uint32 PDIN;
    volatile Uint32 PDCLR;
    volatile Uint32 RSVD1[8];
    volatile Uint32 GBLCTL;
    volatile Uint32 AMUTE;
    volatile Uint32 DLBCTL;
    volatile Uint32 DITCTL;
    volatile Uint32 RSVD2[3];
    volatile Uint32 RGBLCTL;
    volatile Uint32 RMASK;
    volatile Uint32 RFMT;
    volatile Uint32 AFSRCTL;
    volatile Uint32 ACLKRCTL;
    volatile Uint32 AHCLKRCTL;
    volatile Uint32 RTDM;
    volatile Uint32 RINTCTL;
    volatile Uint32 RSTAT;
    volatile Uint32 RSLOT;
    volatile Uint32 RCLKCHK;
    volatile Uint32 REVTCTL;
    volatile Uint32 RSVD3[4];
    volatile Uint32 XGBLCTL;
    volatile Uint32 XMASK;
    volatile Uint32 XFMT;
    volatile Uint32 AFSXCTL;
    volatile Uint32 ACLKXCTL;
    volatile Uint32 AHCLKXCTL;
    volatile Uint32 XTDM;
    volatile Uint32 XINTCTL;
    volatile Uint32 XSTAT;
    volatile Uint32 XSLOT;
    volatile Uint32 XCLKCHK;
    volatile Uint32 XEVTCTL;
    volatile Uint32 RSVD4[12];
    volatile Uint32 DITCSRA0;
    volatile Uint32 DITCSRA1;
    volatile Uint32 DITCSRA2;
    volatile Uint32 DITCSRA3;
    volatile Uint32 DITCSRA4;
    volatile Uint32 DITCSRA5;
    volatile Uint32 DITCSRB0;
    volatile Uint32 DITCSRB1;
    volatile Uint32 DITCSRB2;
    volatile Uint32 DITCSRB3;
    volatile Uint32 DITCSRB4;
    volatile Uint32 DITCSRB5;
    volatile Uint32 DITUDRA0;
    volatile Uint32 DITUDRA1;
    volatile Uint32 DITUDRA2;
    volatile Uint32 DITUDRA3;
    volatile Uint32 DITUDRA4;
    volatile Uint32 DITUDRA5;
    volatile Uint32 DITUDRB0;
    volatile Uint32 DITUDRB1;
    volatile Uint32 DITUDRB2;
    volatile Uint32 DITUDRB3;
    volatile Uint32 DITUDRB4;
    volatile Uint32 DITUDRB5;
    volatile Uint32 RSVD5[8];
    volatile Uint32 SRCTL0;
    volatile Uint32 SRCTL1;
    volatile Uint32 SRCTL2;
    volatile Uint32 SRCTL3;
    volatile Uint32 SRCTL4;
    volatile Uint32 SRCTL5;
    volatile Uint32 SRCTL6;
    volatile Uint32 SRCTL7;
    volatile Uint32 SRCTL8;
    volatile Uint32 SRCTL9;
    volatile Uint32 SRCTL10;
    volatile Uint32 SRCTL11;
    volatile Uint32 SRCTL12;
    volatile Uint32 SRCTL13;
    volatile Uint32 SRCTL14;
    volatile Uint32 SRCTL15;
    volatile Uint32 RSVD6[16];
    volatile Uint32 XBUF0;
    volatile Uint32 XBUF1;
    volatile Uint32 XBUF2;
    volatile Uint32 XBUF3;
    volatile Uint32 XBUF4;
    volatile Uint32 XBUF5;
    volatile Uint32 XBUF6;
    volatile Uint32 XBUF7;
    volatile Uint32 XBUF8;
    volatile Uint32 XBUF9;
    volatile Uint32 XBUF10;
    volatile Uint32 XBUF11;
    volatile Uint32 XBUF12;
    volatile Uint32 XBUF13;
    volatile Uint32 XBUF14;
    volatile Uint32 XBUF15;
    volatile Uint32 RSVD7[16];
    volatile Uint32 RBUF0;
    volatile Uint32 RBUF1;
    volatile Uint32 RBUF2;
    volatile Uint32 RBUF3;
    volatile Uint32 RBUF4;
    volatile Uint32 RBUF5;
    volatile Uint32 RBUF6;
    volatile Uint32 RBUF7;
    volatile Uint32 RBUF8;
    volatile Uint32 RBUF9;
    volatile Uint32 RBUF10;
    volatile Uint32 RBUF11;
    volatile Uint32 RBUF12;
    volatile Uint32 RBUF13;
    volatile Uint32 RBUF14;
    volatile Uint32 RBUF15;
} CSL_McaspRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_McaspRegs  *CSL_McaspRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_MCASP_REVID_REV_MASK (0xFFFFFFFFu)
#define CSL_MCASP_REVID_REV_SHIFT (0x00000000u)
#define CSL_MCASP_REVID_REV_RESETVAL (0x44300A02u)

#define CSL_MCASP_REVID_RESETVAL (0x44300A02u)

/* PFUNC */

#define CSL_MCASP_PFUNC_AFSR_MASK (0x80000000u)
#define CSL_MCASP_PFUNC_AFSR_SHIFT (0x0000001Fu)
#define CSL_MCASP_PFUNC_AFSR_RESETVAL (0x00000000u)
/*----AFSR Tokens----*/
#define CSL_MCASP_PFUNC_AFSR_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AFSR_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AHCLKR_MASK (0x40000000u)
#define CSL_MCASP_PFUNC_AHCLKR_SHIFT (0x0000001Eu)
#define CSL_MCASP_PFUNC_AHCLKR_RESETVAL (0x00000000u)
/*----AHCLKR Tokens----*/
#define CSL_MCASP_PFUNC_AHCLKR_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AHCLKR_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_ACLKR_MASK (0x20000000u)
#define CSL_MCASP_PFUNC_ACLKR_SHIFT (0x0000001Du)
#define CSL_MCASP_PFUNC_ACLKR_RESETVAL (0x00000000u)
/*----ACLKR Tokens----*/
#define CSL_MCASP_PFUNC_ACLKR_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_ACLKR_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AFSX_MASK (0x10000000u)
#define CSL_MCASP_PFUNC_AFSX_SHIFT (0x0000001Cu)
#define CSL_MCASP_PFUNC_AFSX_RESETVAL (0x00000000u)
/*----AFSX Tokens----*/
#define CSL_MCASP_PFUNC_AFSX_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AFSX_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AHCLKX_MASK (0x08000000u)
#define CSL_MCASP_PFUNC_AHCLKX_SHIFT (0x0000001Bu)
#define CSL_MCASP_PFUNC_AHCLKX_RESETVAL (0x00000000u)
/*----AHCLKX Tokens----*/
#define CSL_MCASP_PFUNC_AHCLKX_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AHCLKX_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_ACLKX_MASK (0x04000000u)
#define CSL_MCASP_PFUNC_ACLKX_SHIFT (0x0000001Au)
#define CSL_MCASP_PFUNC_ACLKX_RESETVAL (0x00000000u)
/*----ACLKX Tokens----*/
#define CSL_MCASP_PFUNC_ACLKX_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_ACLKX_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AMUTE_MASK (0x02000000u)
#define CSL_MCASP_PFUNC_AMUTE_SHIFT (0x00000019u)
#define CSL_MCASP_PFUNC_AMUTE_RESETVAL (0x00000000u)
/*----AMUTE Tokens----*/
#define CSL_MCASP_PFUNC_AMUTE_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AMUTE_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR15_MASK (0x00008000u)
#define CSL_MCASP_PFUNC_AXR15_SHIFT (0x0000000Fu)
#define CSL_MCASP_PFUNC_AXR15_RESETVAL (0x00000000u)
#define CSL_MCASP_PFUNC_AXR15_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR15_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR14_MASK (0x00004000u)
#define CSL_MCASP_PFUNC_AXR14_SHIFT (0x0000000Eu)
#define CSL_MCASP_PFUNC_AXR14_RESETVAL (0x00000000u)
#define CSL_MCASP_PFUNC_AXR14_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR14_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR13_MASK (0x00002000u)
#define CSL_MCASP_PFUNC_AXR13_SHIFT (0x0000000Du)
#define CSL_MCASP_PFUNC_AXR13_RESETVAL (0x00000000u)
#define CSL_MCASP_PFUNC_AXR13_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR13_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR12_MASK (0x00001000u)
#define CSL_MCASP_PFUNC_AXR12_SHIFT (0x0000000Cu)
#define CSL_MCASP_PFUNC_AXR12_RESETVAL (0x00000000u)
#define CSL_MCASP_PFUNC_AXR12_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR12_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR11_MASK (0x00000800u)
#define CSL_MCASP_PFUNC_AXR11_SHIFT (0x0000000Bu)
#define CSL_MCASP_PFUNC_AXR11_RESETVAL (0x00000000u)
#define CSL_MCASP_PFUNC_AXR11_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR11_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR10_MASK (0x00000400u)
#define CSL_MCASP_PFUNC_AXR10_SHIFT (0x0000000Au)
#define CSL_MCASP_PFUNC_AXR10_RESETVAL (0x00000000u)
#define CSL_MCASP_PFUNC_AXR10_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR10_GPIO (0x00000001u)
#define CSL_MCASP_PFUNC_AXR9_MASK (0x00000200u)
#define CSL_MCASP_PFUNC_AXR9_SHIFT (0x00000009u)
#define CSL_MCASP_PFUNC_AXR9_RESETVAL (0x00000000u)
/*----AXR9 Tokens----*/
#define CSL_MCASP_PFUNC_AXR9_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR9_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR8_MASK (0x00000100u)
#define CSL_MCASP_PFUNC_AXR8_SHIFT (0x00000008u)
#define CSL_MCASP_PFUNC_AXR8_RESETVAL (0x00000000u)
/*----AXR8 Tokens----*/
#define CSL_MCASP_PFUNC_AXR8_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR8_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR7_MASK (0x00000080u)
#define CSL_MCASP_PFUNC_AXR7_SHIFT (0x00000007u)
#define CSL_MCASP_PFUNC_AXR7_RESETVAL (0x00000000u)
/*----AXR7 Tokens----*/
#define CSL_MCASP_PFUNC_AXR7_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR7_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR6_MASK (0x00000040u)
#define CSL_MCASP_PFUNC_AXR6_SHIFT (0x00000006u)
#define CSL_MCASP_PFUNC_AXR6_RESETVAL (0x00000000u)
/*----AXR6 Tokens----*/
#define CSL_MCASP_PFUNC_AXR6_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR6_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR5_MASK (0x00000020u)
#define CSL_MCASP_PFUNC_AXR5_SHIFT (0x00000005u)
#define CSL_MCASP_PFUNC_AXR5_RESETVAL (0x00000000u)
/*----AXR5 Tokens----*/
#define CSL_MCASP_PFUNC_AXR5_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR5_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR4_MASK (0x00000010u)
#define CSL_MCASP_PFUNC_AXR4_SHIFT (0x00000004u)
#define CSL_MCASP_PFUNC_AXR4_RESETVAL (0x00000000u)
/*----AXR4 Tokens----*/
#define CSL_MCASP_PFUNC_AXR4_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR4_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR3_MASK (0x00000008u)
#define CSL_MCASP_PFUNC_AXR3_SHIFT (0x00000003u)
#define CSL_MCASP_PFUNC_AXR3_RESETVAL (0x00000000u)
/*----AXR3 Tokens----*/
#define CSL_MCASP_PFUNC_AXR3_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR3_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR2_MASK (0x00000004u)
#define CSL_MCASP_PFUNC_AXR2_SHIFT (0x00000002u)
#define CSL_MCASP_PFUNC_AXR2_RESETVAL (0x00000000u)
/*----AXR2 Tokens----*/
#define CSL_MCASP_PFUNC_AXR2_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR2_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR1_MASK (0x00000002u)
#define CSL_MCASP_PFUNC_AXR1_SHIFT (0x00000001u)
#define CSL_MCASP_PFUNC_AXR1_RESETVAL (0x00000000u)
/*----AXR1 Tokens----*/
#define CSL_MCASP_PFUNC_AXR1_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR1_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_AXR0_MASK (0x00000001u)
#define CSL_MCASP_PFUNC_AXR0_SHIFT (0x00000000u)
#define CSL_MCASP_PFUNC_AXR0_RESETVAL (0x00000000u)
/*----AXR0 Tokens----*/
#define CSL_MCASP_PFUNC_AXR0_MCASP (0x00000000u)
#define CSL_MCASP_PFUNC_AXR0_GPIO (0x00000001u)

#define CSL_MCASP_PFUNC_RESETVAL (0x00000000u)

/* PDIR */

#define CSL_MCASP_PDIR_AFSR_MASK (0x80000000u)
#define CSL_MCASP_PDIR_AFSR_SHIFT (0x0000001Fu)
#define CSL_MCASP_PDIR_AFSR_RESETVAL (0x00000000u)
/*----AFSR Tokens----*/
#define CSL_MCASP_PDIR_AFSR_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AFSR_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AHCLKR_MASK (0x40000000u)
#define CSL_MCASP_PDIR_AHCLKR_SHIFT (0x0000001Eu)
#define CSL_MCASP_PDIR_AHCLKR_RESETVAL (0x00000000u)
/*----AHCLKR Tokens----*/
#define CSL_MCASP_PDIR_AHCLKR_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AHCLKR_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_ACLKR_MASK (0x20000000u)
#define CSL_MCASP_PDIR_ACLKR_SHIFT (0x0000001Du)
#define CSL_MCASP_PDIR_ACLKR_RESETVAL (0x00000000u)
/*----ACLKR Tokens----*/
#define CSL_MCASP_PDIR_ACLKR_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_ACLKR_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AFSX_MASK (0x10000000u)
#define CSL_MCASP_PDIR_AFSX_SHIFT (0x0000001Cu)
#define CSL_MCASP_PDIR_AFSX_RESETVAL (0x00000000u)
/*----AFSX Tokens----*/
#define CSL_MCASP_PDIR_AFSX_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AFSX_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AHCLKX_MASK (0x08000000u)
#define CSL_MCASP_PDIR_AHCLKX_SHIFT (0x0000001Bu)
#define CSL_MCASP_PDIR_AHCLKX_RESETVAL (0x00000000u)
/*----AHCLKX Tokens----*/
#define CSL_MCASP_PDIR_AHCLKX_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AHCLKX_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_ACLKX_MASK (0x04000000u)
#define CSL_MCASP_PDIR_ACLKX_SHIFT (0x0000001Au)
#define CSL_MCASP_PDIR_ACLKX_RESETVAL (0x00000000u)
/*----ACLKX Tokens----*/
#define CSL_MCASP_PDIR_ACLKX_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_ACLKX_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AMUTE_MASK (0x02000000u)
#define CSL_MCASP_PDIR_AMUTE_SHIFT (0x00000019u)
#define CSL_MCASP_PDIR_AMUTE_RESETVAL (0x00000000u)
/*----AMUTE Tokens----*/
#define CSL_MCASP_PDIR_AMUTE_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AMUTE_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR15_MASK (0x00008000u)
#define CSL_MCASP_PDIR_AXR15_SHIFT (0x0000000Fu)
#define CSL_MCASP_PDIR_AXR15_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIR_AXR15_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR15_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR14_MASK (0x00004000u)
#define CSL_MCASP_PDIR_AXR14_SHIFT (0x0000000Eu)
#define CSL_MCASP_PDIR_AXR14_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIR_AXR14_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR14_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR13_MASK (0x00002000u)
#define CSL_MCASP_PDIR_AXR13_SHIFT (0x0000000Du)
#define CSL_MCASP_PDIR_AXR13_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIR_AXR13_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR13_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR12_MASK (0x00001000u)
#define CSL_MCASP_PDIR_AXR12_SHIFT (0x0000000Cu)
#define CSL_MCASP_PDIR_AXR12_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIR_AXR12_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR12_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR11_MASK (0x00000800u)
#define CSL_MCASP_PDIR_AXR11_SHIFT (0x0000000Bu)
#define CSL_MCASP_PDIR_AXR11_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIR_AXR11_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR11_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR10_MASK (0x00000400u)
#define CSL_MCASP_PDIR_AXR10_SHIFT (0x0000000Au)
#define CSL_MCASP_PDIR_AXR10_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIR_AXR10_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR10_OUTPUT (0x00000001u)
#define CSL_MCASP_PDIR_AXR9_MASK (0x00000200u)
#define CSL_MCASP_PDIR_AXR9_SHIFT (0x00000009u)
#define CSL_MCASP_PDIR_AXR9_RESETVAL (0x00000000u)
/*----AXR9 Tokens----*/
#define CSL_MCASP_PDIR_AXR9_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR9_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR8_MASK (0x00000100u)
#define CSL_MCASP_PDIR_AXR8_SHIFT (0x00000008u)
#define CSL_MCASP_PDIR_AXR8_RESETVAL (0x00000000u)
/*----AXR8 Tokens----*/
#define CSL_MCASP_PDIR_AXR8_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR8_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR7_MASK (0x00000080u)
#define CSL_MCASP_PDIR_AXR7_SHIFT (0x00000007u)
#define CSL_MCASP_PDIR_AXR7_RESETVAL (0x00000000u)
/*----AXR7 Tokens----*/
#define CSL_MCASP_PDIR_AXR7_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR7_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR6_MASK (0x00000040u)
#define CSL_MCASP_PDIR_AXR6_SHIFT (0x00000006u)
#define CSL_MCASP_PDIR_AXR6_RESETVAL (0x00000000u)
/*----AXR6 Tokens----*/
#define CSL_MCASP_PDIR_AXR6_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR6_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR5_MASK (0x00000020u)
#define CSL_MCASP_PDIR_AXR5_SHIFT (0x00000005u)
#define CSL_MCASP_PDIR_AXR5_RESETVAL (0x00000000u)
/*----AXR5 Tokens----*/
#define CSL_MCASP_PDIR_AXR5_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR5_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR4_MASK (0x00000010u)
#define CSL_MCASP_PDIR_AXR4_SHIFT (0x00000004u)
#define CSL_MCASP_PDIR_AXR4_RESETVAL (0x00000000u)
/*----AXR4 Tokens----*/
#define CSL_MCASP_PDIR_AXR4_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR4_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR3_MASK (0x00000008u)
#define CSL_MCASP_PDIR_AXR3_SHIFT (0x00000003u)
#define CSL_MCASP_PDIR_AXR3_RESETVAL (0x00000000u)
/*----AXR3 Tokens----*/
#define CSL_MCASP_PDIR_AXR3_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR3_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR2_MASK (0x00000004u)
#define CSL_MCASP_PDIR_AXR2_SHIFT (0x00000002u)
#define CSL_MCASP_PDIR_AXR2_RESETVAL (0x00000000u)
/*----AXR2 Tokens----*/
#define CSL_MCASP_PDIR_AXR2_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR2_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR1_MASK (0x00000002u)
#define CSL_MCASP_PDIR_AXR1_SHIFT (0x00000001u)
#define CSL_MCASP_PDIR_AXR1_RESETVAL (0x00000000u)
/*----AXR1 Tokens----*/
#define CSL_MCASP_PDIR_AXR1_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR1_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_AXR0_MASK (0x00000001u)
#define CSL_MCASP_PDIR_AXR0_SHIFT (0x00000000u)
#define CSL_MCASP_PDIR_AXR0_RESETVAL (0x00000000u)
/*----AXR0 Tokens----*/
#define CSL_MCASP_PDIR_AXR0_INPUT (0x00000000u)
#define CSL_MCASP_PDIR_AXR0_OUTPUT (0x00000001u)

#define CSL_MCASP_PDIR_RESETVAL (0x00000000u)

/* PDOUT */

#define CSL_MCASP_PDOUT_AFSR_MASK (0x80000000u)
#define CSL_MCASP_PDOUT_AFSR_SHIFT (0x0000001Fu)
#define CSL_MCASP_PDOUT_AFSR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AFSR_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AFSR_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AHCLKR_MASK (0x40000000u)
#define CSL_MCASP_PDOUT_AHCLKR_SHIFT (0x0000001Eu)
#define CSL_MCASP_PDOUT_AHCLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AHCLKR_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AHCLKR_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_ACLKR_MASK (0x20000000u)
#define CSL_MCASP_PDOUT_ACLKR_SHIFT (0x0000001Du)
#define CSL_MCASP_PDOUT_ACLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_ACLKR_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_ACLKR_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AFSX_MASK (0x10000000u)
#define CSL_MCASP_PDOUT_AFSX_SHIFT (0x0000001Cu)
#define CSL_MCASP_PDOUT_AFSX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AFSX_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AFSX_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AHCLKX_MASK (0x08000000u)
#define CSL_MCASP_PDOUT_AHCLKX_SHIFT (0x0000001Bu)
#define CSL_MCASP_PDOUT_AHCLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AHCLKX_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AHCLKX_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_ACLKX_MASK (0x04000000u)
#define CSL_MCASP_PDOUT_ACLKX_SHIFT (0x0000001Au)
#define CSL_MCASP_PDOUT_ACLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_ACLKX_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_ACLKX_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AMUTE_MASK (0x02000000u)
#define CSL_MCASP_PDOUT_AMUTE_SHIFT (0x00000019u)
#define CSL_MCASP_PDOUT_AMUTE_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AMUTE_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AMUTE_DRV1 (0x00000001u)


#define CSL_MCASP_PDOUT_AXR15_MASK (0x00008000u)
#define CSL_MCASP_PDOUT_AXR15_SHIFT (0x0000000Fu)
#define CSL_MCASP_PDOUT_AXR15_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR15_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR15_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR14_MASK (0x00004000u)
#define CSL_MCASP_PDOUT_AXR14_SHIFT (0x0000000Eu)
#define CSL_MCASP_PDOUT_AXR14_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR14_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR14_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR13_MASK (0x00002000u)
#define CSL_MCASP_PDOUT_AXR13_SHIFT (0x0000000Du)
#define CSL_MCASP_PDOUT_AXR13_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR13_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR13_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR12_MASK (0x00001000u)
#define CSL_MCASP_PDOUT_AXR12_SHIFT (0x0000000Cu)
#define CSL_MCASP_PDOUT_AXR12_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR12_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR12_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR11_MASK (0x00000800u)
#define CSL_MCASP_PDOUT_AXR11_SHIFT (0x0000000Bu)
#define CSL_MCASP_PDOUT_AXR11_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR11_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR11_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR10_MASK (0x00000400u)
#define CSL_MCASP_PDOUT_AXR10_SHIFT (0x0000000Au)
#define CSL_MCASP_PDOUT_AXR10_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR10_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR10_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR9_MASK (0x00000200u)
#define CSL_MCASP_PDOUT_AXR9_SHIFT (0x00000009u)
#define CSL_MCASP_PDOUT_AXR9_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR9_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR9_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR8_MASK (0x00000100u)
#define CSL_MCASP_PDOUT_AXR8_SHIFT (0x00000008u)
#define CSL_MCASP_PDOUT_AXR8_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR8_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR8_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR7_MASK (0x00000080u)
#define CSL_MCASP_PDOUT_AXR7_SHIFT (0x00000007u)
#define CSL_MCASP_PDOUT_AXR7_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR7_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR7_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR6_MASK (0x00000040u)
#define CSL_MCASP_PDOUT_AXR6_SHIFT (0x00000006u)
#define CSL_MCASP_PDOUT_AXR6_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR6_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR6_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR5_MASK (0x00000020u)
#define CSL_MCASP_PDOUT_AXR5_SHIFT (0x00000005u)
#define CSL_MCASP_PDOUT_AXR5_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR5_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR5_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR4_MASK (0x00000010u)
#define CSL_MCASP_PDOUT_AXR4_SHIFT (0x00000004u)
#define CSL_MCASP_PDOUT_AXR4_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR4_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR4_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR3_MASK (0x00000008u)
#define CSL_MCASP_PDOUT_AXR3_SHIFT (0x00000003u)
#define CSL_MCASP_PDOUT_AXR3_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR3_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR3_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR2_MASK (0x00000004u)
#define CSL_MCASP_PDOUT_AXR2_SHIFT (0x00000002u)
#define CSL_MCASP_PDOUT_AXR2_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR2_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR2_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR1_MASK (0x00000002u)
#define CSL_MCASP_PDOUT_AXR1_SHIFT (0x00000001u)
#define CSL_MCASP_PDOUT_AXR1_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR1_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR1_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_AXR0_MASK (0x00000001u)
#define CSL_MCASP_PDOUT_AXR0_SHIFT (0x00000000u)
#define CSL_MCASP_PDOUT_AXR0_RESETVAL (0x00000000u)
#define CSL_MCASP_PDOUT_AXR0_DRV0 (0x00000000u)
#define CSL_MCASP_PDOUT_AXR0_DRV1 (0x00000001u)

#define CSL_MCASP_PDOUT_RESETVAL (0x00000000u)

/* PDIN */

#define CSL_MCASP_PDIN_AFSR_MASK (0x80000000u)
#define CSL_MCASP_PDIN_AFSR_SHIFT (0x0000001Fu)
#define CSL_MCASP_PDIN_AFSR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AFSR_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AFSR_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AHCLKR_MASK (0x40000000u)
#define CSL_MCASP_PDIN_AHCLKR_SHIFT (0x0000001Eu)
#define CSL_MCASP_PDIN_AHCLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AHCLKR_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AHCLKR_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_ACLKR_MASK (0x20000000u)
#define CSL_MCASP_PDIN_ACLKR_SHIFT (0x0000001Du)
#define CSL_MCASP_PDIN_ACLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_ACLKR_LOW (0x00000000u)
#define CSL_MCASP_PDIN_ACLKR_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AFSX_MASK (0x10000000u)
#define CSL_MCASP_PDIN_AFSX_SHIFT (0x0000001Cu)
#define CSL_MCASP_PDIN_AFSX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AFSX_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AFSX_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AHCLKX_MASK (0x08000000u)
#define CSL_MCASP_PDIN_AHCLKX_SHIFT (0x0000001Bu)
#define CSL_MCASP_PDIN_AHCLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AHCLKX_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AHCLKX_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_ACLKX_MASK (0x04000000u)
#define CSL_MCASP_PDIN_ACLKX_SHIFT (0x0000001Au)
#define CSL_MCASP_PDIN_ACLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_ACLKX_LOW (0x00000000u)
#define CSL_MCASP_PDIN_ACLKX_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AMUTE_MASK (0x02000000u)
#define CSL_MCASP_PDIN_AMUTE_SHIFT (0x00000019u)
#define CSL_MCASP_PDIN_AMUTE_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AMUTE_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AMUTE_HIGH (0x00000001u)


#define CSL_MCASP_PDIN_AXR15_MASK (0x00008000u)
#define CSL_MCASP_PDIN_AXR15_SHIFT (0x0000000Fu)
#define CSL_MCASP_PDIN_AXR15_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR15_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR15_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR14_MASK (0x00004000u)
#define CSL_MCASP_PDIN_AXR14_SHIFT (0x0000000Eu)
#define CSL_MCASP_PDIN_AXR14_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR14_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR14_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR13_MASK (0x00002000u)
#define CSL_MCASP_PDIN_AXR13_SHIFT (0x0000000Du)
#define CSL_MCASP_PDIN_AXR13_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR13_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR13_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR12_MASK (0x00001000u)
#define CSL_MCASP_PDIN_AXR12_SHIFT (0x0000000Cu)
#define CSL_MCASP_PDIN_AXR12_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR12_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR12_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR11_MASK (0x00000800u)
#define CSL_MCASP_PDIN_AXR11_SHIFT (0x0000000Bu)
#define CSL_MCASP_PDIN_AXR11_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR11_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR11_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR10_MASK (0x00000400u)
#define CSL_MCASP_PDIN_AXR10_SHIFT (0x0000000Au)
#define CSL_MCASP_PDIN_AXR10_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR10_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR10_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR9_MASK (0x00000200u)
#define CSL_MCASP_PDIN_AXR9_SHIFT (0x00000009u)
#define CSL_MCASP_PDIN_AXR9_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR9_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR9_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR8_MASK (0x00000100u)
#define CSL_MCASP_PDIN_AXR8_SHIFT (0x00000008u)
#define CSL_MCASP_PDIN_AXR8_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR8_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR8_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR7_MASK (0x00000080u)
#define CSL_MCASP_PDIN_AXR7_SHIFT (0x00000007u)
#define CSL_MCASP_PDIN_AXR7_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR7_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR7_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR6_MASK (0x00000040u)
#define CSL_MCASP_PDIN_AXR6_SHIFT (0x00000006u)
#define CSL_MCASP_PDIN_AXR6_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR6_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR6_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR5_MASK (0x00000020u)
#define CSL_MCASP_PDIN_AXR5_SHIFT (0x00000005u)
#define CSL_MCASP_PDIN_AXR5_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR5_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR5_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR4_MASK (0x00000010u)
#define CSL_MCASP_PDIN_AXR4_SHIFT (0x00000004u)
#define CSL_MCASP_PDIN_AXR4_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR4_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR4_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR3_MASK (0x00000008u)
#define CSL_MCASP_PDIN_AXR3_SHIFT (0x00000003u)
#define CSL_MCASP_PDIN_AXR3_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR3_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR3_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR2_MASK (0x00000004u)
#define CSL_MCASP_PDIN_AXR2_SHIFT (0x00000002u)
#define CSL_MCASP_PDIN_AXR2_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR2_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR2_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR1_MASK (0x00000002u)
#define CSL_MCASP_PDIN_AXR1_SHIFT (0x00000001u)
#define CSL_MCASP_PDIN_AXR1_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR1_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR1_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_AXR0_MASK (0x00000001u)
#define CSL_MCASP_PDIN_AXR0_SHIFT (0x00000000u)
#define CSL_MCASP_PDIN_AXR0_RESETVAL (0x00000000u)
#define CSL_MCASP_PDIN_AXR0_LOW (0x00000000u)
#define CSL_MCASP_PDIN_AXR0_HIGH (0x00000001u)

#define CSL_MCASP_PDIN_RESETVAL (0x00000000u)

/* PDSET */

#define CSL_MCASP_PDSET_AFSR_MASK (0x80000000u)
#define CSL_MCASP_PDSET_AFSR_SHIFT (0x0000001Fu)
#define CSL_MCASP_PDSET_AFSR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AFSR_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AFSR_SET (0x00000001u)

#define CSL_MCASP_PDSET_AHCLKR_MASK (0x40000000u)
#define CSL_MCASP_PDSET_AHCLKR_SHIFT (0x0000001Eu)
#define CSL_MCASP_PDSET_AHCLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AHCLKR_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AHCLKR_SET (0x00000001u)

#define CSL_MCASP_PDSET_ACLKR_MASK (0x20000000u)
#define CSL_MCASP_PDSET_ACLKR_SHIFT (0x0000001Du)
#define CSL_MCASP_PDSET_ACLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_ACLKR_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_ACLKR_SET (0x00000001u)

#define CSL_MCASP_PDSET_AFSX_MASK (0x10000000u)
#define CSL_MCASP_PDSET_AFSX_SHIFT (0x0000001Cu)
#define CSL_MCASP_PDSET_AFSX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AFSX_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AFSX_SET (0x00000001u)

#define CSL_MCASP_PDSET_AHCLKX_MASK (0x08000000u)
#define CSL_MCASP_PDSET_AHCLKX_SHIFT (0x0000001Bu)
#define CSL_MCASP_PDSET_AHCLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AHCLKX_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AHCLKX_SET (0x00000001u)

#define CSL_MCASP_PDSET_ACLKX_MASK (0x04000000u)
#define CSL_MCASP_PDSET_ACLKX_SHIFT (0x0000001Au)
#define CSL_MCASP_PDSET_ACLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_ACLKX_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_ACLKX_SET (0x00000001u)

#define CSL_MCASP_PDSET_AMUTE_MASK (0x02000000u)
#define CSL_MCASP_PDSET_AMUTE_SHIFT (0x00000019u)
#define CSL_MCASP_PDSET_AMUTE_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AMUTE_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AMUTE_SET (0x00000001u)


#define CSL_MCASP_PDSET_AXR15_MASK (0x00008000u)
#define CSL_MCASP_PDSET_AXR15_SHIFT (0x0000000Fu)
#define CSL_MCASP_PDSET_AXR15_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR15_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR15_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR14_MASK (0x00004000u)
#define CSL_MCASP_PDSET_AXR14_SHIFT (0x0000000Eu)
#define CSL_MCASP_PDSET_AXR14_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR14_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR14_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR13_MASK (0x00002000u)
#define CSL_MCASP_PDSET_AXR13_SHIFT (0x0000000Du)
#define CSL_MCASP_PDSET_AXR13_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR13_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR13_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR12_MASK (0x00001000u)
#define CSL_MCASP_PDSET_AXR12_SHIFT (0x0000000Cu)
#define CSL_MCASP_PDSET_AXR12_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR12_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR12_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR11_MASK (0x00000800u)
#define CSL_MCASP_PDSET_AXR11_SHIFT (0x0000000Bu)
#define CSL_MCASP_PDSET_AXR11_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR11_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR11_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR10_MASK (0x00000400u)
#define CSL_MCASP_PDSET_AXR10_SHIFT (0x0000000Au)
#define CSL_MCASP_PDSET_AXR10_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR10_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR10_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR9_MASK (0x00000200u)
#define CSL_MCASP_PDSET_AXR9_SHIFT (0x00000009u)
#define CSL_MCASP_PDSET_AXR9_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR9_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR9_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR8_MASK (0x00000100u)
#define CSL_MCASP_PDSET_AXR8_SHIFT (0x00000008u)
#define CSL_MCASP_PDSET_AXR8_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR8_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR8_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR7_MASK (0x00000080u)
#define CSL_MCASP_PDSET_AXR7_SHIFT (0x00000007u)
#define CSL_MCASP_PDSET_AXR7_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR7_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR7_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR6_MASK (0x00000040u)
#define CSL_MCASP_PDSET_AXR6_SHIFT (0x00000006u)
#define CSL_MCASP_PDSET_AXR6_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR6_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR6_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR5_MASK (0x00000020u)
#define CSL_MCASP_PDSET_AXR5_SHIFT (0x00000005u)
#define CSL_MCASP_PDSET_AXR5_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR5_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR5_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR4_MASK (0x00000010u)
#define CSL_MCASP_PDSET_AXR4_SHIFT (0x00000004u)
#define CSL_MCASP_PDSET_AXR4_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR4_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR4_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR3_MASK (0x00000008u)
#define CSL_MCASP_PDSET_AXR3_SHIFT (0x00000003u)
#define CSL_MCASP_PDSET_AXR3_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR3_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR3_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR2_MASK (0x00000004u)
#define CSL_MCASP_PDSET_AXR2_SHIFT (0x00000002u)
#define CSL_MCASP_PDSET_AXR2_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR2_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR2_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR1_MASK (0x00000002u)
#define CSL_MCASP_PDSET_AXR1_SHIFT (0x00000001u)
#define CSL_MCASP_PDSET_AXR1_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR1_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR1_SET (0x00000001u)

#define CSL_MCASP_PDSET_AXR0_MASK (0x00000001u)
#define CSL_MCASP_PDSET_AXR0_SHIFT (0x00000000u)
#define CSL_MCASP_PDSET_AXR0_RESETVAL (0x00000000u)
#define CSL_MCASP_PDSET_AXR0_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDSET_AXR0_SET (0x00000001u)

#define CSL_MCASP_PDSET_RESETVAL (0x00000000u)

/* PDCLR */

#define CSL_MCASP_PDCLR_AFSR_MASK (0x80000000u)
#define CSL_MCASP_PDCLR_AFSR_SHIFT (0x0000001Fu)
#define CSL_MCASP_PDCLR_AFSR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AFSR_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AFSR_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AHCLKR_MASK (0x40000000u)
#define CSL_MCASP_PDCLR_AHCLKR_SHIFT (0x0000001Eu)
#define CSL_MCASP_PDCLR_AHCLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AHCLKR_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AHCLKR_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_ACLKR_MASK (0x20000000u)
#define CSL_MCASP_PDCLR_ACLKR_SHIFT (0x0000001Du)
#define CSL_MCASP_PDCLR_ACLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_ACLKR_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_ACLKR_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AFSX_MASK (0x10000000u)
#define CSL_MCASP_PDCLR_AFSX_SHIFT (0x0000001Cu)
#define CSL_MCASP_PDCLR_AFSX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AFSX_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AFSX_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AHCLKX_MASK (0x08000000u)
#define CSL_MCASP_PDCLR_AHCLKX_SHIFT (0x0000001Bu)
#define CSL_MCASP_PDCLR_AHCLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AHCLKX_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AHCLKX_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_ACLKX_MASK (0x04000000u)
#define CSL_MCASP_PDCLR_ACLKX_SHIFT (0x0000001Au)
#define CSL_MCASP_PDCLR_ACLKX_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_ACLKX_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_ACLKX_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AMUTE_MASK (0x02000000u)
#define CSL_MCASP_PDCLR_AMUTE_SHIFT (0x00000019u)
#define CSL_MCASP_PDCLR_AMUTE_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AMUTE_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AMUTE_CLEAR (0x00000001u)


#define CSL_MCASP_PDCLR_AXR15_MASK (0x00008000u)
#define CSL_MCASP_PDCLR_AXR15_SHIFT (0x0000000Fu)
#define CSL_MCASP_PDCLR_AXR15_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR15_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR15_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR14_MASK (0x00004000u)
#define CSL_MCASP_PDCLR_AXR14_SHIFT (0x0000000Eu)
#define CSL_MCASP_PDCLR_AXR14_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR14_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR14_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR13_MASK (0x00002000u)
#define CSL_MCASP_PDCLR_AXR13_SHIFT (0x0000000Du)
#define CSL_MCASP_PDCLR_AXR13_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR13_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR13_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR12_MASK (0x00001000u)
#define CSL_MCASP_PDCLR_AXR12_SHIFT (0x0000000Cu)
#define CSL_MCASP_PDCLR_AXR12_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR12_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR12_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR11_MASK (0x00000800u)
#define CSL_MCASP_PDCLR_AXR11_SHIFT (0x0000000Bu)
#define CSL_MCASP_PDCLR_AXR11_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR11_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR11_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR10_MASK (0x00000400u)
#define CSL_MCASP_PDCLR_AXR10_SHIFT (0x0000000Au)
#define CSL_MCASP_PDCLR_AXR10_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR10_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR10_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR9_MASK (0x00000200u)
#define CSL_MCASP_PDCLR_AXR9_SHIFT (0x00000009u)
#define CSL_MCASP_PDCLR_AXR9_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR9_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR9_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR8_MASK (0x00000100u)
#define CSL_MCASP_PDCLR_AXR8_SHIFT (0x00000008u)
#define CSL_MCASP_PDCLR_AXR8_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR8_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR8_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR7_MASK (0x00000080u)
#define CSL_MCASP_PDCLR_AXR7_SHIFT (0x00000007u)
#define CSL_MCASP_PDCLR_AXR7_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR7_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR7_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR6_MASK (0x00000040u)
#define CSL_MCASP_PDCLR_AXR6_SHIFT (0x00000006u)
#define CSL_MCASP_PDCLR_AXR6_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR6_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR6_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR5_MASK (0x00000020u)
#define CSL_MCASP_PDCLR_AXR5_SHIFT (0x00000005u)
#define CSL_MCASP_PDCLR_AXR5_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR5_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR5_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR4_MASK (0x00000010u)
#define CSL_MCASP_PDCLR_AXR4_SHIFT (0x00000004u)
#define CSL_MCASP_PDCLR_AXR4_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR4_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR4_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR3_MASK (0x00000008u)
#define CSL_MCASP_PDCLR_AXR3_SHIFT (0x00000003u)
#define CSL_MCASP_PDCLR_AXR3_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR3_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR3_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR2_MASK (0x00000004u)
#define CSL_MCASP_PDCLR_AXR2_SHIFT (0x00000002u)
#define CSL_MCASP_PDCLR_AXR2_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR2_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR2_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR1_MASK (0x00000002u)
#define CSL_MCASP_PDCLR_AXR1_SHIFT (0x00000001u)
#define CSL_MCASP_PDCLR_AXR1_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR1_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR1_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_AXR0_MASK (0x00000001u)
#define CSL_MCASP_PDCLR_AXR0_SHIFT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR0_RESETVAL (0x00000000u)
#define CSL_MCASP_PDCLR_AXR0_NOEFFECT (0x00000000u)
#define CSL_MCASP_PDCLR_AXR0_CLEAR (0x00000001u)

#define CSL_MCASP_PDCLR_RESETVAL (0x00000000u)
/* GBLCTL */


#define CSL_MCASP_GBLCTL_XFRST_MASK (0x00001000u)
#define CSL_MCASP_GBLCTL_XFRST_SHIFT (0x0000000Cu)
#define CSL_MCASP_GBLCTL_XFRST_RESETVAL (0x00000000u)
/*----XFRST Tokens----*/
#define CSL_MCASP_GBLCTL_XFRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_XFRST_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_XSMRST_MASK (0x00000800u)
#define CSL_MCASP_GBLCTL_XSMRST_SHIFT (0x0000000Bu)
#define CSL_MCASP_GBLCTL_XSMRST_RESETVAL (0x00000000u)
/*----XSMRST Tokens----*/
#define CSL_MCASP_GBLCTL_XSMRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_XSMRST_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_XSRCLR_MASK (0x00000400u)
#define CSL_MCASP_GBLCTL_XSRCLR_SHIFT (0x0000000Au)
#define CSL_MCASP_GBLCTL_XSRCLR_RESETVAL (0x00000000u)
/*----XSRCLR Tokens----*/
#define CSL_MCASP_GBLCTL_XSRCLR_CLEAR (0x00000000u)
#define CSL_MCASP_GBLCTL_XSRCLR_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_XHCLKRST_MASK (0x00000200u)
#define CSL_MCASP_GBLCTL_XHCLKRST_SHIFT (0x00000009u)
#define CSL_MCASP_GBLCTL_XHCLKRST_RESETVAL (0x00000000u)
/*----XHCLKRST Tokens----*/
#define CSL_MCASP_GBLCTL_XHCLKRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_XHCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_XCLKRST_MASK (0x00000100u)
#define CSL_MCASP_GBLCTL_XCLKRST_SHIFT (0x00000008u)
#define CSL_MCASP_GBLCTL_XCLKRST_RESETVAL (0x00000000u)
/*----XCLKRST Tokens----*/
#define CSL_MCASP_GBLCTL_XCLKRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_XCLKRST_ACTIVE (0x00000001u)


#define CSL_MCASP_GBLCTL_RFRST_MASK (0x00000010u)
#define CSL_MCASP_GBLCTL_RFRST_SHIFT (0x00000004u)
#define CSL_MCASP_GBLCTL_RFRST_RESETVAL (0x00000000u)
/*----RFRST Tokens----*/
#define CSL_MCASP_GBLCTL_RFRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_RFRST_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_RSMRST_MASK (0x00000008u)
#define CSL_MCASP_GBLCTL_RSMRST_SHIFT (0x00000003u)
#define CSL_MCASP_GBLCTL_RSMRST_RESETVAL (0x00000000u)
/*----RSMRST Tokens----*/
#define CSL_MCASP_GBLCTL_RSMRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_RSMRST_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_RSRCLR_MASK (0x00000004u)
#define CSL_MCASP_GBLCTL_RSRCLR_SHIFT (0x00000002u)
#define CSL_MCASP_GBLCTL_RSRCLR_RESETVAL (0x00000000u)
/*----RSRCLR Tokens----*/
#define CSL_MCASP_GBLCTL_RSRCLR_CLEAR (0x00000000u)
#define CSL_MCASP_GBLCTL_RSRCLR_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_RHCLKRST_MASK (0x00000002u)
#define CSL_MCASP_GBLCTL_RHCLKRST_SHIFT (0x00000001u)
#define CSL_MCASP_GBLCTL_RHCLKRST_RESETVAL (0x00000000u)
/*----RHCLKRST Tokens----*/
#define CSL_MCASP_GBLCTL_RHCLKRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_RHCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_RCLKRST_MASK (0x00000001u)
#define CSL_MCASP_GBLCTL_RCLKRST_SHIFT (0x00000000u)
#define CSL_MCASP_GBLCTL_RCLKRST_RESETVAL (0x00000000u)
/*----RCLKRST Tokens----*/
#define CSL_MCASP_GBLCTL_RCLKRST_RESET (0x00000000u)
#define CSL_MCASP_GBLCTL_RCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_GBLCTL_RESETVAL (0x00000000u)

/* AMUTE */


#define CSL_MCASP_AMUTE_XDMAERR_MASK (0x00001000u)
#define CSL_MCASP_AMUTE_XDMAERR_SHIFT (0x0000000Cu)
#define CSL_MCASP_AMUTE_XDMAERR_RESETVAL (0x00000000u)
/*----XDMAERR Tokens----*/
#define CSL_MCASP_AMUTE_XDMAERR_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_XDMAERR_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_RDMAERR_MASK (0x00000800u)
#define CSL_MCASP_AMUTE_RDMAERR_SHIFT (0x0000000Bu)
#define CSL_MCASP_AMUTE_RDMAERR_RESETVAL (0x00000000u)
/*----RDMAERR Tokens----*/
#define CSL_MCASP_AMUTE_RDMAERR_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_RDMAERR_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_XCKFAIL_MASK (0x00000400u)
#define CSL_MCASP_AMUTE_XCKFAIL_SHIFT (0x0000000Au)
#define CSL_MCASP_AMUTE_XCKFAIL_RESETVAL (0x00000000u)
/*----XCKFAIL Tokens----*/
#define CSL_MCASP_AMUTE_XCKFAIL_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_XCKFAIL_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_RCKFAIL_MASK (0x00000200u)
#define CSL_MCASP_AMUTE_RCKFAIL_SHIFT (0x00000009u)
#define CSL_MCASP_AMUTE_RCKFAIL_RESETVAL (0x00000000u)
/*----RCKFAIL Tokens----*/
#define CSL_MCASP_AMUTE_RCKFAIL_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_RCKFAIL_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_XSYNCERR_MASK (0x00000100u)
#define CSL_MCASP_AMUTE_XSYNCERR_SHIFT (0x00000008u)
#define CSL_MCASP_AMUTE_XSYNCERR_RESETVAL (0x00000000u)
/*----XSYNCERR Tokens----*/
#define CSL_MCASP_AMUTE_XSYNCERR_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_XSYNCERR_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_RSYNCERR_MASK (0x00000080u)
#define CSL_MCASP_AMUTE_RSYNCERR_SHIFT (0x00000007u)
#define CSL_MCASP_AMUTE_RSYNCERR_RESETVAL (0x00000000u)
/*----RSYNCERR Tokens----*/
#define CSL_MCASP_AMUTE_RSYNCERR_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_RSYNCERR_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_XUNDRN_MASK (0x00000040u)
#define CSL_MCASP_AMUTE_XUNDRN_SHIFT (0x00000006u)
#define CSL_MCASP_AMUTE_XUNDRN_RESETVAL (0x00000000u)
/*----XUNDRN Tokens----*/
#define CSL_MCASP_AMUTE_XUNDRN_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_XUNDRN_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_ROVRN_MASK (0x00000020u)
#define CSL_MCASP_AMUTE_ROVRN_SHIFT (0x00000005u)
#define CSL_MCASP_AMUTE_ROVRN_RESETVAL (0x00000000u)
/*----ROVRN Tokens----*/
#define CSL_MCASP_AMUTE_ROVRN_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_ROVRN_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_INSTAT_MASK (0x00000010u)
#define CSL_MCASP_AMUTE_INSTAT_SHIFT (0x00000004u)
#define CSL_MCASP_AMUTE_INSTAT_RESETVAL (0x00000000u)
/*----INSTAT Tokens----*/
#define CSL_MCASP_AMUTE_INSTAT_INACTIVE (0x00000000u)
#define CSL_MCASP_AMUTE_INSTAT_ACTIVE (0x00000001u)

#define CSL_MCASP_AMUTE_INEN_MASK (0x00000008u)
#define CSL_MCASP_AMUTE_INEN_SHIFT (0x00000003u)
#define CSL_MCASP_AMUTE_INEN_RESETVAL (0x00000000u)
/*----INEN Tokens----*/
#define CSL_MCASP_AMUTE_INEN_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_INEN_ENABLE (0x00000001u)

#define CSL_MCASP_AMUTE_INPOL_MASK (0x00000004u)
#define CSL_MCASP_AMUTE_INPOL_SHIFT (0x00000002u)
#define CSL_MCASP_AMUTE_INPOL_RESETVAL (0x00000000u)
/*----INPOL Tokens----*/
#define CSL_MCASP_AMUTE_INPOL_ACTHIGH (0x00000000u)
#define CSL_MCASP_AMUTE_INPOL_ACTLOW (0x00000001u)

#define CSL_MCASP_AMUTE_MUTEN_MASK (0x00000003u)
#define CSL_MCASP_AMUTE_MUTEN_SHIFT (0x00000000u)
#define CSL_MCASP_AMUTE_MUTEN_RESETVAL (0x00000000u)
/*----MUTEN Tokens----*/
#define CSL_MCASP_AMUTE_MUTEN_DISABLE (0x00000000u)
#define CSL_MCASP_AMUTE_MUTEN_ERRHIGH (0x00000001u)
#define CSL_MCASP_AMUTE_MUTEN_ERRLOW (0x00000002u)
#define CSL_MCASP_AMUTE_MUTEN_RESV (0x00000003u)

#define CSL_MCASP_AMUTE_RESETVAL (0x00000000u)

/* DLBCTL */


#define CSL_MCASP_DLBCTL_IOLBEN_MASK (0x00000010u)
#define CSL_MCASP_DLBCTL_IOLBEN_SHIFT (0x00000004u)
#define CSL_MCASP_DLBCTL_IOLBEN_RESETVAL (0x00000000u)
#define CSL_MCASP_DLBCTL_IOLBEN_DISABLE (0x00000000u)
#define CSL_MCASP_DLBCTL_IOLBEN_ENABLE (0x00000001u)
#define CSL_MCASP_DLBCTL_MODE_MASK (0x0000000Cu)
#define CSL_MCASP_DLBCTL_MODE_SHIFT (0x00000002u)
#define CSL_MCASP_DLBCTL_MODE_RESETVAL (0x00000000u)
/*----MODE Tokens----*/
#define CSL_MCASP_DLBCTL_MODE_RESERVED (0x00000000u)
#define CSL_MCASP_DLBCTL_MODE_XMTCLK (0x00000001u)
#define CSL_MCASP_DLBCTL_MODE_RESERVED1 (0x00000002u)
#define CSL_MCASP_DLBCTL_MODE_RESERVED2 (0x00000003u)

#define CSL_MCASP_DLBCTL_ORD_MASK (0x00000002u)
#define CSL_MCASP_DLBCTL_ORD_SHIFT (0x00000001u)
#define CSL_MCASP_DLBCTL_ORD_RESETVAL (0x00000000u)
/*----ORD Tokens----*/
#define CSL_MCASP_DLBCTL_ORD_XMTODD (0x00000000u)
#define CSL_MCASP_DLBCTL_ORD_XMTEVEN (0x00000001u)

#define CSL_MCASP_DLBCTL_DLBEN_MASK (0x00000001u)
#define CSL_MCASP_DLBCTL_DLBEN_SHIFT (0x00000000u)
#define CSL_MCASP_DLBCTL_DLBEN_RESETVAL (0x00000000u)
/*----DLBEN Tokens----*/
#define CSL_MCASP_DLBCTL_DLBEN_DISABLE (0x00000000u)
#define CSL_MCASP_DLBCTL_DLBEN_ENABLE (0x00000001u)

#define CSL_MCASP_DLBCTL_RESETVAL (0x00000000u)

/* DITCTL */


#define CSL_MCASP_DITCTL_VB_MASK (0x00000008u)
#define CSL_MCASP_DITCTL_VB_SHIFT (0x00000003u)
#define CSL_MCASP_DITCTL_VB_RESETVAL (0x00000000u)
/*----VB Tokens----*/
#define CSL_MCASP_DITCTL_VB_ZERO (0x00000000u)
#define CSL_MCASP_DITCTL_VB_ONE (0x00000001u)

#define CSL_MCASP_DITCTL_VA_MASK (0x00000004u)
#define CSL_MCASP_DITCTL_VA_SHIFT (0x00000002u)
#define CSL_MCASP_DITCTL_VA_RESETVAL (0x00000000u)
/*----VA Tokens----*/
#define CSL_MCASP_DITCTL_VA_ZERO (0x00000000u)
#define CSL_MCASP_DITCTL_VA_ONE (0x00000001u)


#define CSL_MCASP_DITCTL_DITEN_MASK (0x00000001u)
#define CSL_MCASP_DITCTL_DITEN_SHIFT (0x00000000u)
#define CSL_MCASP_DITCTL_DITEN_RESETVAL (0x00000000u)
/*----DITEN Tokens----*/
#define CSL_MCASP_DITCTL_DITEN_DISABLE (0x00000000u)
#define CSL_MCASP_DITCTL_DITEN_ENABLE (0x00000001u)

#define CSL_MCASP_DITCTL_RESETVAL (0x00000000u)

/* RGBLCTL */


#define CSL_MCASP_RGBLCTL_XFRST_MASK (0x00001000u)
#define CSL_MCASP_RGBLCTL_XFRST_SHIFT (0x0000000Cu)
#define CSL_MCASP_RGBLCTL_XFRST_RESETVAL (0x00000000u)
/*----XFRST Tokens----*/
#define CSL_MCASP_RGBLCTL_XFRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_XFRST_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_XSMRST_MASK (0x00000800u)
#define CSL_MCASP_RGBLCTL_XSMRST_SHIFT (0x0000000Bu)
#define CSL_MCASP_RGBLCTL_XSMRST_RESETVAL (0x00000000u)
/*----XSMRST Tokens----*/
#define CSL_MCASP_RGBLCTL_XSMRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_XSMRST_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_XSRCLR_MASK (0x00000400u)
#define CSL_MCASP_RGBLCTL_XSRCLR_SHIFT (0x0000000Au)
#define CSL_MCASP_RGBLCTL_XSRCLR_RESETVAL (0x00000000u)
/*----XSRCLR Tokens----*/
#define CSL_MCASP_RGBLCTL_XSRCLR_CLEAR (0x00000000u)
#define CSL_MCASP_RGBLCTL_XSRCLR_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_XHCLKRST_MASK (0x00000200u)
#define CSL_MCASP_RGBLCTL_XHCLKRST_SHIFT (0x00000009u)
#define CSL_MCASP_RGBLCTL_XHCLKRST_RESETVAL (0x00000000u)
/*----XHCLKRST Tokens----*/
#define CSL_MCASP_RGBLCTL_XHCLKRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_XHCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_XCLKRST_MASK (0x00000100u)
#define CSL_MCASP_RGBLCTL_XCLKRST_SHIFT (0x00000008u)
#define CSL_MCASP_RGBLCTL_XCLKRST_RESETVAL (0x00000000u)
/*----XCLKRST Tokens----*/
#define CSL_MCASP_RGBLCTL_XCLKRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_XCLKRST_ACTIVE (0x00000001u)


#define CSL_MCASP_RGBLCTL_RFRST_MASK (0x00000010u)
#define CSL_MCASP_RGBLCTL_RFRST_SHIFT (0x00000004u)
#define CSL_MCASP_RGBLCTL_RFRST_RESETVAL (0x00000000u)
/*----RFRST Tokens----*/
#define CSL_MCASP_RGBLCTL_RFRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_RFRST_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_RSMRST_MASK (0x00000008u)
#define CSL_MCASP_RGBLCTL_RSMRST_SHIFT (0x00000003u)
#define CSL_MCASP_RGBLCTL_RSMRST_RESETVAL (0x00000000u)
/*----RSMRST Tokens----*/
#define CSL_MCASP_RGBLCTL_RSMRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_RSMRST_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_RSRCLR_MASK (0x00000004u)
#define CSL_MCASP_RGBLCTL_RSRCLR_SHIFT (0x00000002u)
#define CSL_MCASP_RGBLCTL_RSRCLR_RESETVAL (0x00000000u)
/*----RSRCLR Tokens----*/
#define CSL_MCASP_RGBLCTL_RSRCLR_CLEAR (0x00000000u)
#define CSL_MCASP_RGBLCTL_RSRCLR_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_RHCLKRST_MASK (0x00000002u)
#define CSL_MCASP_RGBLCTL_RHCLKRST_SHIFT (0x00000001u)
#define CSL_MCASP_RGBLCTL_RHCLKRST_RESETVAL (0x00000000u)
/*----RHCLKRST Tokens----*/
#define CSL_MCASP_RGBLCTL_RHCLKRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_RHCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_RCLKRST_MASK (0x00000001u)
#define CSL_MCASP_RGBLCTL_RCLKRST_SHIFT (0x00000000u)
#define CSL_MCASP_RGBLCTL_RCLKRST_RESETVAL (0x00000000u)
/*----RCLKRST Tokens----*/
#define CSL_MCASP_RGBLCTL_RCLKRST_RESET (0x00000000u)
#define CSL_MCASP_RGBLCTL_RCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_RGBLCTL_RESETVAL (0x00000000u)

/* RMASK */

#define CSL_MCASP_RMASK_RMASK31_MASK (0x80000000u)
#define CSL_MCASP_RMASK_RMASK31_SHIFT (0x0000001Fu)
#define CSL_MCASP_RMASK_RMASK31_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK31_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK31_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK30_MASK (0x40000000u)
#define CSL_MCASP_RMASK_RMASK30_SHIFT (0x0000001Eu)
#define CSL_MCASP_RMASK_RMASK30_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK30_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK30_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK29_MASK (0x20000000u)
#define CSL_MCASP_RMASK_RMASK29_SHIFT (0x0000001Du)
#define CSL_MCASP_RMASK_RMASK29_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK29_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK29_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK28_MASK (0x10000000u)
#define CSL_MCASP_RMASK_RMASK28_SHIFT (0x0000001Cu)
#define CSL_MCASP_RMASK_RMASK28_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK28_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK28_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK27_MASK (0x08000000u)
#define CSL_MCASP_RMASK_RMASK27_SHIFT (0x0000001Bu)
#define CSL_MCASP_RMASK_RMASK27_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK27_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK27_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK26_MASK (0x04000000u)
#define CSL_MCASP_RMASK_RMASK26_SHIFT (0x0000001Au)
#define CSL_MCASP_RMASK_RMASK26_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK26_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK26_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK25_MASK (0x02000000u)
#define CSL_MCASP_RMASK_RMASK25_SHIFT (0x00000019u)
#define CSL_MCASP_RMASK_RMASK25_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK25_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK25_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK24_MASK (0x01000000u)
#define CSL_MCASP_RMASK_RMASK24_SHIFT (0x00000018u)
#define CSL_MCASP_RMASK_RMASK24_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK24_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK24_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK23_MASK (0x00800000u)
#define CSL_MCASP_RMASK_RMASK23_SHIFT (0x00000017u)
#define CSL_MCASP_RMASK_RMASK23_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK23_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK23_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK22_MASK (0x00400000u)
#define CSL_MCASP_RMASK_RMASK22_SHIFT (0x00000016u)
#define CSL_MCASP_RMASK_RMASK22_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK22_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK22_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK21_MASK (0x00200000u)
#define CSL_MCASP_RMASK_RMASK21_SHIFT (0x00000015u)
#define CSL_MCASP_RMASK_RMASK21_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK21_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK21_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK20_MASK (0x00100000u)
#define CSL_MCASP_RMASK_RMASK20_SHIFT (0x00000014u)
#define CSL_MCASP_RMASK_RMASK20_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK20_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK20_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK19_MASK (0x00080000u)
#define CSL_MCASP_RMASK_RMASK19_SHIFT (0x00000013u)
#define CSL_MCASP_RMASK_RMASK19_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK19_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK19_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK18_MASK (0x00040000u)
#define CSL_MCASP_RMASK_RMASK18_SHIFT (0x00000012u)
#define CSL_MCASP_RMASK_RMASK18_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK18_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK18_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK17_MASK (0x00020000u)
#define CSL_MCASP_RMASK_RMASK17_SHIFT (0x00000011u)
#define CSL_MCASP_RMASK_RMASK17_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK17_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK17_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK16_MASK (0x00010000u)
#define CSL_MCASP_RMASK_RMASK16_SHIFT (0x00000010u)
#define CSL_MCASP_RMASK_RMASK16_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK16_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK16_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK15_MASK (0x00008000u)
#define CSL_MCASP_RMASK_RMASK15_SHIFT (0x0000000Fu)
#define CSL_MCASP_RMASK_RMASK15_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK15_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK15_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK14_MASK (0x00004000u)
#define CSL_MCASP_RMASK_RMASK14_SHIFT (0x0000000Eu)
#define CSL_MCASP_RMASK_RMASK14_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK14_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK14_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK13_MASK (0x00002000u)
#define CSL_MCASP_RMASK_RMASK13_SHIFT (0x0000000Du)
#define CSL_MCASP_RMASK_RMASK13_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK13_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK13_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK12_MASK (0x00001000u)
#define CSL_MCASP_RMASK_RMASK12_SHIFT (0x0000000Cu)
#define CSL_MCASP_RMASK_RMASK12_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK12_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK12_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK11_MASK (0x00000800u)
#define CSL_MCASP_RMASK_RMASK11_SHIFT (0x0000000Bu)
#define CSL_MCASP_RMASK_RMASK11_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK11_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK11_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK10_MASK (0x00000400u)
#define CSL_MCASP_RMASK_RMASK10_SHIFT (0x0000000Au)
#define CSL_MCASP_RMASK_RMASK10_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK10_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK10_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK9_MASK (0x00000200u)
#define CSL_MCASP_RMASK_RMASK9_SHIFT (0x00000009u)
#define CSL_MCASP_RMASK_RMASK9_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK9_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK9_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK8_MASK (0x00000100u)
#define CSL_MCASP_RMASK_RMASK8_SHIFT (0x00000008u)
#define CSL_MCASP_RMASK_RMASK8_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK8_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK8_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK7_MASK (0x00000080u)
#define CSL_MCASP_RMASK_RMASK7_SHIFT (0x00000007u)
#define CSL_MCASP_RMASK_RMASK7_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK7_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK7_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK6_MASK (0x00000040u)
#define CSL_MCASP_RMASK_RMASK6_SHIFT (0x00000006u)
#define CSL_MCASP_RMASK_RMASK6_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK6_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK6_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK5_MASK (0x00000020u)
#define CSL_MCASP_RMASK_RMASK5_SHIFT (0x00000005u)
#define CSL_MCASP_RMASK_RMASK5_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK5_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK5_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK4_MASK (0x00000010u)
#define CSL_MCASP_RMASK_RMASK4_SHIFT (0x00000004u)
#define CSL_MCASP_RMASK_RMASK4_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK4_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK4_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK3_MASK (0x00000008u)
#define CSL_MCASP_RMASK_RMASK3_SHIFT (0x00000003u)
#define CSL_MCASP_RMASK_RMASK3_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK3_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK3_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK2_MASK (0x00000004u)
#define CSL_MCASP_RMASK_RMASK2_SHIFT (0x00000002u)
#define CSL_MCASP_RMASK_RMASK2_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK2_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK2_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK1_MASK (0x00000002u)
#define CSL_MCASP_RMASK_RMASK1_SHIFT (0x00000001u)
#define CSL_MCASP_RMASK_RMASK1_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK1_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK1_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RMASK0_MASK (0x00000001u)
#define CSL_MCASP_RMASK_RMASK0_SHIFT (0x00000000u)
#define CSL_MCASP_RMASK_RMASK0_RESETVAL (0x00000000u)
#define CSL_MCASP_RMASK_RMASK0_USEMASK (0x00000000u)
#define CSL_MCASP_RMASK_RMASK0_NOMASK (0x00000001u)

#define CSL_MCASP_RMASK_RESETVAL (0x00000000u)

/* RFMT */


#define CSL_MCASP_RFMT_RDATDLY_MASK (0x00030000u)
#define CSL_MCASP_RFMT_RDATDLY_SHIFT (0x00000010u)
#define CSL_MCASP_RFMT_RDATDLY_RESETVAL (0x00000000u)
/*----RDATDLY Tokens----*/
#define CSL_MCASP_RFMT_RDATDLY_0BIT (0x00000000u)
#define CSL_MCASP_RFMT_RDATDLY_1BIT (0x00000001u)
#define CSL_MCASP_RFMT_RDATDLY_2BIT (0x00000002u)
#define CSL_MCASP_RFMT_RDATDLY_RESV (0x00000003u)

#define CSL_MCASP_RFMT_RRVRS_MASK (0x00008000u)
#define CSL_MCASP_RFMT_RRVRS_SHIFT (0x0000000Fu)
#define CSL_MCASP_RFMT_RRVRS_RESETVAL (0x00000000u)
/*----RRVRS Tokens----*/
#define CSL_MCASP_RFMT_RRVRS_LSBFIRST (0x00000000u)
#define CSL_MCASP_RFMT_RRVRS_MSBFIRST (0x00000001u)

#define CSL_MCASP_RFMT_RPAD_MASK (0x00006000u)
#define CSL_MCASP_RFMT_RPAD_SHIFT (0x0000000Du)
#define CSL_MCASP_RFMT_RPAD_RESETVAL (0x00000000u)
/*----RPAD Tokens----*/
#define CSL_MCASP_RFMT_RPAD_ZERO (0x00000000u)
#define CSL_MCASP_RFMT_RPAD_ONE (0x00000001u)
#define CSL_MCASP_RFMT_RPAD_RPBIT (0x00000002u)
#define CSL_MCASP_RFMT_RPAD_RESV (0x00000003u)

#define CSL_MCASP_RFMT_RPBIT_MASK (0x00001F00u)
#define CSL_MCASP_RFMT_RPBIT_SHIFT (0x00000008u)
#define CSL_MCASP_RFMT_RPBIT_RESETVAL (0x00000000u)

#define CSL_MCASP_RFMT_RSSZ_MASK (0x000000F0u)
#define CSL_MCASP_RFMT_RSSZ_SHIFT (0x00000004u)
#define CSL_MCASP_RFMT_RSSZ_RESETVAL (0x00000000u)
/*----RSSZ Tokens----*/
#define CSL_MCASP_RFMT_RSSZ_RSV (0x00000000u)
#define CSL_MCASP_RFMT_RSSZ_RSV1 (0x00000001u)
#define CSL_MCASP_RFMT_RSSZ_RSV2 (0x00000002u)
#define CSL_MCASP_RFMT_RSSZ_8BITS (0x00000003u)
#define CSL_MCASP_RFMT_RSSZ_RSV3 (0x00000004u)
#define CSL_MCASP_RFMT_RSSZ_12BITS (0x00000005u)
#define CSL_MCASP_RFMT_RSSZ_RSV4 (0x00000006u)
#define CSL_MCASP_RFMT_RSSZ_16BITS (0x00000007u)
#define CSL_MCASP_RFMT_RSSZ_RSV5 (0x00000008u)
#define CSL_MCASP_RFMT_RSSZ_20BITS (0x00000009u)
#define CSL_MCASP_RFMT_RSSZ_RSV6 (0x0000000Au)
#define CSL_MCASP_RFMT_RSSZ_24BITS (0x0000000Bu)
#define CSL_MCASP_RFMT_RSSZ_RSV7 (0x0000000Cu)
#define CSL_MCASP_RFMT_RSSZ_28BITS (0x0000000Du)
#define CSL_MCASP_RFMT_RSSZ_RSV8 (0x0000000Eu)
#define CSL_MCASP_RFMT_RSSZ_32BITS (0x0000000Fu)

#define CSL_MCASP_RFMT_RBUSEL_MASK (0x00000008u)
#define CSL_MCASP_RFMT_RBUSEL_SHIFT (0x00000003u)
#define CSL_MCASP_RFMT_RBUSEL_RESETVAL (0x00000000u)
/*----RBUSEL Tokens----*/
#define CSL_MCASP_RFMT_RBUSEL_VBUSP (0x00000000u)
#define CSL_MCASP_RFMT_RBUSEL_VBUS (0x00000001u)

#define CSL_MCASP_RFMT_RROT_MASK (0x00000007u)
#define CSL_MCASP_RFMT_RROT_SHIFT (0x00000000u)
#define CSL_MCASP_RFMT_RROT_RESETVAL (0x00000000u)
/*----RROT Tokens----*/
#define CSL_MCASP_RFMT_RROT_NONE (0x00000000u)
#define CSL_MCASP_RFMT_RROT_4BITS (0x00000001u)
#define CSL_MCASP_RFMT_RROT_8BITS (0x00000002u)
#define CSL_MCASP_RFMT_RROT_12BITS (0x00000003u)
#define CSL_MCASP_RFMT_RROT_16BITS (0x00000004u)
#define CSL_MCASP_RFMT_RROT_20BITS (0x00000005u)
#define CSL_MCASP_RFMT_RROT_24BITS (0x00000006u)
#define CSL_MCASP_RFMT_RROT_28BITS (0x00000007u)

#define CSL_MCASP_RFMT_RESETVAL (0x00000000u)

/* AFSRCTL */


#define CSL_MCASP_AFSRCTL_RMOD_MASK (0x0000FF80u)
#define CSL_MCASP_AFSRCTL_RMOD_SHIFT (0x00000007u)
#define CSL_MCASP_AFSRCTL_RMOD_RESETVAL (0x00000000u)
/*----RMOD Tokens----*/
#define CSL_MCASP_AFSRCTL_RMOD_BURST (0x00000000u)
#define CSL_MCASP_AFSRCTL_RMOD_I2S (0x00000002u)


#define CSL_MCASP_AFSRCTL_FRWID_MASK (0x00000010u)
#define CSL_MCASP_AFSRCTL_FRWID_SHIFT (0x00000004u)
#define CSL_MCASP_AFSRCTL_FRWID_RESETVAL (0x00000000u)
/*----FRWID Tokens----*/
#define CSL_MCASP_AFSRCTL_FRWID_BIT (0x00000000u)
#define CSL_MCASP_AFSRCTL_FRWID_WORD (0x00000001u)


#define CSL_MCASP_AFSRCTL_FSRM_MASK (0x00000002u)
#define CSL_MCASP_AFSRCTL_FSRM_SHIFT (0x00000001u)
#define CSL_MCASP_AFSRCTL_FSRM_RESETVAL (0x00000000u)
/*----FSRM Tokens----*/
#define CSL_MCASP_AFSRCTL_FSRM_EXTERNAL (0x00000000u)
#define CSL_MCASP_AFSRCTL_FSRM_INTERNAL (0x00000001u)

#define CSL_MCASP_AFSRCTL_FSRP_MASK (0x00000001u)
#define CSL_MCASP_AFSRCTL_FSRP_SHIFT (0x00000000u)
#define CSL_MCASP_AFSRCTL_FSRP_RESETVAL (0x00000000u)
/*----FSRP Tokens----*/
#define CSL_MCASP_AFSRCTL_FSRP_RISINGEDGE (0x00000000u)
#define CSL_MCASP_AFSRCTL_FSRP_FALLINGEDGE (0x00000001u)

#define CSL_MCASP_AFSRCTL_RESETVAL (0x00000000u)

/* ACLKRCTL */


#define CSL_MCASP_ACLKRCTL_CLKRP_MASK (0x00000080u)
#define CSL_MCASP_ACLKRCTL_CLKRP_SHIFT (0x00000007u)
#define CSL_MCASP_ACLKRCTL_CLKRP_RESETVAL (0x00000000u)
/*----CLKRP Tokens----*/
#define CSL_MCASP_ACLKRCTL_CLKRP_FALLINGEDGE (0x00000000u)
#define CSL_MCASP_ACLKRCTL_CLKRP_RISINGEDGE (0x00000001u)


#define CSL_MCASP_ACLKRCTL_CLKRM_MASK (0x00000020u)
#define CSL_MCASP_ACLKRCTL_CLKRM_SHIFT (0x00000005u)
#define CSL_MCASP_ACLKRCTL_CLKRM_RESETVAL (0x00000001u)
/*----CLKRM Tokens----*/
#define CSL_MCASP_ACLKRCTL_CLKRM_EXTERNAL (0x00000000u)
#define CSL_MCASP_ACLKRCTL_CLKRM_INTERNAL (0x00000001u)

#define CSL_MCASP_ACLKRCTL_CLKRDIV_MASK (0x0000001Fu)
#define CSL_MCASP_ACLKRCTL_CLKRDIV_SHIFT (0x00000000u)
#define CSL_MCASP_ACLKRCTL_CLKRDIV_RESETVAL (0x00000000u)

#define CSL_MCASP_ACLKRCTL_RESETVAL (0x00000020u)

/* AHCLKRCTL */


#define CSL_MCASP_AHCLKRCTL_HCLKRM_MASK (0x00008000u)
#define CSL_MCASP_AHCLKRCTL_HCLKRM_SHIFT (0x0000000Fu)
#define CSL_MCASP_AHCLKRCTL_HCLKRM_RESETVAL (0x00000001u)
/*----HCLKRM Tokens----*/
#define CSL_MCASP_AHCLKRCTL_HCLKRM_EXTERNAL (0x00000000u)
#define CSL_MCASP_AHCLKRCTL_HCLKRM_INTERNAL (0x00000001u)

#define CSL_MCASP_AHCLKRCTL_HCLKRP_MASK (0x00004000u)
#define CSL_MCASP_AHCLKRCTL_HCLKRP_SHIFT (0x0000000Eu)
#define CSL_MCASP_AHCLKRCTL_HCLKRP_RESETVAL (0x00000000u)
/*----HCLKRP Tokens----*/
#define CSL_MCASP_AHCLKRCTL_HCLKRP_NOTINVERTED (0x00000000u)
#define CSL_MCASP_AHCLKRCTL_HCLKRP_INVERTED (0x00000001u)


#define CSL_MCASP_AHCLKRCTL_HCLKRDIV_MASK (0x00000FFFu)
#define CSL_MCASP_AHCLKRCTL_HCLKRDIV_SHIFT (0x00000000u)
#define CSL_MCASP_AHCLKRCTL_HCLKRDIV_RESETVAL (0x00000000u)

#define CSL_MCASP_AHCLKRCTL_RESETVAL (0x00008000u)

/* RTDM */

#define CSL_MCASP_RTDM_RTDMS31_MASK (0x80000000u)
#define CSL_MCASP_RTDM_RTDMS31_SHIFT (0x0000001Fu)
#define CSL_MCASP_RTDM_RTDMS31_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS31_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS31_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS30_MASK (0x40000000u)
#define CSL_MCASP_RTDM_RTDMS30_SHIFT (0x0000001Eu)
#define CSL_MCASP_RTDM_RTDMS30_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS30_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS30_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS29_MASK (0x20000000u)
#define CSL_MCASP_RTDM_RTDMS29_SHIFT (0x0000001Du)
#define CSL_MCASP_RTDM_RTDMS29_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS29_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS29_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS28_MASK (0x10000000u)
#define CSL_MCASP_RTDM_RTDMS28_SHIFT (0x0000001Cu)
#define CSL_MCASP_RTDM_RTDMS28_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS28_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS28_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS27_MASK (0x08000000u)
#define CSL_MCASP_RTDM_RTDMS27_SHIFT (0x0000001Bu)
#define CSL_MCASP_RTDM_RTDMS27_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS27_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS27_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS26_MASK (0x04000000u)
#define CSL_MCASP_RTDM_RTDMS26_SHIFT (0x0000001Au)
#define CSL_MCASP_RTDM_RTDMS26_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS26_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS26_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS25_MASK (0x02000000u)
#define CSL_MCASP_RTDM_RTDMS25_SHIFT (0x00000019u)
#define CSL_MCASP_RTDM_RTDMS25_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS25_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS25_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS24_MASK (0x01000000u)
#define CSL_MCASP_RTDM_RTDMS24_SHIFT (0x00000018u)
#define CSL_MCASP_RTDM_RTDMS24_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS24_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS24_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS23_MASK (0x00800000u)
#define CSL_MCASP_RTDM_RTDMS23_SHIFT (0x00000017u)
#define CSL_MCASP_RTDM_RTDMS23_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS23_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS23_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS22_MASK (0x00400000u)
#define CSL_MCASP_RTDM_RTDMS22_SHIFT (0x00000016u)
#define CSL_MCASP_RTDM_RTDMS22_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS22_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS22_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS21_MASK (0x00200000u)
#define CSL_MCASP_RTDM_RTDMS21_SHIFT (0x00000015u)
#define CSL_MCASP_RTDM_RTDMS21_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS21_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS21_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS20_MASK (0x00100000u)
#define CSL_MCASP_RTDM_RTDMS20_SHIFT (0x00000014u)
#define CSL_MCASP_RTDM_RTDMS20_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS20_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS20_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS19_MASK (0x00080000u)
#define CSL_MCASP_RTDM_RTDMS19_SHIFT (0x00000013u)
#define CSL_MCASP_RTDM_RTDMS19_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS19_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS19_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS18_MASK (0x00040000u)
#define CSL_MCASP_RTDM_RTDMS18_SHIFT (0x00000012u)
#define CSL_MCASP_RTDM_RTDMS18_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS18_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS18_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS17_MASK (0x00020000u)
#define CSL_MCASP_RTDM_RTDMS17_SHIFT (0x00000011u)
#define CSL_MCASP_RTDM_RTDMS17_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS17_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS17_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS16_MASK (0x00010000u)
#define CSL_MCASP_RTDM_RTDMS16_SHIFT (0x00000010u)
#define CSL_MCASP_RTDM_RTDMS16_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS16_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS16_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS15_MASK (0x00008000u)
#define CSL_MCASP_RTDM_RTDMS15_SHIFT (0x0000000Fu)
#define CSL_MCASP_RTDM_RTDMS15_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS15_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS15_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS14_MASK (0x00004000u)
#define CSL_MCASP_RTDM_RTDMS14_SHIFT (0x0000000Eu)
#define CSL_MCASP_RTDM_RTDMS14_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS14_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS14_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS13_MASK (0x00002000u)
#define CSL_MCASP_RTDM_RTDMS13_SHIFT (0x0000000Du)
#define CSL_MCASP_RTDM_RTDMS13_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS13_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS13_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS12_MASK (0x00001000u)
#define CSL_MCASP_RTDM_RTDMS12_SHIFT (0x0000000Cu)
#define CSL_MCASP_RTDM_RTDMS12_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS12_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS12_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS11_MASK (0x00000800u)
#define CSL_MCASP_RTDM_RTDMS11_SHIFT (0x0000000Bu)
#define CSL_MCASP_RTDM_RTDMS11_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS11_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS11_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS10_MASK (0x00000400u)
#define CSL_MCASP_RTDM_RTDMS10_SHIFT (0x0000000Au)
#define CSL_MCASP_RTDM_RTDMS10_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS10_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS10_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS9_MASK (0x00000200u)
#define CSL_MCASP_RTDM_RTDMS9_SHIFT (0x00000009u)
#define CSL_MCASP_RTDM_RTDMS9_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS9_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS9_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS8_MASK (0x00000100u)
#define CSL_MCASP_RTDM_RTDMS8_SHIFT (0x00000008u)
#define CSL_MCASP_RTDM_RTDMS8_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS8_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS8_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS7_MASK (0x00000080u)
#define CSL_MCASP_RTDM_RTDMS7_SHIFT (0x00000007u)
#define CSL_MCASP_RTDM_RTDMS7_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS7_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS7_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS6_MASK (0x00000040u)
#define CSL_MCASP_RTDM_RTDMS6_SHIFT (0x00000006u)
#define CSL_MCASP_RTDM_RTDMS6_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS6_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS6_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS5_MASK (0x00000020u)
#define CSL_MCASP_RTDM_RTDMS5_SHIFT (0x00000005u)
#define CSL_MCASP_RTDM_RTDMS5_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS5_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS5_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS4_MASK (0x00000010u)
#define CSL_MCASP_RTDM_RTDMS4_SHIFT (0x00000004u)
#define CSL_MCASP_RTDM_RTDMS4_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS4_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS4_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS3_MASK (0x00000008u)
#define CSL_MCASP_RTDM_RTDMS3_SHIFT (0x00000003u)
#define CSL_MCASP_RTDM_RTDMS3_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS3_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS3_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS2_MASK (0x00000004u)
#define CSL_MCASP_RTDM_RTDMS2_SHIFT (0x00000002u)
#define CSL_MCASP_RTDM_RTDMS2_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS2_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS2_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS1_MASK (0x00000002u)
#define CSL_MCASP_RTDM_RTDMS1_SHIFT (0x00000001u)
#define CSL_MCASP_RTDM_RTDMS1_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS1_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS1_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RTDMS0_MASK (0x00000001u)
#define CSL_MCASP_RTDM_RTDMS0_SHIFT (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS0_RESETVAL (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS0_INACTIVE (0x00000000u)
#define CSL_MCASP_RTDM_RTDMS0_ACTIVE (0x00000001u)

#define CSL_MCASP_RTDM_RESETVAL (0x00000000u)

/* RINTCTL */


#define CSL_MCASP_RINTCTL_RSTAFRM_MASK (0x00000080u)
#define CSL_MCASP_RINTCTL_RSTAFRM_SHIFT (0x00000007u)
#define CSL_MCASP_RINTCTL_RSTAFRM_RESETVAL (0x00000000u)
/*----RSTAFRM Tokens----*/
#define CSL_MCASP_RINTCTL_RSTAFRM_DISABLE (0x00000000u)
#define CSL_MCASP_RINTCTL_RSTAFRM_ENABLE (0x00000001u)


#define CSL_MCASP_RINTCTL_RDATA_MASK (0x00000020u)
#define CSL_MCASP_RINTCTL_RDATA_SHIFT (0x00000005u)
#define CSL_MCASP_RINTCTL_RDATA_RESETVAL (0x00000000u)
/*----RDATA Tokens----*/
#define CSL_MCASP_RINTCTL_RDATA_DISABLE (0x00000000u)
#define CSL_MCASP_RINTCTL_RDATA_ENABLE (0x00000001u)

#define CSL_MCASP_RINTCTL_RLAST_MASK (0x00000010u)
#define CSL_MCASP_RINTCTL_RLAST_SHIFT (0x00000004u)
#define CSL_MCASP_RINTCTL_RLAST_RESETVAL (0x00000000u)
/*----RLAST Tokens----*/
#define CSL_MCASP_RINTCTL_RLAST_DISABLE (0x00000000u)
#define CSL_MCASP_RINTCTL_RLAST_ENABLE (0x00000001u)

#define CSL_MCASP_RINTCTL_RDMAERR_MASK (0x00000008u)
#define CSL_MCASP_RINTCTL_RDMAERR_SHIFT (0x00000003u)
#define CSL_MCASP_RINTCTL_RDMAERR_RESETVAL (0x00000000u)
/*----RDMAERR Tokens----*/
#define CSL_MCASP_RINTCTL_RDMAERR_DISABLE (0x00000000u)
#define CSL_MCASP_RINTCTL_RDMAERR_ENABLE (0x00000001u)

#define CSL_MCASP_RINTCTL_RCKFAIL_MASK (0x00000004u)
#define CSL_MCASP_RINTCTL_RCKFAIL_SHIFT (0x00000002u)
#define CSL_MCASP_RINTCTL_RCKFAIL_RESETVAL (0x00000000u)
/*----RCKFAIL Tokens----*/
#define CSL_MCASP_RINTCTL_RCKFAIL_DISABLE (0x00000000u)
#define CSL_MCASP_RINTCTL_RCKFAIL_ENABLE (0x00000001u)

#define CSL_MCASP_RINTCTL_RSYNCERR_MASK (0x00000002u)
#define CSL_MCASP_RINTCTL_RSYNCERR_SHIFT (0x00000001u)
#define CSL_MCASP_RINTCTL_RSYNCERR_RESETVAL (0x00000000u)
/*----RSYNCERR Tokens----*/
#define CSL_MCASP_RINTCTL_RSYNCERR_DISABLE (0x00000000u)
#define CSL_MCASP_RINTCTL_RSYNCERR_ENABLE (0x00000001u)

#define CSL_MCASP_RINTCTL_ROVRN_MASK (0x00000001u)
#define CSL_MCASP_RINTCTL_ROVRN_SHIFT (0x00000000u)
#define CSL_MCASP_RINTCTL_ROVRN_RESETVAL (0x00000000u)
/*----ROVRN Tokens----*/
#define CSL_MCASP_RINTCTL_ROVRN_DISABLE (0x00000000u)
#define CSL_MCASP_RINTCTL_ROVRN_ENABLE (0x00000001u)

#define CSL_MCASP_RINTCTL_RESETVAL (0x00000000u)

/* RSTAT */


#define CSL_MCASP_RSTAT_RERR_MASK (0x00000100u)
#define CSL_MCASP_RSTAT_RERR_SHIFT (0x00000008u)
#define CSL_MCASP_RSTAT_RERR_RESETVAL (0x00000000u)
/*----RERR Tokens----*/
#define CSL_MCASP_RSTAT_RERR_NOERROR (0x00000000u)
#define CSL_MCASP_RSTAT_RERR_ERROR (0x00000001u)

#define CSL_MCASP_RSTAT_RDMAERR_MASK (0x00000080u)
#define CSL_MCASP_RSTAT_RDMAERR_SHIFT (0x00000007u)
#define CSL_MCASP_RSTAT_RDMAERR_RESETVAL (0x00000000u)
/*----RDMAERR Tokens----*/
#define CSL_MCASP_RSTAT_RDMAERR_NO_ERROR (0x00000000u)
#define CSL_MCASP_RSTAT_RDMAERR_ERROR (0x00000001u)

#define CSL_MCASP_RSTAT_RSTAFRM_MASK (0x00000040u)
#define CSL_MCASP_RSTAT_RSTAFRM_SHIFT (0x00000006u)
#define CSL_MCASP_RSTAT_RSTAFRM_RESETVAL (0x00000000u)
/*----RSTAFRM Tokens----*/
#define CSL_MCASP_RSTAT_RSTAFRM_NO (0x00000000u)
#define CSL_MCASP_RSTAT_RSTAFRM_YES (0x00000001u)

#define CSL_MCASP_RSTAT_RDATA_MASK (0x00000020u)
#define CSL_MCASP_RSTAT_RDATA_SHIFT (0x00000005u)
#define CSL_MCASP_RSTAT_RDATA_RESETVAL (0x00000000u)
/*----RDATA Tokens----*/
#define CSL_MCASP_RSTAT_RDATA_NO (0x00000000u)
#define CSL_MCASP_RSTAT_RDATA_YES (0x00000001u)

#define CSL_MCASP_RSTAT_RLAST_MASK (0x00000010u)
#define CSL_MCASP_RSTAT_RLAST_SHIFT (0x00000004u)
#define CSL_MCASP_RSTAT_RLAST_RESETVAL (0x00000000u)
/*----RLAST Tokens----*/
#define CSL_MCASP_RSTAT_RLAST_NO (0x00000000u)
#define CSL_MCASP_RSTAT_RLAST_YES (0x00000001u)

#define CSL_MCASP_RSTAT_RTDMSLOT_MASK (0x00000008u)
#define CSL_MCASP_RSTAT_RTDMSLOT_SHIFT (0x00000003u)
#define CSL_MCASP_RSTAT_RTDMSLOT_RESETVAL (0x00000000u)
/*----RTDMSLOT Tokens----*/
#define CSL_MCASP_RSTAT_RTDMSLOT_ODD (0x00000000u)
#define CSL_MCASP_RSTAT_RTDMSLOT_EVEN (0x00000001u)

#define CSL_MCASP_RSTAT_RCKFAIL_MASK (0x00000004u)
#define CSL_MCASP_RSTAT_RCKFAIL_SHIFT (0x00000002u)
#define CSL_MCASP_RSTAT_RCKFAIL_RESETVAL (0x00000000u)
/*----RCKFAIL Tokens----*/
#define CSL_MCASP_RSTAT_RCKFAIL_NO (0x00000000u)
#define CSL_MCASP_RSTAT_RCKFAIL_YES (0x00000001u)

#define CSL_MCASP_RSTAT_RSYNCERR_MASK (0x00000002u)
#define CSL_MCASP_RSTAT_RSYNCERR_SHIFT (0x00000001u)
#define CSL_MCASP_RSTAT_RSYNCERR_RESETVAL (0x00000000u)
/*----RSYNCERR Tokens----*/
#define CSL_MCASP_RSTAT_RSYNCERR_NO (0x00000000u)
#define CSL_MCASP_RSTAT_RSYNCERR_YES (0x00000001u)

#define CSL_MCASP_RSTAT_ROVRN_MASK (0x00000001u)
#define CSL_MCASP_RSTAT_ROVRN_SHIFT (0x00000000u)
#define CSL_MCASP_RSTAT_ROVRN_RESETVAL (0x00000000u)
/*----ROVRN Tokens----*/
#define CSL_MCASP_RSTAT_ROVRN_NO (0x00000000u)
#define CSL_MCASP_RSTAT_ROVRN_YES (0x00000001u)

#define CSL_MCASP_RSTAT_RESETVAL (0x00000000u)

/* RSLOT */


#define CSL_MCASP_RSLOT_RSLOTCNT_MASK (0x000003FFu)
#define CSL_MCASP_RSLOT_RSLOTCNT_SHIFT (0x00000000u)
#define CSL_MCASP_RSLOT_RSLOTCNT_RESETVAL (0x00000000u)

#define CSL_MCASP_RSLOT_RESETVAL (0x00000000u)

/* RCLKCHK */

#define CSL_MCASP_RCLKCHK_RCNT_MASK (0xFF000000u)
#define CSL_MCASP_RCLKCHK_RCNT_SHIFT (0x00000018u)
#define CSL_MCASP_RCLKCHK_RCNT_RESETVAL (0x00000000u)

#define CSL_MCASP_RCLKCHK_RMAX_MASK (0x00FF0000u)
#define CSL_MCASP_RCLKCHK_RMAX_SHIFT (0x00000010u)
#define CSL_MCASP_RCLKCHK_RMAX_RESETVAL (0x00000000u)

#define CSL_MCASP_RCLKCHK_RMIN_MASK (0x0000FF00u)
#define CSL_MCASP_RCLKCHK_RMIN_SHIFT (0x00000008u)
#define CSL_MCASP_RCLKCHK_RMIN_RESETVAL (0x00000000u)


#define CSL_MCASP_RCLKCHK_RPS_MASK (0x0000000Fu)
#define CSL_MCASP_RCLKCHK_RPS_SHIFT (0x00000000u)
#define CSL_MCASP_RCLKCHK_RPS_RESETVAL (0x00000000u)
/*----RPS Tokens----*/
#define CSL_MCASP_RCLKCHK_RPS_DIVBY1 (0x00000000u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY2 (0x00000001u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY4 (0x00000002u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY8 (0x00000003u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY16 (0x00000004u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY32 (0x00000005u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY64 (0x00000006u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY128 (0x00000007u)
#define CSL_MCASP_RCLKCHK_RPS_DIVBY256 (0x00000008u)

#define CSL_MCASP_RCLKCHK_RESETVAL (0x00000000u)

/* REVTCTL */


#define CSL_MCASP_REVTCTL_RDATDMA_MASK (0x00000001u)
#define CSL_MCASP_REVTCTL_RDATDMA_SHIFT (0x00000000u)
#define CSL_MCASP_REVTCTL_RDATDMA_RESETVAL (0x00000000u)
/*----RDATDMA Tokens----*/
#define CSL_MCASP_REVTCTL_RDATDMA_ENABLE (0x00000000u)
#define CSL_MCASP_REVTCTL_RDATDMA_RSV (0x00000001u)

#define CSL_MCASP_REVTCTL_RESETVAL (0x00000000u)

/* XGBLCTL */


#define CSL_MCASP_XGBLCTL_XFRST_MASK (0x00001000u)
#define CSL_MCASP_XGBLCTL_XFRST_SHIFT (0x0000000Cu)
#define CSL_MCASP_XGBLCTL_XFRST_RESETVAL (0x00000000u)
/*----XFRST Tokens----*/
#define CSL_MCASP_XGBLCTL_XFRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_XFRST_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_XSMRST_MASK (0x00000800u)
#define CSL_MCASP_XGBLCTL_XSMRST_SHIFT (0x0000000Bu)
#define CSL_MCASP_XGBLCTL_XSMRST_RESETVAL (0x00000000u)
/*----XSMRST Tokens----*/
#define CSL_MCASP_XGBLCTL_XSMRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_XSMRST_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_XSRCLR_MASK (0x00000400u)
#define CSL_MCASP_XGBLCTL_XSRCLR_SHIFT (0x0000000Au)
#define CSL_MCASP_XGBLCTL_XSRCLR_RESETVAL (0x00000000u)
/*----XSRCLR Tokens----*/
#define CSL_MCASP_XGBLCTL_XSRCLR_CLEAR (0x00000000u)
#define CSL_MCASP_XGBLCTL_XSRCLR_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_XHCLKRST_MASK (0x00000200u)
#define CSL_MCASP_XGBLCTL_XHCLKRST_SHIFT (0x00000009u)
#define CSL_MCASP_XGBLCTL_XHCLKRST_RESETVAL (0x00000000u)
/*----XHCLKRST Tokens----*/
#define CSL_MCASP_XGBLCTL_XHCLKRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_XHCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_XCLKRST_MASK (0x00000100u)
#define CSL_MCASP_XGBLCTL_XCLKRST_SHIFT (0x00000008u)
#define CSL_MCASP_XGBLCTL_XCLKRST_RESETVAL (0x00000000u)
/*----XCLKRST Tokens----*/
#define CSL_MCASP_XGBLCTL_XCLKRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_XCLKRST_ACTIVE (0x00000001u)


#define CSL_MCASP_XGBLCTL_RFRST_MASK (0x00000010u)
#define CSL_MCASP_XGBLCTL_RFRST_SHIFT (0x00000004u)
#define CSL_MCASP_XGBLCTL_RFRST_RESETVAL (0x00000000u)
#define CSL_MCASP_XGBLCTL_RFRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_RFRST_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_RSMRST_MASK (0x00000008u)
#define CSL_MCASP_XGBLCTL_RSMRST_SHIFT (0x00000003u)
#define CSL_MCASP_XGBLCTL_RSMRST_RESETVAL (0x00000000u)
#define CSL_MCASP_XGBLCTL_RSMRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_RSMRST_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_RSRCLKR_MASK (0x00000004u)
#define CSL_MCASP_XGBLCTL_RSRCLKR_SHIFT (0x00000002u)
#define CSL_MCASP_XGBLCTL_RSRCLKR_RESETVAL (0x00000000u)
#define CSL_MCASP_XGBLCTL_RSRCLKR_CLEAR (0x00000000u)
#define CSL_MCASP_XGBLCTL_RSRCLKR_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_RHCLKRST_MASK (0x00000002u)
#define CSL_MCASP_XGBLCTL_RHCLKRST_SHIFT (0x00000001u)
#define CSL_MCASP_XGBLCTL_RHCLKRST_RESETVAL (0x00000000u)
#define CSL_MCASP_XGBLCTL_RHCLKRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_RHCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_RCLKRST_MASK (0x00000001u)
#define CSL_MCASP_XGBLCTL_RCLKRST_SHIFT (0x00000000u)
#define CSL_MCASP_XGBLCTL_RCLKRST_RESETVAL (0x00000000u)
#define CSL_MCASP_XGBLCTL_RCLKRST_RESET (0x00000000u)
#define CSL_MCASP_XGBLCTL_RCLKRST_ACTIVE (0x00000001u)

#define CSL_MCASP_XGBLCTL_RESETVAL (0x00000000u)

/* XMASK */

#define CSL_MCASP_XMASK_XMASK31_MASK (0x80000000u)
#define CSL_MCASP_XMASK_XMASK31_SHIFT (0x0000001Fu)
#define CSL_MCASP_XMASK_XMASK31_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK31_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK31_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK30_MASK (0x40000000u)
#define CSL_MCASP_XMASK_XMASK30_SHIFT (0x0000001Eu)
#define CSL_MCASP_XMASK_XMASK30_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK30_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK30_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK29_MASK (0x20000000u)
#define CSL_MCASP_XMASK_XMASK29_SHIFT (0x0000001Du)
#define CSL_MCASP_XMASK_XMASK29_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK29_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK29_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK28_MASK (0x10000000u)
#define CSL_MCASP_XMASK_XMASK28_SHIFT (0x0000001Cu)
#define CSL_MCASP_XMASK_XMASK28_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK28_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK28_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK27_MASK (0x08000000u)
#define CSL_MCASP_XMASK_XMASK27_SHIFT (0x0000001Bu)
#define CSL_MCASP_XMASK_XMASK27_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK27_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK27_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK26_MASK (0x04000000u)
#define CSL_MCASP_XMASK_XMASK26_SHIFT (0x0000001Au)
#define CSL_MCASP_XMASK_XMASK26_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK26_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK26_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK25_MASK (0x02000000u)
#define CSL_MCASP_XMASK_XMASK25_SHIFT (0x00000019u)
#define CSL_MCASP_XMASK_XMASK25_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK25_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK25_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK24_MASK (0x01000000u)
#define CSL_MCASP_XMASK_XMASK24_SHIFT (0x00000018u)
#define CSL_MCASP_XMASK_XMASK24_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK24_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK24_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK23_MASK (0x00800000u)
#define CSL_MCASP_XMASK_XMASK23_SHIFT (0x00000017u)
#define CSL_MCASP_XMASK_XMASK23_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK23_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK23_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK22_MASK (0x00400000u)
#define CSL_MCASP_XMASK_XMASK22_SHIFT (0x00000016u)
#define CSL_MCASP_XMASK_XMASK22_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK22_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK22_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK21_MASK (0x00200000u)
#define CSL_MCASP_XMASK_XMASK21_SHIFT (0x00000015u)
#define CSL_MCASP_XMASK_XMASK21_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK21_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK21_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK20_MASK (0x00100000u)
#define CSL_MCASP_XMASK_XMASK20_SHIFT (0x00000014u)
#define CSL_MCASP_XMASK_XMASK20_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK20_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK20_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK19_MASK (0x00080000u)
#define CSL_MCASP_XMASK_XMASK19_SHIFT (0x00000013u)
#define CSL_MCASP_XMASK_XMASK19_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK19_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK19_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK18_MASK (0x00040000u)
#define CSL_MCASP_XMASK_XMASK18_SHIFT (0x00000012u)
#define CSL_MCASP_XMASK_XMASK18_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK18_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK18_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK17_MASK (0x00020000u)
#define CSL_MCASP_XMASK_XMASK17_SHIFT (0x00000011u)
#define CSL_MCASP_XMASK_XMASK17_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK17_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK17_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK16_MASK (0x00010000u)
#define CSL_MCASP_XMASK_XMASK16_SHIFT (0x00000010u)
#define CSL_MCASP_XMASK_XMASK16_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK16_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK16_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK15_MASK (0x00008000u)
#define CSL_MCASP_XMASK_XMASK15_SHIFT (0x0000000Fu)
#define CSL_MCASP_XMASK_XMASK15_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK15_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK15_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK14_MASK (0x00004000u)
#define CSL_MCASP_XMASK_XMASK14_SHIFT (0x0000000Eu)
#define CSL_MCASP_XMASK_XMASK14_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK14_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK14_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK13_MASK (0x00002000u)
#define CSL_MCASP_XMASK_XMASK13_SHIFT (0x0000000Du)
#define CSL_MCASP_XMASK_XMASK13_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK13_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK13_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK12_MASK (0x00001000u)
#define CSL_MCASP_XMASK_XMASK12_SHIFT (0x0000000Cu)
#define CSL_MCASP_XMASK_XMASK12_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK12_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK12_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK11_MASK (0x00000800u)
#define CSL_MCASP_XMASK_XMASK11_SHIFT (0x0000000Bu)
#define CSL_MCASP_XMASK_XMASK11_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK11_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK11_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK10_MASK (0x00000400u)
#define CSL_MCASP_XMASK_XMASK10_SHIFT (0x0000000Au)
#define CSL_MCASP_XMASK_XMASK10_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK10_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK10_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK9_MASK (0x00000200u)
#define CSL_MCASP_XMASK_XMASK9_SHIFT (0x00000009u)
#define CSL_MCASP_XMASK_XMASK9_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK9_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK9_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK8_MASK (0x00000100u)
#define CSL_MCASP_XMASK_XMASK8_SHIFT (0x00000008u)
#define CSL_MCASP_XMASK_XMASK8_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK8_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK8_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK7_MASK (0x00000080u)
#define CSL_MCASP_XMASK_XMASK7_SHIFT (0x00000007u)
#define CSL_MCASP_XMASK_XMASK7_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK7_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK7_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK6_MASK (0x00000040u)
#define CSL_MCASP_XMASK_XMASK6_SHIFT (0x00000006u)
#define CSL_MCASP_XMASK_XMASK6_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK6_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK6_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK5_MASK (0x00000020u)
#define CSL_MCASP_XMASK_XMASK5_SHIFT (0x00000005u)
#define CSL_MCASP_XMASK_XMASK5_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK5_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK5_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK4_MASK (0x00000010u)
#define CSL_MCASP_XMASK_XMASK4_SHIFT (0x00000004u)
#define CSL_MCASP_XMASK_XMASK4_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK4_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK4_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK3_MASK (0x00000008u)
#define CSL_MCASP_XMASK_XMASK3_SHIFT (0x00000003u)
#define CSL_MCASP_XMASK_XMASK3_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK3_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK3_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK2_MASK (0x00000004u)
#define CSL_MCASP_XMASK_XMASK2_SHIFT (0x00000002u)
#define CSL_MCASP_XMASK_XMASK2_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK2_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK2_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK1_MASK (0x00000002u)
#define CSL_MCASP_XMASK_XMASK1_SHIFT (0x00000001u)
#define CSL_MCASP_XMASK_XMASK1_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK1_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK1_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_XMASK0_MASK (0x00000001u)
#define CSL_MCASP_XMASK_XMASK0_SHIFT (0x00000000u)
#define CSL_MCASP_XMASK_XMASK0_RESETVAL (0x00000000u)
#define CSL_MCASP_XMASK_XMASK0_USEMASK (0x00000000u)
#define CSL_MCASP_XMASK_XMASK0_NOMASK (0x00000001u)

#define CSL_MCASP_XMASK_RESETVAL (0x00000000u)

/* XFMT */


#define CSL_MCASP_XFMT_XDATDLY_MASK (0x00030000u)
#define CSL_MCASP_XFMT_XDATDLY_SHIFT (0x00000010u)
#define CSL_MCASP_XFMT_XDATDLY_RESETVAL (0x00000000u)
/*----XDATDLY Tokens----*/
#define CSL_MCASP_XFMT_XDATDLY_0BIT (0x00000000u)
#define CSL_MCASP_XFMT_XDATDLY_1BIT (0x00000001u)
#define CSL_MCASP_XFMT_XDATDLY_2BIT (0x00000002u)

#define CSL_MCASP_XFMT_XRVRS_MASK (0x00008000u)
#define CSL_MCASP_XFMT_XRVRS_SHIFT (0x0000000Fu)
#define CSL_MCASP_XFMT_XRVRS_RESETVAL (0x00000000u)
/*----XRVRS Tokens----*/
#define CSL_MCASP_XFMT_XRVRS_LSBFIRST (0x00000000u)
#define CSL_MCASP_XFMT_XRVRS_MSBFIRST (0x00000001u)

#define CSL_MCASP_XFMT_XPAD_MASK (0x00006000u)
#define CSL_MCASP_XFMT_XPAD_SHIFT (0x0000000Du)
#define CSL_MCASP_XFMT_XPAD_RESETVAL (0x00000000u)
/*----XPAD Tokens----*/
#define CSL_MCASP_XFMT_XPAD_ZERO (0x00000000u)
#define CSL_MCASP_XFMT_XPAD_ONE (0x00000001u)
#define CSL_MCASP_XFMT_XPAD_XPBIT (0x00000002u)

#define CSL_MCASP_XFMT_XPBIT_MASK (0x00001F00u)
#define CSL_MCASP_XFMT_XPBIT_SHIFT (0x00000008u)
#define CSL_MCASP_XFMT_XPBIT_RESETVAL (0x00000000u)

#define CSL_MCASP_XFMT_XSSZ_MASK (0x000000F0u)
#define CSL_MCASP_XFMT_XSSZ_SHIFT (0x00000004u)
#define CSL_MCASP_XFMT_XSSZ_RESETVAL (0x00000000u)
/*----XSSZ Tokens----*/
#define CSL_MCASP_XFMT_XSSZ_RSV (0x00000000u)
#define CSL_MCASP_XFMT_XSSZ_RSV1 (0x00000001u)
#define CSL_MCASP_XFMT_XSSZ_RSV2 (0x00000002u)
#define CSL_MCASP_XFMT_XSSZ_8BITS (0x00000003u)
#define CSL_MCASP_XFMT_XSSZ_RSV3 (0x00000004u)
#define CSL_MCASP_XFMT_XSSZ_12BITS (0x00000005u)
#define CSL_MCASP_XFMT_XSSZ_RSV4 (0x00000006u)
#define CSL_MCASP_XFMT_XSSZ_16BITS (0x00000007u)
#define CSL_MCASP_XFMT_XSSZ_RSV5 (0x00000008u)
#define CSL_MCASP_XFMT_XSSZ_20BITS (0x00000009u)
#define CSL_MCASP_XFMT_XSSZ_RSV6 (0x0000000Au)
#define CSL_MCASP_XFMT_XSSZ_24BITS (0x0000000Bu)
#define CSL_MCASP_XFMT_XSSZ_RSV7 (0x0000000Cu)
#define CSL_MCASP_XFMT_XSSZ_28BITS (0x0000000Du)
#define CSL_MCASP_XFMT_XSSZ_RSV8 (0x0000000Eu)
#define CSL_MCASP_XFMT_XSSZ_32BITS (0x0000000Fu)

#define CSL_MCASP_XFMT_XBUSEL_MASK (0x00000008u)
#define CSL_MCASP_XFMT_XBUSEL_SHIFT (0x00000003u)
#define CSL_MCASP_XFMT_XBUSEL_RESETVAL (0x00000000u)
/*----XBUSEL Tokens----*/
#define CSL_MCASP_XFMT_XBUSEL_VBUSP (0x00000000u)
#define CSL_MCASP_XFMT_XBUSEL_VBUS (0x00000001u)

#define CSL_MCASP_XFMT_XROT_MASK (0x00000007u)
#define CSL_MCASP_XFMT_XROT_SHIFT (0x00000000u)
#define CSL_MCASP_XFMT_XROT_RESETVAL (0x00000000u)
/*----XROT Tokens----*/
#define CSL_MCASP_XFMT_XROT_NONE (0x00000000u)
#define CSL_MCASP_XFMT_XROT_4BITS (0x00000001u)
#define CSL_MCASP_XFMT_XROT_8BITS (0x00000002u)
#define CSL_MCASP_XFMT_XROT_12BITS (0x00000003u)
#define CSL_MCASP_XFMT_XROT_16BITS (0x00000004u)
#define CSL_MCASP_XFMT_XROT_20BITS (0x00000005u)
#define CSL_MCASP_XFMT_XROT_24BITS (0x00000006u)
#define CSL_MCASP_XFMT_XROT_28BITS (0x00000007u)

#define CSL_MCASP_XFMT_RESETVAL (0x00000000u)

/* AFSXCTL */


#define CSL_MCASP_AFSXCTL_XMOD_MASK (0x0000FF80u)
#define CSL_MCASP_AFSXCTL_XMOD_SHIFT (0x00000007u)
#define CSL_MCASP_AFSXCTL_XMOD_RESETVAL (0x00000000u)
/*----XMOD Tokens----*/
#define CSL_MCASP_AFSXCTL_XMOD_BURST (0x00000000u)
#define CSL_MCASP_AFSXCTL_XMOD_I2S (0x00000002u)


#define CSL_MCASP_AFSXCTL_FXWID_MASK (0x00000010u)
#define CSL_MCASP_AFSXCTL_FXWID_SHIFT (0x00000004u)
#define CSL_MCASP_AFSXCTL_FXWID_RESETVAL (0x00000000u)
/*----FXWID Tokens----*/
#define CSL_MCASP_AFSXCTL_FXWID_BIT (0x00000000u)
#define CSL_MCASP_AFSXCTL_FXWID_WORD (0x00000001u)


#define CSL_MCASP_AFSXCTL_FSXM_MASK (0x00000002u)
#define CSL_MCASP_AFSXCTL_FSXM_SHIFT (0x00000001u)
#define CSL_MCASP_AFSXCTL_FSXM_RESETVAL (0x00000000u)
/*----FSXM Tokens----*/
#define CSL_MCASP_AFSXCTL_FSXM_EXTERNAL (0x00000000u)
#define CSL_MCASP_AFSXCTL_FSXM_INTERNAL (0x00000001u)

#define CSL_MCASP_AFSXCTL_FSXP_MASK (0x00000001u)
#define CSL_MCASP_AFSXCTL_FSXP_SHIFT (0x00000000u)
#define CSL_MCASP_AFSXCTL_FSXP_RESETVAL (0x00000000u)
/*----FSXP Tokens----*/
#define CSL_MCASP_AFSXCTL_FSXP_RISINGEDGE (0x00000000u)
#define CSL_MCASP_AFSXCTL_FSXP_FALLINGEDGE (0x00000001u)

#define CSL_MCASP_AFSXCTL_RESETVAL (0x00000000u)

/* ACLKXCTL */


#define CSL_MCASP_ACLKXCTL_CLKXP_MASK (0x00000080u)
#define CSL_MCASP_ACLKXCTL_CLKXP_SHIFT (0x00000007u)
#define CSL_MCASP_ACLKXCTL_CLKXP_RESETVAL (0x00000000u)
/*----CLKXP Tokens----*/
#define CSL_MCASP_ACLKXCTL_CLKXP_RISINGEDGE (0x00000000u)
#define CSL_MCASP_ACLKXCTL_CLKXP_FALLINGEDGE (0x00000001u)

#define CSL_MCASP_ACLKXCTL_ASYNC_MASK (0x00000040u)
#define CSL_MCASP_ACLKXCTL_ASYNC_SHIFT (0x00000006u)
#define CSL_MCASP_ACLKXCTL_ASYNC_RESETVAL (0x00000001u)
/*----ASYNC Tokens----*/
#define CSL_MCASP_ACLKXCTL_ASYNC_SYNC (0x00000000u)
#define CSL_MCASP_ACLKXCTL_ASYNC_ASYNC (0x00000001u)

#define CSL_MCASP_ACLKXCTL_CLKXM_MASK (0x00000020u)
#define CSL_MCASP_ACLKXCTL_CLKXM_SHIFT (0x00000005u)
#define CSL_MCASP_ACLKXCTL_CLKXM_RESETVAL (0x00000001u)
/*----CLKXM Tokens----*/
#define CSL_MCASP_ACLKXCTL_CLKXM_EXTERNAL (0x00000000u)
#define CSL_MCASP_ACLKXCTL_CLKXM_INTERNAL (0x00000001u)

#define CSL_MCASP_ACLKXCTL_CLKXDIV_MASK (0x0000001Fu)
#define CSL_MCASP_ACLKXCTL_CLKXDIV_SHIFT (0x00000000u)
#define CSL_MCASP_ACLKXCTL_CLKXDIV_RESETVAL (0x00000000u)

#define CSL_MCASP_ACLKXCTL_RESETVAL (0x00000060u)

/* AHCLKXCTL */


#define CSL_MCASP_AHCLKXCTL_HCLKXM_MASK (0x00008000u)
#define CSL_MCASP_AHCLKXCTL_HCLKXM_SHIFT (0x0000000Fu)
#define CSL_MCASP_AHCLKXCTL_HCLKXM_RESETVAL (0x00000001u)
/*----HCLKXM Tokens----*/
#define CSL_MCASP_AHCLKXCTL_HCLKXM_EXTERNAL (0x00000000u)
#define CSL_MCASP_AHCLKXCTL_HCLKXM_INTERNAL (0x00000001u)

#define CSL_MCASP_AHCLKXCTL_HCLKXP_MASK (0x00004000u)
#define CSL_MCASP_AHCLKXCTL_HCLKXP_SHIFT (0x0000000Eu)
#define CSL_MCASP_AHCLKXCTL_HCLKXP_RESETVAL (0x00000000u)
/*----HCLKXP Tokens----*/
#define CSL_MCASP_AHCLKXCTL_HCLKXP_NOTINVERTED (0x00000000u)
#define CSL_MCASP_AHCLKXCTL_HCLKXP_INVERTED (0x00000001u)


#define CSL_MCASP_AHCLKXCTL_HCLKXDIV_MASK (0x00000FFFu)
#define CSL_MCASP_AHCLKXCTL_HCLKXDIV_SHIFT (0x00000000u)
#define CSL_MCASP_AHCLKXCTL_HCLKXDIV_RESETVAL (0x00000000u)

#define CSL_MCASP_AHCLKXCTL_RESETVAL (0x00008000u)

/* XTDM */

#define CSL_MCASP_XTDM_XTDMS31_MASK (0x80000000u)
#define CSL_MCASP_XTDM_XTDMS31_SHIFT (0x0000001Fu)
#define CSL_MCASP_XTDM_XTDMS31_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS31_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS31_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS30_MASK (0x40000000u)
#define CSL_MCASP_XTDM_XTDMS30_SHIFT (0x0000001Eu)
#define CSL_MCASP_XTDM_XTDMS30_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS30_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS30_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS29_MASK (0x20000000u)
#define CSL_MCASP_XTDM_XTDMS29_SHIFT (0x0000001Du)
#define CSL_MCASP_XTDM_XTDMS29_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS29_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS29_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS28_MASK (0x10000000u)
#define CSL_MCASP_XTDM_XTDMS28_SHIFT (0x0000001Cu)
#define CSL_MCASP_XTDM_XTDMS28_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS28_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS28_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS27_MASK (0x08000000u)
#define CSL_MCASP_XTDM_XTDMS27_SHIFT (0x0000001Bu)
#define CSL_MCASP_XTDM_XTDMS27_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS27_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS27_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS26_MASK (0x04000000u)
#define CSL_MCASP_XTDM_XTDMS26_SHIFT (0x0000001Au)
#define CSL_MCASP_XTDM_XTDMS26_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS26_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS26_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS25_MASK (0x02000000u)
#define CSL_MCASP_XTDM_XTDMS25_SHIFT (0x00000019u)
#define CSL_MCASP_XTDM_XTDMS25_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS25_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS25_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS24_MASK (0x01000000u)
#define CSL_MCASP_XTDM_XTDMS24_SHIFT (0x00000018u)
#define CSL_MCASP_XTDM_XTDMS24_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS24_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS24_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS23_MASK (0x00800000u)
#define CSL_MCASP_XTDM_XTDMS23_SHIFT (0x00000017u)
#define CSL_MCASP_XTDM_XTDMS23_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS23_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS23_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS22_MASK (0x00400000u)
#define CSL_MCASP_XTDM_XTDMS22_SHIFT (0x00000016u)
#define CSL_MCASP_XTDM_XTDMS22_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS22_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS22_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS21_MASK (0x00200000u)
#define CSL_MCASP_XTDM_XTDMS21_SHIFT (0x00000015u)
#define CSL_MCASP_XTDM_XTDMS21_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS21_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS21_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS20_MASK (0x00100000u)
#define CSL_MCASP_XTDM_XTDMS20_SHIFT (0x00000014u)
#define CSL_MCASP_XTDM_XTDMS20_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS20_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS20_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS19_MASK (0x00080000u)
#define CSL_MCASP_XTDM_XTDMS19_SHIFT (0x00000013u)
#define CSL_MCASP_XTDM_XTDMS19_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS19_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS19_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS18_MASK (0x00040000u)
#define CSL_MCASP_XTDM_XTDMS18_SHIFT (0x00000012u)
#define CSL_MCASP_XTDM_XTDMS18_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS18_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS18_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS17_MASK (0x00020000u)
#define CSL_MCASP_XTDM_XTDMS17_SHIFT (0x00000011u)
#define CSL_MCASP_XTDM_XTDMS17_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS17_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS17_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS16_MASK (0x00010000u)
#define CSL_MCASP_XTDM_XTDMS16_SHIFT (0x00000010u)
#define CSL_MCASP_XTDM_XTDMS16_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS16_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS16_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS15_MASK (0x00008000u)
#define CSL_MCASP_XTDM_XTDMS15_SHIFT (0x0000000Fu)
#define CSL_MCASP_XTDM_XTDMS15_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS15_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS15_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS14_MASK (0x00004000u)
#define CSL_MCASP_XTDM_XTDMS14_SHIFT (0x0000000Eu)
#define CSL_MCASP_XTDM_XTDMS14_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS14_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS14_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS13_MASK (0x00002000u)
#define CSL_MCASP_XTDM_XTDMS13_SHIFT (0x0000000Du)
#define CSL_MCASP_XTDM_XTDMS13_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS13_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS13_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS12_MASK (0x00001000u)
#define CSL_MCASP_XTDM_XTDMS12_SHIFT (0x0000000Cu)
#define CSL_MCASP_XTDM_XTDMS12_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS12_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS12_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS11_MASK (0x00000800u)
#define CSL_MCASP_XTDM_XTDMS11_SHIFT (0x0000000Bu)
#define CSL_MCASP_XTDM_XTDMS11_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS11_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS11_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS10_MASK (0x00000400u)
#define CSL_MCASP_XTDM_XTDMS10_SHIFT (0x0000000Au)
#define CSL_MCASP_XTDM_XTDMS10_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS10_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS10_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS9_MASK (0x00000200u)
#define CSL_MCASP_XTDM_XTDMS9_SHIFT (0x00000009u)
#define CSL_MCASP_XTDM_XTDMS9_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS9_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS9_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS8_MASK (0x00000100u)
#define CSL_MCASP_XTDM_XTDMS8_SHIFT (0x00000008u)
#define CSL_MCASP_XTDM_XTDMS8_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS8_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS8_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS7_MASK (0x00000080u)
#define CSL_MCASP_XTDM_XTDMS7_SHIFT (0x00000007u)
#define CSL_MCASP_XTDM_XTDMS7_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS7_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS7_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS6_MASK (0x00000040u)
#define CSL_MCASP_XTDM_XTDMS6_SHIFT (0x00000006u)
#define CSL_MCASP_XTDM_XTDMS6_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS6_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS6_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS5_MASK (0x00000020u)
#define CSL_MCASP_XTDM_XTDMS5_SHIFT (0x00000005u)
#define CSL_MCASP_XTDM_XTDMS5_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS5_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS5_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS4_MASK (0x00000010u)
#define CSL_MCASP_XTDM_XTDMS4_SHIFT (0x00000004u)
#define CSL_MCASP_XTDM_XTDMS4_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS4_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS4_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS3_MASK (0x00000008u)
#define CSL_MCASP_XTDM_XTDMS3_SHIFT (0x00000003u)
#define CSL_MCASP_XTDM_XTDMS3_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS3_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS3_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS2_MASK (0x00000004u)
#define CSL_MCASP_XTDM_XTDMS2_SHIFT (0x00000002u)
#define CSL_MCASP_XTDM_XTDMS2_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS2_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS2_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS1_MASK (0x00000002u)
#define CSL_MCASP_XTDM_XTDMS1_SHIFT (0x00000001u)
#define CSL_MCASP_XTDM_XTDMS1_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS1_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS1_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_XTDMS0_MASK (0x00000001u)
#define CSL_MCASP_XTDM_XTDMS0_SHIFT (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS0_RESETVAL (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS0_INACTIVE (0x00000000u)
#define CSL_MCASP_XTDM_XTDMS0_ACTIVE (0x00000001u)

#define CSL_MCASP_XTDM_RESETVAL (0x00000000u)

/* XINTCTL */


#define CSL_MCASP_XINTCTL_XSTAFRM_MASK (0x00000080u)
#define CSL_MCASP_XINTCTL_XSTAFRM_SHIFT (0x00000007u)
#define CSL_MCASP_XINTCTL_XSTAFRM_RESETVAL (0x00000000u)
/*----XSTAFRM Tokens----*/
#define CSL_MCASP_XINTCTL_XSTAFRM_DISABLE (0x00000000u)
#define CSL_MCASP_XINTCTL_XSTAFRM_ENABLE (0x00000001u)


#define CSL_MCASP_XINTCTL_XDATA_MASK (0x00000020u)
#define CSL_MCASP_XINTCTL_XDATA_SHIFT (0x00000005u)
#define CSL_MCASP_XINTCTL_XDATA_RESETVAL (0x00000000u)
/*----XDATA Tokens----*/
#define CSL_MCASP_XINTCTL_XDATA_DISABLE (0x00000000u)
#define CSL_MCASP_XINTCTL_XDATA_ENABLE (0x00000001u)

#define CSL_MCASP_XINTCTL_XLAST_MASK (0x00000010u)
#define CSL_MCASP_XINTCTL_XLAST_SHIFT (0x00000004u)
#define CSL_MCASP_XINTCTL_XLAST_RESETVAL (0x00000000u)
/*----XLAST Tokens----*/
#define CSL_MCASP_XINTCTL_XLAST_DISABLE (0x00000000u)
#define CSL_MCASP_XINTCTL_XLAST_ENABLE (0x00000001u)

#define CSL_MCASP_XINTCTL_XDMAERR_MASK (0x00000008u)
#define CSL_MCASP_XINTCTL_XDMAERR_SHIFT (0x00000003u)
#define CSL_MCASP_XINTCTL_XDMAERR_RESETVAL (0x00000000u)
/*----XDMAERR Tokens----*/
#define CSL_MCASP_XINTCTL_XDMAERR_DISABLE (0x00000000u)
#define CSL_MCASP_XINTCTL_XDMAERR_ENABLE (0x00000001u)

#define CSL_MCASP_XINTCTL_XCKFAIL_MASK (0x00000004u)
#define CSL_MCASP_XINTCTL_XCKFAIL_SHIFT (0x00000002u)
#define CSL_MCASP_XINTCTL_XCKFAIL_RESETVAL (0x00000000u)
/*----XCKFAIL Tokens----*/
#define CSL_MCASP_XINTCTL_XCKFAIL_DISABLE (0x00000000u)
#define CSL_MCASP_XINTCTL_XCKFAIL_ENABLE (0x00000001u)

#define CSL_MCASP_XINTCTL_XSYNCERR_MASK (0x00000002u)
#define CSL_MCASP_XINTCTL_XSYNCERR_SHIFT (0x00000001u)
#define CSL_MCASP_XINTCTL_XSYNCERR_RESETVAL (0x00000000u)
/*----XSYNCERR Tokens----*/
#define CSL_MCASP_XINTCTL_XSYNCERR_DISABLE (0x00000000u)
#define CSL_MCASP_XINTCTL_XSYNCERR_ENABLE (0x00000001u)

#define CSL_MCASP_XINTCTL_XUNDRN_MASK (0x00000001u)
#define CSL_MCASP_XINTCTL_XUNDRN_SHIFT (0x00000000u)
#define CSL_MCASP_XINTCTL_XUNDRN_RESETVAL (0x00000000u)
/*----XUNDRN Tokens----*/
#define CSL_MCASP_XINTCTL_XUNDRN_DISABLE (0x00000000u)
#define CSL_MCASP_XINTCTL_XUNDRN_ENABLE (0x00000001u)

#define CSL_MCASP_XINTCTL_RESETVAL (0x00000000u)

/* XSTAT */


#define CSL_MCASP_XSTAT_XERR_MASK (0x00000100u)
#define CSL_MCASP_XSTAT_XERR_SHIFT (0x00000008u)
#define CSL_MCASP_XSTAT_XERR_RESETVAL (0x00000000u)
/*----XERR Tokens----*/
#define CSL_MCASP_XSTAT_XERR_NOERROR (0x00000000u)
#define CSL_MCASP_XSTAT_XERR_ERROR (0x00000001u)

#define CSL_MCASP_XSTAT_XDMAERR_MASK (0x00000080u)
#define CSL_MCASP_XSTAT_XDMAERR_SHIFT (0x00000007u)
#define CSL_MCASP_XSTAT_XDMAERR_RESETVAL (0x00000000u)
/*----XDMAERR Tokens----*/
#define CSL_MCASP_XSTAT_XDMAERR_NOERROR (0x00000000u)
#define CSL_MCASP_XSTAT_XDMAERR_ERROR (0x00000001u)

#define CSL_MCASP_XSTAT_XSTAFRM_MASK (0x00000040u)
#define CSL_MCASP_XSTAT_XSTAFRM_SHIFT (0x00000006u)
#define CSL_MCASP_XSTAT_XSTAFRM_RESETVAL (0x00000000u)
/*----XSTAFRM Tokens----*/
#define CSL_MCASP_XSTAT_XSTAFRM_NO (0x00000000u)
#define CSL_MCASP_XSTAT_XSTAFRM_YES (0x00000001u)

#define CSL_MCASP_XSTAT_XDATA_MASK (0x00000020u)
#define CSL_MCASP_XSTAT_XDATA_SHIFT (0x00000005u)
#define CSL_MCASP_XSTAT_XDATA_RESETVAL (0x00000000u)
/*----XDATA Tokens----*/
#define CSL_MCASP_XSTAT_XDATA_NO (0x00000000u)
#define CSL_MCASP_XSTAT_XDATA_YES (0x00000001u)

#define CSL_MCASP_XSTAT_XLAST_MASK (0x00000010u)
#define CSL_MCASP_XSTAT_XLAST_SHIFT (0x00000004u)
#define CSL_MCASP_XSTAT_XLAST_RESETVAL (0x00000000u)
/*----XLAST Tokens----*/
#define CSL_MCASP_XSTAT_XLAST_NO (0x00000000u)
#define CSL_MCASP_XSTAT_XLAST_YES (0x00000001u)

#define CSL_MCASP_XSTAT_XTDMSLOT_MASK (0x00000008u)
#define CSL_MCASP_XSTAT_XTDMSLOT_SHIFT (0x00000003u)
#define CSL_MCASP_XSTAT_XTDMSLOT_RESETVAL (0x00000000u)
/*----XTDMSLOT Tokens----*/
#define CSL_MCASP_XSTAT_XTDMSLOT_ODD (0x00000000u)
#define CSL_MCASP_XSTAT_XTDMSLOT_EVEN (0x00000001u)

#define CSL_MCASP_XSTAT_XCKFAIL_MASK (0x00000004u)
#define CSL_MCASP_XSTAT_XCKFAIL_SHIFT (0x00000002u)
#define CSL_MCASP_XSTAT_XCKFAIL_RESETVAL (0x00000000u)
/*----XCKFAIL Tokens----*/
#define CSL_MCASP_XSTAT_XCKFAIL_NO (0x00000000u)
#define CSL_MCASP_XSTAT_XCKFAIL_YES (0x00000001u)

#define CSL_MCASP_XSTAT_XSYNCERR_MASK (0x00000002u)
#define CSL_MCASP_XSTAT_XSYNCERR_SHIFT (0x00000001u)
#define CSL_MCASP_XSTAT_XSYNCERR_RESETVAL (0x00000000u)
/*----XSYNCERR Tokens----*/
#define CSL_MCASP_XSTAT_XSYNCERR_NO (0x00000000u)
#define CSL_MCASP_XSTAT_XSYNCERR_YES (0x00000001u)

#define CSL_MCASP_XSTAT_XUNDRN_MASK (0x00000001u)
#define CSL_MCASP_XSTAT_XUNDRN_SHIFT (0x00000000u)
#define CSL_MCASP_XSTAT_XUNDRN_RESETVAL (0x00000000u)
/*----XUNDRN Tokens----*/
#define CSL_MCASP_XSTAT_XUNDRN_NO (0x00000000u)
#define CSL_MCASP_XSTAT_XUNDRN_YES (0x00000001u)

#define CSL_MCASP_XSTAT_RESETVAL (0x00000000u)

/* XSLOT */


#define CSL_MCASP_XSLOT_XSLOTCNT_MASK (0x000003FFu)
#define CSL_MCASP_XSLOT_XSLOTCNT_SHIFT (0x00000000u)
#define CSL_MCASP_XSLOT_XSLOTCNT_RESETVAL (0x0000017Fu)

#define CSL_MCASP_XSLOT_RESETVAL (0x0000017Fu)

/* XCLKCHK */

#define CSL_MCASP_XCLKCHK_XCNT_MASK (0xFF000000u)
#define CSL_MCASP_XCLKCHK_XCNT_SHIFT (0x00000018u)
#define CSL_MCASP_XCLKCHK_XCNT_RESETVAL (0x00000000u)

#define CSL_MCASP_XCLKCHK_XMAX_MASK (0x00FF0000u)
#define CSL_MCASP_XCLKCHK_XMAX_SHIFT (0x00000010u)
#define CSL_MCASP_XCLKCHK_XMAX_RESETVAL (0x00000000u)

#define CSL_MCASP_XCLKCHK_XMIN_MASK (0x0000FF00u)
#define CSL_MCASP_XCLKCHK_XMIN_SHIFT (0x00000008u)
#define CSL_MCASP_XCLKCHK_XMIN_RESETVAL (0x00000000u)



#define CSL_MCASP_XCLKCHK_XPS_MASK (0x0000000Fu)
#define CSL_MCASP_XCLKCHK_XPS_SHIFT (0x00000000u)
#define CSL_MCASP_XCLKCHK_XPS_RESETVAL (0x00000000u)
/*----XPS Tokens----*/
#define CSL_MCASP_XCLKCHK_XPS_DIVBY1 (0x00000000u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY2 (0x00000001u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY4 (0x00000002u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY8 (0x00000003u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY16 (0x00000004u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY32 (0x00000005u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY64 (0x00000006u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY128 (0x00000007u)
#define CSL_MCASP_XCLKCHK_XPS_DIVBY256 (0x00000008u)

#define CSL_MCASP_XCLKCHK_RESETVAL (0x00000000u)

/* XEVTCTL */


#define CSL_MCASP_XEVTCTL_XDATDMA_MASK (0x00000001u)
#define CSL_MCASP_XEVTCTL_XDATDMA_SHIFT (0x00000000u)
#define CSL_MCASP_XEVTCTL_XDATDMA_RESETVAL (0x00000000u)
/*----XDATDMA Tokens----*/
#define CSL_MCASP_XEVTCTL_XDATDMA_ENABLE (0x00000000u)
#define CSL_MCASP_XEVTCTL_XDATDMA_RSV (0x00000001u)

#define CSL_MCASP_XEVTCTL_RESETVAL (0x00000000u)

/* DITCSRA0 */

#define CSL_MCASP_DITCSRA0_DITCSRA0_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRA0_DITCSRA0_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRA0_DITCSRA0_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRA0_RESETVAL (0x00000000u)

/* DITCSRA1 */

#define CSL_MCASP_DITCSRA1_DITCSRA1_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRA1_DITCSRA1_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRA1_DITCSRA1_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRA1_RESETVAL (0x00000000u)

/* DITCSRA2 */

#define CSL_MCASP_DITCSRA2_DITCSRA2_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRA2_DITCSRA2_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRA2_DITCSRA2_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRA2_RESETVAL (0x00000000u)

/* DITCSRA3 */

#define CSL_MCASP_DITCSRA3_DITCSRA3_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRA3_DITCSRA3_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRA3_DITCSRA3_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRA3_RESETVAL (0x00000000u)

/* DITCSRA4 */

#define CSL_MCASP_DITCSRA4_DITCSRA4_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRA4_DITCSRA4_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRA4_DITCSRA4_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRA4_RESETVAL (0x00000000u)

/* DITCSRA5 */

#define CSL_MCASP_DITCSRA5_DITCSRA5_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRA5_DITCSRA5_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRA5_DITCSRA5_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRA5_RESETVAL (0x00000000u)

/* DITCSRB0 */

#define CSL_MCASP_DITCSRB0_DITCSRB0_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRB0_DITCSRB0_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRB0_DITCSRB0_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRB0_RESETVAL (0x00000000u)

/* DITCSRB1 */

#define CSL_MCASP_DITCSRB1_DITCSRB1_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRB1_DITCSRB1_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRB1_DITCSRB1_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRB1_RESETVAL (0x00000000u)

/* DITCSRB2 */

#define CSL_MCASP_DITCSRB2_DITCSRB2_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRB2_DITCSRB2_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRB2_DITCSRB2_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRB2_RESETVAL (0x00000000u)

/* DITCSRB3 */

#define CSL_MCASP_DITCSRB3_DITCSRB3_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRB3_DITCSRB3_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRB3_DITCSRB3_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRB3_RESETVAL (0x00000000u)

/* DITCSRB4 */

#define CSL_MCASP_DITCSRB4_DITCSRB4_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRB4_DITCSRB4_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRB4_DITCSRB4_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRB4_RESETVAL (0x00000000u)

/* DITCSRB5 */

#define CSL_MCASP_DITCSRB5_DITCSRB5_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITCSRB5_DITCSRB5_SHIFT (0x00000000u)
#define CSL_MCASP_DITCSRB5_DITCSRB5_RESETVAL (0x00000000u)

#define CSL_MCASP_DITCSRB5_RESETVAL (0x00000000u)

/* DITUDRA0 */

#define CSL_MCASP_DITUDRA0_DITUDRA0_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRA0_DITUDRA0_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRA0_DITUDRA0_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRA0_RESETVAL (0x00000000u)

/* DITUDRA1 */

#define CSL_MCASP_DITUDRA1_DITUDRA1_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRA1_DITUDRA1_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRA1_DITUDRA1_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRA1_RESETVAL (0x00000000u)

/* DITUDRA2 */

#define CSL_MCASP_DITUDRA2_DITUDRA2_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRA2_DITUDRA2_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRA2_DITUDRA2_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRA2_RESETVAL (0x00000000u)

/* DITUDRA3 */

#define CSL_MCASP_DITUDRA3_DITUDRA3_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRA3_DITUDRA3_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRA3_DITUDRA3_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRA3_RESETVAL (0x00000000u)

/* DITUDRA4 */

#define CSL_MCASP_DITUDRA4_DITUDRA4_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRA4_DITUDRA4_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRA4_DITUDRA4_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRA4_RESETVAL (0x00000000u)

/* DITUDRA5 */

#define CSL_MCASP_DITUDRA5_DITUDRA5_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRA5_DITUDRA5_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRA5_DITUDRA5_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRA5_RESETVAL (0x00000000u)

/* DITUDRB0 */

#define CSL_MCASP_DITUDRB0_DITUDRB0_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRB0_DITUDRB0_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRB0_DITUDRB0_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRB0_RESETVAL (0x00000000u)

/* DITUDRB1 */

#define CSL_MCASP_DITUDRB1_DITUDRB1_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRB1_DITUDRB1_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRB1_DITUDRB1_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRB1_RESETVAL (0x00000000u)

/* DITUDRB2 */

#define CSL_MCASP_DITUDRB2_DITUDRB2_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRB2_DITUDRB2_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRB2_DITUDRB2_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRB2_RESETVAL (0x00000000u)

/* DITUDRB3 */

#define CSL_MCASP_DITUDRB3_DITUDRB3_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRB3_DITUDRB3_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRB3_DITUDRB3_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRB3_RESETVAL (0x00000000u)

/* DITUDRB4 */

#define CSL_MCASP_DITUDRB4_DITUDRB4_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRB4_DITUDRB4_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRB4_DITUDRB4_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRB4_RESETVAL (0x00000000u)

/* DITUDRB5 */

#define CSL_MCASP_DITUDRB5_DITUDRB5_MASK (0xFFFFFFFFu)
#define CSL_MCASP_DITUDRB5_DITUDRB5_SHIFT (0x00000000u)
#define CSL_MCASP_DITUDRB5_DITUDRB5_RESETVAL (0x00000000u)

#define CSL_MCASP_DITUDRB5_RESETVAL (0x00000000u)

/* SRCTL0 */


#define CSL_MCASP_SRCTL0_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL0_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL0_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL0_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL0_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL0_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL0_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL0_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL0_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL0_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL0_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL0_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL0_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL0_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL0_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL0_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL0_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL0_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL0_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL0_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL0_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL0_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL0_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL0_RESETVAL (0x00000000u)

/* SRCTL1 */


#define CSL_MCASP_SRCTL1_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL1_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL1_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL1_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL1_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL1_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL1_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL1_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL1_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL1_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL1_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL1_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL1_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL1_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL1_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL1_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL1_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL1_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL1_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL1_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL1_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL1_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL1_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL1_RESETVAL (0x00000000u)

/* SRCTL2 */


#define CSL_MCASP_SRCTL2_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL2_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL2_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL2_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL2_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL2_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL2_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL2_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL2_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL2_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL2_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL2_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL2_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL2_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL2_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL2_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL2_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL2_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL2_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL2_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL2_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL2_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL2_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL2_RESETVAL (0x00000000u)

/* SRCTL3 */


#define CSL_MCASP_SRCTL3_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL3_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL3_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL3_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL3_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL3_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL3_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL3_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL3_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL3_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL3_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL3_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL3_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL3_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL3_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL3_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL3_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL3_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL3_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL3_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL3_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL3_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL3_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL3_RESETVAL (0x00000000u)

/* SRCTL4 */


#define CSL_MCASP_SRCTL4_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL4_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL4_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL4_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL4_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL4_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL4_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL4_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL4_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL4_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL4_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL4_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL4_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL4_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL4_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL4_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL4_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL4_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL4_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL4_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL4_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL4_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL4_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL4_RESETVAL (0x00000000u)

/* SRCTL5 */


#define CSL_MCASP_SRCTL5_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL5_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL5_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL5_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL5_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL5_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL5_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL5_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL5_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL5_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL5_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL5_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL5_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL5_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL5_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL5_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL5_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL5_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL5_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL5_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL5_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL5_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL5_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL5_RESETVAL (0x00000000u)

/* SRCTL6 */


#define CSL_MCASP_SRCTL6_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL6_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL6_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL6_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL6_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL6_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL6_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL6_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL6_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL6_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL6_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL6_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL6_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL6_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL6_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL6_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL6_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL6_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL6_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL6_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL6_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL6_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL6_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL6_RESETVAL (0x00000000u)

/* SRCTL7 */


#define CSL_MCASP_SRCTL7_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL7_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL7_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL7_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL7_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL7_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL7_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL7_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL7_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL7_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL7_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL7_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL7_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL7_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL7_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL7_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL7_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL7_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL7_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL7_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL7_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL7_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL7_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL7_RESETVAL (0x00000000u)

/* SRCTL8 */


#define CSL_MCASP_SRCTL8_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL8_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL8_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL8_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL8_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL8_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL8_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL8_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL8_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL8_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL8_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL8_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL8_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL8_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL8_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL8_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL8_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL8_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL8_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL8_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL8_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL8_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL8_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL8_RESETVAL (0x00000000u)

/* SRCTL9 */


#define CSL_MCASP_SRCTL9_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL9_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL9_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL9_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL9_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL9_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL9_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL9_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL9_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL9_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL9_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL9_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL9_DISMOD_RESETVAL (0x00000000u)
/*----DISMOD Tokens----*/
#define CSL_MCASP_SRCTL9_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL9_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL9_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL9_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL9_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL9_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL9_SRMOD_RESETVAL (0x00000000u)
/*----SRMOD Tokens----*/
#define CSL_MCASP_SRCTL9_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL9_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL9_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL9_RESETVAL (0x00000000u)
/* SRCTL10 */


#define CSL_MCASP_SRCTL10_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL10_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL10_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL10_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL10_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL10_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL10_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL10_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL10_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL10_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL10_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL10_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL10_DISMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL10_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL10_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL10_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL10_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL10_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL10_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL10_SRMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL10_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL10_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL10_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL10_RESETVAL (0x00000000u)

/* SRCTL11 */


#define CSL_MCASP_SRCTL11_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL11_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL11_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL11_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL11_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL11_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL11_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL11_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL11_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL11_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL11_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL11_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL11_DISMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL11_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL11_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL11_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL11_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL11_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL11_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL11_SRMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL11_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL11_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL11_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL11_RESETVAL (0x00000000u)

/* SRCTL12 */


#define CSL_MCASP_SRCTL12_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL12_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL12_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL12_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL12_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL12_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL12_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL12_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL12_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL12_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL12_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL12_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL12_DISMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL12_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL12_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL12_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL12_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL12_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL12_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL12_SRMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL12_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL12_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL12_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL12_RESETVAL (0x00000000u)

/* SRCTL13 */


#define CSL_MCASP_SRCTL13_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL13_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL13_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL13_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL13_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL13_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL13_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL13_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL13_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL13_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL13_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL13_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL13_DISMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL13_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL13_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL13_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL13_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL13_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL13_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL13_SRMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL13_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL13_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL13_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL13_RESETVAL (0x00000000u)

/* SRCTL14 */


#define CSL_MCASP_SRCTL14_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL14_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL14_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL14_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL14_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL14_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL14_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL14_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL14_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL14_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL14_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL14_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL14_DISMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL14_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL14_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL14_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL14_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL14_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL14_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL14_SRMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL14_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL14_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL14_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL14_RESETVAL (0x00000000u)

/* SRCTL15 */


#define CSL_MCASP_SRCTL15_RRDY_MASK (0x00000020u)
#define CSL_MCASP_SRCTL15_RRDY_SHIFT (0x00000005u)
#define CSL_MCASP_SRCTL15_RRDY_RESETVAL (0x00000000u)
/*----RRDY Tokens----*/
#define CSL_MCASP_SRCTL15_RRDY_EMPTY (0x00000000u)
#define CSL_MCASP_SRCTL15_RRDY_DATA (0x00000001u)

#define CSL_MCASP_SRCTL15_XRDY_MASK (0x00000010u)
#define CSL_MCASP_SRCTL15_XRDY_SHIFT (0x00000004u)
#define CSL_MCASP_SRCTL15_XRDY_RESETVAL (0x00000000u)
/*----XRDY Tokens----*/
#define CSL_MCASP_SRCTL15_XRDY_DATA (0x00000000u)
#define CSL_MCASP_SRCTL15_XRDY_EMPTY (0x00000001u)

#define CSL_MCASP_SRCTL15_DISMOD_MASK (0x0000000Cu)
#define CSL_MCASP_SRCTL15_DISMOD_SHIFT (0x00000002u)
#define CSL_MCASP_SRCTL15_DISMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL15_DISMOD_3STATE (0x00000000u)
#define CSL_MCASP_SRCTL15_DISMOD_RSV (0x00000001u)
#define CSL_MCASP_SRCTL15_DISMOD_LOW (0x00000002u)
#define CSL_MCASP_SRCTL15_DISMOD_HIGH (0x00000003u)

#define CSL_MCASP_SRCTL15_SRMOD_MASK (0x00000003u)
#define CSL_MCASP_SRCTL15_SRMOD_SHIFT (0x00000000u)
#define CSL_MCASP_SRCTL15_SRMOD_RESETVAL (0x00000000u)
#define CSL_MCASP_SRCTL15_SRMOD_INACTIVE (0x00000000u)
#define CSL_MCASP_SRCTL15_SRMOD_XMT (0x00000001u)
#define CSL_MCASP_SRCTL15_SRMOD_RCV (0x00000002u)

#define CSL_MCASP_SRCTL15_RESETVAL (0x00000000u)

/* XBUF0 */

#define CSL_MCASP_XBUF0_XBUF0_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF0_XBUF0_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF0_XBUF0_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF0_RESETVAL (0x00000000u)

/* XBUF1 */

#define CSL_MCASP_XBUF1_XBUF1_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF1_XBUF1_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF1_XBUF1_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF1_RESETVAL (0x00000000u)

/* XBUF2 */

#define CSL_MCASP_XBUF2_XBUF2_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF2_XBUF2_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF2_XBUF2_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF2_RESETVAL (0x00000000u)

/* XBUF3 */

#define CSL_MCASP_XBUF3_XBUF3_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF3_XBUF3_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF3_XBUF3_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF3_RESETVAL (0x00000000u)

/* XBUF4 */

#define CSL_MCASP_XBUF4_XBUF4_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF4_XBUF4_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF4_XBUF4_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF4_RESETVAL (0x00000000u)

/* XBUF5 */

#define CSL_MCASP_XBUF5_XBUF5_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF5_XBUF5_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF5_XBUF5_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF5_RESETVAL (0x00000000u)

/* XBUF6 */

#define CSL_MCASP_XBUF6_XBUF6_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF6_XBUF6_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF6_XBUF6_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF6_RESETVAL (0x00000000u)

/* XBUF7 */

#define CSL_MCASP_XBUF7_XBUF7_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF7_XBUF7_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF7_XBUF7_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF7_RESETVAL (0x00000000u)

/* XBUF8 */

#define CSL_MCASP_XBUF8_XBUF8_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF8_XBUF8_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF8_XBUF8_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF8_RESETVAL (0x00000000u)

/* XBUF9 */

#define CSL_MCASP_XBUF9_XBUF9_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF9_XBUF9_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF9_XBUF9_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF9_RESETVAL (0x00000000u)

/* XBUF10 */

#define CSL_MCASP_XBUF10_XBUF10_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF10_XBUF10_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF10_XBUF10_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF10_RESETVAL (0x00000000u)

/* XBUF11 */

#define CSL_MCASP_XBUF11_XBUF11_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF11_XBUF11_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF11_XBUF11_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF11_RESETVAL (0x00000000u)

/* XBUF12 */

#define CSL_MCASP_XBUF12_XBUF12_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF12_XBUF12_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF12_XBUF12_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF12_RESETVAL (0x00000000u)

/* XBUF13 */

#define CSL_MCASP_XBUF13_XBUF13_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF13_XBUF13_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF13_XBUF13_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF13_RESETVAL (0x00000000u)

/* XBUF14 */

#define CSL_MCASP_XBUF14_XBUF14_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF14_XBUF14_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF14_XBUF14_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF14_RESETVAL (0x00000000u)

/* XBUF15 */

#define CSL_MCASP_XBUF15_XBUF15_MASK (0xFFFFFFFFu)
#define CSL_MCASP_XBUF15_XBUF15_SHIFT (0x00000000u)
#define CSL_MCASP_XBUF15_XBUF15_RESETVAL (0x00000000u)

#define CSL_MCASP_XBUF15_RESETVAL (0x00000000u)
/* RBUF0 */

#define CSL_MCASP_RBUF0_RBUF0_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF0_RBUF0_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF0_RBUF0_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF0_RESETVAL (0x00000000u)

/* RBUF1 */

#define CSL_MCASP_RBUF1_RBUF1_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF1_RBUF1_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF1_RBUF1_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF1_RESETVAL (0x00000000u)

/* RBUF2 */

#define CSL_MCASP_RBUF2_RBUF2_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF2_RBUF2_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF2_RBUF2_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF2_RESETVAL (0x00000000u)

/* RBUF3 */

#define CSL_MCASP_RBUF3_RBUF3_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF3_RBUF3_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF3_RBUF3_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF3_RESETVAL (0x00000000u)

/* RBUF4 */

#define CSL_MCASP_RBUF4_RBUF4_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF4_RBUF4_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF4_RBUF4_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF4_RESETVAL (0x00000000u)

/* RBUF5 */

#define CSL_MCASP_RBUF5_RBUF5_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF5_RBUF5_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF5_RBUF5_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF5_RESETVAL (0x00000000u)

/* RBUF6 */

#define CSL_MCASP_RBUF6_RBUF6_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF6_RBUF6_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF6_RBUF6_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF6_RESETVAL (0x00000000u)

/* RBUF7 */

#define CSL_MCASP_RBUF7_RBUF7_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF7_RBUF7_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF7_RBUF7_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF7_RESETVAL (0x00000000u)

/* RBUF8 */

#define CSL_MCASP_RBUF8_RBUF8_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF8_RBUF8_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF8_RBUF8_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF8_RESETVAL (0x00000000u)

/* RBUF9 */

#define CSL_MCASP_RBUF9_RBUF9_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF9_RBUF9_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF9_RBUF9_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF9_RESETVAL (0x00000000u)

/* RBUF10 */

#define CSL_MCASP_RBUF10_RBUF10_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF10_RBUF10_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF10_RBUF10_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF10_RESETVAL (0x00000000u)

/* RBUF11 */

#define CSL_MCASP_RBUF11_RBUF11_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF11_RBUF11_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF11_RBUF11_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF11_RESETVAL (0x00000000u)

/* RBUF12 */

#define CSL_MCASP_RBUF12_RBUF12_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF12_RBUF12_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF12_RBUF12_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF12_RESETVAL (0x00000000u)

/* RBUF13 */

#define CSL_MCASP_RBUF13_RBUF13_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF13_RBUF13_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF13_RBUF13_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF13_RESETVAL (0x00000000u)

/* RBUF14 */

#define CSL_MCASP_RBUF14_RBUF14_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF14_RBUF14_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF14_RBUF14_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF14_RESETVAL (0x00000000u)

/* RBUF15 */

#define CSL_MCASP_RBUF15_RBUF15_MASK (0xFFFFFFFFu)
#define CSL_MCASP_RBUF15_RBUF15_SHIFT (0x00000000u)
#define CSL_MCASP_RBUF15_RBUF15_RESETVAL (0x00000000u)

#define CSL_MCASP_RBUF15_RESETVAL (0x00000000u)


/**************************************************************************\
* Field Definition Macros (AFIFO)
\**************************************************************************/

#define CSL_AFIFO_REVID_REV_MASK (0xFFFFFFFFu)
#define CSL_AFIFO_REVID_REV_SHIFT (0x00000000u)
#define CSL_AFIFO_REVID_REV_RESETVAL (0x44311100u)

#define CSL_AFIFO_REVID_RESETVAL (0x44311100u)

/* WFIFOCTL */


#define CSL_AFIFO_WFIFOCTL_WENA_MASK (0x00010000u)
#define CSL_AFIFO_WFIFOCTL_WENA_SHIFT (0x00000010u)
#define CSL_AFIFO_WFIFOCTL_WENA_RESETVAL (0x00000000u)
#define CSL_AFIFO_WFIFOCTL_WENA_DISABLED (0x00000000u)
#define CSL_AFIFO_WFIFOCTL_WENA_ENABLED (0x00000001u)

#define CSL_AFIFO_WFIFOCTL_WNUMEVT_MASK (0x0000FF00u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_SHIFT (0x00000008u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_RESETVAL (0x00000010u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_0WORDS (0x00000000u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_4WORDS (0x00000004u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_8WORDS (0x00000008u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_12WORDS (0x0000000Cu)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_16WORDS (0x00000010u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_20WORDS (0x00000014u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_24WORDS (0x00000018u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_28WORDS (0x0000001Cu)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_32WORDS (0x00000020u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_36WORDS (0x00000024u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_40WORDS (0x00000028u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_44WORDS (0x0000002Cu)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_48WORDS (0x00000030u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_52WORDS (0x00000034u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_56WORDS (0x00000038u)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_60WORDS (0x0000003Cu)
#define CSL_AFIFO_WFIFOCTL_WNUMEVT_64WORDS (0x00000040u)

#define CSL_AFIFO_WFIFOCTL_WNUMDMA_MASK (0x000000FFu)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_SHIFT (0x00000000u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_RESETVAL (0x00000004u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_0WORDS (0x00000000u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_1WORDS (0x00000001u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_2WORDS (0x00000002u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_3WORDS (0x00000003u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_4WORDS (0x00000004u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_5WORDS (0x00000005u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_6WORDS (0x00000006u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_7WORDS (0x00000007u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_8WORDS (0x00000008u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_9WORDS (0x00000009u)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_10WORDS (0x0000000Au)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_11WORDS (0x0000000Bu)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_12WORDS (0x0000000Cu)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_13WORDS (0x0000000Du)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_14WORDS (0x0000000Eu)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_15WORDS (0x0000000Fu)
#define CSL_AFIFO_WFIFOCTL_WNUMDMA_16WORDS (0x00000010u)

#define CSL_AFIFO_WFIFOCTL_RESETVAL (0x00001004u)

/* WFIFOSTS */


#define CSL_AFIFO_WFIFOSTS_WLVL_MASK (0x000000FFu)
#define CSL_AFIFO_WFIFOSTS_WLVL_SHIFT (0x00000000u)
#define CSL_AFIFO_WFIFOSTS_WLVL_RESETVAL (0x00000000u)

#define CSL_AFIFO_WFIFOSTS_RESETVAL (0x00000000u)

/* RFIFOCTL */


#define CSL_AFIFO_RFIFOCTL_RENA_MASK (0x00010000u)
#define CSL_AFIFO_RFIFOCTL_RENA_SHIFT (0x00000010u)
#define CSL_AFIFO_RFIFOCTL_RENA_RESETVAL (0x00000000u)
#define CSL_AFIFO_RFIFOCTL_RENA_DISABLED (0x00000000u)
#define CSL_AFIFO_RFIFOCTL_RENA_ENABLED (0x00000001u)

#define CSL_AFIFO_RFIFOCTL_RNUMEVT_MASK (0x0000FF00u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_SHIFT (0x00000008u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_RESETVAL (0x00000010u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_0WORDS (0x00000000u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_4WORDS (0x00000004u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_8WORDS (0x00000008u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_12WORDS (0x0000000Cu)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_16WORDS (0x00000010u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_20WORDS (0x00000014u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_24WORDS (0x00000018u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_28WORDS (0x0000001Cu)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_32WORDS (0x00000020u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_36WORDS (0x00000024u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_40WORDS (0x00000028u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_44WORDS (0x0000002Cu)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_48WORDS (0x00000030u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_52WORDS (0x00000034u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_56WORDS (0x00000038u)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_60WORDS (0x0000003Cu)
#define CSL_AFIFO_RFIFOCTL_RNUMEVT_64WORDS (0x00000040u)

#define CSL_AFIFO_RFIFOCTL_RNUMDMA_MASK (0x000000FFu)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_SHIFT (0x00000000u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_RESETVAL (0x00000004u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_0WORDS (0x00000000u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_1WORDS (0x00000001u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_2WORDS (0x00000002u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_3WORDS (0x00000003u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_4WORDS (0x00000004u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_5WORDS (0x00000005u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_6WORDS (0x00000006u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_7WORDS (0x00000007u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_8WORDS (0x00000008u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_9WORDS (0x00000009u)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_10WORDS (0x0000000Au)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_11WORDS (0x0000000Bu)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_12WORDS (0x0000000Cu)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_13WORDS (0x0000000Du)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_14WORDS (0x0000000Eu)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_15WORDS (0x0000000Fu)
#define CSL_AFIFO_RFIFOCTL_RNUMDMA_16WORDS (0x00000010u)

#define CSL_AFIFO_RFIFOCTL_RESETVAL (0x00001004u)

/* RFIFOSTS */


#define CSL_AFIFO_RFIFOSTS_RLVL_MASK (0x000000FFu)
#define CSL_AFIFO_RFIFOSTS_RLVL_SHIFT (0x00000000u)
#define CSL_AFIFO_RFIFOSTS_RLVL_RESETVAL (0x00000000u)

#define CSL_AFIFO_RFIFOSTS_RESETVAL (0x00000000u)
#endif

