/*
 * cslr_usb_ohci.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


#ifndef _CSLR_OHCI_H_
#define _CSLR_OHCI_H_

#include <ti/pspiom/cslr/cslr.h>

#include <ti/pspiom/cslr/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 HCCONTROL;
    volatile Uint32 HCCOMMANDSTATUS;
    volatile Uint32 HCINTERRUPTSTATUS;
    volatile Uint32 HCINTERRUPTENABLE;
    volatile Uint32 HCINTERRUPTDISABLE;
    volatile Uint32 HCHCCA;
    volatile Uint32 HCPERIODCURRENTED;
    volatile Uint32 HCCONTROLHEADED;
    volatile Uint32 HCCONTROLCURRENTED;
    volatile Uint32 HCBULKHEADED;
    volatile Uint32 HCBULKCURRENTED;
    volatile Uint32 HCDONEHEAD;
    volatile Uint32 HCFMINTERVAL;
    volatile Uint32 HCFMREMAINING;
    volatile Uint32 HCFMNUMBER;
    volatile Uint32 HCPERIODICSTART;
    volatile Uint32 HCLSTHRESHOLD;
    volatile Uint32 HCRHDESCRIPTORA;
    volatile Uint32 HCRHDESCRIPTORB;
    volatile Uint32 HCRHSTATUS;
    volatile Uint32 HCRHPORTSTATUS;
} CSL_OhciRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_OhciRegs             *CSL_OhciRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define CSL_OHCI_REVID_REV_MASK     (0xFFFFFFFFu)
#define CSL_OHCI_REVID_REV_SHIFT    (0x00000000u)
#define CSL_OHCI_REVID_REV_RESETVAL (0x00000010u)

#define CSL_OHCI_REVID_RESETVAL     (0x00000010u)

/* HcControl */

#define CSL_OHCI_HCCONTROL_RESERVED_MASK (0xFFFFF800u)
#define CSL_OHCI_HCCONTROL_RESERVED_SHIFT (0x0000000Bu)
#define CSL_OHCI_HCCONTROL_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCONTROL_RWE_MASK      (0x00000400u)
#define CSL_OHCI_HCCONTROL_RWE_SHIFT     (0x0000000Au)
#define CSL_OHCI_HCCONTROL_RWE_RESETVAL  (0x00000000u)
/*----RWE Tokens----*/
#define CSL_OHCI_HCCONTROL_RWE_ENABLE    (0x00000001u)
#define CSL_OHCI_HCCONTROL_RWE_DISABLE   (0x00000000u)

#define CSL_OHCI_HCCONTROL_RWC_MASK      (0x00000200u)
#define CSL_OHCI_HCCONTROL_RWC_SHIFT     (0x00000009u)
#define CSL_OHCI_HCCONTROL_RWC_RESETVAL  (0x00000000u)
/*----RWC Tokens----*/
#define CSL_OHCI_HCCONTROL_RWC_ENABLE    (0x00000001u)
#define CSL_OHCI_HCCONTROL_RWC_DISABLE   (0x00000000u)

#define CSL_OHCI_HCCONTROL_IR_MASK       (0x00000100u)
#define CSL_OHCI_HCCONTROL_IR_SHIFT      (0x00000008u)
#define CSL_OHCI_HCCONTROL_IR_RESETVAL   (0x00000000u)
/*----IR Tokens----*/
#define CSL_OHCI_HCCONTROL_IR_SMINT      (0x00000001u)
#define CSL_OHCI_HCCONTROL_IR_HOSTINT    (0x00000000u)

#define CSL_OHCI_HCCONTROL_HCFS_MASK     (0x000000C0u)
#define CSL_OHCI_HCCONTROL_HCFS_SHIFT    (0x00000006u)
#define CSL_OHCI_HCCONTROL_HCFS_RESETVAL (0x00000000u)
/*----HCFS Tokens----*/
#define CSL_OHCI_HCCONTROL_HCFS_USBRESET (0x00000000u)
#define CSL_OHCI_HCCONTROL_HCFS_USBRESUME (0x00000001u)
#define CSL_OHCI_HCCONTROL_HCFS_USBOPERATIONAL (0x00000002u)
#define CSL_OHCI_HCCONTROL_HCFS_USBSUSPEND (0x00000003u)

#define CSL_OHCI_HCCONTROL_BLE_MASK      (0x00000020u)
#define CSL_OHCI_HCCONTROL_BLE_SHIFT     (0x00000005u)
#define CSL_OHCI_HCCONTROL_BLE_RESETVAL  (0x00000000u)
/*----BLE Tokens----*/
#define CSL_OHCI_HCCONTROL_BLE_ENABLE    (0x00000001u)
#define CSL_OHCI_HCCONTROL_BLE_DISABLE   (0x00000000u)

#define CSL_OHCI_HCCONTROL_CLE_MASK      (0x00000010u)
#define CSL_OHCI_HCCONTROL_CLE_SHIFT     (0x00000004u)
#define CSL_OHCI_HCCONTROL_CLE_RESETVAL  (0x00000000u)
/*----CLE Tokens----*/
#define CSL_OHCI_HCCONTROL_CLE_ENABLE    (0x00000001u)
#define CSL_OHCI_HCCONTROL_CLE_DISABLE   (0x00000000u)

#define CSL_OHCI_HCCONTROL_IE_MASK       (0x00000008u)
#define CSL_OHCI_HCCONTROL_IE_SHIFT      (0x00000003u)
#define CSL_OHCI_HCCONTROL_IE_RESETVAL   (0x00000000u)
/*----IE Tokens----*/
#define CSL_OHCI_HCCONTROL_IE_ENABLE     (0x00000001u)
#define CSL_OHCI_HCCONTROL_IE_DISABLE    (0x00000000u)

#define CSL_OHCI_HCCONTROL_PLE_MASK      (0x00000004u)
#define CSL_OHCI_HCCONTROL_PLE_SHIFT     (0x00000002u)
#define CSL_OHCI_HCCONTROL_PLE_RESETVAL  (0x00000000u)
/*----PLE Tokens----*/
#define CSL_OHCI_HCCONTROL_PLE_ENABLE    (0x00000001u)
#define CSL_OHCI_HCCONTROL_PLE_DISABLE   (0x00000000u)

#define CSL_OHCI_HCCONTROL_CBSR_MASK     (0x00000003u)
#define CSL_OHCI_HCCONTROL_CBSR_SHIFT    (0x00000000u)
#define CSL_OHCI_HCCONTROL_CBSR_RESETVAL (0x00000000u)
/*----CBSR Tokens----*/
#define CSL_OHCI_HCCONTROL_CBSR_RATIO11  (0x00000000u)
#define CSL_OHCI_HCCONTROL_CBSR_RATIO21  (0x00000001u)
#define CSL_OHCI_HCCONTROL_CBSR_RATIO31  (0x00000002u)
#define CSL_OHCI_HCCONTROL_CBSR_RATIO41  (0x00000003u)

#define CSL_OHCI_HCCONTROL_RESETVAL      (0x00000000u)

/* HcCommandStatus */

#define CSL_OHCI_HCCOMMANDSTATUS_RESERVED_MASK (0xFFFC0000u)
#define CSL_OHCI_HCCOMMANDSTATUS_RESERVED_SHIFT (0x00000012u)
#define CSL_OHCI_HCCOMMANDSTATUS_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCOMMANDSTATUS_SOC_MASK (0x00030000u)
#define CSL_OHCI_HCCOMMANDSTATUS_SOC_SHIFT (0x00000010u)
#define CSL_OHCI_HCCOMMANDSTATUS_SOC_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCOMMANDSTATUS_RESERVED0_MASK (0x0000FFF0u)
#define CSL_OHCI_HCCOMMANDSTATUS_RESERVED0_SHIFT (0x00000004u)
#define CSL_OHCI_HCCOMMANDSTATUS_RESERVED0_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCOMMANDSTATUS_OCR_MASK (0x00000008u)
#define CSL_OHCI_HCCOMMANDSTATUS_OCR_SHIFT (0x00000003u)
#define CSL_OHCI_HCCOMMANDSTATUS_OCR_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCOMMANDSTATUS_BLF_MASK (0x00000004u)
#define CSL_OHCI_HCCOMMANDSTATUS_BLF_SHIFT (0x00000002u)
#define CSL_OHCI_HCCOMMANDSTATUS_BLF_RESETVAL (0x00000000u)
/*----BLF Tokens----*/
#define CSL_OHCI_HCCOMMANDSTATUS_BLF_SET (0x00000001u)
#define CSL_OHCI_HCCOMMANDSTATUS_BLF_CLEAR (0x00000000u)

#define CSL_OHCI_HCCOMMANDSTATUS_CLF_MASK (0x00000002u)
#define CSL_OHCI_HCCOMMANDSTATUS_CLF_SHIFT (0x00000001u)
#define CSL_OHCI_HCCOMMANDSTATUS_CLF_RESETVAL (0x00000000u)
/*----CLF Tokens----*/
#define CSL_OHCI_HCCOMMANDSTATUS_CLF_SET (0x00000001u)
#define CSL_OHCI_HCCOMMANDSTATUS_CLF_CLEAR (0x00000000u)

#define CSL_OHCI_HCCOMMANDSTATUS_HCR_MASK (0x00000001u)
#define CSL_OHCI_HCCOMMANDSTATUS_HCR_SHIFT (0x00000000u)
#define CSL_OHCI_HCCOMMANDSTATUS_HCR_RESETVAL (0x00000000u)
/*----HCR Tokens----*/
#define CSL_OHCI_HCCOMMANDSTATUS_HCR_SET (0x00000001u)
#define CSL_OHCI_HCCOMMANDSTATUS_HCR_CLEAR (0x00000000u)

#define CSL_OHCI_HCCOMMANDSTATUS_RESETVAL (0x00000000u)

/* HcInterruptStatus */

#define CSL_OHCI_HCINTERRUPTSTATUS_RSVD_MASK (0x80000000u)
#define CSL_OHCI_HCINTERRUPTSTATUS_RSVD_SHIFT (0x0000001Fu)
#define CSL_OHCI_HCINTERRUPTSTATUS_RSVD_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_OC_MASK (0x40000000u)
#define CSL_OHCI_HCINTERRUPTSTATUS_OC_SHIFT (0x0000001Eu)
#define CSL_OHCI_HCINTERRUPTSTATUS_OC_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_RESERVED_MASK (0x3FFFFF80u)
#define CSL_OHCI_HCINTERRUPTSTATUS_RESERVED_SHIFT (0x00000007u)
#define CSL_OHCI_HCINTERRUPTSTATUS_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_RHSC_MASK (0x00000040u)
#define CSL_OHCI_HCINTERRUPTSTATUS_RHSC_SHIFT (0x00000006u)
#define CSL_OHCI_HCINTERRUPTSTATUS_RHSC_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_FNO_MASK (0x00000020u)
#define CSL_OHCI_HCINTERRUPTSTATUS_FNO_SHIFT (0x00000005u)
#define CSL_OHCI_HCINTERRUPTSTATUS_FNO_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_UE_MASK (0x00000010u)
#define CSL_OHCI_HCINTERRUPTSTATUS_UE_SHIFT (0x00000004u)
#define CSL_OHCI_HCINTERRUPTSTATUS_UE_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_RD_MASK (0x00000008u)
#define CSL_OHCI_HCINTERRUPTSTATUS_RD_SHIFT (0x00000003u)
#define CSL_OHCI_HCINTERRUPTSTATUS_RD_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_SF_MASK (0x00000004u)
#define CSL_OHCI_HCINTERRUPTSTATUS_SF_SHIFT (0x00000002u)
#define CSL_OHCI_HCINTERRUPTSTATUS_SF_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_WDH_MASK (0x00000002u)
#define CSL_OHCI_HCINTERRUPTSTATUS_WDH_SHIFT (0x00000001u)
#define CSL_OHCI_HCINTERRUPTSTATUS_WDH_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_SO_MASK (0x00000001u)
#define CSL_OHCI_HCINTERRUPTSTATUS_SO_SHIFT (0x00000000u)
#define CSL_OHCI_HCINTERRUPTSTATUS_SO_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTSTATUS_RESETVAL (0x00000000u)

/* HcInterruptEnable */

#define CSL_OHCI_HCINTERRUPTENABLE_MIE_MASK (0x80000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_MIE_SHIFT (0x0000001Fu)
#define CSL_OHCI_HCINTERRUPTENABLE_MIE_RESETVAL (0x00000000u)
/*----MIE Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_MIE_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_MIE_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_OC_MASK (0x40000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_OC_SHIFT (0x0000001Eu)
#define CSL_OHCI_HCINTERRUPTENABLE_OC_RESETVAL (0x00000000u)
/*----OC Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_OC_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_OC_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_RESERVED_MASK (0x3FFFFF80u)
#define CSL_OHCI_HCINTERRUPTENABLE_RESERVED_SHIFT (0x00000007u)
#define CSL_OHCI_HCINTERRUPTENABLE_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTENABLE_RHSC_MASK (0x00000040u)
#define CSL_OHCI_HCINTERRUPTENABLE_RHSC_SHIFT (0x00000006u)
#define CSL_OHCI_HCINTERRUPTENABLE_RHSC_RESETVAL (0x00000000u)
/*----RHSC Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_RHSC_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_RHSC_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_FNO_MASK (0x00000020u)
#define CSL_OHCI_HCINTERRUPTENABLE_FNO_SHIFT (0x00000005u)
#define CSL_OHCI_HCINTERRUPTENABLE_FNO_RESETVAL (0x00000000u)
/*----FNO Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_FNO_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_FNO_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_UE_MASK (0x00000010u)
#define CSL_OHCI_HCINTERRUPTENABLE_UE_SHIFT (0x00000004u)
#define CSL_OHCI_HCINTERRUPTENABLE_UE_RESETVAL (0x00000000u)
/*----UE Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_UE_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_UE_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_RD_MASK (0x00000008u)
#define CSL_OHCI_HCINTERRUPTENABLE_RD_SHIFT (0x00000003u)
#define CSL_OHCI_HCINTERRUPTENABLE_RD_RESETVAL (0x00000000u)
/*----RD Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_RD_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_RD_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_SF_MASK (0x00000004u)
#define CSL_OHCI_HCINTERRUPTENABLE_SF_SHIFT (0x00000002u)
#define CSL_OHCI_HCINTERRUPTENABLE_SF_RESETVAL (0x00000000u)
/*----SF Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_SF_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_SF_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_WDH_MASK (0x00000002u)
#define CSL_OHCI_HCINTERRUPTENABLE_WDH_SHIFT (0x00000001u)
#define CSL_OHCI_HCINTERRUPTENABLE_WDH_RESETVAL (0x00000000u)
/*----WDH Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_WDH_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_WDH_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_SO_MASK (0x00000001u)
#define CSL_OHCI_HCINTERRUPTENABLE_SO_SHIFT (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_SO_RESETVAL (0x00000000u)
/*----SO Tokens----*/
#define CSL_OHCI_HCINTERRUPTENABLE_SO_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTENABLE_SO_ENABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTENABLE_RESETVAL (0x00000000u)

/* HcInterruptDisable */

#define CSL_OHCI_HCINTERRUPTDISABLE_MIE_MASK (0x80000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_MIE_SHIFT (0x0000001Fu)
#define CSL_OHCI_HCINTERRUPTDISABLE_MIE_RESETVAL (0x00000000u)
/*----MIE Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_MIE_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_MIE_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_OC_MASK (0x40000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_OC_SHIFT (0x0000001Eu)
#define CSL_OHCI_HCINTERRUPTDISABLE_OC_RESETVAL (0x00000000u)
/*----OC Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_OC_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_OC_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_RESERVED_MASK (0x3FFFFF80u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RESERVED_SHIFT (0x00000007u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCINTERRUPTDISABLE_RHSC_MASK (0x00000040u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RHSC_SHIFT (0x00000006u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RHSC_RESETVAL (0x00000000u)
/*----RHSC Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_RHSC_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RHSC_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_FNO_MASK (0x00000020u)
#define CSL_OHCI_HCINTERRUPTDISABLE_FNO_SHIFT (0x00000005u)
#define CSL_OHCI_HCINTERRUPTDISABLE_FNO_RESETVAL (0x00000000u)
/*----FNO Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_FNO_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_FNO_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_UE_MASK (0x00000010u)
#define CSL_OHCI_HCINTERRUPTDISABLE_UE_SHIFT (0x00000004u)
#define CSL_OHCI_HCINTERRUPTDISABLE_UE_RESETVAL (0x00000000u)
/*----UE Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_UE_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_UE_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_RD_MASK (0x00000008u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RD_SHIFT (0x00000003u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RD_RESETVAL (0x00000000u)
/*----RD Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_RD_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_RD_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_SF_MASK (0x00000004u)
#define CSL_OHCI_HCINTERRUPTDISABLE_SF_SHIFT (0x00000002u)
#define CSL_OHCI_HCINTERRUPTDISABLE_SF_RESETVAL (0x00000000u)
/*----SF Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_SF_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_SF_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_WDH_MASK (0x00000002u)
#define CSL_OHCI_HCINTERRUPTDISABLE_WDH_SHIFT (0x00000001u)
#define CSL_OHCI_HCINTERRUPTDISABLE_WDH_RESETVAL (0x00000000u)
/*----WDH Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_WDH_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_WDH_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_SO_MASK (0x00000001u)
#define CSL_OHCI_HCINTERRUPTDISABLE_SO_SHIFT (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_SO_RESETVAL (0x00000000u)
/*----SO Tokens----*/
#define CSL_OHCI_HCINTERRUPTDISABLE_SO_IGNORE (0x00000000u)
#define CSL_OHCI_HCINTERRUPTDISABLE_SO_DISABLE (0x00000001u)

#define CSL_OHCI_HCINTERRUPTDISABLE_RESETVAL (0x00000000u)

/* HcHCCA */

#define CSL_OHCI_HCHCCA_HCCA_MASK        (0xFFFFFF00u)
#define CSL_OHCI_HCHCCA_HCCA_SHIFT       (0x00000008u)
#define CSL_OHCI_HCHCCA_HCCA_RESETVAL    (0x00000000u)

#define CSL_OHCI_HCHCCA_RESERVED_MASK    (0x000000FFu)
#define CSL_OHCI_HCHCCA_RESERVED_SHIFT   (0x00000000u)
#define CSL_OHCI_HCHCCA_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCHCCA_RESETVAL         (0x00000000u)

/* HcPeriodCurrentED */

#define CSL_OHCI_HCPERIODCURRENTED_PCED_MASK (0xFFFFFFF0u)
#define CSL_OHCI_HCPERIODCURRENTED_PCED_SHIFT (0x00000004u)
#define CSL_OHCI_HCPERIODCURRENTED_PCED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCPERIODCURRENTED_RESERVED_MASK (0x0000000Fu)
#define CSL_OHCI_HCPERIODCURRENTED_RESERVED_SHIFT (0x00000000u)
#define CSL_OHCI_HCPERIODCURRENTED_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCPERIODCURRENTED_RESETVAL (0x00000000u)

/* HcControlHeadED */

#define CSL_OHCI_HCCONTROLHEADED_CHED_MASK (0xFFFFFFF0u)
#define CSL_OHCI_HCCONTROLHEADED_CHED_SHIFT (0x00000004u)
#define CSL_OHCI_HCCONTROLHEADED_CHED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCONTROLHEADED_RESERVED_MASK (0x0000000Fu)
#define CSL_OHCI_HCCONTROLHEADED_RESERVED_SHIFT (0x00000000u)
#define CSL_OHCI_HCCONTROLHEADED_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCONTROLHEADED_RESETVAL (0x00000000u)

/* HcControlCurrentED */

#define CSL_OHCI_HCCONTROLCURRENTED_CCED_MASK (0xFFFFFFF0u)
#define CSL_OHCI_HCCONTROLCURRENTED_CCED_SHIFT (0x00000004u)
#define CSL_OHCI_HCCONTROLCURRENTED_CCED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCONTROLCURRENTED_RESERVED_MASK (0x0000000Fu)
#define CSL_OHCI_HCCONTROLCURRENTED_RESERVED_SHIFT (0x00000000u)
#define CSL_OHCI_HCCONTROLCURRENTED_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCCONTROLCURRENTED_RESETVAL (0x00000000u)

/* HcBulkHeadED */

#define CSL_OHCI_HCBULKHEADED_BHED_MASK  (0xFFFFFFF0u)
#define CSL_OHCI_HCBULKHEADED_BHED_SHIFT (0x00000004u)
#define CSL_OHCI_HCBULKHEADED_BHED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCBULKHEADED_RESERVED_MASK (0x0000000Fu)
#define CSL_OHCI_HCBULKHEADED_RESERVED_SHIFT (0x00000000u)
#define CSL_OHCI_HCBULKHEADED_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCBULKHEADED_RESETVAL   (0x00000000u)

/* HcBulkCurrentED */

#define CSL_OHCI_HCBULKCURRENTED_BCED_MASK (0xFFFFFFF0u)
#define CSL_OHCI_HCBULKCURRENTED_BCED_SHIFT (0x00000004u)
#define CSL_OHCI_HCBULKCURRENTED_BCED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCBULKCURRENTED_RESERVED_MASK (0x0000000Fu)
#define CSL_OHCI_HCBULKCURRENTED_RESERVED_SHIFT (0x00000000u)
#define CSL_OHCI_HCBULKCURRENTED_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCBULKCURRENTED_RESETVAL (0x00000000u)

/* HcDoneHead */

#define CSL_OHCI_HCDONEHEAD_DH_MASK      (0xFFFFFFF0u)
#define CSL_OHCI_HCDONEHEAD_DH_SHIFT     (0x00000004u)
#define CSL_OHCI_HCDONEHEAD_DH_RESETVAL  (0x00000000u)

#define CSL_OHCI_HCDONEHEAD_RESERVED_MASK (0x0000000Fu)
#define CSL_OHCI_HCDONEHEAD_RESERVED_SHIFT (0x00000000u)
#define CSL_OHCI_HCDONEHEAD_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCDONEHEAD_RESETVAL     (0x00000000u)

/* HcFmInterval */

#define CSL_OHCI_HCFMINTERVAL_FIT_MASK   (0x80000000u)
#define CSL_OHCI_HCFMINTERVAL_FIT_SHIFT  (0x0000001Fu)
#define CSL_OHCI_HCFMINTERVAL_FIT_RESETVAL (0x00000000u)

#define CSL_OHCI_HCFMINTERVAL_FSMPS_MASK (0x7FFF0000u)
#define CSL_OHCI_HCFMINTERVAL_FSMPS_SHIFT (0x00000010u)
#define CSL_OHCI_HCFMINTERVAL_FSMPS_RESETVAL (0x00000000u)

#define CSL_OHCI_HCFMINTERVAL_RESERVED_MASK (0x0000C000u)
#define CSL_OHCI_HCFMINTERVAL_RESERVED_SHIFT (0x0000000Eu)
#define CSL_OHCI_HCFMINTERVAL_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCFMINTERVAL_FRAMEINTERVAL_MASK (0x00003FFFu)
#define CSL_OHCI_HCFMINTERVAL_FRAMEINTERVAL_SHIFT (0x00000000u)
#define CSL_OHCI_HCFMINTERVAL_FRAMEINTERVAL_RESETVAL (0x00002EDFu)

#define CSL_OHCI_HCFMINTERVAL_RESETVAL   (0x00002EDFu)

/* HcFmRemaining */

#define CSL_OHCI_HCFMREMAINING_FRT_MASK  (0x80000000u)
#define CSL_OHCI_HCFMREMAINING_FRT_SHIFT (0x0000001Fu)
#define CSL_OHCI_HCFMREMAINING_FRT_RESETVAL (0x00000000u)

#define CSL_OHCI_HCFMREMAINING_RESERVED_MASK (0x7FFFC000u)
#define CSL_OHCI_HCFMREMAINING_RESERVED_SHIFT (0x0000000Eu)
#define CSL_OHCI_HCFMREMAINING_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCFMREMAINING_FR_MASK   (0x00003FFFu)
#define CSL_OHCI_HCFMREMAINING_FR_SHIFT  (0x00000000u)
#define CSL_OHCI_HCFMREMAINING_FR_RESETVAL (0x00000000u)

#define CSL_OHCI_HCFMREMAINING_RESETVAL  (0x00000000u)

/* HcFmNumber */

#define CSL_OHCI_HCFMNUMBER_RESERVED_MASK (0xFFFF0000u)
#define CSL_OHCI_HCFMNUMBER_RESERVED_SHIFT (0x00000010u)
#define CSL_OHCI_HCFMNUMBER_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCFMNUMBER_FN_MASK      (0x0000FFFFu)
#define CSL_OHCI_HCFMNUMBER_FN_SHIFT     (0x00000000u)
#define CSL_OHCI_HCFMNUMBER_FN_RESETVAL  (0x00000000u)

#define CSL_OHCI_HCFMNUMBER_RESETVAL     (0x00000000u)

/* HcPeriodicStart */

#define CSL_OHCI_HCPERIODICSTART_RESERVED_MASK (0xFFFFC000u)
#define CSL_OHCI_HCPERIODICSTART_RESERVED_SHIFT (0x0000000Eu)
#define CSL_OHCI_HCPERIODICSTART_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCPERIODICSTART_PS_MASK (0x00003FFFu)
#define CSL_OHCI_HCPERIODICSTART_PS_SHIFT (0x00000000u)
#define CSL_OHCI_HCPERIODICSTART_PS_RESETVAL (0x00000000u)

#define CSL_OHCI_HCPERIODICSTART_RESETVAL (0x00000000u)

/* HcLSThreshold */

#define CSL_OHCI_HCLSTHRESHOLD_RESERVED_MASK (0xFFFFF000u)
#define CSL_OHCI_HCLSTHRESHOLD_RESERVED_SHIFT (0x0000000Cu)
#define CSL_OHCI_HCLSTHRESHOLD_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCLSTHRESHOLD_LST_MASK  (0x00000FFFu)
#define CSL_OHCI_HCLSTHRESHOLD_LST_SHIFT (0x00000000u)
#define CSL_OHCI_HCLSTHRESHOLD_LST_RESETVAL (0x00000628u)

#define CSL_OHCI_HCLSTHRESHOLD_RESETVAL  (0x00000628u)

/* HcRhDescriptorA */

#define CSL_OHCI_HCRHDESCRIPTORA_POTPGT_MASK (0xFF000000u)
#define CSL_OHCI_HCRHDESCRIPTORA_POTPGT_SHIFT (0x00000018u)
#define CSL_OHCI_HCRHDESCRIPTORA_POTPGT_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHDESCRIPTORA_RESERVED_MASK (0x00FFE000u)
#define CSL_OHCI_HCRHDESCRIPTORA_RESERVED_SHIFT (0x0000000Du)
#define CSL_OHCI_HCRHDESCRIPTORA_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHDESCRIPTORA_NOCP_MASK (0x00001000u)
#define CSL_OHCI_HCRHDESCRIPTORA_NOCP_SHIFT (0x0000000Cu)
#define CSL_OHCI_HCRHDESCRIPTORA_NOCP_RESETVAL (0x00000000u)
/*----NOCP Tokens----*/
#define CSL_OHCI_HCRHDESCRIPTORA_NOCP_ENABLE (0x00000000u)
#define CSL_OHCI_HCRHDESCRIPTORA_NOCP_DISABLE (0x00000001u)

#define CSL_OHCI_HCRHDESCRIPTORA_OCPM_MASK (0x00000800u)
#define CSL_OHCI_HCRHDESCRIPTORA_OCPM_SHIFT (0x0000000Bu)
#define CSL_OHCI_HCRHDESCRIPTORA_OCPM_RESETVAL (0x00000000u)
/*----OCPM Tokens----*/
#define CSL_OHCI_HCRHDESCRIPTORA_OCPM_GLOBAL (0x00000000u)
#define CSL_OHCI_HCRHDESCRIPTORA_OCPM_PERPORT (0x00000001u)

#define CSL_OHCI_HCRHDESCRIPTORA_DT_MASK (0x00000400u)
#define CSL_OHCI_HCRHDESCRIPTORA_DT_SHIFT (0x0000000Au)
#define CSL_OHCI_HCRHDESCRIPTORA_DT_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHDESCRIPTORA_NPS_MASK (0x00000200u)
#define CSL_OHCI_HCRHDESCRIPTORA_NPS_SHIFT (0x00000009u)
#define CSL_OHCI_HCRHDESCRIPTORA_NPS_RESETVAL (0x00000001u)
/*----NPS Tokens----*/
#define CSL_OHCI_HCRHDESCRIPTORA_NPS_ALWAYSON (0x00000001u)
#define CSL_OHCI_HCRHDESCRIPTORA_NPS_SWITCHED (0x00000000u)

#define CSL_OHCI_HCRHDESCRIPTORA_PSM_MASK (0x00000100u)
#define CSL_OHCI_HCRHDESCRIPTORA_PSM_SHIFT (0x00000008u)
#define CSL_OHCI_HCRHDESCRIPTORA_PSM_RESETVAL (0x00000000u)
/*----PSM Tokens----*/
#define CSL_OHCI_HCRHDESCRIPTORA_PSM_GLOBAL (0x00000000u)
#define CSL_OHCI_HCRHDESCRIPTORA_PSM_PERPORT (0x00000001u)

#define CSL_OHCI_HCRHDESCRIPTORA_NDP_MASK (0x000000FFu)
#define CSL_OHCI_HCRHDESCRIPTORA_NDP_SHIFT (0x00000000u)
#define CSL_OHCI_HCRHDESCRIPTORA_NDP_RESETVAL (0x00000001u)

#define CSL_OHCI_HCRHDESCRIPTORA_RESETVAL (0x00000201u)

/* HcRhDescriptorB */

#define CSL_OHCI_HCRHDESCRIPTORB_PPCM_MASK (0xFFFF0000u)
#define CSL_OHCI_HCRHDESCRIPTORB_PPCM_SHIFT (0x00000010u)
#define CSL_OHCI_HCRHDESCRIPTORB_PPCM_RESETVAL (0x00000000u)
/*----PPCM Tokens----*/
#define CSL_OHCI_HCRHDESCRIPTORB_PPCM_P1GPENA (0x00000001u)
#define CSL_OHCI_HCRHDESCRIPTORB_PPCM_P1GPDIS (0x00000000u)

#define CSL_OHCI_HCRHDESCRIPTORB_DR_MASK (0x0000FFFFu)
#define CSL_OHCI_HCRHDESCRIPTORB_DR_SHIFT (0x00000000u)
#define CSL_OHCI_HCRHDESCRIPTORB_DR_RESETVAL (0x00000000u)
/*----DR Tokens----*/
#define CSL_OHCI_HCRHDESCRIPTORB_DR_P1DR (0x00000000u)
#define CSL_OHCI_HCRHDESCRIPTORB_DR_P1DNR (0x00000001u)

#define CSL_OHCI_HCRHDESCRIPTORB_RESETVAL (0x00000000u)

/* HcRhStatus */

#define CSL_OHCI_HCRHSTATUS_CRWE_MASK    (0x80000000u)
#define CSL_OHCI_HCRHSTATUS_CRWE_SHIFT   (0x0000001Fu)
#define CSL_OHCI_HCRHSTATUS_CRWE_RESETVAL (0x00000000u)
/*----CRWE Tokens----*/
#define CSL_OHCI_HCRHSTATUS_CRWE_CLEAR   (0x00000001u)
#define CSL_OHCI_HCRHSTATUS_CRWE_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_RESERVED_MASK (0x7FFC0000u)
#define CSL_OHCI_HCRHSTATUS_RESERVED_SHIFT (0x00000012u)
#define CSL_OHCI_HCRHSTATUS_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_OCIC_MASK    (0x00020000u)
#define CSL_OHCI_HCRHSTATUS_OCIC_SHIFT   (0x00000011u)
#define CSL_OHCI_HCRHSTATUS_OCIC_RESETVAL (0x00000000u)
/*----OCIC Tokens----*/
#define CSL_OHCI_HCRHSTATUS_OCIC_CLEAR   (0x00000001u)
#define CSL_OHCI_HCRHSTATUS_OCIC_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_LPSC_MASK    (0x00010000u)
#define CSL_OHCI_HCRHSTATUS_LPSC_SHIFT   (0x00000010u)
#define CSL_OHCI_HCRHSTATUS_LPSC_RESETVAL (0x00000000u)
/*----LPSC Tokens----*/
#define CSL_OHCI_HCRHSTATUS_LPSC_POWERON (0x00000001u)
#define CSL_OHCI_HCRHSTATUS_LPSC_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_DRWE_MASK    (0x00008000u)
#define CSL_OHCI_HCRHSTATUS_DRWE_SHIFT   (0x0000000Fu)
#define CSL_OHCI_HCRHSTATUS_DRWE_RESETVAL (0x00000000u)
/*----DRWE Tokens----*/
#define CSL_OHCI_HCRHSTATUS_DRWE_SETDRWE (0x00000001u)
#define CSL_OHCI_HCRHSTATUS_DRWE_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_RESERVED0_MASK (0x00007FFCu)
#define CSL_OHCI_HCRHSTATUS_RESERVED0_SHIFT (0x00000002u)
#define CSL_OHCI_HCRHSTATUS_RESERVED0_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_OCI_MASK     (0x00000002u)
#define CSL_OHCI_HCRHSTATUS_OCI_SHIFT    (0x00000001u)
#define CSL_OHCI_HCRHSTATUS_OCI_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_LPS_MASK     (0x00000001u)
#define CSL_OHCI_HCRHSTATUS_LPS_SHIFT    (0x00000000u)
#define CSL_OHCI_HCRHSTATUS_LPS_RESETVAL (0x00000000u)
/*----LPS Tokens----*/
#define CSL_OHCI_HCRHSTATUS_LPS_POWEROFF (0x00000001u)
#define CSL_OHCI_HCRHSTATUS_LPS_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHSTATUS_RESETVAL     (0x00000000u)

/* HcRhPortStatus */

#define CSL_OHCI_HCRHPORTSTATUS_RESERVED_MASK (0xFFE00000u)
#define CSL_OHCI_HCRHPORTSTATUS_RESERVED_SHIFT (0x00000015u)
#define CSL_OHCI_HCRHPORTSTATUS_RESERVED_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_PRSC_MASK (0x00100000u)
#define CSL_OHCI_HCRHPORTSTATUS_PRSC_SHIFT (0x00000014u)
#define CSL_OHCI_HCRHPORTSTATUS_PRSC_RESETVAL (0x00000000u)
/*----PRSC Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_PRSC_PRSCCLR (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PRSC_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_OCIC_MASK (0x00080000u)
#define CSL_OHCI_HCRHPORTSTATUS_OCIC_SHIFT (0x00000013u)
#define CSL_OHCI_HCRHPORTSTATUS_OCIC_RESETVAL (0x00000000u)
/*----OCIC Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_OCIC_OCICCLR (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_OCIC_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_PSSC_MASK (0x00040000u)
#define CSL_OHCI_HCRHPORTSTATUS_PSSC_SHIFT (0x00000012u)
#define CSL_OHCI_HCRHPORTSTATUS_PSSC_RESETVAL (0x00000000u)
/*----PSSC Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_PSSC_PSSCCLR (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PSSC_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_PESC_MASK (0x00020000u)
#define CSL_OHCI_HCRHPORTSTATUS_PESC_SHIFT (0x00000011u)
#define CSL_OHCI_HCRHPORTSTATUS_PESC_RESETVAL (0x00000000u)
/*----PESC Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_PESC_PESCCLR (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PESC_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_CSC_MASK (0x00010000u)
#define CSL_OHCI_HCRHPORTSTATUS_CSC_SHIFT (0x00000010u)
#define CSL_OHCI_HCRHPORTSTATUS_CSC_RESETVAL (0x00000000u)
/*----CSC Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_CSC_CSCCLR (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_CSC_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_RESERVED0_MASK (0x0000FC00u)
#define CSL_OHCI_HCRHPORTSTATUS_RESERVED0_SHIFT (0x0000000Au)
#define CSL_OHCI_HCRHPORTSTATUS_RESERVED0_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_LSDA_MASK (0x00000200u)
#define CSL_OHCI_HCRHPORTSTATUS_LSDA_SHIFT (0x00000009u)
#define CSL_OHCI_HCRHPORTSTATUS_LSDA_RESETVAL (0x00000000u)
/*----LSDA Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_LSDA_PPSCLR (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_LSDA_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_PPS_MASK (0x00000100u)
#define CSL_OHCI_HCRHPORTSTATUS_PPS_SHIFT (0x00000008u)
#define CSL_OHCI_HCRHPORTSTATUS_PPS_RESETVAL (0x00000000u)
/*----PPS Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_PPS_PPSSET (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PPS_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_RESERVED1_MASK (0x000000E0u)
#define CSL_OHCI_HCRHPORTSTATUS_RESERVED1_SHIFT (0x00000005u)
#define CSL_OHCI_HCRHPORTSTATUS_RESERVED1_RESETVAL (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_PRS_MASK (0x00000010u)
#define CSL_OHCI_HCRHPORTSTATUS_PRS_SHIFT (0x00000004u)
#define CSL_OHCI_HCRHPORTSTATUS_PRS_RESETVAL (0x00000000u)
/*----PRS Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_PRS_PORTRESET (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PRS_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_POCI_MASK (0x00000008u)
#define CSL_OHCI_HCRHPORTSTATUS_POCI_SHIFT (0x00000003u)
#define CSL_OHCI_HCRHPORTSTATUS_POCI_RESETVAL (0x00000000u)
/*----POCI Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_POCI_RESUME (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_POCI_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_PSS_MASK (0x00000004u)
#define CSL_OHCI_HCRHPORTSTATUS_PSS_SHIFT (0x00000002u)
#define CSL_OHCI_HCRHPORTSTATUS_PSS_RESETVAL (0x00000000u)
/*----PSS Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_PSS_SUSPEND (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PSS_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_PES_MASK (0x00000002u)
#define CSL_OHCI_HCRHPORTSTATUS_PES_SHIFT (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PES_RESETVAL (0x00000000u)
/*----PES Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_PES_PENA (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_PES_NOEFFECT (0x00000000u)

#define CSL_OHCI_HCRHPORTSTATUS_CCS_MASK (0x00000001u)
#define CSL_OHCI_HCRHPORTSTATUS_CCS_SHIFT (0x00000000u)
#define CSL_OHCI_HCRHPORTSTATUS_CCS_RESETVAL (0x00000000u)
/*----CCS Tokens----*/
#define CSL_OHCI_HCRHPORTSTATUS_CCS_NOEFFECT (0x00000000u)
#define CSL_OHCI_HCRHPORTSTATUS_CCS_CLEAR (0x00000001u)

#define CSL_OHCI_HCRHPORTSTATUS_RESETVAL (0x00000000u)

#endif
