//------------------------------------------------------------------------------
// File audio.c
//------------------------------------------------------------------------------
// Copyright (c) 2010, Texas Instruments Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice,
//       this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Texas Instruments Inc. nor the names of its
//       contributors may be used to endorse or promote products derived from
//       this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//------------------------------------------------------------------------------

#include <stdio.h>
#include "tistdtypes.h"

#include "app.h"
#include "edma3.h"

//-----------------------------------------------------------------------------
// Configuration Macros
//-----------------------------------------------------------------------------

#define SAMPLES_PER_BUF     128 * 3
#define BYTES_PER_SAMPLE    4
#define N_CHANNELS          2

#define BUF_LENGTH          SAMPLES_PER_BUF * N_CHANNELS
#define BUF_SIZE            SAMPLES_PER_BUF * N_CHANNELS * BYTES_PER_SAMPLE

//-----------------------------------------------------------------------------
// Static Variable Declarations
//-----------------------------------------------------------------------------
/* Define transmit and receive buffers 
#pragma DATA_SECTION(rcv_ping_L,"dmaMem")
Uint32 rcv_ping_L[BUF_LENGTH];
#pragma DATA_SECTION(rcv_pong_L,"dmaMem")
Uint32 rcv_pong_L[BUF_LENGTH];
#pragma DATA_SECTION(rcv_ping_R,"dmaMem")
Uint32 rcv_ping_R[BUF_LENGTH];
#pragma DATA_SECTION(rcv_pong_R,"dmaMem")
Uint32 rcv_pong_R[BUF_LENGTH];

#pragma DATA_SECTION(xmt_ping_L,"dmaMem")
Uint32 xmt_ping_L[BUF_LENGTH];
#pragma DATA_SECTION(xmt_pong_L,"dmaMem")
Uint32 xmt_pong_L[BUF_LENGTH];
#pragma DATA_SECTION(xmt_ping_R,"dmaMem")  
Uint32 xmt_ping_R[BUF_LENGTH];
#pragma DATA_SECTION(xmt_pong_R,"dmaMem")
Uint32 xmt_pong_R[BUF_LENGTH];*/

//#pragma DATA_SECTION(rcv_ping,"dmaMem")
Uint32 rcv_ping[BUF_LENGTH];
//#pragma DATA_SECTION(rcv_pong,"dmaMem")
Uint32 rcv_pong[BUF_LENGTH];
//#pragma DATA_SECTION(xmt_ping,"dmaMem")
Uint32 xmt_ping[BUF_LENGTH];
//#pragma DATA_SECTION(xmt_pong,"dmaMem")
Uint32 xmt_pong[BUF_LENGTH];

Uint8 rcv_ping_flag=0,rcv_pong_flag=0,xmt_ping_flag=0,xmt_pong_flag=0;

void copydata(Uint32 input[BUF_LENGTH],Uint32 output[BUF_LENGTH]);

static void audio_run(void)
{
    while (1)
    {
        
        while(!rcv_ping_flag);
        rcv_ping_flag = 0;
		while(!xmt_ping_flag);
        xmt_ping_flag = 0;
		
		copydata(rcv_ping,xmt_ping);
        
		while(!rcv_pong_flag);
		rcv_pong_flag = 0;
		while(!xmt_pong_flag);
		xmt_pong_flag = 0;
		
		copydata(rcv_pong,xmt_pong);
        
    }
}

//-----------------------------------------------------------------------------
// Static TSK Function
//-----------------------------------------------------------------------------

void copydata(Uint32 *input,Uint32 *output)
{
  Uint16 i;
  for(i=0;i<BUF_LENGTH;i++)
  {
    
	output[i] = input[i];

  }

}

int audio_tsk_fxn()
{
    Uint16 i;
	for(i=0;i<BUF_LENGTH;i++)
	{
		
		rcv_ping[i] = 0;

		rcv_pong[i] = 0;

		//rcv_ping_R[i] = 0;

		//rcv_pong_R[i] = 0;
       /*
       if(i%3==0)
	   {
		xmt_ping[i] = 0x1234;

		xmt_pong[i] = 0x1234;
       }
	   else if(i%3==1)
	   {
	    xmt_ping[i] = 0x5678;

		xmt_pong[i] = 0x5678;
	   }
	   else if(i%3==2)
	   {
	    xmt_ping[i] = 0x9abc;

		xmt_pong[i] = 0x9abc;
	   }
	   */
		xmt_ping[i] = 0;

		xmt_pong[i] = 0;
 
	  
	}
	/*
    setup_edma_pingpong_rcv(mcasp_rcv_register, rcv_ping_L, rcv_pong_L,
                            rcv_ping_R, rcv_pong_R,
                            BYTES_PER_SAMPLE, SAMPLES_PER_BUF);

    setup_edma_pingpong_xmt(rcv_ping_L, rcv_pong_L,
                            rcv_ping_R, rcv_pong_R, mcasp_xmt_register,
                            BYTES_PER_SAMPLE, SAMPLES_PER_BUF);
    
    */

    
	mcasp_close();
    // setup codec and McASP
    mcasp_open();
    /*
	EdmaEnableChannel(EDMA_MCASPRXCH, 0);
    EdmaEnableChannel(EDMA_MCASPTXCH, 0);
	
    EdmaIntEnable(EDMA_RCV_PING_TCC);
    EdmaIntEnable(EDMA_RCV_PONG_TCC);
    EdmaIntEnable(EDMA_XMT_PING_TCC);
    EdmaIntEnable(EDMA_XMT_PONG_TCC);
    */
    // run audio test
    audio_run();

    // kill codec and McASP
    mcasp_close();

    // close application

    return 0;
}

//------------------------------------------------------------------------------
// End of File audio.c
//------------------------------------------------------------------------------
