//------------------------------------------------------------------------------
// File mcasp.c
//------------------------------------------------------------------------------
// Copyright (c) 2010, Texas Instruments Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright notice,
//       this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of the Texas Instruments Inc. nor the names of its
//       contributors may be used to endorse or promote products derived from
//       this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//------------------------------------------------------------------------------

#include "app.h"

#include "evmc6747.h"
#include "evmc6747_mcasp.h"

//------------------------------------------------------------------------------
// Configuration Macros
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
// Variables
//------------------------------------------------------------------------------

void *mcasp_xmt_register = (void *)(MCASP0_BASE + 0x2000);
void *mcasp_rcv_register = (void *)(MCASP0_BASE + 0x2000);

void *mcasp_xmt_register5 = (void *)(MCASP0_BASE + 0x214);
void *mcasp_rcv_register1 = (void *)(MCASP0_BASE + 0x284);

extern Uint32 rcv_ping[];
extern Uint32 rcv_pong[];
//extern Uint32 rcv_ping_R[];
//extern Uint32 rcv_pong_R[];
extern Uint32 xmt_ping[];
extern Uint32 xmt_pong[];
//extern Uint32 xmt_ping_R[];
//extern Uint32 xmt_pong_R[];

extern void setup_edma_pingpong_xmt(void *src_ping, void *src_pong, void *dst,
                             Uint32 acnt, Uint32 bcnt);
extern void setup_edma_pingpong_rcv(void *src, void *dst_ping, void *dst_pong,
                             Uint32 acnt, Uint32 bcnt);


extern void EdmaIntEnable(Int intNumber);
extern void EdmaEnableChannel(Int channelNumber, Int QueueNumber);


static MCASP_Handle mcasp;


//------------------------------------------------------------------------------
// Functions
//------------------------------------------------------------------------------

void mcasp_close()
{
    mcasp = &MCASP_MODULE_0;
    // Close McASP
    mcasp->regs->SRCTL0 = 0; // Serializers
    mcasp->regs->SRCTL1 = 0;
    mcasp->regs->SRCTL2 = 0;
	mcasp->regs->SRCTL3 = 0;
    mcasp->regs->SRCTL5 = 0;
    mcasp->regs->SRCTL6 = 0;
	mcasp->regs->SRCTL7 = 0;
	mcasp->regs->SRCTL8 = 0;
    //mcasp->regs->SRCTL11 = 0;
    //mcasp->regs->SRCTL12 = 0;
    mcasp->regs->GBLCTL = 0;  // Global Reset
}

void mcasp_open()
{
    

    /* ---------------------------------------------------------------- *
     *                                                                  *
     *  McASP1 is in MASTER mode.                                       *
     *      BCLK & WCLK come from McASP1                                *
     *      DIN is used by write16/write32                              *
     *      DOUT is usec by read16/read32                               *
     *                                                                  *
     * ---------------------------------------------------------------- */

    mcasp->regs->GBLCTL  = 0;       // Reset
    mcasp->regs->RGBLCTL = 0;       // Reset RX
    mcasp->regs->XGBLCTL = 0;       // Reset TX
    mcasp->regs->PWRDEMU = 1;       // Free-running

    // RX
    mcasp->regs->RMASK      = 0xffffff00; // No padding used
    mcasp->regs->RFMT       = 0x000080f0; // MSB 16bit, 1-delay, no pad, CFGBus
    mcasp->regs->AFSRCTL    = 0x00000112; // 2TDM, 1bit Rising, INTERNAL FS, word
    mcasp->regs->ACLKRCTL   = 0x000000A3; // Rising INTERNAL CLK,(from tx side)
    mcasp->regs->AHCLKRCTL  = 0x00008001; // INT CLK (from tx side)
    mcasp->regs->RTDM       = 0xFFFFFFFF; // Slots 0,1
    mcasp->regs->RINTCTL    = 0x00000009; // Not used
    mcasp->regs->RCLKCHK    = 0x00FF0000; // 255-MAX 0-MIN, div-by-256
	mcasp->regs->REVTCTL    = 0;

    // TX
    mcasp->regs->XMASK      = 0xffffff00; // No padding used
    mcasp->regs->XFMT       = 0x000080f0; // MSB 16bit, 1-delay, no pad, CFGBus
    mcasp->regs->AFSXCTL    = 0x00000112; // 2TDM, 1bit Rising edge INTERNAL FS, word
    mcasp->regs->ACLKXCTL   = 0x000000A3; // ASYNC, Rising INTERNAL CLK, div-by-16
    mcasp->regs->AHCLKXCTL  = 0x00008001; // EXT CLK
    mcasp->regs->XTDM       = 0xFFFFFFFF; // Slots 0,1
    mcasp->regs->XINTCTL    = 0x00000009; // Not used
    mcasp->regs->XCLKCHK    = 0x00FF0000; // 255-MAX 0-MIN, div-by-256
	mcasp->regs->XEVTCTL    = 0;

    mcasp->regs->SRCTL0     = 0x0002;     // MCASP1.AXR1[0] <-- DOUT
    mcasp->regs->SRCTL1     = 0x0002;     // MCASP1.AXR1[0] <-- DOUT
	mcasp->regs->SRCTL2     = 0x0002;     // MCASP1.AXR1[0] <-- DOUT
	//mcasp->regs->SRCTL3     = 0x0002;     // MCASP1.AXR1[0] <-- DOUT
    mcasp->regs->SRCTL5     = 0x0001;     // MCASP1.AXR1[5] --> DIN
	mcasp->regs->SRCTL6     = 0x0001;     // MCASP1.AXR1[5] --> DIN
	mcasp->regs->SRCTL7     = 0x0001;     // MCASP1.AXR1[5] --> DIN
	//mcasp->regs->SRCTL8     = 0x0001;     // MCASP1.AXR1[5] --> DIN
   
    mcasp->regs->PFUNC      = 0; // All MCASPs
    mcasp->regs->PDIR       = 0x1E0001E0; // All inputs except AXR0[5], ACLKX1, AFSX1

    mcasp->regs->DITCTL     = 0x00000000; // Not used
    mcasp->regs->DLBCTL     = 0x00000000; // Not used
    mcasp->regs->AMUTE      = 0x00000000; // Not used

    // Starting sections of the McASP
    mcasp->regs->XGBLCTL |= GBLCTL_XHCLKRST_ON;                                    // HS Clk
    while ( ( mcasp->regs->XGBLCTL & GBLCTL_XHCLKRST_ON ) != GBLCTL_XHCLKRST_ON );  
    mcasp->regs->RGBLCTL |= GBLCTL_RHCLKRST_ON;                                    // HS Clk
    while ( ( mcasp->regs->RGBLCTL & GBLCTL_RHCLKRST_ON ) != GBLCTL_RHCLKRST_ON );
   
    mcasp->regs->XGBLCTL |= GBLCTL_XCLKRST_ON;                                     // Clk
    while ( ( mcasp->regs->XGBLCTL & GBLCTL_XCLKRST_ON ) != GBLCTL_XCLKRST_ON );
    //mcasp->regs->RGBLCTL |= GBLCTL_RCLKRST_ON;                                     // Clk
    //while ( ( mcasp->regs->RGBLCTL & GBLCTL_RCLKRST_ON ) != GBLCTL_RCLKRST_ON );

	setup_edma_pingpong_rcv(mcasp_rcv_register, rcv_ping, rcv_pong,
                            4, 768);

    setup_edma_pingpong_xmt(xmt_ping, xmt_pong,mcasp_xmt_register,
                            4, 768);
    

    
    EdmaEnableChannel(0, 0);
    EdmaEnableChannel(1, 0);
	
    EdmaIntEnable(1);
    EdmaIntEnable(2);
    EdmaIntEnable(3);
    EdmaIntEnable(4);
    
    mcasp->regs->XSTAT = 0x0000ffff;        // Clear all
    mcasp->regs->RSTAT = 0x0000ffff;        // Clear all

    mcasp->regs->XGBLCTL |= GBLCTL_XSRCLR_ON;                                      // Serialize
    while ( ( mcasp->regs->XGBLCTL & GBLCTL_XSRCLR_ON ) != GBLCTL_XSRCLR_ON );
    mcasp->regs->RGBLCTL |= GBLCTL_RSRCLR_ON;                                      // Serialize
    while ( ( mcasp->regs->RGBLCTL & GBLCTL_RSRCLR_ON ) != GBLCTL_RSRCLR_ON );

    // Write a 0, so that no underrun occurs after releasing the state machine
    mcasp->regs->XBUF6 = 0;
    mcasp->regs->RBUF0 = 0;
    mcasp->regs->XBUF5 = 0;
    mcasp->regs->RBUF1 = 0;
	mcasp->regs->XBUF7 = 0;
    mcasp->regs->RBUF2 = 0;
    //mcasp->regs->XBUF8 = 0;
    //mcasp->regs->RBUF3 = 0;
    mcasp->regs->XGBLCTL |= GBLCTL_XSMRST_ON;                                       // State Machine
    while ( ( mcasp->regs->XGBLCTL & GBLCTL_XSMRST_ON ) != GBLCTL_XSMRST_ON );
    mcasp->regs->RGBLCTL |= GBLCTL_RSMRST_ON;                                       // State Machine
    while ( ( mcasp->regs->RGBLCTL & GBLCTL_RSMRST_ON ) != GBLCTL_RSMRST_ON );

    mcasp->regs->XGBLCTL |= GBLCTL_XFRST_ON;                                        // Frame Sync
    while ( ( mcasp->regs->XGBLCTL & GBLCTL_XFRST_ON ) != GBLCTL_XFRST_ON );
    mcasp->regs->RGBLCTL |= GBLCTL_RFRST_ON;                                        // Frame Sync
    while ( ( mcasp->regs->RGBLCTL & GBLCTL_RFRST_ON ) != GBLCTL_RFRST_ON );
}

/*
interrupt void McASPInterrupt(void)
{


        if(mcasp->regs->XSTAT & 0x01)
		  mcasp_open();

		if(mcasp->regs->XSTAT & 0x08)
		  mcasp_open();

		if(mcasp->regs->RSTAT & 0x01)
		  mcasp->regs->RSTAT |= 0x01;

		if(mcasp->regs->RSTAT & 0x08)
		  mcasp_open();
	    

}
*/
//------------------------------------------------------------------------------
// End of File mcasp.c
//------------------------------------------------------------------------------
