/******************************************************************************

  Copyright (C), 2001-2012, Texas Instrument.

 ******************************************************************************
  File Name     : FunctionHook.h
  Version       : Initial Draft
  Author        : Brighton
  Created       : 2012/11/18
  Last Modified :
  Description   : FunctionHook.c header file

******************************************************************************/

#ifndef __FUNCTION_HOOK_H__
#define __FUNCTION_HOOK_H__


#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* __cplusplus */

/*if record buffer is used as circular buffer, 
MAX record number must be power of 2 for easy wrap*/
#define MAX_PROFILE_RECORD_NUM 	(4*1024*1024)

typedef enum
{
	HOOK_TYPE_FUNC_ENTRY = 0, 	/*function entry hook*/
	HOOK_TYPE_FUNC_EXIT, 	/*function exit hook*/
	HOOK_TYPE_TASK_ENTRY, 	/*task entry hook*/
	HOOK_TYPE_TASK_EXIT 		/*task exit hook*/
}Hook_Record_Type;

typedef	struct{
	/*Address always has last 2 bits == 0.  
	lower two bits are used as record type*/
	unsigned int address_type;
	unsigned int TSCL; 	/*Lower 32 bits of Time Stamp Counter*/
	unsigned int TSCH; 	/*Higher 32 bits of Time Stamp Counter*/
} Hook_Record;

extern Hook_Record ProfileData[MAX_PROFILE_RECORD_NUM];
extern unsigned int uiProfileDataCnt;   //total counter of records

extern void function_hook_init();
extern void entry_hook(void (* func_addr)());
extern void exit_hook(void (* func_addr)());
extern void task_switch_hook(unsigned int prevTask, 
	unsigned int nextTask);

#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */


#endif /* __FUNCTION_HOOK_H__ */
