/****************************************************************************\
 *           Copyright (C) 2012 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
  ****************************************************************************
This class implement a list of all functions's address or all tasks's handle
******************************************************************************
 * Created by :                                                             *
 *            Brighton Feng                                    *
 *            Texas Instruments                                             * 
 *            Nov 20, 2012                                                  *
***************************************************************************/

//---------------------------------------------------------------------------


#include <string.h>
#include <stdio.h>
#include "list.h"

//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
/*initialize variables*/
TFuncTaskList::TFuncTaskList(unsigned int uiSize)
{
	this->uiSize= uiSize;
	list= new unsigned int[uiSize];

	memset(list, 0, uiSize*4);

	uiCount= 0;
}

//---------------------------------------------------------------------------
TFuncTaskList::~TFuncTaskList()
{
	if(list)
	{
		delete [] list;
		list= NULL;
	}

	uiSize= 0;
	uiCount= 0;
}

//---------------------------------------------------------------------------
/*if this function or task address does not in the structure array,
insert it by ascending order of address.*/
int TFuncTaskList::insert(unsigned int uiAddress)
{
	int i;
	int iLowIndex= 0, iHighIndex= uiCount-1, iMidIndex;

	if(uiCount >= uiSize)
	{//list full
		uiCount= uiSize;
		return uiSize;
	}
	
	/*binary find the index to insert*/
	iMidIndex= (iLowIndex+iHighIndex)>>1;
	while(iLowIndex<=iHighIndex)
	{
		if(list[iMidIndex]>uiAddress)
			iHighIndex=iMidIndex-1;
		else
			iLowIndex=iMidIndex+1;
		iMidIndex= (iLowIndex+iHighIndex)>>1;
	}
	if(iMidIndex>=0) 	//find it
		if(list[iMidIndex]==uiAddress)
			return uiCount;

	iMidIndex++; 	//this is the index to insert

	/*move data after the index to make room for new element*/
	for(i=uiCount; i>iMidIndex; i--)
		list[i]= list[i-1];

	/*insert function to the index*/
	list[iMidIndex]= uiAddress;

	uiCount++;

	return uiCount;
}

//---------------------------------------------------------------------------
/*binary search to find the index of an address in the list,
return the index if found; return -1, if not found*/
int TFuncTaskList::find(unsigned int uiAddress)
{
	int iLowIndex= 0, iHighIndex= uiCount-1, iMidIndex;

	iMidIndex= (iLowIndex+iHighIndex)>>1;
	while(iLowIndex<=iHighIndex)
	{
		if(list[iMidIndex]>uiAddress)
			iHighIndex=iMidIndex-1;
		else
			iLowIndex=iMidIndex+1;
		iMidIndex= (iLowIndex+iHighIndex)>>1;
	}
	if(iMidIndex>=0)
		if(list[iMidIndex]==uiAddress)
			return iMidIndex;

	return -1; 	//can not find the function
}

int defined_function()
{
	unsigned int a, b;

	printf("The address of a is 0x%08X, address of b is 0x%08X", &a, &b);

	return 0;
}
