/****************************************************************************\
 *           Copyright (C) 2011 Texas Instruments Incorporated.             *
 *                           All Rights Reserved                            *
 *                                                                          *
 * GENERAL DISCLAIMER                                                       *
 * ------------------                                                       *
 * All software and related documentation is provided "AS IS" and without   *
 * warranty or support of any kind and Texas Instruments expressly disclaims*
 * all other warranties, express or implied, including, but not limited to, *
 * the implied warranties of merchantability and fitness for a particular   *
 * purpose.  Under no circumstances shall Texas Instruments be liable for   *
 * any incidental, special or consequential damages that result from the    *
 * use or inability to use the software or related documentation, even if   *
 * Texas Instruments has been advised of the liability.                     *
  ****************************************************************************
This class implement a list of all functions's address or all tasks's handle
******************************************************************************
 * Created by :                                                             *
 *            Brighton Feng                                    *
 *            Texas Instruments                                             * 
 *            Nov 20, 2012                                                  *
***************************************************************************/
//---------------------------------------------------------------------------
#ifndef _LIST_H_
#define _LIST_H_

#ifdef __cplusplus
#if __cplusplus
extern "C"{
#endif
#endif /* __cplusplus */

extern int defined_function();

//---------------------------------------------------------------------------
class TFuncTaskList
{
private:

	unsigned int uiSize; //maximum records can be save in the list

public:

/*array to record all task handles and function addresses*/
	unsigned int * list;

	unsigned int uiCount; 	//count of valid records in the list

	/*if this function or task address does not in the structure array,
	insert it by ascending order of address*/
	int insert(unsigned int uiAddress);

	/*binary search to find the index of an address in the list,
	return -1, if not found*/
	int find(unsigned int uiAddress);

	TFuncTaskList(unsigned int uiSize);
	~TFuncTaskList();

};

class MyClass
{
    public:
        int a;
        void method();
};


//---------------------------------------------------------------------------
#ifdef __cplusplus
#if __cplusplus
}
#endif
#endif /* __cplusplus */

#endif

