/*
 * ETB_Profile.h
 *
 *  Created on: Mar 19, 2014
 *      Author: a0282196
 */

#ifndef ETB_PROFILE_H_
#define ETB_PROFILE_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "DSPTraceExport.h"
#include "ETBInterface.h"
#include "ETBAddr.h"
#include "edma_dev-c66xx.h"
#include "aet.h"

#ifdef C6670
#include "DeviceSpecific_C6670.h"
#endif

#ifdef C6678
#include "DeviceSpecific_C6678.h"
#endif

#ifdef C6657
#include "DeviceSpecific_C6657.h"
#endif

#ifdef C66AK2Hxx
#include "DeviceSpecific_C66AK2Hxx.h"
#endif


#define USE_TEND 0
#define EXTERNAL_BUFFER_WRAPPING 1

/* The _USE_MANUAL_READ_ definition is used to select whether the drain buffer
 *  is read using ETB_read function or manually read from the DMA status
 *  information returned from the ETB_flush_dma function.
 */
/*
#define _USE_MANUAL_READ_
*/
#define EDMA_DEST_ADDRESS  0x0c000000
#define EDMA_BFR_WORDS     0x1000   /* 0x4000 (16384) bytes */

#define TEMP_BFR_READ_SIZE 0x400

typedef struct _TraceJOBConfig
{
	AET_jobIndex startJob;
	AET_jobIndex endJob;
	uint32_t         startProfileAddr;
	uint32_t         endProfileAddr;
	uint32_t          tracetype;

}TraceJOBConfig;

void Init_Profile(uint32_t* pDmaMemory, TraceJOBConfig* ProfileConfig);
void Setup_ETB_Profile(TraceJOBConfig* ProfileConfig, ETBHandle** pETBHandle, DSPTraceHandle** pDSPHandle);
void Stop_ETB_Profile(TraceJOBConfig* ProfileConfig, ETBHandle** pETBHandle, DSPTraceHandle** pDSPHandle);

#ifdef __cplusplus
}
#endif

#endif /* ETB_PROFILE_H_ */
