/****************************************************************************
CToolsLib - DSPTraceExport Library  

Copyright (c) 2009-2010 Texas Instruments Inc. (www.ti.com)
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
****************************************************************************/
#ifndef __DSPTRACEEXPORT_ADDR_H
#define __DSPTRACEEXPORT_ADDR_H

#ifdef __cplusplus
extern "C" {
#endif

/*! \file DSPTraceAddr.h
    \version 1.3

    This file contains the DSP Trace Export addresses.
*/

/* PIN manager MMR address. */
#define PIN_MGR0   (0x1BC0130)
#define PIN_MGR1   (0x1BC0134)
#define PIN_MGR2   (0x1BC0138) 
#define PIN_MGR3   (0x1BC0164)


#if defined(TCI6486)  //Tomahawk
    #define PLLDIV  (0x029A0178)
    #define PLLCMD  (0x029A0138)
    #define PLLSTAT (0x029A013C)
   
#elif defined(TCI6488) //Faraday
    #define PLLDIV  (0x029A0184)
    #define PLLCMD  (0x029A0138)
    #define PLLSTAT (0x029A013C)

#elif defined(TCI6484) //Curie
    #define PLLDIV  (0x029A0120)
    #define PLLCMD  (0x029A0138)
    #define PLLSTAT (0x029A013C)

#elif defined(C66x) //C66x devices
    #define PLLDIV  (0x0231011C) 
    #define PLLCMD  (0x02310138)
    #define PLLSTAT (0x0231013C)

#else
    #error No device type preprocessor defined for the DSPTraceExport library

#endif

/* Trace control register MMR address. */
#define TR_CNTL    (0x1BC013C)
#define TF_CNTL    (0x1BC014C)
#define TR_SYNC    (0x1BC0140)
#define TR_IAR_ADD (0x1BC0020)

/* PIN manager MMR address. */
#define PIN_MGR0   (0x1BC0130)
#define PIN_MGR1   (0x1BC0134)
#define PIN_MGR2   (0x1BC0138) 
#define PIN_MGR3   (0x1BC0164) 

#define VALID_DSPTRACE_HANDLE    0xbeef

#ifdef __cplusplus
}
#endif

#endif //__DSPTRACEEXPORT_ADDR_H
