#ifndef _CSLR_AET_IAR_H_
#define _CSLR_AET_IAR_H_

#include <_aet.h>

#include <stdint.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for CMP
\**************************************************************************/
typedef struct  {
    volatile int32_t DRC_CNTL;
    volatile int32_t DRC_AREF;
    volatile int32_t DCQ_DREFL;
    volatile int32_t DCQ_MREFL;
    volatile int32_t DCQ_DREFH;
    volatile int32_t DCQ_MREFH;
    volatile int32_t DCR_RSVD_0;
    volatile int32_t DCR_RSVD_1;
} CSL_Aet_iarCmpRegs;

/**************************************************************************\
* Register Overlay Structure for AUX
\**************************************************************************/
typedef struct  {
    volatile int32_t AUX_EVT_CNTL;
    volatile int32_t AE_ENA;
} CSL_Aet_iarAuxRegs;

/**************************************************************************\
* Register Overlay Structure for CNT_RELOAD
\**************************************************************************/
typedef struct  {
    volatile int32_t CNT_RLD;
} CSL_Aet_iarCnt_reloadRegs;

/**************************************************************************\
* Register Overlay Structure for TB_SEXT
\**************************************************************************/
typedef struct  {
    volatile int32_t NI;
} CSL_Aet_iarTb_sextRegs;

/**************************************************************************\
* Register Overlay Structure for TB_CNTL_GRP_W
\**************************************************************************/
typedef struct  {
    volatile int32_t TB_ORS_W;
    volatile int32_t TB_CNTL_W_1;
    volatile int32_t TB_CEXT_W_2;
    volatile int32_t TB_CEXT_W_3;
    volatile int32_t TB_CEXT_W_4;
    volatile uint8_t RSVD4[12];
} CSL_Aet_iarTb_cntl_grp_wRegs;

/**************************************************************************\
* Register Overlay Structure for SM
\**************************************************************************/
typedef struct  {
    volatile int32_t SM_ORS;
    volatile int32_t SM_CNTL_W_1;
    volatile int32_t SM_CEXT_W_2;
    volatile uint8_t RSVD4[20];
} CSL_Aet_iarSmRegs;

/**************************************************************************\
* Register Overlay Structure for TB_CNTL_GRP_1
\**************************************************************************/
typedef struct  {
    volatile int32_t TB_ORS;
    volatile int32_t TB_CNTL;
} CSL_Aet_iarTb_cntl_grp_1Regs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    CSL_Aet_iarCmpRegs CMP[16];
    volatile int32_t PIN_OBSV;
    volatile int32_t PIN_MGR_0;
    volatile int32_t PIN_MGR_1;
    volatile uint8_t RSVD0[4];
    volatile int32_t TB_ENA;
    volatile int32_t TB_DM;
    volatile int32_t FUNC_CNTL;
    volatile int32_t CMPI_SEL;
    volatile uint8_t RSVD1[8];
    CSL_Aet_iarAuxRegs AUX[3];
    volatile int32_t TR_CNTL;
    volatile int32_t TP_COUNTER;
    volatile uint8_t RSVD2[8];
    volatile int32_t TF_CNTL;
    volatile uint8_t RSVD3[108];
    CSL_Aet_iarCnt_reloadRegs CNT_RELOAD[4];
    CSL_Aet_iarTb_sextRegs TB_SEXT[4];
    volatile uint8_t RSVD5[32];
    CSL_Aet_iarTb_cntl_grp_wRegs TB_CNTL_GRP_W[2];
    CSL_Aet_iarSmRegs SM[6];
    volatile uint8_t RSVD6[256];
    CSL_Aet_iarTb_cntl_grp_1Regs TB_CNTL_GRP_1[8];
} CSL_Aet_iarRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DRC_CNTL */

#define CSL_AET_IAR_DRC_CNTL_QLU_RES_MASK (0xE0000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_RES_SHIFT (0x0000001Du)
#define CSL_AET_IAR_DRC_CNTL_QLU_RES_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DRC_CNTL_QLU_INASENSE_MASK (0x10000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_INASENSE_SHIFT (0x0000001Cu)
#define CSL_AET_IAR_DRC_CNTL_QLU_INASENSE_RESETVAL (0x00000000u)
/*----QLU_INASENSE Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_INASENSE_ACTIVE_HIGH (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_INASENSE_ACTIVE_LOW (0x00000001u)

#define CSL_AET_IAR_DRC_CNTL_QLU_EXACT_MASK (0x08000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_EXACT_SHIFT (0x0000001Bu)
#define CSL_AET_IAR_DRC_CNTL_QLU_EXACT_RESETVAL (0x00000000u)
/*----QLU_EXACT Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_EXACT_INEXACT (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_EXACT_EXACT (0x00000001u)

#define CSL_AET_IAR_DRC_CNTL_QLU_REF_MASK (0x06000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_REF_SHIFT (0x00000019u)
#define CSL_AET_IAR_DRC_CNTL_QLU_REF_RESETVAL (0x00000000u)
/*----QLU_REF Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_REF_BYTE (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_REF_HALFWORD (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_QLU_REF_WORD (0x00000002u)
#define CSL_AET_IAR_DRC_CNTL_QLU_REF_DOUBLEWORD (0x00000003u)

#define CSL_AET_IAR_DRC_CNTL_QLU_EXE_MASK (0x01000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_EXE_SHIFT (0x00000018u)
#define CSL_AET_IAR_DRC_CNTL_QLU_EXE_RESETVAL (0x00000000u)
/*----QLU_EXE Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_EXE_NO_QUALIFY (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_EXE_QUALIFY (0x00000001u)

#define CSL_AET_IAR_DRC_CNTL_QLU_STALL_MASK (0x00800000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_STALL_SHIFT (0x00000017u)
#define CSL_AET_IAR_DRC_CNTL_QLU_STALL_RESETVAL (0x00000000u)
/*----QLU_STALL Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_STALL_QUALIFY (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_STALL_NO_QUALIFY (0x00000001u)

#define CSL_AET_IAR_DRC_CNTL_QLU_ETYPE_MASK (0x00400000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ETYPE_SHIFT (0x00000016u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ETYPE_RESETVAL (0x00000000u)
/*----QLU_ETYPE Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_ETYPE_NO_QUALIFY (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ETYPE_QUALIFY (0x00000001u)

#define CSL_AET_IAR_DRC_CNTL_QLU_DQ_MASK (0x00200000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_DQ_SHIFT (0x00000015u)
#define CSL_AET_IAR_DRC_CNTL_QLU_DQ_RESETVAL (0x00000000u)
/*----QLU_DQ Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_DQ_NO_QUALIFY (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_DQ_QUALIFY (0x00000001u)

#define CSL_AET_IAR_DRC_CNTL_QLU_RW_MASK (0x00100000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_RW_SHIFT (0x00000014u)
#define CSL_AET_IAR_DRC_CNTL_QLU_RW_RESETVAL (0x00000000u)
/*----QLU_RW Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_RW_WRITE (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_RW_READ (0x00000001u)

#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_MASK (0x000F0000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_SHIFT (0x00000010u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_RESETVAL (0x00000000u)
/*----QLU_ACCESS Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_NONE (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_BYTE (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_HALFWORD (0x00000002u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_HALFWORD_BYTE (0x00000003u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_WORD (0x00000004u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_WORD_BYTE (0x00000005u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_WORD_HALFWORD (0x00000006u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_WORD_HALFWORD_BYTE (0x00000007u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD (0x00000008u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD_BYTE (0x00000009u)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD_HALFWORD (0x0000000Au)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD_HALFWORD_BYTE (0x0000000Bu)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD_WORD (0x0000000Cu)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD_WORD_BYTE (0x0000000Du)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD_WORD_HALFWORD (0x0000000Eu)
#define CSL_AET_IAR_DRC_CNTL_QLU_ACCESS_DOUBLEWORD_WORD_HALFWORD_BYTE (0x0000000Fu)

#define CSL_AET_IAR_DRC_CNTL_BE_MASK (0x0000FF00u)
#define CSL_AET_IAR_DRC_CNTL_BE_SHIFT (0x00000008u)
#define CSL_AET_IAR_DRC_CNTL_BE_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DRC_CNTL_ES_MASK (0x000000F0u)
#define CSL_AET_IAR_DRC_CNTL_ES_SHIFT (0x00000004u)
#define CSL_AET_IAR_DRC_CNTL_ES_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DRC_CNTL_GT_MASK (0x00000008u)
#define CSL_AET_IAR_DRC_CNTL_GT_SHIFT (0x00000003u)
#define CSL_AET_IAR_DRC_CNTL_GT_RESETVAL (0x00000000u)
/*----GT Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_GT_GT (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_GT_LEQ (0x00000000u)

#define CSL_AET_IAR_DRC_CNTL_LT_MASK (0x00000004u)
#define CSL_AET_IAR_DRC_CNTL_LT_SHIFT (0x00000002u)
#define CSL_AET_IAR_DRC_CNTL_LT_RESETVAL (0x00000000u)
/*----LT Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_LT_LT (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_LT_GEQ (0x00000000u)

#define CSL_AET_IAR_DRC_CNTL_EC_MASK (0x00000002u)
#define CSL_AET_IAR_DRC_CNTL_EC_SHIFT (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_EC_RESETVAL (0x00000000u)
/*----EC Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_EC_LOCAL_BP (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_EC_NORMAL (0x00000000u)

#define CSL_AET_IAR_DRC_CNTL_SCD_MASK (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_SCD_SHIFT (0x00000000u)
#define CSL_AET_IAR_DRC_CNTL_SCD_RESETVAL (0x00000000u)
/*----SCD Tokens----*/
#define CSL_AET_IAR_DRC_CNTL_SCD_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_DRC_CNTL_SCD_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_DRC_CNTL_RESETVAL (0x00000000u)

/* DRC_AREF */

#define CSL_AET_IAR_DRC_AREF_AREF_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_DRC_AREF_AREF_SHIFT (0x00000000u)
#define CSL_AET_IAR_DRC_AREF_AREF_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DRC_AREF_RESETVAL (0x00000000u)

/* DCQ_DREFL */

#define CSL_AET_IAR_DCQ_DREFL_DREFL_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_DCQ_DREFL_DREFL_SHIFT (0x00000000u)
#define CSL_AET_IAR_DCQ_DREFL_DREFL_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DCQ_DREFL_RESETVAL (0x00000000u)

/* DCQ_MREFL */

#define CSL_AET_IAR_DCQ_MREFL_MREFL_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_DCQ_MREFL_MREFL_SHIFT (0x00000000u)
#define CSL_AET_IAR_DCQ_MREFL_MREFL_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DCQ_MREFL_RESETVAL (0x00000000u)

/* DCQ_DREFH */

#define CSL_AET_IAR_DCQ_DREFH_DREFH_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_DCQ_DREFH_DREFH_SHIFT (0x00000000u)
#define CSL_AET_IAR_DCQ_DREFH_DREFH_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DCQ_DREFH_RESETVAL (0x00000000u)

/* DCQ_MREFH */

#define CSL_AET_IAR_DCQ_MREFH_MREFH_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_DCQ_MREFH_MREFH_SHIFT (0x00000000u)
#define CSL_AET_IAR_DCQ_MREFH_MREFH_RESETVAL (0x00000000u)

#define CSL_AET_IAR_DCQ_MREFH_RESETVAL (0x00000000u)

/* DCR_RSVD_0 */


#define CSL_AET_IAR_DCR_RSVD_0_RESETVAL (0x00000000u)

/* DCR_RSVD_1 */


#define CSL_AET_IAR_DCR_RSVD_1_RESETVAL (0x00000000u)

/* AUX_EVT_CNTL */


#define CSL_AET_IAR_AUX_EVT_CNTL_TDR_MASK (0x00002000u)
#define CSL_AET_IAR_AUX_EVT_CNTL_TDR_SHIFT (0x0000000Du)
#define CSL_AET_IAR_AUX_EVT_CNTL_TDR_RESETVAL (0x00000000u)

#define CSL_AET_IAR_AUX_EVT_CNTL_TMD_MASK (0x00001000u)
#define CSL_AET_IAR_AUX_EVT_CNTL_TMD_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_AUX_EVT_CNTL_TMD_RESETVAL (0x00000000u)
/*----TMD Tokens----*/
#define CSL_AET_IAR_AUX_EVT_CNTL_TMD_ENABLE (0x00000001u)
#define CSL_AET_IAR_AUX_EVT_CNTL_TMD_DISABLE (0x00000000u)

#define CSL_AET_IAR_AUX_EVT_CNTL_SCD_MASK (0x00000800u)
#define CSL_AET_IAR_AUX_EVT_CNTL_SCD_SHIFT (0x0000000Bu)
#define CSL_AET_IAR_AUX_EVT_CNTL_SCD_RESETVAL (0x00000000u)
/*----SCD Tokens----*/
#define CSL_AET_IAR_AUX_EVT_CNTL_SCD_DOMAIN1 (0x00000001u)
#define CSL_AET_IAR_AUX_EVT_CNTL_SCD_DOMAIN0 (0x00000000u)

#define CSL_AET_IAR_AUX_EVT_CNTL_SYNC_MASK (0x00000400u)
#define CSL_AET_IAR_AUX_EVT_CNTL_SYNC_SHIFT (0x0000000Au)
#define CSL_AET_IAR_AUX_EVT_CNTL_SYNC_RESETVAL (0x00000000u)
/*----SYNC Tokens----*/
#define CSL_AET_IAR_AUX_EVT_CNTL_SYNC_ENABLE (0x00000001u)
#define CSL_AET_IAR_AUX_EVT_CNTL_SYNC_DISABLE (0x00000000u)

#define CSL_AET_IAR_AUX_EVT_CNTL_EDGE_MASK (0x00000200u)
#define CSL_AET_IAR_AUX_EVT_CNTL_EDGE_SHIFT (0x00000009u)
#define CSL_AET_IAR_AUX_EVT_CNTL_EDGE_RESETVAL (0x00000000u)
/*----EDGE Tokens----*/
#define CSL_AET_IAR_AUX_EVT_CNTL_EDGE_ENABLE (0x00000001u)
#define CSL_AET_IAR_AUX_EVT_CNTL_EDGE_DISABLE (0x00000000u)

#define CSL_AET_IAR_AUX_EVT_CNTL_ALIGN_MASK (0x00000100u)
#define CSL_AET_IAR_AUX_EVT_CNTL_ALIGN_SHIFT (0x00000008u)
#define CSL_AET_IAR_AUX_EVT_CNTL_ALIGN_RESETVAL (0x00000000u)
/*----ALIGN Tokens----*/
#define CSL_AET_IAR_AUX_EVT_CNTL_ALIGN_ENABLE (0x00000001u)
#define CSL_AET_IAR_AUX_EVT_CNTL_ALIGN_DISABLE (0x00000000u)

#define CSL_AET_IAR_AUX_EVT_CNTL_EP_MASK (0x000000FFu)
#define CSL_AET_IAR_AUX_EVT_CNTL_EP_SHIFT (0x00000000u)
#define CSL_AET_IAR_AUX_EVT_CNTL_EP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_AUX_EVT_CNTL_RESETVAL (0x00000000u)

/* AE_ENA */

#define CSL_AET_IAR_AE_ENA_ENA_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_AE_ENA_ENA_SHIFT (0x00000000u)
#define CSL_AET_IAR_AE_ENA_ENA_RESETVAL (0x00000000u)

#define CSL_AET_IAR_AE_ENA_RESETVAL (0x00000000u)

/* CNT_RLD */

#define CSL_AET_IAR_CNT_RLD_VALUE_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_CNT_RLD_VALUE_SHIFT (0x00000000u)
#define CSL_AET_IAR_CNT_RLD_VALUE_RESETVAL (0x00000000u)

#define CSL_AET_IAR_CNT_RLD_RESETVAL (0x00000000u)

/* NI */

#define CSL_AET_IAR_NI_RSVD_MASK (0xFFFFFFFFu)
#define CSL_AET_IAR_NI_RSVD_SHIFT (0x00000000u)
#define CSL_AET_IAR_NI_RSVD_RESETVAL (0x00000000u)

#define CSL_AET_IAR_NI_RESETVAL (0x00000000u)

/* TB_ORS_W */


#define CSL_AET_IAR_TB_ORS_W_MASK_B_MASK (0x7FFF0000u)
#define CSL_AET_IAR_TB_ORS_W_MASK_B_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_ORS_W_MASK_B_RESETVAL (0x00000000u)


#define CSL_AET_IAR_TB_ORS_W_MASK_A_MASK (0x00007FFFu)
#define CSL_AET_IAR_TB_ORS_W_MASK_A_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_ORS_W_MASK_A_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_ORS_W_RESETVAL (0x00000000u)

/* TB_CNTL_W_1 */

#define CSL_AET_IAR_TB_CNTL_W_1_OC_MASK (0xC0000000u)
#define CSL_AET_IAR_TB_CNTL_W_1_OC_SHIFT (0x0000001Eu)
#define CSL_AET_IAR_TB_CNTL_W_1_OC_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_W_1_ESD_MASK (0x3E000000u)
#define CSL_AET_IAR_TB_CNTL_W_1_ESD_SHIFT (0x00000019u)
#define CSL_AET_IAR_TB_CNTL_W_1_ESD_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_W_1_ESC_MASK (0x01F00000u)
#define CSL_AET_IAR_TB_CNTL_W_1_ESC_SHIFT (0x00000014u)
#define CSL_AET_IAR_TB_CNTL_W_1_ESC_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_W_1_ST_DIS_MASK (0x000F0000u)
#define CSL_AET_IAR_TB_CNTL_W_1_ST_DIS_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_CNTL_W_1_ST_DIS_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_W_1_BP_OP_MASK (0x0000FFFFu)
#define CSL_AET_IAR_TB_CNTL_W_1_BP_OP_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_CNTL_W_1_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_W_1_RESETVAL (0x00000000u)

/* TB_CEXT_W_2 */

#define CSL_AET_IAR_TB_CEXT_W_2_EVEN_BP_OP_MASK (0xFFFF0000u)
#define CSL_AET_IAR_TB_CEXT_W_2_EVEN_BP_OP_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_CEXT_W_2_EVEN_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CEXT_W_2_ODD_BP_OP_MASK (0x0000FFFFu)
#define CSL_AET_IAR_TB_CEXT_W_2_ODD_BP_OP_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_CEXT_W_2_ODD_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CEXT_W_2_RESETVAL (0x00000000u)

/* TB_CEXT_W_3 */

#define CSL_AET_IAR_TB_CEXT_W_3_EVEN_BP_OP_MASK (0xFFFF0000u)
#define CSL_AET_IAR_TB_CEXT_W_3_EVEN_BP_OP_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_CEXT_W_3_EVEN_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CEXT_W_3_ODD_BP_OP_MASK (0x0000FFFFu)
#define CSL_AET_IAR_TB_CEXT_W_3_ODD_BP_OP_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_CEXT_W_3_ODD_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CEXT_W_3_RESETVAL (0x00000000u)

/* TB_CEXT_W_4 */

#define CSL_AET_IAR_TB_CEXT_W_4_EVEN_BP_OP_MASK (0xFFFF0000u)
#define CSL_AET_IAR_TB_CEXT_W_4_EVEN_BP_OP_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_CEXT_W_4_EVEN_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CEXT_W_4_ODD_BP_OP_MASK (0x0000FFFFu)
#define CSL_AET_IAR_TB_CEXT_W_4_ODD_BP_OP_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_CEXT_W_4_ODD_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CEXT_W_4_RESETVAL (0x00000000u)

/* SM_ORS */


#define CSL_AET_IAR_SM_ORS_MASK_B_MASK (0x7FFF0000u)
#define CSL_AET_IAR_SM_ORS_MASK_B_SHIFT (0x00000010u)
#define CSL_AET_IAR_SM_ORS_MASK_B_RESETVAL (0x00000000u)


#define CSL_AET_IAR_SM_ORS_MASK_A_MASK (0x00007FFFu)
#define CSL_AET_IAR_SM_ORS_MASK_A_SHIFT (0x00000000u)
#define CSL_AET_IAR_SM_ORS_MASK_A_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_ORS_RESETVAL (0x00000000u)

/* SM_CNTL_W_1 */

#define CSL_AET_IAR_SM_CNTL_W_1_OC_MASK (0xC0000000u)
#define CSL_AET_IAR_SM_CNTL_W_1_OC_SHIFT (0x0000001Eu)
#define CSL_AET_IAR_SM_CNTL_W_1_OC_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_CNTL_W_1_ESD_MASK (0x3E000000u)
#define CSL_AET_IAR_SM_CNTL_W_1_ESD_SHIFT (0x00000019u)
#define CSL_AET_IAR_SM_CNTL_W_1_ESD_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_CNTL_W_1_ESC_MASK (0x01F00000u)
#define CSL_AET_IAR_SM_CNTL_W_1_ESC_SHIFT (0x00000014u)
#define CSL_AET_IAR_SM_CNTL_W_1_ESC_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_CNTL_W_1_ST_DIS_MASK (0x000F0000u)
#define CSL_AET_IAR_SM_CNTL_W_1_ST_DIS_SHIFT (0x00000010u)
#define CSL_AET_IAR_SM_CNTL_W_1_ST_DIS_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_CNTL_W_1_BP_OP_MASK (0x0000FFFFu)
#define CSL_AET_IAR_SM_CNTL_W_1_BP_OP_SHIFT (0x00000000u)
#define CSL_AET_IAR_SM_CNTL_W_1_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_CNTL_W_1_RESETVAL (0x00000000u)

/* SM_CEXT_W_2 */

#define CSL_AET_IAR_SM_CEXT_W_2_EVEN_BP_OP_MASK (0xFFFF0000u)
#define CSL_AET_IAR_SM_CEXT_W_2_EVEN_BP_OP_SHIFT (0x00000010u)
#define CSL_AET_IAR_SM_CEXT_W_2_EVEN_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_CEXT_W_2_ODD_BP_OP_MASK (0x0000FFFFu)
#define CSL_AET_IAR_SM_CEXT_W_2_ODD_BP_OP_SHIFT (0x00000000u)
#define CSL_AET_IAR_SM_CEXT_W_2_ODD_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_SM_CEXT_W_2_RESETVAL (0x00000000u)

/* TB_ORS */


#define CSL_AET_IAR_TB_ORS_MASK_B_MASK (0x7FFF0000u)
#define CSL_AET_IAR_TB_ORS_MASK_B_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_ORS_MASK_B_RESETVAL (0x00000000u)


#define CSL_AET_IAR_TB_ORS_MASK_A_MASK (0x00007FFFu)
#define CSL_AET_IAR_TB_ORS_MASK_A_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_ORS_MASK_A_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_ORS_RESETVAL (0x00000000u)

/* TB_CNTL */

#define CSL_AET_IAR_TB_CNTL_OC_MASK (0xC0000000u)
#define CSL_AET_IAR_TB_CNTL_OC_SHIFT (0x0000001Eu)
#define CSL_AET_IAR_TB_CNTL_OC_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_ESD_MASK (0x3E000000u)
#define CSL_AET_IAR_TB_CNTL_ESD_SHIFT (0x00000019u)
#define CSL_AET_IAR_TB_CNTL_ESD_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_ESC_MASK (0x01F00000u)
#define CSL_AET_IAR_TB_CNTL_ESC_SHIFT (0x00000014u)
#define CSL_AET_IAR_TB_CNTL_ESC_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_ST_DIS_MASK (0x000F0000u)
#define CSL_AET_IAR_TB_CNTL_ST_DIS_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_CNTL_ST_DIS_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_BP_OP_MASK (0x0000FFFFu)
#define CSL_AET_IAR_TB_CNTL_BP_OP_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_CNTL_BP_OP_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TB_CNTL_RESETVAL (0x00000000u)

/* PIN_OBSV */

#define CSL_AET_IAR_PIN_OBSV_ECU_STOP_1_MASK (0x80000000u)
#define CSL_AET_IAR_PIN_OBSV_ECU_STOP_1_SHIFT (0x0000001Fu)
#define CSL_AET_IAR_PIN_OBSV_ECU_STOP_1_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_ECU_STOP_0_MASK (0x40000000u)
#define CSL_AET_IAR_PIN_OBSV_ECU_STOP_0_SHIFT (0x0000001Eu)
#define CSL_AET_IAR_PIN_OBSV_ECU_STOP_0_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_TCK_MASK (0x20000000u)
#define CSL_AET_IAR_PIN_OBSV_TCK_SHIFT (0x0000001Du)
#define CSL_AET_IAR_PIN_OBSV_TCK_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_TLR_MASK (0x10000000u)
#define CSL_AET_IAR_PIN_OBSV_TLR_SHIFT (0x0000001Cu)
#define CSL_AET_IAR_PIN_OBSV_TLR_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_TMS_MASK (0x08000000u)
#define CSL_AET_IAR_PIN_OBSV_TMS_SHIFT (0x0000001Bu)
#define CSL_AET_IAR_PIN_OBSV_TMS_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_TDI_MASK (0x04000000u)
#define CSL_AET_IAR_PIN_OBSV_TDI_SHIFT (0x0000001Au)
#define CSL_AET_IAR_PIN_OBSV_TDI_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_TDO_MASK (0x02000000u)
#define CSL_AET_IAR_PIN_OBSV_TDO_SHIFT (0x00000019u)
#define CSL_AET_IAR_PIN_OBSV_TDO_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_RSVD_MASK (0x01C00000u)
#define CSL_AET_IAR_PIN_OBSV_RSVD_SHIFT (0x00000016u)
#define CSL_AET_IAR_PIN_OBSV_RSVD_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_21_MASK (0x00200000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_21_SHIFT (0x00000015u)
#define CSL_AET_IAR_PIN_OBSV_EMU_21_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_20_MASK (0x00100000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_20_SHIFT (0x00000014u)
#define CSL_AET_IAR_PIN_OBSV_EMU_20_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_19_MASK (0x00080000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_19_SHIFT (0x00000013u)
#define CSL_AET_IAR_PIN_OBSV_EMU_19_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_18_MASK (0x00040000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_18_SHIFT (0x00000012u)
#define CSL_AET_IAR_PIN_OBSV_EMU_18_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_17_MASK (0x00020000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_17_SHIFT (0x00000011u)
#define CSL_AET_IAR_PIN_OBSV_EMU_17_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_16_MASK (0x00010000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_16_SHIFT (0x00000010u)
#define CSL_AET_IAR_PIN_OBSV_EMU_16_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_15_MASK (0x00008000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_15_SHIFT (0x0000000Fu)
#define CSL_AET_IAR_PIN_OBSV_EMU_15_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_14_MASK (0x00004000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_14_SHIFT (0x0000000Eu)
#define CSL_AET_IAR_PIN_OBSV_EMU_14_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_13_MASK (0x00002000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_13_SHIFT (0x0000000Du)
#define CSL_AET_IAR_PIN_OBSV_EMU_13_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_12_MASK (0x00001000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_12_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_PIN_OBSV_EMU_12_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_11_MASK (0x00000800u)
#define CSL_AET_IAR_PIN_OBSV_EMU_11_SHIFT (0x0000000Bu)
#define CSL_AET_IAR_PIN_OBSV_EMU_11_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_10_MASK (0x00000400u)
#define CSL_AET_IAR_PIN_OBSV_EMU_10_SHIFT (0x0000000Au)
#define CSL_AET_IAR_PIN_OBSV_EMU_10_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_9_MASK (0x00000200u)
#define CSL_AET_IAR_PIN_OBSV_EMU_9_SHIFT (0x00000009u)
#define CSL_AET_IAR_PIN_OBSV_EMU_9_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_8_MASK (0x00000100u)
#define CSL_AET_IAR_PIN_OBSV_EMU_8_SHIFT (0x00000008u)
#define CSL_AET_IAR_PIN_OBSV_EMU_8_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_7_MASK (0x00000080u)
#define CSL_AET_IAR_PIN_OBSV_EMU_7_SHIFT (0x00000007u)
#define CSL_AET_IAR_PIN_OBSV_EMU_7_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_6_MASK (0x00000040u)
#define CSL_AET_IAR_PIN_OBSV_EMU_6_SHIFT (0x00000006u)
#define CSL_AET_IAR_PIN_OBSV_EMU_6_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_5_MASK (0x00000020u)
#define CSL_AET_IAR_PIN_OBSV_EMU_5_SHIFT (0x00000005u)
#define CSL_AET_IAR_PIN_OBSV_EMU_5_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_4_MASK (0x00000010u)
#define CSL_AET_IAR_PIN_OBSV_EMU_4_SHIFT (0x00000004u)
#define CSL_AET_IAR_PIN_OBSV_EMU_4_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_3_MASK (0x00000008u)
#define CSL_AET_IAR_PIN_OBSV_EMU_3_SHIFT (0x00000003u)
#define CSL_AET_IAR_PIN_OBSV_EMU_3_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_2_MASK (0x00000004u)
#define CSL_AET_IAR_PIN_OBSV_EMU_2_SHIFT (0x00000002u)
#define CSL_AET_IAR_PIN_OBSV_EMU_2_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_1_MASK (0x00000002u)
#define CSL_AET_IAR_PIN_OBSV_EMU_1_SHIFT (0x00000001u)
#define CSL_AET_IAR_PIN_OBSV_EMU_1_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_EMU_0_MASK (0x00000001u)
#define CSL_AET_IAR_PIN_OBSV_EMU_0_SHIFT (0x00000000u)
#define CSL_AET_IAR_PIN_OBSV_EMU_0_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_OBSV_RESETVAL (0x00000000u)

/* PIN_MGR_0 */

#define CSL_AET_IAR_PIN_MGR_0_EMU_7_MASK (0xF0000000u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_7_SHIFT (0x0000001Cu)
#define CSL_AET_IAR_PIN_MGR_0_EMU_7_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_EMU_6_MASK (0x0F000000u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_6_SHIFT (0x00000018u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_6_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_EMU_5_MASK (0x00F00000u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_5_SHIFT (0x00000014u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_5_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_EMU_4_MASK (0x000F0000u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_4_SHIFT (0x00000010u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_4_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_EMU_3_MASK (0x0000F000u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_3_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_PIN_MGR_0_EMU_3_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_EMU_2_MASK (0x00000F00u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_2_SHIFT (0x00000008u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_2_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_EMU_1_MASK (0x000000F0u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_1_SHIFT (0x00000004u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_1_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_EMU_0_MASK (0x0000000Fu)
#define CSL_AET_IAR_PIN_MGR_0_EMU_0_SHIFT (0x00000000u)
#define CSL_AET_IAR_PIN_MGR_0_EMU_0_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_0_RESETVAL (0x00000000u)

/* PIN_MGR_1 */

#define CSL_AET_IAR_PIN_MGR_1_EMU_15_MASK (0xF0000000u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_15_SHIFT (0x0000001Cu)
#define CSL_AET_IAR_PIN_MGR_1_EMU_15_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_EMU_14_MASK (0x0F000000u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_14_SHIFT (0x00000018u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_14_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_EMU_13_MASK (0x00F00000u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_13_SHIFT (0x00000014u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_13_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_EMU_12_MASK (0x000F0000u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_12_SHIFT (0x00000010u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_12_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_EMU_11_MASK (0x0000F000u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_11_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_PIN_MGR_1_EMU_11_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_EMU_10_MASK (0x00000F00u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_10_SHIFT (0x00000008u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_10_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_EMU_9_MASK (0x000000F0u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_9_SHIFT (0x00000004u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_9_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_EMU_8_MASK (0x0000000Fu)
#define CSL_AET_IAR_PIN_MGR_1_EMU_8_SHIFT (0x00000000u)
#define CSL_AET_IAR_PIN_MGR_1_EMU_8_RESETVAL (0x00000000u)

#define CSL_AET_IAR_PIN_MGR_1_RESETVAL (0x00000000u)

/* TB_ENA */

#define CSL_AET_IAR_TB_ENA_TBE_31_MASK (0x80000000u)
#define CSL_AET_IAR_TB_ENA_TBE_31_SHIFT (0x0000001Fu)
#define CSL_AET_IAR_TB_ENA_TBE_31_RESETVAL (0x00000000u)
/*----TBE_31 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_31_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_31_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_30_MASK (0x40000000u)
#define CSL_AET_IAR_TB_ENA_TBE_30_SHIFT (0x0000001Eu)
#define CSL_AET_IAR_TB_ENA_TBE_30_RESETVAL (0x00000000u)
/*----TBE_30 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_30_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_30_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_29_MASK (0x20000000u)
#define CSL_AET_IAR_TB_ENA_TBE_29_SHIFT (0x0000001Du)
#define CSL_AET_IAR_TB_ENA_TBE_29_RESETVAL (0x00000000u)
/*----TBE_29 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_29_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_29_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_28_MASK (0x10000000u)
#define CSL_AET_IAR_TB_ENA_TBE_28_SHIFT (0x0000001Cu)
#define CSL_AET_IAR_TB_ENA_TBE_28_RESETVAL (0x00000000u)
/*----TBE_28 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_28_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_28_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_27_MASK (0x08000000u)
#define CSL_AET_IAR_TB_ENA_TBE_27_SHIFT (0x0000001Bu)
#define CSL_AET_IAR_TB_ENA_TBE_27_RESETVAL (0x00000000u)
/*----TBE_27 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_27_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_27_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_26_MASK (0x04000000u)
#define CSL_AET_IAR_TB_ENA_TBE_26_SHIFT (0x0000001Au)
#define CSL_AET_IAR_TB_ENA_TBE_26_RESETVAL (0x00000000u)
/*----TBE_26 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_26_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_26_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_25_MASK (0x02000000u)
#define CSL_AET_IAR_TB_ENA_TBE_25_SHIFT (0x00000019u)
#define CSL_AET_IAR_TB_ENA_TBE_25_RESETVAL (0x00000000u)
/*----TBE_25 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_25_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_25_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_24_MASK (0x01000000u)
#define CSL_AET_IAR_TB_ENA_TBE_24_SHIFT (0x00000018u)
#define CSL_AET_IAR_TB_ENA_TBE_24_RESETVAL (0x00000000u)
/*----TBE_24 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_24_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_24_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_23_MASK (0x00800000u)
#define CSL_AET_IAR_TB_ENA_TBE_23_SHIFT (0x00000017u)
#define CSL_AET_IAR_TB_ENA_TBE_23_RESETVAL (0x00000000u)
/*----TBE_23 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_23_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_23_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_22_MASK (0x00400000u)
#define CSL_AET_IAR_TB_ENA_TBE_22_SHIFT (0x00000016u)
#define CSL_AET_IAR_TB_ENA_TBE_22_RESETVAL (0x00000000u)
/*----TBE_22 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_22_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_22_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_21_MASK (0x00200000u)
#define CSL_AET_IAR_TB_ENA_TBE_21_SHIFT (0x00000015u)
#define CSL_AET_IAR_TB_ENA_TBE_21_RESETVAL (0x00000000u)
/*----TBE_21 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_21_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_21_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_20_MASK (0x00100000u)
#define CSL_AET_IAR_TB_ENA_TBE_20_SHIFT (0x00000014u)
#define CSL_AET_IAR_TB_ENA_TBE_20_RESETVAL (0x00000000u)
/*----TBE_20 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_20_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_20_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_19_MASK (0x00080000u)
#define CSL_AET_IAR_TB_ENA_TBE_19_SHIFT (0x00000013u)
#define CSL_AET_IAR_TB_ENA_TBE_19_RESETVAL (0x00000000u)
/*----TBE_19 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_19_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_19_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_18_MASK (0x00040000u)
#define CSL_AET_IAR_TB_ENA_TBE_18_SHIFT (0x00000012u)
#define CSL_AET_IAR_TB_ENA_TBE_18_RESETVAL (0x00000000u)
/*----TBE_18 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_18_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_18_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_17_MASK (0x00020000u)
#define CSL_AET_IAR_TB_ENA_TBE_17_SHIFT (0x00000011u)
#define CSL_AET_IAR_TB_ENA_TBE_17_RESETVAL (0x00000000u)
/*----TBE_17 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_17_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_17_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_16_MASK (0x00010000u)
#define CSL_AET_IAR_TB_ENA_TBE_16_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_ENA_TBE_16_RESETVAL (0x00000000u)
/*----TBE_16 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_16_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_16_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_15_MASK (0x00008000u)
#define CSL_AET_IAR_TB_ENA_TBE_15_SHIFT (0x0000000Fu)
#define CSL_AET_IAR_TB_ENA_TBE_15_RESETVAL (0x00000000u)
/*----TBE_15 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_15_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_15_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_14_MASK (0x00004000u)
#define CSL_AET_IAR_TB_ENA_TBE_14_SHIFT (0x0000000Eu)
#define CSL_AET_IAR_TB_ENA_TBE_14_RESETVAL (0x00000000u)
/*----TBE_14 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_14_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_14_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_13_MASK (0x00002000u)
#define CSL_AET_IAR_TB_ENA_TBE_13_SHIFT (0x0000000Du)
#define CSL_AET_IAR_TB_ENA_TBE_13_RESETVAL (0x00000000u)
/*----TBE_13 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_13_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_13_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_12_MASK (0x00001000u)
#define CSL_AET_IAR_TB_ENA_TBE_12_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_TB_ENA_TBE_12_RESETVAL (0x00000000u)
/*----TBE_12 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_12_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_12_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_11_MASK (0x00000800u)
#define CSL_AET_IAR_TB_ENA_TBE_11_SHIFT (0x0000000Bu)
#define CSL_AET_IAR_TB_ENA_TBE_11_RESETVAL (0x00000000u)
/*----TBE_11 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_11_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_11_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_10_MASK (0x00000400u)
#define CSL_AET_IAR_TB_ENA_TBE_10_SHIFT (0x0000000Au)
#define CSL_AET_IAR_TB_ENA_TBE_10_RESETVAL (0x00000000u)
/*----TBE_10 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_10_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_10_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_9_MASK (0x00000200u)
#define CSL_AET_IAR_TB_ENA_TBE_9_SHIFT (0x00000009u)
#define CSL_AET_IAR_TB_ENA_TBE_9_RESETVAL (0x00000000u)
/*----TBE_9 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_9_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_9_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_8_MASK (0x00000100u)
#define CSL_AET_IAR_TB_ENA_TBE_8_SHIFT (0x00000008u)
#define CSL_AET_IAR_TB_ENA_TBE_8_RESETVAL (0x00000000u)
/*----TBE_8 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_8_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_8_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_7_MASK (0x00000080u)
#define CSL_AET_IAR_TB_ENA_TBE_7_SHIFT (0x00000007u)
#define CSL_AET_IAR_TB_ENA_TBE_7_RESETVAL (0x00000000u)
/*----TBE_7 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_7_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_7_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_6_MASK (0x00000040u)
#define CSL_AET_IAR_TB_ENA_TBE_6_SHIFT (0x00000006u)
#define CSL_AET_IAR_TB_ENA_TBE_6_RESETVAL (0x00000000u)
/*----TBE_6 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_6_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_6_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_5_MASK (0x00000020u)
#define CSL_AET_IAR_TB_ENA_TBE_5_SHIFT (0x00000005u)
#define CSL_AET_IAR_TB_ENA_TBE_5_RESETVAL (0x00000000u)
/*----TBE_5 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_5_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_5_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_4_MASK (0x00000010u)
#define CSL_AET_IAR_TB_ENA_TBE_4_SHIFT (0x00000004u)
#define CSL_AET_IAR_TB_ENA_TBE_4_RESETVAL (0x00000000u)
/*----TBE_4 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_4_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_4_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_3_MASK (0x00000008u)
#define CSL_AET_IAR_TB_ENA_TBE_3_SHIFT (0x00000003u)
#define CSL_AET_IAR_TB_ENA_TBE_3_RESETVAL (0x00000000u)
/*----TBE_3 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_3_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_3_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_2_MASK (0x00000004u)
#define CSL_AET_IAR_TB_ENA_TBE_2_SHIFT (0x00000002u)
#define CSL_AET_IAR_TB_ENA_TBE_2_RESETVAL (0x00000000u)
/*----TBE_2 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_2_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_2_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_1_MASK (0x00000002u)
#define CSL_AET_IAR_TB_ENA_TBE_1_SHIFT (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_1_RESETVAL (0x00000000u)
/*----TBE_1 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_1_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_1_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_TBE_0_MASK (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_0_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_ENA_TBE_0_RESETVAL (0x00000000u)
/*----TBE_0 Tokens----*/
#define CSL_AET_IAR_TB_ENA_TBE_0_ENABLE (0x00000001u)
#define CSL_AET_IAR_TB_ENA_TBE_0_DISABLE (0x00000000u)

#define CSL_AET_IAR_TB_ENA_RESETVAL (0x00000000u)

/* TB_DM */

#define CSL_AET_IAR_TB_DM_TBDM_31_MASK (0x80000000u)
#define CSL_AET_IAR_TB_DM_TBDM_31_SHIFT (0x0000001Fu)
#define CSL_AET_IAR_TB_DM_TBDM_31_RESETVAL (0x00000000u)
/*----TBDM_31 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_31_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_31_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_30_MASK (0x40000000u)
#define CSL_AET_IAR_TB_DM_TBDM_30_SHIFT (0x0000001Eu)
#define CSL_AET_IAR_TB_DM_TBDM_30_RESETVAL (0x00000000u)
/*----TBDM_30 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_30_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_30_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_29_MASK (0x20000000u)
#define CSL_AET_IAR_TB_DM_TBDM_29_SHIFT (0x0000001Du)
#define CSL_AET_IAR_TB_DM_TBDM_29_RESETVAL (0x00000000u)
/*----TBDM_29 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_29_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_29_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_28_MASK (0x10000000u)
#define CSL_AET_IAR_TB_DM_TBDM_28_SHIFT (0x0000001Cu)
#define CSL_AET_IAR_TB_DM_TBDM_28_RESETVAL (0x00000000u)
/*----TBDM_28 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_28_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_28_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_27_MASK (0x08000000u)
#define CSL_AET_IAR_TB_DM_TBDM_27_SHIFT (0x0000001Bu)
#define CSL_AET_IAR_TB_DM_TBDM_27_RESETVAL (0x00000000u)
/*----TBDM_27 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_27_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_27_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_26_MASK (0x04000000u)
#define CSL_AET_IAR_TB_DM_TBDM_26_SHIFT (0x0000001Au)
#define CSL_AET_IAR_TB_DM_TBDM_26_RESETVAL (0x00000000u)
/*----TBDM_26 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_26_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_26_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_25_MASK (0x02000000u)
#define CSL_AET_IAR_TB_DM_TBDM_25_SHIFT (0x00000019u)
#define CSL_AET_IAR_TB_DM_TBDM_25_RESETVAL (0x00000000u)
/*----TBDM_25 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_25_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_25_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_24_MASK (0x01000000u)
#define CSL_AET_IAR_TB_DM_TBDM_24_SHIFT (0x00000018u)
#define CSL_AET_IAR_TB_DM_TBDM_24_RESETVAL (0x00000000u)
/*----TBDM_24 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_24_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_24_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_23_MASK (0x00800000u)
#define CSL_AET_IAR_TB_DM_TBDM_23_SHIFT (0x00000017u)
#define CSL_AET_IAR_TB_DM_TBDM_23_RESETVAL (0x00000000u)
/*----TBDM_23 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_23_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_23_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_22_MASK (0x00400000u)
#define CSL_AET_IAR_TB_DM_TBDM_22_SHIFT (0x00000016u)
#define CSL_AET_IAR_TB_DM_TBDM_22_RESETVAL (0x00000000u)
/*----TBDM_22 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_22_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_22_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_21_MASK (0x00200000u)
#define CSL_AET_IAR_TB_DM_TBDM_21_SHIFT (0x00000015u)
#define CSL_AET_IAR_TB_DM_TBDM_21_RESETVAL (0x00000000u)
/*----TBDM_21 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_21_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_21_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_20_MASK (0x00100000u)
#define CSL_AET_IAR_TB_DM_TBDM_20_SHIFT (0x00000014u)
#define CSL_AET_IAR_TB_DM_TBDM_20_RESETVAL (0x00000000u)
/*----TBDM_20 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_20_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_20_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_19_MASK (0x00080000u)
#define CSL_AET_IAR_TB_DM_TBDM_19_SHIFT (0x00000013u)
#define CSL_AET_IAR_TB_DM_TBDM_19_RESETVAL (0x00000000u)
/*----TBDM_19 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_19_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_19_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_18_MASK (0x00040000u)
#define CSL_AET_IAR_TB_DM_TBDM_18_SHIFT (0x00000012u)
#define CSL_AET_IAR_TB_DM_TBDM_18_RESETVAL (0x00000000u)
/*----TBDM_18 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_18_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_18_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_17_MASK (0x00020000u)
#define CSL_AET_IAR_TB_DM_TBDM_17_SHIFT (0x00000011u)
#define CSL_AET_IAR_TB_DM_TBDM_17_RESETVAL (0x00000000u)
/*----TBDM_17 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_17_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_17_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_16_MASK (0x00010000u)
#define CSL_AET_IAR_TB_DM_TBDM_16_SHIFT (0x00000010u)
#define CSL_AET_IAR_TB_DM_TBDM_16_RESETVAL (0x00000000u)
/*----TBDM_16 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_16_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_16_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_15_MASK (0x00008000u)
#define CSL_AET_IAR_TB_DM_TBDM_15_SHIFT (0x0000000Fu)
#define CSL_AET_IAR_TB_DM_TBDM_15_RESETVAL (0x00000000u)
/*----TBDM_15 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_15_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_15_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_14_MASK (0x00004000u)
#define CSL_AET_IAR_TB_DM_TBDM_14_SHIFT (0x0000000Eu)
#define CSL_AET_IAR_TB_DM_TBDM_14_RESETVAL (0x00000000u)
/*----TBDM_14 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_14_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_14_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_13_MASK (0x00002000u)
#define CSL_AET_IAR_TB_DM_TBDM_13_SHIFT (0x0000000Du)
#define CSL_AET_IAR_TB_DM_TBDM_13_RESETVAL (0x00000000u)
/*----TBDM_13 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_13_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_13_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_12_MASK (0x00001000u)
#define CSL_AET_IAR_TB_DM_TBDM_12_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_TB_DM_TBDM_12_RESETVAL (0x00000000u)
/*----TBDM_12 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_12_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_12_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_11_MASK (0x00000800u)
#define CSL_AET_IAR_TB_DM_TBDM_11_SHIFT (0x0000000Bu)
#define CSL_AET_IAR_TB_DM_TBDM_11_RESETVAL (0x00000000u)
/*----TBDM_11 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_11_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_11_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_10_MASK (0x00000400u)
#define CSL_AET_IAR_TB_DM_TBDM_10_SHIFT (0x0000000Au)
#define CSL_AET_IAR_TB_DM_TBDM_10_RESETVAL (0x00000000u)
/*----TBDM_10 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_10_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_10_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_9_MASK (0x00000200u)
#define CSL_AET_IAR_TB_DM_TBDM_9_SHIFT (0x00000009u)
#define CSL_AET_IAR_TB_DM_TBDM_9_RESETVAL (0x00000000u)
/*----TBDM_9 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_9_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_9_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_8_MASK (0x00000100u)
#define CSL_AET_IAR_TB_DM_TBDM_8_SHIFT (0x00000008u)
#define CSL_AET_IAR_TB_DM_TBDM_8_RESETVAL (0x00000000u)
/*----TBDM_8 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_8_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_8_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_7_MASK (0x00000080u)
#define CSL_AET_IAR_TB_DM_TBDM_7_SHIFT (0x00000007u)
#define CSL_AET_IAR_TB_DM_TBDM_7_RESETVAL (0x00000000u)
/*----TBDM_7 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_7_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_7_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_6_MASK (0x00000040u)
#define CSL_AET_IAR_TB_DM_TBDM_6_SHIFT (0x00000006u)
#define CSL_AET_IAR_TB_DM_TBDM_6_RESETVAL (0x00000000u)
/*----TBDM_6 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_6_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_6_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_5_MASK (0x00000020u)
#define CSL_AET_IAR_TB_DM_TBDM_5_SHIFT (0x00000005u)
#define CSL_AET_IAR_TB_DM_TBDM_5_RESETVAL (0x00000000u)
/*----TBDM_5 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_5_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_5_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_4_MASK (0x00000010u)
#define CSL_AET_IAR_TB_DM_TBDM_4_SHIFT (0x00000004u)
#define CSL_AET_IAR_TB_DM_TBDM_4_RESETVAL (0x00000000u)
/*----TBDM_4 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_4_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_4_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_3_MASK (0x00000008u)
#define CSL_AET_IAR_TB_DM_TBDM_3_SHIFT (0x00000003u)
#define CSL_AET_IAR_TB_DM_TBDM_3_RESETVAL (0x00000000u)
/*----TBDM_3 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_3_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_3_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_2_MASK (0x00000004u)
#define CSL_AET_IAR_TB_DM_TBDM_2_SHIFT (0x00000002u)
#define CSL_AET_IAR_TB_DM_TBDM_2_RESETVAL (0x00000000u)
/*----TBDM_2 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_2_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_2_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_1_MASK (0x00000002u)
#define CSL_AET_IAR_TB_DM_TBDM_1_SHIFT (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_1_RESETVAL (0x00000000u)
/*----TBDM_1 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_1_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_1_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_TBDM_0_MASK (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_0_SHIFT (0x00000000u)
#define CSL_AET_IAR_TB_DM_TBDM_0_RESETVAL (0x00000000u)
/*----TBDM_0 Tokens----*/
#define CSL_AET_IAR_TB_DM_TBDM_0_DOMAIN_1 (0x00000001u)
#define CSL_AET_IAR_TB_DM_TBDM_0_DOMAIN_0 (0x00000000u)

#define CSL_AET_IAR_TB_DM_RESETVAL (0x00000000u)

/* FUNC_CNTL */


#define CSL_AET_IAR_FUNC_CNTL_SMA_MASK (0x00800000u)
#define CSL_AET_IAR_FUNC_CNTL_SMA_SHIFT (0x00000017u)
#define CSL_AET_IAR_FUNC_CNTL_SMA_RESETVAL (0x00000000u)
/*----SMA Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_SMA_DOMAIN_0 (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_SMA_DOMAIN_1 (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_SME_MASK (0x00400000u)
#define CSL_AET_IAR_FUNC_CNTL_SME_SHIFT (0x00000016u)
#define CSL_AET_IAR_FUNC_CNTL_SME_RESETVAL (0x00000000u)
/*----SME Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_SME_DISABLE (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_SME_ENABLE (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_SMC_MASK (0x00200000u)
#define CSL_AET_IAR_FUNC_CNTL_SMC_SHIFT (0x00000015u)
#define CSL_AET_IAR_FUNC_CNTL_SMC_RESETVAL (0x00000000u)
/*----SMC Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_SMC_NOT_CONTINUOUS (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_SMC_CONTINUOUS (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_SMM_MASK (0x00100000u)
#define CSL_AET_IAR_FUNC_CNTL_SMM_SHIFT (0x00000014u)
#define CSL_AET_IAR_FUNC_CNTL_SMM_RESETVAL (0x00000000u)
/*----SMM Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_SMM_FOUR_STATE (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_SMM_TWO_STATE (0x00000001u)


#define CSL_AET_IAR_FUNC_CNTL_CTE3_MASK (0x00040000u)
#define CSL_AET_IAR_FUNC_CNTL_CTE3_SHIFT (0x00000012u)
#define CSL_AET_IAR_FUNC_CNTL_CTE3_RESETVAL (0x00000000u)
/*----CTE3 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTE3_DISABLED (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTE3_WATERMARK (0x00000001u)


#define CSL_AET_IAR_FUNC_CNTL_CTM3_MASK (0x00018000u)
#define CSL_AET_IAR_FUNC_CNTL_CTM3_SHIFT (0x0000000Fu)
#define CSL_AET_IAR_FUNC_CNTL_CTM3_RESETVAL (0x00000000u)
/*----CTM3 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTM3_MIN_WM (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTM3_MAX_WM (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_CTA2_MASK (0x00004000u)
#define CSL_AET_IAR_FUNC_CNTL_CTA2_SHIFT (0x0000000Eu)
#define CSL_AET_IAR_FUNC_CNTL_CTA2_RESETVAL (0x00000000u)
/*----CTA2 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTA2_CLK0 (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTA2_CLK1 (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_CTE2_MASK (0x00002000u)
#define CSL_AET_IAR_FUNC_CNTL_CTE2_SHIFT (0x0000000Du)
#define CSL_AET_IAR_FUNC_CNTL_CTE2_RESETVAL (0x00000000u)
/*----CTE2 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTE2_DISABLED (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTE2_ENABLED (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_CTC2_MASK (0x00001000u)
#define CSL_AET_IAR_FUNC_CNTL_CTC2_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_FUNC_CNTL_CTC2_RESETVAL (0x00000000u)
/*----CTC2 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTC2_RTM_EN (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTC2_RTM_DIS (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_CTM2_MASK (0x00000C00u)
#define CSL_AET_IAR_FUNC_CNTL_CTM2_SHIFT (0x0000000Au)
#define CSL_AET_IAR_FUNC_CNTL_CTM2_RESETVAL (0x00000000u)
/*----CTM2 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTM2_COUNT (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTM2_EVENT (0x00000001u)
#define CSL_AET_IAR_FUNC_CNTL_CTM2_CONT (0x00000002u)
#define CSL_AET_IAR_FUNC_CNTL_CTM2_ONE_SHOT (0x00000003u)


#define CSL_AET_IAR_FUNC_CNTL_CTE1_MASK (0x00000100u)
#define CSL_AET_IAR_FUNC_CNTL_CTE1_SHIFT (0x00000008u)
#define CSL_AET_IAR_FUNC_CNTL_CTE1_RESETVAL (0x00000000u)
/*----CTE1 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTE1_DISABLED (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTE1_WATERMARK (0x00000001u)


#define CSL_AET_IAR_FUNC_CNTL_CTM1_MASK (0x00000060u)
#define CSL_AET_IAR_FUNC_CNTL_CTM1_SHIFT (0x00000005u)
#define CSL_AET_IAR_FUNC_CNTL_CTM1_RESETVAL (0x00000000u)
/*----CTM1 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTM1_MIN_WM (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTM1_MAX_WM (0x00000001u)
#define CSL_AET_IAR_FUNC_CNTL_CTM1_RESERVED (0x00000002u)
#define CSL_AET_IAR_FUNC_CNTL_CTM1_RESERVED2 (0x00000003u)

#define CSL_AET_IAR_FUNC_CNTL_CTA0_MASK (0x00000010u)
#define CSL_AET_IAR_FUNC_CNTL_CTA0_SHIFT (0x00000004u)
#define CSL_AET_IAR_FUNC_CNTL_CTA0_RESETVAL (0x00000000u)
/*----CTA0 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTA0_CLK0 (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTA0_CLK1 (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_CTE0_MASK (0x00000008u)
#define CSL_AET_IAR_FUNC_CNTL_CTE0_SHIFT (0x00000003u)
#define CSL_AET_IAR_FUNC_CNTL_CTE0_RESETVAL (0x00000000u)
/*----CTE0 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTE0_DISABLED (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTE0_ENABLED (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_CTC0_MASK (0x00000004u)
#define CSL_AET_IAR_FUNC_CNTL_CTC0_SHIFT (0x00000002u)
#define CSL_AET_IAR_FUNC_CNTL_CTC0_RESETVAL (0x00000000u)
/*----CTC0 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTC0_STOP (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTC0_RUN (0x00000001u)

#define CSL_AET_IAR_FUNC_CNTL_CTM0_MASK (0x00000003u)
#define CSL_AET_IAR_FUNC_CNTL_CTM0_SHIFT (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTM0_RESETVAL (0x00000000u)
/*----CTM0 Tokens----*/
#define CSL_AET_IAR_FUNC_CNTL_CTM0_COUNT (0x00000000u)
#define CSL_AET_IAR_FUNC_CNTL_CTM0_EVENT (0x00000001u)
#define CSL_AET_IAR_FUNC_CNTL_CTM0_CONT (0x00000002u)
#define CSL_AET_IAR_FUNC_CNTL_CTM0_ONESHOT (0x00000003u)

#define CSL_AET_IAR_FUNC_CNTL_RESETVAL (0x00000000u)

/* CMPI_SEL */

#define CSL_AET_IAR_CMPI_SEL_BS7_MASK (0xF0000000u)
#define CSL_AET_IAR_CMPI_SEL_BS7_SHIFT (0x0000001Cu)
#define CSL_AET_IAR_CMPI_SEL_BS7_RESETVAL (0x00000000u)

#define CSL_AET_IAR_CMPI_SEL_BS6_MASK (0x0F000000u)
#define CSL_AET_IAR_CMPI_SEL_BS6_SHIFT (0x00000018u)
#define CSL_AET_IAR_CMPI_SEL_BS6_RESETVAL (0x00000000u)

#define CSL_AET_IAR_CMPI_SEL_BS5_MASK (0x00F00000u)
#define CSL_AET_IAR_CMPI_SEL_BS5_SHIFT (0x00000014u)
#define CSL_AET_IAR_CMPI_SEL_BS5_RESETVAL (0x00000000u)


#define CSL_AET_IAR_CMPI_SEL_OAE_MASK (0x00030000u)
#define CSL_AET_IAR_CMPI_SEL_OAE_SHIFT (0x00000010u)
#define CSL_AET_IAR_CMPI_SEL_OAE_RESETVAL (0x00000000u)
/*----OAE Tokens----*/
#define CSL_AET_IAR_CMPI_SEL_OAE_MEMORY_EVENTS (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_OAE_STALLS (0x00000001u)
#define CSL_AET_IAR_CMPI_SEL_OAE_MISC_EVENTS (0x00000002u)


#define CSL_AET_IAR_CMPI_SEL_CMP3_ADR_MASK (0x00003000u)
#define CSL_AET_IAR_CMPI_SEL_CMP3_ADR_SHIFT (0x0000000Cu)
#define CSL_AET_IAR_CMPI_SEL_CMP3_ADR_RESETVAL (0x00000000u)
/*----CMP3_ADR Tokens----*/
#define CSL_AET_IAR_CMPI_SEL_CMP3_ADR_DA0 (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_CMP3_ADR_DA1 (0x00000001u)
#define CSL_AET_IAR_CMPI_SEL_CMP3_ADR_PA (0x00000002u)
#define CSL_AET_IAR_CMPI_SEL_CMP3_ADR_RESERVED (0x00000003u)


#define CSL_AET_IAR_CMPI_SEL_CMP2_ADR_MASK (0x00000300u)
#define CSL_AET_IAR_CMPI_SEL_CMP2_ADR_SHIFT (0x00000008u)
#define CSL_AET_IAR_CMPI_SEL_CMP2_ADR_RESETVAL (0x00000000u)
/*----CMP2_ADR Tokens----*/
#define CSL_AET_IAR_CMPI_SEL_CMP2_ADR_DA0 (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_CMP2_ADR_DA1 (0x00000001u)
#define CSL_AET_IAR_CMPI_SEL_CMP2_ADR_PA (0x00000002u)
#define CSL_AET_IAR_CMPI_SEL_CMP2_ADR_RESERVED (0x00000003u)

#define CSL_AET_IAR_CMPI_SEL_CMP1_DATA_MASK (0x000000C0u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_DATA_SHIFT (0x00000006u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_DATA_RESETVAL (0x00000000u)
/*----CMP1_DATA Tokens----*/
#define CSL_AET_IAR_CMPI_SEL_CMP1_DATA_DW0 (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_DATA_DW1 (0x00000001u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_DATA_DR0 (0x00000002u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_DATA_DR1 (0x00000003u)

#define CSL_AET_IAR_CMPI_SEL_CMP1_ADR_MASK (0x00000030u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_ADR_SHIFT (0x00000004u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_ADR_RESETVAL (0x00000000u)
/*----CMP1_ADR Tokens----*/
#define CSL_AET_IAR_CMPI_SEL_CMP1_ADR_DA0 (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_ADR_DA1 (0x00000001u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_ADR_PA (0x00000002u)
#define CSL_AET_IAR_CMPI_SEL_CMP1_ADR_RESERVED (0x00000003u)

#define CSL_AET_IAR_CMPI_SEL_CMP0_DATA_MASK (0x0000000Cu)
#define CSL_AET_IAR_CMPI_SEL_CMP0_DATA_SHIFT (0x00000002u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_DATA_RESETVAL (0x00000000u)
/*----CMP0_DATA Tokens----*/
#define CSL_AET_IAR_CMPI_SEL_CMP0_DATA_DW0 (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_DATA_DW1 (0x00000001u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_DATA_DR0 (0x00000002u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_DATA_DR1 (0x00000003u)

#define CSL_AET_IAR_CMPI_SEL_CMP0_ADR_MASK (0x00000003u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_ADR_SHIFT (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_ADR_RESETVAL (0x00000000u)
/*----CMP0_ADR Tokens----*/
#define CSL_AET_IAR_CMPI_SEL_CMP0_ADR_DA0 (0x00000000u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_ADR_DA1 (0x00000001u)
#define CSL_AET_IAR_CMPI_SEL_CMP0_ADR_PA (0x00000002u)

#define CSL_AET_IAR_CMPI_SEL_RESETVAL (0x00000000u)

/* TR_CNTL */


#define CSL_AET_IAR_TR_CNTL_TCO_MASK (0x40000000u)
#define CSL_AET_IAR_TR_CNTL_TCO_SHIFT (0x0000001Eu)
#define CSL_AET_IAR_TR_CNTL_TCO_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_CPTM_MASK (0x38000000u)
#define CSL_AET_IAR_TR_CNTL_CPTM_SHIFT (0x0000001Bu)
#define CSL_AET_IAR_TR_CNTL_CPTM_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_STRM_PR_MASK (0x07F80000u)
#define CSL_AET_IAR_TR_CNTL_STRM_PR_SHIFT (0x00000013u)
#define CSL_AET_IAR_TR_CNTL_STRM_PR_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_CIDS_MASK (0x00040000u)
#define CSL_AET_IAR_TR_CNTL_CIDS_SHIFT (0x00000012u)
#define CSL_AET_IAR_TR_CNTL_CIDS_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_CEMU_STALL_MASK (0x00020000u)
#define CSL_AET_IAR_TR_CNTL_CEMU_STALL_SHIFT (0x00000011u)
#define CSL_AET_IAR_TR_CNTL_CEMU_STALL_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_DBGM_SD_MASK (0x00010000u)
#define CSL_AET_IAR_TR_CNTL_DBGM_SD_SHIFT (0x00000010u)
#define CSL_AET_IAR_TR_CNTL_DBGM_SD_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_STALL_EN_MASK (0x00008000u)
#define CSL_AET_IAR_TR_CNTL_STALL_EN_SHIFT (0x0000000Fu)
#define CSL_AET_IAR_TR_CNTL_STALL_EN_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_HPI_MASK_MASK (0x00004000u)
#define CSL_AET_IAR_TR_CNTL_HPI_MASK_SHIFT (0x0000000Eu)
#define CSL_AET_IAR_TR_CNTL_HPI_MASK_RESETVAL (0x00000000u)


#define CSL_AET_IAR_TR_CNTL_AEG_ACTIVE_MASK (0x00000C00u)
#define CSL_AET_IAR_TR_CNTL_AEG_ACTIVE_SHIFT (0x0000000Au)
#define CSL_AET_IAR_TR_CNTL_AEG_ACTIVE_RESETVAL (0x00000000u)


#define CSL_AET_IAR_TR_CNTL_STRM_EN_3_MASK (0x00000020u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_3_SHIFT (0x00000005u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_3_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_STRM_EN_2_MASK (0x00000010u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_2_SHIFT (0x00000004u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_2_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_STRM_EN_1_MASK (0x00000008u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_1_SHIFT (0x00000003u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_1_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_STRM_EN_0_MASK (0x00000004u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_0_SHIFT (0x00000002u)
#define CSL_AET_IAR_TR_CNTL_STRM_EN_0_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_STATE_MASK (0x00000003u)
#define CSL_AET_IAR_TR_CNTL_STATE_SHIFT (0x00000000u)
#define CSL_AET_IAR_TR_CNTL_STATE_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TR_CNTL_RESETVAL (0x00000000u)

/* TP_COUNTER */


#define CSL_AET_IAR_TP_COUNTER_COUNT_MASK (0x00000007u)
#define CSL_AET_IAR_TP_COUNTER_COUNT_SHIFT (0x00000000u)
#define CSL_AET_IAR_TP_COUNTER_COUNT_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TP_COUNTER_RESETVAL (0x00000000u)

/* TF_CNTL */

#define CSL_AET_IAR_TF_CNTL_RSVD_1_MASK (0xFFFF0000u)
#define CSL_AET_IAR_TF_CNTL_RSVD_1_SHIFT (0x00000010u)
#define CSL_AET_IAR_TF_CNTL_RSVD_1_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_FLUSH_MASK (0x00008000u)
#define CSL_AET_IAR_TF_CNTL_FLUSH_SHIFT (0x0000000Fu)
#define CSL_AET_IAR_TF_CNTL_FLUSH_RESETVAL (0x00000000u)
/*----FLUSH Tokens----*/
#define CSL_AET_IAR_TF_CNTL_FLUSH_FLUSH (0x00000001u)
#define CSL_AET_IAR_TF_CNTL_FLUSH_NO_FLUSH (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_CALIBRATION_MASK (0x00004000u)
#define CSL_AET_IAR_TF_CNTL_CALIBRATION_SHIFT (0x0000000Eu)
#define CSL_AET_IAR_TF_CNTL_CALIBRATION_RESETVAL (0x00000000u)
/*----CALIBRATION Tokens----*/
#define CSL_AET_IAR_TF_CNTL_CALIBRATION_IN_PHASE (0x00000001u)
#define CSL_AET_IAR_TF_CNTL_CALIBRATION_OUT_PHASE (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_LA_MASK (0x00002000u)
#define CSL_AET_IAR_TF_CNTL_LA_SHIFT (0x0000000Du)
#define CSL_AET_IAR_TF_CNTL_LA_RESETVAL (0x00000000u)
/*----LA Tokens----*/
#define CSL_AET_IAR_TF_CNTL_LA_LA_MODE (0x00000001u)
#define CSL_AET_IAR_TF_CNTL_LA_NO_LA_MODE (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_WIDTH_MASK (0x00001F00u)
#define CSL_AET_IAR_TF_CNTL_WIDTH_SHIFT (0x00000008u)
#define CSL_AET_IAR_TF_CNTL_WIDTH_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_DOUBLE_MASK (0x00000080u)
#define CSL_AET_IAR_TF_CNTL_DOUBLE_SHIFT (0x00000007u)
#define CSL_AET_IAR_TF_CNTL_DOUBLE_RESETVAL (0x00000000u)
/*----DOUBLE Tokens----*/
#define CSL_AET_IAR_TF_CNTL_DOUBLE_DOUBLED (0x00000001u)
#define CSL_AET_IAR_TF_CNTL_DOUBLE_NORMAL (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_RSVD_2_MASK (0x00000040u)
#define CSL_AET_IAR_TF_CNTL_RSVD_2_SHIFT (0x00000006u)
#define CSL_AET_IAR_TF_CNTL_RSVD_2_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_GO_MASK (0x00000020u)
#define CSL_AET_IAR_TF_CNTL_GO_SHIFT (0x00000005u)
#define CSL_AET_IAR_TF_CNTL_GO_RESETVAL (0x00000000u)
/*----GO Tokens----*/
#define CSL_AET_IAR_TF_CNTL_GO_ACTIVATE (0x00000001u)
#define CSL_AET_IAR_TF_CNTL_GO_DEACTIVATE (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_ACTIVE_MASK (0x00000010u)
#define CSL_AET_IAR_TF_CNTL_ACTIVE_SHIFT (0x00000004u)
#define CSL_AET_IAR_TF_CNTL_ACTIVE_RESETVAL (0x00000000u)
/*----ACTIVE Tokens----*/
#define CSL_AET_IAR_TF_CNTL_ACTIVE_ACTIVE (0x00000001u)
#define CSL_AET_IAR_TF_CNTL_ACTIVE_INACTIVE (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_FLOW_MASK (0x0000000Fu)
#define CSL_AET_IAR_TF_CNTL_FLOW_SHIFT (0x00000000u)
#define CSL_AET_IAR_TF_CNTL_FLOW_RESETVAL (0x00000000u)

#define CSL_AET_IAR_TF_CNTL_RESETVAL (0x00000000u)

#endif
