#ifndef _CSLR_AET_MMR_H_
#define _CSLR_AET_MMR_H_

#include <_aet.h>

#include <stdint.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile int32_t IAR_ADD;
    volatile int32_t IAR_DAT;
    volatile int32_t DP_EVT;
    volatile int32_t PID_RD;
    volatile int32_t PC;
    volatile int32_t SPL_PC;
    volatile int32_t SPL_STAT;
    volatile uint8_t RSVD0[244];
    volatile int32_t PIN_MGR_0;
    volatile int32_t PIN_MGR_1;
    volatile int32_t PIN_MGR_2;
    volatile int32_t TP_CNTL;
} CSL_Aet_mmrRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* IAR_ADD */

#define CSL_AET_MMR_IAR_ADD_BEND_MASK    (0x80000000u)
#define CSL_AET_MMR_IAR_ADD_BEND_SHIFT   (0x0000001Fu)
#define CSL_AET_MMR_IAR_ADD_BEND_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_TEND_MASK    (0x40000000u)
#define CSL_AET_MMR_IAR_ADD_TEND_SHIFT   (0x0000001Eu)
#define CSL_AET_MMR_IAR_ADD_TEND_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_PLOST_MASK   (0x20000000u)
#define CSL_AET_MMR_IAR_ADD_PLOST_SHIFT  (0x0000001Du)
#define CSL_AET_MMR_IAR_ADD_PLOST_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_DLOST_MASK   (0x10000000u)
#define CSL_AET_MMR_IAR_ADD_DLOST_SHIFT  (0x0000001Cu)
#define CSL_AET_MMR_IAR_ADD_DLOST_RESETVAL (0x00000000u)


#define CSL_AET_MMR_IAR_ADD_OVF1_MASK    (0x02000000u)
#define CSL_AET_MMR_IAR_ADD_OVF1_SHIFT   (0x00000019u)
#define CSL_AET_MMR_IAR_ADD_OVF1_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_OVF0_MASK    (0x01000000u)
#define CSL_AET_MMR_IAR_ADD_OVF0_SHIFT   (0x00000018u)
#define CSL_AET_MMR_IAR_ADD_OVF0_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_TRIG_MASK    (0x00800000u)
#define CSL_AET_MMR_IAR_ADD_TRIG_SHIFT   (0x00000017u)
#define CSL_AET_MMR_IAR_ADD_TRIG_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_REND_MASK    (0x00400000u)
#define CSL_AET_MMR_IAR_ADD_REND_SHIFT   (0x00000016u)
#define CSL_AET_MMR_IAR_ADD_REND_RESETVAL (0x00000000u)


#define CSL_AET_MMR_IAR_ADD_SMM_MASK     (0x00000200u)
#define CSL_AET_MMR_IAR_ADD_SMM_SHIFT    (0x00000009u)
#define CSL_AET_MMR_IAR_ADD_SMM_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_ST_MASK      (0x000001E0u)
#define CSL_AET_MMR_IAR_ADD_ST_SHIFT     (0x00000005u)
#define CSL_AET_MMR_IAR_ADD_ST_RESETVAL  (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_CFR_MASK     (0x0000001Fu)
#define CSL_AET_MMR_IAR_ADD_CFR_SHIFT    (0x00000000u)
#define CSL_AET_MMR_IAR_ADD_CFR_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_RESETVAL     (0x00000000u)

/* IAR_ADD_WRITE */

#define CSL_AET_MMR_IAR_ADD_WRITE_RBEND_MASK (0x80000000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_RBEND_SHIFT (0x0000001Fu)
#define CSL_AET_MMR_IAR_ADD_WRITE_RBEND_RESETVAL (0x00000000u)
/*----RBEND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_RBEND_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRITE_RTEND_MASK (0x40000000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_RTEND_SHIFT (0x0000001Eu)
#define CSL_AET_MMR_IAR_ADD_WRITE_RTEND_RESETVAL (0x00000000u)
/*----RTEND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_RTEND_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRITE_RPLOST_MASK (0x20000000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_RPLOST_SHIFT (0x0000001Du)
#define CSL_AET_MMR_IAR_ADD_WRITE_RPLOST_RESETVAL (0x00000000u)
/*----RPLOST Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_RPLOST_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRITE_RDLOST_MASK (0x10000000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_RDLOST_SHIFT (0x0000001Cu)
#define CSL_AET_MMR_IAR_ADD_WRITE_RDLOST_RESETVAL (0x00000000u)
/*----RDLOST Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_RDLOST_RESET (0x00000001u)


#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF1_MASK (0x02000000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF1_SHIFT (0x00000019u)
#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF1_RESETVAL (0x00000000u)
/*----ROVF1 Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF1_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF0_MASK (0x01000000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF0_SHIFT (0x00000018u)
#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF0_RESETVAL (0x00000000u)
/*----ROVF0 Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_ROVF0_RESET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRITE_UTRV_MASK (0x00800000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_UTRV_SHIFT (0x00000017u)
#define CSL_AET_MMR_IAR_ADD_WRITE_UTRV_RESETVAL (0x00000000u)
/*----UTRV Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_UTRV_UPDATE (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRITE_STEND_MASK (0x00400000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_STEND_SHIFT (0x00000016u)
#define CSL_AET_MMR_IAR_ADD_WRITE_STEND_RESETVAL (0x00000000u)
/*----STEND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_STEND_SET (0x00000001u)

#define CSL_AET_MMR_IAR_ADD_WRITE_RREND_MASK (0x00200000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_RREND_SHIFT (0x00000015u)
#define CSL_AET_MMR_IAR_ADD_WRITE_RREND_RESETVAL (0x00000000u)
/*----RREND Tokens----*/
#define CSL_AET_MMR_IAR_ADD_WRITE_RREND_RESET (0x00000001u)


#define CSL_AET_MMR_IAR_ADD_WRITE_ADDR_MASK (0x000003FFu)
#define CSL_AET_MMR_IAR_ADD_WRITE_ADDR_SHIFT (0x00000000u)
#define CSL_AET_MMR_IAR_ADD_WRITE_ADDR_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_ADD_WRITE_RESETVAL (0x00000000u)

/* IAR_DAT */

#define CSL_AET_MMR_IAR_DAT_DATA_MASK    (0xFFFFFFFFu)
#define CSL_AET_MMR_IAR_DAT_DATA_SHIFT   (0x00000000u)
#define CSL_AET_MMR_IAR_DAT_DATA_RESETVAL (0x00000000u)

#define CSL_AET_MMR_IAR_DAT_RESETVAL     (0x00000000u)

/* DP_EVT */

#define CSL_AET_MMR_DP_EVT_STATUS_MASK   (0xFFFFFFFFu)
#define CSL_AET_MMR_DP_EVT_STATUS_SHIFT  (0x00000000u)
#define CSL_AET_MMR_DP_EVT_STATUS_RESETVAL (0x00000000u)

#define CSL_AET_MMR_DP_EVT_RESETVAL      (0x00000000u)

/* PID_RD */

#define CSL_AET_MMR_PID_RD_AOWN_MASK     (0x80000000u)
#define CSL_AET_MMR_PID_RD_AOWN_SHIFT    (0x0000001Fu)
#define CSL_AET_MMR_PID_RD_AOWN_RESETVAL (0x00000000u)
/*----AOWN Tokens----*/
#define CSL_AET_MMR_PID_RD_AOWN_DEBUG    (0x00000000u)
#define CSL_AET_MMR_PID_RD_AOWN_APP      (0x00000001u)


#define CSL_AET_MMR_PID_RD_ID_MASK       (0x0000FFFCu)
#define CSL_AET_MMR_PID_RD_ID_SHIFT      (0x00000002u)
#define CSL_AET_MMR_PID_RD_ID_RESETVAL   (0x00000000u)

#define CSL_AET_MMR_PID_RD_STATE_MASK    (0x00000003u)
#define CSL_AET_MMR_PID_RD_STATE_SHIFT   (0x00000000u)
#define CSL_AET_MMR_PID_RD_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_AET_MMR_PID_RD_STATE_RELEASED (0x00000000u)
#define CSL_AET_MMR_PID_RD_STATE_CLAIMED (0x00000001u)
#define CSL_AET_MMR_PID_RD_STATE_ENABLED (0x00000002u)
#define CSL_AET_MMR_PID_RD_STATE_RESERVED (0x00000003u)

#define CSL_AET_MMR_PID_RD_RESETVAL      (0x00000000u)

/* PID_RD */

#define CSL_AET_MMR_PID_RD_AOWN_MASK     (0x80000000u)
#define CSL_AET_MMR_PID_RD_AOWN_SHIFT    (0x0000001Fu)
#define CSL_AET_MMR_PID_RD_AOWN_RESETVAL (0x00000000u)
/*----AOWN Tokens----*/
#define CSL_AET_MMR_PID_RD_AOWN_0X0      (0x00000000u)
#define CSL_AET_MMR_PID_RD_AOWN_0X1      (0x00000001u)


#define CSL_AET_MMR_PID_RD_STATE_MASK    (0x00000003u)
#define CSL_AET_MMR_PID_RD_STATE_SHIFT   (0x00000000u)
#define CSL_AET_MMR_PID_RD_STATE_RESETVAL (0x00000000u)
/*----STATE Tokens----*/
#define CSL_AET_MMR_PID_RD_STATE_RELEASE (0x00000000u)
#define CSL_AET_MMR_PID_RD_STATE_CLAIM   (0x00000001u)

#define CSL_AET_MMR_PID_RD_RESETVAL      (0x00000000u)

/* PC */

#define CSL_AET_MMR_PC_STATUS_MASK       (0xFFFFFFFFu)
#define CSL_AET_MMR_PC_STATUS_SHIFT      (0x00000000u)
#define CSL_AET_MMR_PC_STATUS_RESETVAL   (0x00000000u)

#define CSL_AET_MMR_PC_RESETVAL          (0x00000000u)

/* SPL_PC */

#define CSL_AET_MMR_SPL_PC_PC_MASK       (0xFFFFFFFFu)
#define CSL_AET_MMR_SPL_PC_PC_SHIFT      (0x00000000u)
#define CSL_AET_MMR_SPL_PC_PC_RESETVAL   (0x00000000u)

#define CSL_AET_MMR_SPL_PC_RESETVAL      (0x00000000u)

/* SPL_STAT */

#define CSL_AET_MMR_SPL_STAT_PC_MASK     (0xFFFFFFFFu)
#define CSL_AET_MMR_SPL_STAT_PC_SHIFT    (0x00000000u)
#define CSL_AET_MMR_SPL_STAT_PC_RESETVAL (0x00000000u)

#define CSL_AET_MMR_SPL_STAT_RESETVAL    (0x00000000u)

/* PIN_MGR_0 */

#define CSL_AET_MMR_PIN_MGR_0_PIN_VAL_MASK (0xFFFFFFFFu)
#define CSL_AET_MMR_PIN_MGR_0_PIN_VAL_SHIFT (0x00000000u)
#define CSL_AET_MMR_PIN_MGR_0_PIN_VAL_RESETVAL (0x00000000u)

#define CSL_AET_MMR_PIN_MGR_0_RESETVAL   (0x00000000u)

/* PIN_MGR_1 */

#define CSL_AET_MMR_PIN_MGR_1_PIN_VAL_MASK (0xFFFFFFFFu)
#define CSL_AET_MMR_PIN_MGR_1_PIN_VAL_SHIFT (0x00000000u)
#define CSL_AET_MMR_PIN_MGR_1_PIN_VAL_RESETVAL (0x00000000u)

#define CSL_AET_MMR_PIN_MGR_1_RESETVAL   (0x00000000u)

/* PIN_MGR_2 */

#define CSL_AET_MMR_PIN_MGR_2_PIN_VAL_MASK (0xFFFFFFFFu)
#define CSL_AET_MMR_PIN_MGR_2_PIN_VAL_SHIFT (0x00000000u)
#define CSL_AET_MMR_PIN_MGR_2_PIN_VAL_RESETVAL (0x00000000u)

#define CSL_AET_MMR_PIN_MGR_2_RESETVAL   (0x00000000u)

/* TP_CNTL */

#define CSL_AET_MMR_TP_CNTL_RSVD_MASK    (0x80000000u)
#define CSL_AET_MMR_TP_CNTL_RSVD_SHIFT   (0x0000001Fu)
#define CSL_AET_MMR_TP_CNTL_RSVD_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_TCO_MASK     (0x40000000u)
#define CSL_AET_MMR_TP_CNTL_TCO_SHIFT    (0x0000001Eu)
#define CSL_AET_MMR_TP_CNTL_TCO_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_CPTM_MASK    (0x38000000u)
#define CSL_AET_MMR_TP_CNTL_CPTM_SHIFT   (0x0000001Bu)
#define CSL_AET_MMR_TP_CNTL_CPTM_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_STRM_PR_MASK (0x07F80000u)
#define CSL_AET_MMR_TP_CNTL_STRM_PR_SHIFT (0x00000013u)
#define CSL_AET_MMR_TP_CNTL_STRM_PR_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_CIDS_MASK    (0x00040000u)
#define CSL_AET_MMR_TP_CNTL_CIDS_SHIFT   (0x00000012u)
#define CSL_AET_MMR_TP_CNTL_CIDS_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_CEMU_STALL_MASK (0x00020000u)
#define CSL_AET_MMR_TP_CNTL_CEMU_STALL_SHIFT (0x00000011u)
#define CSL_AET_MMR_TP_CNTL_CEMU_STALL_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_DBGM_MASK    (0x00010000u)
#define CSL_AET_MMR_TP_CNTL_DBGM_SHIFT   (0x00000010u)
#define CSL_AET_MMR_TP_CNTL_DBGM_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_STALL_EN_MASK (0x00008000u)
#define CSL_AET_MMR_TP_CNTL_STALL_EN_SHIFT (0x0000000Fu)
#define CSL_AET_MMR_TP_CNTL_STALL_EN_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_HPI_MASK_MASK (0x00004000u)
#define CSL_AET_MMR_TP_CNTL_HPI_MASK_SHIFT (0x0000000Eu)
#define CSL_AET_MMR_TP_CNTL_HPI_MASK_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_RSVD_1_MASK  (0x00003000u)
#define CSL_AET_MMR_TP_CNTL_RSVD_1_SHIFT (0x0000000Cu)
#define CSL_AET_MMR_TP_CNTL_RSVD_1_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_AEGA_MASK    (0x00000C00u)
#define CSL_AET_MMR_TP_CNTL_AEGA_SHIFT   (0x0000000Au)
#define CSL_AET_MMR_TP_CNTL_AEGA_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_RSVD_2_MASK  (0x000003C0u)
#define CSL_AET_MMR_TP_CNTL_RSVD_2_SHIFT (0x00000006u)
#define CSL_AET_MMR_TP_CNTL_RSVD_2_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_STRM_EN_MASK (0x0000003Cu)
#define CSL_AET_MMR_TP_CNTL_STRM_EN_SHIFT (0x00000002u)
#define CSL_AET_MMR_TP_CNTL_STRM_EN_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_STATE_MASK   (0x00000003u)
#define CSL_AET_MMR_TP_CNTL_STATE_SHIFT  (0x00000000u)
#define CSL_AET_MMR_TP_CNTL_STATE_RESETVAL (0x00000000u)

#define CSL_AET_MMR_TP_CNTL_RESETVAL     (0x00000000u)

#endif

