/*
 * main.c
 */

#include "stdio.h"
#include "stdlib.h"
#include "list.h"
#include "CPP_lib.h"
#include "csl_cache.h"
#include "csl_cacheAux.h"
#include "Hook.h"

#include "ETB_Profile.h"

int par_a = 111;
int par_b = 9;
int par_c = 0;

#pragma DATA_SECTION(".test");
#pragma DATA_ALIGN(256);
MyClass myclass;

uint32_t *pDmaMemory = (uint32_t *)EDMA_DEST_ADDRESS;
ETBHandle* pETBHandle;
DSPTraceHandle* pDSPHandle;


void my_function()
{
	unsigned int a, b;

	printf("The address of a is 0x%08X, address of b is 0x%08X", &a, &b);

	return;
}


int main(void)
{
	unsigned int i;

    TraceJOBConfig  tProfileConfig;

    Init_Profile(pDmaMemory, &tProfileConfig);
    tProfileConfig.tracetype = AET_TRACE_TIMING | AET_TRACE_PA;
    tProfileConfig.startProfileAddr = (uint32_t) &function_hook_init;
#if !USE_TEND
    tProfileConfig.endProfileAddr = (uint32_t) &defined_function;
#endif

    Setup_ETB_Profile(&tProfileConfig,&pETBHandle, &pDSPHandle);


	function_hook_init();

    /* Open L1D Cache for All Cores */
    CACHE_setL1DSize(CACHE_L1_32KCACHE);

    /* Make function profile record buffer non-cacheable */
    for(i=((Uint32)ProfileData)/(16*1024*1024);	i<= (((Uint32)ProfileData)+sizeof(ProfileData))/(16*1024*1024); i++)
    {
    	CACHE_disableCaching(i);
    }

	myclass.a = 0xABCD;

	//printf("The value of myclass.a is 0x%08X! \n", myclass.a);

	par_c = func(par_a, par_b);

	printf("The base address of 'myclass' is 0x%08X! \n", myclass);

	my_function();

	defined_function();

    Stop_ETB_Profile(&tProfileConfig,&pETBHandle,&pDSPHandle);


	return 0;

}
