/******************************************************************************
 * Copyright (c) 2010-2011 Texas Instruments Incorporated - http://www.ti.com
 * 
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 *****************************************************************************/
/*
 *  Linker command file
 *
 */

-c
-heap  0x02000000
-stack 0xa000

/* Memory Map 1 - the default */
MEMORY
{
    L1PSRAM (RWX)  : org = 0x0E00000, len = 0x7FFF
    L1DSRAM (RWX)  : org = 0x0F00000, len = 0x7FFF 
    BOOT_MEM:    origin = 0x00800000 length = 0x00001000 /* This address is used for no boot mode */

    DDR3 (RWX)     : org = 0x80000000,len = 0x10000000
    DDR3_NO_CACHE  : org = 0x90000000, len = 0x10000000

    MAIL_BOX_MEM: origin =0x00801000 length = 0x00000100 /* L2 RAM dedicated for mail_box section so that the host testcase knows what address to refer to. */
    ETBLIB_DMA_DATA_MEM: origin = 0x00801100 length = 0x000000FF
    L2_MEM:      origin = 0x008011FF length = 0x0007ee00 /* This is for local SRAM, could be used as cache. */
    MSMC_MEM:      origin = 0x0C1FF000 length = 0x00001000 /* MSMC SRAM. */


}

SECTIONS
{
    .csl_vect   >       L2_MEM
    .text       >       L2_MEM
    GROUP (NEAR_DP)
    {
    .neardata
    .rodata 
    .bss
    } load > L2_MEM
    .stack      >       L2_MEM
    .cinit      >       L2_MEM
    .cio        >       L2_MEM
    .const      >       L2_MEM
    .data       >       L2_MEM
    .switch     >       L2_MEM
    .sysmem     >       DDR3
    .far        >       L2_MEM
    .testMem    >       L2_MEM
    .fardata    >       L2_MEM
    platform_lib > 		0x0C1FF000
    .c6xabi.exidx >		MSMC_MEM
    .c6xabi.extab >		MSMC_MEM
    .test		>		L2_MEM
    .far:External_NonCache_Data > DDR3_NO_CACHE

    /* custom section used by on_trace_1.c, cross_trig.c and sl2_swbp.c */
    .mail_box			>   	MAIL_BOX_MEM

    ETBLib_dmaData > ETBLIB_DMA_DATA_MEM
	ETBLib_ExtMem > MSMC_MEM

}
