/******************************************************************************/
/*            Copyright (c) 2011 Texas Instruments, Incorporated.             */
/*                           All Rights Reserved.                             */
/******************************************************************************/

/*!
********************************************************************************
@file     TestAppDecoder.c
@brief    This is the top level client file that drives the JPEG
          (Progressive Support) Image Decoder Call using XDM Interface
@author   Multimedia Codecs TI India
@version  0.1 - July 23,2011    initial version
********************************************************************************
*/

/* Standard C header files */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* JPEG Interface header files */
#include "ti/sdo/codecs/jpegdec/jpegdec_ti.h"
#include "jpegdec.h"


/* CSL and DMAN3 header files                                                 */
#include <ti/sysbios/family/c66/Cache.h>
#include <ti/sysbios/BIOS.h>
#include <ti/ipc/Ipc.h>
#include <ti/sysbios/knl/Task.h>

#define PROFILING

/* Client header file */
#include "TestAppDecoder.h"

/* Input buffer allocation */
#pragma    DATA_SECTION(inputData, ".input_buffer")
XDAS_Int8 inputData[INPUT_BUFFER_SIZE];

/* Output buffer allocation */
#pragma    DATA_SECTION(outputData, ".display_buffer")
XDAS_Int8  outputData[OUTPUT_BUFFER_SIZE];

/* Output buffer allocation */
#pragma    DATA_SECTION(refData, ".ref_buffer")
XDAS_Int8  refData[OUTPUT_BUFFER_SIZE];

JPEGDEC_Handle    handle;
JPEGDEC_Params    jpegdecParams;
JPEGDEC_DynamicParams    jpegdecDynamicParams;
JPEGDEC_Status    jpegdecStatus;
JPEGDEC_InArgs	  jpegdecInArgs;
JPEGDEC_OutArgs   jpegdecOutArgs;

XDAS_UInt32 resizeOption,progressiveDecFlag,RGB_Format,alpha_rgb;
XDAS_UInt32 outImgRes,numMCU_row,x_org,y_org,x_length,y_length;

XDAS_Int8  *store_outptr1,*store_outptr2,*store_outptr3;

sTokenMapping sTokenMap[] =
{
  {(XDAS_Int8 *)"ImageHeight",    &jpegdecParams.imgdecParams.maxHeight},
  {(XDAS_Int8 *)"ImageWidth",     &jpegdecParams.imgdecParams.maxWidth},
  {(XDAS_Int8 *)"Scan",			 &jpegdecParams.imgdecParams.maxScans},
  {(XDAS_Int8 *)"ChromaFormat",   &jpegdecParams.imgdecParams.forceChromaFormat},
  {(XDAS_Int8 *)"InputFormat",    &jpegdecParams.progressiveDecFlag},
  {(XDAS_Int8 *)"ResizeOption",   &jpegdecDynamicParams.resizeOption},
  {(XDAS_Int8 *)"displayWidth",   &jpegdecDynamicParams.imgdecDynamicParams.displayWidth},
  {(XDAS_Int8 *)"RGB_Format",     &RGB_Format},
  {(XDAS_Int8 *)"outImgRes",      &outImgRes},
  {(XDAS_Int8 *)"numAU",          &jpegdecDynamicParams.imgdecDynamicParams.numAU},
  {(XDAS_Int8 *)"numMCU_row",     &jpegdecDynamicParams.numMCU_row},
  {(XDAS_Int8 *)"x_org",     &jpegdecDynamicParams.x_org},
  {(XDAS_Int8 *)"y_org",     &jpegdecDynamicParams.y_org},
  {(XDAS_Int8 *)"x_length",     &jpegdecDynamicParams.x_length},
  {(XDAS_Int8 *)"y_length",     &jpegdecDynamicParams.y_length},
  {(XDAS_Int8 *)"alpha_rgb",     &jpegdecDynamicParams.alpha_rgb},
  {NULL,             NULL}
};
XDAS_Void  TestApp_SetSizes();
XDAS_Int32 DecodeTask (void);
static char *TempBuff; //= (char *)malloc(400 * 240 * 3);
//char ScaleBuff[400 * 240 * 3] = {0};

/* ===========================================================================*/
/*                                                                            */
/*@func   main()                                                              */
/*                                                                            */
/*@brief  main function to create decode task and start BIOS                  */
/*                                                                            */
/*@param  none                                                                */
/*                                                                            */
/* ===========================================================================*/
void main(void)
{
    Task_Params taskParams;
    /* Call Ipc_start() */
    Ipc_start();

    /* Create encode task  */
    Task_Params_init(&taskParams);
    taskParams.stackSize = 0x2000;
    Task_create((Task_FuncPtr)DecodeTask, &taskParams, NULL);

    /* Call BIOS_start() */
    BIOS_start();
}
/* Main Function acting as a client for Image Decode Call */
XDAS_Int32 DecodeTask()
{
  /* File I/O variables                                                       */
  FILE *fConfigFile, *ftestFile, *finFile, *fparamsFile;

  XDAS_Int8 line[STRING_SIZE], inFile[STRING_SIZE], testFile[STRING_SIZE];
  XDAS_Int8 paramsFile[STRING_SIZE], testCompliance;

#ifdef MSVC
  XDAS_Int8 *fname = "..\\..\\..\\..\\AlgTest\\TestVecs\\Scripts\\Copy of Testvecs.cfg";
#else
  XDAS_Int8 *fname = (XDAS_Int8 *)"..\\..\\..\\Test\\TestVecs\\Config\\Testvecs.cfg";
#endif

  /* Input/Output  buffers  and their sizes                                   */
  //XDAS_UInt8*  pInputBuf  [XDM_MAX_IO_BUFFERS];
  //XDAS_UInt8*  pOutputBuf [XDM_MAX_IO_BUFFERS];
  //XDAS_UInt8   inBufSize  [XDM_MAX_IO_BUFFERS];
  //XDAS_UInt8   outBufSize [XDM_MAX_IO_BUFFERS];
  XDAS_UInt32  ii;

  IIMGDEC1_Fxns *IIMGDEC1Fxns;

  JPEGDEC_Params *params = (JPEGDEC_Params*)&jpegdecParams;
  JPEGDEC_DynamicParams *dynamicParams =
    						(JPEGDEC_DynamicParams*)&jpegdecDynamicParams;
  JPEGDEC_Status *status = (JPEGDEC_Status*)&jpegdecStatus;
  JPEGDEC_InArgs *inArgs = (JPEGDEC_InArgs*)&jpegdecInArgs;
  JPEGDEC_OutArgs *outArgs = (JPEGDEC_OutArgs*)&jpegdecOutArgs;
  
  /* Algorithm specific handle                                                */
  IALG_Handle handle;

  /* Input/Output Buffer Descriptors                                          */
  XDM1_BufDesc inputBufDesc, outputBufDesc;

  /* DMAN3 specific variables */

  /* Input Buffer Management specific variables                               */
  XDAS_Int32 validBytes;
  XDAS_UInt32 bytesConsumed;

  /* Other variables                                                          */
  XDAS_Int32  ScanCount, retVal, testVal, countConfigSet;

  /* Enable Cache Settings  ELF */

  TestApp_EnableCache();

  /* Open Test Config File                                                    */
  fConfigFile = fopen((const char *)fname,"r");

  if (!fConfigFile)
  {
    printf("Couldn't open parameter file %s",fname);
    return XDM_EFAIL;
  }

  countConfigSet = 1; /* Reset countConfigSet value to 1 */

  /* Read the Config File until it reaches the end of file                    */
  while(!feof(fConfigFile))
  {
	  int byteremain=0,inputsize = 0;
	  store_outptr1 = outputBufDesc.descs[0].buf;
	  store_outptr2 = outputBufDesc.descs[1].buf;
	  store_outptr3 = outputBufDesc.descs[2].buf;
    /* Read Compliance Checking parameter */
    if(fgets((char *)line,254,fConfigFile))
    {
      sscanf((char *)line,"%d",&testCompliance);
    }
    else
    {
      break ;
    }
    /* Read Parameters file name */
    if(fgets((char *)line,254,fConfigFile))
    {
      sscanf((char *)line,"%s",paramsFile);
    }
    else
    {
      break ;
    }
    /* Read Input file name */
    if(fgets((char *)line,254,fConfigFile))
    {
      sscanf((char *)line,"%s",inFile);
    }
    else
    {
      break ;
    }

    /* Read Output/Reference file name */
    if(fgets((char *)line,254,fConfigFile))
    {
      sscanf((char *)line,"%s",testFile);
    }
    else
    {
      break ;
    }

    printf("\n*******************************************");
    printf("\nRead Configuration Set %d",countConfigSet);
    printf("\n*******************************************");
    countConfigSet++;

    /* Open Parameters file                                                   */
    fparamsFile = fopen ((char *)paramsFile, "rb");
    if (!fparamsFile)
    {
      printf("\nCouldn't open Parameters file...   %s\n ",paramsFile);
      printf("Exiting for this configuration...\n");
      continue;
    }

    if(readparamfile(fparamsFile) < 0)
    {
      printf("\nSyntax Error in %s\n ",paramsFile);
      printf("Exiting for this configuration...\n");
      continue;
    }

    /* Close Parameters File                                                  */
    fclose(fparamsFile);

    if(testCompliance)
    {
      printf("\nRunning in Compliance Mode");
    }
    else
    {
      printf("\nRunning in Output Dump Mode");
    }

    /* Open input file                                                        */
    finFile = fopen ((char *)inFile, "rb");
    if (!finFile)
    {
      printf("\n Couldn't open Input file...  %s  ",inFile);
      printf("\n Exiting for this configuration...");
      continue;
    }

    /* Open output/reference file                                             */
    if(testCompliance)
    {
      ftestFile = fopen ((char *)testFile, "rb");
    }
    else
    {
      ftestFile = fopen ((char *)testFile, "wb");
    }
    if( !ftestFile)
    {
      printf("Couldn't open Test File... %s",testFile);
      printf("\n Exiting for this configuration..." );
      continue;
    }

    /* Initialization of parameters needed for Algorithm Instance create      */
    TestApp_SetInitParams((IIMGDEC1_Params *)params);

    /* Number of Algorithms: System Parameter                                 */
    TestApp_SetSizes();

    /* Initializing Variables                                                */
    ScanCount                   = 1;

    /* Read the bitstream in the Application Input Buffer                    */
    validBytes = TestApp_ReadByteStream(finFile);
    printf("validBytes:%d\r\n",validBytes);
    //do_savebmp("testsrc.bmp",800,480,24,inputData);
    fclose(finFile);

#ifdef ENABLE_CACHE
     /* Cache clean */
#ifndef MSVC
	Cache_wbInvAll();
#endif
#endif

    /* Return if there is an error in reading the file                       */
    if (validBytes < 0) /* Error condition                                   */
    {
      printf("Valid Bytes incorrect... Exiting for this configuration...\n");
      continue;
    }
	//params->outImgRes = 1;

    /* Create the Algorithm object (instance)                                */
    printf("\nCreating Algorithm Instance...");
while(1)
{
    if ((handle =  (IALG_Handle)ALG_create (
      ( IALG_Fxns *) &JPEGDEC_TI_IJPEGDEC,
      (IALG_Handle) NULL, (IALG_Params *) params)) == NULL)
    {
      printf( "\nFailed to Create Instance... Exiting for this configuration..");
      //continue;
    }
    printf("\nAlgorithm Instance Creation Done...\n");

/*
    dynamicParams.progDisplay = 0;
    dynamicParams.RGB_Format = 0;
	dynamicParams.resizeOption = resizeOption = 0; */
	/*since we don't have bytesgenerated in base class we are making it as zero.*/
	/*we need bytesgenerated to incrementthe o/p buffer*/
/*
	dynamicParams.imgdecDynamicParams.numAU = 0;
	dynamicParams.numMCU_row = 0;
	dynamicParams.alpha_rgb = 0;

	dynamicParams.x_org =  0;
	dynamicParams.y_org =  0;
	dynamicParams.x_length = 0;
	dynamicParams.y_length = 0;
	dynamicParams.imgdecDynamicParams.displayWidth = 0;
*/

    TestApp_SetDynamicParams((IIMGDEC1_DynamicParams *)dynamicParams);

    /* set space for buffer descriptors                                      */
    //inputBufDesc.descs[0].buf = (XDAS_Int8 *)pInputBuf; //ct del
    //outputBufDesc.descs[0].buf = (XDAS_Int8 *)pOutputBuf;
    inputBufDesc.descs[0].bufSize = (XDAS_Int32 )INPUT_BUFFER_SIZE ;
    outputBufDesc.descs[0].bufSize = (XDAS_Int32)OUTPUT_BUFFER_SIZE ;

    inputBufDesc.descs[0].buf     = inputData;
    outputBufDesc.descs[0].buf     = outputData;

    /* Assigning Algorithm handle fxns field to IIMGDEC1fxns                  */
    IIMGDEC1Fxns = (IIMGDEC1_Fxns *)handle->fxns;

    /* Resetting bytesGenerated variable                                     */
    bytesConsumed = 0;

    dynamicParams->imgdecDynamicParams.decodeHeader = XDM_PARSE_HEADER;
       /* Activate the Algorithm                                              */
    handle->fxns->algActivate(handle);

	/* Assign the number of bytes available                                */
	inArgs->imgdecInArgs.numBytes        = validBytes;
	dynamicParams->frame_numbytes = inArgs->imgdecInArgs.numBytes;
	inputBufDesc.descs[0].buf   = (XDAS_Int8 *)((XDAS_Int32) inputData +
	bytesConsumed);

	/* Get Buffer information                                              */
	IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle, XDM_GETBUFINFO,
	(IIMGDEC1_DynamicParams *)dynamicParams,
	(IIMGDEC1_Status *)	status);

	/* Fill up the buffers as required by algorithm                        */
	inputBufDesc.numBufs     = status->imgdecStatus.bufInfo.minNumInBufs ;
	inputBufDesc.descs[0].bufSize = status->imgdecStatus.bufInfo.minInBufSize[0];

	for(ii=0; ii<(status->imgdecStatus.bufInfo.minNumInBufs-1);ii++ )
	{
		inputBufDesc.descs[ii+1].buf = inputBufDesc.descs[ii].buf +
		  status->imgdecStatus.bufInfo.minInBufSize[ii];
		inputBufDesc.descs[ii+1].bufSize=
		  status->imgdecStatus.bufInfo.minInBufSize[ii +1];
	}

	outputBufDesc.numBufs     = status->imgdecStatus.bufInfo.minNumOutBufs ;
	outputBufDesc.descs[0].bufSize = status->imgdecStatus.bufInfo.minOutBufSize[0];
	for(ii=0; ii<(status->imgdecStatus.bufInfo.minNumOutBufs-1);ii++ )
	{
		outputBufDesc.descs[ii+1].buf = outputBufDesc.descs[ii].buf +
		  status->imgdecStatus.bufInfo.minOutBufSize[ii];
		outputBufDesc.descs[ii+1].bufSize =
		  status->imgdecStatus.bufInfo.minOutBufSize[ii+1];
	}


   /* Cache Invalidate for Input Buffer                                   */
      for(ii=0 ; ii < inputBufDesc.numBufs ; ii++ )
      {
        /* Cache Invalidate for Input Buffer                                 */
#ifndef MSVC
 	Cache_inv(inputBufDesc.descs[ii].buf, validBytes,Cache_Type_ALL, TRUE);
#endif

      }

    IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle, XDM_SETPARAMS,
        (IIMGDEC1_DynamicParams *)dynamicParams,
        (IIMGDEC1_Status *)status);

	/* Basic Algorithm process() call                                      */
	retVal = IIMGDEC1Fxns->process((IIMGDEC1_Handle)handle,
	(XDM1_BufDesc *)&inputBufDesc,
	(XDM1_BufDesc *)&outputBufDesc,
	(IIMGDEC1_InArgs *)inArgs,
	(IIMGDEC1_OutArgs *)outArgs);



	IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle, XDM_GETSTATUS,
	(IIMGDEC1_DynamicParams *)dynamicParams,
	(IIMGDEC1_Status *)status);


	dynamicParams->imgdecDynamicParams.decodeHeader = XDM_DECODE_AU;
	IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle, XDM_RESET,
	(IIMGDEC1_DynamicParams *)dynamicParams,
	(IIMGDEC1_Status *)status);

	/* DeActivate the Algorithm                                            */
    handle->fxns->algDeactivate(handle);

    bytesConsumed = 0;

      /* Activate the Algorithm                                              */
      handle->fxns->algActivate(handle);

      /* Assign the number of bytes available                                */
      inArgs->imgdecInArgs.numBytes        = validBytes;
      inputBufDesc.descs[0].buf   = (XDAS_Int8 *)((XDAS_Int32) inputData );

      /* Get Buffer information                                              */
      IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle, XDM_GETBUFINFO,
        (IIMGDEC1_DynamicParams *)dynamicParams,
        (IIMGDEC1_Status *)status);

      /* Fill up the buffers as required by algorithm                        */
      inputBufDesc.numBufs     = status->imgdecStatus.bufInfo.minNumInBufs ;
      inputBufDesc.descs[0].bufSize = status->imgdecStatus.bufInfo.minInBufSize[0];

      for(ii=0; ii<(status->imgdecStatus.bufInfo.minNumInBufs-1);ii++ )
      {
          inputBufDesc.descs[ii+1].buf = inputBufDesc.descs[ii].buf +
          status->imgdecStatus.bufInfo.minInBufSize[ii];
		  		inputBufDesc.descs[ii+1].bufSize=
          status->imgdecStatus.bufInfo.minInBufSize[ii +1];
      }

      outputBufDesc.numBufs     = status->imgdecStatus.bufInfo.minNumOutBufs ;
      outputBufDesc.descs[0].bufSize = status->imgdecStatus.bufInfo.minOutBufSize[0];
      for(ii=0; ii<(status->imgdecStatus.bufInfo.minNumOutBufs-1);ii++ )
      {
          outputBufDesc.descs[ii+1].buf = outputBufDesc.descs[ii].buf +
          status->imgdecStatus.bufInfo.minOutBufSize[ii];
		  		outputBufDesc.descs[ii+1].bufSize =
          status->imgdecStatus.bufInfo.minOutBufSize[ii+1];
      }

      /* Optional: Set Run time parameters in the Algorithm via control()    */
      IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle, XDM_SETPARAMS,
        (IIMGDEC1_DynamicParams *)dynamicParams,
        (IIMGDEC1_Status *)status);

      /* Cache Invalidate for Input Buffer                                   */
      for(ii=0 ; ii < inputBufDesc.numBufs ; ii++ )
      {
        /* Cache Invalidate for Input Buffer */
#ifndef MSVC
	Cache_inv(inputBufDesc.descs[ii].buf, validBytes,Cache_Type_ALL, TRUE);
#endif
      }

	  store_outptr1 = outputBufDesc.descs[0].buf;
	  store_outptr2 = outputBufDesc.descs[1].buf;
	  store_outptr3 = outputBufDesc.descs[2].buf;

    /* Do-While Loop for Decode Call                                         */
    do
    {

	  byteremain = inArgs->imgdecInArgs.numBytes; // newly added
		inputsize = byteremain;

	  if( dynamicParams->numMCU_row !=0) // newly added for sliced
	  {
		if(byteremain <=(inputsize* dynamicParams->numMCU_row ))
			inArgs->imgdecInArgs.numBytes = byteremain;
		else
			inArgs->imgdecInArgs.numBytes  = inputsize* dynamicParams->numMCU_row ;
		if(inArgs->imgdecInArgs.numBytes > dynamicParams->frame_numbytes)
			inArgs->imgdecInArgs.numBytes = dynamicParams->frame_numbytes;
	  }

	  /* Basic Algorithm process() call                                      */
      retVal = IIMGDEC1Fxns->process((IIMGDEC1_Handle)handle,
        (XDM1_BufDesc *)&inputBufDesc,
        (XDM1_BufDesc *)&outputBufDesc,
        (IIMGDEC1_InArgs *)inArgs,
        (IIMGDEC1_OutArgs *)outArgs);

      /* Cache Writeback Invalidate for Output Buffers                       */
      if(outputBufDesc.descs[0].buf != NULL)
	  {
        for(ii=0 ; ii < outputBufDesc.numBufs ; ii++ )
        {
#ifndef MSVC
		  Cache_wbInv(outputBufDesc.descs[ii].buf,
          outputBufDesc.descs[ii].bufSize, Cache_Type_ALL, TRUE);
#endif
        }
	  }

	  byteremain -= outArgs->imgdecOutArgs.bytesConsumed;

	  if(dynamicParams->numMCU_row )
	  {
		inputBufDesc.descs[0].buf += outArgs->imgdecOutArgs.bytesConsumed;
	    inArgs->imgdecInArgs.numBytes -= outArgs->imgdecOutArgs.bytesConsumed;
	  }

      bytesConsumed          += outArgs->imgdecOutArgs.bytesConsumed;

      if(retVal == XDM_EFAIL)
      {
        printf("\n Process function returned an Error...  ");
        break; /* Error Condition: Application may want to break off         */
      }

      /* Optional: Read status via control()                                 */
      IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle,
        XDM_GETSTATUS,
        (IIMGDEC1_DynamicParams *)dynamicParams,
        (IIMGDEC1_Status *)status);

	  if(status->mode == 0) // sequential baseline
	  {
		outputBufDesc.descs[0].buf += status->bytesgenerated[0];
		outputBufDesc.descs[1].buf += status->bytesgenerated[1];
		outputBufDesc.descs[2].buf += status->bytesgenerated[2];
	  }
	  else if((status->mode == 1)) // Non interlaeved sequential
	  {
		if(params->imgdecParams.forceChromaFormat!=8)
		{
			outputBufDesc.descs[0].buf += status->bytesgenerated[0];
			outputBufDesc.descs[1].buf += status->bytesgenerated[1];
			outputBufDesc.descs[2].buf += status->bytesgenerated[2];
		}
	  }
	  else if(status->mode != 2)
	  {
		outputBufDesc.descs[0].buf += status->bytesgenerated[0];
		outputBufDesc.descs[1].buf += status->bytesgenerated[1];
		outputBufDesc.descs[2].buf += status->bytesgenerated[2];
	  }

	  if(( outArgs->imgdecOutArgs.extendedError != JPEGDEC_SUCCESS))
	  {
			printf("\n Decoder ERROR %0x \n ",outArgs->imgdecOutArgs.extendedError);
			break;
	  }

      /* Check for frame ready via display buffer pointers                   */
      if(outputBufDesc.descs[0].buf != NULL)
      {
        printf("\n Decoded Frame # %d  ",ScanCount);

        ScanCount++;
      }
      if(ScanCount == 876)
      {
    	  printf("for debug");
      }
	  if( status->end_of_scan == 1)
	  {
	    outputBufDesc.descs[0].buf = store_outptr1;
		outputBufDesc.descs[1].buf = store_outptr2;
		outputBufDesc.descs[2].buf = store_outptr3;
	  }
 	  if(status->end_of_seq  == 1)
	  {
        outputBufDesc.descs[0].buf = store_outptr1;
		outputBufDesc.descs[1].buf = store_outptr2;
		outputBufDesc.descs[2].buf = store_outptr3;
		break;
	  }

    }  while(1);  /* end of Do-While loop                                    */

      /* DeActivate the Algorithm                                            */
       handle->fxns->algDeactivate(handle);


		IIMGDEC1Fxns->control((IIMGDEC1_Handle)handle,
        XDM_GETSTATUS,
        (IIMGDEC1_DynamicParams *)dynamicParams,
        (IIMGDEC1_Status *)status);

	 for(ii=0; ii<(status->imgdecStatus.bufInfo.minNumOutBufs);ii++ )
      {

        outputBufDesc.descs[ii].bufSize =
          status->imgdecStatus.bufInfo.minOutBufSize[ii];
      }


	  if(( outArgs->imgdecOutArgs.extendedError == JPEGDEC_SUCCESS))
	  {

		if(!dynamicParams->progDisplay)
		{
	        if(testCompliance)
	        {
	          /* Compare the output frames with the Reference File               */
	          testVal = TestApp_CompareOutputData(ftestFile,
	            &outputBufDesc,
	            (IIMGDEC1_OutArgs *)outArgs);

	          if(testVal == XDM_EOK)
	          {
	            printf("\n Decoder compliance test passed for this frame.  ");
	          }
	          else
	          {
	            /* Test Compliance Failed... Breaking...                         */
	            break;
	          }
	        }
	        else
	        {
	          /* Write the output frames in the display order                    */
	          TestApp_WriteOutputData(ftestFile, &outputBufDesc, (IIMGDEC1_OutArgs *)outArgs);
	        }
		} // dynamicParams.progDisplay
	  }
	      /* Delete the Algorithm instance object specified by handle */
    ALG_delete (handle);
} 
    /* Output file close                                                     */
    fclose(ftestFile);


    if(ScanCount == 0)
    {
      ScanCount = 1; /* To avoid division with zero */
    }

    printf("\n --------------  SUMMARY --------------------\n");
    if(!testCompliance)
    {
      printf(" Decoder output dump completed\n");
    }
    printf("\t Total number of Scans              = %d\n",
      (XDAS_UInt32)ScanCount);
    printf("\t Width and Height                    = %d, %d \n",
      (XDAS_UInt32)status->imgdecStatus.outputWidth, (XDAS_UInt32)status->imgdecStatus.outputHeight);

    printf (" --------------    END   --------------------\n");
  //} /* Read the Config File until it reaches the end of file */

  printf("\n End of execution\n");
  /* Close the config files */
  fclose(fConfigFile);
/* Read the Config File until it reaches the end of file */
  return XDM_EOK;
  }
} /* main() */

  /*
  //============================================================================
  // TestApp_ReadByteStream
  //  Reading Byte Stream from a File
  */

  XDAS_Int32 TestApp_ReadByteStream(FILE *finFile)
  {
    XDAS_UInt32 BytesRead, BufferSize;

    fseek (finFile, 0, SEEK_END);
    BufferSize = ftell (finFile);
    printf("\nFileSize = %d", BufferSize);
    fseek (finFile, 0, SEEK_SET);

    if (BufferSize > INPUT_BUFFER_SIZE)
    {
      printf( "\nWarning : File size exceeds the application input buffer size %d ",
        INPUT_BUFFER_SIZE);
      printf( "\nContinuing decoding for %d bytes.\n", INPUT_BUFFER_SIZE);
      BufferSize = INPUT_BUFFER_SIZE;
    }

    /*Read the "BufferSize" number of bytes in the input buffer*/
    BytesRead = fread (inputData, 1, BufferSize, finFile);

    /* Cache Invalidate for Input Buffer */
#ifndef MSVC
	    Cache_wbInv(inputData, BufferSize, Cache_Type_ALL, TRUE);
#endif

    if (BytesRead != BufferSize)
    {
      printf("\nFailure in reading the input bitstream! \n");
      return(-1);
    }
    printf ("\nInput File read successfully...");
    return (BytesRead);
  }

  /*
  //============================================================================
  // TestApp_CompareOutputData
  //  Comparing Output Data with Reference File data
  */

  XDAS_Int32 TestApp_CompareOutputData(FILE *fRefFile,
    XDM1_BufDesc * outputBufDesc,
    IIMGDEC1_OutArgs *outArgs)
  {
    XDAS_Int32 i, bufferSize, retVal;
    XDAS_UInt8 *outputData;

    retVal = XDM_EOK;

    for(i = 0; i < outputBufDesc->numBufs; i++)
    {
      outputData = (XDAS_UInt8 *)outputBufDesc->descs[i].buf;
      bufferSize = outputBufDesc->descs[i].bufSize;
      fread (refData, 1, bufferSize, fRefFile);
      if(memcmp(outputData, refData, bufferSize)) {
        printf( "\n Decoder compliance test failed for this frame. ");
        retVal = XDM_EFAIL;
        break;
      }
    }
    return retVal;
  }

  /*
  //============================================================================
  // TestApp_WriteOutputData
  //  Writing Output Data in a File
  */

  XDAS_Void TestApp_WriteOutputData(FILE *fOutFile,
    XDM1_BufDesc * outputBufDesc,
    IIMGDEC1_OutArgs *outArgs)
  {

    XDAS_UInt8 *s;
    XDAS_Int32 i;
    //TempBuff = (char *)malloc(36 * 66 * 3);
    //char *p = TempBuff;
    for(i = 0; i < outputBufDesc->numBufs; i++)
    {
      s = (XDAS_UInt8 *)outputBufDesc->descs[i].buf;
      //fwrite (s, sizeof (Byte), outputBufDesc->descs[i].bufSize, fOutFile);
      //memcpy(p,s,outputBufDesc->descs[i].bufSize);
      //p += outputBufDesc->descs[i].bufSize;
    }
    //do_savebmp("test.bmp",36,66,24,TempBuff);
    //free(TempBuff);

    //fflush (fOutFile);
    return;
  }

  /*
  //==============================================================================
  // TestApp_SetInitParams
  //  setting of creation time parameters
  */

  XDAS_Void TestApp_SetInitParams(IIMGDEC1_Params *params1)
  {
	IJPEGDEC_Params *params = (IJPEGDEC_Params*) params1;
	
    params->imgdecParams.dataEndianness      = XDM_BYTE;
	params->outImgRes = 1;
    return;
  }

  /*
  //==============================================================================
  // TestApp_SetDynamicParams
  //  setting of run time parameters
  */

  XDAS_Void TestApp_SetDynamicParams(IIMGDEC1_DynamicParams *dynamicParams1)
  {
    /* Set IIMGDEC Run time parameters */
	IJPEGDEC_DynamicParams *dynamicParams = (IJPEGDEC_DynamicParams*)dynamicParams1;

   /*Do header analysis first to get the decoded image size*/
	dynamicParams->imgdecDynamicParams.decodeHeader = XDM_DECODE_AU;
	dynamicParams->progDisplay = 0;
	dynamicParams->RGB_Format = 0;
    return;
  }

  XDAS_Void TestApp_SetSizes()
  {
	jpegdecParams.imgdecParams.size     = sizeof(JPEGDEC_Params);
	jpegdecStatus.imgdecStatus.size     = sizeof(JPEGDEC_Status);
	jpegdecDynamicParams.imgdecDynamicParams.size = sizeof(JPEGDEC_DynamicParams);
	jpegdecInArgs.imgdecInArgs.size     = sizeof(JPEGDEC_InArgs);
	jpegdecOutArgs.imgdecOutArgs.size   = sizeof(JPEGDEC_OutArgs);
  }
  
#define EXT_MEM_BASE (0x80000000)
#define EXT_MEM_SIZE (0x07000000)
#define EXT_MEM_NON_CACHE_BASE (0x87000000)
#define EXT_MEM_NON_CACHE_SIZE (0x01000000)

/* Cache Settings */
XDAS_Void TestApp_EnableCache(void)
{
    Cache_Size size;
    UInt32 mar, disablePrefetch, disableCache;

    size.l1pSize  = Cache_L1Size_32K; /* L1P cache size */
    size.l1dSize  = Cache_L1Size_32K; /* L1D cache size */
    size.l2Size   = Cache_L2Size_64K; /* L2 cache size */

    /* Set L1P, L1D and L2 cache sizes */
    Cache_setSize(&size);

    /* Cache Enable External Memory Space */
    /* BaseAddr, length, MAR enable/disable */
    /* Cache 0x80000000 --- 0x8FFFFFFF   */
    mar = Cache_getMar((Ptr *)EXT_MEM_BASE) | ti_sysbios_family_c66_Cache_PC | ti_sysbios_family_c66_Cache_PFX;
    Cache_setMar((Ptr *)EXT_MEM_BASE, EXT_MEM_SIZE, Cache_Mar_ENABLE | mar);

    disablePrefetch = (~ti_sysbios_family_c66_Cache_PFX) & (0xFFFFFFFF);
    disableCache = (~ti_sysbios_family_c66_Cache_PC) & (0xFFFFFFFF);
    mar = Cache_getMar((Ptr *)EXT_MEM_NON_CACHE_BASE) & disableCache & disablePrefetch;
    Cache_setMar((Ptr *)EXT_MEM_NON_CACHE_BASE, EXT_MEM_NON_CACHE_SIZE, Cache_Mar_DISABLE | mar);
    Cache_wbInvAll();
} /* TestApp_EnableCache */

  /******************************************************************************/
  /*    Copyright (c) 2011 Texas Instruments, Incorporated                      */
  /*    All Rights Reserved                                                     */
  /******************************************************************************/
