/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2011
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */


#include <stdio.h>
#include <c6x.h> 
#include <csl_cpintc.h>
#include "KeyStone_common.h"

int uiUart_event_num;
int uiUart_tx_event_num;
int uiEdmaGint_event_num;

void CP_INTC_Init_UART(void)
{
	/* Disable Global host interrupts. */
	cpIntc0Regs->GLOBAL_ENABLE_HINT_REG= 0;

	/* Configure no nesting support in the CPINTC Module. */
	cpIntc0Regs->CONTROL_REG= ((cpIntc0Regs->CONTROL_REG&
		~CSL_CPINTC_CONTROL_REG_NEST_MODE_MASK)|
		(CPINTC_NO_NESTING<<CSL_CPINTC_CONTROL_REG_NEST_MODE_SHIFT));

	if(C6670 == Get_dsp_type())
	{	
		/*map Uart  interrupts events (164) to INTC0 out64*/
		uiUart_event_num= 164;
		uiEdmaGint_event_num = 22;
		uiUart_tx_event_num = 166;

		cpIntc0Regs->CH_MAP[SWAP_ENDIAN(164)]= 64;
		cpIntc0Regs->CH_MAP[SWAP_ENDIAN(22)]= 65;
		cpIntc0Regs->CH_MAP[SWAP_ENDIAN(166)]= 66;

		/*clear Uart  interrupts events (164)*/
		cpIntc0Regs->STATUS_CLR_INDEX_REG= 164;
		/*enable Uart  interrupts events (164)*/
		cpIntc0Regs->ENABLE_SET_INDEX_REG= 164;
		/*enable INTC out64*/
		cpIntc0Regs->HINT_ENABLE_SET_INDEX_REG= 64;

		cpIntc0Regs->STATUS_CLR_INDEX_REG= 22;
		cpIntc0Regs->ENABLE_SET_INDEX_REG= 22;
		cpIntc0Regs->HINT_ENABLE_SET_INDEX_REG= 65;

		cpIntc0Regs->STATUS_CLR_INDEX_REG=166;
		cpIntc0Regs->ENABLE_SET_INDEX_REG= 166;
		cpIntc0Regs->HINT_ENABLE_SET_INDEX_REG= 66;

	}
	else if(C6678 == Get_dsp_type())
	{	
		/*map Uart interrupts events (148) to INTC0 out33*/
		/*map EDMA interrupt events (22) to INTC0 out34*/
		/*map Uart TX interrupt events (150) to INTC0 out35*/
		uiUart_event_num= 148;
		uiEdmaGint_event_num = 22;
		uiUart_tx_event_num = 150;

		cpIntc0Regs->CH_MAP[SWAP_ENDIAN(148)]= 33;
		cpIntc0Regs->CH_MAP[SWAP_ENDIAN(22)] = 34;
		cpIntc0Regs->CH_MAP[SWAP_ENDIAN(150)]= 35;


		/*clear Uart interrupts events (148)*/
		cpIntc0Regs->STATUS_CLR_INDEX_REG= 148;
		/*enable Uart interrupts events (148)*/
		cpIntc0Regs->ENABLE_SET_INDEX_REG= 148;
		/*enable INTC out33*/
		cpIntc0Regs->HINT_ENABLE_SET_INDEX_REG= 33;

		cpIntc0Regs->STATUS_CLR_INDEX_REG= 22;
		cpIntc0Regs->ENABLE_SET_INDEX_REG= 22;
		cpIntc0Regs->HINT_ENABLE_SET_INDEX_REG= 34;

		cpIntc0Regs->STATUS_CLR_INDEX_REG= 150;
		cpIntc0Regs->ENABLE_SET_INDEX_REG= 150;
		cpIntc0Regs->HINT_ENABLE_SET_INDEX_REG= 35;

	}
	else
	{
		puts("Unknown DSP type!");
		return;
	}	

	/* Enable Global host interrupts. */
	cpIntc0Regs->GLOBAL_ENABLE_HINT_REG= 1;

}

void UART_Interrupts_Init(void)
{
	CP_INTC_Init_UART();
	

	//map Uart interrupt to INT4
	//map EDMA interrupt to INT5
	//map Uart TX interrupt to INT6
	/*on Nyquist, INTC0 out64 event number are 22 on core 0		
	on Shannon, INTC0 out33 event number are 22 on core0		
	map this event 22 to INT4 */
	CGEM_regs->INTMUX1 = (22<<CSL_CGEM_INTMUX1_INTSEL4_SHIFT)|(23<<CSL_CGEM_INTMUX1_INTSEL5_SHIFT)|(24<<CSL_CGEM_INTMUX1_INTSEL6_SHIFT);

	 /*Clear all DSP core events*/
	CGEM_regs->EVTCLR[0]= 	0xFFFFFFFF;
	CGEM_regs->EVTCLR[1]= 	0xFFFFFFFF;
	CGEM_regs->EVTCLR[2]= 	0xFFFFFFFF;
	CGEM_regs->EVTCLR[3]= 	0xFFFFFFFF;

	//clear DSP core interrupt flag
	ICR= IFR;

	//enable INT4, 5, 6
	IER = 3|(1<<4)|(1<<5)|(1<<6);

	/*Interrupt Service Table Pointer to begining of LL2 memory*/
	ISTP= 0x800000;

	//enable GIE
	TSR = TSR|1;
}


