/* --------------------------------------------------------------------------
    FILE        : uart_test.c 				                             	 	        
    PURPOSE     : uart hardware test
    PROJECT     : Keystone CCS UART Utility
    DESC        : Main function for UART on KeyStone device
 ----------------------------------------------------------------------------- */
#include <stdio.h>
#include "KeyStone_common.h"
#include "Keystone_DDR_Init.h"
#include "KeyStone_UART_Init_drv.h"
#include "uart_Intc_setup.h"
#include "uart_edma_setup.h"


/************************************************************
* Explicit External Declarations                            *
************************************************************/


/************************************************************
* Local Macro Declarations                                  *
************************************************************/


/************************************************************
* Local Typedef Declarations                                *
************************************************************/


/************************************************************
* Local Function Declarations                               *
************************************************************/



/************************************************************
* Local Variable Definitions                                *
************************************************************/
char * uart_err_str[]=
{
	"UART_Receive_FIFO_Error",
	"UART_Break_Error       ",
	"UART_Frame_Error       ",
	"UART_Parity_Error      ",
	"UART_Overrun_Error     ",
};
static int pingpongFlag = 1;
/************************************************************
* Global Variable Definitions
************************************************************/
volatile Uint32 gTxCheckEnable = 1;
volatile Uint32 g_BufferIdx = 0;
volatile Uint32 g_TxLength = 0;
volatile Uint32 g_TxFlag = 0;
char text[10] = {'H', 'E', 'L', 'L', 'O','W','O','R','L','D'};
int uartNum = 0;

/************************************************************
* Global Function Definitions                               *
************************************************************/

void main( void )
{
	int i;
	TDSP_Type dspType;

	printf("UART test start\n");
	
    CACHE_setL1PSize(CACHE_L1_32KCACHE);
    CACHE_setL1DSize(CACHE_L1_32KCACHE);
    CACHE_setL2Size(CACHE_256KCACHE);
	CACHE_invAllL1p(CACHE_WAIT);
	CACHE_wbInvAllL1d(CACHE_WAIT);
	CACHE_wbInvAllL2(CACHE_WAIT);

	/*make other cores local memory cacheable and prefetchable*/
	for(i=16; i<24; i++)
		CGEM_regs->MAR[i]=1|(1<<CSL_CGEM_MAR0_PFX_SHIFT);	

	/*make DDR cacheable and prefetchable*/
	for(i=128; i<256; i++)
		CGEM_regs->MAR[i]=1|(1<<CSL_CGEM_MAR0_PFX_SHIFT);	

	/*make other space non-cacheable and non-prefetchable*/
	for(i=24; i<128; i++)
		CGEM_regs->MAR[i]=0;	

	/*XMC memory address extension/mapping and memory protection*/
	KeyStone_XM_cfg();

	if(DNUM ==0)
	{
		dspType= Get_dsp_type();
		if(C6670==dspType)
		{
			//DSP core speed
			KeyStone_main_PLL_init (236, 29); 	//for 122.88MHz input clock

			//DDR speed = 66.67*20/1= 1333
			KeyStone_DDR_PLL_init (20, 1);

			C6670_EVM_DDR_Init(666.667); 	//for 1333Mbps
		
		}
		else if(C6678==dspType)
		{
			//DSP core speed
			//KeyStone_main_PLL_init (20, 1); 	//for 50MHz input clock
			KeyStone_main_PLL_init (10, 1); 	//for 100MHz input clock

			//DDR speed = 66.67*20/1= 1333
			KeyStone_DDR_PLL_init (20, 1);

			C6678_EVM_DDR_Init(666.667); 	//for 1333Mbps

		}
		printf("UART setup started.\n");
		UART_Interrupts_Init();
		KeyStone_UART_calc();
		KeyStone_UART_init(&gUARTCfg, uartNum);
		UART_EDMA_init();

	}
	
	printf("UART%d Send HELLOWORLD\n",uartNum);

	while(1)
	{
		if(g_TxFlag==1)
		{
			Keystone_uartWrite_Busy(0,  text[g_TxLength]);
			g_TxFlag = 0;
			g_TxLength++;
		}
	}

}


interrupt void UartTxISR()
{
	if(g_TxLength< 10)
	{
		g_TxFlag = 1;
	}
	cpIntc0Regs->STATUS_CLR_INDEX_REG= uiUart_tx_event_num;

}

interrupt void UartISR()
{
	Uint32 uartNum = 0;
	Uint32 i;
	Uint32 uLSR;
	Uint32 uartErrShift[5] = {CSL_UART_LSR_RXFIFOE_SHIFT,
							  CSL_UART_LSR_BI_SHIFT,
							  CSL_UART_LSR_FE_SHIFT,
							  CSL_UART_LSR_PE_SHIFT,
							  CSL_UART_LSR_OE_SHIFT};


	CSL_UartRegs * localUART_Regs = (CSL_UartRegs *)((Uint32)UART_Regs + uartNum * 0x1000);

	uLSR = localUART_Regs->LSR;
	for(i=0; i<5; i++)
	{
		if((uLSR >> uartErrShift[i])& 1)
		{
			printf("UART error is %s\n",uart_err_str[i]);
		}

	}

	cpIntc0Regs->STATUS_CLR_INDEX_REG= uiUart_event_num;
}


interrupt void UartEDMA()
{

	Uint32 IPRH = 0;
	IPRH = gEDMACC2Regs->TPCC_IPRH;
	if(IPRH & (1<<(40-32)))
	{
		pingpongFlag = (pingpongFlag ==0);
		g_BufferIdx=1;
		gEDMACC2Regs->TPCC_ICRH = 1<<(40-32);
	}
	else
	{
		gEDMACC2Regs->TPCC_ICRH = 0xFFFFFFFF;
		gEDMACC2Regs->TPCC_ICR = 0xFFFFFFFF;
	}
	IPRH = gEDMACC2Regs->TPCC_IPRH;
    //if(IPRH)
    {
    	gEDMACC2Regs->TPCC_IEVAL = 1;
    }
	cpIntc0Regs->STATUS_CLR_INDEX_REG= uiEdmaGint_event_num;
}
/************************************************************
* Local Function Definitions                                *
************************************************************/


/***********************************************************
* End file                                                 *
***********************************************************/

