/*
 * cslr_edma3cc.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/** ============================================================================
 *   @file  cslr_edma3cc.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for EDMACC
 *
 *  ============================================================================
 */
#ifndef _CSLR_EDMA3CC_H_
#define _CSLR_EDMA3CC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <ti/pspiom/cslr/cslr.h>
#include <ti/pspiom/cslr/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for DRA
\**************************************************************************/
typedef struct  {
    volatile Uint32 DRAE;
    volatile Uint8 RSVD6[4];
} CSL_Edma3ccDraRegs;

/**************************************************************************\
* Register Overlay Structure for QUEUE
\**************************************************************************/
typedef struct  {
    volatile Uint32 EVENT[16];
} CSL_Edma3ccQueueRegs;

/**************************************************************************\
* Register Overlay Structure for SHADOW
\**************************************************************************/
typedef struct  {
    volatile Uint32 ER;
    volatile Uint8 RSVD0[4];
    volatile Uint32 ECR;
    volatile Uint8 RSVD1[4];
    volatile Uint32 ESR;
    volatile Uint8 RSVD2[4];
    volatile Uint32 CER;
    volatile Uint8 RSVD3[4];
    volatile Uint32 EER;
    volatile Uint8 RSVD4[4];
    volatile Uint32 EECR;
    volatile Uint8 RSVD5[4];
    volatile Uint32 EESR;
    volatile Uint8 RSVD6[4];
    volatile Uint32 SER;
    volatile Uint8 RSVD7[4];
    volatile Uint32 SECR;
    volatile Uint8 RSVD8[12];
    volatile Uint32 IER;
    volatile Uint8 RSVD9[4];
    volatile Uint32 IECR;
    volatile Uint8 RSVD10[4];
    volatile Uint32 IESR;
    volatile Uint8 RSVD11[4];
    volatile Uint32 IPR;
    volatile Uint8 RSVD12[4];
    volatile Uint32 ICR;
    volatile Uint8 RSVD13[4];
    volatile Uint32 IEVAL;
    volatile Uint8 RSVD14[4];
    volatile Uint32 QER;
    volatile Uint32 QEER;
    volatile Uint32 QEECR;
    volatile Uint32 QEESR;
    volatile Uint32 QSER;
    volatile Uint32 QSECR;
    volatile Uint8 RSVD15[360];
} CSL_Edma3ccShadowRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_Edma3ccShadowRegs  *CSL_Edma3ccShadowRegsOvly;

/**************************************************************************\
* Register Overlay Structure for PARAMENTRY
\**************************************************************************/
typedef struct  {
    volatile Uint32 OPT;
    volatile Uint32 SRC;
    volatile Uint32 A_B_CNT;
    volatile Uint32 DST;
    volatile Uint32 SRC_DST_BIDX;
    volatile Uint32 LINK_BCNTRLD;
    volatile Uint32 SRC_DST_CIDX;
    volatile Uint32 CCNT;
} CSL_Edma3ccParamSetRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 CCCFG;
    volatile Uint8 RSVD0[504];
    volatile Uint32 QCHMAP[8];
    volatile Uint8 RSVD1[32];
    volatile Uint32 DMAQNUM[8];
    volatile Uint32 QDMAQNUM;
    volatile Uint8 RSVD2[32];
    volatile Uint32 QUEPRI;
    volatile Uint8 RSVD3[120];
    volatile Uint32 EMR;
    volatile Uint8 RSVD4[4];
    volatile Uint32 EMCR;
    volatile Uint8 RSVD5[4];
    volatile Uint32 QEMR;
    volatile Uint32 QEMCR;
    volatile Uint32 CCERR;
    volatile Uint32 CCERRCLR;
    volatile Uint32 EEVAL;
    volatile Uint8 RSVD7[28];
    CSL_Edma3ccDraRegs DRA[4];
    volatile Uint8 RSVD8[32];
    volatile Uint32 QRAE[4];
    volatile Uint8 RSVD9[112];
    CSL_Edma3ccQueueRegs QUEUE[2];
    volatile Uint8 RSVD10[384];
    volatile Uint32 QSTAT[3];
    volatile Uint8 RSVD11[20];
    volatile Uint32 QWMTHRA;
    volatile Uint8 RSVD12[28];
    volatile Uint32 CCSTAT;
    volatile Uint8 RSVD13[2492];
    volatile Uint32 ER;
    volatile Uint8 RSVD14[4];
    volatile Uint32 ECR;
    volatile Uint8 RSVD15[4];
    volatile Uint32 ESR;
    volatile Uint8 RSVD16[4];
    volatile Uint32 CER;
    volatile Uint8 RSVD17[4];
    volatile Uint32 EER;
    volatile Uint8 RSVD18[4];
    volatile Uint32 EECR;
    volatile Uint8 RSVD19[4];
    volatile Uint32 EESR;
    volatile Uint8 RSVD20[4];
    volatile Uint32 SER;
    volatile Uint8 RSVD21[4];
    volatile Uint32 SECR;
    volatile Uint8 RSVD22[12];
    volatile Uint32 IER;
    volatile Uint8 RSVD23[4];
    volatile Uint32 IECR;
    volatile Uint8 RSVD24[4];
    volatile Uint32 IESR;
    volatile Uint8 RSVD25[4];
    volatile Uint32 IPR;
    volatile Uint8 RSVD26[4];
    volatile Uint32 ICR;
    volatile Uint8 RSVD27[4];
    volatile Uint32 IEVAL;
    volatile Uint8 RSVD28[4];
    volatile Uint32 QER;
    volatile Uint32 QEER;
    volatile Uint32 QEECR;
    volatile Uint32 QEESR;
    volatile Uint32 QSER;
    volatile Uint32 QSECR;
    volatile Uint8 RSVD30[3944];
    CSL_Edma3ccShadowRegs SHADOW[4];
    volatile Uint8 RSVD31[6144];
    CSL_Edma3ccParamSetRegs PARAMSET[128];
} CSL_Edma3ccRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_Edma3ccRegs         *CSL_Edma3ccRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DRAE */

#define CSL_EDMA3CC_DRAE_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_DRAE_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_DRAE_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_DRAE_E31_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E31_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_DRAE_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_DRAE_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_DRAE_E30_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E30_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_DRAE_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_DRAE_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_DRAE_E29_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E29_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_DRAE_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_DRAE_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_DRAE_E28_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E28_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_DRAE_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_DRAE_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_DRAE_E27_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E27_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_DRAE_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_DRAE_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_DRAE_E26_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E26_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_DRAE_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_DRAE_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_DRAE_E25_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E25_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_DRAE_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_DRAE_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_DRAE_E24_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E24_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_DRAE_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_DRAE_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_DRAE_E23_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E23_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_DRAE_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_DRAE_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_DRAE_E22_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E22_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_DRAE_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_DRAE_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_DRAE_E21_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E21_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_DRAE_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_DRAE_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_DRAE_E20_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E20_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_DRAE_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_DRAE_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_DRAE_E19_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E19_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_DRAE_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_DRAE_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_DRAE_E18_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E18_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_DRAE_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_DRAE_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_DRAE_E17_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E17_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_DRAE_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_DRAE_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_DRAE_E16_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E16_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_DRAE_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_DRAE_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_DRAE_E15_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E15_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_DRAE_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_DRAE_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_DRAE_E14_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E14_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_DRAE_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_DRAE_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_DRAE_E13_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E13_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_DRAE_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_DRAE_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_DRAE_E12_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E12_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_DRAE_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_DRAE_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_DRAE_E11_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E11_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_DRAE_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_DRAE_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_DRAE_E10_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E10_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_DRAE_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_DRAE_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_DRAE_E9_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E9_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_DRAE_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_DRAE_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_DRAE_E8_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E8_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_DRAE_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_DRAE_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_DRAE_E7_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E7_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_DRAE_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_DRAE_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_DRAE_E6_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E6_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_DRAE_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_DRAE_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_DRAE_E5_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E5_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_DRAE_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_DRAE_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_DRAE_E4_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E4_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_DRAE_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_DRAE_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_DRAE_E3_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E3_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_DRAE_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_DRAE_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_DRAE_E2_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E2_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_DRAE_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_DRAE_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_DRAE_E1_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E1_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_DRAE_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_DRAE_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_DRAE_E0_DISABLE (0x00000000u)
#define CSL_EDMA3CC_DRAE_E0_ENABLE (0x00000001u)

#define CSL_EDMA3CC_DRAE_RESETVAL (0x00000000u)

/* EVENT */

#define CSL_EDMA3CC_EVENT_RESV_MASK (0xFFFFFF00u)
#define CSL_EDMA3CC_EVENT_RESV_SHIFT (0x00000008u)
#define CSL_EDMA3CC_EVENT_RESV_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_EVENT_ETYPE_MASK (0x000000C0u)
#define CSL_EDMA3CC_EVENT_ETYPE_SHIFT (0x00000006u)
#define CSL_EDMA3CC_EVENT_ETYPE_RESETVAL (0x00000000u)
#define CSL_EDMA3CC_EVENT_ETYPE_ER (0x00000000u)
#define CSL_EDMA3CC_EVENT_ETYPE_ESR (0x00000001u)
#define CSL_EDMA3CC_EVENT_ETYPE_CER (0x00000002u)
#define CSL_EDMA3CC_EVENT_ETYPE_QER (0x00000003u)

#define CSL_EDMA3CC_EVENT_ENUM_MASK (0x0000003Fu)
#define CSL_EDMA3CC_EVENT_ENUM_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EVENT_ENUM_RESETVAL (0x00000000u)
#define CSL_EDMA3CC_EVENT_RESETVAL (0x00000000u)

/* ER */

#define CSL_EDMA3CC_ER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_ER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_ER_RESETVAL (0x00000000u)

/* ECR */

#define CSL_EDMA3CC_ECR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_ECR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ECR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_ECR_RESETVAL (0x00000000u)

/* ESR */

#define CSL_EDMA3CC_ESR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_ESR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ESR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_ESR_RESETVAL (0x00000000u)

/* CER */

#define CSL_EDMA3CC_CER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_CER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_CER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_CER_RESETVAL (0x00000000u)

/* EER */

#define CSL_EDMA3CC_EER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_EER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_EER_RESETVAL (0x00000000u)

/* EECR */

#define CSL_EDMA3CC_EECR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_EECR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EECR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_EECR_RESETVAL (0x00000000u)

/* EESR */

#define CSL_EDMA3CC_EESR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_EESR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EESR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_EESR_RESETVAL (0x00000000u)

/* SER */

#define CSL_EDMA3CC_SER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_SER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_SER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_SER_RESETVAL (0x00000000u)

/* SECR */

#define CSL_EDMA3CC_SECR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_SECR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_SECR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_SECR_RESETVAL (0x00000000u)

/* IER */

#define CSL_EDMA3CC_IER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_IER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_IER_RESETVAL (0x00000000u)

/* IECR */

#define CSL_EDMA3CC_IECR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_IECR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IECR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_IECR_RESETVAL (0x00000000u)

/* IESR */

#define CSL_EDMA3CC_IESR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_IESR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IESR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_IESR_RESETVAL (0x00000000u)

/* IPR */

#define CSL_EDMA3CC_IPR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_IPR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IPR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_IPR_RESETVAL (0x00000000u)

/* ICR */

#define CSL_EDMA3CC_ICR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_ICR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ICR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_ICR_RESETVAL (0x00000000u)

/* IEVAL */

#define CSL_EDMA3CC_IEVAL_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_IEVAL_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IEVAL_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_IEVAL_RESETVAL (0x00000000u)

/* QER */

#define CSL_EDMA3CC_QER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_QER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QER_RESETVAL (0x00000000u)

/* QEER */

#define CSL_EDMA3CC_QEER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_QEER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QEER_RESETVAL (0x00000000u)

/* QEECR */

#define CSL_EDMA3CC_QEECR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_QEECR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEECR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QEECR_RESETVAL (0x00000000u)

/* QEESR */

#define CSL_EDMA3CC_QEESR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_QEESR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEESR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QEESR_RESETVAL (0x00000000u)

/* QSER */

#define CSL_EDMA3CC_QSER_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_QSER_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QSER_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QSER_RESETVAL (0x00000000u)

/* QSECR */

#define CSL_EDMA3CC_QSECR_REG_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_QSECR_REG_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QSECR_REG_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QSECR_RESETVAL (0x00000000u)

/* OPT */


#define CSL_EDMA3CC_OPT_PRIVID_MASK (0x0F000000u)
#define CSL_EDMA3CC_OPT_PRIVID_SHIFT (0x00000018u)
#define CSL_EDMA3CC_OPT_PRIVID_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_OPT_ITCCHEN_MASK (0x00800000u)
#define CSL_EDMA3CC_OPT_ITCCHEN_SHIFT (0x00000017u)
#define CSL_EDMA3CC_OPT_ITCCHEN_RESETVAL (0x00000000u)
/*----ITCCHEN Tokens----*/
#define CSL_EDMA3CC_OPT_ITCCHEN_DISABLE (0x00000000u)
#define CSL_EDMA3CC_OPT_ITCCHEN_ENABLE (0x00000001u)

#define CSL_EDMA3CC_OPT_TCCHEN_MASK (0x00400000u)
#define CSL_EDMA3CC_OPT_TCCHEN_SHIFT (0x00000016u)
#define CSL_EDMA3CC_OPT_TCCHEN_RESETVAL (0x00000000u)
/*----TCCHEN Tokens----*/
#define CSL_EDMA3CC_OPT_TCCHEN_DISABLE (0x00000000u)
#define CSL_EDMA3CC_OPT_TCCHEN_ENABLE (0x00000001u)

#define CSL_EDMA3CC_OPT_ITCINTEN_MASK (0x00200000u)
#define CSL_EDMA3CC_OPT_ITCINTEN_SHIFT (0x00000015u)
#define CSL_EDMA3CC_OPT_ITCINTEN_RESETVAL (0x00000000u)
/*----ITCINTEN Tokens----*/
#define CSL_EDMA3CC_OPT_ITCINTEN_DISABLE (0x00000000u)
#define CSL_EDMA3CC_OPT_ITCINTEN_ENABLE (0x00000001u)

#define CSL_EDMA3CC_OPT_TCINTEN_MASK (0x00100000u)
#define CSL_EDMA3CC_OPT_TCINTEN_SHIFT (0x00000014u)
#define CSL_EDMA3CC_OPT_TCINTEN_RESETVAL (0x00000000u)
/*----TCINTEN Tokens----*/
#define CSL_EDMA3CC_OPT_TCINTEN_DISABLE (0x00000000u)
#define CSL_EDMA3CC_OPT_TCINTEN_ENABLE (0x00000001u)


#define CSL_EDMA3CC_OPT_TCC_MASK (0x0003F000u)
#define CSL_EDMA3CC_OPT_TCC_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_OPT_TCC_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_OPT_TCCMOD_MASK (0x00000800u)
#define CSL_EDMA3CC_OPT_TCCMOD_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_OPT_TCCMOD_RESETVAL (0x00000000u)
/*----TCCMOD Tokens----*/
#define CSL_EDMA3CC_OPT_TCCMOD_NORMAL (0x00000000u)
#define CSL_EDMA3CC_OPT_TCCMOD_EARLY (0x00000001u)

#define CSL_EDMA3CC_OPT_FWID_MASK (0x00000700u)
#define CSL_EDMA3CC_OPT_FWID_SHIFT (0x00000008u)
#define CSL_EDMA3CC_OPT_FWID_RESETVAL (0x00000000u)
/*----FWID Tokens----*/
#define CSL_EDMA3CC_OPT_FWID_8BIT (0x00000000u)
#define CSL_EDMA3CC_OPT_FWID_16BIT (0x00000001u)
#define CSL_EDMA3CC_OPT_FWID_32BIT (0x00000002u)
#define CSL_EDMA3CC_OPT_FWID_64BIT (0x00000003u)
#define CSL_EDMA3CC_OPT_FWID_128BIT (0x00000004u)
#define CSL_EDMA3CC_OPT_FWID_256BIT (0x00000005u)


#define CSL_EDMA3CC_OPT_STATIC_MASK (0x00000008u)
#define CSL_EDMA3CC_OPT_STATIC_SHIFT (0x00000003u)
#define CSL_EDMA3CC_OPT_STATIC_RESETVAL (0x00000000u)
/*----STATIC Tokens----*/
#define CSL_EDMA3CC_OPT_STATIC_NORMAL (0x00000000u)
#define CSL_EDMA3CC_OPT_STATIC_STATIC (0x00000001u)

#define CSL_EDMA3CC_OPT_SYNCDIM_MASK (0x00000004u)
#define CSL_EDMA3CC_OPT_SYNCDIM_SHIFT (0x00000002u)
#define CSL_EDMA3CC_OPT_SYNCDIM_RESETVAL (0x00000000u)
/*----SYNCDIM Tokens----*/
#define CSL_EDMA3CC_OPT_SYNCDIM_ASYNC (0x00000000u)
#define CSL_EDMA3CC_OPT_SYNCDIM_ABSYNC (0x00000001u)

#define CSL_EDMA3CC_OPT_DAM_MASK (0x00000002u)
#define CSL_EDMA3CC_OPT_DAM_SHIFT (0x00000001u)
#define CSL_EDMA3CC_OPT_DAM_RESETVAL (0x00000000u)
/*----DAM Tokens----*/
#define CSL_EDMA3CC_OPT_DAM_INCR (0x00000000u)
#define CSL_EDMA3CC_OPT_DAM_CONST (0x00000001u)

#define CSL_EDMA3CC_OPT_SAM_MASK (0x00000001u)
#define CSL_EDMA3CC_OPT_SAM_SHIFT (0x00000000u)
#define CSL_EDMA3CC_OPT_SAM_RESETVAL (0x00000000u)
/*----SAM Tokens----*/
#define CSL_EDMA3CC_OPT_SAM_INCR (0x00000000u)
#define CSL_EDMA3CC_OPT_SAM_CONST (0x00000001u)

#define CSL_EDMA3CC_OPT_RESETVAL (0x00000000u)

/* SRC */

#define CSL_EDMA3CC_SRC_SRC_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_SRC_SRC_SHIFT (0x00000000u)
#define CSL_EDMA3CC_SRC_SRC_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_SRC_RESETVAL (0x00000000u)

/* A_B_CNT */

#define CSL_EDMA3CC_A_B_CNT_BCNT_MASK (0xFFFF0000u)
#define CSL_EDMA3CC_A_B_CNT_BCNT_SHIFT (0x00000010u)
#define CSL_EDMA3CC_A_B_CNT_BCNT_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_A_B_CNT_ACNT_MASK (0x0000FFFFu)
#define CSL_EDMA3CC_A_B_CNT_ACNT_SHIFT (0x00000000u)
#define CSL_EDMA3CC_A_B_CNT_ACNT_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_A_B_CNT_RESETVAL (0x00000000u)

/* DST */

#define CSL_EDMA3CC_DST_DST_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_DST_DST_SHIFT (0x00000000u)
#define CSL_EDMA3CC_DST_DST_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_DST_RESETVAL (0x00000000u)

/* SRC_DST_BIDX */

#define CSL_EDMA3CC_SRC_DST_BIDX_DSTBIDX_MASK (0xFFFF0000u)
#define CSL_EDMA3CC_SRC_DST_BIDX_DSTBIDX_SHIFT (0x00000010u)
#define CSL_EDMA3CC_SRC_DST_BIDX_DSTBIDX_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_SRC_DST_BIDX_SRCBIDX_MASK (0x0000FFFFu)
#define CSL_EDMA3CC_SRC_DST_BIDX_SRCBIDX_SHIFT (0x00000000u)
#define CSL_EDMA3CC_SRC_DST_BIDX_SRCBIDX_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_SRC_DST_BIDX_RESETVAL (0x00000000u)

/* LINK_BCNTRLD */

#define CSL_EDMA3CC_LINK_BCNTRLD_BCNTRLD_MASK (0xFFFF0000u)
#define CSL_EDMA3CC_LINK_BCNTRLD_BCNTRLD_SHIFT (0x00000010u)
#define CSL_EDMA3CC_LINK_BCNTRLD_BCNTRLD_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_LINK_BCNTRLD_LINK_MASK (0x0000FFFFu)
#define CSL_EDMA3CC_LINK_BCNTRLD_LINK_SHIFT (0x00000000u)
#define CSL_EDMA3CC_LINK_BCNTRLD_LINK_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_LINK_BCNTRLD_RESETVAL (0x00000000u)

/* SRC_DST_CIDX */

#define CSL_EDMA3CC_SRC_DST_CIDX_DSTCIDX_MASK (0xFFFF0000u)
#define CSL_EDMA3CC_SRC_DST_CIDX_DSTCIDX_SHIFT (0x00000010u)
#define CSL_EDMA3CC_SRC_DST_CIDX_DSTCIDX_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_SRC_DST_CIDX_SRCCIDX_MASK (0x0000FFFFu)
#define CSL_EDMA3CC_SRC_DST_CIDX_SRCCIDX_SHIFT (0x00000000u)
#define CSL_EDMA3CC_SRC_DST_CIDX_SRCCIDX_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_SRC_DST_CIDX_RESETVAL (0x00000000u)

/* CCNT */


#define CSL_EDMA3CC_CCNT_CCNT_MASK (0x0000FFFFu)
#define CSL_EDMA3CC_CCNT_CCNT_SHIFT (0x00000000u)
#define CSL_EDMA3CC_CCNT_CCNT_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_CCNT_RESETVAL (0x00000000u)

/* PID */

#define CSL_EDMA3CC_PID_PID_MASK (0xFFFFFFFFu)
#define CSL_EDMA3CC_PID_PID_SHIFT (0x00000000u)
#define CSL_EDMA3CC_PID_PID_RESETVAL (0x026295C4u)

#define CSL_EDMA3CC_PID_RESETVAL (0x026295C4u)

/* CCCFG */


#define CSL_EDMA3CC_CCCFG_MP_EXIST_MASK (0x02000000u)
#define CSL_EDMA3CC_CCCFG_MP_EXIST_SHIFT (0x00000019u)
#define CSL_EDMA3CC_CCCFG_MP_EXIST_RESETVAL (0x00000000u)
/*----MP_EXIST Tokens----*/
#define CSL_EDMA3CC_CCCFG_MP_EXIST_NONE (0x00000000u)
#define CSL_EDMA3CC_CCCFG_MP_EXIST_INCLUDED (0x00000001u)

#define CSL_EDMA3CC_CCCFG_CHMAP_EXIST_MASK (0x01000000u)
#define CSL_EDMA3CC_CCCFG_CHMAP_EXIST_SHIFT (0x00000018u)
#define CSL_EDMA3CC_CCCFG_CHMAP_EXIST_RESETVAL (0x00000000u)
/*----CHMAP_EXIST Tokens----*/
#define CSL_EDMA3CC_CCCFG_CHMAP_EXIST_NONE (0x00000000u)
#define CSL_EDMA3CC_CCCFG_CHMAP_EXIST_INCLUDED (0x00000001u)


#define CSL_EDMA3CC_CCCFG_NUM_REGN_MASK (0x00300000u)
#define CSL_EDMA3CC_CCCFG_NUM_REGN_SHIFT (0x00000014u)
#define CSL_EDMA3CC_CCCFG_NUM_REGN_RESETVAL (0x00000002u)
/*----NUM_REGN Tokens----*/
#define CSL_EDMA3CC_CCCFG_NUM_REGN_0REGIONS (0x00000000u)
#define CSL_EDMA3CC_CCCFG_NUM_REGN_2REGIONS (0x00000001u)
#define CSL_EDMA3CC_CCCFG_NUM_REGN_4REGIONS (0x00000002u)
#define CSL_EDMA3CC_CCCFG_NUM_REGN_8REGIONS (0x00000003u)


#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_MASK (0x00070000u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_SHIFT (0x00000010u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_RESETVAL (0x00000002u)
/*----NUM_EVQUE Tokens----*/
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_1EVTQ (0x00000000u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_2EVTQ (0x00000001u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_3EVTQ (0x00000002u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_4EVTQ (0x00000003u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_5EVTQ (0x00000004u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_6EVTQ (0x00000005u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_7EVTQ (0x00000006u)
#define CSL_EDMA3CC_CCCFG_NUM_EVQUE_8EVTQ (0x00000007u)


#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_MASK (0x00007000u)
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_RESETVAL (0x00000003u)
/*----NUM_PAENTRY Tokens----*/
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_16 (0x00000000u)
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_32 (0x00000001u)
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_64 (0x00000002u)
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_128 (0x00000003u)
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_256 (0x00000004u)
#define CSL_EDMA3CC_CCCFG_NUM_PAENTRY_512 (0x00000005u)


#define CSL_EDMA3CC_CCCFG_NUM_INTCH_MASK (0x00000700u)
#define CSL_EDMA3CC_CCCFG_NUM_INTCH_SHIFT (0x00000008u)
#define CSL_EDMA3CC_CCCFG_NUM_INTCH_RESETVAL (0x00000004u)
/*----NUM_INTCH Tokens----*/
#define CSL_EDMA3CC_CCCFG_NUM_INTCH_8 (0x00000001u)
#define CSL_EDMA3CC_CCCFG_NUM_INTCH_16 (0x00000002u)
#define CSL_EDMA3CC_CCCFG_NUM_INTCH_32 (0x00000003u)
#define CSL_EDMA3CC_CCCFG_NUM_INTCH_64 (0x00000004u)


#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_MASK (0x00000070u)
#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_SHIFT (0x00000004u)
#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_RESETVAL (0x00000004u)
/*----NUM_QDMACH Tokens----*/
#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_NONE (0x00000000u)
#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_2 (0x00000001u)
#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_4 (0x00000002u)
#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_6 (0x00000003u)
#define CSL_EDMA3CC_CCCFG_NUM_QDMACH_8 (0x00000004u)


#define CSL_EDMA3CC_CCCFG_NUM_DMACH_MASK (0x00000007u)
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_SHIFT (0x00000000u)
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_RESETVAL (0x00000005u)
/*----NUM_DMACH Tokens----*/
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_NONE (0x00000000u)
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_4 (0x00000001u)
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_8 (0x00000002u)
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_16 (0x00000003u)
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_32 (0x00000004u)
#define CSL_EDMA3CC_CCCFG_NUM_DMACH_64 (0x00000005u)

#define CSL_EDMA3CC_CCCFG_RESETVAL (0x00223445u)

/* QCHMAP */


#define CSL_EDMA3CC_QCHMAP_PAENTRY_MASK (0x00003FE0u)
#define CSL_EDMA3CC_QCHMAP_PAENTRY_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QCHMAP_PAENTRY_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QCHMAP_TRWORD_MASK (0x0000001Cu)
#define CSL_EDMA3CC_QCHMAP_TRWORD_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QCHMAP_TRWORD_RESETVAL (0x00000000u)


#define CSL_EDMA3CC_QCHMAP_RESETVAL (0x00000000u)

/* DMAQNUM */


#define CSL_EDMA3CC_DMAQNUM_E7_MASK (0x70000000u)
#define CSL_EDMA3CC_DMAQNUM_E7_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_DMAQNUM_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E7_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E7_Q1 (0x00000001u)



#define CSL_EDMA3CC_DMAQNUM_E6_MASK (0x07000000u)
#define CSL_EDMA3CC_DMAQNUM_E6_SHIFT (0x00000018u)
#define CSL_EDMA3CC_DMAQNUM_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E6_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E6_Q1 (0x00000001u)



#define CSL_EDMA3CC_DMAQNUM_E5_MASK (0x00700000u)
#define CSL_EDMA3CC_DMAQNUM_E5_SHIFT (0x00000014u)
#define CSL_EDMA3CC_DMAQNUM_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E5_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E5_Q1 (0x00000001u)



#define CSL_EDMA3CC_DMAQNUM_E4_MASK (0x00070000u)
#define CSL_EDMA3CC_DMAQNUM_E4_SHIFT (0x00000010u)
#define CSL_EDMA3CC_DMAQNUM_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E4_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E4_Q1 (0x00000001u)



#define CSL_EDMA3CC_DMAQNUM_E3_MASK (0x00007000u)
#define CSL_EDMA3CC_DMAQNUM_E3_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_DMAQNUM_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E3_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E3_Q1 (0x00000001u)



#define CSL_EDMA3CC_DMAQNUM_E2_MASK (0x00000700u)
#define CSL_EDMA3CC_DMAQNUM_E2_SHIFT (0x00000008u)
#define CSL_EDMA3CC_DMAQNUM_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E2_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E2_Q1 (0x00000001u)



#define CSL_EDMA3CC_DMAQNUM_E1_MASK (0x00000070u)
#define CSL_EDMA3CC_DMAQNUM_E1_SHIFT (0x00000004u)
#define CSL_EDMA3CC_DMAQNUM_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E1_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E1_Q1 (0x00000001u)



#define CSL_EDMA3CC_DMAQNUM_E0_MASK (0x00000007u)
#define CSL_EDMA3CC_DMAQNUM_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_DMAQNUM_E0_Q0 (0x00000000u)
#define CSL_EDMA3CC_DMAQNUM_E0_Q1 (0x00000001u)


#define CSL_EDMA3CC_DMAQNUM_RESETVAL (0x00000000u)

/* QDMAQNUM */


#define CSL_EDMA3CC_QDMAQNUM_E7_MASK (0x70000000u)
#define CSL_EDMA3CC_QDMAQNUM_E7_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_QDMAQNUM_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E7_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E7_Q1 (0x00000001u)



#define CSL_EDMA3CC_QDMAQNUM_E6_MASK (0x07000000u)
#define CSL_EDMA3CC_QDMAQNUM_E6_SHIFT (0x00000018u)
#define CSL_EDMA3CC_QDMAQNUM_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E6_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E6_Q1 (0x00000001u)


#define CSL_EDMA3CC_QDMAQNUM_E5_MASK (0x00700000u)
#define CSL_EDMA3CC_QDMAQNUM_E5_SHIFT (0x00000014u)
#define CSL_EDMA3CC_QDMAQNUM_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E5_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E5_Q1 (0x00000001u)


#define CSL_EDMA3CC_QDMAQNUM_E4_MASK (0x00070000u)
#define CSL_EDMA3CC_QDMAQNUM_E4_SHIFT (0x00000010u)
#define CSL_EDMA3CC_QDMAQNUM_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E4_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E4_Q1 (0x00000001u)



#define CSL_EDMA3CC_QDMAQNUM_E3_MASK (0x00007000u)
#define CSL_EDMA3CC_QDMAQNUM_E3_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_QDMAQNUM_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E3_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E3_Q1 (0x00000001u)


#define CSL_EDMA3CC_QDMAQNUM_E2_MASK (0x00000700u)
#define CSL_EDMA3CC_QDMAQNUM_E2_SHIFT (0x00000008u)
#define CSL_EDMA3CC_QDMAQNUM_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E2_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E2_Q1 (0x00000001u)


#define CSL_EDMA3CC_QDMAQNUM_E1_MASK (0x00000070u)
#define CSL_EDMA3CC_QDMAQNUM_E1_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QDMAQNUM_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E1_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E1_Q1 (0x00000001u)



#define CSL_EDMA3CC_QDMAQNUM_E0_MASK (0x00000007u)
#define CSL_EDMA3CC_QDMAQNUM_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QDMAQNUM_E0_Q0 (0x00000000u)
#define CSL_EDMA3CC_QDMAQNUM_E0_Q1 (0x00000001u)

#define CSL_EDMA3CC_QDMAQNUM_RESETVAL (0x00000000u)

/* QUEPRI */


#define CSL_EDMA3CC_QUEPRI_PRIQ2_MASK (0x00000700u)
#define CSL_EDMA3CC_QUEPRI_PRIQ2_SHIFT (0x00000008u)
#define CSL_EDMA3CC_QUEPRI_PRIQ2_RESETVAL (0x00000000u)


#define CSL_EDMA3CC_QUEPRI_PRIQ1_MASK (0x00000070u)
#define CSL_EDMA3CC_QUEPRI_PRIQ1_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QUEPRI_PRIQ1_RESETVAL (0x00000000u)


#define CSL_EDMA3CC_QUEPRI_PRIQ0_MASK (0x00000007u)
#define CSL_EDMA3CC_QUEPRI_PRIQ0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QUEPRI_PRIQ0_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QUEPRI_RESETVAL (0x00000000u)

/* EMR */

#define CSL_EDMA3CC_EMR_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_EMR_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_EMR_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_EMR_E31_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E31_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_EMR_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_EMR_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_EMR_E30_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E30_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_EMR_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_EMR_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_EMR_E29_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E29_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_EMR_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_EMR_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_EMR_E28_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E28_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_EMR_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_EMR_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_EMR_E27_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E27_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_EMR_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_EMR_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_EMR_E26_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E26_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_EMR_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_EMR_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_EMR_E25_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E25_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_EMR_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_EMR_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_EMR_E24_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E24_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_EMR_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_EMR_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_EMR_E23_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E23_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_EMR_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_EMR_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_EMR_E22_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E22_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_EMR_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_EMR_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_EMR_E21_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E21_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_EMR_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_EMR_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_EMR_E20_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E20_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_EMR_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_EMR_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_EMR_E19_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E19_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_EMR_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_EMR_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_EMR_E18_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E18_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_EMR_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_EMR_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_EMR_E17_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E17_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_EMR_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_EMR_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_EMR_E16_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E16_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_EMR_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_EMR_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_EMR_E15_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E15_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_EMR_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_EMR_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_EMR_E14_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E14_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_EMR_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_EMR_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_EMR_E13_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E13_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_EMR_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_EMR_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_EMR_E12_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E12_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_EMR_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_EMR_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_EMR_E11_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E11_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_EMR_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_EMR_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_EMR_E10_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E10_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_EMR_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_EMR_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_EMR_E9_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E9_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_EMR_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_EMR_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_EMR_E8_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E8_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_EMR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_EMR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_EMR_E7_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E7_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_EMR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_EMR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_EMR_E6_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E6_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_EMR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_EMR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_EMR_E5_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E5_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_EMR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_EMR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_EMR_E4_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E4_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_EMR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_EMR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_EMR_E3_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E3_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_EMR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_EMR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_EMR_E2_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E2_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_EMR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_EMR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_EMR_E1_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E1_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_EMR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EMR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_EMR_E0_NO (0x00000000u)
#define CSL_EDMA3CC_EMR_E0_YES (0x00000001u)

#define CSL_EDMA3CC_EMR_RESETVAL (0x00000000u)

/* EMCR */

#define CSL_EDMA3CC_EMCR_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_EMCR_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_EMCR_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_EMCR_E31_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_EMCR_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_EMCR_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_EMCR_E30_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_EMCR_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_EMCR_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_EMCR_E29_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_EMCR_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_EMCR_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_EMCR_E28_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_EMCR_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_EMCR_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_EMCR_E27_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_EMCR_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_EMCR_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_EMCR_E26_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_EMCR_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_EMCR_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_EMCR_E25_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_EMCR_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_EMCR_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_EMCR_E24_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_EMCR_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_EMCR_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_EMCR_E23_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_EMCR_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_EMCR_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_EMCR_E22_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_EMCR_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_EMCR_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_EMCR_E21_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_EMCR_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_EMCR_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_EMCR_E20_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_EMCR_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_EMCR_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_EMCR_E19_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_EMCR_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_EMCR_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_EMCR_E18_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_EMCR_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_EMCR_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_EMCR_E17_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_EMCR_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_EMCR_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_EMCR_E16_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_EMCR_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_EMCR_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_EMCR_E15_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_EMCR_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_EMCR_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_EMCR_E14_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_EMCR_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_EMCR_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_EMCR_E13_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_EMCR_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_EMCR_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_EMCR_E12_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_EMCR_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_EMCR_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_EMCR_E11_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_EMCR_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_EMCR_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_EMCR_E10_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_EMCR_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_EMCR_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_EMCR_E9_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_EMCR_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_EMCR_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_EMCR_E8_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_EMCR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_EMCR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_EMCR_E7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_EMCR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_EMCR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_EMCR_E6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_EMCR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_EMCR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_EMCR_E5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_EMCR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_EMCR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_EMCR_E4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_EMCR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_EMCR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_EMCR_E3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_EMCR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_EMCR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_EMCR_E2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_EMCR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_EMCR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_EMCR_E1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_EMCR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EMCR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_EMCR_E0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EMCR_RESETVAL (0x00000000u)

/* QEMR */


#define CSL_EDMA3CC_QEMR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QEMR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QEMR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QEMR_E7_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E7_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QEMR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QEMR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QEMR_E6_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E6_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QEMR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QEMR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QEMR_E5_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E5_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QEMR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QEMR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QEMR_E4_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E4_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QEMR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QEMR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QEMR_E3_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E3_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QEMR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QEMR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QEMR_E2_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E2_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QEMR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QEMR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QEMR_E1_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E1_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QEMR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEMR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QEMR_E0_NO (0x00000000u)
#define CSL_EDMA3CC_QEMR_E0_YES (0x00000001u)

#define CSL_EDMA3CC_QEMR_RESETVAL (0x00000000u)

/* QEMCR */


#define CSL_EDMA3CC_QEMCR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QEMCR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QEMCR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QEMCR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QEMCR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QEMCR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QEMCR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QEMCR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QEMCR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QEMCR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QEMCR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QEMCR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QEMCR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QEMCR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QEMCR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QEMCR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEMCR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QEMCR_E0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEMCR_RESETVAL (0x00000000u)

/* CCERR */


#define CSL_EDMA3CC_CCERR_TCCERR_MASK (0x00010000u)
#define CSL_EDMA3CC_CCERR_TCCERR_SHIFT (0x00000010u)
#define CSL_EDMA3CC_CCERR_TCCERR_RESETVAL (0x00000000u)
/*----TCCERR Tokens----*/
#define CSL_EDMA3CC_CCERR_TCCERR_FALSE (0x00000000u)
#define CSL_EDMA3CC_CCERR_TCCERR_TRUE (0x00000001u)


#define CSL_EDMA3CC_CCERR_QTHRXCD2_MASK (0x00000004u)
#define CSL_EDMA3CC_CCERR_QTHRXCD2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_CCERR_QTHRXCD2_RESETVAL (0x00000000u)
/*----QTHRXCD2 Tokens----*/
#define CSL_EDMA3CC_CCERR_QTHRXCD2_FALSE (0x00000000u)
#define CSL_EDMA3CC_CCERR_QTHRXCD2_TRUE (0x00000001u)

#define CSL_EDMA3CC_CCERR_QTHRXCD1_MASK (0x00000002u)
#define CSL_EDMA3CC_CCERR_QTHRXCD1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_CCERR_QTHRXCD1_RESETVAL (0x00000000u)
/*----QTHRXCD1 Tokens----*/
#define CSL_EDMA3CC_CCERR_QTHRXCD1_FALSE (0x00000000u)
#define CSL_EDMA3CC_CCERR_QTHRXCD1_TRUE (0x00000001u)

#define CSL_EDMA3CC_CCERR_QTHRXCD0_MASK (0x00000001u)
#define CSL_EDMA3CC_CCERR_QTHRXCD0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_CCERR_QTHRXCD0_RESETVAL (0x00000000u)
/*----QTHRXCD0 Tokens----*/
#define CSL_EDMA3CC_CCERR_QTHRXCD0_FALSE (0x00000000u)
#define CSL_EDMA3CC_CCERR_QTHRXCD0_TRUE (0x00000001u)

#define CSL_EDMA3CC_CCERR_RESETVAL (0x00000000u)

/* CCERRCLR */


#define CSL_EDMA3CC_CCERRCLR_TCCERR_MASK (0x00010000u)
#define CSL_EDMA3CC_CCERRCLR_TCCERR_SHIFT (0x00000010u)
#define CSL_EDMA3CC_CCERRCLR_TCCERR_RESETVAL (0x00000000u)
/*----TCCERR Tokens----*/
#define CSL_EDMA3CC_CCERRCLR_TCCERR_CLEAR (0x00000001u)


#define CSL_EDMA3CC_CCERRCLR_QTHRXCD2_MASK (0x00000004u)
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD2_RESETVAL (0x00000000u)
/*----QTHRXCD2 Tokens----*/
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_CCERRCLR_QTHRXCD1_MASK (0x00000002u)
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD1_RESETVAL (0x00000000u)
/*----QTHRXCD1 Tokens----*/
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_CCERRCLR_QTHRXCD0_MASK (0x00000001u)
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD0_RESETVAL (0x00000000u)
/*----QTHRXCD0 Tokens----*/
#define CSL_EDMA3CC_CCERRCLR_QTHRXCD0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_CCERRCLR_RESETVAL (0x00000000u)

/* EEVAL */



#define CSL_EDMA3CC_EEVAL_EVAL_MASK (0x00000001u)
#define CSL_EDMA3CC_EEVAL_EVAL_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EEVAL_EVAL_RESETVAL (0x00000000u)
/*----EVAL Tokens----*/
#define CSL_EDMA3CC_EEVAL_EVAL_EVAL (0x00000001u)

#define CSL_EDMA3CC_EEVAL_RESETVAL (0x00000000u)

/* QRAE */


#define CSL_EDMA3CC_QRAE_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QRAE_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QRAE_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QRAE_E7_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E7_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QRAE_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QRAE_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QRAE_E6_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E6_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QRAE_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QRAE_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QRAE_E5_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E5_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QRAE_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QRAE_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QRAE_E4_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E4_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QRAE_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QRAE_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QRAE_E3_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E3_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QRAE_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QRAE_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QRAE_E2_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E2_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QRAE_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QRAE_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QRAE_E1_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E1_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QRAE_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QRAE_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QRAE_E0_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QRAE_E0_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QRAE_RESETVAL (0x00000000u)

/* QSTAT */


#define CSL_EDMA3CC_QSTAT_THRXCD_MASK (0x01000000u)
#define CSL_EDMA3CC_QSTAT_THRXCD_SHIFT (0x00000018u)
#define CSL_EDMA3CC_QSTAT_THRXCD_RESETVAL (0x00000000u)
/*----THRXCD Tokens----*/
#define CSL_EDMA3CC_QSTAT_THRXCD_NO (0x00000000u)
#define CSL_EDMA3CC_QSTAT_THRXCD_YES (0x00000001u)


#define CSL_EDMA3CC_QSTAT_WM_MASK (0x001F0000u)
#define CSL_EDMA3CC_QSTAT_WM_SHIFT (0x00000010u)
#define CSL_EDMA3CC_QSTAT_WM_RESETVAL (0x00000000u)
#define CSL_EDMA3CC_QSTAT_WM_EMPTY (0x00000000u)
#define CSL_EDMA3CC_QSTAT_WM_FULL (0x00000010u)


#define CSL_EDMA3CC_QSTAT_NUMVAL_MASK (0x00001F00u)
#define CSL_EDMA3CC_QSTAT_NUMVAL_SHIFT (0x00000008u)
#define CSL_EDMA3CC_QSTAT_NUMVAL_RESETVAL (0x00000000u)
#define CSL_EDMA3CC_QSTAT_NUMVAL_EMPTY (0x00000000u)
#define CSL_EDMA3CC_QSTAT_NUMVAL_FULL (0x00000010u)


#define CSL_EDMA3CC_QSTAT_STRTPTR_MASK (0x0000000Fu)
#define CSL_EDMA3CC_QSTAT_STRTPTR_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QSTAT_STRTPTR_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_QSTAT_RESETVAL (0x00000000u)

/* QWMTHRA */


#define CSL_EDMA3CC_QWMTHRA_Q2_MASK (0x001F0000u)
#define CSL_EDMA3CC_QWMTHRA_Q2_SHIFT (0x00000010u)
#define CSL_EDMA3CC_QWMTHRA_Q2_RESETVAL (0x00000010u)
#define CSL_EDMA3CC_QWMTHRA_Q2_DISABLE (0x00000011u)
#define CSL_EDMA3CC_QWMTHRA_Q2_MAX (0x00000010u)


#define CSL_EDMA3CC_QWMTHRA_Q1_MASK (0x00001F00u)
#define CSL_EDMA3CC_QWMTHRA_Q1_SHIFT (0x00000008u)
#define CSL_EDMA3CC_QWMTHRA_Q1_RESETVAL (0x00000010u)
#define CSL_EDMA3CC_QWMTHRA_Q1_DISABLE (0x00000011u)
#define CSL_EDMA3CC_QWMTHRA_Q1_MAX (0x00000010u)


#define CSL_EDMA3CC_QWMTHRA_Q0_MASK (0x0000001Fu)
#define CSL_EDMA3CC_QWMTHRA_Q0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QWMTHRA_Q0_RESETVAL (0x00000010u)
#define CSL_EDMA3CC_QWMTHRA_Q0_DISABLE (0x00000011u)
#define CSL_EDMA3CC_QWMTHRA_Q0_MAX (0x00000010u)

#define CSL_EDMA3CC_QWMTHRA_RESETVAL (0x00101010u)

/* CCSTAT */


#define CSL_EDMA3CC_CCSTAT_QUEACTV2_MASK (0x00040000u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV2_SHIFT (0x00000012u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV2_RESETVAL (0x00000000u)
/*----QUEACTV2 Tokens----*/
#define CSL_EDMA3CC_CCSTAT_QUEACTV2_NONE (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV2_ACTIVE (0x00000001u)

#define CSL_EDMA3CC_CCSTAT_QUEACTV1_MASK (0x00020000u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV1_SHIFT (0x00000011u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV1_RESETVAL (0x00000000u)
/*----QUEACTV1 Tokens----*/
#define CSL_EDMA3CC_CCSTAT_QUEACTV1_NONE (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV1_ACTIVE (0x00000001u)

#define CSL_EDMA3CC_CCSTAT_QUEACTV0_MASK (0x00010000u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV0_SHIFT (0x00000010u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV0_RESETVAL (0x00000000u)
/*----QUEACTV0 Tokens----*/
#define CSL_EDMA3CC_CCSTAT_QUEACTV0_NONE (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_QUEACTV0_ACTIVE (0x00000001u)


#define CSL_EDMA3CC_CCSTAT_COMPACTV_MASK (0x00003F00u)
#define CSL_EDMA3CC_CCSTAT_COMPACTV_SHIFT (0x00000008u)
#define CSL_EDMA3CC_CCSTAT_COMPACTV_RESETVAL (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_COMPACTV_NONE (0x00000000u)


#define CSL_EDMA3CC_CCSTAT_ACTV_MASK (0x00000010u)
#define CSL_EDMA3CC_CCSTAT_ACTV_SHIFT (0x00000004u)
#define CSL_EDMA3CC_CCSTAT_ACTV_RESETVAL (0x00000000u)
/*----ACTV Tokens----*/
#define CSL_EDMA3CC_CCSTAT_ACTV_IDLE (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_ACTV_BUSY (0x00000001u)

#define CSL_EDMA3CC_CCSTAT_WSTATACTV_MASK (0x00000008u)
#define CSL_EDMA3CC_CCSTAT_WSTATACTV_SHIFT (0x00000003u)
#define CSL_EDMA3CC_CCSTAT_WSTATACTV_RESETVAL (0x00000000u)

#define CSL_EDMA3CC_CCSTAT_TRACTV_MASK (0x00000004u)
#define CSL_EDMA3CC_CCSTAT_TRACTV_SHIFT (0x00000002u)
#define CSL_EDMA3CC_CCSTAT_TRACTV_RESETVAL (0x00000000u)
/*----TRACTV Tokens----*/
#define CSL_EDMA3CC_CCSTAT_TRACTV_NONE (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_TRACTV_ACTIVE (0x00000001u)

#define CSL_EDMA3CC_CCSTAT_QEVTACTV_MASK (0x00000002u)
#define CSL_EDMA3CC_CCSTAT_QEVTACTV_SHIFT (0x00000001u)
#define CSL_EDMA3CC_CCSTAT_QEVTACTV_RESETVAL (0x00000000u)
/*----QEVTACTV Tokens----*/
#define CSL_EDMA3CC_CCSTAT_QEVTACTV_NONE (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_QEVTACTV_ACTIVE (0x00000001u)

#define CSL_EDMA3CC_CCSTAT_EVTACTV_MASK (0x00000001u)
#define CSL_EDMA3CC_CCSTAT_EVTACTV_SHIFT (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_EVTACTV_RESETVAL (0x00000000u)
/*----EVTACTV Tokens----*/
#define CSL_EDMA3CC_CCSTAT_EVTACTV_NONE (0x00000000u)
#define CSL_EDMA3CC_CCSTAT_EVTACTV_ACTIVE (0x00000001u)

#define CSL_EDMA3CC_CCSTAT_RESETVAL (0x00000000u)

/* ER */

#define CSL_EDMA3CC_ER_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_ER_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_ER_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_ER_E31_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E31_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_ER_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_ER_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_ER_E30_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E30_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_ER_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_ER_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_ER_E29_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E29_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_ER_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_ER_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_ER_E28_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E28_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_ER_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_ER_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_ER_E27_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E27_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_ER_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_ER_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_ER_E26_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E26_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_ER_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_ER_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_ER_E25_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E25_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_ER_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_ER_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_ER_E24_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E24_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_ER_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_ER_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_ER_E23_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E23_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_ER_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_ER_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_ER_E22_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E22_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_ER_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_ER_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_ER_E21_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E21_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_ER_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_ER_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_ER_E20_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E20_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_ER_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_ER_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_ER_E19_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E19_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_ER_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_ER_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_ER_E18_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E18_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_ER_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_ER_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_ER_E17_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E17_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_ER_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_ER_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_ER_E16_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E16_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_ER_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_ER_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_ER_E15_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E15_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_ER_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_ER_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_ER_E14_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E14_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_ER_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_ER_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_ER_E13_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E13_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_ER_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_ER_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_ER_E12_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E12_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_ER_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_ER_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_ER_E11_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E11_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_ER_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_ER_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_ER_E10_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E10_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_ER_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_ER_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_ER_E9_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E9_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_ER_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_ER_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_ER_E8_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E8_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_ER_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_ER_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_ER_E7_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E7_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_ER_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_ER_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_ER_E6_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E6_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_ER_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_ER_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_ER_E5_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E5_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_ER_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_ER_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_ER_E4_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E4_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_ER_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_ER_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_ER_E3_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E3_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_ER_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_ER_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_ER_E2_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E2_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_ER_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_ER_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_ER_E1_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E1_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_ER_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ER_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_ER_E0_NOT_ASSERTED (0x00000000u)
#define CSL_EDMA3CC_ER_E0_ASSERTED (0x00000001u)

#define CSL_EDMA3CC_ER_RESETVAL (0x00000000u)

/* ECR */

#define CSL_EDMA3CC_ECR_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_ECR_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_ECR_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_ECR_E31_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_ECR_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_ECR_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_ECR_E30_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_ECR_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_ECR_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_ECR_E29_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_ECR_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_ECR_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_ECR_E28_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_ECR_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_ECR_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_ECR_E27_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_ECR_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_ECR_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_ECR_E26_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_ECR_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_ECR_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_ECR_E25_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_ECR_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_ECR_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_ECR_E24_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_ECR_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_ECR_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_ECR_E23_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_ECR_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_ECR_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_ECR_E22_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_ECR_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_ECR_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_ECR_E21_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_ECR_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_ECR_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_ECR_E20_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_ECR_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_ECR_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_ECR_E19_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_ECR_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_ECR_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_ECR_E18_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_ECR_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_ECR_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_ECR_E17_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_ECR_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_ECR_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_ECR_E16_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_ECR_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_ECR_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_ECR_E15_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_ECR_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_ECR_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_ECR_E14_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_ECR_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_ECR_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_ECR_E13_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_ECR_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_ECR_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_ECR_E12_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_ECR_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_ECR_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_ECR_E11_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_ECR_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_ECR_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_ECR_E10_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_ECR_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_ECR_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_ECR_E9_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_ECR_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_ECR_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_ECR_E8_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_ECR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_ECR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_ECR_E7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_ECR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_ECR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_ECR_E6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_ECR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_ECR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_ECR_E5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_ECR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_ECR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_ECR_E4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_ECR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_ECR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_ECR_E3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_ECR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_ECR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_ECR_E2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_ECR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_ECR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_ECR_E1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_ECR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ECR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_ECR_E0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ECR_RESETVAL (0x00000000u)

/* ESR */

#define CSL_EDMA3CC_ESR_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_ESR_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_ESR_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_ESR_E31_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_ESR_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_ESR_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_ESR_E30_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_ESR_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_ESR_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_ESR_E29_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_ESR_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_ESR_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_ESR_E28_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_ESR_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_ESR_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_ESR_E27_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_ESR_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_ESR_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_ESR_E26_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_ESR_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_ESR_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_ESR_E25_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_ESR_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_ESR_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_ESR_E24_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_ESR_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_ESR_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_ESR_E23_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_ESR_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_ESR_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_ESR_E22_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_ESR_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_ESR_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_ESR_E21_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_ESR_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_ESR_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_ESR_E20_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_ESR_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_ESR_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_ESR_E19_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_ESR_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_ESR_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_ESR_E18_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_ESR_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_ESR_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_ESR_E17_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_ESR_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_ESR_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_ESR_E16_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_ESR_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_ESR_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_ESR_E15_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_ESR_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_ESR_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_ESR_E14_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_ESR_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_ESR_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_ESR_E13_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_ESR_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_ESR_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_ESR_E12_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_ESR_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_ESR_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_ESR_E11_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_ESR_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_ESR_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_ESR_E10_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_ESR_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_ESR_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_ESR_E9_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_ESR_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_ESR_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_ESR_E8_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_ESR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_ESR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_ESR_E7_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_ESR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_ESR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_ESR_E6_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_ESR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_ESR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_ESR_E5_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_ESR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_ESR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_ESR_E4_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_ESR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_ESR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_ESR_E3_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_ESR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_ESR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_ESR_E2_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_ESR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_ESR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_ESR_E1_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_ESR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ESR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_ESR_E0_SET (0x00000001u)

#define CSL_EDMA3CC_ESR_RESETVAL (0x00000000u)

/* CER */

#define CSL_EDMA3CC_CER_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_CER_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_CER_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_CER_E31_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_CER_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_CER_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_CER_E30_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_CER_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_CER_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_CER_E29_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_CER_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_CER_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_CER_E28_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_CER_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_CER_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_CER_E27_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_CER_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_CER_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_CER_E26_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_CER_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_CER_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_CER_E25_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_CER_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_CER_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_CER_E24_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_CER_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_CER_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_CER_E23_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_CER_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_CER_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_CER_E22_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_CER_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_CER_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_CER_E21_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_CER_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_CER_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_CER_E20_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_CER_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_CER_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_CER_E19_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_CER_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_CER_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_CER_E18_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_CER_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_CER_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_CER_E17_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_CER_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_CER_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_CER_E16_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_CER_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_CER_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_CER_E15_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_CER_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_CER_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_CER_E14_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_CER_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_CER_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_CER_E13_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_CER_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_CER_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_CER_E12_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_CER_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_CER_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_CER_E11_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_CER_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_CER_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_CER_E10_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_CER_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_CER_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_CER_E9_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_CER_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_CER_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_CER_E8_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_CER_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_CER_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_CER_E7_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_CER_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_CER_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_CER_E6_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_CER_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_CER_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_CER_E5_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_CER_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_CER_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_CER_E4_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_CER_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_CER_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_CER_E3_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_CER_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_CER_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_CER_E2_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_CER_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_CER_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_CER_E1_SET (0x00000001u)

#define CSL_EDMA3CC_CER_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_CER_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_CER_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_CER_E0_SET (0x00000001u)

#define CSL_EDMA3CC_CER_RESETVAL (0x00000000u)

/* EER */

#define CSL_EDMA3CC_EER_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_EER_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_EER_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_EER_E31_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E31_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_EER_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_EER_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_EER_E30_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E30_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_EER_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_EER_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_EER_E29_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E29_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_EER_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_EER_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_EER_E28_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E28_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_EER_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_EER_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_EER_E27_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E27_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_EER_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_EER_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_EER_E26_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E26_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_EER_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_EER_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_EER_E25_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E25_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_EER_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_EER_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_EER_E24_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E24_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_EER_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_EER_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_EER_E23_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E23_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_EER_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_EER_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_EER_E22_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E22_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_EER_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_EER_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_EER_E21_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E21_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_EER_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_EER_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_EER_E20_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E20_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_EER_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_EER_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_EER_E19_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E19_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_EER_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_EER_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_EER_E18_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E18_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_EER_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_EER_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_EER_E17_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E17_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_EER_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_EER_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_EER_E16_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E16_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_EER_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_EER_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_EER_E15_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E15_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_EER_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_EER_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_EER_E14_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E14_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_EER_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_EER_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_EER_E13_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E13_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_EER_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_EER_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_EER_E12_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E12_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_EER_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_EER_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_EER_E11_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E11_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_EER_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_EER_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_EER_E10_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E10_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_EER_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_EER_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_EER_E9_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E9_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_EER_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_EER_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_EER_E8_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E8_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_EER_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_EER_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_EER_E7_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E7_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_EER_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_EER_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_EER_E6_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E6_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_EER_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_EER_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_EER_E5_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E5_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_EER_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_EER_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_EER_E4_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E4_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_EER_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_EER_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_EER_E3_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E3_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_EER_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_EER_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_EER_E2_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E2_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_EER_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_EER_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_EER_E1_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E1_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_EER_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EER_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_EER_E0_DISABLE (0x00000000u)
#define CSL_EDMA3CC_EER_E0_ENABLE (0x00000001u)

#define CSL_EDMA3CC_EER_RESETVAL (0x00000000u)

/* EECR */

#define CSL_EDMA3CC_EECR_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_EECR_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_EECR_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_EECR_E31_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_EECR_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_EECR_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_EECR_E30_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_EECR_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_EECR_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_EECR_E29_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_EECR_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_EECR_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_EECR_E28_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_EECR_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_EECR_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_EECR_E27_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_EECR_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_EECR_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_EECR_E26_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_EECR_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_EECR_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_EECR_E25_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_EECR_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_EECR_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_EECR_E24_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_EECR_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_EECR_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_EECR_E23_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_EECR_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_EECR_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_EECR_E22_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_EECR_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_EECR_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_EECR_E21_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_EECR_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_EECR_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_EECR_E20_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_EECR_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_EECR_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_EECR_E19_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_EECR_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_EECR_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_EECR_E18_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_EECR_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_EECR_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_EECR_E17_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_EECR_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_EECR_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_EECR_E16_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_EECR_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_EECR_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_EECR_E15_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_EECR_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_EECR_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_EECR_E14_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_EECR_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_EECR_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_EECR_E13_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_EECR_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_EECR_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_EECR_E12_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_EECR_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_EECR_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_EECR_E11_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_EECR_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_EECR_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_EECR_E10_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_EECR_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_EECR_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_EECR_E9_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_EECR_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_EECR_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_EECR_E8_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_EECR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_EECR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_EECR_E7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_EECR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_EECR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_EECR_E6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_EECR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_EECR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_EECR_E5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_EECR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_EECR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_EECR_E4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_EECR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_EECR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_EECR_E3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_EECR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_EECR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_EECR_E2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_EECR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_EECR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_EECR_E1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_EECR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EECR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_EECR_E0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_EECR_RESETVAL (0x00000000u)

/* EESR */

#define CSL_EDMA3CC_EESR_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_EESR_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_EESR_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_EESR_E31_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_EESR_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_EESR_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_EESR_E30_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_EESR_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_EESR_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_EESR_E29_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_EESR_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_EESR_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_EESR_E28_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_EESR_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_EESR_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_EESR_E27_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_EESR_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_EESR_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_EESR_E26_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_EESR_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_EESR_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_EESR_E25_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_EESR_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_EESR_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_EESR_E24_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_EESR_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_EESR_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_EESR_E23_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_EESR_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_EESR_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_EESR_E22_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_EESR_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_EESR_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_EESR_E21_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_EESR_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_EESR_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_EESR_E20_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_EESR_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_EESR_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_EESR_E19_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_EESR_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_EESR_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_EESR_E18_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_EESR_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_EESR_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_EESR_E17_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_EESR_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_EESR_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_EESR_E16_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_EESR_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_EESR_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_EESR_E15_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_EESR_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_EESR_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_EESR_E14_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_EESR_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_EESR_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_EESR_E13_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_EESR_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_EESR_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_EESR_E12_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_EESR_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_EESR_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_EESR_E11_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_EESR_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_EESR_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_EESR_E10_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_EESR_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_EESR_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_EESR_E9_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_EESR_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_EESR_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_EESR_E8_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_EESR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_EESR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_EESR_E7_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_EESR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_EESR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_EESR_E6_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_EESR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_EESR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_EESR_E5_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_EESR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_EESR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_EESR_E4_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_EESR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_EESR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_EESR_E3_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_EESR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_EESR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_EESR_E2_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_EESR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_EESR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_EESR_E1_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_EESR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_EESR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_EESR_E0_SET (0x00000001u)

#define CSL_EDMA3CC_EESR_RESETVAL (0x00000000u)

/* SER */

#define CSL_EDMA3CC_SER_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_SER_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_SER_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_SER_E31_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E31_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_SER_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_SER_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_SER_E30_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E30_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_SER_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_SER_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_SER_E29_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E29_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_SER_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_SER_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_SER_E28_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E28_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_SER_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_SER_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_SER_E27_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E27_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_SER_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_SER_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_SER_E26_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E26_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_SER_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_SER_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_SER_E25_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E25_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_SER_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_SER_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_SER_E24_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E24_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_SER_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_SER_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_SER_E23_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E23_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_SER_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_SER_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_SER_E22_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E22_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_SER_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_SER_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_SER_E21_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E21_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_SER_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_SER_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_SER_E20_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E20_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_SER_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_SER_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_SER_E19_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E19_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_SER_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_SER_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_SER_E18_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E18_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_SER_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_SER_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_SER_E17_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E17_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_SER_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_SER_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_SER_E16_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E16_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_SER_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_SER_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_SER_E15_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E15_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_SER_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_SER_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_SER_E14_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E14_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_SER_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_SER_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_SER_E13_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E13_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_SER_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_SER_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_SER_E12_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E12_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_SER_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_SER_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_SER_E11_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E11_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_SER_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_SER_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_SER_E10_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E10_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_SER_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_SER_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_SER_E9_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E9_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_SER_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_SER_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_SER_E8_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E8_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_SER_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_SER_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_SER_E7_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E7_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_SER_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_SER_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_SER_E6_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E6_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_SER_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_SER_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_SER_E5_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E5_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_SER_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_SER_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_SER_E4_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E4_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_SER_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_SER_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_SER_E3_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E3_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_SER_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_SER_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_SER_E2_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E2_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_SER_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_SER_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_SER_E1_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E1_YES (0x00000001u)

#define CSL_EDMA3CC_SER_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_SER_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_SER_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_SER_E0_NO (0x00000000u)
#define CSL_EDMA3CC_SER_E0_YES (0x00000001u)

#define CSL_EDMA3CC_SER_RESETVAL (0x00000000u)

/* SECR */

#define CSL_EDMA3CC_SECR_E31_MASK (0x80000000u)
#define CSL_EDMA3CC_SECR_E31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_SECR_E31_RESETVAL (0x00000000u)
/*----E31 Tokens----*/
#define CSL_EDMA3CC_SECR_E31_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E30_MASK (0x40000000u)
#define CSL_EDMA3CC_SECR_E30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_SECR_E30_RESETVAL (0x00000000u)
/*----E30 Tokens----*/
#define CSL_EDMA3CC_SECR_E30_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E29_MASK (0x20000000u)
#define CSL_EDMA3CC_SECR_E29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_SECR_E29_RESETVAL (0x00000000u)
/*----E29 Tokens----*/
#define CSL_EDMA3CC_SECR_E29_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E28_MASK (0x10000000u)
#define CSL_EDMA3CC_SECR_E28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_SECR_E28_RESETVAL (0x00000000u)
/*----E28 Tokens----*/
#define CSL_EDMA3CC_SECR_E28_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E27_MASK (0x08000000u)
#define CSL_EDMA3CC_SECR_E27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_SECR_E27_RESETVAL (0x00000000u)
/*----E27 Tokens----*/
#define CSL_EDMA3CC_SECR_E27_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E26_MASK (0x04000000u)
#define CSL_EDMA3CC_SECR_E26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_SECR_E26_RESETVAL (0x00000000u)
/*----E26 Tokens----*/
#define CSL_EDMA3CC_SECR_E26_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E25_MASK (0x02000000u)
#define CSL_EDMA3CC_SECR_E25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_SECR_E25_RESETVAL (0x00000000u)
/*----E25 Tokens----*/
#define CSL_EDMA3CC_SECR_E25_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E24_MASK (0x01000000u)
#define CSL_EDMA3CC_SECR_E24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_SECR_E24_RESETVAL (0x00000000u)
/*----E24 Tokens----*/
#define CSL_EDMA3CC_SECR_E24_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E23_MASK (0x00800000u)
#define CSL_EDMA3CC_SECR_E23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_SECR_E23_RESETVAL (0x00000000u)
/*----E23 Tokens----*/
#define CSL_EDMA3CC_SECR_E23_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E22_MASK (0x00400000u)
#define CSL_EDMA3CC_SECR_E22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_SECR_E22_RESETVAL (0x00000000u)
/*----E22 Tokens----*/
#define CSL_EDMA3CC_SECR_E22_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E21_MASK (0x00200000u)
#define CSL_EDMA3CC_SECR_E21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_SECR_E21_RESETVAL (0x00000000u)
/*----E21 Tokens----*/
#define CSL_EDMA3CC_SECR_E21_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E20_MASK (0x00100000u)
#define CSL_EDMA3CC_SECR_E20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_SECR_E20_RESETVAL (0x00000000u)
/*----E20 Tokens----*/
#define CSL_EDMA3CC_SECR_E20_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E19_MASK (0x00080000u)
#define CSL_EDMA3CC_SECR_E19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_SECR_E19_RESETVAL (0x00000000u)
/*----E19 Tokens----*/
#define CSL_EDMA3CC_SECR_E19_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E18_MASK (0x00040000u)
#define CSL_EDMA3CC_SECR_E18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_SECR_E18_RESETVAL (0x00000000u)
/*----E18 Tokens----*/
#define CSL_EDMA3CC_SECR_E18_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E17_MASK (0x00020000u)
#define CSL_EDMA3CC_SECR_E17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_SECR_E17_RESETVAL (0x00000000u)
/*----E17 Tokens----*/
#define CSL_EDMA3CC_SECR_E17_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E16_MASK (0x00010000u)
#define CSL_EDMA3CC_SECR_E16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_SECR_E16_RESETVAL (0x00000000u)
/*----E16 Tokens----*/
#define CSL_EDMA3CC_SECR_E16_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E15_MASK (0x00008000u)
#define CSL_EDMA3CC_SECR_E15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_SECR_E15_RESETVAL (0x00000000u)
/*----E15 Tokens----*/
#define CSL_EDMA3CC_SECR_E15_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E14_MASK (0x00004000u)
#define CSL_EDMA3CC_SECR_E14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_SECR_E14_RESETVAL (0x00000000u)
/*----E14 Tokens----*/
#define CSL_EDMA3CC_SECR_E14_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E13_MASK (0x00002000u)
#define CSL_EDMA3CC_SECR_E13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_SECR_E13_RESETVAL (0x00000000u)
/*----E13 Tokens----*/
#define CSL_EDMA3CC_SECR_E13_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E12_MASK (0x00001000u)
#define CSL_EDMA3CC_SECR_E12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_SECR_E12_RESETVAL (0x00000000u)
/*----E12 Tokens----*/
#define CSL_EDMA3CC_SECR_E12_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E11_MASK (0x00000800u)
#define CSL_EDMA3CC_SECR_E11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_SECR_E11_RESETVAL (0x00000000u)
/*----E11 Tokens----*/
#define CSL_EDMA3CC_SECR_E11_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E10_MASK (0x00000400u)
#define CSL_EDMA3CC_SECR_E10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_SECR_E10_RESETVAL (0x00000000u)
/*----E10 Tokens----*/
#define CSL_EDMA3CC_SECR_E10_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E9_MASK (0x00000200u)
#define CSL_EDMA3CC_SECR_E9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_SECR_E9_RESETVAL (0x00000000u)
/*----E9 Tokens----*/
#define CSL_EDMA3CC_SECR_E9_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E8_MASK (0x00000100u)
#define CSL_EDMA3CC_SECR_E8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_SECR_E8_RESETVAL (0x00000000u)
/*----E8 Tokens----*/
#define CSL_EDMA3CC_SECR_E8_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_SECR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_SECR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_SECR_E7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_SECR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_SECR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_SECR_E6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_SECR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_SECR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_SECR_E5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_SECR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_SECR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_SECR_E4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_SECR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_SECR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_SECR_E3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_SECR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_SECR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_SECR_E2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_SECR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_SECR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_SECR_E1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_SECR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_SECR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_SECR_E0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_SECR_RESETVAL (0x00000000u)

/* IER */

#define CSL_EDMA3CC_IER_I31_MASK (0x80000000u)
#define CSL_EDMA3CC_IER_I31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_IER_I31_RESETVAL (0x00000000u)
/*----I31 Tokens----*/
#define CSL_EDMA3CC_IER_I31_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I31_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I30_MASK (0x40000000u)
#define CSL_EDMA3CC_IER_I30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_IER_I30_RESETVAL (0x00000000u)
/*----I30 Tokens----*/
#define CSL_EDMA3CC_IER_I30_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I30_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I29_MASK (0x20000000u)
#define CSL_EDMA3CC_IER_I29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_IER_I29_RESETVAL (0x00000000u)
/*----I29 Tokens----*/
#define CSL_EDMA3CC_IER_I29_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I29_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I28_MASK (0x10000000u)
#define CSL_EDMA3CC_IER_I28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_IER_I28_RESETVAL (0x00000000u)
/*----I28 Tokens----*/
#define CSL_EDMA3CC_IER_I28_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I28_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I27_MASK (0x08000000u)
#define CSL_EDMA3CC_IER_I27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_IER_I27_RESETVAL (0x00000000u)
/*----I27 Tokens----*/
#define CSL_EDMA3CC_IER_I27_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I27_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I26_MASK (0x04000000u)
#define CSL_EDMA3CC_IER_I26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_IER_I26_RESETVAL (0x00000000u)
/*----I26 Tokens----*/
#define CSL_EDMA3CC_IER_I26_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I26_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I25_MASK (0x02000000u)
#define CSL_EDMA3CC_IER_I25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_IER_I25_RESETVAL (0x00000000u)
/*----I25 Tokens----*/
#define CSL_EDMA3CC_IER_I25_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I25_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I24_MASK (0x01000000u)
#define CSL_EDMA3CC_IER_I24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_IER_I24_RESETVAL (0x00000000u)
/*----I24 Tokens----*/
#define CSL_EDMA3CC_IER_I24_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I24_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I23_MASK (0x00800000u)
#define CSL_EDMA3CC_IER_I23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_IER_I23_RESETVAL (0x00000000u)
/*----I23 Tokens----*/
#define CSL_EDMA3CC_IER_I23_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I23_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I22_MASK (0x00400000u)
#define CSL_EDMA3CC_IER_I22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_IER_I22_RESETVAL (0x00000000u)
/*----I22 Tokens----*/
#define CSL_EDMA3CC_IER_I22_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I22_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I21_MASK (0x00200000u)
#define CSL_EDMA3CC_IER_I21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_IER_I21_RESETVAL (0x00000000u)
/*----I21 Tokens----*/
#define CSL_EDMA3CC_IER_I21_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I21_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I20_MASK (0x00100000u)
#define CSL_EDMA3CC_IER_I20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_IER_I20_RESETVAL (0x00000000u)
/*----I20 Tokens----*/
#define CSL_EDMA3CC_IER_I20_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I20_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I19_MASK (0x00080000u)
#define CSL_EDMA3CC_IER_I19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_IER_I19_RESETVAL (0x00000000u)
/*----I19 Tokens----*/
#define CSL_EDMA3CC_IER_I19_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I19_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I18_MASK (0x00040000u)
#define CSL_EDMA3CC_IER_I18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_IER_I18_RESETVAL (0x00000000u)
/*----I18 Tokens----*/
#define CSL_EDMA3CC_IER_I18_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I18_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I17_MASK (0x00020000u)
#define CSL_EDMA3CC_IER_I17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_IER_I17_RESETVAL (0x00000000u)
/*----I17 Tokens----*/
#define CSL_EDMA3CC_IER_I17_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I17_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I16_MASK (0x00010000u)
#define CSL_EDMA3CC_IER_I16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_IER_I16_RESETVAL (0x00000000u)
/*----I16 Tokens----*/
#define CSL_EDMA3CC_IER_I16_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I16_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I15_MASK (0x00008000u)
#define CSL_EDMA3CC_IER_I15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_IER_I15_RESETVAL (0x00000000u)
/*----I15 Tokens----*/
#define CSL_EDMA3CC_IER_I15_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I15_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I14_MASK (0x00004000u)
#define CSL_EDMA3CC_IER_I14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_IER_I14_RESETVAL (0x00000000u)
/*----I14 Tokens----*/
#define CSL_EDMA3CC_IER_I14_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I14_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I13_MASK (0x00002000u)
#define CSL_EDMA3CC_IER_I13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_IER_I13_RESETVAL (0x00000000u)
/*----I13 Tokens----*/
#define CSL_EDMA3CC_IER_I13_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I13_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I12_MASK (0x00001000u)
#define CSL_EDMA3CC_IER_I12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_IER_I12_RESETVAL (0x00000000u)
/*----I12 Tokens----*/
#define CSL_EDMA3CC_IER_I12_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I12_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I11_MASK (0x00000800u)
#define CSL_EDMA3CC_IER_I11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_IER_I11_RESETVAL (0x00000000u)
/*----I11 Tokens----*/
#define CSL_EDMA3CC_IER_I11_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I11_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I10_MASK (0x00000400u)
#define CSL_EDMA3CC_IER_I10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_IER_I10_RESETVAL (0x00000000u)
/*----I10 Tokens----*/
#define CSL_EDMA3CC_IER_I10_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I10_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I9_MASK (0x00000200u)
#define CSL_EDMA3CC_IER_I9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_IER_I9_RESETVAL (0x00000000u)
/*----I9 Tokens----*/
#define CSL_EDMA3CC_IER_I9_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I9_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I8_MASK (0x00000100u)
#define CSL_EDMA3CC_IER_I8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_IER_I8_RESETVAL (0x00000000u)
/*----I8 Tokens----*/
#define CSL_EDMA3CC_IER_I8_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I8_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I7_MASK (0x00000080u)
#define CSL_EDMA3CC_IER_I7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_IER_I7_RESETVAL (0x00000000u)
/*----I7 Tokens----*/
#define CSL_EDMA3CC_IER_I7_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I7_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I6_MASK (0x00000040u)
#define CSL_EDMA3CC_IER_I6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_IER_I6_RESETVAL (0x00000000u)
/*----I6 Tokens----*/
#define CSL_EDMA3CC_IER_I6_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I6_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I5_MASK (0x00000020u)
#define CSL_EDMA3CC_IER_I5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_IER_I5_RESETVAL (0x00000000u)
/*----I5 Tokens----*/
#define CSL_EDMA3CC_IER_I5_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I5_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I4_MASK (0x00000010u)
#define CSL_EDMA3CC_IER_I4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_IER_I4_RESETVAL (0x00000000u)
/*----I4 Tokens----*/
#define CSL_EDMA3CC_IER_I4_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I4_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I3_MASK (0x00000008u)
#define CSL_EDMA3CC_IER_I3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_IER_I3_RESETVAL (0x00000000u)
/*----I3 Tokens----*/
#define CSL_EDMA3CC_IER_I3_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I3_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I2_MASK (0x00000004u)
#define CSL_EDMA3CC_IER_I2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_IER_I2_RESETVAL (0x00000000u)
/*----I2 Tokens----*/
#define CSL_EDMA3CC_IER_I2_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I2_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I1_MASK (0x00000002u)
#define CSL_EDMA3CC_IER_I1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_IER_I1_RESETVAL (0x00000000u)
/*----I1 Tokens----*/
#define CSL_EDMA3CC_IER_I1_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I1_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_I0_MASK (0x00000001u)
#define CSL_EDMA3CC_IER_I0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IER_I0_RESETVAL (0x00000000u)
/*----I0 Tokens----*/
#define CSL_EDMA3CC_IER_I0_DISABLE (0x00000000u)
#define CSL_EDMA3CC_IER_I0_ENABLE (0x00000001u)

#define CSL_EDMA3CC_IER_RESETVAL (0x00000000u)

/* IECR */

#define CSL_EDMA3CC_IECR_I31_MASK (0x80000000u)
#define CSL_EDMA3CC_IECR_I31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_IECR_I31_RESETVAL (0x00000000u)
/*----I31 Tokens----*/
#define CSL_EDMA3CC_IECR_I31_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I30_MASK (0x40000000u)
#define CSL_EDMA3CC_IECR_I30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_IECR_I30_RESETVAL (0x00000000u)
/*----I30 Tokens----*/
#define CSL_EDMA3CC_IECR_I30_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I29_MASK (0x20000000u)
#define CSL_EDMA3CC_IECR_I29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_IECR_I29_RESETVAL (0x00000000u)
/*----I29 Tokens----*/
#define CSL_EDMA3CC_IECR_I29_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I28_MASK (0x10000000u)
#define CSL_EDMA3CC_IECR_I28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_IECR_I28_RESETVAL (0x00000000u)
/*----I28 Tokens----*/
#define CSL_EDMA3CC_IECR_I28_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I27_MASK (0x08000000u)
#define CSL_EDMA3CC_IECR_I27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_IECR_I27_RESETVAL (0x00000000u)
/*----I27 Tokens----*/
#define CSL_EDMA3CC_IECR_I27_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I26_MASK (0x04000000u)
#define CSL_EDMA3CC_IECR_I26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_IECR_I26_RESETVAL (0x00000000u)
/*----I26 Tokens----*/
#define CSL_EDMA3CC_IECR_I26_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I25_MASK (0x02000000u)
#define CSL_EDMA3CC_IECR_I25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_IECR_I25_RESETVAL (0x00000000u)
/*----I25 Tokens----*/
#define CSL_EDMA3CC_IECR_I25_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I24_MASK (0x01000000u)
#define CSL_EDMA3CC_IECR_I24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_IECR_I24_RESETVAL (0x00000000u)
/*----I24 Tokens----*/
#define CSL_EDMA3CC_IECR_I24_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I23_MASK (0x00800000u)
#define CSL_EDMA3CC_IECR_I23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_IECR_I23_RESETVAL (0x00000000u)
/*----I23 Tokens----*/
#define CSL_EDMA3CC_IECR_I23_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I22_MASK (0x00400000u)
#define CSL_EDMA3CC_IECR_I22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_IECR_I22_RESETVAL (0x00000000u)
/*----I22 Tokens----*/
#define CSL_EDMA3CC_IECR_I22_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I21_MASK (0x00200000u)
#define CSL_EDMA3CC_IECR_I21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_IECR_I21_RESETVAL (0x00000000u)
/*----I21 Tokens----*/
#define CSL_EDMA3CC_IECR_I21_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I20_MASK (0x00100000u)
#define CSL_EDMA3CC_IECR_I20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_IECR_I20_RESETVAL (0x00000000u)
/*----I20 Tokens----*/
#define CSL_EDMA3CC_IECR_I20_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I19_MASK (0x00080000u)
#define CSL_EDMA3CC_IECR_I19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_IECR_I19_RESETVAL (0x00000000u)
/*----I19 Tokens----*/
#define CSL_EDMA3CC_IECR_I19_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I18_MASK (0x00040000u)
#define CSL_EDMA3CC_IECR_I18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_IECR_I18_RESETVAL (0x00000000u)
/*----I18 Tokens----*/
#define CSL_EDMA3CC_IECR_I18_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I17_MASK (0x00020000u)
#define CSL_EDMA3CC_IECR_I17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_IECR_I17_RESETVAL (0x00000000u)
/*----I17 Tokens----*/
#define CSL_EDMA3CC_IECR_I17_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I16_MASK (0x00010000u)
#define CSL_EDMA3CC_IECR_I16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_IECR_I16_RESETVAL (0x00000000u)
/*----I16 Tokens----*/
#define CSL_EDMA3CC_IECR_I16_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I15_MASK (0x00008000u)
#define CSL_EDMA3CC_IECR_I15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_IECR_I15_RESETVAL (0x00000000u)
/*----I15 Tokens----*/
#define CSL_EDMA3CC_IECR_I15_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I14_MASK (0x00004000u)
#define CSL_EDMA3CC_IECR_I14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_IECR_I14_RESETVAL (0x00000000u)
/*----I14 Tokens----*/
#define CSL_EDMA3CC_IECR_I14_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I13_MASK (0x00002000u)
#define CSL_EDMA3CC_IECR_I13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_IECR_I13_RESETVAL (0x00000000u)
/*----I13 Tokens----*/
#define CSL_EDMA3CC_IECR_I13_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I12_MASK (0x00001000u)
#define CSL_EDMA3CC_IECR_I12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_IECR_I12_RESETVAL (0x00000000u)
/*----I12 Tokens----*/
#define CSL_EDMA3CC_IECR_I12_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I11_MASK (0x00000800u)
#define CSL_EDMA3CC_IECR_I11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_IECR_I11_RESETVAL (0x00000000u)
/*----I11 Tokens----*/
#define CSL_EDMA3CC_IECR_I11_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I10_MASK (0x00000400u)
#define CSL_EDMA3CC_IECR_I10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_IECR_I10_RESETVAL (0x00000000u)
/*----I10 Tokens----*/
#define CSL_EDMA3CC_IECR_I10_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I9_MASK (0x00000200u)
#define CSL_EDMA3CC_IECR_I9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_IECR_I9_RESETVAL (0x00000000u)
/*----I9 Tokens----*/
#define CSL_EDMA3CC_IECR_I9_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I8_MASK (0x00000100u)
#define CSL_EDMA3CC_IECR_I8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_IECR_I8_RESETVAL (0x00000000u)
/*----I8 Tokens----*/
#define CSL_EDMA3CC_IECR_I8_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I7_MASK (0x00000080u)
#define CSL_EDMA3CC_IECR_I7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_IECR_I7_RESETVAL (0x00000000u)
/*----I7 Tokens----*/
#define CSL_EDMA3CC_IECR_I7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I6_MASK (0x00000040u)
#define CSL_EDMA3CC_IECR_I6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_IECR_I6_RESETVAL (0x00000000u)
/*----I6 Tokens----*/
#define CSL_EDMA3CC_IECR_I6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I5_MASK (0x00000020u)
#define CSL_EDMA3CC_IECR_I5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_IECR_I5_RESETVAL (0x00000000u)
/*----I5 Tokens----*/
#define CSL_EDMA3CC_IECR_I5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I4_MASK (0x00000010u)
#define CSL_EDMA3CC_IECR_I4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_IECR_I4_RESETVAL (0x00000000u)
/*----I4 Tokens----*/
#define CSL_EDMA3CC_IECR_I4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I3_MASK (0x00000008u)
#define CSL_EDMA3CC_IECR_I3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_IECR_I3_RESETVAL (0x00000000u)
/*----I3 Tokens----*/
#define CSL_EDMA3CC_IECR_I3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I2_MASK (0x00000004u)
#define CSL_EDMA3CC_IECR_I2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_IECR_I2_RESETVAL (0x00000000u)
/*----I2 Tokens----*/
#define CSL_EDMA3CC_IECR_I2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I1_MASK (0x00000002u)
#define CSL_EDMA3CC_IECR_I1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_IECR_I1_RESETVAL (0x00000000u)
/*----I1 Tokens----*/
#define CSL_EDMA3CC_IECR_I1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_I0_MASK (0x00000001u)
#define CSL_EDMA3CC_IECR_I0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IECR_I0_RESETVAL (0x00000000u)
/*----I0 Tokens----*/
#define CSL_EDMA3CC_IECR_I0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_IECR_RESETVAL (0x00000000u)


/* IESR */

#define CSL_EDMA3CC_IESR_I31_MASK (0x80000000u)
#define CSL_EDMA3CC_IESR_I31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_IESR_I31_RESETVAL (0x00000000u)
/*----I31 Tokens----*/
#define CSL_EDMA3CC_IESR_I31_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I30_MASK (0x40000000u)
#define CSL_EDMA3CC_IESR_I30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_IESR_I30_RESETVAL (0x00000000u)
/*----I30 Tokens----*/
#define CSL_EDMA3CC_IESR_I30_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I29_MASK (0x20000000u)
#define CSL_EDMA3CC_IESR_I29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_IESR_I29_RESETVAL (0x00000000u)
/*----I29 Tokens----*/
#define CSL_EDMA3CC_IESR_I29_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I28_MASK (0x10000000u)
#define CSL_EDMA3CC_IESR_I28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_IESR_I28_RESETVAL (0x00000000u)
/*----I28 Tokens----*/
#define CSL_EDMA3CC_IESR_I28_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I27_MASK (0x08000000u)
#define CSL_EDMA3CC_IESR_I27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_IESR_I27_RESETVAL (0x00000000u)
/*----I27 Tokens----*/
#define CSL_EDMA3CC_IESR_I27_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I26_MASK (0x04000000u)
#define CSL_EDMA3CC_IESR_I26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_IESR_I26_RESETVAL (0x00000000u)
/*----I26 Tokens----*/
#define CSL_EDMA3CC_IESR_I26_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I25_MASK (0x02000000u)
#define CSL_EDMA3CC_IESR_I25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_IESR_I25_RESETVAL (0x00000000u)
/*----I25 Tokens----*/
#define CSL_EDMA3CC_IESR_I25_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I24_MASK (0x01000000u)
#define CSL_EDMA3CC_IESR_I24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_IESR_I24_RESETVAL (0x00000000u)
/*----I24 Tokens----*/
#define CSL_EDMA3CC_IESR_I24_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I23_MASK (0x00800000u)
#define CSL_EDMA3CC_IESR_I23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_IESR_I23_RESETVAL (0x00000000u)
/*----I23 Tokens----*/
#define CSL_EDMA3CC_IESR_I23_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I22_MASK (0x00400000u)
#define CSL_EDMA3CC_IESR_I22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_IESR_I22_RESETVAL (0x00000000u)
/*----I22 Tokens----*/
#define CSL_EDMA3CC_IESR_I22_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I21_MASK (0x00200000u)
#define CSL_EDMA3CC_IESR_I21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_IESR_I21_RESETVAL (0x00000000u)
/*----I21 Tokens----*/
#define CSL_EDMA3CC_IESR_I21_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I20_MASK (0x00100000u)
#define CSL_EDMA3CC_IESR_I20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_IESR_I20_RESETVAL (0x00000000u)
/*----I20 Tokens----*/
#define CSL_EDMA3CC_IESR_I20_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I19_MASK (0x00080000u)
#define CSL_EDMA3CC_IESR_I19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_IESR_I19_RESETVAL (0x00000000u)
/*----I19 Tokens----*/
#define CSL_EDMA3CC_IESR_I19_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I18_MASK (0x00040000u)
#define CSL_EDMA3CC_IESR_I18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_IESR_I18_RESETVAL (0x00000000u)
/*----I18 Tokens----*/
#define CSL_EDMA3CC_IESR_I18_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I17_MASK (0x00020000u)
#define CSL_EDMA3CC_IESR_I17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_IESR_I17_RESETVAL (0x00000000u)
/*----I17 Tokens----*/
#define CSL_EDMA3CC_IESR_I17_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I16_MASK (0x00010000u)
#define CSL_EDMA3CC_IESR_I16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_IESR_I16_RESETVAL (0x00000000u)
/*----I16 Tokens----*/
#define CSL_EDMA3CC_IESR_I16_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I15_MASK (0x00008000u)
#define CSL_EDMA3CC_IESR_I15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_IESR_I15_RESETVAL (0x00000000u)
/*----I15 Tokens----*/
#define CSL_EDMA3CC_IESR_I15_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I14_MASK (0x00004000u)
#define CSL_EDMA3CC_IESR_I14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_IESR_I14_RESETVAL (0x00000000u)
/*----I14 Tokens----*/
#define CSL_EDMA3CC_IESR_I14_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I13_MASK (0x00002000u)
#define CSL_EDMA3CC_IESR_I13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_IESR_I13_RESETVAL (0x00000000u)
/*----I13 Tokens----*/
#define CSL_EDMA3CC_IESR_I13_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I12_MASK (0x00001000u)
#define CSL_EDMA3CC_IESR_I12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_IESR_I12_RESETVAL (0x00000000u)
/*----I12 Tokens----*/
#define CSL_EDMA3CC_IESR_I12_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I11_MASK (0x00000800u)
#define CSL_EDMA3CC_IESR_I11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_IESR_I11_RESETVAL (0x00000000u)
/*----I11 Tokens----*/
#define CSL_EDMA3CC_IESR_I11_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I10_MASK (0x00000400u)
#define CSL_EDMA3CC_IESR_I10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_IESR_I10_RESETVAL (0x00000000u)
/*----I10 Tokens----*/
#define CSL_EDMA3CC_IESR_I10_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I9_MASK (0x00000200u)
#define CSL_EDMA3CC_IESR_I9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_IESR_I9_RESETVAL (0x00000000u)
/*----I9 Tokens----*/
#define CSL_EDMA3CC_IESR_I9_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I8_MASK (0x00000100u)
#define CSL_EDMA3CC_IESR_I8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_IESR_I8_RESETVAL (0x00000000u)
/*----I8 Tokens----*/
#define CSL_EDMA3CC_IESR_I8_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I7_MASK (0x00000080u)
#define CSL_EDMA3CC_IESR_I7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_IESR_I7_RESETVAL (0x00000000u)
/*----I7 Tokens----*/
#define CSL_EDMA3CC_IESR_I7_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I6_MASK (0x00000040u)
#define CSL_EDMA3CC_IESR_I6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_IESR_I6_RESETVAL (0x00000000u)
/*----I6 Tokens----*/
#define CSL_EDMA3CC_IESR_I6_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I5_MASK (0x00000020u)
#define CSL_EDMA3CC_IESR_I5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_IESR_I5_RESETVAL (0x00000000u)
/*----I5 Tokens----*/
#define CSL_EDMA3CC_IESR_I5_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I4_MASK (0x00000010u)
#define CSL_EDMA3CC_IESR_I4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_IESR_I4_RESETVAL (0x00000000u)
/*----I4 Tokens----*/
#define CSL_EDMA3CC_IESR_I4_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I3_MASK (0x00000008u)
#define CSL_EDMA3CC_IESR_I3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_IESR_I3_RESETVAL (0x00000000u)
/*----I3 Tokens----*/
#define CSL_EDMA3CC_IESR_I3_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I2_MASK (0x00000004u)
#define CSL_EDMA3CC_IESR_I2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_IESR_I2_RESETVAL (0x00000000u)
/*----I2 Tokens----*/
#define CSL_EDMA3CC_IESR_I2_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I1_MASK (0x00000002u)
#define CSL_EDMA3CC_IESR_I1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_IESR_I1_RESETVAL (0x00000000u)
/*----I1 Tokens----*/
#define CSL_EDMA3CC_IESR_I1_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_I0_MASK (0x00000001u)
#define CSL_EDMA3CC_IESR_I0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IESR_I0_RESETVAL (0x00000000u)
/*----I0 Tokens----*/
#define CSL_EDMA3CC_IESR_I0_SET (0x00000001u)

#define CSL_EDMA3CC_IESR_RESETVAL (0x00000000u)

/* IPR */

#define CSL_EDMA3CC_IPR_I31_MASK (0x80000000u)
#define CSL_EDMA3CC_IPR_I31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_IPR_I31_RESETVAL (0x00000000u)
/*----I31 Tokens----*/
#define CSL_EDMA3CC_IPR_I31_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I31_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I30_MASK (0x40000000u)
#define CSL_EDMA3CC_IPR_I30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_IPR_I30_RESETVAL (0x00000000u)
/*----I30 Tokens----*/
#define CSL_EDMA3CC_IPR_I30_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I30_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I29_MASK (0x20000000u)
#define CSL_EDMA3CC_IPR_I29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_IPR_I29_RESETVAL (0x00000000u)
/*----I29 Tokens----*/
#define CSL_EDMA3CC_IPR_I29_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I29_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I28_MASK (0x10000000u)
#define CSL_EDMA3CC_IPR_I28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_IPR_I28_RESETVAL (0x00000000u)
/*----I28 Tokens----*/
#define CSL_EDMA3CC_IPR_I28_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I28_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I27_MASK (0x08000000u)
#define CSL_EDMA3CC_IPR_I27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_IPR_I27_RESETVAL (0x00000000u)
/*----I27 Tokens----*/
#define CSL_EDMA3CC_IPR_I27_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I27_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I26_MASK (0x04000000u)
#define CSL_EDMA3CC_IPR_I26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_IPR_I26_RESETVAL (0x00000000u)
/*----I26 Tokens----*/
#define CSL_EDMA3CC_IPR_I26_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I26_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I25_MASK (0x02000000u)
#define CSL_EDMA3CC_IPR_I25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_IPR_I25_RESETVAL (0x00000000u)
/*----I25 Tokens----*/
#define CSL_EDMA3CC_IPR_I25_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I25_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I24_MASK (0x01000000u)
#define CSL_EDMA3CC_IPR_I24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_IPR_I24_RESETVAL (0x00000000u)
/*----I24 Tokens----*/
#define CSL_EDMA3CC_IPR_I24_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I24_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I23_MASK (0x00800000u)
#define CSL_EDMA3CC_IPR_I23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_IPR_I23_RESETVAL (0x00000000u)
/*----I23 Tokens----*/
#define CSL_EDMA3CC_IPR_I23_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I23_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I22_MASK (0x00400000u)
#define CSL_EDMA3CC_IPR_I22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_IPR_I22_RESETVAL (0x00000000u)
/*----I22 Tokens----*/
#define CSL_EDMA3CC_IPR_I22_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I22_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I21_MASK (0x00200000u)
#define CSL_EDMA3CC_IPR_I21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_IPR_I21_RESETVAL (0x00000000u)
/*----I21 Tokens----*/
#define CSL_EDMA3CC_IPR_I21_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I21_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I20_MASK (0x00100000u)
#define CSL_EDMA3CC_IPR_I20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_IPR_I20_RESETVAL (0x00000000u)
/*----I20 Tokens----*/
#define CSL_EDMA3CC_IPR_I20_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I20_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I19_MASK (0x00080000u)
#define CSL_EDMA3CC_IPR_I19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_IPR_I19_RESETVAL (0x00000000u)
/*----I19 Tokens----*/
#define CSL_EDMA3CC_IPR_I19_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I19_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I18_MASK (0x00040000u)
#define CSL_EDMA3CC_IPR_I18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_IPR_I18_RESETVAL (0x00000000u)
/*----I18 Tokens----*/
#define CSL_EDMA3CC_IPR_I18_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I18_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I17_MASK (0x00020000u)
#define CSL_EDMA3CC_IPR_I17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_IPR_I17_RESETVAL (0x00000000u)
/*----I17 Tokens----*/
#define CSL_EDMA3CC_IPR_I17_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I17_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I16_MASK (0x00010000u)
#define CSL_EDMA3CC_IPR_I16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_IPR_I16_RESETVAL (0x00000000u)
/*----I16 Tokens----*/
#define CSL_EDMA3CC_IPR_I16_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I16_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I15_MASK (0x00008000u)
#define CSL_EDMA3CC_IPR_I15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_IPR_I15_RESETVAL (0x00000000u)
/*----I15 Tokens----*/
#define CSL_EDMA3CC_IPR_I15_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I15_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I14_MASK (0x00004000u)
#define CSL_EDMA3CC_IPR_I14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_IPR_I14_RESETVAL (0x00000000u)
/*----I14 Tokens----*/
#define CSL_EDMA3CC_IPR_I14_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I14_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I13_MASK (0x00002000u)
#define CSL_EDMA3CC_IPR_I13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_IPR_I13_RESETVAL (0x00000000u)
/*----I13 Tokens----*/
#define CSL_EDMA3CC_IPR_I13_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I13_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I12_MASK (0x00001000u)
#define CSL_EDMA3CC_IPR_I12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_IPR_I12_RESETVAL (0x00000000u)
/*----I12 Tokens----*/
#define CSL_EDMA3CC_IPR_I12_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I12_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I11_MASK (0x00000800u)
#define CSL_EDMA3CC_IPR_I11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_IPR_I11_RESETVAL (0x00000000u)
/*----I11 Tokens----*/
#define CSL_EDMA3CC_IPR_I11_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I11_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I10_MASK (0x00000400u)
#define CSL_EDMA3CC_IPR_I10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_IPR_I10_RESETVAL (0x00000000u)
/*----I10 Tokens----*/
#define CSL_EDMA3CC_IPR_I10_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I10_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I9_MASK (0x00000200u)
#define CSL_EDMA3CC_IPR_I9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_IPR_I9_RESETVAL (0x00000000u)
/*----I9 Tokens----*/
#define CSL_EDMA3CC_IPR_I9_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I9_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I8_MASK (0x00000100u)
#define CSL_EDMA3CC_IPR_I8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_IPR_I8_RESETVAL (0x00000000u)
/*----I8 Tokens----*/
#define CSL_EDMA3CC_IPR_I8_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I8_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I7_MASK (0x00000080u)
#define CSL_EDMA3CC_IPR_I7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_IPR_I7_RESETVAL (0x00000000u)
/*----I7 Tokens----*/
#define CSL_EDMA3CC_IPR_I7_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I7_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I6_MASK (0x00000040u)
#define CSL_EDMA3CC_IPR_I6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_IPR_I6_RESETVAL (0x00000000u)
/*----I6 Tokens----*/
#define CSL_EDMA3CC_IPR_I6_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I6_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I5_MASK (0x00000020u)
#define CSL_EDMA3CC_IPR_I5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_IPR_I5_RESETVAL (0x00000000u)
/*----I5 Tokens----*/
#define CSL_EDMA3CC_IPR_I5_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I5_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I4_MASK (0x00000010u)
#define CSL_EDMA3CC_IPR_I4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_IPR_I4_RESETVAL (0x00000000u)
/*----I4 Tokens----*/
#define CSL_EDMA3CC_IPR_I4_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I4_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I3_MASK (0x00000008u)
#define CSL_EDMA3CC_IPR_I3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_IPR_I3_RESETVAL (0x00000000u)
/*----I3 Tokens----*/
#define CSL_EDMA3CC_IPR_I3_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I3_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I2_MASK (0x00000004u)
#define CSL_EDMA3CC_IPR_I2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_IPR_I2_RESETVAL (0x00000000u)
/*----I2 Tokens----*/
#define CSL_EDMA3CC_IPR_I2_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I2_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I1_MASK (0x00000002u)
#define CSL_EDMA3CC_IPR_I1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_IPR_I1_RESETVAL (0x00000000u)
/*----I1 Tokens----*/
#define CSL_EDMA3CC_IPR_I1_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I1_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_I0_MASK (0x00000001u)
#define CSL_EDMA3CC_IPR_I0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IPR_I0_RESETVAL (0x00000000u)
/*----I0 Tokens----*/
#define CSL_EDMA3CC_IPR_I0_NO (0x00000000u)
#define CSL_EDMA3CC_IPR_I0_YES (0x00000001u)

#define CSL_EDMA3CC_IPR_RESETVAL (0x00000000u)

/* ICR */

#define CSL_EDMA3CC_ICR_I31_MASK (0x80000000u)
#define CSL_EDMA3CC_ICR_I31_SHIFT (0x0000001Fu)
#define CSL_EDMA3CC_ICR_I31_RESETVAL (0x00000000u)
/*----I31 Tokens----*/
#define CSL_EDMA3CC_ICR_I31_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I30_MASK (0x40000000u)
#define CSL_EDMA3CC_ICR_I30_SHIFT (0x0000001Eu)
#define CSL_EDMA3CC_ICR_I30_RESETVAL (0x00000000u)
/*----I30 Tokens----*/
#define CSL_EDMA3CC_ICR_I30_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I29_MASK (0x20000000u)
#define CSL_EDMA3CC_ICR_I29_SHIFT (0x0000001Du)
#define CSL_EDMA3CC_ICR_I29_RESETVAL (0x00000000u)
/*----I29 Tokens----*/
#define CSL_EDMA3CC_ICR_I29_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I28_MASK (0x10000000u)
#define CSL_EDMA3CC_ICR_I28_SHIFT (0x0000001Cu)
#define CSL_EDMA3CC_ICR_I28_RESETVAL (0x00000000u)
/*----I28 Tokens----*/
#define CSL_EDMA3CC_ICR_I28_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I27_MASK (0x08000000u)
#define CSL_EDMA3CC_ICR_I27_SHIFT (0x0000001Bu)
#define CSL_EDMA3CC_ICR_I27_RESETVAL (0x00000000u)
/*----I27 Tokens----*/
#define CSL_EDMA3CC_ICR_I27_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I26_MASK (0x04000000u)
#define CSL_EDMA3CC_ICR_I26_SHIFT (0x0000001Au)
#define CSL_EDMA3CC_ICR_I26_RESETVAL (0x00000000u)
/*----I26 Tokens----*/
#define CSL_EDMA3CC_ICR_I26_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I25_MASK (0x02000000u)
#define CSL_EDMA3CC_ICR_I25_SHIFT (0x00000019u)
#define CSL_EDMA3CC_ICR_I25_RESETVAL (0x00000000u)
/*----I25 Tokens----*/
#define CSL_EDMA3CC_ICR_I25_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I24_MASK (0x01000000u)
#define CSL_EDMA3CC_ICR_I24_SHIFT (0x00000018u)
#define CSL_EDMA3CC_ICR_I24_RESETVAL (0x00000000u)
/*----I24 Tokens----*/
#define CSL_EDMA3CC_ICR_I24_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I23_MASK (0x00800000u)
#define CSL_EDMA3CC_ICR_I23_SHIFT (0x00000017u)
#define CSL_EDMA3CC_ICR_I23_RESETVAL (0x00000000u)
/*----I23 Tokens----*/
#define CSL_EDMA3CC_ICR_I23_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I22_MASK (0x00400000u)
#define CSL_EDMA3CC_ICR_I22_SHIFT (0x00000016u)
#define CSL_EDMA3CC_ICR_I22_RESETVAL (0x00000000u)
/*----I22 Tokens----*/
#define CSL_EDMA3CC_ICR_I22_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I21_MASK (0x00200000u)
#define CSL_EDMA3CC_ICR_I21_SHIFT (0x00000015u)
#define CSL_EDMA3CC_ICR_I21_RESETVAL (0x00000000u)
/*----I21 Tokens----*/
#define CSL_EDMA3CC_ICR_I21_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I20_MASK (0x00100000u)
#define CSL_EDMA3CC_ICR_I20_SHIFT (0x00000014u)
#define CSL_EDMA3CC_ICR_I20_RESETVAL (0x00000000u)
/*----I20 Tokens----*/
#define CSL_EDMA3CC_ICR_I20_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I19_MASK (0x00080000u)
#define CSL_EDMA3CC_ICR_I19_SHIFT (0x00000013u)
#define CSL_EDMA3CC_ICR_I19_RESETVAL (0x00000000u)
/*----I19 Tokens----*/
#define CSL_EDMA3CC_ICR_I19_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I18_MASK (0x00040000u)
#define CSL_EDMA3CC_ICR_I18_SHIFT (0x00000012u)
#define CSL_EDMA3CC_ICR_I18_RESETVAL (0x00000000u)
/*----I18 Tokens----*/
#define CSL_EDMA3CC_ICR_I18_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I17_MASK (0x00020000u)
#define CSL_EDMA3CC_ICR_I17_SHIFT (0x00000011u)
#define CSL_EDMA3CC_ICR_I17_RESETVAL (0x00000000u)
/*----I17 Tokens----*/
#define CSL_EDMA3CC_ICR_I17_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I16_MASK (0x00010000u)
#define CSL_EDMA3CC_ICR_I16_SHIFT (0x00000010u)
#define CSL_EDMA3CC_ICR_I16_RESETVAL (0x00000000u)
/*----I16 Tokens----*/
#define CSL_EDMA3CC_ICR_I16_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I15_MASK (0x00008000u)
#define CSL_EDMA3CC_ICR_I15_SHIFT (0x0000000Fu)
#define CSL_EDMA3CC_ICR_I15_RESETVAL (0x00000000u)
/*----I15 Tokens----*/
#define CSL_EDMA3CC_ICR_I15_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I14_MASK (0x00004000u)
#define CSL_EDMA3CC_ICR_I14_SHIFT (0x0000000Eu)
#define CSL_EDMA3CC_ICR_I14_RESETVAL (0x00000000u)
/*----I14 Tokens----*/
#define CSL_EDMA3CC_ICR_I14_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I13_MASK (0x00002000u)
#define CSL_EDMA3CC_ICR_I13_SHIFT (0x0000000Du)
#define CSL_EDMA3CC_ICR_I13_RESETVAL (0x00000000u)
/*----I13 Tokens----*/
#define CSL_EDMA3CC_ICR_I13_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I12_MASK (0x00001000u)
#define CSL_EDMA3CC_ICR_I12_SHIFT (0x0000000Cu)
#define CSL_EDMA3CC_ICR_I12_RESETVAL (0x00000000u)
/*----I12 Tokens----*/
#define CSL_EDMA3CC_ICR_I12_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I11_MASK (0x00000800u)
#define CSL_EDMA3CC_ICR_I11_SHIFT (0x0000000Bu)
#define CSL_EDMA3CC_ICR_I11_RESETVAL (0x00000000u)
/*----I11 Tokens----*/
#define CSL_EDMA3CC_ICR_I11_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I10_MASK (0x00000400u)
#define CSL_EDMA3CC_ICR_I10_SHIFT (0x0000000Au)
#define CSL_EDMA3CC_ICR_I10_RESETVAL (0x00000000u)
/*----I10 Tokens----*/
#define CSL_EDMA3CC_ICR_I10_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I9_MASK (0x00000200u)
#define CSL_EDMA3CC_ICR_I9_SHIFT (0x00000009u)
#define CSL_EDMA3CC_ICR_I9_RESETVAL (0x00000000u)
/*----I9 Tokens----*/
#define CSL_EDMA3CC_ICR_I9_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I8_MASK (0x00000100u)
#define CSL_EDMA3CC_ICR_I8_SHIFT (0x00000008u)
#define CSL_EDMA3CC_ICR_I8_RESETVAL (0x00000000u)
/*----I8 Tokens----*/
#define CSL_EDMA3CC_ICR_I8_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I7_MASK (0x00000080u)
#define CSL_EDMA3CC_ICR_I7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_ICR_I7_RESETVAL (0x00000000u)
/*----I7 Tokens----*/
#define CSL_EDMA3CC_ICR_I7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I6_MASK (0x00000040u)
#define CSL_EDMA3CC_ICR_I6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_ICR_I6_RESETVAL (0x00000000u)
/*----I6 Tokens----*/
#define CSL_EDMA3CC_ICR_I6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I5_MASK (0x00000020u)
#define CSL_EDMA3CC_ICR_I5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_ICR_I5_RESETVAL (0x00000000u)
/*----I5 Tokens----*/
#define CSL_EDMA3CC_ICR_I5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I4_MASK (0x00000010u)
#define CSL_EDMA3CC_ICR_I4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_ICR_I4_RESETVAL (0x00000000u)
/*----I4 Tokens----*/
#define CSL_EDMA3CC_ICR_I4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I3_MASK (0x00000008u)
#define CSL_EDMA3CC_ICR_I3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_ICR_I3_RESETVAL (0x00000000u)
/*----I3 Tokens----*/
#define CSL_EDMA3CC_ICR_I3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I2_MASK (0x00000004u)
#define CSL_EDMA3CC_ICR_I2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_ICR_I2_RESETVAL (0x00000000u)
/*----I2 Tokens----*/
#define CSL_EDMA3CC_ICR_I2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I1_MASK (0x00000002u)
#define CSL_EDMA3CC_ICR_I1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_ICR_I1_RESETVAL (0x00000000u)
/*----I1 Tokens----*/
#define CSL_EDMA3CC_ICR_I1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_I0_MASK (0x00000001u)
#define CSL_EDMA3CC_ICR_I0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_ICR_I0_RESETVAL (0x00000000u)
/*----I0 Tokens----*/
#define CSL_EDMA3CC_ICR_I0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_ICR_RESETVAL (0x00000000u)

/* IEVAL */



#define CSL_EDMA3CC_IEVAL_EVAL_MASK (0x00000001u)
#define CSL_EDMA3CC_IEVAL_EVAL_SHIFT (0x00000000u)
#define CSL_EDMA3CC_IEVAL_EVAL_RESETVAL (0x00000000u)
/*----EVAL Tokens----*/
#define CSL_EDMA3CC_IEVAL_EVAL_SET (0x00000001u)
#define CSL_EDMA3CC_IEVAL_EVAL_EVAL (0x00000001u)

#define CSL_EDMA3CC_IEVAL_RESETVAL (0x00000000u)

/* QER */


#define CSL_EDMA3CC_QER_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QER_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QER_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QER_E7_SET (0x00000001u)

#define CSL_EDMA3CC_QER_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QER_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QER_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QER_E6_SET (0x00000001u)

#define CSL_EDMA3CC_QER_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QER_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QER_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QER_E5_SET (0x00000001u)

#define CSL_EDMA3CC_QER_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QER_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QER_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QER_E4_SET (0x00000001u)

#define CSL_EDMA3CC_QER_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QER_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QER_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QER_E3_SET (0x00000001u)

#define CSL_EDMA3CC_QER_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QER_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QER_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QER_E2_SET (0x00000001u)

#define CSL_EDMA3CC_QER_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QER_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QER_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QER_E1_SET (0x00000001u)

#define CSL_EDMA3CC_QER_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QER_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QER_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QER_E0_SET (0x00000001u)

#define CSL_EDMA3CC_QER_RESETVAL (0x00000000u)

/* QEER */


#define CSL_EDMA3CC_QEER_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QEER_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QEER_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QEER_E7_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E7_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QEER_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QEER_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QEER_E6_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E6_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QEER_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QEER_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QEER_E5_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E5_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QEER_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QEER_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QEER_E4_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E4_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QEER_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QEER_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QEER_E3_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E3_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QEER_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QEER_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QEER_E2_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E2_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QEER_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QEER_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QEER_E1_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E1_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QEER_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEER_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QEER_E0_DISABLE (0x00000000u)
#define CSL_EDMA3CC_QEER_E0_ENABLE (0x00000001u)

#define CSL_EDMA3CC_QEER_RESETVAL (0x00000000u)

/* QEECR */


#define CSL_EDMA3CC_QEECR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QEECR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QEECR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QEECR_E7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QEECR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QEECR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QEECR_E6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QEECR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QEECR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QEECR_E5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QEECR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QEECR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QEECR_E4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QEECR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QEECR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QEECR_E3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QEECR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QEECR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QEECR_E2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QEECR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QEECR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QEECR_E1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QEECR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEECR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QEECR_E0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QEECR_RESETVAL (0x00000000u)

/* QEESR */


#define CSL_EDMA3CC_QEESR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QEESR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QEESR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QEESR_E7_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QEESR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QEESR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QEESR_E6_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QEESR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QEESR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QEESR_E5_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QEESR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QEESR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QEESR_E4_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QEESR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QEESR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QEESR_E3_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QEESR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QEESR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QEESR_E2_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QEESR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QEESR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QEESR_E1_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QEESR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QEESR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QEESR_E0_SET (0x00000001u)

#define CSL_EDMA3CC_QEESR_RESETVAL (0x00000000u)

/* QSER */


#define CSL_EDMA3CC_QSER_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QSER_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QSER_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QSER_E7_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E7_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QSER_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QSER_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QSER_E6_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E6_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QSER_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QSER_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QSER_E5_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E5_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QSER_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QSER_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QSER_E4_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E4_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QSER_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QSER_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QSER_E3_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E3_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QSER_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QSER_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QSER_E2_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E2_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QSER_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QSER_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QSER_E1_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E1_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QSER_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QSER_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QSER_E0_NO (0x00000000u)
#define CSL_EDMA3CC_QSER_E0_YES (0x00000001u)

#define CSL_EDMA3CC_QSER_RESETVAL (0x00000000u)

/* QSECR */


#define CSL_EDMA3CC_QSECR_E7_MASK (0x00000080u)
#define CSL_EDMA3CC_QSECR_E7_SHIFT (0x00000007u)
#define CSL_EDMA3CC_QSECR_E7_RESETVAL (0x00000000u)
/*----E7 Tokens----*/
#define CSL_EDMA3CC_QSECR_E7_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_E6_MASK (0x00000040u)
#define CSL_EDMA3CC_QSECR_E6_SHIFT (0x00000006u)
#define CSL_EDMA3CC_QSECR_E6_RESETVAL (0x00000000u)
/*----E6 Tokens----*/
#define CSL_EDMA3CC_QSECR_E6_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_E5_MASK (0x00000020u)
#define CSL_EDMA3CC_QSECR_E5_SHIFT (0x00000005u)
#define CSL_EDMA3CC_QSECR_E5_RESETVAL (0x00000000u)
/*----E5 Tokens----*/
#define CSL_EDMA3CC_QSECR_E5_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_E4_MASK (0x00000010u)
#define CSL_EDMA3CC_QSECR_E4_SHIFT (0x00000004u)
#define CSL_EDMA3CC_QSECR_E4_RESETVAL (0x00000000u)
/*----E4 Tokens----*/
#define CSL_EDMA3CC_QSECR_E4_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_E3_MASK (0x00000008u)
#define CSL_EDMA3CC_QSECR_E3_SHIFT (0x00000003u)
#define CSL_EDMA3CC_QSECR_E3_RESETVAL (0x00000000u)
/*----E3 Tokens----*/
#define CSL_EDMA3CC_QSECR_E3_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_E2_MASK (0x00000004u)
#define CSL_EDMA3CC_QSECR_E2_SHIFT (0x00000002u)
#define CSL_EDMA3CC_QSECR_E2_RESETVAL (0x00000000u)
/*----E2 Tokens----*/
#define CSL_EDMA3CC_QSECR_E2_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_E1_MASK (0x00000002u)
#define CSL_EDMA3CC_QSECR_E1_SHIFT (0x00000001u)
#define CSL_EDMA3CC_QSECR_E1_RESETVAL (0x00000000u)
/*----E1 Tokens----*/
#define CSL_EDMA3CC_QSECR_E1_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_E0_MASK (0x00000001u)
#define CSL_EDMA3CC_QSECR_E0_SHIFT (0x00000000u)
#define CSL_EDMA3CC_QSECR_E0_RESETVAL (0x00000000u)
/*----E0 Tokens----*/
#define CSL_EDMA3CC_QSECR_E0_CLEAR (0x00000001u)

#define CSL_EDMA3CC_QSECR_RESETVAL (0x00000000u)

#ifdef __cplusplus
}
#endif

#endif

