/*
 * cslr_usb_otg.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/

#ifndef _CSLR_USB_OTG_H_
#define _CSLR_USB_OTG_H_

#include <ti/pspiom/cslr/cslr.h>
#include <ti/pspiom/cslr/tistdtypes.h>

/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure for GENRNDISSZ
\**************************************************************************/
typedef struct  {
    volatile Uint32 SIZE;
} CSL_Usb_otgGenrndisszRegs;

/**************************************************************************\
* Register Overlay Structure for EPTRG
\**************************************************************************/
typedef struct  {
    volatile Uint8 TXFUNCADDR;
    volatile Uint8 RSVD0;
    volatile Uint8 TXHUBADDR;
    volatile Uint8 TXHUBPORT;
    volatile Uint8 RXFUNCADDR;
    volatile Uint8 RSVD1;
    volatile Uint8 RXHUBADDR;
    volatile Uint8 RXHUBPORT;
} CSL_Usb_otgEptrgRegs;

/**************************************************************************\
* Register Overlay Structure for EPCSR
\**************************************************************************/
typedef struct  {
    volatile Uint16 TXMAXP;
    union {
        volatile Uint16 PERI_CSR0;
      volatile Uint16 HOST_CSR0;
      volatile Uint16 PERI_TXCSR;
      volatile Uint16 HOST_TXCSR;
    } TXCSR;
    volatile Uint16 RXMAXP;
    union {
      volatile Uint16 PERI_RXCSR;
      volatile Uint16 HOST_RXCSR;
    } RXCSR;
    union {
      volatile Uint16 COUNT0;
      volatile Uint16 RXCOUNT;
    } COUNT;
    union {
      volatile Uint8 HOST_TYPE0;
      volatile Uint8 HOST_TXTYPE;
    } TXTYPE;
    union {
      volatile Uint8 HOST_NAKLIMIT0;
      volatile Uint8 HOST_TXINTERVAL;
    } LIMIT_INTERVAL;
    volatile Uint8 HOST_RXTYPE;
    volatile Uint8 HOST_RXINTERVAL;
    volatile Uint8 RSVD0;
    volatile Uint8 CONFIGDATA;
} CSL_Usb_otgEpcsrRegs;

/**************************************************************************\
* Register Overlay Structure for RQPKTCOUNT
\**************************************************************************/
typedef struct  {
    volatile Uint16 RQPKTCOUNT;
} CSL_Usb_otgRqpktcountRegs;

/**************************************************************************\
* Register Overlay Structure for DMA_GLOBAL
\**************************************************************************/
typedef struct  {
    volatile Uint32 DMAREVID;
    volatile Uint32 TDFDQ;
    volatile Uint32 DMAEMU;
    volatile Uint8 RSVD9[20];
} CSL_Usb_otgDma_globalRegs;

/**************************************************************************\
* Register Overlay Structure for DMA_CTRL
\**************************************************************************/
typedef struct  {
    volatile Uint32 TXGCR;
    volatile Uint8 RSVD0[4];
    volatile Uint32 RXGCR;
    volatile Uint32 RXHPCRA;
    volatile Uint32 RXHPCRB;
    volatile Uint8 RSVD11[12];
} CSL_Usb_otgDma_ctrlRegs;

/**************************************************************************\
* Register Overlay Structure for DMA_SCHED
\**************************************************************************/
typedef struct  {
    volatile Uint32 DMA_SCHED_CTRL;
    volatile Uint8 RSVD0[2044];
    volatile Uint32 ENTRY[64];
    volatile Uint8 RSVD13[1792];
} CSL_Usb_otgDma_schedRegs;

/**************************************************************************\
* Register Overlay Structure for QMGR
\**************************************************************************/
typedef struct  {
    volatile Uint32 QMGRREVID;
    volatile Uint8 RSVD0[4];
    volatile Uint32 DIVERSION;
    volatile Uint8 RSVD1[20];
    volatile Uint32 FDBSC0;
    volatile Uint32 FDBSC1;
    volatile Uint32 FDBSC2;
    volatile Uint32 FDBSC3;
    volatile Uint8 RSVD2[80];
    volatile Uint32 LRAM0BASE;
    volatile Uint32 LRAM0SIZE;
    volatile Uint32 LRAM1BASE;
    volatile Uint8 RSVD3[4];
    volatile Uint32 PEND0;
    volatile Uint32 PEND1;
    volatile Uint32 PEND2;
    volatile Uint8 RSVD15[3940];
} CSL_Usb_otgQmgrRegs;

/**************************************************************************\
* Register Overlay Structure for QMEMREGION
\**************************************************************************/
typedef struct  {
    volatile Uint32 QMEMRBASE;
    volatile Uint32 QMEMRCTRL;
    volatile Uint8 RSVD17[8];
} CSL_Usb_otgQmemregionRegs;

/**************************************************************************\
* Register Overlay Structure for QCTRL
\**************************************************************************/
typedef struct  {
    volatile Uint8 RSVD0[12];
    volatile Uint32 CTRLD;
} CSL_Usb_otgQctrlRegs;

/**************************************************************************\
* Register Overlay Structure for QSTAT
\**************************************************************************/
typedef struct  {
    volatile Uint32 QSTATA;
    volatile Uint32 QSTATB;
    volatile Uint32 QSTATC;
    volatile Uint8 RSVD19[4];
} CSL_Usb_otgQstatRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 REVID;
    volatile Uint32 CTRLR;
    volatile Uint32 STATR;
    volatile Uint32 EMUR;
    volatile Uint32 MODE;
    volatile Uint32 AUTOREQ;
    volatile Uint32 SRPFIXTIME;
    volatile Uint32 TEARDOWN;
    volatile Uint32 INTSRCR;
    volatile Uint32 INTSETR;
    volatile Uint32 INTCLRR;
    volatile Uint32 INTMSKR;
    volatile Uint32 INTMSKSETR;
    volatile Uint32 INTMSKCLRR;
    volatile Uint32 INTMASKEDR;
    volatile Uint32 EOIR;
    volatile Uint32 INTVECTR;
    volatile Uint8 RSVD0[60];
    CSL_Usb_otgGenrndisszRegs GENRNDISSZ[4];
    volatile Uint8 RSVD1[880];
    volatile Uint8 FADDR;
    volatile Uint8 POWER;
    volatile Uint16 INTRTX;
    volatile Uint16 INTRRX;
    volatile Uint16 INTRTXE;
    volatile Uint16 INTRRXE;
    volatile Uint8 INTRUSB;
    volatile Uint8 INTRUSBE;
    volatile Uint16 FRAME;
    volatile Uint8 INDEX;
    volatile Uint8 TESTMODE;
    volatile Uint16 TXMAXP;
    union {
      volatile Uint16 PERI_CSR0;
      volatile Uint16 HOST_CSR0;
      volatile Uint16 PERI_TXCSR;
      volatile Uint16 HOST_TXCSR;
    } TXCSR;
    volatile Uint16 RXMAXP;
    union {
      volatile Uint16 PERI_RXCSR;
      volatile Uint16 HOST_RXCSR;
    } RXCSR;
    union {
      volatile Uint16 COUNT0;
      volatile Uint16 RXCOUNT;
    } COUNT;
    union {
      volatile Uint8 HOST_TYPE0;
      volatile Uint8 HOST_TXTYPE;
    } TXTYPE;
    union {
      volatile Uint8 HOST_NAKLIMIT0;
      volatile Uint8 HOST_TXINTERVAL;
    } LIMIT_INTERVAL;
    volatile Uint8 HOST_RXTYPE;
    volatile Uint8 HOST_RXINTERVAL;
    volatile Uint8 RSVD2;
    volatile Uint8 CONFIGDATA;
    volatile Uint32 FIFO0;
    volatile Uint32 FIFO1;
    volatile Uint32 FIFO2;
    volatile Uint32 FIFO3;
    volatile Uint32 FIFO4;
    volatile Uint8 RSVD3[44];
    volatile Uint8 DEVCTL;
    volatile Uint8 RSVD4;
    volatile Uint8 TXFIFOSZ;
    volatile Uint8 RXFIFOSZ;
    volatile Uint16 TXFIFOADDR;
    volatile Uint16 RXFIFOADDR;
    volatile Uint8 RSVD5[4];
    volatile Uint16 HWVERS;
    volatile Uint8 RSVD6[18];
    CSL_Usb_otgEptrgRegs EPTRG[5];
    volatile Uint8 RSVD7[88];
    CSL_Usb_otgEpcsrRegs EPCSR[5];
    volatile Uint8 RSVD8[432];
    CSL_Usb_otgRqpktcountRegs RQPKTCOUNT[4];
    volatile Uint8 RSVD10[2296];
    CSL_Usb_otgDma_globalRegs DMA_GLOBAL;
    volatile Uint8 RSVD12[2016];
    CSL_Usb_otgDma_ctrlRegs DMA_CTRL[4];
    volatile Uint8 RSVD14[1920];
    CSL_Usb_otgDma_schedRegs DMA_SCHED;
    volatile Uint8 RSVD16[4096];
    CSL_Usb_otgQmgrRegs QMGR;
    CSL_Usb_otgQmemregionRegs QMEMREGION[16];
    volatile Uint8 RSVD18[3840];
    CSL_Usb_otgQctrlRegs QCTRL[64];
    volatile Uint8 RSVD20[1024];
    CSL_Usb_otgQstatRegs QSTAT[64];
} CSL_Usb_otgRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef CSL_Usb_otgRegs *CSL_Usb_otgRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* SIZE */

#define CSL_USB_OTG_SIZE_RSV_MASK        (0xFFFE0000u)
#define CSL_USB_OTG_SIZE_RSV_SHIFT       (0x00000011u)
#define CSL_USB_OTG_SIZE_RSV_RESETVAL    (0x00000000u)

#define CSL_USB_OTG_SIZE_SIZE_MASK       (0x0001FFFFu)
#define CSL_USB_OTG_SIZE_SIZE_SHIFT      (0x00000000u)
#define CSL_USB_OTG_SIZE_SIZE_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_SIZE_RESETVAL        (0x00000000u)

/* TXFUNCADDR */

#define CSL_USB_OTG_TXFUNCADDR_FUNCADDR_MASK (0x7Fu)
#define CSL_USB_OTG_TXFUNCADDR_FUNCADDR_SHIFT (0x00u)
#define CSL_USB_OTG_TXFUNCADDR_FUNCADDR_RESETVAL (0x00u)

#define CSL_USB_OTG_TXFUNCADDR_RESETVAL  (0x00u)

/* TXHUBADDR */

#define CSL_USB_OTG_TXHUBADDR_MULT_TRANS_MASK (0x80u)
#define CSL_USB_OTG_TXHUBADDR_MULT_TRANS_SHIFT (0x07u)
#define CSL_USB_OTG_TXHUBADDR_MULT_TRANS_RESETVAL (0x00u)

#define CSL_USB_OTG_TXHUBADDR_HUBADDR_MASK (0x7Fu)
#define CSL_USB_OTG_TXHUBADDR_HUBADDR_SHIFT (0x00u)
#define CSL_USB_OTG_TXHUBADDR_HUBADDR_RESETVAL (0x00u)

#define CSL_USB_OTG_TXHUBADDR_RESETVAL   (0x00u)

/* TXHUBPORT */

#define CSL_USB_OTG_TXHUBPORT_HUBPORT_MASK (0x7Fu)
#define CSL_USB_OTG_TXHUBPORT_HUBPORT_SHIFT (0x00u)
#define CSL_USB_OTG_TXHUBPORT_HUBPORT_RESETVAL (0x00u)

#define CSL_USB_OTG_TXHUBPORT_RESETVAL   (0x00u)

/* RXFUNCADDR */

#define CSL_USB_OTG_RXFUNCADDR_FUNCADDR_MASK (0x7Fu)
#define CSL_USB_OTG_RXFUNCADDR_FUNCADDR_SHIFT (0x00u)
#define CSL_USB_OTG_RXFUNCADDR_FUNCADDR_RESETVAL (0x00u)

#define CSL_USB_OTG_RXFUNCADDR_RESETVAL  (0x00u)

/* RXHUBADDR */

#define CSL_USB_OTG_RXHUBADDR_MULT_TRANS_MASK (0x80u)
#define CSL_USB_OTG_RXHUBADDR_MULT_TRANS_SHIFT (0x07u)
#define CSL_USB_OTG_RXHUBADDR_MULT_TRANS_RESETVAL (0x00u)

#define CSL_USB_OTG_RXHUBADDR_HUBADDR_MASK (0x7Fu)
#define CSL_USB_OTG_RXHUBADDR_HUBADDR_SHIFT (0x00u)
#define CSL_USB_OTG_RXHUBADDR_HUBADDR_RESETVAL (0x00u)

#define CSL_USB_OTG_RXHUBADDR_RESETVAL   (0x00u)

/* RXHUBPORT */

#define CSL_USB_OTG_RXHUBPORT_HUBPORT_MASK (0x7Fu)
#define CSL_USB_OTG_RXHUBPORT_HUBPORT_SHIFT (0x00u)
#define CSL_USB_OTG_RXHUBPORT_HUBPORT_RESETVAL (0x00u)

#define CSL_USB_OTG_RXHUBPORT_RESETVAL   (0x00u)

/* TXMAXP */

#define CSL_USB_OTG_TXMAXP_RESETVAL      (0x0000u)

/* PERI_CSR0 */

#define CSL_USB_OTG_PERI_CSR0_RESETVAL   (0x0000u)

/* RXMAXP */

#define CSL_USB_OTG_RXMAXP_RESETVAL      (0x0000u)

/* PERI_RXCSR */

#define CSL_USB_OTG_PERI_RXCSR_RESETVAL  (0x0000u)

/* COUNT0 */

#define CSL_USB_OTG_COUNT0_RESETVAL      (0x0000u)

/* HOST_TYPE0 */

#define CSL_USB_OTG_HOST_TYPE0_RESETVAL  (0x00u)

/* HOST_NAKLIMIT0 */

#define CSL_USB_OTG_HOST_NAKLIMIT0_RESETVAL (0x00u)

/* HOST_RXTYPE */

#define CSL_USB_OTG_HOST_RXTYPE_RESETVAL (0x00u)

/* HOST_RXINTERVAL */

#define CSL_USB_OTG_HOST_RXINTERVAL_RESETVAL (0x00u)

/* CONFIGDATA */

#define CSL_USB_OTG_CONFIGDATA_RESETVAL  (0x00u)

/* RQPKTCOUNT */

#define CSL_USB_OTG_RQPKTCOUNT_RESETVAL  (0x0000u)

/* DMAREVID */

#define CSL_USB_OTG_DMAREVID_REV_MASK    (0xFFFFFFFFu)
#define CSL_USB_OTG_DMAREVID_REV_SHIFT   (0x00000000u)
#define CSL_USB_OTG_DMAREVID_REV_RESETVAL (0x00531900u)

#define CSL_USB_OTG_DMAREVID_RESETVAL    (0x00531900u)

/* TDFDQ */

#define CSL_USB_OTG_TDFDQ_TD_DESC_QMGR_MASK (0x00003000u)
#define CSL_USB_OTG_TDFDQ_TD_DESC_QMGR_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_TDFDQ_TD_DESC_QMGR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TDFDQ_TD_DESC_QNUM_MASK (0x00000FFFu)
#define CSL_USB_OTG_TDFDQ_TD_DESC_QNUM_SHIFT (0x00000000u)
#define CSL_USB_OTG_TDFDQ_TD_DESC_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TDFDQ_RESETVAL       (0x00000000u)

/* DMAEMU */

#define CSL_USB_OTG_DMAEMU_SOFT_MASK     (0x00000002u)
#define CSL_USB_OTG_DMAEMU_SOFT_SHIFT    (0x00000001u)
#define CSL_USB_OTG_DMAEMU_SOFT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_DMAEMU_FREE_MASK     (0x00000001u)
#define CSL_USB_OTG_DMAEMU_FREE_SHIFT    (0x00000000u)
#define CSL_USB_OTG_DMAEMU_FREE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_DMAEMU_RESETVAL      (0x00000000u)

/* TXGCR */

#define CSL_USB_OTG_TXGCR_TX_ENABLE_MASK (0x80000000u)
#define CSL_USB_OTG_TXGCR_TX_ENABLE_SHIFT (0x0000001Fu)
#define CSL_USB_OTG_TXGCR_TX_ENABLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TXGCR_TX_TEARDOWN_MASK (0x40000000u)
#define CSL_USB_OTG_TXGCR_TX_TEARDOWN_SHIFT (0x0000001Eu)
#define CSL_USB_OTG_TXGCR_TX_TEARDOWN_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TXGCR_RSV1_MASK      (0x3FFFC000u)
#define CSL_USB_OTG_TXGCR_RSV1_SHIFT     (0x0000000Eu)
#define CSL_USB_OTG_TXGCR_RSV1_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_TXGCR_TX_DEFAULT_QMGR_MASK (0x00003000u)
#define CSL_USB_OTG_TXGCR_TX_DEFAULT_QMGR_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_TXGCR_TX_DEFAULT_QMGR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TXGCR_TX_DEFAULT_QNUM_MASK (0x00000FFFu)
#define CSL_USB_OTG_TXGCR_TX_DEFAULT_QNUM_SHIFT (0x00000000u)
#define CSL_USB_OTG_TXGCR_TX_DEFAULT_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TXGCR_RESETVAL       (0x00000000u)

/* RXGCR */

#define CSL_USB_OTG_RXGCR_RX_ENABLE_MASK (0x80000000u)
#define CSL_USB_OTG_RXGCR_RX_ENABLE_SHIFT (0x0000001Fu)
#define CSL_USB_OTG_RXGCR_RX_ENABLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXGCR_RX_TEARDOWN_MASK (0x40000000u)
#define CSL_USB_OTG_RXGCR_RX_TEARDOWN_SHIFT (0x0000001Eu)
#define CSL_USB_OTG_RXGCR_RX_TEARDOWN_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXGCR_RSV1_MASK      (0x3E000000u)
#define CSL_USB_OTG_RXGCR_RSV1_SHIFT     (0x00000019u)
#define CSL_USB_OTG_RXGCR_RSV1_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_RXGCR_RX_ERROR_HANDLING_MASK (0x01000000u)
#define CSL_USB_OTG_RXGCR_RX_ERROR_HANDLING_SHIFT (0x00000018u)
#define CSL_USB_OTG_RXGCR_RX_ERROR_HANDLING_RESETVAL (0x00000000u)
/*----RX_ERROR_HANDLING Tokens----*/
#define CSL_USB_OTG_RXGCR_RX_ERROR_HANDLING_DROP (0x00000000u)
#define CSL_USB_OTG_RXGCR_RX_ERROR_HANDLING_RETRY (0x00000001u)

#define CSL_USB_OTG_RXGCR_RX_SOP_OFFSET_MASK (0x00FF0000u)
#define CSL_USB_OTG_RXGCR_RX_SOP_OFFSET_SHIFT (0x00000010u)
#define CSL_USB_OTG_RXGCR_RX_SOP_OFFSET_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXGCR_RX_DEFAULT_DESC_TYPE_MASK (0x0000C000u)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_DESC_TYPE_SHIFT (0x0000000Eu)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_DESC_TYPE_RESETVAL (0x00000000u)
/*----RX_DEFAULT_DESC_TYPE Tokens----*/
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_DESC_TYPE_EMBEDDED (0x00000000u)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_DESC_TYPE_HOST (0x00000001u)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_DESC_TYPE_MONOLITHIC (0x00000002u)

#define CSL_USB_OTG_RXGCR_RX_DEFAULT_RQ_QMGR_MASK (0x00003000u)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_RQ_QMGR_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_RQ_QMGR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXGCR_RX_DEFAULT_RQ_QNUM_MASK (0x00000FFFu)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_RQ_QNUM_SHIFT (0x00000000u)
#define CSL_USB_OTG_RXGCR_RX_DEFAULT_RQ_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXGCR_RESETVAL       (0x00000000u)

/* RXHPCRA */

#define CSL_USB_OTG_RXHPCRA_RSV1_MASK    (0xC0000000u)
#define CSL_USB_OTG_RXHPCRA_RSV1_SHIFT   (0x0000001Eu)
#define CSL_USB_OTG_RXHPCRA_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ1_QMGR_MASK (0x30000000u)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ1_QMGR_SHIFT (0x0000001Cu)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ1_QMGR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ1_QNUM_MASK (0x0FFF0000u)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ1_QNUM_SHIFT (0x00000010u)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ1_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRA_RSV2_MASK    (0x0000C000u)
#define CSL_USB_OTG_RXHPCRA_RSV2_SHIFT   (0x0000000Eu)
#define CSL_USB_OTG_RXHPCRA_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ0_QMGR_MASK (0x00003000u)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ0_QMGR_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ0_QMGR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ0_QNUM_MASK (0x00000FFFu)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ0_QNUM_SHIFT (0x00000000u)
#define CSL_USB_OTG_RXHPCRA_RX_HOST_FDQ0_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRA_RESETVAL     (0x00000000u)

/* RXHPCRB */

#define CSL_USB_OTG_RXHPCRB_RSV1_MASK    (0xC0000000u)
#define CSL_USB_OTG_RXHPCRB_RSV1_SHIFT   (0x0000001Eu)
#define CSL_USB_OTG_RXHPCRB_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ3_QMGR_MASK (0x30000000u)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ3_QMGR_SHIFT (0x0000001Cu)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ3_QMGR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ3_QNUM_MASK (0x0FFF0000u)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ3_QNUM_SHIFT (0x00000010u)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ3_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRB_RSV2_MASK    (0x0000C000u)
#define CSL_USB_OTG_RXHPCRB_RSV2_SHIFT   (0x0000000Eu)
#define CSL_USB_OTG_RXHPCRB_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ2_QMGR_MASK (0x00003000u)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ2_QMGR_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ2_QMGR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ2_QNUM_MASK (0x00000FFFu)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ2_QNUM_SHIFT (0x00000000u)
#define CSL_USB_OTG_RXHPCRB_RX_HOST_FDQ2_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_RXHPCRB_RESETVAL     (0x00000000u)

/* DMA_SCHED_CTRL */

#define CSL_USB_OTG_DMA_SCHED_CTRL_ENABLE_MASK (0x80000000u)
#define CSL_USB_OTG_DMA_SCHED_CTRL_ENABLE_SHIFT (0x0000001Fu)
#define CSL_USB_OTG_DMA_SCHED_CTRL_ENABLE_RESETVAL (0x00000000u)
/*----ENABLE Tokens----*/
#define CSL_USB_OTG_DMA_SCHED_CTRL_ENABLE_DISABLE (0x00000000u)
#define CSL_USB_OTG_DMA_SCHED_CTRL_ENABLE_ENABLE (0x00000001u)

#define CSL_USB_OTG_DMA_SCHED_CTRL_RSV1_MASK (0x7FFFFF00u)
#define CSL_USB_OTG_DMA_SCHED_CTRL_RSV1_SHIFT (0x00000008u)
#define CSL_USB_OTG_DMA_SCHED_CTRL_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_DMA_SCHED_CTRL_LAST_ENTRY_MASK (0x000000FFu)
#define CSL_USB_OTG_DMA_SCHED_CTRL_LAST_ENTRY_SHIFT (0x00000000u)
#define CSL_USB_OTG_DMA_SCHED_CTRL_LAST_ENTRY_RESETVAL (0x00000000u)

#define CSL_USB_OTG_DMA_SCHED_CTRL_RESETVAL (0x00000000u)

/* ENTRY */

#define CSL_USB_OTG_ENTRY_ENTRY3_RXTX_MASK (0x80000000u)
#define CSL_USB_OTG_ENTRY_ENTRY3_RXTX_SHIFT (0x0000001Fu)
#define CSL_USB_OTG_ENTRY_ENTRY3_RXTX_RESETVAL (0x00000000u)
/*----ENTRY3_RXTX Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY3_RXTX_TX (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY3_RXTX_RX (0x00000001u)

#define CSL_USB_OTG_ENTRY_ENTRY3_CHANNEL_MASK (0x0F000000u)
#define CSL_USB_OTG_ENTRY_ENTRY3_CHANNEL_SHIFT (0x00000018u)
#define CSL_USB_OTG_ENTRY_ENTRY3_CHANNEL_RESETVAL (0x00000000u)
/*----ENTRY3_CHANNEL Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY3_CHANNEL_CHAN0 (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY3_CHANNEL_CHAN1 (0x00000001u)
#define CSL_USB_OTG_ENTRY_ENTRY3_CHANNEL_CHAN2 (0x00000002u)
#define CSL_USB_OTG_ENTRY_ENTRY3_CHANNEL_CHAN3 (0x00000003u)

#define CSL_USB_OTG_ENTRY_ENTRY2_RXTX_MASK (0x00800000u)
#define CSL_USB_OTG_ENTRY_ENTRY2_RXTX_SHIFT (0x00000017u)
#define CSL_USB_OTG_ENTRY_ENTRY2_RXTX_RESETVAL (0x00000000u)
/*----ENTRY2_RXTX Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY2_RXTX_TX (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY2_RXTX_RX (0x00000001u)

#define CSL_USB_OTG_ENTRY_ENTRY2_CHANNEL_MASK (0x000F0000u)
#define CSL_USB_OTG_ENTRY_ENTRY2_CHANNEL_SHIFT (0x00000010u)
#define CSL_USB_OTG_ENTRY_ENTRY2_CHANNEL_RESETVAL (0x00000000u)
/*----ENTRY2_CHANNEL Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY2_CHANNEL_CHAN0 (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY2_CHANNEL_CHAN1 (0x00000001u)
#define CSL_USB_OTG_ENTRY_ENTRY2_CHANNEL_CHAN2 (0x00000002u)
#define CSL_USB_OTG_ENTRY_ENTRY2_CHANNEL_CHAN3 (0x00000003u)

#define CSL_USB_OTG_ENTRY_ENTRY1_RXTX_MASK (0x00008000u)
#define CSL_USB_OTG_ENTRY_ENTRY1_RXTX_SHIFT (0x0000000Fu)
#define CSL_USB_OTG_ENTRY_ENTRY1_RXTX_RESETVAL (0x00000000u)
/*----ENTRY1_RXTX Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY1_RXTX_TX (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY1_RXTX_RX (0x00000001u)

#define CSL_USB_OTG_ENTRY_ENTRY1_CHANNEL_MASK (0x00000F00u)
#define CSL_USB_OTG_ENTRY_ENTRY1_CHANNEL_SHIFT (0x00000008u)
#define CSL_USB_OTG_ENTRY_ENTRY1_CHANNEL_RESETVAL (0x00000000u)
/*----ENTRY1_CHANNEL Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY1_CHANNEL_CHAN0 (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY1_CHANNEL_CHAN1 (0x00000001u)
#define CSL_USB_OTG_ENTRY_ENTRY1_CHANNEL_CHAN2 (0x00000002u)
#define CSL_USB_OTG_ENTRY_ENTRY1_CHANNEL_CHAN3 (0x00000003u)

#define CSL_USB_OTG_ENTRY_ENTRY0_RXTX_MASK (0x00000080u)
#define CSL_USB_OTG_ENTRY_ENTRY0_RXTX_SHIFT (0x00000007u)
#define CSL_USB_OTG_ENTRY_ENTRY0_RXTX_RESETVAL (0x00000000u)
/*----ENTRY0_RXTX Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY0_RXTX_TX (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY0_RXTX_RX (0x00000001u)

#define CSL_USB_OTG_ENTRY_ENTRY0_CHANNEL_MASK (0x0000000Fu)
#define CSL_USB_OTG_ENTRY_ENTRY0_CHANNEL_SHIFT (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY0_CHANNEL_RESETVAL (0x00000000u)
/*----ENTRY0_CHANNEL Tokens----*/
#define CSL_USB_OTG_ENTRY_ENTRY0_CHANNEL_CHAN0 (0x00000000u)
#define CSL_USB_OTG_ENTRY_ENTRY0_CHANNEL_CHAN1 (0x00000001u)
#define CSL_USB_OTG_ENTRY_ENTRY0_CHANNEL_CHAN2 (0x00000002u)
#define CSL_USB_OTG_ENTRY_ENTRY0_CHANNEL_CHAN3 (0x00000003u)

#define CSL_USB_OTG_ENTRY_RESETVAL       (0x00000000u)

/* QMGRREVID */

#define CSL_USB_OTG_QMGRREVID_REV_MASK   (0xFFFFFFFFu)
#define CSL_USB_OTG_QMGRREVID_REV_SHIFT  (0x00000000u)
#define CSL_USB_OTG_QMGRREVID_REV_RESETVAL (0x00521200u)

#define CSL_USB_OTG_QMGRREVID_RESETVAL   (0x00521200u)

/* DIVERSION */

#define CSL_USB_OTG_DIVERSION_HEAD_TAIL_MASK (0x80000000u)
#define CSL_USB_OTG_DIVERSION_HEAD_TAIL_SHIFT (0x0000001Fu)
#define CSL_USB_OTG_DIVERSION_HEAD_TAIL_RESETVAL (0x00000000u)
/*----HEAD_TAIL Tokens----*/
#define CSL_USB_OTG_DIVERSION_HEAD_TAIL_TAILINS (0x00000000u)
#define CSL_USB_OTG_DIVERSION_HEAD_TAIL_HEADINS (0x00000001u)

#define CSL_USB_OTG_DIVERSION_RSV2_MASK  (0x40000000u)
#define CSL_USB_OTG_DIVERSION_RSV2_SHIFT (0x0000001Eu)
#define CSL_USB_OTG_DIVERSION_RSV2_RESETVAL (0x00000001u)

#define CSL_USB_OTG_DIVERSION_DEST_QNUM_MASK (0x3FFF0000u)
#define CSL_USB_OTG_DIVERSION_DEST_QNUM_SHIFT (0x00000010u)
#define CSL_USB_OTG_DIVERSION_DEST_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_DIVERSION_RSV1_MASK  (0x0000C000u)
#define CSL_USB_OTG_DIVERSION_RSV1_SHIFT (0x0000000Eu)
#define CSL_USB_OTG_DIVERSION_RSV1_RESETVAL (0x00000E83u)

#define CSL_USB_OTG_DIVERSION_SOURCE_QNUM_MASK (0x00003FFFu)
#define CSL_USB_OTG_DIVERSION_SOURCE_QNUM_SHIFT (0x00000000u)
#define CSL_USB_OTG_DIVERSION_SOURCE_QNUM_RESETVAL (0x00000000u)

#define CSL_USB_OTG_DIVERSION_RESETVAL   (0x43A0C000u)

/* FDBSC0 */

#define CSL_USB_OTG_FDBSC0_FDBQ3_STARVE_CNT_MASK (0xFF000000u)
#define CSL_USB_OTG_FDBSC0_FDBQ3_STARVE_CNT_SHIFT (0x00000018u)
#define CSL_USB_OTG_FDBSC0_FDBQ3_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC0_FDBQ2_STARVE_CNT_MASK (0x00FF0000u)
#define CSL_USB_OTG_FDBSC0_FDBQ2_STARVE_CNT_SHIFT (0x00000010u)
#define CSL_USB_OTG_FDBSC0_FDBQ2_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC0_FDBQ1_STARVE_CNT_MASK (0x0000FF00u)
#define CSL_USB_OTG_FDBSC0_FDBQ1_STARVE_CNT_SHIFT (0x00000008u)
#define CSL_USB_OTG_FDBSC0_FDBQ1_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC0_FDBQ0_STARVE_CNT_MASK (0x000000FFu)
#define CSL_USB_OTG_FDBSC0_FDBQ0_STARVE_CNT_SHIFT (0x00000000u)
#define CSL_USB_OTG_FDBSC0_FDBQ0_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC0_RESETVAL      (0x00000000u)

/* FDBSC1 */

#define CSL_USB_OTG_FDBSC1_FDBQ7_STARVE_CNT_MASK (0xFF000000u)
#define CSL_USB_OTG_FDBSC1_FDBQ7_STARVE_CNT_SHIFT (0x00000018u)
#define CSL_USB_OTG_FDBSC1_FDBQ7_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC1_FDBQ6_STARVE_CNT_MASK (0x00FF0000u)
#define CSL_USB_OTG_FDBSC1_FDBQ6_STARVE_CNT_SHIFT (0x00000010u)
#define CSL_USB_OTG_FDBSC1_FDBQ6_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC1_FDBQ5_STARVE_CNT_MASK (0x0000FF00u)
#define CSL_USB_OTG_FDBSC1_FDBQ5_STARVE_CNT_SHIFT (0x00000008u)
#define CSL_USB_OTG_FDBSC1_FDBQ5_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC1_FDBQ4_STARVE_CNT_MASK (0x000000FFu)
#define CSL_USB_OTG_FDBSC1_FDBQ4_STARVE_CNT_SHIFT (0x00000000u)
#define CSL_USB_OTG_FDBSC1_FDBQ4_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC1_RESETVAL      (0x00000000u)

/* FDBSC2 */

#define CSL_USB_OTG_FDBSC2_FDBQ11_STARVE_CNT_MASK (0xFF000000u)
#define CSL_USB_OTG_FDBSC2_FDBQ11_STARVE_CNT_SHIFT (0x00000018u)
#define CSL_USB_OTG_FDBSC2_FDBQ11_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC2_FDBQ10_STARVE_CNT_MASK (0x00FF0000u)
#define CSL_USB_OTG_FDBSC2_FDBQ10_STARVE_CNT_SHIFT (0x00000010u)
#define CSL_USB_OTG_FDBSC2_FDBQ10_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC2_FDBQ9_STARVE_CNT_MASK (0x0000FF00u)
#define CSL_USB_OTG_FDBSC2_FDBQ9_STARVE_CNT_SHIFT (0x00000008u)
#define CSL_USB_OTG_FDBSC2_FDBQ9_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC2_FDBQ8_STARVE_CNT_MASK (0x000000FFu)
#define CSL_USB_OTG_FDBSC2_FDBQ8_STARVE_CNT_SHIFT (0x00000000u)
#define CSL_USB_OTG_FDBSC2_FDBQ8_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC2_RESETVAL      (0x00000000u)

/* FDBSC3 */

#define CSL_USB_OTG_FDBSC3_FDBQ15_STARVE_CNT_MASK (0xFF000000u)
#define CSL_USB_OTG_FDBSC3_FDBQ15_STARVE_CNT_SHIFT (0x00000018u)
#define CSL_USB_OTG_FDBSC3_FDBQ15_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC3_FDBQ14_STARVE_CNT_MASK (0x00FF0000u)
#define CSL_USB_OTG_FDBSC3_FDBQ14_STARVE_CNT_SHIFT (0x00000010u)
#define CSL_USB_OTG_FDBSC3_FDBQ14_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC3_FDBQ13_STARVE_CNT_MASK (0x0000FF00u)
#define CSL_USB_OTG_FDBSC3_FDBQ13_STARVE_CNT_SHIFT (0x00000008u)
#define CSL_USB_OTG_FDBSC3_FDBQ13_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC3_FDBQ12_STARVE_CNT_MASK (0x000000FFu)
#define CSL_USB_OTG_FDBSC3_FDBQ12_STARVE_CNT_SHIFT (0x00000000u)
#define CSL_USB_OTG_FDBSC3_FDBQ12_STARVE_CNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_FDBSC3_RESETVAL      (0x00000000u)

/* LRAM0BASE */

#define CSL_USB_OTG_LRAM0BASE_REGION0_BASE_MASK (0xFFFFFFFFu)
#define CSL_USB_OTG_LRAM0BASE_REGION0_BASE_SHIFT (0x00000000u)
#define CSL_USB_OTG_LRAM0BASE_REGION0_BASE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_LRAM0BASE_RESETVAL   (0x00000000u)

/* LRAM0SIZE */

#define CSL_USB_OTG_LRAM0SIZE_RSV_MASK   (0xFFFFC000u)
#define CSL_USB_OTG_LRAM0SIZE_RSV_SHIFT  (0x0000000Eu)
#define CSL_USB_OTG_LRAM0SIZE_RSV_RESETVAL (0x00000000u)

#define CSL_USB_OTG_LRAM0SIZE_ENTRIES_MASK (0x00003FFFu)
#define CSL_USB_OTG_LRAM0SIZE_ENTRIES_SHIFT (0x00000000u)
#define CSL_USB_OTG_LRAM0SIZE_ENTRIES_RESETVAL (0x00000000u)

#define CSL_USB_OTG_LRAM0SIZE_RESETVAL   (0x00000000u)

/* LRAM1BASE */

#define CSL_USB_OTG_LRAM1BASE_REGION1_BASE_MASK (0xFFFFFFFFu)
#define CSL_USB_OTG_LRAM1BASE_REGION1_BASE_SHIFT (0x00000000u)
#define CSL_USB_OTG_LRAM1BASE_REGION1_BASE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_LRAM1BASE_RESETVAL   (0x00000000u)

/* PEND0 */

#define CSL_USB_OTG_PEND0_Q31_MASK       (0x80000000u)
#define CSL_USB_OTG_PEND0_Q31_SHIFT      (0x0000001Fu)
#define CSL_USB_OTG_PEND0_Q31_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q30_MASK       (0x40000000u)
#define CSL_USB_OTG_PEND0_Q30_SHIFT      (0x0000001Eu)
#define CSL_USB_OTG_PEND0_Q30_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q29_MASK       (0x20000000u)
#define CSL_USB_OTG_PEND0_Q29_SHIFT      (0x0000001Du)
#define CSL_USB_OTG_PEND0_Q29_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q28_MASK       (0x10000000u)
#define CSL_USB_OTG_PEND0_Q28_SHIFT      (0x0000001Cu)
#define CSL_USB_OTG_PEND0_Q28_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q27_MASK       (0x08000000u)
#define CSL_USB_OTG_PEND0_Q27_SHIFT      (0x0000001Bu)
#define CSL_USB_OTG_PEND0_Q27_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q26_MASK       (0x04000000u)
#define CSL_USB_OTG_PEND0_Q26_SHIFT      (0x0000001Au)
#define CSL_USB_OTG_PEND0_Q26_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q25_MASK       (0x02000000u)
#define CSL_USB_OTG_PEND0_Q25_SHIFT      (0x00000019u)
#define CSL_USB_OTG_PEND0_Q25_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q24_MASK       (0x01000000u)
#define CSL_USB_OTG_PEND0_Q24_SHIFT      (0x00000018u)
#define CSL_USB_OTG_PEND0_Q24_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q23_MASK       (0x00800000u)
#define CSL_USB_OTG_PEND0_Q23_SHIFT      (0x00000017u)
#define CSL_USB_OTG_PEND0_Q23_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q22_MASK       (0x00400000u)
#define CSL_USB_OTG_PEND0_Q22_SHIFT      (0x00000016u)
#define CSL_USB_OTG_PEND0_Q22_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q21_MASK       (0x00200000u)
#define CSL_USB_OTG_PEND0_Q21_SHIFT      (0x00000015u)
#define CSL_USB_OTG_PEND0_Q21_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q20_MASK       (0x00100000u)
#define CSL_USB_OTG_PEND0_Q20_SHIFT      (0x00000014u)
#define CSL_USB_OTG_PEND0_Q20_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q19_MASK       (0x00080000u)
#define CSL_USB_OTG_PEND0_Q19_SHIFT      (0x00000013u)
#define CSL_USB_OTG_PEND0_Q19_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q18_MASK       (0x00040000u)
#define CSL_USB_OTG_PEND0_Q18_SHIFT      (0x00000012u)
#define CSL_USB_OTG_PEND0_Q18_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q17_MASK       (0x00020000u)
#define CSL_USB_OTG_PEND0_Q17_SHIFT      (0x00000011u)
#define CSL_USB_OTG_PEND0_Q17_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q16_MASK       (0x00010000u)
#define CSL_USB_OTG_PEND0_Q16_SHIFT      (0x00000010u)
#define CSL_USB_OTG_PEND0_Q16_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q15_MASK       (0x00008000u)
#define CSL_USB_OTG_PEND0_Q15_SHIFT      (0x0000000Fu)
#define CSL_USB_OTG_PEND0_Q15_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q14_MASK       (0x00004000u)
#define CSL_USB_OTG_PEND0_Q14_SHIFT      (0x0000000Eu)
#define CSL_USB_OTG_PEND0_Q14_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q13_MASK       (0x00002000u)
#define CSL_USB_OTG_PEND0_Q13_SHIFT      (0x0000000Du)
#define CSL_USB_OTG_PEND0_Q13_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q12_MASK       (0x00001000u)
#define CSL_USB_OTG_PEND0_Q12_SHIFT      (0x0000000Cu)
#define CSL_USB_OTG_PEND0_Q12_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q11_MASK       (0x00000800u)
#define CSL_USB_OTG_PEND0_Q11_SHIFT      (0x0000000Bu)
#define CSL_USB_OTG_PEND0_Q11_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q10_MASK       (0x00000400u)
#define CSL_USB_OTG_PEND0_Q10_SHIFT      (0x0000000Au)
#define CSL_USB_OTG_PEND0_Q10_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND0_Q9_MASK        (0x00000200u)
#define CSL_USB_OTG_PEND0_Q9_SHIFT       (0x00000009u)
#define CSL_USB_OTG_PEND0_Q9_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q8_MASK        (0x00000100u)
#define CSL_USB_OTG_PEND0_Q8_SHIFT       (0x00000008u)
#define CSL_USB_OTG_PEND0_Q8_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q7_MASK        (0x00000080u)
#define CSL_USB_OTG_PEND0_Q7_SHIFT       (0x00000007u)
#define CSL_USB_OTG_PEND0_Q7_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q6_MASK        (0x00000040u)
#define CSL_USB_OTG_PEND0_Q6_SHIFT       (0x00000006u)
#define CSL_USB_OTG_PEND0_Q6_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q5_MASK        (0x00000020u)
#define CSL_USB_OTG_PEND0_Q5_SHIFT       (0x00000005u)
#define CSL_USB_OTG_PEND0_Q5_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q4_MASK        (0x00000010u)
#define CSL_USB_OTG_PEND0_Q4_SHIFT       (0x00000004u)
#define CSL_USB_OTG_PEND0_Q4_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q3_MASK        (0x00000008u)
#define CSL_USB_OTG_PEND0_Q3_SHIFT       (0x00000003u)
#define CSL_USB_OTG_PEND0_Q3_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q2_MASK        (0x00000004u)
#define CSL_USB_OTG_PEND0_Q2_SHIFT       (0x00000002u)
#define CSL_USB_OTG_PEND0_Q2_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q1_MASK        (0x00000002u)
#define CSL_USB_OTG_PEND0_Q1_SHIFT       (0x00000001u)
#define CSL_USB_OTG_PEND0_Q1_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_Q0_MASK        (0x00000001u)
#define CSL_USB_OTG_PEND0_Q0_SHIFT       (0x00000000u)
#define CSL_USB_OTG_PEND0_Q0_RESETVAL    (0x00000001u)

#define CSL_USB_OTG_PEND0_RESETVAL       (0xFFFFFFFFu)

/* PEND1 */

#define CSL_USB_OTG_PEND1_Q63_MASK       (0x80000000u)
#define CSL_USB_OTG_PEND1_Q63_SHIFT      (0x0000001Fu)
#define CSL_USB_OTG_PEND1_Q63_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q62_MASK       (0x40000000u)
#define CSL_USB_OTG_PEND1_Q62_SHIFT      (0x0000001Eu)
#define CSL_USB_OTG_PEND1_Q62_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q61_MASK       (0x20000000u)
#define CSL_USB_OTG_PEND1_Q61_SHIFT      (0x0000001Du)
#define CSL_USB_OTG_PEND1_Q61_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q60_MASK       (0x10000000u)
#define CSL_USB_OTG_PEND1_Q60_SHIFT      (0x0000001Cu)
#define CSL_USB_OTG_PEND1_Q60_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q59_MASK       (0x08000000u)
#define CSL_USB_OTG_PEND1_Q59_SHIFT      (0x0000001Bu)
#define CSL_USB_OTG_PEND1_Q59_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q58_MASK       (0x04000000u)
#define CSL_USB_OTG_PEND1_Q58_SHIFT      (0x0000001Au)
#define CSL_USB_OTG_PEND1_Q58_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q57_MASK       (0x02000000u)
#define CSL_USB_OTG_PEND1_Q57_SHIFT      (0x00000019u)
#define CSL_USB_OTG_PEND1_Q57_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q56_MASK       (0x01000000u)
#define CSL_USB_OTG_PEND1_Q56_SHIFT      (0x00000018u)
#define CSL_USB_OTG_PEND1_Q56_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q55_MASK       (0x00800000u)
#define CSL_USB_OTG_PEND1_Q55_SHIFT      (0x00000017u)
#define CSL_USB_OTG_PEND1_Q55_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q54_MASK       (0x00400000u)
#define CSL_USB_OTG_PEND1_Q54_SHIFT      (0x00000016u)
#define CSL_USB_OTG_PEND1_Q54_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q53_MASK       (0x00200000u)
#define CSL_USB_OTG_PEND1_Q53_SHIFT      (0x00000015u)
#define CSL_USB_OTG_PEND1_Q53_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q52_MASK       (0x00100000u)
#define CSL_USB_OTG_PEND1_Q52_SHIFT      (0x00000014u)
#define CSL_USB_OTG_PEND1_Q52_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q51_MASK       (0x00080000u)
#define CSL_USB_OTG_PEND1_Q51_SHIFT      (0x00000013u)
#define CSL_USB_OTG_PEND1_Q51_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q50_MASK       (0x00040000u)
#define CSL_USB_OTG_PEND1_Q50_SHIFT      (0x00000012u)
#define CSL_USB_OTG_PEND1_Q50_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q49_MASK       (0x00020000u)
#define CSL_USB_OTG_PEND1_Q49_SHIFT      (0x00000011u)
#define CSL_USB_OTG_PEND1_Q49_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q48_MASK       (0x00010000u)
#define CSL_USB_OTG_PEND1_Q48_SHIFT      (0x00000010u)
#define CSL_USB_OTG_PEND1_Q48_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q47_MASK       (0x00008000u)
#define CSL_USB_OTG_PEND1_Q47_SHIFT      (0x0000000Fu)
#define CSL_USB_OTG_PEND1_Q47_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q46_MASK       (0x00004000u)
#define CSL_USB_OTG_PEND1_Q46_SHIFT      (0x0000000Eu)
#define CSL_USB_OTG_PEND1_Q46_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q45_MASK       (0x00002000u)
#define CSL_USB_OTG_PEND1_Q45_SHIFT      (0x0000000Du)
#define CSL_USB_OTG_PEND1_Q45_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q44_MASK       (0x00001000u)
#define CSL_USB_OTG_PEND1_Q44_SHIFT      (0x0000000Cu)
#define CSL_USB_OTG_PEND1_Q44_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q43_MASK       (0x00000800u)
#define CSL_USB_OTG_PEND1_Q43_SHIFT      (0x0000000Bu)
#define CSL_USB_OTG_PEND1_Q43_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q42_MASK       (0x00000400u)
#define CSL_USB_OTG_PEND1_Q42_SHIFT      (0x0000000Au)
#define CSL_USB_OTG_PEND1_Q42_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q41_MASK       (0x00000200u)
#define CSL_USB_OTG_PEND1_Q41_SHIFT      (0x00000009u)
#define CSL_USB_OTG_PEND1_Q41_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q40_MASK       (0x00000100u)
#define CSL_USB_OTG_PEND1_Q40_SHIFT      (0x00000008u)
#define CSL_USB_OTG_PEND1_Q40_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q39_MASK       (0x00000080u)
#define CSL_USB_OTG_PEND1_Q39_SHIFT      (0x00000007u)
#define CSL_USB_OTG_PEND1_Q39_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q38_MASK       (0x00000040u)
#define CSL_USB_OTG_PEND1_Q38_SHIFT      (0x00000006u)
#define CSL_USB_OTG_PEND1_Q38_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q37_MASK       (0x00000020u)
#define CSL_USB_OTG_PEND1_Q37_SHIFT      (0x00000005u)
#define CSL_USB_OTG_PEND1_Q37_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q36_MASK       (0x00000010u)
#define CSL_USB_OTG_PEND1_Q36_SHIFT      (0x00000004u)
#define CSL_USB_OTG_PEND1_Q36_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q35_MASK       (0x00000008u)
#define CSL_USB_OTG_PEND1_Q35_SHIFT      (0x00000003u)
#define CSL_USB_OTG_PEND1_Q35_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q34_MASK       (0x00000004u)
#define CSL_USB_OTG_PEND1_Q34_SHIFT      (0x00000002u)
#define CSL_USB_OTG_PEND1_Q34_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q33_MASK       (0x00000002u)
#define CSL_USB_OTG_PEND1_Q33_SHIFT      (0x00000001u)
#define CSL_USB_OTG_PEND1_Q33_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_Q32_MASK       (0x00000001u)
#define CSL_USB_OTG_PEND1_Q32_SHIFT      (0x00000000u)
#define CSL_USB_OTG_PEND1_Q32_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND1_RESETVAL       (0xFFFFFFFFu)

/* PEND2 */

#define CSL_USB_OTG_PEND2_Q95_MASK       (0x80000000u)
#define CSL_USB_OTG_PEND2_Q95_SHIFT      (0x0000001Fu)
#define CSL_USB_OTG_PEND2_Q95_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q94_MASK       (0x40000000u)
#define CSL_USB_OTG_PEND2_Q94_SHIFT      (0x0000001Eu)
#define CSL_USB_OTG_PEND2_Q94_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q93_MASK       (0x20000000u)
#define CSL_USB_OTG_PEND2_Q93_SHIFT      (0x0000001Du)
#define CSL_USB_OTG_PEND2_Q93_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q92_MASK       (0x10000000u)
#define CSL_USB_OTG_PEND2_Q92_SHIFT      (0x0000001Cu)
#define CSL_USB_OTG_PEND2_Q92_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q91_MASK       (0x08000000u)
#define CSL_USB_OTG_PEND2_Q91_SHIFT      (0x0000001Bu)
#define CSL_USB_OTG_PEND2_Q91_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q90_MASK       (0x04000000u)
#define CSL_USB_OTG_PEND2_Q90_SHIFT      (0x0000001Au)
#define CSL_USB_OTG_PEND2_Q90_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q89_MASK       (0x02000000u)
#define CSL_USB_OTG_PEND2_Q89_SHIFT      (0x00000019u)
#define CSL_USB_OTG_PEND2_Q89_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q88_MASK       (0x01000000u)
#define CSL_USB_OTG_PEND2_Q88_SHIFT      (0x00000018u)
#define CSL_USB_OTG_PEND2_Q88_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q87_MASK       (0x00800000u)
#define CSL_USB_OTG_PEND2_Q87_SHIFT      (0x00000017u)
#define CSL_USB_OTG_PEND2_Q87_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q86_MASK       (0x00400000u)
#define CSL_USB_OTG_PEND2_Q86_SHIFT      (0x00000016u)
#define CSL_USB_OTG_PEND2_Q86_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q85_MASK       (0x00200000u)
#define CSL_USB_OTG_PEND2_Q85_SHIFT      (0x00000015u)
#define CSL_USB_OTG_PEND2_Q85_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q84_MASK       (0x00100000u)
#define CSL_USB_OTG_PEND2_Q84_SHIFT      (0x00000014u)
#define CSL_USB_OTG_PEND2_Q84_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q83_MASK       (0x00080000u)
#define CSL_USB_OTG_PEND2_Q83_SHIFT      (0x00000013u)
#define CSL_USB_OTG_PEND2_Q83_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q82_MASK       (0x00040000u)
#define CSL_USB_OTG_PEND2_Q82_SHIFT      (0x00000012u)
#define CSL_USB_OTG_PEND2_Q82_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q81_MASK       (0x00020000u)
#define CSL_USB_OTG_PEND2_Q81_SHIFT      (0x00000011u)
#define CSL_USB_OTG_PEND2_Q81_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q80_MASK       (0x00010000u)
#define CSL_USB_OTG_PEND2_Q80_SHIFT      (0x00000010u)
#define CSL_USB_OTG_PEND2_Q80_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q79_MASK       (0x00008000u)
#define CSL_USB_OTG_PEND2_Q79_SHIFT      (0x0000000Fu)
#define CSL_USB_OTG_PEND2_Q79_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q78_MASK       (0x00004000u)
#define CSL_USB_OTG_PEND2_Q78_SHIFT      (0x0000000Eu)
#define CSL_USB_OTG_PEND2_Q78_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q77_MASK       (0x00002000u)
#define CSL_USB_OTG_PEND2_Q77_SHIFT      (0x0000000Du)
#define CSL_USB_OTG_PEND2_Q77_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q76_MASK       (0x00001000u)
#define CSL_USB_OTG_PEND2_Q76_SHIFT      (0x0000000Cu)
#define CSL_USB_OTG_PEND2_Q76_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q75_MASK       (0x00000800u)
#define CSL_USB_OTG_PEND2_Q75_SHIFT      (0x0000000Bu)
#define CSL_USB_OTG_PEND2_Q75_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q74_MASK       (0x00000400u)
#define CSL_USB_OTG_PEND2_Q74_SHIFT      (0x0000000Au)
#define CSL_USB_OTG_PEND2_Q74_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q73_MASK       (0x00000200u)
#define CSL_USB_OTG_PEND2_Q73_SHIFT      (0x00000009u)
#define CSL_USB_OTG_PEND2_Q73_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q72_MASK       (0x00000100u)
#define CSL_USB_OTG_PEND2_Q72_SHIFT      (0x00000008u)
#define CSL_USB_OTG_PEND2_Q72_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q71_MASK       (0x00000080u)
#define CSL_USB_OTG_PEND2_Q71_SHIFT      (0x00000007u)
#define CSL_USB_OTG_PEND2_Q71_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q70_MASK       (0x00000040u)
#define CSL_USB_OTG_PEND2_Q70_SHIFT      (0x00000006u)
#define CSL_USB_OTG_PEND2_Q70_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q69_MASK       (0x00000020u)
#define CSL_USB_OTG_PEND2_Q69_SHIFT      (0x00000005u)
#define CSL_USB_OTG_PEND2_Q69_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q68_MASK       (0x00000010u)
#define CSL_USB_OTG_PEND2_Q68_SHIFT      (0x00000004u)
#define CSL_USB_OTG_PEND2_Q68_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q67_MASK       (0x00000008u)
#define CSL_USB_OTG_PEND2_Q67_SHIFT      (0x00000003u)
#define CSL_USB_OTG_PEND2_Q67_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q66_MASK       (0x00000004u)
#define CSL_USB_OTG_PEND2_Q66_SHIFT      (0x00000002u)
#define CSL_USB_OTG_PEND2_Q66_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q65_MASK       (0x00000002u)
#define CSL_USB_OTG_PEND2_Q65_SHIFT      (0x00000001u)
#define CSL_USB_OTG_PEND2_Q65_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_Q64_MASK       (0x00000001u)
#define CSL_USB_OTG_PEND2_Q64_SHIFT      (0x00000000u)
#define CSL_USB_OTG_PEND2_Q64_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_PEND2_RESETVAL       (0xFFFFFFFFu)

/* QMEMRBASE */

#define CSL_USB_OTG_QMEMRBASE_REG_MASK   (0xFFFFFFFFu)
#define CSL_USB_OTG_QMEMRBASE_REG_SHIFT  (0x00000000u)
#define CSL_USB_OTG_QMEMRBASE_REG_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QMEMRBASE_RESETVAL   (0x00000000u)

/* QMEMRCTRL */

#define CSL_USB_OTG_QMEMRCTRL_RSV3_MASK  (0xC0000000u)
#define CSL_USB_OTG_QMEMRCTRL_RSV3_SHIFT (0x0000001Eu)
#define CSL_USB_OTG_QMEMRCTRL_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QMEMRCTRL_START_INDEX_MASK (0x3FFF0000u)
#define CSL_USB_OTG_QMEMRCTRL_START_INDEX_SHIFT (0x00000010u)
#define CSL_USB_OTG_QMEMRCTRL_START_INDEX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QMEMRCTRL_RSV2_MASK  (0x0000F000u)
#define CSL_USB_OTG_QMEMRCTRL_RSV2_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_QMEMRCTRL_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QMEMRCTRL_DESC_SIZE_MASK (0x00000F00u)
#define CSL_USB_OTG_QMEMRCTRL_DESC_SIZE_SHIFT (0x00000008u)
#define CSL_USB_OTG_QMEMRCTRL_DESC_SIZE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QMEMRCTRL_RSV1_MASK  (0x000000F8u)
#define CSL_USB_OTG_QMEMRCTRL_RSV1_SHIFT (0x00000003u)
#define CSL_USB_OTG_QMEMRCTRL_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QMEMRCTRL_REG_SIZE_MASK (0x00000007u)
#define CSL_USB_OTG_QMEMRCTRL_REG_SIZE_SHIFT (0x00000000u)
#define CSL_USB_OTG_QMEMRCTRL_REG_SIZE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QMEMRCTRL_RESETVAL   (0x00000000u)

/* CTRLD */

#define CSL_USB_OTG_CTRLD_DESC_PTR_MASK  (0xFFFFFFE0u)
#define CSL_USB_OTG_CTRLD_DESC_PTR_SHIFT (0x00000005u)
#define CSL_USB_OTG_CTRLD_DESC_PTR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_CTRLD_DESC_SIZE_MASK (0x0000001Fu)
#define CSL_USB_OTG_CTRLD_DESC_SIZE_SHIFT (0x00000000u)
#define CSL_USB_OTG_CTRLD_DESC_SIZE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_CTRLD_RESETVAL       (0x00000000u)

/* QSTATA */

#define CSL_USB_OTG_QSTATA_RSV_MASK      (0xFFFFC000u)
#define CSL_USB_OTG_QSTATA_RSV_SHIFT     (0x0000000Eu)
#define CSL_USB_OTG_QSTATA_RSV_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_QSTATA_QUEUE_ENTRY_COUNT_MASK (0x00003FFFu)
#define CSL_USB_OTG_QSTATA_QUEUE_ENTRY_COUNT_SHIFT (0x00000000u)
#define CSL_USB_OTG_QSTATA_QUEUE_ENTRY_COUNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QSTATA_RESETVAL      (0x00000000u)

/* QSTATB */

#define CSL_USB_OTG_QSTATB_RSV_MASK      (0xF0000000u)
#define CSL_USB_OTG_QSTATB_RSV_SHIFT     (0x0000001Cu)
#define CSL_USB_OTG_QSTATB_RSV_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_QSTATB_QUEUE_BYTE_COUNT_MASK (0x0FFFFFFFu)
#define CSL_USB_OTG_QSTATB_QUEUE_BYTE_COUNT_SHIFT (0x00000000u)
#define CSL_USB_OTG_QSTATB_QUEUE_BYTE_COUNT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QSTATB_RESETVAL      (0x00000000u)

/* QSTATC */

#define CSL_USB_OTG_QSTATC_RSV_MASK      (0xFFFFC000u)
#define CSL_USB_OTG_QSTATC_RSV_SHIFT     (0x0000000Eu)
#define CSL_USB_OTG_QSTATC_RSV_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_QSTATC_PACKET_SIZE_MASK (0x00003FFFu)
#define CSL_USB_OTG_QSTATC_PACKET_SIZE_SHIFT (0x00000000u)
#define CSL_USB_OTG_QSTATC_PACKET_SIZE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_QSTATC_RESETVAL      (0x00000000u)

/* REVID */

#define CSL_USB_OTG_REVID_REV_MASK       (0xFFFFFFFFu)
#define CSL_USB_OTG_REVID_REV_SHIFT      (0x00000000u)
#define CSL_USB_OTG_REVID_REV_RESETVAL   (0x4EA10800u)

#define CSL_USB_OTG_REVID_RESETVAL       (0x4EA10800u)

/* CTRLR */

#define CSL_USB_OTG_CTRLR_DIS_DEB_MASK   (0x80000000u)
#define CSL_USB_OTG_CTRLR_DIS_DEB_SHIFT  (0x0000001Fu)
#define CSL_USB_OTG_CTRLR_DIS_DEB_RESETVAL (0x00000000u)

#define CSL_USB_OTG_CTRLR_DIS_SRP_MASK   (0x40000000u)
#define CSL_USB_OTG_CTRLR_DIS_SRP_SHIFT  (0x0000001Eu)
#define CSL_USB_OTG_CTRLR_DIS_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_CTRLR_RSV_MASK       (0x3FFFFFE0u)
#define CSL_USB_OTG_CTRLR_RSV_SHIFT      (0x00000005u)
#define CSL_USB_OTG_CTRLR_RSV_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_CTRLR_RNDIS_MASK     (0x00000010u)
#define CSL_USB_OTG_CTRLR_RNDIS_SHIFT    (0x00000004u)
#define CSL_USB_OTG_CTRLR_RNDIS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_CTRLR_UINT_MASK      (0x00000008u)
#define CSL_USB_OTG_CTRLR_UINT_SHIFT     (0x00000003u)
#define CSL_USB_OTG_CTRLR_UINT_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_CTRLR_RSV2_MASK      (0x00000004u)
#define CSL_USB_OTG_CTRLR_RSV2_SHIFT     (0x00000002u)
#define CSL_USB_OTG_CTRLR_RSV2_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_CTRLR_CLKFACK_MASK   (0x00000002u)
#define CSL_USB_OTG_CTRLR_CLKFACK_SHIFT  (0x00000001u)
#define CSL_USB_OTG_CTRLR_CLKFACK_RESETVAL (0x00000000u)

#define CSL_USB_OTG_CTRLR_RESET_MASK     (0x00000001u)
#define CSL_USB_OTG_CTRLR_RESET_SHIFT    (0x00000000u)
#define CSL_USB_OTG_CTRLR_RESET_RESETVAL (0x00000001u)

#define CSL_USB_OTG_CTRLR_RESETVAL       (0x00000001u)

/* STATR */

#define CSL_USB_OTG_STATR_RSV_MASK       (0xFFFFFFFEu)
#define CSL_USB_OTG_STATR_RSV_SHIFT      (0x00000001u)
#define CSL_USB_OTG_STATR_RSV_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_STATR_DRVVBUS_MASK   (0x00000001u)
#define CSL_USB_OTG_STATR_DRVVBUS_SHIFT  (0x00000000u)
#define CSL_USB_OTG_STATR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_STATR_RESETVAL       (0x00000000u)

/* EMUR */

#define CSL_USB_OTG_EMUR_RSV_MASK        (0xFFFFFFF8u)
#define CSL_USB_OTG_EMUR_RSV_SHIFT       (0x00000003u)
#define CSL_USB_OTG_EMUR_RSV_RESETVAL    (0x00000000u)

#define CSL_USB_OTG_EMUR_RT_SEL_MASK     (0x00000004u)
#define CSL_USB_OTG_EMUR_RT_SEL_SHIFT    (0x00000002u)
#define CSL_USB_OTG_EMUR_RT_SEL_RESETVAL (0x00000001u)

#define CSL_USB_OTG_EMUR_SOFT_MASK       (0x00000002u)
#define CSL_USB_OTG_EMUR_SOFT_SHIFT      (0x00000001u)
#define CSL_USB_OTG_EMUR_SOFT_RESETVAL   (0x00000001u)

#define CSL_USB_OTG_EMUR_FREERUN_MASK    (0x00000001u)
#define CSL_USB_OTG_EMUR_FREERUN_SHIFT   (0x00000000u)
#define CSL_USB_OTG_EMUR_FREERUN_RESETVAL (0x00000001u)

#define CSL_USB_OTG_EMUR_RESETVAL        (0x00000007u)

/* MODE */

#define CSL_USB_OTG_MODE_RSV8_MASK       (0xC0000000u)
#define CSL_USB_OTG_MODE_RSV8_SHIFT      (0x0000001Eu)
#define CSL_USB_OTG_MODE_RSV8_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_RX4_MODE_MASK   (0x30000000u)
#define CSL_USB_OTG_MODE_RX4_MODE_SHIFT  (0x0000001Cu)
#define CSL_USB_OTG_MODE_RX4_MODE_RESETVAL (0x00000000u)
/*----RX4_MODE Tokens----*/
#define CSL_USB_OTG_MODE_RX4_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_RX4_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_RX4_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_RX4_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RSV7_MASK       (0x0C000000u)
#define CSL_USB_OTG_MODE_RSV7_SHIFT      (0x0000001Au)
#define CSL_USB_OTG_MODE_RSV7_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_RX3_MODE_MASK   (0x03000000u)
#define CSL_USB_OTG_MODE_RX3_MODE_SHIFT  (0x00000018u)
#define CSL_USB_OTG_MODE_RX3_MODE_RESETVAL (0x00000000u)
/*----RX3_MODE Tokens----*/
#define CSL_USB_OTG_MODE_RX3_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_RX3_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_RX3_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_RX3_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RSV6_MASK       (0x00C00000u)
#define CSL_USB_OTG_MODE_RSV6_SHIFT      (0x00000016u)
#define CSL_USB_OTG_MODE_RSV6_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_RX2_MODE_MASK   (0x00300000u)
#define CSL_USB_OTG_MODE_RX2_MODE_SHIFT  (0x00000014u)
#define CSL_USB_OTG_MODE_RX2_MODE_RESETVAL (0x00000000u)
/*----RX2_MODE Tokens----*/
#define CSL_USB_OTG_MODE_RX2_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_RX2_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_RX2_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_RX2_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RSV5_MASK       (0x000C0000u)
#define CSL_USB_OTG_MODE_RSV5_SHIFT      (0x00000012u)
#define CSL_USB_OTG_MODE_RSV5_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_RX1_MODE_MASK   (0x00030000u)
#define CSL_USB_OTG_MODE_RX1_MODE_SHIFT  (0x00000010u)
#define CSL_USB_OTG_MODE_RX1_MODE_RESETVAL (0x00000000u)
/*----RX1_MODE Tokens----*/
#define CSL_USB_OTG_MODE_RX1_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_RX1_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_RX1_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_RX1_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RSV4_MASK       (0x0000C000u)
#define CSL_USB_OTG_MODE_RSV4_SHIFT      (0x0000000Eu)
#define CSL_USB_OTG_MODE_RSV4_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_TX4_MODE_MASK   (0x00003000u)
#define CSL_USB_OTG_MODE_TX4_MODE_SHIFT  (0x0000000Cu)
#define CSL_USB_OTG_MODE_TX4_MODE_RESETVAL (0x00000000u)
/*----TX4_MODE Tokens----*/
#define CSL_USB_OTG_MODE_TX4_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_TX4_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_TX4_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_TX4_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RSV3_MASK       (0x00000C00u)
#define CSL_USB_OTG_MODE_RSV3_SHIFT      (0x0000000Au)
#define CSL_USB_OTG_MODE_RSV3_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_TX3_MODE_MASK   (0x00000300u)
#define CSL_USB_OTG_MODE_TX3_MODE_SHIFT  (0x00000008u)
#define CSL_USB_OTG_MODE_TX3_MODE_RESETVAL (0x00000000u)
/*----TX3_MODE Tokens----*/
#define CSL_USB_OTG_MODE_TX3_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_TX3_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_TX3_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_TX3_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RSV2_MASK       (0x000000C0u)
#define CSL_USB_OTG_MODE_RSV2_SHIFT      (0x00000006u)
#define CSL_USB_OTG_MODE_RSV2_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_TX2_MODE_MASK   (0x00000030u)
#define CSL_USB_OTG_MODE_TX2_MODE_SHIFT  (0x00000004u)
#define CSL_USB_OTG_MODE_TX2_MODE_RESETVAL (0x00000000u)
/*----TX2_MODE Tokens----*/
#define CSL_USB_OTG_MODE_TX2_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_TX2_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_TX2_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_TX2_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RSV1_MASK       (0x0000000Cu)
#define CSL_USB_OTG_MODE_RSV1_SHIFT      (0x00000002u)
#define CSL_USB_OTG_MODE_RSV1_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_MODE_TX1_MODE_MASK   (0x00000003u)
#define CSL_USB_OTG_MODE_TX1_MODE_SHIFT  (0x00000000u)
#define CSL_USB_OTG_MODE_TX1_MODE_RESETVAL (0x00000000u)
/*----TX1_MODE Tokens----*/
#define CSL_USB_OTG_MODE_TX1_MODE_TRANSPARENT (0x00000000u)
#define CSL_USB_OTG_MODE_TX1_MODE_RNDIS  (0x00000001u)
#define CSL_USB_OTG_MODE_TX1_MODE_CDC    (0x00000002u)
#define CSL_USB_OTG_MODE_TX1_MODE_GENRNDIS (0x00000003u)

#define CSL_USB_OTG_MODE_RESETVAL        (0x00000000u)

/* AUTOREQ */

#define CSL_USB_OTG_AUTOREQ_RSV_MASK     (0xFFFFFF00u)
#define CSL_USB_OTG_AUTOREQ_RSV_SHIFT    (0x00000008u)
#define CSL_USB_OTG_AUTOREQ_RSV_RESETVAL (0x00000000u)

#define CSL_USB_OTG_AUTOREQ_RX4_AUTREQ_MASK (0x000000C0u)
#define CSL_USB_OTG_AUTOREQ_RX4_AUTREQ_SHIFT (0x00000006u)
#define CSL_USB_OTG_AUTOREQ_RX4_AUTREQ_RESETVAL (0x00000000u)
/*----RX4_AUTREQ Tokens----*/
#define CSL_USB_OTG_AUTOREQ_RX4_AUTREQ_NONE (0x00000000u)
#define CSL_USB_OTG_AUTOREQ_RX4_AUTREQ_ALL_BUT_EOP (0x00000001u)
#define CSL_USB_OTG_AUTOREQ_RX4_AUTREQ_ALL (0x00000003u)

#define CSL_USB_OTG_AUTOREQ_RX3_AUTREQ_MASK (0x00000030u)
#define CSL_USB_OTG_AUTOREQ_RX3_AUTREQ_SHIFT (0x00000004u)
#define CSL_USB_OTG_AUTOREQ_RX3_AUTREQ_RESETVAL (0x00000000u)
/*----RX3_AUTREQ Tokens----*/
#define CSL_USB_OTG_AUTOREQ_RX3_AUTREQ_NONE (0x00000000u)
#define CSL_USB_OTG_AUTOREQ_RX3_AUTREQ_ALL_BUT_EOP (0x00000001u)
#define CSL_USB_OTG_AUTOREQ_RX3_AUTREQ_ALL (0x00000003u)

#define CSL_USB_OTG_AUTOREQ_RX2_AUTREQ_MASK (0x0000000Cu)
#define CSL_USB_OTG_AUTOREQ_RX2_AUTREQ_SHIFT (0x00000002u)
#define CSL_USB_OTG_AUTOREQ_RX2_AUTREQ_RESETVAL (0x00000000u)
/*----RX2_AUTREQ Tokens----*/
#define CSL_USB_OTG_AUTOREQ_RX2_AUTREQ_NONE (0x00000000u)
#define CSL_USB_OTG_AUTOREQ_RX2_AUTREQ_ALL_BUT_EOP (0x00000001u)
#define CSL_USB_OTG_AUTOREQ_RX2_AUTREQ_ALL (0x00000003u)

#define CSL_USB_OTG_AUTOREQ_RX1_AUTREQ_MASK (0x00000003u)
#define CSL_USB_OTG_AUTOREQ_RX1_AUTREQ_SHIFT (0x00000000u)
#define CSL_USB_OTG_AUTOREQ_RX1_AUTREQ_RESETVAL (0x00000000u)
/*----RX1_AUTREQ Tokens----*/
#define CSL_USB_OTG_AUTOREQ_RX1_AUTREQ_NONE (0x00000000u)
#define CSL_USB_OTG_AUTOREQ_RX1_AUTREQ_ALL_BUT_EOP (0x00000001u)
#define CSL_USB_OTG_AUTOREQ_RX1_AUTREQ_ALL (0x00000003u)

#define CSL_USB_OTG_AUTOREQ_RESETVAL     (0x00000000u)

/* SRPFIXTIME */

#define CSL_USB_OTG_SRPFIXTIME_SRPFIXTIME_MASK (0xFFFFFFFFu)
#define CSL_USB_OTG_SRPFIXTIME_SRPFIXTIME_SHIFT (0x00000000u)
#define CSL_USB_OTG_SRPFIXTIME_SRPFIXTIME_RESETVAL (0x0280DE80u)

#define CSL_USB_OTG_SRPFIXTIME_RESETVAL  (0x0280DE80u)

/* TEARDOWN */

#define CSL_USB_OTG_TEARDOWN_RSV3_MASK   (0xFFE00000u)
#define CSL_USB_OTG_TEARDOWN_RSV3_SHIFT  (0x00000015u)
#define CSL_USB_OTG_TEARDOWN_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TEARDOWN_TX_TDOWN_MASK (0x001E0000u)
#define CSL_USB_OTG_TEARDOWN_TX_TDOWN_SHIFT (0x00000011u)
#define CSL_USB_OTG_TEARDOWN_TX_TDOWN_RESETVAL (0x00000000u)
/*----TX_TDOWN Tokens----*/
#define CSL_USB_OTG_TEARDOWN_TX_TDOWN_TX4 (0x00000008u)
#define CSL_USB_OTG_TEARDOWN_TX_TDOWN_TX3 (0x00000004u)
#define CSL_USB_OTG_TEARDOWN_TX_TDOWN_TX2 (0x00000002u)
#define CSL_USB_OTG_TEARDOWN_TX_TDOWN_TX1 (0x00000001u)

#define CSL_USB_OTG_TEARDOWN_RSV2_MASK   (0x0001FFE0u)
#define CSL_USB_OTG_TEARDOWN_RSV2_SHIFT  (0x00000005u)
#define CSL_USB_OTG_TEARDOWN_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TEARDOWN_RX_TDOWN_MASK (0x0000001Eu)
#define CSL_USB_OTG_TEARDOWN_RX_TDOWN_SHIFT (0x00000001u)
#define CSL_USB_OTG_TEARDOWN_RX_TDOWN_RESETVAL (0x00000000u)
/*----RX_TDOWN Tokens----*/
#define CSL_USB_OTG_TEARDOWN_RX_TDOWN_RX4 (0x00000008u)
#define CSL_USB_OTG_TEARDOWN_RX_TDOWN_RX3 (0x00000004u)
#define CSL_USB_OTG_TEARDOWN_RX_TDOWN_RX2 (0x00000002u)
#define CSL_USB_OTG_TEARDOWN_RX_TDOWN_RX1 (0x00000001u)

#define CSL_USB_OTG_TEARDOWN_RSV1_MASK   (0x00000001u)
#define CSL_USB_OTG_TEARDOWN_RSV1_SHIFT  (0x00000000u)
#define CSL_USB_OTG_TEARDOWN_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_TEARDOWN_RESETVAL    (0x00000000u)

/* INTSRCR */

#define CSL_USB_OTG_INTSRCR_RSV3_MASK    (0xFE000000u)
#define CSL_USB_OTG_INTSRCR_RSV3_SHIFT   (0x00000019u)
#define CSL_USB_OTG_INTSRCR_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_DRVVBUS_MASK (0x01000000u)
#define CSL_USB_OTG_INTSRCR_DRVVBUS_SHIFT (0x00000018u)
#define CSL_USB_OTG_INTSRCR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_VBUSINVALID_MASK (0x00800000u)
#define CSL_USB_OTG_INTSRCR_VBUSINVALID_SHIFT (0x00000017u)
#define CSL_USB_OTG_INTSRCR_VBUSINVALID_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_SRP_MASK     (0x00400000u)
#define CSL_USB_OTG_INTSRCR_SRP_SHIFT    (0x00000016u)
#define CSL_USB_OTG_INTSRCR_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_DISCONNECT_MASK (0x00200000u)
#define CSL_USB_OTG_INTSRCR_DISCONNECT_SHIFT (0x00000015u)
#define CSL_USB_OTG_INTSRCR_DISCONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_CONNECT_MASK (0x00100000u)
#define CSL_USB_OTG_INTSRCR_CONNECT_SHIFT (0x00000014u)
#define CSL_USB_OTG_INTSRCR_CONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_SOF_MASK     (0x00080000u)
#define CSL_USB_OTG_INTSRCR_SOF_SHIFT    (0x00000013u)
#define CSL_USB_OTG_INTSRCR_SOF_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_RESET_BABBLE_MASK (0x00040000u)
#define CSL_USB_OTG_INTSRCR_RESET_BABBLE_SHIFT (0x00000012u)
#define CSL_USB_OTG_INTSRCR_RESET_BABBLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_RESUME_MASK  (0x00020000u)
#define CSL_USB_OTG_INTSRCR_RESUME_SHIFT (0x00000011u)
#define CSL_USB_OTG_INTSRCR_RESUME_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_SUSPEND_MASK (0x00010000u)
#define CSL_USB_OTG_INTSRCR_SUSPEND_SHIFT (0x00000010u)
#define CSL_USB_OTG_INTSRCR_SUSPEND_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_RSV2_MASK    (0x0000E000u)
#define CSL_USB_OTG_INTSRCR_RSV2_SHIFT   (0x0000000Du)
#define CSL_USB_OTG_INTSRCR_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP4RX_MASK   (0x00001000u)
#define CSL_USB_OTG_INTSRCR_EP4RX_SHIFT  (0x0000000Cu)
#define CSL_USB_OTG_INTSRCR_EP4RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP3RX_MASK   (0x00000800u)
#define CSL_USB_OTG_INTSRCR_EP3RX_SHIFT  (0x0000000Bu)
#define CSL_USB_OTG_INTSRCR_EP3RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP2RX_MASK   (0x00000400u)
#define CSL_USB_OTG_INTSRCR_EP2RX_SHIFT  (0x0000000Au)
#define CSL_USB_OTG_INTSRCR_EP2RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP1RX_MASK   (0x00000200u)
#define CSL_USB_OTG_INTSRCR_EP1RX_SHIFT  (0x00000009u)
#define CSL_USB_OTG_INTSRCR_EP1RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_RSV1_MASK    (0x000001E0u)
#define CSL_USB_OTG_INTSRCR_RSV1_SHIFT   (0x00000005u)
#define CSL_USB_OTG_INTSRCR_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP4TX_MASK   (0x00000010u)
#define CSL_USB_OTG_INTSRCR_EP4TX_SHIFT  (0x00000004u)
#define CSL_USB_OTG_INTSRCR_EP4TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP3TX_MASK   (0x00000008u)
#define CSL_USB_OTG_INTSRCR_EP3TX_SHIFT  (0x00000003u)
#define CSL_USB_OTG_INTSRCR_EP3TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP2TX_MASK   (0x00000004u)
#define CSL_USB_OTG_INTSRCR_EP2TX_SHIFT  (0x00000002u)
#define CSL_USB_OTG_INTSRCR_EP2TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP1TX_MASK   (0x00000002u)
#define CSL_USB_OTG_INTSRCR_EP1TX_SHIFT  (0x00000001u)
#define CSL_USB_OTG_INTSRCR_EP1TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_EP0_MASK     (0x00000001u)
#define CSL_USB_OTG_INTSRCR_EP0_SHIFT    (0x00000000u)
#define CSL_USB_OTG_INTSRCR_EP0_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSRCR_RESETVAL     (0x00000000u)

/* INTSETR */

#define CSL_USB_OTG_INTSETR_RSV3_MASK    (0xFE000000u)
#define CSL_USB_OTG_INTSETR_RSV3_SHIFT   (0x00000019u)
#define CSL_USB_OTG_INTSETR_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_DRVVBUS_MASK (0x01000000u)
#define CSL_USB_OTG_INTSETR_DRVVBUS_SHIFT (0x00000018u)
#define CSL_USB_OTG_INTSETR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_VBUSINVALID_MASK (0x00800000u)
#define CSL_USB_OTG_INTSETR_VBUSINVALID_SHIFT (0x00000017u)
#define CSL_USB_OTG_INTSETR_VBUSINVALID_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_SRP_MASK     (0x00400000u)
#define CSL_USB_OTG_INTSETR_SRP_SHIFT    (0x00000016u)
#define CSL_USB_OTG_INTSETR_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_DISCONNECT_MASK (0x00200000u)
#define CSL_USB_OTG_INTSETR_DISCONNECT_SHIFT (0x00000015u)
#define CSL_USB_OTG_INTSETR_DISCONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_CONNECT_MASK (0x00100000u)
#define CSL_USB_OTG_INTSETR_CONNECT_SHIFT (0x00000014u)
#define CSL_USB_OTG_INTSETR_CONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_SOF_MASK     (0x00080000u)
#define CSL_USB_OTG_INTSETR_SOF_SHIFT    (0x00000013u)
#define CSL_USB_OTG_INTSETR_SOF_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_RESET_BABBLE_MASK (0x00040000u)
#define CSL_USB_OTG_INTSETR_RESET_BABBLE_SHIFT (0x00000012u)
#define CSL_USB_OTG_INTSETR_RESET_BABBLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_RESUME_MASK  (0x00020000u)
#define CSL_USB_OTG_INTSETR_RESUME_SHIFT (0x00000011u)
#define CSL_USB_OTG_INTSETR_RESUME_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_SUSPEND_MASK (0x00010000u)
#define CSL_USB_OTG_INTSETR_SUSPEND_SHIFT (0x00000010u)
#define CSL_USB_OTG_INTSETR_SUSPEND_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_RSV2_MASK    (0x0000E000u)
#define CSL_USB_OTG_INTSETR_RSV2_SHIFT   (0x0000000Du)
#define CSL_USB_OTG_INTSETR_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP4RX_MASK   (0x00001000u)
#define CSL_USB_OTG_INTSETR_EP4RX_SHIFT  (0x0000000Cu)
#define CSL_USB_OTG_INTSETR_EP4RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP3RX_MASK   (0x00000800u)
#define CSL_USB_OTG_INTSETR_EP3RX_SHIFT  (0x0000000Bu)
#define CSL_USB_OTG_INTSETR_EP3RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP2RX_MASK   (0x00000400u)
#define CSL_USB_OTG_INTSETR_EP2RX_SHIFT  (0x0000000Au)
#define CSL_USB_OTG_INTSETR_EP2RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP1RX_MASK   (0x00000200u)
#define CSL_USB_OTG_INTSETR_EP1RX_SHIFT  (0x00000009u)
#define CSL_USB_OTG_INTSETR_EP1RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_RSV1_MASK    (0x000001E0u)
#define CSL_USB_OTG_INTSETR_RSV1_SHIFT   (0x00000005u)
#define CSL_USB_OTG_INTSETR_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP4TX_MASK   (0x00000010u)
#define CSL_USB_OTG_INTSETR_EP4TX_SHIFT  (0x00000004u)
#define CSL_USB_OTG_INTSETR_EP4TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP3TX_MASK   (0x00000008u)
#define CSL_USB_OTG_INTSETR_EP3TX_SHIFT  (0x00000003u)
#define CSL_USB_OTG_INTSETR_EP3TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP2TX_MASK   (0x00000004u)
#define CSL_USB_OTG_INTSETR_EP2TX_SHIFT  (0x00000002u)
#define CSL_USB_OTG_INTSETR_EP2TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP1TX_MASK   (0x00000002u)
#define CSL_USB_OTG_INTSETR_EP1TX_SHIFT  (0x00000001u)
#define CSL_USB_OTG_INTSETR_EP1TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_EP0_MASK     (0x00000001u)
#define CSL_USB_OTG_INTSETR_EP0_SHIFT    (0x00000000u)
#define CSL_USB_OTG_INTSETR_EP0_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTSETR_RESETVAL     (0x00000000u)

/* INTCLRR */

#define CSL_USB_OTG_INTCLRR_RSV3_MASK    (0xFE000000u)
#define CSL_USB_OTG_INTCLRR_RSV3_SHIFT   (0x00000019u)
#define CSL_USB_OTG_INTCLRR_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_DRVVBUS_MASK (0x01000000u)
#define CSL_USB_OTG_INTCLRR_DRVVBUS_SHIFT (0x00000018u)
#define CSL_USB_OTG_INTCLRR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_VBUSINVALID_MASK (0x00800000u)
#define CSL_USB_OTG_INTCLRR_VBUSINVALID_SHIFT (0x00000017u)
#define CSL_USB_OTG_INTCLRR_VBUSINVALID_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_SRP_MASK     (0x00400000u)
#define CSL_USB_OTG_INTCLRR_SRP_SHIFT    (0x00000016u)
#define CSL_USB_OTG_INTCLRR_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_DISCONNECT_MASK (0x00200000u)
#define CSL_USB_OTG_INTCLRR_DISCONNECT_SHIFT (0x00000015u)
#define CSL_USB_OTG_INTCLRR_DISCONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_CONNECT_MASK (0x00100000u)
#define CSL_USB_OTG_INTCLRR_CONNECT_SHIFT (0x00000014u)
#define CSL_USB_OTG_INTCLRR_CONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_SOF_MASK     (0x00080000u)
#define CSL_USB_OTG_INTCLRR_SOF_SHIFT    (0x00000013u)
#define CSL_USB_OTG_INTCLRR_SOF_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_RESET_BABBLE_MASK (0x00040000u)
#define CSL_USB_OTG_INTCLRR_RESET_BABBLE_SHIFT (0x00000012u)
#define CSL_USB_OTG_INTCLRR_RESET_BABBLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_RESUME_MASK  (0x00020000u)
#define CSL_USB_OTG_INTCLRR_RESUME_SHIFT (0x00000011u)
#define CSL_USB_OTG_INTCLRR_RESUME_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_SUSPEND_MASK (0x00010000u)
#define CSL_USB_OTG_INTCLRR_SUSPEND_SHIFT (0x00000010u)
#define CSL_USB_OTG_INTCLRR_SUSPEND_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_RSV2_MASK    (0x0000E000u)
#define CSL_USB_OTG_INTCLRR_RSV2_SHIFT   (0x0000000Du)
#define CSL_USB_OTG_INTCLRR_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP4RX_MASK   (0x00001000u)
#define CSL_USB_OTG_INTCLRR_EP4RX_SHIFT  (0x0000000Cu)
#define CSL_USB_OTG_INTCLRR_EP4RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP3RX_MASK   (0x00000800u)
#define CSL_USB_OTG_INTCLRR_EP3RX_SHIFT  (0x0000000Bu)
#define CSL_USB_OTG_INTCLRR_EP3RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP2RX_MASK   (0x00000400u)
#define CSL_USB_OTG_INTCLRR_EP2RX_SHIFT  (0x0000000Au)
#define CSL_USB_OTG_INTCLRR_EP2RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP1RX_MASK   (0x00000200u)
#define CSL_USB_OTG_INTCLRR_EP1RX_SHIFT  (0x00000009u)
#define CSL_USB_OTG_INTCLRR_EP1RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_RSV1_MASK    (0x000001E0u)
#define CSL_USB_OTG_INTCLRR_RSV1_SHIFT   (0x00000005u)
#define CSL_USB_OTG_INTCLRR_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP4TX_MASK   (0x00000010u)
#define CSL_USB_OTG_INTCLRR_EP4TX_SHIFT  (0x00000004u)
#define CSL_USB_OTG_INTCLRR_EP4TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP3TX_MASK   (0x00000008u)
#define CSL_USB_OTG_INTCLRR_EP3TX_SHIFT  (0x00000003u)
#define CSL_USB_OTG_INTCLRR_EP3TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP2TX_MASK   (0x00000004u)
#define CSL_USB_OTG_INTCLRR_EP2TX_SHIFT  (0x00000002u)
#define CSL_USB_OTG_INTCLRR_EP2TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP1TX_MASK   (0x00000002u)
#define CSL_USB_OTG_INTCLRR_EP1TX_SHIFT  (0x00000001u)
#define CSL_USB_OTG_INTCLRR_EP1TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_EP0_MASK     (0x00000001u)
#define CSL_USB_OTG_INTCLRR_EP0_SHIFT    (0x00000000u)
#define CSL_USB_OTG_INTCLRR_EP0_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTCLRR_RESETVAL     (0x00000000u)

/* INTMSKR */

#define CSL_USB_OTG_INTMSKR_RSV3_MASK    (0xFE000000u)
#define CSL_USB_OTG_INTMSKR_RSV3_SHIFT   (0x00000019u)
#define CSL_USB_OTG_INTMSKR_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_DRVVBUS_MASK (0x01000000u)
#define CSL_USB_OTG_INTMSKR_DRVVBUS_SHIFT (0x00000018u)
#define CSL_USB_OTG_INTMSKR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_VBUSINVALID_MASK (0x00800000u)
#define CSL_USB_OTG_INTMSKR_VBUSINVALID_SHIFT (0x00000017u)
#define CSL_USB_OTG_INTMSKR_VBUSINVALID_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_SRP_MASK     (0x00400000u)
#define CSL_USB_OTG_INTMSKR_SRP_SHIFT    (0x00000016u)
#define CSL_USB_OTG_INTMSKR_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_DISCONNECT_MASK (0x00200000u)
#define CSL_USB_OTG_INTMSKR_DISCONNECT_SHIFT (0x00000015u)
#define CSL_USB_OTG_INTMSKR_DISCONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_CONNECT_MASK (0x00100000u)
#define CSL_USB_OTG_INTMSKR_CONNECT_SHIFT (0x00000014u)
#define CSL_USB_OTG_INTMSKR_CONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_SOF_MASK     (0x00080000u)
#define CSL_USB_OTG_INTMSKR_SOF_SHIFT    (0x00000013u)
#define CSL_USB_OTG_INTMSKR_SOF_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_RESET_BABBLE_MASK (0x00040000u)
#define CSL_USB_OTG_INTMSKR_RESET_BABBLE_SHIFT (0x00000012u)
#define CSL_USB_OTG_INTMSKR_RESET_BABBLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_RESUME_MASK  (0x00020000u)
#define CSL_USB_OTG_INTMSKR_RESUME_SHIFT (0x00000011u)
#define CSL_USB_OTG_INTMSKR_RESUME_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_SUSPEND_MASK (0x00010000u)
#define CSL_USB_OTG_INTMSKR_SUSPEND_SHIFT (0x00000010u)
#define CSL_USB_OTG_INTMSKR_SUSPEND_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_RSV2_MASK    (0x0000E000u)
#define CSL_USB_OTG_INTMSKR_RSV2_SHIFT   (0x0000000Du)
#define CSL_USB_OTG_INTMSKR_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP4RX_MASK   (0x00001000u)
#define CSL_USB_OTG_INTMSKR_EP4RX_SHIFT  (0x0000000Cu)
#define CSL_USB_OTG_INTMSKR_EP4RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP3RX_MASK   (0x00000800u)
#define CSL_USB_OTG_INTMSKR_EP3RX_SHIFT  (0x0000000Bu)
#define CSL_USB_OTG_INTMSKR_EP3RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP2RX_MASK   (0x00000400u)
#define CSL_USB_OTG_INTMSKR_EP2RX_SHIFT  (0x0000000Au)
#define CSL_USB_OTG_INTMSKR_EP2RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP1RX_MASK   (0x00000200u)
#define CSL_USB_OTG_INTMSKR_EP1RX_SHIFT  (0x00000009u)
#define CSL_USB_OTG_INTMSKR_EP1RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_RSV1_MASK    (0x000001E0u)
#define CSL_USB_OTG_INTMSKR_RSV1_SHIFT   (0x00000005u)
#define CSL_USB_OTG_INTMSKR_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP4TX_MASK   (0x00000010u)
#define CSL_USB_OTG_INTMSKR_EP4TX_SHIFT  (0x00000004u)
#define CSL_USB_OTG_INTMSKR_EP4TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP3TX_MASK   (0x00000008u)
#define CSL_USB_OTG_INTMSKR_EP3TX_SHIFT  (0x00000003u)
#define CSL_USB_OTG_INTMSKR_EP3TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP2TX_MASK   (0x00000004u)
#define CSL_USB_OTG_INTMSKR_EP2TX_SHIFT  (0x00000002u)
#define CSL_USB_OTG_INTMSKR_EP2TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP1TX_MASK   (0x00000002u)
#define CSL_USB_OTG_INTMSKR_EP1TX_SHIFT  (0x00000001u)
#define CSL_USB_OTG_INTMSKR_EP1TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_EP0_MASK     (0x00000001u)
#define CSL_USB_OTG_INTMSKR_EP0_SHIFT    (0x00000000u)
#define CSL_USB_OTG_INTMSKR_EP0_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKR_RESETVAL     (0x00000000u)

/* INTMSKSETR */

#define CSL_USB_OTG_INTMSKSETR_RSV3_MASK (0xFE000000u)
#define CSL_USB_OTG_INTMSKSETR_RSV3_SHIFT (0x00000019u)
#define CSL_USB_OTG_INTMSKSETR_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_DRVVBUS_MASK (0x01000000u)
#define CSL_USB_OTG_INTMSKSETR_DRVVBUS_SHIFT (0x00000018u)
#define CSL_USB_OTG_INTMSKSETR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_VBUSINVALID_MASK (0x00800000u)
#define CSL_USB_OTG_INTMSKSETR_VBUSINVALID_SHIFT (0x00000017u)
#define CSL_USB_OTG_INTMSKSETR_VBUSINVALID_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_SRP_MASK  (0x00400000u)
#define CSL_USB_OTG_INTMSKSETR_SRP_SHIFT (0x00000016u)
#define CSL_USB_OTG_INTMSKSETR_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_DISCONNECT_MASK (0x00200000u)
#define CSL_USB_OTG_INTMSKSETR_DISCONNECT_SHIFT (0x00000015u)
#define CSL_USB_OTG_INTMSKSETR_DISCONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_CONNECT_MASK (0x00100000u)
#define CSL_USB_OTG_INTMSKSETR_CONNECT_SHIFT (0x00000014u)
#define CSL_USB_OTG_INTMSKSETR_CONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_SOF_MASK  (0x00080000u)
#define CSL_USB_OTG_INTMSKSETR_SOF_SHIFT (0x00000013u)
#define CSL_USB_OTG_INTMSKSETR_SOF_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_RESET_BABBLE_MASK (0x00040000u)
#define CSL_USB_OTG_INTMSKSETR_RESET_BABBLE_SHIFT (0x00000012u)
#define CSL_USB_OTG_INTMSKSETR_RESET_BABBLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_RESUME_MASK (0x00020000u)
#define CSL_USB_OTG_INTMSKSETR_RESUME_SHIFT (0x00000011u)
#define CSL_USB_OTG_INTMSKSETR_RESUME_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_SUSPEND_MASK (0x00010000u)
#define CSL_USB_OTG_INTMSKSETR_SUSPEND_SHIFT (0x00000010u)
#define CSL_USB_OTG_INTMSKSETR_SUSPEND_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_RSV2_MASK (0x0000E000u)
#define CSL_USB_OTG_INTMSKSETR_RSV2_SHIFT (0x0000000Du)
#define CSL_USB_OTG_INTMSKSETR_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP4RX_MASK (0x00001000u)
#define CSL_USB_OTG_INTMSKSETR_EP4RX_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_INTMSKSETR_EP4RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP3RX_MASK (0x00000800u)
#define CSL_USB_OTG_INTMSKSETR_EP3RX_SHIFT (0x0000000Bu)
#define CSL_USB_OTG_INTMSKSETR_EP3RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP2RX_MASK (0x00000400u)
#define CSL_USB_OTG_INTMSKSETR_EP2RX_SHIFT (0x0000000Au)
#define CSL_USB_OTG_INTMSKSETR_EP2RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP1RX_MASK (0x00000200u)
#define CSL_USB_OTG_INTMSKSETR_EP1RX_SHIFT (0x00000009u)
#define CSL_USB_OTG_INTMSKSETR_EP1RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_RSV1_MASK (0x000001E0u)
#define CSL_USB_OTG_INTMSKSETR_RSV1_SHIFT (0x00000005u)
#define CSL_USB_OTG_INTMSKSETR_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP4TX_MASK (0x00000010u)
#define CSL_USB_OTG_INTMSKSETR_EP4TX_SHIFT (0x00000004u)
#define CSL_USB_OTG_INTMSKSETR_EP4TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP3TX_MASK (0x00000008u)
#define CSL_USB_OTG_INTMSKSETR_EP3TX_SHIFT (0x00000003u)
#define CSL_USB_OTG_INTMSKSETR_EP3TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP2TX_MASK (0x00000004u)
#define CSL_USB_OTG_INTMSKSETR_EP2TX_SHIFT (0x00000002u)
#define CSL_USB_OTG_INTMSKSETR_EP2TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP1TX_MASK (0x00000002u)
#define CSL_USB_OTG_INTMSKSETR_EP1TX_SHIFT (0x00000001u)
#define CSL_USB_OTG_INTMSKSETR_EP1TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_EP0_MASK  (0x00000001u)
#define CSL_USB_OTG_INTMSKSETR_EP0_SHIFT (0x00000000u)
#define CSL_USB_OTG_INTMSKSETR_EP0_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKSETR_RESETVAL  (0x00000000u)

/* INTMSKCLRR */

#define CSL_USB_OTG_INTMSKCLRR_RSV3_MASK (0xFE000000u)
#define CSL_USB_OTG_INTMSKCLRR_RSV3_SHIFT (0x00000019u)
#define CSL_USB_OTG_INTMSKCLRR_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_DRVVBUS_MASK (0x01000000u)
#define CSL_USB_OTG_INTMSKCLRR_DRVVBUS_SHIFT (0x00000018u)
#define CSL_USB_OTG_INTMSKCLRR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_VBUSINVALID_MASK (0x00800000u)
#define CSL_USB_OTG_INTMSKCLRR_VBUSINVALID_SHIFT (0x00000017u)
#define CSL_USB_OTG_INTMSKCLRR_VBUSINVALID_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_SRP_MASK  (0x00400000u)
#define CSL_USB_OTG_INTMSKCLRR_SRP_SHIFT (0x00000016u)
#define CSL_USB_OTG_INTMSKCLRR_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_DISCONNECT_MASK (0x00200000u)
#define CSL_USB_OTG_INTMSKCLRR_DISCONNECT_SHIFT (0x00000015u)
#define CSL_USB_OTG_INTMSKCLRR_DISCONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_CONNECT_MASK (0x00100000u)
#define CSL_USB_OTG_INTMSKCLRR_CONNECT_SHIFT (0x00000014u)
#define CSL_USB_OTG_INTMSKCLRR_CONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_SOF_MASK  (0x00080000u)
#define CSL_USB_OTG_INTMSKCLRR_SOF_SHIFT (0x00000013u)
#define CSL_USB_OTG_INTMSKCLRR_SOF_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_RESET_BABBLE_MASK (0x00040000u)
#define CSL_USB_OTG_INTMSKCLRR_RESET_BABBLE_SHIFT (0x00000012u)
#define CSL_USB_OTG_INTMSKCLRR_RESET_BABBLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_RESUME_MASK (0x00020000u)
#define CSL_USB_OTG_INTMSKCLRR_RESUME_SHIFT (0x00000011u)
#define CSL_USB_OTG_INTMSKCLRR_RESUME_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_SUSPEND_MASK (0x00010000u)
#define CSL_USB_OTG_INTMSKCLRR_SUSPEND_SHIFT (0x00000010u)
#define CSL_USB_OTG_INTMSKCLRR_SUSPEND_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_RSV2_MASK (0x0000E000u)
#define CSL_USB_OTG_INTMSKCLRR_RSV2_SHIFT (0x0000000Du)
#define CSL_USB_OTG_INTMSKCLRR_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP4RX_MASK (0x00001000u)
#define CSL_USB_OTG_INTMSKCLRR_EP4RX_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_INTMSKCLRR_EP4RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP3RX_MASK (0x00000800u)
#define CSL_USB_OTG_INTMSKCLRR_EP3RX_SHIFT (0x0000000Bu)
#define CSL_USB_OTG_INTMSKCLRR_EP3RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP2RX_MASK (0x00000400u)
#define CSL_USB_OTG_INTMSKCLRR_EP2RX_SHIFT (0x0000000Au)
#define CSL_USB_OTG_INTMSKCLRR_EP2RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP1RX_MASK (0x00000200u)
#define CSL_USB_OTG_INTMSKCLRR_EP1RX_SHIFT (0x00000009u)
#define CSL_USB_OTG_INTMSKCLRR_EP1RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_RSV1_MASK (0x000001E0u)
#define CSL_USB_OTG_INTMSKCLRR_RSV1_SHIFT (0x00000005u)
#define CSL_USB_OTG_INTMSKCLRR_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP4TX_MASK (0x00000010u)
#define CSL_USB_OTG_INTMSKCLRR_EP4TX_SHIFT (0x00000004u)
#define CSL_USB_OTG_INTMSKCLRR_EP4TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP3TX_MASK (0x00000008u)
#define CSL_USB_OTG_INTMSKCLRR_EP3TX_SHIFT (0x00000003u)
#define CSL_USB_OTG_INTMSKCLRR_EP3TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP2TX_MASK (0x00000004u)
#define CSL_USB_OTG_INTMSKCLRR_EP2TX_SHIFT (0x00000002u)
#define CSL_USB_OTG_INTMSKCLRR_EP2TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP1TX_MASK (0x00000002u)
#define CSL_USB_OTG_INTMSKCLRR_EP1TX_SHIFT (0x00000001u)
#define CSL_USB_OTG_INTMSKCLRR_EP1TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_EP0_MASK  (0x00000001u)
#define CSL_USB_OTG_INTMSKCLRR_EP0_SHIFT (0x00000000u)
#define CSL_USB_OTG_INTMSKCLRR_EP0_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMSKCLRR_RESETVAL  (0x00000000u)

/* INTMASKEDR */

#define CSL_USB_OTG_INTMASKEDR_RSV3_MASK (0xFE000000u)
#define CSL_USB_OTG_INTMASKEDR_RSV3_SHIFT (0x00000019u)
#define CSL_USB_OTG_INTMASKEDR_RSV3_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_DRVVBUS_MASK (0x01000000u)
#define CSL_USB_OTG_INTMASKEDR_DRVVBUS_SHIFT (0x00000018u)
#define CSL_USB_OTG_INTMASKEDR_DRVVBUS_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_VBUSINVALID_MASK (0x00800000u)
#define CSL_USB_OTG_INTMASKEDR_VBUSINVALID_SHIFT (0x00000017u)
#define CSL_USB_OTG_INTMASKEDR_VBUSINVALID_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_SRP_MASK  (0x00400000u)
#define CSL_USB_OTG_INTMASKEDR_SRP_SHIFT (0x00000016u)
#define CSL_USB_OTG_INTMASKEDR_SRP_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_DISCONNECT_MASK (0x00200000u)
#define CSL_USB_OTG_INTMASKEDR_DISCONNECT_SHIFT (0x00000015u)
#define CSL_USB_OTG_INTMASKEDR_DISCONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_CONNECT_MASK (0x00100000u)
#define CSL_USB_OTG_INTMASKEDR_CONNECT_SHIFT (0x00000014u)
#define CSL_USB_OTG_INTMASKEDR_CONNECT_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_SOF_MASK  (0x00080000u)
#define CSL_USB_OTG_INTMASKEDR_SOF_SHIFT (0x00000013u)
#define CSL_USB_OTG_INTMASKEDR_SOF_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_RESET_BABBLE_MASK (0x00040000u)
#define CSL_USB_OTG_INTMASKEDR_RESET_BABBLE_SHIFT (0x00000012u)
#define CSL_USB_OTG_INTMASKEDR_RESET_BABBLE_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_RESUME_MASK (0x00020000u)
#define CSL_USB_OTG_INTMASKEDR_RESUME_SHIFT (0x00000011u)
#define CSL_USB_OTG_INTMASKEDR_RESUME_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_SUSPEND_MASK (0x00010000u)
#define CSL_USB_OTG_INTMASKEDR_SUSPEND_SHIFT (0x00000010u)
#define CSL_USB_OTG_INTMASKEDR_SUSPEND_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_RSV2_MASK (0x0000E000u)
#define CSL_USB_OTG_INTMASKEDR_RSV2_SHIFT (0x0000000Du)
#define CSL_USB_OTG_INTMASKEDR_RSV2_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP4RX_MASK (0x00001000u)
#define CSL_USB_OTG_INTMASKEDR_EP4RX_SHIFT (0x0000000Cu)
#define CSL_USB_OTG_INTMASKEDR_EP4RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP3RX_MASK (0x00000800u)
#define CSL_USB_OTG_INTMASKEDR_EP3RX_SHIFT (0x0000000Bu)
#define CSL_USB_OTG_INTMASKEDR_EP3RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP2RX_MASK (0x00000400u)
#define CSL_USB_OTG_INTMASKEDR_EP2RX_SHIFT (0x0000000Au)
#define CSL_USB_OTG_INTMASKEDR_EP2RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP1RX_MASK (0x00000200u)
#define CSL_USB_OTG_INTMASKEDR_EP1RX_SHIFT (0x00000009u)
#define CSL_USB_OTG_INTMASKEDR_EP1RX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_RSV1_MASK (0x000001E0u)
#define CSL_USB_OTG_INTMASKEDR_RSV1_SHIFT (0x00000005u)
#define CSL_USB_OTG_INTMASKEDR_RSV1_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP4TX_MASK (0x00000010u)
#define CSL_USB_OTG_INTMASKEDR_EP4TX_SHIFT (0x00000004u)
#define CSL_USB_OTG_INTMASKEDR_EP4TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP3TX_MASK (0x00000008u)
#define CSL_USB_OTG_INTMASKEDR_EP3TX_SHIFT (0x00000003u)
#define CSL_USB_OTG_INTMASKEDR_EP3TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP2TX_MASK (0x00000004u)
#define CSL_USB_OTG_INTMASKEDR_EP2TX_SHIFT (0x00000002u)
#define CSL_USB_OTG_INTMASKEDR_EP2TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP1TX_MASK (0x00000002u)
#define CSL_USB_OTG_INTMASKEDR_EP1TX_SHIFT (0x00000001u)
#define CSL_USB_OTG_INTMASKEDR_EP1TX_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_EP0_MASK  (0x00000001u)
#define CSL_USB_OTG_INTMASKEDR_EP0_SHIFT (0x00000000u)
#define CSL_USB_OTG_INTMASKEDR_EP0_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTMASKEDR_RESETVAL  (0x00000000u)

/* EOIR */

#define CSL_USB_OTG_EOIR_RSV1_MASK       (0xFFFFFF00u)
#define CSL_USB_OTG_EOIR_RSV1_SHIFT      (0x00000008u)
#define CSL_USB_OTG_EOIR_RSV1_RESETVAL   (0x00000000u)

#define CSL_USB_OTG_EOIR_EOI_VECTOR_MASK (0x000000FFu)
#define CSL_USB_OTG_EOIR_EOI_VECTOR_SHIFT (0x00000000u)
#define CSL_USB_OTG_EOIR_EOI_VECTOR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_EOIR_RESETVAL        (0x00000000u)

/* INTVECTR */

#define CSL_USB_OTG_INTVECTR_VECTOR_MASK (0xFFFFFFFFu)
#define CSL_USB_OTG_INTVECTR_VECTOR_SHIFT (0x00000000u)
#define CSL_USB_OTG_INTVECTR_VECTOR_RESETVAL (0x00000000u)

#define CSL_USB_OTG_INTVECTR_RESETVAL    (0x00000000u)

/* FADDR */

#define CSL_USB_OTG_FADDR_FUNCADDR_MASK  (0x7Fu)
#define CSL_USB_OTG_FADDR_FUNCADDR_SHIFT (0x00u)
#define CSL_USB_OTG_FADDR_FUNCADDR_RESETVAL (0x00u)

#define CSL_USB_OTG_FADDR_RESETVAL       (0x00u)

/* POWER */

#define CSL_USB_OTG_POWER_ISOUPDATE_MASK (0x80u)
#define CSL_USB_OTG_POWER_ISOUPDATE_SHIFT (0x07u)
#define CSL_USB_OTG_POWER_ISOUPDATE_RESETVAL (0x00u)

#define CSL_USB_OTG_POWER_SOFTCONN_MASK  (0x40u)
#define CSL_USB_OTG_POWER_SOFTCONN_SHIFT (0x06u)
#define CSL_USB_OTG_POWER_SOFTCONN_RESETVAL (0x00u)

#define CSL_USB_OTG_POWER_HSEN_MASK      (0x20u)
#define CSL_USB_OTG_POWER_HSEN_SHIFT     (0x05u)
#define CSL_USB_OTG_POWER_HSEN_RESETVAL  (0x01u)

#define CSL_USB_OTG_POWER_HSMODE_MASK    (0x10u)
#define CSL_USB_OTG_POWER_HSMODE_SHIFT   (0x04u)
#define CSL_USB_OTG_POWER_HSMODE_RESETVAL (0x00u)

#define CSL_USB_OTG_POWER_RESET_MASK     (0x08u)
#define CSL_USB_OTG_POWER_RESET_SHIFT    (0x03u)
#define CSL_USB_OTG_POWER_RESET_RESETVAL (0x00u)

#define CSL_USB_OTG_POWER_RESUME_MASK    (0x04u)
#define CSL_USB_OTG_POWER_RESUME_SHIFT   (0x02u)
#define CSL_USB_OTG_POWER_RESUME_RESETVAL (0x00u)

#define CSL_USB_OTG_POWER_SUSPENDM_MASK  (0x02u)
#define CSL_USB_OTG_POWER_SUSPENDM_SHIFT (0x01u)
#define CSL_USB_OTG_POWER_SUSPENDM_RESETVAL (0x00u)

#define CSL_USB_OTG_POWER_ENSUSPM_MASK   (0x01u)
#define CSL_USB_OTG_POWER_ENSUSPM_SHIFT  (0x00u)
#define CSL_USB_OTG_POWER_ENSUSPM_RESETVAL (0x00u)

#define CSL_USB_OTG_POWER_RESETVAL       (0x20u)

/* INTRTX */

#define CSL_USB_OTG_INTRTX_RSV_MASK      (0xFFE0u)
#define CSL_USB_OTG_INTRTX_RSV_SHIFT     (0x0005u)
#define CSL_USB_OTG_INTRTX_RSV_RESETVAL  (0x0000u)

#define CSL_USB_OTG_INTRTX_EP4TX_MASK    (0x0010u)
#define CSL_USB_OTG_INTRTX_EP4TX_SHIFT   (0x0004u)
#define CSL_USB_OTG_INTRTX_EP4TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTX_EP3TX_MASK    (0x0008u)
#define CSL_USB_OTG_INTRTX_EP3TX_SHIFT   (0x0003u)
#define CSL_USB_OTG_INTRTX_EP3TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTX_EP2TX_MASK    (0x0004u)
#define CSL_USB_OTG_INTRTX_EP2TX_SHIFT   (0x0002u)
#define CSL_USB_OTG_INTRTX_EP2TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTX_EP1TX_MASK    (0x0002u)
#define CSL_USB_OTG_INTRTX_EP1TX_SHIFT   (0x0001u)
#define CSL_USB_OTG_INTRTX_EP1TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTX_EP0_MASK      (0x0001u)
#define CSL_USB_OTG_INTRTX_EP0_SHIFT     (0x0000u)
#define CSL_USB_OTG_INTRTX_EP0_RESETVAL  (0x0000u)

#define CSL_USB_OTG_INTRTX_RESETVAL      (0x0000u)

/* INTRRX */

#define CSL_USB_OTG_INTRRX_RSV1_MASK     (0xFFE0u)
#define CSL_USB_OTG_INTRRX_RSV1_SHIFT    (0x0005u)
#define CSL_USB_OTG_INTRRX_RSV1_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRX_EP4RX_MASK    (0x0010u)
#define CSL_USB_OTG_INTRRX_EP4RX_SHIFT   (0x0004u)
#define CSL_USB_OTG_INTRRX_EP4RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRX_EP3RX_MASK    (0x0008u)
#define CSL_USB_OTG_INTRRX_EP3RX_SHIFT   (0x0003u)
#define CSL_USB_OTG_INTRRX_EP3RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRX_EP2RX_MASK    (0x0004u)
#define CSL_USB_OTG_INTRRX_EP2RX_SHIFT   (0x0002u)
#define CSL_USB_OTG_INTRRX_EP2RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRX_EP1RX_MASK    (0x0002u)
#define CSL_USB_OTG_INTRRX_EP1RX_SHIFT   (0x0001u)
#define CSL_USB_OTG_INTRRX_EP1RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRX_RSV0_MASK     (0x0001u)
#define CSL_USB_OTG_INTRRX_RSV0_SHIFT    (0x0000u)
#define CSL_USB_OTG_INTRRX_RSV0_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRX_RESETVAL      (0x0000u)

/* INTRTXE */

#define CSL_USB_OTG_INTRTXE_RSV_MASK     (0xFFE0u)
#define CSL_USB_OTG_INTRTXE_RSV_SHIFT    (0x0005u)
#define CSL_USB_OTG_INTRTXE_RSV_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTXE_EP4TX_MASK   (0x0010u)
#define CSL_USB_OTG_INTRTXE_EP4TX_SHIFT  (0x0004u)
#define CSL_USB_OTG_INTRTXE_EP4TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTXE_EP3TX_MASK   (0x0008u)
#define CSL_USB_OTG_INTRTXE_EP3TX_SHIFT  (0x0003u)
#define CSL_USB_OTG_INTRTXE_EP3TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTXE_EP2TX_MASK   (0x0004u)
#define CSL_USB_OTG_INTRTXE_EP2TX_SHIFT  (0x0002u)
#define CSL_USB_OTG_INTRTXE_EP2TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTXE_EP1TX_MASK   (0x0002u)
#define CSL_USB_OTG_INTRTXE_EP1TX_SHIFT  (0x0001u)
#define CSL_USB_OTG_INTRTXE_EP1TX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTXE_EP0_MASK     (0x0001u)
#define CSL_USB_OTG_INTRTXE_EP0_SHIFT    (0x0000u)
#define CSL_USB_OTG_INTRTXE_EP0_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRTXE_RESETVAL     (0x0000u)

/* INTRRXE */

#define CSL_USB_OTG_INTRRXE_RSV1_MASK    (0xFFE0u)
#define CSL_USB_OTG_INTRRXE_RSV1_SHIFT   (0x0005u)
#define CSL_USB_OTG_INTRRXE_RSV1_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRXE_EP4RX_MASK   (0x0010u)
#define CSL_USB_OTG_INTRRXE_EP4RX_SHIFT  (0x0004u)
#define CSL_USB_OTG_INTRRXE_EP4RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRXE_EP3RX_MASK   (0x0008u)
#define CSL_USB_OTG_INTRRXE_EP3RX_SHIFT  (0x0003u)
#define CSL_USB_OTG_INTRRXE_EP3RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRXE_EP2RX_MASK   (0x0004u)
#define CSL_USB_OTG_INTRRXE_EP2RX_SHIFT  (0x0002u)
#define CSL_USB_OTG_INTRRXE_EP2RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRXE_EP1RX_MASK   (0x0002u)
#define CSL_USB_OTG_INTRRXE_EP1RX_SHIFT  (0x0001u)
#define CSL_USB_OTG_INTRRXE_EP1RX_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRXE_RSV0_MASK    (0x0001u)
#define CSL_USB_OTG_INTRRXE_RSV0_SHIFT   (0x0000u)
#define CSL_USB_OTG_INTRRXE_RSV0_RESETVAL (0x0000u)

#define CSL_USB_OTG_INTRRXE_RESETVAL     (0x0000u)

/* INTRUSB */

#define CSL_USB_OTG_INTRUSB_VBUSERR_MASK (0x80u)
#define CSL_USB_OTG_INTRUSB_VBUSERR_SHIFT (0x07u)
#define CSL_USB_OTG_INTRUSB_VBUSERR_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_SESSREQ_MASK (0x40u)
#define CSL_USB_OTG_INTRUSB_SESSREQ_SHIFT (0x06u)
#define CSL_USB_OTG_INTRUSB_SESSREQ_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_DISCON_MASK  (0x20u)
#define CSL_USB_OTG_INTRUSB_DISCON_SHIFT (0x05u)
#define CSL_USB_OTG_INTRUSB_DISCON_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_CONN_MASK    (0x10u)
#define CSL_USB_OTG_INTRUSB_CONN_SHIFT   (0x04u)
#define CSL_USB_OTG_INTRUSB_CONN_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_SOF_MASK     (0x08u)
#define CSL_USB_OTG_INTRUSB_SOF_SHIFT    (0x03u)
#define CSL_USB_OTG_INTRUSB_SOF_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_RESET_BABBLE_MASK (0x04u)
#define CSL_USB_OTG_INTRUSB_RESET_BABBLE_SHIFT (0x02u)
#define CSL_USB_OTG_INTRUSB_RESET_BABBLE_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_RESUME_MASK  (0x02u)
#define CSL_USB_OTG_INTRUSB_RESUME_SHIFT (0x01u)
#define CSL_USB_OTG_INTRUSB_RESUME_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_SUSPEND_MASK (0x01u)
#define CSL_USB_OTG_INTRUSB_SUSPEND_SHIFT (0x00u)
#define CSL_USB_OTG_INTRUSB_SUSPEND_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSB_RESETVAL     (0x00u)

/* INTRUSBE */

#define CSL_USB_OTG_INTRUSBE_VBUSERR_MASK (0x80u)
#define CSL_USB_OTG_INTRUSBE_VBUSERR_SHIFT (0x07u)
#define CSL_USB_OTG_INTRUSBE_VBUSERR_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_SESSREQ_MASK (0x40u)
#define CSL_USB_OTG_INTRUSBE_SESSREQ_SHIFT (0x06u)
#define CSL_USB_OTG_INTRUSBE_SESSREQ_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_DISCON_MASK (0x20u)
#define CSL_USB_OTG_INTRUSBE_DISCON_SHIFT (0x05u)
#define CSL_USB_OTG_INTRUSBE_DISCON_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_CONN_MASK   (0x10u)
#define CSL_USB_OTG_INTRUSBE_CONN_SHIFT  (0x04u)
#define CSL_USB_OTG_INTRUSBE_CONN_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_SOF_MASK    (0x08u)
#define CSL_USB_OTG_INTRUSBE_SOF_SHIFT   (0x03u)
#define CSL_USB_OTG_INTRUSBE_SOF_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_RESET_BABBLE_MASK (0x04u)
#define CSL_USB_OTG_INTRUSBE_RESET_BABBLE_SHIFT (0x02u)
#define CSL_USB_OTG_INTRUSBE_RESET_BABBLE_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_RESUME_MASK (0x02u)
#define CSL_USB_OTG_INTRUSBE_RESUME_SHIFT (0x01u)
#define CSL_USB_OTG_INTRUSBE_RESUME_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_SUSPEND_MASK (0x01u)
#define CSL_USB_OTG_INTRUSBE_SUSPEND_SHIFT (0x00u)
#define CSL_USB_OTG_INTRUSBE_SUSPEND_RESETVAL (0x00u)

#define CSL_USB_OTG_INTRUSBE_RESETVAL    (0x00u)

/* FRAME */

#define CSL_USB_OTG_FRAME_FRAMENUMBER_MASK (0x07FFu)
#define CSL_USB_OTG_FRAME_FRAMENUMBER_SHIFT (0x0000u)
#define CSL_USB_OTG_FRAME_FRAMENUMBER_RESETVAL (0x0000u)

#define CSL_USB_OTG_FRAME_RESETVAL       (0x0000u)

/* INDEX */

#define CSL_USB_OTG_INDEX_EPSEL_MASK     (0x0Fu)
#define CSL_USB_OTG_INDEX_EPSEL_SHIFT    (0x00u)
#define CSL_USB_OTG_INDEX_EPSEL_RESETVAL (0x00u)
/*----EPSEL Tokens----*/
#define CSL_USB_OTG_INDEX_EPSEL_EP0      (0x00u)
#define CSL_USB_OTG_INDEX_EPSEL_EP0      (0x00u)
#define CSL_USB_OTG_INDEX_EPSEL_EP1      (0x01u)
#define CSL_USB_OTG_INDEX_EPSEL_EP2      (0x02u)
#define CSL_USB_OTG_INDEX_EPSEL_EP3      (0x03u)
#define CSL_USB_OTG_INDEX_EPSEL_EP4      (0x04u)

#define CSL_USB_OTG_INDEX_RESETVAL       (0x00u)

/* TESTMODE */

#define CSL_USB_OTG_TESTMODE_FORCE_HOST_MASK (0x80u)
#define CSL_USB_OTG_TESTMODE_FORCE_HOST_SHIFT (0x07u)
#define CSL_USB_OTG_TESTMODE_FORCE_HOST_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_FIFO_ACCESS_MASK (0x40u)
#define CSL_USB_OTG_TESTMODE_FIFO_ACCESS_SHIFT (0x06u)
#define CSL_USB_OTG_TESTMODE_FIFO_ACCESS_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_FORCE_FS_MASK (0x20u)
#define CSL_USB_OTG_TESTMODE_FORCE_FS_SHIFT (0x05u)
#define CSL_USB_OTG_TESTMODE_FORCE_FS_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_FORCE_HS_MASK (0x10u)
#define CSL_USB_OTG_TESTMODE_FORCE_HS_SHIFT (0x04u)
#define CSL_USB_OTG_TESTMODE_FORCE_HS_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_TEST_PACKET_MASK (0x08u)
#define CSL_USB_OTG_TESTMODE_TEST_PACKET_SHIFT (0x03u)
#define CSL_USB_OTG_TESTMODE_TEST_PACKET_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_TEST_K_MASK (0x04u)
#define CSL_USB_OTG_TESTMODE_TEST_K_SHIFT (0x02u)
#define CSL_USB_OTG_TESTMODE_TEST_K_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_TEST_J_MASK (0x02u)
#define CSL_USB_OTG_TESTMODE_TEST_J_SHIFT (0x01u)
#define CSL_USB_OTG_TESTMODE_TEST_J_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_TEST_SE0_NAK_MASK (0x01u)
#define CSL_USB_OTG_TESTMODE_TEST_SE0_NAK_SHIFT (0x00u)
#define CSL_USB_OTG_TESTMODE_TEST_SE0_NAK_RESETVAL (0x00u)

#define CSL_USB_OTG_TESTMODE_RESETVAL    (0x00u)

/* TXMAXP */

#define CSL_USB_OTG_TXMAXP_MAXPAYLOAD_MASK (0x07FFu)
#define CSL_USB_OTG_TXMAXP_MAXPAYLOAD_SHIFT (0x0000u)
#define CSL_USB_OTG_TXMAXP_MAXPAYLOAD_RESETVAL (0x0000u)

#define CSL_USB_OTG_TXMAXP_RESETVAL      (0x0000u)

/* PERI_CSR0 */

#define CSL_USB_OTG_PERI_CSR0_RSV_MASK   (0xFE00u)
#define CSL_USB_OTG_PERI_CSR0_RSV_SHIFT  (0x0009u)
#define CSL_USB_OTG_PERI_CSR0_RSV_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_FLUSHFIFO_MASK (0x0100u)
#define CSL_USB_OTG_PERI_CSR0_FLUSHFIFO_SHIFT (0x0008u)
#define CSL_USB_OTG_PERI_CSR0_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_SERV_SETUPEND_MASK (0x0080u)
#define CSL_USB_OTG_PERI_CSR0_SERV_SETUPEND_SHIFT (0x0007u)
#define CSL_USB_OTG_PERI_CSR0_SERV_SETUPEND_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_SERV_RXPKTRDY_MASK (0x0040u)
#define CSL_USB_OTG_PERI_CSR0_SERV_RXPKTRDY_SHIFT (0x0006u)
#define CSL_USB_OTG_PERI_CSR0_SERV_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_SENDSTALL_MASK (0x0020u)
#define CSL_USB_OTG_PERI_CSR0_SENDSTALL_SHIFT (0x0005u)
#define CSL_USB_OTG_PERI_CSR0_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_SETUPEND_MASK (0x0010u)
#define CSL_USB_OTG_PERI_CSR0_SETUPEND_SHIFT (0x0004u)
#define CSL_USB_OTG_PERI_CSR0_SETUPEND_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_DATAEND_MASK (0x0008u)
#define CSL_USB_OTG_PERI_CSR0_DATAEND_SHIFT (0x0003u)
#define CSL_USB_OTG_PERI_CSR0_DATAEND_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_SENTSTALL_MASK (0x0004u)
#define CSL_USB_OTG_PERI_CSR0_SENTSTALL_SHIFT (0x0002u)
#define CSL_USB_OTG_PERI_CSR0_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_TXPKTRDY_MASK (0x0002u)
#define CSL_USB_OTG_PERI_CSR0_TXPKTRDY_SHIFT (0x0001u)
#define CSL_USB_OTG_PERI_CSR0_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_OTG_PERI_CSR0_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_OTG_PERI_CSR0_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_CSR0_RESETVAL   (0x0000u)

/* HOST_CSR0 */

#define CSL_USB_OTG_HOST_CSR0_RSV_MASK   (0xF000u)
#define CSL_USB_OTG_HOST_CSR0_RSV_SHIFT  (0x000Cu)
#define CSL_USB_OTG_HOST_CSR0_RSV_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_DISPING_MASK (0x0800u)
#define CSL_USB_OTG_HOST_CSR0_DISPING_SHIFT (0x000Bu)
#define CSL_USB_OTG_HOST_CSR0_DISPING_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_DATATOGWREN_MASK (0x0400u)
#define CSL_USB_OTG_HOST_CSR0_DATATOGWREN_SHIFT (0x000Au)
#define CSL_USB_OTG_HOST_CSR0_DATATOGWREN_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_DATATOG_MASK (0x0200u)
#define CSL_USB_OTG_HOST_CSR0_DATATOG_SHIFT (0x0009u)
#define CSL_USB_OTG_HOST_CSR0_DATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_FLUSHFIFO_MASK (0x0100u)
#define CSL_USB_OTG_HOST_CSR0_FLUSHFIFO_SHIFT (0x0008u)
#define CSL_USB_OTG_HOST_CSR0_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_NAK_TIMEOUT_MASK (0x0080u)
#define CSL_USB_OTG_HOST_CSR0_NAK_TIMEOUT_SHIFT (0x0007u)
#define CSL_USB_OTG_HOST_CSR0_NAK_TIMEOUT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_STATUSPKT_MASK (0x0040u)
#define CSL_USB_OTG_HOST_CSR0_STATUSPKT_SHIFT (0x0006u)
#define CSL_USB_OTG_HOST_CSR0_STATUSPKT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_REQPKT_MASK (0x0020u)
#define CSL_USB_OTG_HOST_CSR0_REQPKT_SHIFT (0x0005u)
#define CSL_USB_OTG_HOST_CSR0_REQPKT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_ERROR_MASK (0x0010u)
#define CSL_USB_OTG_HOST_CSR0_ERROR_SHIFT (0x0004u)
#define CSL_USB_OTG_HOST_CSR0_ERROR_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_SETUPPKT_MASK (0x0008u)
#define CSL_USB_OTG_HOST_CSR0_SETUPPKT_SHIFT (0x0003u)
#define CSL_USB_OTG_HOST_CSR0_SETUPPKT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_RXSTALL_MASK (0x0004u)
#define CSL_USB_OTG_HOST_CSR0_RXSTALL_SHIFT (0x0002u)
#define CSL_USB_OTG_HOST_CSR0_RXSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_TXPKTRDY_MASK (0x0002u)
#define CSL_USB_OTG_HOST_CSR0_TXPKTRDY_SHIFT (0x0001u)
#define CSL_USB_OTG_HOST_CSR0_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_OTG_HOST_CSR0_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_OTG_HOST_CSR0_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_CSR0_RESETVAL   (0x0000u)

/* HOST_TXCSR */

#define CSL_USB_OTG_HOST_TXCSR_AUTOSET_MASK (0x8000u)
#define CSL_USB_OTG_HOST_TXCSR_AUTOSET_SHIFT (0x000Fu)
#define CSL_USB_OTG_HOST_TXCSR_AUTOSET_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_RSV_MASK  (0x4000u)
#define CSL_USB_OTG_HOST_TXCSR_RSV_SHIFT (0x000Eu)
#define CSL_USB_OTG_HOST_TXCSR_RSV_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_MODE_MASK (0x2000u)
#define CSL_USB_OTG_HOST_TXCSR_MODE_SHIFT (0x000Du)
#define CSL_USB_OTG_HOST_TXCSR_MODE_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_DMAEN_MASK (0x1000u)
#define CSL_USB_OTG_HOST_TXCSR_DMAEN_SHIFT (0x000Cu)
#define CSL_USB_OTG_HOST_TXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_FRCDATATOG_MASK (0x0800u)
#define CSL_USB_OTG_HOST_TXCSR_FRCDATATOG_SHIFT (0x000Bu)
#define CSL_USB_OTG_HOST_TXCSR_FRCDATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_DMAMODE_MASK (0x0400u)
#define CSL_USB_OTG_HOST_TXCSR_DMAMODE_SHIFT (0x000Au)
#define CSL_USB_OTG_HOST_TXCSR_DMAMODE_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_DATATOGWREN_MASK (0x0200u)
#define CSL_USB_OTG_HOST_TXCSR_DATATOGWREN_SHIFT (0x0009u)
#define CSL_USB_OTG_HOST_TXCSR_DATATOGWREN_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_DATATOG_MASK (0x0100u)
#define CSL_USB_OTG_HOST_TXCSR_DATATOG_SHIFT (0x0008u)
#define CSL_USB_OTG_HOST_TXCSR_DATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_NAK_TIMEOUT_MASK (0x0080u)
#define CSL_USB_OTG_HOST_TXCSR_NAK_TIMEOUT_SHIFT (0x0007u)
#define CSL_USB_OTG_HOST_TXCSR_NAK_TIMEOUT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_CLRDATATOG_MASK (0x0040u)
#define CSL_USB_OTG_HOST_TXCSR_CLRDATATOG_SHIFT (0x0006u)
#define CSL_USB_OTG_HOST_TXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_RXSTALL_MASK (0x0020u)
#define CSL_USB_OTG_HOST_TXCSR_RXSTALL_SHIFT (0x0005u)
#define CSL_USB_OTG_HOST_TXCSR_RXSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_SETUPPKT_MASK (0x0010u)
#define CSL_USB_OTG_HOST_TXCSR_SETUPPKT_SHIFT (0x0004u)
#define CSL_USB_OTG_HOST_TXCSR_SETUPPKT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_FLUSHFIFO_MASK (0x0008u)
#define CSL_USB_OTG_HOST_TXCSR_FLUSHFIFO_SHIFT (0x0003u)
#define CSL_USB_OTG_HOST_TXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_ERROR_MASK (0x0004u)
#define CSL_USB_OTG_HOST_TXCSR_ERROR_SHIFT (0x0002u)
#define CSL_USB_OTG_HOST_TXCSR_ERROR_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_FIFONOTEMPTY_MASK (0x0002u)
#define CSL_USB_OTG_HOST_TXCSR_FIFONOTEMPTY_SHIFT (0x0001u)
#define CSL_USB_OTG_HOST_TXCSR_FIFONOTEMPTY_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_TXPKTRDY_MASK (0x0001u)
#define CSL_USB_OTG_HOST_TXCSR_TXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_OTG_HOST_TXCSR_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_TXCSR_RESETVAL  (0x0000u)

/* PERI_TXCSR */

#define CSL_USB_OTG_PERI_TXCSR_AUTOSET_MASK (0x8000u)
#define CSL_USB_OTG_PERI_TXCSR_AUTOSET_SHIFT (0x000Fu)
#define CSL_USB_OTG_PERI_TXCSR_AUTOSET_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_ISO_MASK  (0x4000u)
#define CSL_USB_OTG_PERI_TXCSR_ISO_SHIFT (0x000Eu)
#define CSL_USB_OTG_PERI_TXCSR_ISO_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_MODE_MASK (0x2000u)
#define CSL_USB_OTG_PERI_TXCSR_MODE_SHIFT (0x000Du)
#define CSL_USB_OTG_PERI_TXCSR_MODE_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_DMAEN_MASK (0x1000u)
#define CSL_USB_OTG_PERI_TXCSR_DMAEN_SHIFT (0x000Cu)
#define CSL_USB_OTG_PERI_TXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_FRCDATATOG_MASK (0x0800u)
#define CSL_USB_OTG_PERI_TXCSR_FRCDATATOG_SHIFT (0x000Bu)
#define CSL_USB_OTG_PERI_TXCSR_FRCDATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_DMAMODE_MASK (0x0400u)
#define CSL_USB_OTG_PERI_TXCSR_DMAMODE_SHIFT (0x000Au)
#define CSL_USB_OTG_PERI_TXCSR_DMAMODE_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_RSV1_MASK (0x0380u)
#define CSL_USB_OTG_PERI_TXCSR_RSV1_SHIFT (0x0007u)
#define CSL_USB_OTG_PERI_TXCSR_RSV1_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_CLRDATATOG_MASK (0x0040u)
#define CSL_USB_OTG_PERI_TXCSR_CLRDATATOG_SHIFT (0x0006u)
#define CSL_USB_OTG_PERI_TXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_SENTSTALL_MASK (0x0020u)
#define CSL_USB_OTG_PERI_TXCSR_SENTSTALL_SHIFT (0x0005u)
#define CSL_USB_OTG_PERI_TXCSR_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_SENDSTALL_MASK (0x0010u)
#define CSL_USB_OTG_PERI_TXCSR_SENDSTALL_SHIFT (0x0004u)
#define CSL_USB_OTG_PERI_TXCSR_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_FLUSHFIFO_MASK (0x0008u)
#define CSL_USB_OTG_PERI_TXCSR_FLUSHFIFO_SHIFT (0x0003u)
#define CSL_USB_OTG_PERI_TXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_UNDERRUN_MASK (0x0004u)
#define CSL_USB_OTG_PERI_TXCSR_UNDERRUN_SHIFT (0x0002u)
#define CSL_USB_OTG_PERI_TXCSR_UNDERRUN_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_FIFONOTEMPTY_MASK (0x0002u)
#define CSL_USB_OTG_PERI_TXCSR_FIFONOTEMPTY_SHIFT (0x0001u)
#define CSL_USB_OTG_PERI_TXCSR_FIFONOTEMPTY_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_TXPKTRDY_MASK (0x0001u)
#define CSL_USB_OTG_PERI_TXCSR_TXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_OTG_PERI_TXCSR_TXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_TXCSR_RESETVAL  (0x0000u)

/* RXMAXP */

#define CSL_USB_OTG_RXMAXP_MAXPAYLOAD_MASK (0x07FFu)
#define CSL_USB_OTG_RXMAXP_MAXPAYLOAD_SHIFT (0x0000u)
#define CSL_USB_OTG_RXMAXP_MAXPAYLOAD_RESETVAL (0x0000u)

#define CSL_USB_OTG_RXMAXP_RESETVAL      (0x0000u)

/* PERI_RXCSR */

#define CSL_USB_OTG_PERI_RXCSR_AUTOCLEAR_MASK (0x8000u)
#define CSL_USB_OTG_PERI_RXCSR_AUTOCLEAR_SHIFT (0x000Fu)
#define CSL_USB_OTG_PERI_RXCSR_AUTOCLEAR_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_ISO_MASK  (0x4000u)
#define CSL_USB_OTG_PERI_RXCSR_ISO_SHIFT (0x000Eu)
#define CSL_USB_OTG_PERI_RXCSR_ISO_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_DMAEN_MASK (0x2000u)
#define CSL_USB_OTG_PERI_RXCSR_DMAEN_SHIFT (0x000Du)
#define CSL_USB_OTG_PERI_RXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_DISNYET_MASK (0x1000u)
#define CSL_USB_OTG_PERI_RXCSR_DISNYET_SHIFT (0x000Cu)
#define CSL_USB_OTG_PERI_RXCSR_DISNYET_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_DMAMODE_MASK (0x0800u)
#define CSL_USB_OTG_PERI_RXCSR_DMAMODE_SHIFT (0x000Bu)
#define CSL_USB_OTG_PERI_RXCSR_DMAMODE_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_CLRDATATOG_MASK (0x0080u)
#define CSL_USB_OTG_PERI_RXCSR_CLRDATATOG_SHIFT (0x0007u)
#define CSL_USB_OTG_PERI_RXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_SENTSTALL_MASK (0x0040u)
#define CSL_USB_OTG_PERI_RXCSR_SENTSTALL_SHIFT (0x0006u)
#define CSL_USB_OTG_PERI_RXCSR_SENTSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_SENDSTALL_MASK (0x0020u)
#define CSL_USB_OTG_PERI_RXCSR_SENDSTALL_SHIFT (0x0005u)
#define CSL_USB_OTG_PERI_RXCSR_SENDSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_FLUSHFIFO_MASK (0x0010u)
#define CSL_USB_OTG_PERI_RXCSR_FLUSHFIFO_SHIFT (0x0004u)
#define CSL_USB_OTG_PERI_RXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_DATAERROR_MASK (0x0008u)
#define CSL_USB_OTG_PERI_RXCSR_DATAERROR_SHIFT (0x0003u)
#define CSL_USB_OTG_PERI_RXCSR_DATAERROR_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_OVERRUN_MASK (0x0004u)
#define CSL_USB_OTG_PERI_RXCSR_OVERRUN_SHIFT (0x0002u)
#define CSL_USB_OTG_PERI_RXCSR_OVERRUN_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_FIFOFULL_MASK (0x0002u)
#define CSL_USB_OTG_PERI_RXCSR_FIFOFULL_SHIFT (0x0001u)
#define CSL_USB_OTG_PERI_RXCSR_FIFOFULL_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_OTG_PERI_RXCSR_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_OTG_PERI_RXCSR_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_PERI_RXCSR_RESETVAL  (0x0000u)

/* HOST_RXCSR */

#define CSL_USB_OTG_HOST_RXCSR_AUTOCLEAR_MASK (0x8000u)
#define CSL_USB_OTG_HOST_RXCSR_AUTOCLEAR_SHIFT (0x000Fu)
#define CSL_USB_OTG_HOST_RXCSR_AUTOCLEAR_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_AUTOREQ_MASK (0x4000u)
#define CSL_USB_OTG_HOST_RXCSR_AUTOREQ_SHIFT (0x000Eu)
#define CSL_USB_OTG_HOST_RXCSR_AUTOREQ_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_DMAEN_MASK (0x2000u)
#define CSL_USB_OTG_HOST_RXCSR_DMAEN_SHIFT (0x000Du)
#define CSL_USB_OTG_HOST_RXCSR_DMAEN_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_DISNYET_MASK (0x1000u)
#define CSL_USB_OTG_HOST_RXCSR_DISNYET_SHIFT (0x000Cu)
#define CSL_USB_OTG_HOST_RXCSR_DISNYET_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_DMAMODE_MASK (0x0800u)
#define CSL_USB_OTG_HOST_RXCSR_DMAMODE_SHIFT (0x000Bu)
#define CSL_USB_OTG_HOST_RXCSR_DMAMODE_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_DATATOGWREN_MASK (0x0400u)
#define CSL_USB_OTG_HOST_RXCSR_DATATOGWREN_SHIFT (0x000Au)
#define CSL_USB_OTG_HOST_RXCSR_DATATOGWREN_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_DATATOG_MASK (0x0200u)
#define CSL_USB_OTG_HOST_RXCSR_DATATOG_SHIFT (0x0009u)
#define CSL_USB_OTG_HOST_RXCSR_DATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_CLRDATATOG_MASK (0x0080u)
#define CSL_USB_OTG_HOST_RXCSR_CLRDATATOG_SHIFT (0x0007u)
#define CSL_USB_OTG_HOST_RXCSR_CLRDATATOG_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_RXSTALL_MASK (0x0040u)
#define CSL_USB_OTG_HOST_RXCSR_RXSTALL_SHIFT (0x0006u)
#define CSL_USB_OTG_HOST_RXCSR_RXSTALL_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_REQPKT_MASK (0x0020u)
#define CSL_USB_OTG_HOST_RXCSR_REQPKT_SHIFT (0x0005u)
#define CSL_USB_OTG_HOST_RXCSR_REQPKT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_FLUSHFIFO_MASK (0x0010u)
#define CSL_USB_OTG_HOST_RXCSR_FLUSHFIFO_SHIFT (0x0004u)
#define CSL_USB_OTG_HOST_RXCSR_FLUSHFIFO_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_DATAERR_NAKTIMEOUT_MASK (0x0008u)
#define CSL_USB_OTG_HOST_RXCSR_DATAERR_NAKTIMEOUT_SHIFT (0x0003u)
#define CSL_USB_OTG_HOST_RXCSR_DATAERR_NAKTIMEOUT_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_ERROR_MASK (0x0004u)
#define CSL_USB_OTG_HOST_RXCSR_ERROR_SHIFT (0x0002u)
#define CSL_USB_OTG_HOST_RXCSR_ERROR_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_FIFOFULL_MASK (0x0002u)
#define CSL_USB_OTG_HOST_RXCSR_FIFOFULL_SHIFT (0x0001u)
#define CSL_USB_OTG_HOST_RXCSR_FIFOFULL_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_RXPKTRDY_MASK (0x0001u)
#define CSL_USB_OTG_HOST_RXCSR_RXPKTRDY_SHIFT (0x0000u)
#define CSL_USB_OTG_HOST_RXCSR_RXPKTRDY_RESETVAL (0x0000u)

#define CSL_USB_OTG_HOST_RXCSR_RESETVAL  (0x0000u)

/* COUNT0 */

#define CSL_USB_OTG_COUNT0_EP0RXCOUNT_MASK (0x007Fu)
#define CSL_USB_OTG_COUNT0_EP0RXCOUNT_SHIFT (0x0000u)
#define CSL_USB_OTG_COUNT0_EP0RXCOUNT_RESETVAL (0x0000u)

#define CSL_USB_OTG_COUNT0_RESETVAL      (0x0000u)

/* RXCOUNT */

#define CSL_USB_OTG_RXCOUNT_EPRXCOUNT_MASK (0x1FFFu)
#define CSL_USB_OTG_RXCOUNT_EPRXCOUNT_SHIFT (0x0000u)
#define CSL_USB_OTG_RXCOUNT_EPRXCOUNT_RESETVAL (0x0000u)

#define CSL_USB_OTG_RXCOUNT_RESETVAL     (0x0000u)

/* HOST_TYPE0 */

#define CSL_USB_OTG_HOST_TYPE0_SPEED_MASK (0xC0u)
#define CSL_USB_OTG_HOST_TYPE0_SPEED_SHIFT (0x06u)
#define CSL_USB_OTG_HOST_TYPE0_SPEED_RESETVAL (0x00u)
/*----SPEED Tokens----*/
#define CSL_USB_OTG_HOST_TYPE0_SPEED_HS  (0x01u)
#define CSL_USB_OTG_HOST_TYPE0_SPEED_FS  (0x02u)
#define CSL_USB_OTG_HOST_TYPE0_SPEED_LS  (0x03u)

#define CSL_USB_OTG_HOST_TYPE0_RESETVAL  (0x00u)

/* HOST_TXTYPE */

#define CSL_USB_OTG_HOST_TXTYPE_SPEED_MASK (0xC0u)
#define CSL_USB_OTG_HOST_TXTYPE_SPEED_SHIFT (0x06u)
#define CSL_USB_OTG_HOST_TXTYPE_SPEED_RESETVAL (0x00u)
/*----SPEED Tokens----*/
#define CSL_USB_OTG_HOST_TXTYPE_SPEED_HS (0x01u)
#define CSL_USB_OTG_HOST_TXTYPE_SPEED_FS (0x02u)
#define CSL_USB_OTG_HOST_TXTYPE_SPEED_LS (0x03u)

#define CSL_USB_OTG_HOST_TXTYPE_PROT_MASK (0x30u)
#define CSL_USB_OTG_HOST_TXTYPE_PROT_SHIFT (0x04u)
#define CSL_USB_OTG_HOST_TXTYPE_PROT_RESETVAL (0x00u)
/*----PROT Tokens----*/
#define CSL_USB_OTG_HOST_TXTYPE_PROT_CTRL (0x00u)
#define CSL_USB_OTG_HOST_TXTYPE_PROT_ISOC (0x01u)
#define CSL_USB_OTG_HOST_TXTYPE_PROT_BULK (0x02u)
#define CSL_USB_OTG_HOST_TXTYPE_PROT_INTR (0x03u)

#define CSL_USB_OTG_HOST_TXTYPE_TENDPN_MASK (0x0Fu)
#define CSL_USB_OTG_HOST_TXTYPE_TENDPN_SHIFT (0x00u)
#define CSL_USB_OTG_HOST_TXTYPE_TENDPN_RESETVAL (0x00u)

#define CSL_USB_OTG_HOST_TXTYPE_RESETVAL (0x00u)

/* HOST_NAKLIMIT0 */

#define CSL_USB_OTG_HOST_NAKLIMIT0_EP0NAKLIMIT_MASK (0x1Fu)
#define CSL_USB_OTG_HOST_NAKLIMIT0_EP0NAKLIMIT_SHIFT (0x00u)
#define CSL_USB_OTG_HOST_NAKLIMIT0_EP0NAKLIMIT_RESETVAL (0x00u)

#define CSL_USB_OTG_HOST_NAKLIMIT0_RESETVAL (0x00u)

/* HOST_TXINTERVAL */

#define CSL_USB_OTG_HOST_TXINTERVAL_POLINTVL_NAKLIMIT_MASK (0xFFu)
#define CSL_USB_OTG_HOST_TXINTERVAL_POLINTVL_NAKLIMIT_SHIFT (0x00u)
#define CSL_USB_OTG_HOST_TXINTERVAL_POLINTVL_NAKLIMIT_RESETVAL (0x00u)

#define CSL_USB_OTG_HOST_TXINTERVAL_RESETVAL (0x00u)

/* HOST_RXTYPE */

#define CSL_USB_OTG_HOST_RXTYPE_SPEED_MASK (0xC0u)
#define CSL_USB_OTG_HOST_RXTYPE_SPEED_SHIFT (0x06u)
#define CSL_USB_OTG_HOST_RXTYPE_SPEED_RESETVAL (0x00u)
/*----SPEED Tokens----*/
#define CSL_USB_OTG_HOST_RXTYPE_SPEED_HS (0x01u)
#define CSL_USB_OTG_HOST_RXTYPE_SPEED_FS (0x02u)
#define CSL_USB_OTG_HOST_RXTYPE_SPEED_LS (0x03u)

#define CSL_USB_OTG_HOST_RXTYPE_PROT_MASK (0x30u)
#define CSL_USB_OTG_HOST_RXTYPE_PROT_SHIFT (0x04u)
#define CSL_USB_OTG_HOST_RXTYPE_PROT_RESETVAL (0x00u)
/*----PROT Tokens----*/
#define CSL_USB_OTG_HOST_RXTYPE_PROT_CTRL (0x00u)
#define CSL_USB_OTG_HOST_RXTYPE_PROT_ISOC (0x01u)
#define CSL_USB_OTG_HOST_RXTYPE_PROT_BULK (0x02u)
#define CSL_USB_OTG_HOST_RXTYPE_PROT_INTR (0x03u)

#define CSL_USB_OTG_HOST_RXTYPE_RENDPN_MASK (0x0Fu)
#define CSL_USB_OTG_HOST_RXTYPE_RENDPN_SHIFT (0x00u)
#define CSL_USB_OTG_HOST_RXTYPE_RENDPN_RESETVAL (0x00u)

#define CSL_USB_OTG_HOST_RXTYPE_RESETVAL (0x00u)

/* HOST_RXINTERVAL */

#define CSL_USB_OTG_HOST_RXINTERVAL_POLINTVL_NAKLIMIT_MASK (0xFFu)
#define CSL_USB_OTG_HOST_RXINTERVAL_POLINTVL_NAKLIMIT_SHIFT (0x00u)
#define CSL_USB_OTG_HOST_RXINTERVAL_POLINTVL_NAKLIMIT_RESETVAL (0x00u)

#define CSL_USB_OTG_HOST_RXINTERVAL_RESETVAL (0x00u)

/* CONFIGDATA */

#define CSL_USB_OTG_CONFIGDATA_MPRXE_MASK (0x80u)
#define CSL_USB_OTG_CONFIGDATA_MPRXE_SHIFT (0x07u)
#define CSL_USB_OTG_CONFIGDATA_MPRXE_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_MPTXE_MASK (0x40u)
#define CSL_USB_OTG_CONFIGDATA_MPTXE_SHIFT (0x06u)
#define CSL_USB_OTG_CONFIGDATA_MPTXE_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_BIGENDIAN_MASK (0x20u)
#define CSL_USB_OTG_CONFIGDATA_BIGENDIAN_SHIFT (0x05u)
#define CSL_USB_OTG_CONFIGDATA_BIGENDIAN_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_HBRXE_MASK (0x10u)
#define CSL_USB_OTG_CONFIGDATA_HBRXE_SHIFT (0x04u)
#define CSL_USB_OTG_CONFIGDATA_HBRXE_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_HBTXE_MASK (0x08u)
#define CSL_USB_OTG_CONFIGDATA_HBTXE_SHIFT (0x03u)
#define CSL_USB_OTG_CONFIGDATA_HBTXE_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_DYNFIFO_MASK (0x04u)
#define CSL_USB_OTG_CONFIGDATA_DYNFIFO_SHIFT (0x02u)
#define CSL_USB_OTG_CONFIGDATA_DYNFIFO_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_SOFTCONE_MASK (0x02u)
#define CSL_USB_OTG_CONFIGDATA_SOFTCONE_SHIFT (0x01u)
#define CSL_USB_OTG_CONFIGDATA_SOFTCONE_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_UTMIDATAWIDTH_MASK (0x01u)
#define CSL_USB_OTG_CONFIGDATA_UTMIDATAWIDTH_SHIFT (0x00u)
#define CSL_USB_OTG_CONFIGDATA_UTMIDATAWIDTH_RESETVAL (0x00u)

#define CSL_USB_OTG_CONFIGDATA_RESETVAL  (0x00u)

/* FIFO0 */

#define CSL_USB_OTG_FIFO0_DATA_MASK      (0xFFFFFFFFu)
#define CSL_USB_OTG_FIFO0_DATA_SHIFT     (0x00000000u)
#define CSL_USB_OTG_FIFO0_DATA_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_FIFO0_RESETVAL       (0x00000000u)

/* FIFO1 */

#define CSL_USB_OTG_FIFO1_DATA_MASK      (0xFFFFFFFFu)
#define CSL_USB_OTG_FIFO1_DATA_SHIFT     (0x00000000u)
#define CSL_USB_OTG_FIFO1_DATA_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_FIFO1_RESETVAL       (0x00000000u)

/* FIFO2 */

#define CSL_USB_OTG_FIFO2_DATA_MASK      (0xFFFFFFFFu)
#define CSL_USB_OTG_FIFO2_DATA_SHIFT     (0x00000000u)
#define CSL_USB_OTG_FIFO2_DATA_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_FIFO2_RESETVAL       (0x00000000u)

/* FIFO3 */

#define CSL_USB_OTG_FIFO3_DATA_MASK      (0xFFFFFFFFu)
#define CSL_USB_OTG_FIFO3_DATA_SHIFT     (0x00000000u)
#define CSL_USB_OTG_FIFO3_DATA_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_FIFO3_RESETVAL       (0x00000000u)

/* FIFO4 */

#define CSL_USB_OTG_FIFO4_DATA_MASK      (0xFFFFFFFFu)
#define CSL_USB_OTG_FIFO4_DATA_SHIFT     (0x00000000u)
#define CSL_USB_OTG_FIFO4_DATA_RESETVAL  (0x00000000u)

#define CSL_USB_OTG_FIFO4_RESETVAL       (0x00000000u)

/* DEVCTL */

#define CSL_USB_OTG_DEVCTL_BDEVICE_MASK  (0x80u)
#define CSL_USB_OTG_DEVCTL_BDEVICE_SHIFT (0x07u)
#define CSL_USB_OTG_DEVCTL_BDEVICE_RESETVAL (0x00u)
/*----BDEVICE Tokens----*/
#define CSL_USB_OTG_DEVCTL_BDEVICE_ADEV  (0x00u)
#define CSL_USB_OTG_DEVCTL_BDEVICE_BDEV  (0x01u)

#define CSL_USB_OTG_DEVCTL_FSDEV_MASK    (0x40u)
#define CSL_USB_OTG_DEVCTL_FSDEV_SHIFT   (0x06u)
#define CSL_USB_OTG_DEVCTL_FSDEV_RESETVAL (0x00u)
/*----FSDEV Tokens----*/
#define CSL_USB_OTG_DEVCTL_FSDEV_HS      (0x00u)
#define CSL_USB_OTG_DEVCTL_FSDEV_FS      (0x01u)

#define CSL_USB_OTG_DEVCTL_LSDEV_MASK    (0x20u)
#define CSL_USB_OTG_DEVCTL_LSDEV_SHIFT   (0x05u)
#define CSL_USB_OTG_DEVCTL_LSDEV_RESETVAL (0x00u)
/*----LSDEV Tokens----*/
#define CSL_USB_OTG_DEVCTL_LSDEV_FS      (0x00u)
#define CSL_USB_OTG_DEVCTL_LSDEV_LS      (0x01u)

#define CSL_USB_OTG_DEVCTL_VBUS_MASK     (0x18u)
#define CSL_USB_OTG_DEVCTL_VBUS_SHIFT    (0x03u)
#define CSL_USB_OTG_DEVCTL_VBUS_RESETVAL (0x00u)
/*----VBUS Tokens----*/
#define CSL_USB_OTG_DEVCTL_VBUS_BELOW_SESSION_END (0x00u)
#define CSL_USB_OTG_DEVCTL_VBUS_BELOW_AVALID (0x01u)
#define CSL_USB_OTG_DEVCTL_VBUS_BELOW_VBUS_VALID (0x02u)
#define CSL_USB_OTG_DEVCTL_VBUS_ABOVE_VBUS_VALID (0x03u)

#define CSL_USB_OTG_DEVCTL_HOSTMODE_MASK (0x04u)
#define CSL_USB_OTG_DEVCTL_HOSTMODE_SHIFT (0x02u)
#define CSL_USB_OTG_DEVCTL_HOSTMODE_RESETVAL (0x00u)
/*----HOSTMODE Tokens----*/
#define CSL_USB_OTG_DEVCTL_HOSTMODE_PER_MODE (0x00u)
#define CSL_USB_OTG_DEVCTL_HOSTMODE_HOST_MODE (0x01u)

#define CSL_USB_OTG_DEVCTL_HOSTREQ_MASK  (0x02u)
#define CSL_USB_OTG_DEVCTL_HOSTREQ_SHIFT (0x01u)
#define CSL_USB_OTG_DEVCTL_HOSTREQ_RESETVAL (0x00u)
/*----HOSTREQ Tokens----*/
#define CSL_USB_OTG_DEVCTL_HOSTREQ_HNP_END (0x00u)
#define CSL_USB_OTG_DEVCTL_HOSTREQ_START_HNP (0x01u)

#define CSL_USB_OTG_DEVCTL_SESSION_MASK  (0x01u)
#define CSL_USB_OTG_DEVCTL_SESSION_SHIFT (0x00u)
#define CSL_USB_OTG_DEVCTL_SESSION_RESETVAL (0x00u)
/*----SESSION Tokens----*/
#define CSL_USB_OTG_DEVCTL_SESSION_SESSION_END (0x00u)
#define CSL_USB_OTG_DEVCTL_SESSION_SESSION_START (0x01u)

#define CSL_USB_OTG_DEVCTL_RESETVAL      (0x00u)

/* TXFIFOSZ */

#define CSL_USB_OTG_TXFIFOSZ_DPB_MASK    (0x10u)
#define CSL_USB_OTG_TXFIFOSZ_DPB_SHIFT   (0x04u)
#define CSL_USB_OTG_TXFIFOSZ_DPB_RESETVAL (0x00u)
/*----DPB Tokens----*/
#define CSL_USB_OTG_TXFIFOSZ_DPB_DISABLE (0x00u)
#define CSL_USB_OTG_TXFIFOSZ_DPB_ENABLE  (0x01u)

#define CSL_USB_OTG_TXFIFOSZ_SZ_MASK     (0x0Fu)
#define CSL_USB_OTG_TXFIFOSZ_SZ_SHIFT    (0x00u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_RESETVAL (0x00u)
/*----SZ Tokens----*/
#define CSL_USB_OTG_TXFIFOSZ_SZ_8_BYTES  (0x00u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_16_BYTES (0x01u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_32_BYTES (0x02u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_64_BYTES (0x03u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_128_BYTES (0x04u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_256_BYTES (0x05u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_512_BYTES (0x06u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_1024_BYTES (0x07u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_2048_BYTES (0x08u)
#define CSL_USB_OTG_TXFIFOSZ_SZ_4096_BYTES (0x09u)

#define CSL_USB_OTG_TXFIFOSZ_RESETVAL    (0x00u)

/* RXFIFOSZ */

#define CSL_USB_OTG_RXFIFOSZ_DPB_MASK    (0x10u)
#define CSL_USB_OTG_RXFIFOSZ_DPB_SHIFT   (0x04u)
#define CSL_USB_OTG_RXFIFOSZ_DPB_RESETVAL (0x00u)
/*----DPB Tokens----*/
#define CSL_USB_OTG_RXFIFOSZ_DPB_DISABLE (0x00u)
#define CSL_USB_OTG_RXFIFOSZ_DPB_ENABLE  (0x01u)

#define CSL_USB_OTG_RXFIFOSZ_SZ_MASK     (0x0Fu)
#define CSL_USB_OTG_RXFIFOSZ_SZ_SHIFT    (0x00u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_RESETVAL (0x00u)
/*----SZ Tokens----*/
#define CSL_USB_OTG_RXFIFOSZ_SZ_8_BYTES  (0x00u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_16_BYTES (0x01u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_32_BYTES (0x02u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_64_BYTES (0x03u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_128_BYTES (0x04u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_256_BYTES (0x05u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_512_BYTES (0x06u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_1024_BYTES (0x07u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_2048_BYTES (0x08u)
#define CSL_USB_OTG_RXFIFOSZ_SZ_4096_BYTES (0x09u)

#define CSL_USB_OTG_RXFIFOSZ_RESETVAL    (0x00u)

/* TXFIFOADDR */

#define CSL_USB_OTG_TXFIFOADDR_ADDR_MASK (0x1FFFu)
#define CSL_USB_OTG_TXFIFOADDR_ADDR_SHIFT (0x0000u)
#define CSL_USB_OTG_TXFIFOADDR_ADDR_RESETVAL (0x0000u)

#define CSL_USB_OTG_TXFIFOADDR_RESETVAL  (0x0000u)

/* RXFIFOADDR */

#define CSL_USB_OTG_RXFIFOADDR_ADDR_MASK (0x1FFFu)
#define CSL_USB_OTG_RXFIFOADDR_ADDR_SHIFT (0x0000u)
#define CSL_USB_OTG_RXFIFOADDR_ADDR_RESETVAL (0x0000u)

#define CSL_USB_OTG_RXFIFOADDR_RESETVAL  (0x0000u)

/* HWVERS */

#define CSL_USB_OTG_HWVERS_RC_MASK       (0x8000u)
#define CSL_USB_OTG_HWVERS_RC_SHIFT      (0x000Fu)
#define CSL_USB_OTG_HWVERS_RC_RESETVAL   (0x0000u)

#define CSL_USB_OTG_HWVERS_REVMAJ_MASK   (0x7C00u)
#define CSL_USB_OTG_HWVERS_REVMAJ_SHIFT  (0x000Au)
#define CSL_USB_OTG_HWVERS_REVMAJ_RESETVAL (0x0000u)

#define CSL_USB_OTG_HWVERS_REVMIN_MASK   (0x03FFu)
#define CSL_USB_OTG_HWVERS_REVMIN_SHIFT  (0x0000u)
#define CSL_USB_OTG_HWVERS_REVMIN_RESETVAL (0x0000u)

#define CSL_USB_OTG_HWVERS_RESETVAL      (0x0000u)

#endif
