/*
 * cslr_spi.h
 *
 * This file contains the macros for Register Chip Support Library (CSL) which 
 * can be used for operations on the respective underlying hardware/peripheral
 *
 * Copyright (C) 2009 Texas Instruments Incorporated - http://www.ti.com/
 *
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *    Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 *    Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/


/** ============================================================================
 *   @file  cslr_spi.h
 *
 *   @path  $(CSLPATH)\inc
 *
 *   @desc  This file contains the Register Descriptions for SPI
 *
 *  ============================================================================
 */
#ifndef _CSLR_SPI_H_
#define _CSLR_SPI_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <ti/pspiom/cslr/cslr.h>
#include <ti/pspiom/cslr/tistdtypes.h>


/* Minimum unit = 1 byte */

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 SPIGCR0;
    volatile Uint32 SPIGCR1;
    volatile Uint32 SPIINT0;
    volatile Uint32 SPILVL;
    volatile Uint32 SPIFLG;
    volatile Uint32 SPIPC0;
    volatile Uint32 SPIPC1;
    volatile Uint32 SPIPC2;
    volatile Uint32 SPIPC3;
    volatile Uint32 SPIPC4;
    volatile Uint32 SPIPC5;
    volatile Uint8 RSVD0[12];
    volatile Uint32 SPIDAT0;
    volatile Uint32 SPIDAT1;
    volatile Uint32 SPIBUF;
    volatile Uint32 SPIEMU;
    volatile Uint32 SPIDELAY;
    volatile Uint32 SPIDEF;
    volatile Uint32 SPIFMT[4];
    volatile Uint32 INTVEC[2];
} CSL_SpiRegs;

/**************************************************************************\
* Overlay structure typedef definition
\**************************************************************************/
typedef volatile CSL_SpiRegs         *CSL_SpiRegsOvly;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* SPIGCR0 */


#define CSL_SPI_SPIGCR0_RESET_MASK       (0x00000001u)
#define CSL_SPI_SPIGCR0_RESET_SHIFT      (0x00000000u)
#define CSL_SPI_SPIGCR0_RESET_RESETVAL   (0x00000000u)
/*----RESET Tokens----*/
#define CSL_SPI_SPIGCR0_RESET_IN_RESET   (0x00000000u)
#define CSL_SPI_SPIGCR0_RESET_OUT_OF_RESET (0x00000001u)

#define CSL_SPI_SPIGCR0_RESETVAL         (0x00000000u)

/* SPIGCR1 */


#define CSL_SPI_SPIGCR1_ENABLE_MASK      (0x01000000u)
#define CSL_SPI_SPIGCR1_ENABLE_SHIFT     (0x00000018u)
#define CSL_SPI_SPIGCR1_ENABLE_RESETVAL  (0x00000000u)
/*----ENABLE Tokens----*/
#define CSL_SPI_SPIGCR1_ENABLE_DISABLE   (0x00000000u)
#define CSL_SPI_SPIGCR1_ENABLE_ENABLE    (0x00000001u)


#define CSL_SPI_SPIGCR1_LOOPBACK_MASK    (0x00010000u)
#define CSL_SPI_SPIGCR1_LOOPBACK_SHIFT   (0x00000010u)
#define CSL_SPI_SPIGCR1_LOOPBACK_RESETVAL (0x00000000u)
/*----LOOPBACK Tokens----*/
#define CSL_SPI_SPIGCR1_LOOPBACK_DISABLE (0x00000000u)
#define CSL_SPI_SPIGCR1_LOOPBACK_ENABLE  (0x00000001u)


#define CSL_SPI_SPIGCR1_POWERDOWN_MASK   (0x00000100u)
#define CSL_SPI_SPIGCR1_POWERDOWN_SHIFT  (0x00000008u)
#define CSL_SPI_SPIGCR1_POWERDOWN_RESETVAL (0x00000000u)
/*----POWERDOWN Tokens----*/
#define CSL_SPI_SPIGCR1_POWERDOWN_DISABLE (0x00000000u)
#define CSL_SPI_SPIGCR1_POWERDOWN_ENABLE (0x00000001u)


#define CSL_SPI_SPIGCR1_CLKMOD_MASK      (0x00000002u)
#define CSL_SPI_SPIGCR1_CLKMOD_SHIFT     (0x00000001u)
#define CSL_SPI_SPIGCR1_CLKMOD_RESETVAL  (0x00000000u)
/*----CLKMOD Tokens----*/
#define CSL_SPI_SPIGCR1_CLKMOD_EXTERNAL  (0x00000000u)
#define CSL_SPI_SPIGCR1_CLKMOD_INTERNAL  (0x00000001u)

#define CSL_SPI_SPIGCR1_MASTER_MASK      (0x00000001u)
#define CSL_SPI_SPIGCR1_MASTER_SHIFT     (0x00000000u)
#define CSL_SPI_SPIGCR1_MASTER_RESETVAL  (0x00000000u)
/*----MASTER Tokens----*/
#define CSL_SPI_SPIGCR1_MASTER_SLAVE     (0x00000000u)
#define CSL_SPI_SPIGCR1_MASTER_MASTER    (0x00000001u)

#define CSL_SPI_SPIGCR1_RESETVAL         (0x00000000u)

/* SPIINT0 */


#define CSL_SPI_SPIINT0_ENABLEHIGHZ_MASK (0x01000000u)
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_SHIFT (0x00000018u)
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_RESETVAL (0x00000000u)
/*----ENABLEHIGHZ Tokens----*/
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_ENABLE (0x00000001u)


#define CSL_SPI_SPIINT0_DMAREQEN_MASK    (0x00010000u)
#define CSL_SPI_SPIINT0_DMAREQEN_SHIFT   (0x00000010u)
#define CSL_SPI_SPIINT0_DMAREQEN_RESETVAL (0x00000000u)
/*----DMAREQEN Tokens----*/
#define CSL_SPI_SPIINT0_DMAREQEN_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_DMAREQEN_ENABLE  (0x00000001u)


#define CSL_SPI_SPIINT0_TXINTENA_MASK    (0x00000200u)
#define CSL_SPI_SPIINT0_TXINTENA_SHIFT   (0x00000009u)
#define CSL_SPI_SPIINT0_TXINTENA_RESETVAL (0x00000000u)
/*----TXINTENA Tokens----*/
#define CSL_SPI_SPIINT0_TXINTENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_TXINTENA_ENABLE  (0x00000001u)

#define CSL_SPI_SPIINT0_RXINTENA_MASK    (0x00000100u)
#define CSL_SPI_SPIINT0_RXINTENA_SHIFT   (0x00000008u)
#define CSL_SPI_SPIINT0_RXINTENA_RESETVAL (0x00000000u)
/*----RXINTENA Tokens----*/
#define CSL_SPI_SPIINT0_RXINTENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_RXINTENA_ENABLE  (0x00000001u)


#define CSL_SPI_SPIINT0_OVRNINTENA_MASK  (0x00000040u)
#define CSL_SPI_SPIINT0_OVRNINTENA_SHIFT (0x00000006u)
#define CSL_SPI_SPIINT0_OVRNINTENA_RESETVAL (0x00000000u)
/*----OVRNINTENA Tokens----*/
#define CSL_SPI_SPIINT0_OVRNINTENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_OVRNINTENA_ENABLE (0x00000001u)


#define CSL_SPI_SPIINT0_BITERRENA_MASK   (0x00000010u)
#define CSL_SPI_SPIINT0_BITERRENA_SHIFT  (0x00000004u)
#define CSL_SPI_SPIINT0_BITERRENA_RESETVAL (0x00000000u)
/*----BITERRENA Tokens----*/
#define CSL_SPI_SPIINT0_BITERRENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_BITERRENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_DESYNCENA_MASK   (0x00000008u)
#define CSL_SPI_SPIINT0_DESYNCENA_SHIFT  (0x00000003u)
#define CSL_SPI_SPIINT0_DESYNCENA_RESETVAL (0x00000000u)
/*----DESYNCENA Tokens----*/
#define CSL_SPI_SPIINT0_DESYNCENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_DESYNCENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_PARERRENA_MASK   (0x00000004u)
#define CSL_SPI_SPIINT0_PARERRENA_SHIFT  (0x00000002u)
#define CSL_SPI_SPIINT0_PARERRENA_RESETVAL (0x00000000u)
/*----PARERRENA Tokens----*/
#define CSL_SPI_SPIINT0_PARERRENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_PARERRENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_TIMEOUTENA_MASK  (0x00000002u)
#define CSL_SPI_SPIINT0_TIMEOUTENA_SHIFT (0x00000001u)
#define CSL_SPI_SPIINT0_TIMEOUTENA_RESETVAL (0x00000000u)
/*----TIMEOUTENA Tokens----*/
#define CSL_SPI_SPIINT0_TIMEOUTENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_TIMEOUTENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_DLENERRENA_MASK  (0x00000001u)
#define CSL_SPI_SPIINT0_DLENERRENA_SHIFT (0x00000000u)
#define CSL_SPI_SPIINT0_DLENERRENA_RESETVAL (0x00000000u)
/*----DLENERRENA Tokens----*/
#define CSL_SPI_SPIINT0_DLENERRENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_DLENERRENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_RESETVAL         (0x00000000u)

/* SPILVL */


#define CSL_SPI_SPILVL_TXINTLVL_MASK     (0x00000200u)
#define CSL_SPI_SPILVL_TXINTLVL_SHIFT    (0x00000009u)
#define CSL_SPI_SPILVL_TXINTLVL_RESETVAL (0x00000000u)
/*----TXINTLVL Tokens----*/
#define CSL_SPI_SPILVL_TXINTLVL_INT0     (0x00000000u)
#define CSL_SPI_SPILVL_TXINTLVL_INT1     (0x00000001u)

#define CSL_SPI_SPILVL_RXINTLVL_MASK     (0x00000100u)
#define CSL_SPI_SPILVL_RXINTLVL_SHIFT    (0x00000008u)
#define CSL_SPI_SPILVL_RXINTLVL_RESETVAL (0x00000000u)
/*----RXINTLVL Tokens----*/
#define CSL_SPI_SPILVL_RXINTLVL_INT0     (0x00000000u)
#define CSL_SPI_SPILVL_RXINTLVL_INT1     (0x00000001u)


#define CSL_SPI_SPILVL_OVRNINTLVL_MASK   (0x00000040u)
#define CSL_SPI_SPILVL_OVRNINTLVL_SHIFT  (0x00000006u)
#define CSL_SPI_SPILVL_OVRNINTLVL_RESETVAL (0x00000000u)
/*----OVRNINTLVL Tokens----*/
#define CSL_SPI_SPILVL_OVRNINTLVL_INT0   (0x00000000u)
#define CSL_SPI_SPILVL_OVRNINTLVL_INT1   (0x00000001u)


#define CSL_SPI_SPILVL_BITERRLVL_MASK    (0x00000010u)
#define CSL_SPI_SPILVL_BITERRLVL_SHIFT   (0x00000004u)
#define CSL_SPI_SPILVL_BITERRLVL_RESETVAL (0x00000000u)
/*----BITERRLVL Tokens----*/
#define CSL_SPI_SPILVL_BITERRLVL_INT0    (0x00000000u)
#define CSL_SPI_SPILVL_BITERRLVL_INT1    (0x00000001u)

#define CSL_SPI_SPILVL_DESYNCLVL_MASK    (0x00000008u)
#define CSL_SPI_SPILVL_DESYNCLVL_SHIFT   (0x00000003u)
#define CSL_SPI_SPILVL_DESYNCLVL_RESETVAL (0x00000000u)
/*----DESYNCLVL Tokens----*/
#define CSL_SPI_SPILVL_DESYNCLVL_INT0    (0x00000000u)
#define CSL_SPI_SPILVL_DESYNCLVL_INT1    (0x00000001u)

#define CSL_SPI_SPILVL_PARERRLVL_MASK    (0x00000004u)
#define CSL_SPI_SPILVL_PARERRLVL_SHIFT   (0x00000002u)
#define CSL_SPI_SPILVL_PARERRLVL_RESETVAL (0x00000000u)
/*----PARERRLVL Tokens----*/
#define CSL_SPI_SPILVL_PARERRLVL_INT0    (0x00000000u)
#define CSL_SPI_SPILVL_PARERRLVL_INT1    (0x00000001u)

#define CSL_SPI_SPILVL_TIMEOUTLVL_MASK   (0x00000002u)
#define CSL_SPI_SPILVL_TIMEOUTLVL_SHIFT  (0x00000001u)
#define CSL_SPI_SPILVL_TIMEOUTLVL_RESETVAL (0x00000000u)
/*----TIMEOUTLVL Tokens----*/
#define CSL_SPI_SPILVL_TIMEOUTLVL_INT0   (0x00000000u)
#define CSL_SPI_SPILVL_TIMEOUTLVL_INT1   (0x00000001u)

#define CSL_SPI_SPILVL_DLENERRLVL_MASK   (0x00000001u)
#define CSL_SPI_SPILVL_DLENERRLVL_SHIFT  (0x00000000u)
#define CSL_SPI_SPILVL_DLENERRLVL_RESETVAL (0x00000000u)
/*----DLENERRLVL Tokens----*/
#define CSL_SPI_SPILVL_DLENERRLVL_INT0   (0x00000000u)
#define CSL_SPI_SPILVL_DLENERRLVL_INT1   (0x00000001u)

#define CSL_SPI_SPILVL_RESETVAL          (0x00000000u)

/* SPIFLG */


#define CSL_SPI_SPIFLG_TXINTFLG_MASK     (0x00000200u)
#define CSL_SPI_SPIFLG_TXINTFLG_SHIFT    (0x00000009u)
#define CSL_SPI_SPIFLG_TXINTFLG_RESETVAL (0x00000000u)
/*----TXINTFLG Tokens----*/
#define CSL_SPI_SPIFLG_TXINTFLG_NO_EMPTY (0x00000000u)
#define CSL_SPI_SPIFLG_TXINTFLG_EMPTY    (0x00000001u)

#define CSL_SPI_SPIFLG_RXINTFLG_MASK     (0x00000100u)
#define CSL_SPI_SPIFLG_RXINTFLG_SHIFT    (0x00000008u)
#define CSL_SPI_SPIFLG_RXINTFLG_RESETVAL (0x00000000u)
/*----RXINTFLG Tokens----*/
#define CSL_SPI_SPIFLG_RXINTFLG_NO_FULL  (0x00000000u)
#define CSL_SPI_SPIFLG_RXINTFLG_FULL     (0x00000001u)


#define CSL_SPI_SPIFLG_OVRNINTFLG_MASK   (0x00000040u)
#define CSL_SPI_SPIFLG_OVRNINTFLG_SHIFT  (0x00000006u)
#define CSL_SPI_SPIFLG_OVRNINTFLG_RESETVAL (0x00000000u)
/*----OVRNINTFLG Tokens----*/
#define CSL_SPI_SPIFLG_OVRNINTFLG_NO_ERROR (0x00000000u)
#define CSL_SPI_SPIFLG_OVRNINTFLG_ERROR  (0x00000001u)


#define CSL_SPI_SPIFLG_BITERRFLG_MASK    (0x00000010u)
#define CSL_SPI_SPIFLG_BITERRFLG_SHIFT   (0x00000004u)
#define CSL_SPI_SPIFLG_BITERRFLG_RESETVAL (0x00000000u)
/*----BITERRFLG Tokens----*/
#define CSL_SPI_SPIFLG_BITERRFLG_NO_ERROR (0x00000000u)
#define CSL_SPI_SPIFLG_BITERRFLG_ERROR   (0x00000001u)

#define CSL_SPI_SPIFLG_DESYNCFLG_MASK    (0x00000008u)
#define CSL_SPI_SPIFLG_DESYNCFLG_SHIFT   (0x00000003u)
#define CSL_SPI_SPIFLG_DESYNCFLG_RESETVAL (0x00000000u)
/*----DESYNCFLG Tokens----*/
#define CSL_SPI_SPIFLG_DESYNCFLG_NO_ERROR (0x00000000u)
#define CSL_SPI_SPIFLG_DESYNCFLG_ERROR   (0x00000001u)

#define CSL_SPI_SPIFLG_PARERRFLG_MASK    (0x00000004u)
#define CSL_SPI_SPIFLG_PARERRFLG_SHIFT   (0x00000002u)
#define CSL_SPI_SPIFLG_PARERRFLG_RESETVAL (0x00000000u)
/*----PARERRFLG Tokens----*/
#define CSL_SPI_SPIFLG_PARERRFLG_NO_ERROR (0x00000000u)
#define CSL_SPI_SPIFLG_PARERRFLG_ERROR   (0x00000001u)

#define CSL_SPI_SPIFLG_TIMEOUTFLG_MASK   (0x00000002u)
#define CSL_SPI_SPIFLG_TIMEOUTFLG_SHIFT  (0x00000001u)
#define CSL_SPI_SPIFLG_TIMEOUTFLG_RESETVAL (0x00000000u)
/*----TIMEOUTFLG Tokens----*/
#define CSL_SPI_SPIFLG_TIMEOUTFLG_NO_ERROR (0x00000000u)
#define CSL_SPI_SPIFLG_TIMEOUTFLG_ERROR  (0x00000001u)

#define CSL_SPI_SPIFLG_DLENERRFLG_MASK   (0x00000001u)
#define CSL_SPI_SPIFLG_DLENERRFLG_SHIFT  (0x00000000u)
#define CSL_SPI_SPIFLG_DLENERRFLG_RESETVAL (0x00000000u)
/*----DLENERRFLG Tokens----*/
#define CSL_SPI_SPIFLG_DLENERRFLG_NO_ERROR (0x00000000u)
#define CSL_SPI_SPIFLG_DLENERRFLG_ERROR  (0x00000001u)

#define CSL_SPI_SPIFLG_RESETVAL          (0x00000000u)

/* SPIPC0 */


#define CSL_SPI_SPIPC0_SOMIFUN_MASK      (0x00000800u)
#define CSL_SPI_SPIPC0_SOMIFUN_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC0_SOMIFUN_RESETVAL  (0x00000000u)
/*----SOMIFUN Tokens----*/
#define CSL_SPI_SPIPC0_SOMIFUN_GPIO      (0x00000000u)
#define CSL_SPI_SPIPC0_SOMIFUN_SPI       (0x00000001u)

#define CSL_SPI_SPIPC0_SIMOFUN_MASK      (0x00000400u)
#define CSL_SPI_SPIPC0_SIMOFUN_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC0_SIMOFUN_RESETVAL  (0x00000000u)
/*----SIMOFUN Tokens----*/
#define CSL_SPI_SPIPC0_SIMOFUN_GPIO      (0x00000000u)
#define CSL_SPI_SPIPC0_SIMOFUN_SPI       (0x00000001u)

#define CSL_SPI_SPIPC0_CLKFUN_MASK       (0x00000200u)
#define CSL_SPI_SPIPC0_CLKFUN_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC0_CLKFUN_RESETVAL   (0x00000000u)
/*----CLKFUN Tokens----*/
#define CSL_SPI_SPIPC0_CLKFUN_GPIO       (0x00000000u)
#define CSL_SPI_SPIPC0_CLKFUN_SPI        (0x00000001u)

#define CSL_SPI_SPIPC0_ENAFUN_MASK       (0x00000100u)
#define CSL_SPI_SPIPC0_ENAFUN_SHIFT      (0x00000008u)
#define CSL_SPI_SPIPC0_ENAFUN_RESETVAL   (0x00000000u)
/*----ENAFUN Tokens----*/
#define CSL_SPI_SPIPC0_ENAFUN_GPIO       (0x00000000u)
#define CSL_SPI_SPIPC0_ENAFUN_SPI        (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN7_MASK     (0x00000080u)
#define CSL_SPI_SPIPC0_SCS0FUN7_SHIFT    (0x00000007u)
#define CSL_SPI_SPIPC0_SCS0FUN7_RESETVAL (0x00000000u)
/*----SCS0FUN7 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN7_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN7_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN6_MASK     (0x00000040u)
#define CSL_SPI_SPIPC0_SCS0FUN6_SHIFT    (0x00000006u)
#define CSL_SPI_SPIPC0_SCS0FUN6_RESETVAL (0x00000000u)
/*----SCS0FUN6 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN6_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN6_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN5_MASK     (0x00000020u)
#define CSL_SPI_SPIPC0_SCS0FUN5_SHIFT    (0x00000005u)
#define CSL_SPI_SPIPC0_SCS0FUN5_RESETVAL (0x00000000u)
/*----SCS0FUN5 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN5_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN5_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN4_MASK     (0x00000010u)
#define CSL_SPI_SPIPC0_SCS0FUN4_SHIFT    (0x00000004u)
#define CSL_SPI_SPIPC0_SCS0FUN4_RESETVAL (0x00000000u)
/*----SCS0FUN4 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN4_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN4_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN3_MASK     (0x00000008u)
#define CSL_SPI_SPIPC0_SCS0FUN3_SHIFT    (0x00000003u)
#define CSL_SPI_SPIPC0_SCS0FUN3_RESETVAL (0x00000000u)
/*----SCS0FUN3 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN3_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN3_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN2_MASK     (0x00000004u)
#define CSL_SPI_SPIPC0_SCS0FUN2_SHIFT    (0x00000002u)
#define CSL_SPI_SPIPC0_SCS0FUN2_RESETVAL (0x00000000u)
/*----SCS0FUN2 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN2_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN2_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN1_MASK     (0x00000002u)
#define CSL_SPI_SPIPC0_SCS0FUN1_SHIFT    (0x00000001u)
#define CSL_SPI_SPIPC0_SCS0FUN1_RESETVAL (0x00000000u)
/*----SCS0FUN1 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN1_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN1_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_SCS0FUN0_MASK     (0x00000001u)
#define CSL_SPI_SPIPC0_SCS0FUN0_SHIFT    (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN0_RESETVAL (0x00000000u)
/*----SCS0FUN0 Tokens----*/
#define CSL_SPI_SPIPC0_SCS0FUN0_GPIO     (0x00000000u)
#define CSL_SPI_SPIPC0_SCS0FUN0_SPI      (0x00000001u)

#define CSL_SPI_SPIPC0_RESETVAL          (0x00000000u)

/* SPIPC1 */


#define CSL_SPI_SPIPC1_SOMIDIR_MASK      (0x00000800u)
#define CSL_SPI_SPIPC1_SOMIDIR_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC1_SOMIDIR_RESETVAL  (0x00000000u)
/*----SOMIDIR Tokens----*/
#define CSL_SPI_SPIPC1_SOMIDIR_INPUT     (0x00000000u)
#define CSL_SPI_SPIPC1_SOMIDIR_OUTPUT    (0x00000001u)

#define CSL_SPI_SPIPC1_SIMODIR_MASK      (0x00000400u)
#define CSL_SPI_SPIPC1_SIMODIR_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC1_SIMODIR_RESETVAL  (0x00000000u)
/*----SIMODIR Tokens----*/
#define CSL_SPI_SPIPC1_SIMODIR_INPUT     (0x00000000u)
#define CSL_SPI_SPIPC1_SIMODIR_OUTPUT    (0x00000001u)

#define CSL_SPI_SPIPC1_CLKDIR_MASK       (0x00000200u)
#define CSL_SPI_SPIPC1_CLKDIR_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC1_CLKDIR_RESETVAL   (0x00000000u)
/*----CLKDIR Tokens----*/
#define CSL_SPI_SPIPC1_CLKDIR_INPUT      (0x00000000u)
#define CSL_SPI_SPIPC1_CLKDIR_OUTPUT     (0x00000001u)

#define CSL_SPI_SPIPC1_ENADIR_MASK       (0x00000100u)
#define CSL_SPI_SPIPC1_ENADIR_SHIFT      (0x00000008u)
#define CSL_SPI_SPIPC1_ENADIR_RESETVAL   (0x00000000u)
/*----ENADIR Tokens----*/
#define CSL_SPI_SPIPC1_ENADIR_INPUT      (0x00000000u)
#define CSL_SPI_SPIPC1_ENADIR_OUTPUT     (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR7_MASK     (0x00000080u)
#define CSL_SPI_SPIPC1_SCS0DIR7_SHIFT    (0x00000007u)
#define CSL_SPI_SPIPC1_SCS0DIR7_RESETVAL (0x00000000u)
/*----SCS0DIR7 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR7_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR7_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR6_MASK     (0x00000040u)
#define CSL_SPI_SPIPC1_SCS0DIR6_SHIFT    (0x00000006u)
#define CSL_SPI_SPIPC1_SCS0DIR6_RESETVAL (0x00000000u)
/*----SCS0DIR6 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR6_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR6_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR5_MASK     (0x00000020u)
#define CSL_SPI_SPIPC1_SCS0DIR5_SHIFT    (0x00000005u)
#define CSL_SPI_SPIPC1_SCS0DIR5_RESETVAL (0x00000000u)
/*----SCS0DIR5 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR5_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR5_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR4_MASK     (0x00000010u)
#define CSL_SPI_SPIPC1_SCS0DIR4_SHIFT    (0x00000004u)
#define CSL_SPI_SPIPC1_SCS0DIR4_RESETVAL (0x00000000u)
/*----SCS0DIR4 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR4_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR4_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR3_MASK     (0x00000008u)
#define CSL_SPI_SPIPC1_SCS0DIR3_SHIFT    (0x00000003u)
#define CSL_SPI_SPIPC1_SCS0DIR3_RESETVAL (0x00000000u)
/*----SCS0DIR3 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR3_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR3_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR2_MASK     (0x00000004u)
#define CSL_SPI_SPIPC1_SCS0DIR2_SHIFT    (0x00000002u)
#define CSL_SPI_SPIPC1_SCS0DIR2_RESETVAL (0x00000000u)
/*----SCS0DIR2 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR2_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR2_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR1_MASK     (0x00000002u)
#define CSL_SPI_SPIPC1_SCS0DIR1_SHIFT    (0x00000001u)
#define CSL_SPI_SPIPC1_SCS0DIR1_RESETVAL (0x00000000u)
/*----SCS0DIR1 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR1_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR1_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_SCS0DIR0_MASK     (0x00000001u)
#define CSL_SPI_SPIPC1_SCS0DIR0_SHIFT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR0_RESETVAL (0x00000000u)
/*----SCS0DIR0 Tokens----*/
#define CSL_SPI_SPIPC1_SCS0DIR0_INPUT    (0x00000000u)
#define CSL_SPI_SPIPC1_SCS0DIR0_OUTPUT   (0x00000001u)

#define CSL_SPI_SPIPC1_RESETVAL          (0x00000000u)

/* SPIPC2 */


#define CSL_SPI_SPIPC2_SOMIDIN_MASK      (0x00000800u)
#define CSL_SPI_SPIPC2_SOMIDIN_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC2_SOMIDIN_RESETVAL  (0x00000000u)
/*----SOMIDIN Tokens----*/
#define CSL_SPI_SPIPC2_SOMIDIN_LOW       (0x00000000u)
#define CSL_SPI_SPIPC2_SOMIDIN_HIGH      (0x00000001u)

#define CSL_SPI_SPIPC2_SIMODIN_MASK      (0x00000400u)
#define CSL_SPI_SPIPC2_SIMODIN_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC2_SIMODIN_RESETVAL  (0x00000000u)
/*----SIMODIN Tokens----*/
#define CSL_SPI_SPIPC2_SIMODIN_LOW       (0x00000000u)
#define CSL_SPI_SPIPC2_SIMODIN_HIGH      (0x00000001u)

#define CSL_SPI_SPIPC2_CLKDIN_MASK       (0x00000200u)
#define CSL_SPI_SPIPC2_CLKDIN_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC2_CLKDIN_RESETVAL   (0x00000000u)
/*----CLKDIN Tokens----*/
#define CSL_SPI_SPIPC2_CLKDIN_LOW        (0x00000000u)
#define CSL_SPI_SPIPC2_CLKDIN_HIGH       (0x00000001u)

#define CSL_SPI_SPIPC2_ENADIN_MASK       (0x00000100u)
#define CSL_SPI_SPIPC2_ENADIN_SHIFT      (0x00000008u)
#define CSL_SPI_SPIPC2_ENADIN_RESETVAL   (0x00000000u)
/*----ENADIN Tokens----*/
#define CSL_SPI_SPIPC2_ENADIN_LOW        (0x00000000u)
#define CSL_SPI_SPIPC2_ENADIN_HIGH       (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN7_MASK     (0x00000080u)
#define CSL_SPI_SPIPC2_SCS0DIN7_SHIFT    (0x00000007u)
#define CSL_SPI_SPIPC2_SCS0DIN7_RESETVAL (0x00000000u)
/*----SCS0DIN7 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN7_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN7_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN6_MASK     (0x00000040u)
#define CSL_SPI_SPIPC2_SCS0DIN6_SHIFT    (0x00000006u)
#define CSL_SPI_SPIPC2_SCS0DIN6_RESETVAL (0x00000000u)
/*----SCS0DIN6 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN6_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN6_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN5_MASK     (0x00000020u)
#define CSL_SPI_SPIPC2_SCS0DIN5_SHIFT    (0x00000005u)
#define CSL_SPI_SPIPC2_SCS0DIN5_RESETVAL (0x00000000u)
/*----SCS0DIN5 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN5_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN5_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN4_MASK     (0x00000010u)
#define CSL_SPI_SPIPC2_SCS0DIN4_SHIFT    (0x00000004u)
#define CSL_SPI_SPIPC2_SCS0DIN4_RESETVAL (0x00000000u)
/*----SCS0DIN4 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN4_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN4_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN3_MASK     (0x00000008u)
#define CSL_SPI_SPIPC2_SCS0DIN3_SHIFT    (0x00000003u)
#define CSL_SPI_SPIPC2_SCS0DIN3_RESETVAL (0x00000000u)
/*----SCS0DIN3 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN3_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN3_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN2_MASK     (0x00000004u)
#define CSL_SPI_SPIPC2_SCS0DIN2_SHIFT    (0x00000002u)
#define CSL_SPI_SPIPC2_SCS0DIN2_RESETVAL (0x00000000u)
/*----SCS0DIN2 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN2_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN2_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN1_MASK     (0x00000002u)
#define CSL_SPI_SPIPC2_SCS0DIN1_SHIFT    (0x00000001u)
#define CSL_SPI_SPIPC2_SCS0DIN1_RESETVAL (0x00000000u)
/*----SCS0DIN1 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN1_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN1_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_SCS0DIN0_MASK     (0x00000001u)
#define CSL_SPI_SPIPC2_SCS0DIN0_SHIFT    (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN0_RESETVAL (0x00000000u)
/*----SCS0DIN0 Tokens----*/
#define CSL_SPI_SPIPC2_SCS0DIN0_LOW      (0x00000000u)
#define CSL_SPI_SPIPC2_SCS0DIN0_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC2_RESETVAL          (0x00000000u)

/* SPIPC3 */


#define CSL_SPI_SPIPC3_SOMIDOUT_MASK     (0x00000800u)
#define CSL_SPI_SPIPC3_SOMIDOUT_SHIFT    (0x0000000Bu)
#define CSL_SPI_SPIPC3_SOMIDOUT_RESETVAL (0x00000000u)
/*----SOMIDOUT Tokens----*/
#define CSL_SPI_SPIPC3_SOMIDOUT_LOW      (0x00000000u)
#define CSL_SPI_SPIPC3_SOMIDOUT_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC3_SIMODOUT_MASK     (0x00000400u)
#define CSL_SPI_SPIPC3_SIMODOUT_SHIFT    (0x0000000Au)
#define CSL_SPI_SPIPC3_SIMODOUT_RESETVAL (0x00000000u)
/*----SIMODOUT Tokens----*/
#define CSL_SPI_SPIPC3_SIMODOUT_LOW      (0x00000000u)
#define CSL_SPI_SPIPC3_SIMODOUT_HIGH     (0x00000001u)

#define CSL_SPI_SPIPC3_CLKDOUT_MASK      (0x00000200u)
#define CSL_SPI_SPIPC3_CLKDOUT_SHIFT     (0x00000009u)
#define CSL_SPI_SPIPC3_CLKDOUT_RESETVAL  (0x00000000u)
/*----CLKDOUT Tokens----*/
#define CSL_SPI_SPIPC3_CLKDOUT_LOW       (0x00000000u)
#define CSL_SPI_SPIPC3_CLKDOUT_HIGH      (0x00000001u)

#define CSL_SPI_SPIPC3_ENADOUT_MASK      (0x00000100u)
#define CSL_SPI_SPIPC3_ENADOUT_SHIFT     (0x00000008u)
#define CSL_SPI_SPIPC3_ENADOUT_RESETVAL  (0x00000000u)
/*----ENADOUT Tokens----*/
#define CSL_SPI_SPIPC3_ENADOUT_LOW       (0x00000000u)
#define CSL_SPI_SPIPC3_ENADOUT_HIGH      (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT7_MASK    (0x00000080u)
#define CSL_SPI_SPIPC3_SCS0DOUT7_SHIFT   (0x00000007u)
#define CSL_SPI_SPIPC3_SCS0DOUT7_RESETVAL (0x00000000u)
/*----SCS0DOUT7 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT7_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT7_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT6_MASK    (0x00000040u)
#define CSL_SPI_SPIPC3_SCS0DOUT6_SHIFT   (0x00000006u)
#define CSL_SPI_SPIPC3_SCS0DOUT6_RESETVAL (0x00000000u)
/*----SCS0DOUT6 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT6_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT6_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT5_MASK    (0x00000020u)
#define CSL_SPI_SPIPC3_SCS0DOUT5_SHIFT   (0x00000005u)
#define CSL_SPI_SPIPC3_SCS0DOUT5_RESETVAL (0x00000000u)
/*----SCS0DOUT5 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT5_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT5_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT4_MASK    (0x00000010u)
#define CSL_SPI_SPIPC3_SCS0DOUT4_SHIFT   (0x00000004u)
#define CSL_SPI_SPIPC3_SCS0DOUT4_RESETVAL (0x00000000u)
/*----SCS0DOUT4 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT4_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT4_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT3_MASK    (0x00000008u)
#define CSL_SPI_SPIPC3_SCS0DOUT3_SHIFT   (0x00000003u)
#define CSL_SPI_SPIPC3_SCS0DOUT3_RESETVAL (0x00000000u)
/*----SCS0DOUT3 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT3_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT3_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT2_MASK    (0x00000004u)
#define CSL_SPI_SPIPC3_SCS0DOUT2_SHIFT   (0x00000002u)
#define CSL_SPI_SPIPC3_SCS0DOUT2_RESETVAL (0x00000000u)
/*----SCS0DOUT2 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT2_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT2_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT1_MASK    (0x00000002u)
#define CSL_SPI_SPIPC3_SCS0DOUT1_SHIFT   (0x00000001u)
#define CSL_SPI_SPIPC3_SCS0DOUT1_RESETVAL (0x00000000u)
/*----SCS0DOUT1 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT1_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT1_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_SCS0DOUT0_MASK    (0x00000001u)
#define CSL_SPI_SPIPC3_SCS0DOUT0_SHIFT   (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT0_RESETVAL (0x00000000u)
/*----SCS0DOUT0 Tokens----*/
#define CSL_SPI_SPIPC3_SCS0DOUT0_LOW     (0x00000000u)
#define CSL_SPI_SPIPC3_SCS0DOUT0_HIGH    (0x00000001u)

#define CSL_SPI_SPIPC3_RESETVAL          (0x00000000u)

/* SPIPC4 */


#define CSL_SPI_SPIPC4_SOMISET_MASK      (0x00000800u)
#define CSL_SPI_SPIPC4_SOMISET_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC4_SOMISET_RESETVAL  (0x00000000u)
/*----SOMISET Tokens----*/
#define CSL_SPI_SPIPC4_SOMISET_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SOMISET_SET       (0x00000001u)

#define CSL_SPI_SPIPC4_SIMOSET_MASK      (0x00000400u)
#define CSL_SPI_SPIPC4_SIMOSET_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC4_SIMOSET_RESETVAL  (0x00000000u)
/*----SIMOSET Tokens----*/
#define CSL_SPI_SPIPC4_SIMOSET_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SIMOSET_SET       (0x00000001u)

#define CSL_SPI_SPIPC4_CLKSET_MASK       (0x00000200u)
#define CSL_SPI_SPIPC4_CLKSET_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC4_CLKSET_RESETVAL   (0x00000000u)
/*----CLKSET Tokens----*/
#define CSL_SPI_SPIPC4_CLKSET_NO_EFFECT  (0x00000000u)
#define CSL_SPI_SPIPC4_CLKSET_SET        (0x00000001u)

#define CSL_SPI_SPIPC4_ENASET_MASK       (0x00000100u)
#define CSL_SPI_SPIPC4_ENASET_SHIFT      (0x00000008u)
#define CSL_SPI_SPIPC4_ENASET_RESETVAL   (0x00000000u)
/*----ENASET Tokens----*/
#define CSL_SPI_SPIPC4_ENASET_NO_EFFECT  (0x00000000u)
#define CSL_SPI_SPIPC4_ENASET_SET        (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET7_MASK     (0x00000080u)
#define CSL_SPI_SPIPC4_SCS0SET7_SHIFT    (0x00000007u)
#define CSL_SPI_SPIPC4_SCS0SET7_RESETVAL (0x00000000u)
/*----SCS0SET7 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET7_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET7_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET6_MASK     (0x00000040u)
#define CSL_SPI_SPIPC4_SCS0SET6_SHIFT    (0x00000006u)
#define CSL_SPI_SPIPC4_SCS0SET6_RESETVAL (0x00000000u)
/*----SCS0SET6 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET6_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET6_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET5_MASK     (0x00000020u)
#define CSL_SPI_SPIPC4_SCS0SET5_SHIFT    (0x00000005u)
#define CSL_SPI_SPIPC4_SCS0SET5_RESETVAL (0x00000000u)
/*----SCS0SET5 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET5_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET5_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET4_MASK     (0x00000010u)
#define CSL_SPI_SPIPC4_SCS0SET4_SHIFT    (0x00000004u)
#define CSL_SPI_SPIPC4_SCS0SET4_RESETVAL (0x00000000u)
/*----SCS0SET4 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET4_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET4_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET3_MASK     (0x00000008u)
#define CSL_SPI_SPIPC4_SCS0SET3_SHIFT    (0x00000003u)
#define CSL_SPI_SPIPC4_SCS0SET3_RESETVAL (0x00000000u)
/*----SCS0SET3 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET3_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET3_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET2_MASK     (0x00000004u)
#define CSL_SPI_SPIPC4_SCS0SET2_SHIFT    (0x00000002u)
#define CSL_SPI_SPIPC4_SCS0SET2_RESETVAL (0x00000000u)
/*----SCS0SET2 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET2_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET2_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET1_MASK     (0x00000002u)
#define CSL_SPI_SPIPC4_SCS0SET1_SHIFT    (0x00000001u)
#define CSL_SPI_SPIPC4_SCS0SET1_RESETVAL (0x00000000u)
/*----SCS0SET1 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET1_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET1_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_SCS0SET0_MASK     (0x00000001u)
#define CSL_SPI_SPIPC4_SCS0SET0_SHIFT    (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET0_RESETVAL (0x00000000u)
/*----SCS0SET0 Tokens----*/
#define CSL_SPI_SPIPC4_SCS0SET0_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC4_SCS0SET0_SET      (0x00000001u)

#define CSL_SPI_SPIPC4_RESETVAL          (0x00000000u)

/* SPIPC5 */


#define CSL_SPI_SPIPC5_SOMICLR_MASK      (0x00000800u)
#define CSL_SPI_SPIPC5_SOMICLR_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC5_SOMICLR_RESETVAL  (0x00000000u)
/*----SOMICLR Tokens----*/
#define CSL_SPI_SPIPC5_SOMICLR_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SOMICLR_CLEAR     (0x00000001u)

#define CSL_SPI_SPIPC5_SIMOCLR_MASK      (0x00000400u)
#define CSL_SPI_SPIPC5_SIMOCLR_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC5_SIMOCLR_RESETVAL  (0x00000000u)
/*----SIMOCLR Tokens----*/
#define CSL_SPI_SPIPC5_SIMOCLR_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SIMOCLR_CLEAR     (0x00000001u)

#define CSL_SPI_SPIPC5_CLKCLR_MASK       (0x00000200u)
#define CSL_SPI_SPIPC5_CLKCLR_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC5_CLKCLR_RESETVAL   (0x00000000u)
/*----CLKCLR Tokens----*/
#define CSL_SPI_SPIPC5_CLKCLR_NO_EFFECT  (0x00000000u)
#define CSL_SPI_SPIPC5_CLKCLR_CLEAR      (0x00000001u)

#define CSL_SPI_SPIPC5_ENACLR_MASK       (0x00000100u)
#define CSL_SPI_SPIPC5_ENACLR_SHIFT      (0x00000008u)
#define CSL_SPI_SPIPC5_ENACLR_RESETVAL   (0x00000000u)
/*----ENACLR Tokens----*/
#define CSL_SPI_SPIPC5_ENACLR_NO_EFFECT  (0x00000000u)
#define CSL_SPI_SPIPC5_ENACLR_CLEAR      (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR7_MASK     (0x00000080u)
#define CSL_SPI_SPIPC5_SCS0CLR7_SHIFT    (0x00000007u)
#define CSL_SPI_SPIPC5_SCS0CLR7_RESETVAL (0x00000000u)
/*----SCS0CLR7 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR7_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR7_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR6_MASK     (0x00000040u)
#define CSL_SPI_SPIPC5_SCS0CLR6_SHIFT    (0x00000006u)
#define CSL_SPI_SPIPC5_SCS0CLR6_RESETVAL (0x00000000u)
/*----SCS0CLR6 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR6_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR6_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR5_MASK     (0x00000020u)
#define CSL_SPI_SPIPC5_SCS0CLR5_SHIFT    (0x00000005u)
#define CSL_SPI_SPIPC5_SCS0CLR5_RESETVAL (0x00000000u)
/*----SCS0CLR5 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR5_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR5_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR4_MASK     (0x00000010u)
#define CSL_SPI_SPIPC5_SCS0CLR4_SHIFT    (0x00000004u)
#define CSL_SPI_SPIPC5_SCS0CLR4_RESETVAL (0x00000000u)
/*----SCS0CLR4 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR4_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR4_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR3_MASK     (0x00000008u)
#define CSL_SPI_SPIPC5_SCS0CLR3_SHIFT    (0x00000003u)
#define CSL_SPI_SPIPC5_SCS0CLR3_RESETVAL (0x00000000u)
/*----SCS0CLR3 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR3_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR3_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR2_MASK     (0x00000004u)
#define CSL_SPI_SPIPC5_SCS0CLR2_SHIFT    (0x00000002u)
#define CSL_SPI_SPIPC5_SCS0CLR2_RESETVAL (0x00000000u)
/*----SCS0CLR2 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR2_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR2_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR1_MASK     (0x00000002u)
#define CSL_SPI_SPIPC5_SCS0CLR1_SHIFT    (0x00000001u)
#define CSL_SPI_SPIPC5_SCS0CLR1_RESETVAL (0x00000000u)
/*----SCS0CLR1 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR1_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR1_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_SCS0CLR0_MASK     (0x00000001u)
#define CSL_SPI_SPIPC5_SCS0CLR0_SHIFT    (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR0_RESETVAL (0x00000000u)
/*----SCS0CLR0 Tokens----*/
#define CSL_SPI_SPIPC5_SCS0CLR0_NO_EFFECT (0x00000000u)
#define CSL_SPI_SPIPC5_SCS0CLR0_CLEAR    (0x00000001u)

#define CSL_SPI_SPIPC5_RESETVAL          (0x00000000u)

/* SPIDAT0 */


#define CSL_SPI_SPIDAT0_TXDATA_MASK      (0x0000FFFFu)
#define CSL_SPI_SPIDAT0_TXDATA_SHIFT     (0x00000000u)
#define CSL_SPI_SPIDAT0_TXDATA_RESETVAL  (0x00000000u)

#define CSL_SPI_SPIDAT0_RESETVAL         (0x00000000u)

/* SPIDAT1 */


#define CSL_SPI_SPIDAT1_CSHOLD_MASK      (0x10000000u)
#define CSL_SPI_SPIDAT1_CSHOLD_SHIFT     (0x0000001Cu)
#define CSL_SPI_SPIDAT1_CSHOLD_RESETVAL  (0x00000000u)
/*----CSHOLD Tokens----*/
#define CSL_SPI_SPIDAT1_CSHOLD_DISABLE   (0x00000000u)
#define CSL_SPI_SPIDAT1_CSHOLD_ENABLE    (0x00000001u)


#define CSL_SPI_SPIDAT1_WDEL_MASK        (0x04000000u)
#define CSL_SPI_SPIDAT1_WDEL_SHIFT       (0x0000001Au)
#define CSL_SPI_SPIDAT1_WDEL_RESETVAL    (0x00000000u)
/*----WDEL Tokens----*/
#define CSL_SPI_SPIDAT1_WDEL_DISABLE     (0x00000000u)
#define CSL_SPI_SPIDAT1_WDEL_ENABLE      (0x00000001u)

#define CSL_SPI_SPIDAT1_DFSEL_MASK       (0x03000000u)
#define CSL_SPI_SPIDAT1_DFSEL_SHIFT      (0x00000018u)
#define CSL_SPI_SPIDAT1_DFSEL_RESETVAL   (0x00000000u)
/*----DFSEL Tokens----*/
#define CSL_SPI_SPIDAT1_DFSEL_FORMAT0    (0x00000000u)
#define CSL_SPI_SPIDAT1_DFSEL_FORMAT1    (0x00000001u)
#define CSL_SPI_SPIDAT1_DFSEL_FORMAT2    (0x00000002u)
#define CSL_SPI_SPIDAT1_DFSEL_FORMAT3    (0x00000003u)

#define CSL_SPI_SPIDAT1_CSNR_MASK        (0x00FF0000u)
#define CSL_SPI_SPIDAT1_CSNR_SHIFT       (0x00000010u)
#define CSL_SPI_SPIDAT1_CSNR_RESETVAL    (0x00000000u)

#define CSL_SPI_SPIDAT1_TXDATA_MASK      (0x0000FFFFu)
#define CSL_SPI_SPIDAT1_TXDATA_SHIFT     (0x00000000u)
#define CSL_SPI_SPIDAT1_TXDATA_RESETVAL  (0x00000000u)

#define CSL_SPI_SPIDAT1_RESETVAL         (0x00000000u)

/* SPIBUF */

#define CSL_SPI_SPIBUF_RXEMPTY_MASK      (0x80000000u)
#define CSL_SPI_SPIBUF_RXEMPTY_SHIFT     (0x0000001Fu)
#define CSL_SPI_SPIBUF_RXEMPTY_RESETVAL  (0x00000001u)
/*----RXEMPTY Tokens----*/
#define CSL_SPI_SPIBUF_RXEMPTY_NO_EMPTY  (0x00000000u)
#define CSL_SPI_SPIBUF_RXEMPTY_EMPTY     (0x00000001u)

#define CSL_SPI_SPIBUF_RXOVR_MASK        (0x40000000u)
#define CSL_SPI_SPIBUF_RXOVR_SHIFT       (0x0000001Eu)
#define CSL_SPI_SPIBUF_RXOVR_RESETVAL    (0x00000000u)
/*----RXOVR Tokens----*/
#define CSL_SPI_SPIBUF_RXOVR_NO_ERROR    (0x00000000u)
#define CSL_SPI_SPIBUF_RXOVR_ERROR       (0x00000001u)

#define CSL_SPI_SPIBUF_TXFULL_MASK       (0x20000000u)
#define CSL_SPI_SPIBUF_TXFULL_SHIFT      (0x0000001Du)
#define CSL_SPI_SPIBUF_TXFULL_RESETVAL   (0x00000000u)
/*----TXFULL Tokens----*/
#define CSL_SPI_SPIBUF_TXFULL_NO_FULL    (0x00000000u)
#define CSL_SPI_SPIBUF_TXFULL_FULL       (0x00000001u)

#define CSL_SPI_SPIBUF_BITERR_MASK       (0x10000000u)
#define CSL_SPI_SPIBUF_BITERR_SHIFT      (0x0000001Cu)
#define CSL_SPI_SPIBUF_BITERR_RESETVAL   (0x00000000u)
/*----BITERR Tokens----*/
#define CSL_SPI_SPIBUF_BITERR_NO_ERROR   (0x00000000u)
#define CSL_SPI_SPIBUF_BITERR_ERROR      (0x00000001u)

#define CSL_SPI_SPIBUF_DESYNC_MASK       (0x08000000u)
#define CSL_SPI_SPIBUF_DESYNC_SHIFT      (0x0000001Bu)
#define CSL_SPI_SPIBUF_DESYNC_RESETVAL   (0x00000000u)
/*----DESYNC Tokens----*/
#define CSL_SPI_SPIBUF_DESYNC_NO_ERROR   (0x00000000u)
#define CSL_SPI_SPIBUF_DESYNC_ERROR      (0x00000001u)

#define CSL_SPI_SPIBUF_PARERR_MASK       (0x04000000u)
#define CSL_SPI_SPIBUF_PARERR_SHIFT      (0x0000001Au)
#define CSL_SPI_SPIBUF_PARERR_RESETVAL   (0x00000000u)
/*----PARERR Tokens----*/
#define CSL_SPI_SPIBUF_PARERR_NO_ERROR   (0x00000000u)
#define CSL_SPI_SPIBUF_PARERR_ERROR      (0x00000001u)

#define CSL_SPI_SPIBUF_TIMEOUT_MASK      (0x02000000u)
#define CSL_SPI_SPIBUF_TIMEOUT_SHIFT     (0x00000019u)
#define CSL_SPI_SPIBUF_TIMEOUT_RESETVAL  (0x00000000u)
/*----TIMEOUT Tokens----*/
#define CSL_SPI_SPIBUF_TIMEOUT_NO_ERROR  (0x00000000u)
#define CSL_SPI_SPIBUF_TIMEOUT_ERROR     (0x00000001u)

#define CSL_SPI_SPIBUF_DLENERR_MASK      (0x01000000u)
#define CSL_SPI_SPIBUF_DLENERR_SHIFT     (0x00000018u)
#define CSL_SPI_SPIBUF_DLENERR_RESETVAL  (0x00000000u)
/*----DLENERR Tokens----*/
#define CSL_SPI_SPIBUF_DLENERR_NO_ERROR  (0x00000000u)
#define CSL_SPI_SPIBUF_DLENERR_ERROR     (0x00000001u)


#define CSL_SPI_SPIBUF_RXDATA_MASK       (0x0000FFFFu)
#define CSL_SPI_SPIBUF_RXDATA_SHIFT      (0x00000000u)
#define CSL_SPI_SPIBUF_RXDATA_RESETVAL   (0x00000000u)

#define CSL_SPI_SPIBUF_RESETVAL          (0x80000000u)

/* SPIEMU */


#define CSL_SPI_SPIEMU_RXDATA_MASK       (0x0000FFFFu)
#define CSL_SPI_SPIEMU_RXDATA_SHIFT      (0x00000000u)
#define CSL_SPI_SPIEMU_RXDATA_RESETVAL   (0x00000000u)

#define CSL_SPI_SPIEMU_RESETVAL          (0x00000000u)

/* SPIDELAY */

#define CSL_SPI_SPIDELAY_C2TDELAY_MASK   (0xFF000000u)
#define CSL_SPI_SPIDELAY_C2TDELAY_SHIFT  (0x00000018u)
#define CSL_SPI_SPIDELAY_C2TDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_T2CDELAY_MASK   (0x00FF0000u)
#define CSL_SPI_SPIDELAY_T2CDELAY_SHIFT  (0x00000010u)
#define CSL_SPI_SPIDELAY_T2CDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_T2EDELAY_MASK   (0x0000FF00u)
#define CSL_SPI_SPIDELAY_T2EDELAY_SHIFT  (0x00000008u)
#define CSL_SPI_SPIDELAY_T2EDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_C2EDELAY_MASK   (0x000000FFu)
#define CSL_SPI_SPIDELAY_C2EDELAY_SHIFT  (0x00000000u)
#define CSL_SPI_SPIDELAY_C2EDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_RESETVAL        (0x00000000u)

/* SPIDEF */


#define CSL_SPI_SPIDEF_CSDEF0_MASK       (0x00000001u)
#define CSL_SPI_SPIDEF_CSDEF0_SHIFT      (0x00000000u)
#define CSL_SPI_SPIDEF_CSDEF0_RESETVAL   (0x00000001u)
/*----CSDEF0 Tokens----*/
#define CSL_SPI_SPIDEF_CSDEF0_LOW        (0x00000000u)
#define CSL_SPI_SPIDEF_CSDEF0_HIGH       (0x00000001u)

#define CSL_SPI_SPIDEF_RESETVAL          (0x00000001u)

/* SPIFMT */


#define CSL_SPI_SPIFMT_WDELAY_MASK       (0x3F000000u)
#define CSL_SPI_SPIFMT_WDELAY_SHIFT      (0x00000018u)
#define CSL_SPI_SPIFMT_WDELAY_RESETVAL   (0x00000000u)

#define CSL_SPI_SPIFMT_PARPOL_MASK       (0x00800000u)
#define CSL_SPI_SPIFMT_PARPOL_SHIFT      (0x00000017u)
#define CSL_SPI_SPIFMT_PARPOL_RESETVAL   (0x00000000u)
/*----PARPOL Tokens----*/
#define CSL_SPI_SPIFMT_PARPOL_EVEN       (0x00000000u)
#define CSL_SPI_SPIFMT_PARPOL_ODD        (0x00000001u)

#define CSL_SPI_SPIFMT_PARENA_MASK       (0x00400000u)
#define CSL_SPI_SPIFMT_PARENA_SHIFT      (0x00000016u)
#define CSL_SPI_SPIFMT_PARENA_RESETVAL   (0x00000000u)
/*----PARENA Tokens----*/
#define CSL_SPI_SPIFMT_PARENA_DISABLE    (0x00000000u)
#define CSL_SPI_SPIFMT_PARENA_ENABLE     (0x00000001u)

#define CSL_SPI_SPIFMT_WAITENA_MASK      (0x00200000u)
#define CSL_SPI_SPIFMT_WAITENA_SHIFT     (0x00000015u)
#define CSL_SPI_SPIFMT_WAITENA_RESETVAL  (0x00000000u)
/*----WAITENA Tokens----*/
#define CSL_SPI_SPIFMT_WAITENA_DISABLE   (0x00000000u)
#define CSL_SPI_SPIFMT_WAITENA_ENABLE    (0x00000001u)

#define CSL_SPI_SPIFMT_SHIFTDIR_MASK     (0x00100000u)
#define CSL_SPI_SPIFMT_SHIFTDIR_SHIFT    (0x00000014u)
#define CSL_SPI_SPIFMT_SHIFTDIR_RESETVAL (0x00000000u)
/*----SHIFTDIR Tokens----*/
#define CSL_SPI_SPIFMT_SHIFTDIR_MSB      (0x00000000u)
#define CSL_SPI_SPIFMT_SHIFTDIR_LSB      (0x00000001u)


#define CSL_SPI_SPIFMT_DISCSTIMERS_MASK  (0x00040000u)
#define CSL_SPI_SPIFMT_DISCSTIMERS_SHIFT (0x00000012u)
#define CSL_SPI_SPIFMT_DISCSTIMERS_RESETVAL (0x00000000u)
/*----DISCSTIMERS Tokens----*/
#define CSL_SPI_SPIFMT_DISCSTIMERS_DISABLE (0x00000000u)
#define CSL_SPI_SPIFMT_DISCSTIMERS_ENABLE (0x00000001u)

#define CSL_SPI_SPIFMT_POLARITY_MASK     (0x00020000u)
#define CSL_SPI_SPIFMT_POLARITY_SHIFT    (0x00000011u)
#define CSL_SPI_SPIFMT_POLARITY_RESETVAL (0x00000000u)
/*----POLARITY Tokens----*/
#define CSL_SPI_SPIFMT_POLARITY_LOW      (0x00000000u)
#define CSL_SPI_SPIFMT_POLARITY_HIGH     (0x00000001u)

#define CSL_SPI_SPIFMT_PHASE_MASK        (0x00010000u)
#define CSL_SPI_SPIFMT_PHASE_SHIFT       (0x00000010u)
#define CSL_SPI_SPIFMT_PHASE_RESETVAL    (0x00000000u)
/*----PHASE Tokens----*/
#define CSL_SPI_SPIFMT_PHASE_NO_DELAY    (0x00000000u)
#define CSL_SPI_SPIFMT_PHASE_DELAY       (0x00000001u)

#define CSL_SPI_SPIFMT_PRESCALE_MASK     (0x0000FF00u)
#define CSL_SPI_SPIFMT_PRESCALE_SHIFT    (0x00000008u)
#define CSL_SPI_SPIFMT_PRESCALE_RESETVAL (0x00000000u)


#define CSL_SPI_SPIFMT_CHARLEN_MASK      (0x0000001Fu)
#define CSL_SPI_SPIFMT_CHARLEN_SHIFT     (0x00000000u)
#define CSL_SPI_SPIFMT_CHARLEN_RESETVAL  (0x00000000u)

#define CSL_SPI_SPIFMT_RESETVAL          (0x00000000u)

/* INTVEC */


#define CSL_SPI_INTVEC_INTVECT_MASK      (0x0000003Eu)
#define CSL_SPI_INTVEC_INTVECT_SHIFT     (0x00000001u)
#define CSL_SPI_INTVEC_INTVECT_RESETVAL  (0x00000000u)


#define CSL_SPI_INTVEC_RESETVAL          (0x00000000u)

#endif
