module hpi(sysclk,locked,hrdy,hint,rw,hds1,hds2,hcs,has,hcntl,hd,step);

inout  [31:0] hd;

input  hrdy;
input  hint;
input  locked;
input  sysclk;

output  rw;
output  hds1;
output  hds2;
output  hcs;
output  has;
output  [1:0] hcntl;
output  step;


reg  [31:0] tdata;
reg  [31:0] hd_reg;
reg  [31:0] data;
reg  [31:0] data1;
reg  hcs;
reg  has;
reg  hds1;
reg  hds2;
reg  rw;
reg  wrcontrol;
reg  [1:0]hcntl;
reg  [1:0]control;
reg  [1:0]cnt;
reg  [5:0]step;
reg  [2:0]cnt1;


parameter HPIC=2'b00;// control HPI control register
parameter HPIA=2'b01;// address HPI address register
parameter HPIDS=2'b10;// successive write 
parameter HPID=2'b11;// fix address write 

parameter state1=7'b0000001;// state 
parameter state2=7'b0000010;
parameter state3=7'b0000100;
parameter state4=7'b0001000;
parameter state5=7'b0010000;
parameter state6=7'b0100000;
parameter state7=7'b1000000;



parameter  DPIC=32'h00000000;// control data 
parameter  DPIA=32'h000D223C;// address data 
parameter  DPID=32'h05050505;// write or read data 

parameter  write=1'b0;
parameter  read=1'b1;

wire  ready;
wire  plllocked;

assign   ready=hrdy;
assign   plllocked=locked;
assign   hd=(rw==0)?hd_reg:32'bz;


always @ (posedge sysclk)
begin
    tdata<=data1;
end

always @ (posedge sysclk )
begin
   if(plllocked)//PLL locked go
   	begin
			case (step)
               state1:
						begin
							 rw<=wrcontrol;  
							 hcs<=0;
						    has<=1;
							 hds1<=0;
							 hds2<=0;
							 cnt1<=0;
							 step<=state2;
							 hcntl<=control;
						end
					state2:
                   begin
						    hds2<=1;
                      step<=state3;
                   end
               state3:
                   begin
						    if(ready==0)
								begin 
                              step<=state4;
                                  if(rw==0)
                                       begin
                                           hd_reg<=data;//当写控制寄存器或者地址寄存器的时候将要发给DSP寄存器的数据给hd_reg
											      end
                                  else
                                       begin
                                           data1<=hd;//当读的时候将DSP中的数据传到data1中
                                       end
                        end
                       else
                         begin
                            step<=state3;
								 end
                                                           
                    end
                state4:
                        begin 
								cnt1<=cnt1+1;
								   if(cnt1<3'd3)
										step<=state4;
									else 
										step<=state5;
                        end
                state5:
                    begin
                        hds2<=0; 
								step<=state6;
                    end
					 state6:
                    begin
							   hcs<=1;
								step<=state7;
								if(cnt==2'b10)
									begin
										 cnt<=2'b00;
									end
								else
									begin
										 cnt<=cnt+1;
									end
										 
						   end
                state7:
                     begin
                         step<=state1;
                     end        
					default :
				      	begin
                          step<=state1;
                     end
         endcase
                        
      end
    else// PLL unlock wait 
		begin
           cnt<=2'b00;
           step<=state1;           
			  hcs<=1;
           hds1<=0;
           hds2<=0;
	   end
end

always @ (posedge sysclk)
begin
   if(plllocked)
		begin
          if(cnt==2'b10)
               begin
						wrcontrol<=read;
               end
          else
					begin
                   wrcontrol<=write;
               end
		end
   else
		begin
         wrcontrol<=write;
      end
          
end
always @ (posedge sysclk)
begin
   if(plllocked)
		begin
          if(cnt==2'b00)
               begin 
						control<=2'b00;
						data<=32'h00000000;
				   end
			 else if(cnt==2'b01)
					begin
						control<=2'b01;
						data<=32'h000e1234;
				   end
			 else if(cnt==2'b10)
					begin
						control<=2'b11;
				   end
			 else
					begin
						control<=2'b00;
						data<=32'h00000000;
				   end				  
		end
  else
       begin
          control<=2'b00;
          data<=32'h00000000;
       end
end
endmodule
