-c  /* ROM autoinitialization module */
-a  /* LINK USING C CONVENTIONS      */

-heap  0x800000
-stack 0x0A000



MEMORY
{
    DDR3  (RWX) : org = 0x80000000, len = 0x20000000
    MSMC		: org = 0x0C000000, len = 0x001FFFFF

    L1D:     o = 00f00000h   l = 00007FFFh
    L1P:     o = 00e00000h   l = 00007FFFh
    L2SRAM:  o = 10800000h   l = 00080000h
}

SECTIONS
{
  .text > DDR3
  .MSMC_buffers      >       MSMC
  .DDR3_buffers      >       DDR3
  .L2_buffers        >       L2SRAM

  GROUP (NEAR_DP)
  {
    .neardata
    .rodata
    .bss
  } load > DDR3

  .stack    > DDR3
  .cinit    > DDR3
  .cio      > DDR3
  .const    > DDR3
  .data     > DDR3
  .far      > DDR3
  .switch   > DDR3
  .sysmem   > DDR3
  .fardata  > DDR3

  image_mem > DDR3
}
