#include <math.h>
#include <stdio.h>
#include "fft_corr.h"
#include "DSP_fft32x32.h"
#include "DSP_ifft32x32.h"


void correl(int * x,int l,int * h,int m,int * r,int N)
{
 
  float temp1,temp2,temp3,temp4;
  int  i;
  int * x_in=(int *)malloc(2*N*sizeof(int));
  int * x_out=(int *)malloc(2*N*sizeof(int));
  int * h_in=(int *)malloc(2*N*sizeof(int));
  int * h_out=(int *)malloc(2*N*sizeof(int));
  int * r_in=(int *)malloc(2*N*sizeof(int));
  int * r_out=(int *)malloc(2*N*sizeof(int));

  int * fft_corr=(int *)malloc(2*N*sizeof(int));
  int * ifft_corr=(int *)malloc(2*N*sizeof(int));

  gen_twiddle_fft32x32(fft_corr,N);
  gen_twiddle_fft32x32(ifft_corr,N);
	for(i = 0;i<N;i++)
	{
		ifft_corr[2*i+1] = - ifft_corr[2*i+1];
	}	

    memset(x_in,0,2*N*sizeof(int));
	memset(h_in,0,2*N*sizeof(int));

	for(i =0;i<l;i++)
	{
		x_in[2*i] = x[i];
	}
	for(i =0;i<m;i++)
	{
		h_in[2*i] = h[i];

	}
										  
    DSP_fft32x32(fft_corr, N, x_in, x_out);
	
    DSP_fft32x32(fft_corr, N, h_in, h_out);

	for(i = 0;i<N;i++)
	{
		h_out[2*i+1] = - h_out[2*i+1];
	}
	for(i = 0;i<N;i++)
	{
    temp1=x_out[2*i];
    temp2=x_out[2*i+1];
    temp3=h_out[2*i];
	temp4=h_out[2*i+1];
	r_in[2*i] = (temp1*temp3- temp2*temp4);

	r_in[2*i+1] =(temp1*temp4 + temp2*temp3); 
	}



	DSP_ifft32x32(ifft_corr, N, r_in, r_out);
   



	for(i = 0;i<N ;i++)
	{	r[i] = abs(r_out[2*i]);}


    free(x_in);
	free(x_out);
	free(h_in);
	free(h_out);
	free(r_in);
	free(r_out);
	free(fft_corr);
	free(ifft_corr);

}

