        .title  "Flash bootup utility"
        .option D,T
        .length 102
        .width  140
     

BOOT_SIZE     .equ    0x40000       ;bootup code size in byte
FLASH_START   .equ    0x70000400  ;flash start address
BOOT_START    .equ    0x10800400  ;L2 sram start address

CODE_SIZE     .equ    0x30000      ;application code size in byte
CODE_START    .equ    0x400       ;application code start address

 .sect ".boot_sect" 
 .global _boot

 .ref _c_int00
 
_boot:
            MVKL  BOOT_START,A4 ;ram start address ->A4
			MVKH  BOOT_START,A4

      		MVKL  FLASH_START,B4 ;flash start address ->B4
      	    MVKH  FLASH_START,B4

	   		MVKL  BOOT_SIZE,A0  ;0xc000,B0 ;B6 = BOOT_SIZE -1024
            MVKH  BOOT_SIZE,A0  ;0xc000,B0

_wait_loop: LDH   *B4++[1],B5
            SUB	  A0,1,A0
            NOP   4
            STH   B5,*A4++[1]
      [A0]  B     _wait_loop
            NOP   5
        
            MVKL .S2 _c_int00, B0
            MVKH .S2 _c_int00, B0
            B    .S2 B0
            nop   5
; 
; end of the bootup routine
  
