/*
 * file: 		interface of gpmc&fpga
 * auther:		Damon Yu
 * date:		2015-09-09
 *
 * */

#include "gpmc.h"
#include <xdc/runtime/System.h>
#include "plat_mux.h"

#define	GPMC_BASE_ADDR		0x50000000


MUX_CONFIG GpmcMux[] = {
    { 0x0800 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad0
    { 0x0804 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad1
    { 0x0808 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT}, 	//  conf_gpmc_ad2
    { 0x080c , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad3
	{ 0x0810 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad4
	{ 0x0814 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad5
	{ 0x0818 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT}, 	//  conf_gpmc_ad6
	{ 0x081c , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad7
    { 0x0820 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT}, 	//  conf_gpmc_ad8
    { 0x0824 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT}, 	//  conf_gpmc_ad9
	{ 0x0828 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad10
	{ 0x082c , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad11
	{ 0x0830 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT}, 	//  conf_gpmc_ad12
	{ 0x0834 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad13
	{ 0x0838 , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad14
	{ 0x083c , 0 , AM335X_PIN_OUTPUT | AM335X_PIN_INPUT},	//	conf_gpmc_ad15

	{ 0x0840 , 0 , AM335X_PIN_OUTPUT }, //  conf_gpmc_a0
	{ 0x0844 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a1
	{ 0x0848 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a2
	{ 0x084c , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a3
	{ 0x0850 , 0 , AM335X_PIN_OUTPUT }, //  conf_gpmc_a4
	{ 0x0854 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a5
	{ 0x0858 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a6
	{ 0x085c , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a7
	{ 0x0860 , 0 , AM335X_PIN_OUTPUT }, //  conf_gpmc_a8
	{ 0x0864 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a9
	//{ 0x0868 , 7 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a10
	//{ 0x086c , 7 , AM335X_PIN_OUTPUT },	//	conf_gpmc_a11

	//{ 0x0870 , 7 , AM335X_PIN_INPUT }, //  conf_gpmc_wait0
	//{ 0x0874 , 7 , AM335X_PIN_OUTPUT },	//	conf_gpmc_wpn(write protect active low)
	{ 0x0878 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_ben1

	//{ 0x087c , 7 , AM335X_PIN_OUTPUT },	//	conf_gpmc_csn0
	//{ 0x0880 , 7 , AM335X_PIN_OUTPUT }, //  conf_gpmc_csn1
	{ 0x0884 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_csn2(active low)
	//{ 0x0888 , 7 , AM335X_PIN_OUTPUT },	//	conf_gpmc_csn3

	{ 0x0890 , 0 , AM335X_PIN_OUTPUT }, //  conf_gpmc_advn_ale
	{ 0x0894 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_oen_ren(active low)
	{ 0x0898 , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_wen(active low)
	//{ 0x088c , 7 , AM335X_PIN_OUTPUT },	//	conf_gpmc_clk
	//{ 0x089C , 0 , AM335X_PIN_OUTPUT },	//	conf_gpmc_ben0_cle
    {0xFFFFFFFF,0,0}
};







#include "hw_control_AM335x.h"
#include "soc_AM335x.h"
#include "hw_cm_wkup.h"
#include "hw_cm_per.h"
//#include "evmAM335x.h"
#include "hw_types.h"

/*
void GPMCClkConfig(void)
{
    HWREG(SOC_PRCM_REGS + CM_PER_L3S_CLKSTCTRL) |=
                             CM_PER_L3S_CLKSTCTRL_CLKTRCTRL_SW_WKUP;

    while((HWREG(SOC_PRCM_REGS + CM_PER_L3S_CLKSTCTRL) &
     CM_PER_L3S_CLKSTCTRL_CLKTRCTRL) != CM_PER_L3S_CLKSTCTRL_CLKTRCTRL_SW_WKUP);

    HWREG(SOC_PRCM_REGS + CM_PER_L3_CLKSTCTRL) |=
                             CM_PER_L3_CLKSTCTRL_CLKTRCTRL_SW_WKUP;

    while((HWREG(SOC_PRCM_REGS + CM_PER_L3_CLKSTCTRL) &
     CM_PER_L3_CLKSTCTRL_CLKTRCTRL) != CM_PER_L3_CLKSTCTRL_CLKTRCTRL_SW_WKUP);

    HWREG(SOC_PRCM_REGS + CM_PER_L3_INSTR_CLKCTRL) |=
                             CM_PER_L3_INSTR_CLKCTRL_MODULEMODE_ENABLE;

    while((HWREG(SOC_PRCM_REGS + CM_PER_L3_INSTR_CLKCTRL) &
                               CM_PER_L3_INSTR_CLKCTRL_MODULEMODE) !=
                                   CM_PER_L3_INSTR_CLKCTRL_MODULEMODE_ENABLE);

    HWREG(SOC_PRCM_REGS + CM_PER_L3_CLKCTRL) |=
                             CM_PER_L3_CLKCTRL_MODULEMODE_ENABLE;

    while((HWREG(SOC_PRCM_REGS + CM_PER_L3_CLKCTRL) &
        CM_PER_L3_CLKCTRL_MODULEMODE) != CM_PER_L3_CLKCTRL_MODULEMODE_ENABLE);

    HWREG(SOC_PRCM_REGS + CM_PER_OCPWP_L3_CLKSTCTRL) |=
                             CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL_SW_WKUP;

    while((HWREG(SOC_PRCM_REGS + CM_PER_OCPWP_L3_CLKSTCTRL) &
                              CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL) !=
                                CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL_SW_WKUP);

    HWREG(SOC_PRCM_REGS + CM_PER_GPMC_CLKCTRL) |=
                             CM_PER_GPMC_CLKCTRL_MODULEMODE_ENABLE;

    while((HWREG(SOC_PRCM_REGS + CM_PER_GPMC_CLKCTRL) &
      CM_PER_GPMC_CLKCTRL_MODULEMODE) != CM_PER_GPMC_CLKCTRL_MODULEMODE_ENABLE);

    HWREG(SOC_PRCM_REGS + CM_PER_ELM_CLKCTRL) |=
                             CM_PER_ELM_CLKCTRL_MODULEMODE_ENABLE;

    while((HWREG(SOC_PRCM_REGS + CM_PER_ELM_CLKCTRL) &
      CM_PER_ELM_CLKCTRL_MODULEMODE) != CM_PER_ELM_CLKCTRL_MODULEMODE_ENABLE);


    while(!(HWREG(SOC_PRCM_REGS + CM_PER_L3S_CLKSTCTRL) &
            CM_PER_L3S_CLKSTCTRL_CLKACTIVITY_L3S_GCLK));

    while(!(HWREG(SOC_PRCM_REGS + CM_PER_L3_CLKSTCTRL) &
            CM_PER_L3_CLKSTCTRL_CLKACTIVITY_L3_GCLK));

}
*/

void GPMCSystemConfig()

{
	GPMCIdleModeSelect(GPMC_BASE_ADDR, GPMC_IDLEMODE_SMARTIDLE);
	GPMCAutoIdleConfig(GPMC_BASE_ADDR, GPMC_AUTOIDLE_AUTORUN);
}

void GPMCMuxConfig1()
{

	GPMCFclkDividerSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_FCLK_DIV_BY_4);
	GPMCTimeParaGranularitySelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_TIMEPARAGRANULARITY_X1);
	GPMCAddrDataMuxProtocolSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_MUXADDDATA_NOMUX);
	GPMCDevTypeSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_DEVICETYPE_NORLIKE);
	//
	GPMCDevSizeSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_DEVICESIZE_16BITS);
	//
	GPMCWaitPinSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_WAIT_PIN0);
	//
	GPMCWaitMonitoringTimeSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_WAITMONITORINGTIME_TWOCLKB4_VALIDDATA);
	GPMCWaitPinMonitoringConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_MODE_READ, GPMC_WAITMONITORING_DISABLE);
	GPMCWaitPinMonitoringConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_MODE_WRITE, GPMC_WAITMONITORING_DISABLE);
	//
	GPMCClkActivationTimeConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_CLKACTIVATIONTIME_TWOCLK_AFTR);
	//
	GPMCDevPageLenSet(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_DEV_PAGELENGTH_SIXTEEN);
	GPMCWriteTypeSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_WRITETYPE_ASYNC);
	GPMCReadTypeSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_READTYPE_ASYNC);
	GPMCAccessTypeSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_MODE_READ, GPMC_ACCESSTYPE_SINGLE);
	GPMCAccessTypeSelect(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_MODE_WRITE, GPMC_ACCESSTYPE_SINGLE);
	GPMCSyncWrapBurstConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_WRAPBURST_DISABLE);
}

 void GPMCMuxConfig2()
{
	unsigned int CSWrOffTime = 15;
	unsigned int CSRdOffTime = 15 ;
	unsigned int CSExtDelayFlag = 0;
	unsigned int CSOnTime = 1;

	unsigned int value = GPMC_CS_TIMING_CONFIG(CSWrOffTime, CSRdOffTime, CSExtDelayFlag, CSOnTime );

	GPMCCSTimingConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, value);
}

 void GPMCMuxConfig3()
{
	unsigned int ADVAADMuxWrOffTime = 0;
	unsigned int ADVAADMuxRdOffTime = 0;
	unsigned int ADVWrOffTime = 15;
	unsigned int ADVRdOffTime = 15;
	unsigned int ADVExtDelayFlag = 0;
	unsigned int ADVAADMuxOnTime = 0;
	unsigned int ADVOnTime = 1;

	unsigned int value = GPMC_ADV_TIMING_CONFIG(ADVAADMuxWrOffTime, ADVAADMuxRdOffTime, ADVWrOffTime, ADVRdOffTime, ADVExtDelayFlag, ADVAADMuxOnTime, ADVOnTime);

	GPMCADVTimingConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, value);
}

 void GPMCMuxConfig4()
{
	unsigned int WEOffTime = 15;
	unsigned int WEExtDelayFlag = 0;
	unsigned int WEOnTime = 1;
	unsigned int OEAADMuxOffTime = 0;
	unsigned int OEOffTime = 15;
	unsigned int OEExtDelayFlag = 0;
	unsigned int OEAADMuxOnTime = 0;
	unsigned int OEOnTime = 1;

	unsigned int value = GPMC_WE_OE_TIMING_CONFIG(WEOffTime, WEExtDelayFlag, WEOnTime, OEAADMuxOffTime, OEOffTime, OEExtDelayFlag, OEAADMuxOnTime,OEOnTime);

	GPMCWEAndOETimingConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, value);
}


 void GPMCMuxConfig5()
{
	unsigned int rdCycleTime = 15;
	unsigned int wrCycleTime = 15;
	unsigned int rdAccessTime = 12;
	unsigned int pageBurstAccessTime = 3;

	unsigned int value = GPMC_RDACCESS_CYCLETIME_TIMING_CONFIG(rdCycleTime, wrCycleTime, rdAccessTime, pageBurstAccessTime );

	GPMCRdAccessAndCycleTimeTimingConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, value);
}


 void GPMCMuxConfig6()
{
	unsigned int cycle2CycleDelay = 3;
	unsigned int cycle2CycleDelaySameCSCfg = 1;
	unsigned int cycle2CycleDelayDiffCSCfg = 1;
	unsigned int busTAtime = 3;

	unsigned int value = GPMC_CYCLE2CYCLE_BUSTURNAROUND_TIMING_CONFIG(cycle2CycleDelay, cycle2CycleDelaySameCSCfg, cycle2CycleDelayDiffCSCfg, busTAtime );

	unsigned int wrAccessTime = 12;
	unsigned int wrDataOnADmuxBus = 3;

	GPMCycle2CycleAndTurnArndTimeTimingConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, value);
	GPMCWrAccessAndWrDataOnADMUXBusTimingConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, wrAccessTime, wrDataOnADmuxBus);
}

 void GPMCMuxConfig7()
{

	 unsigned int baseaddress = 0x0a;		//ַռ  	start:	0x0a000000
	 	 	 	 	 	 	 	 	 	//		end: 	0x0a000000 + 0x0EFFFFFF

	GPMCBaseAddrSet(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, baseaddress);
	GPMCCSConfig(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_CS_ENABLE);
	GPMCMaskAddrSet(GPMC_BASE_ADDR, GPMC_CHIP_SELECT_2, GPMC_CS_SIZE_32MB);
}




 void GpmcInitial()
{
	unsigned int revision;

	System_printf("##### GPMC Initial ##### \n");
	PinMuxConfig(GpmcMux);

	//λ
	GPMCModuleSoftReset(GPMC_BASE_ADDR);
	//λ
	while(!GPMCModuleResetStatusGet(GPMC_BASE_ADDR))

	System_printf("#####  GPMCModuleSoftReset ##### \n");

	GPMCSystemConfig();
	System_printf("#####  GPMCSystemConfig ##### \n");
	//config 1 ~ 7
	GPMCMuxConfig1();
	System_printf("#####  GPMCMuxConfig1 ##### \n");
	GPMCMuxConfig2();
	System_printf("#####  GPMCMuxConfig2 ##### \n");
	GPMCMuxConfig3();
	System_printf("#####  GPMCMuxConfig3 ##### \n");
	GPMCMuxConfig4();
	System_printf("#####  GPMCMuxConfig4 ##### \n");
	GPMCMuxConfig5();
	System_printf("#####  GPMCMuxConfig5 ##### \n");
	GPMCMuxConfig6();
	System_printf("#####  GPMCMuxConfig6 ##### \n");
	GPMCMuxConfig7();
	System_printf("#####  GPMCMuxConfig7 ##### \n");

	//controls the write protect output pin level
	GPMCWriteProtectPinLevelCtrl(GPMC_BASE_ADDR, GPMC_WP_PIN_LEVEL_LOW);

	revision = GPMCRevisionGet(GPMC_BASE_ADDR);
	System_printf("***GPMC Revision : %d *** \n", revision);
	System_flush();
}

 void GpmcWriteFpga()
{
	 int i;
	 char * point = (char *)0x0a000000;

	 //GPMCEmptyWriteBuffStatusGet(GPMC_BASE_ADDR);
	 System_printf("point 0x0a000000 = ");
	for(i = 0; i < 100; i++)
	{
		*(point + i) = i;
		System_printf("%d ", i);
	}
	System_printf("\n");
}

 void GpmcReadFpga()
{
	 short value = 0;
	 int i;

	 do
	 {
		 value = *((short *)0x0a000000);
		 if(value != 0)
		 {
			 System_printf("read FPGA  value = %d\n ", (int)value);
		 }
		 i++;

	 }while(value == 0 && i < 100);
	 System_printf(" Read End \n");

}


