

/**
 *  @Component:   CM
 *
 *  @Filename:    ../../CredDataBase/prcmCRED/cm_per_cred.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_CM_PER_H_
#define _HW_CM_PER_H_


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define CM_PER_L4LS_CLKSTCTRL   (0x0)
#define CM_PER_L3S_CLKSTCTRL   (0x4)
#define CM_PER_L4FW_CLKSTCTRL   (0x8)
#define CM_PER_L3_CLKSTCTRL   (0xc)
#define CM_PER_CPGMAC0_CLKCTRL   (0x14)
#define CM_PER_LCDC_CLKCTRL   (0x18)
#define CM_PER_USB0_CLKCTRL   (0x1c)
#define CM_PER_MLB_CLKCTRL   (0x20)
#define CM_PER_TPTC0_CLKCTRL   (0x24)
#define CM_PER_EMIF_CLKCTRL   (0x28)
#define CM_PER_OCMCRAM_CLKCTRL   (0x2c)
#define CM_PER_GPMC_CLKCTRL   (0x30)
#define CM_PER_MCASP0_CLKCTRL   (0x34)
#define CM_PER_UART5_CLKCTRL   (0x38)
#define CM_PER_MMC0_CLKCTRL   (0x3c)
#define CM_PER_ELM_CLKCTRL   (0x40)
#define CM_PER_I2C2_CLKCTRL   (0x44)
#define CM_PER_I2C1_CLKCTRL   (0x48)
#define CM_PER_SPI0_CLKCTRL   (0x4c)
#define CM_PER_SPI1_CLKCTRL   (0x50)
#define CM_PER_L4LS_CLKCTRL   (0x60)
#define CM_PER_L4FW_CLKCTRL   (0x64)
#define CM_PER_MCASP1_CLKCTRL   (0x68)
#define CM_PER_UART1_CLKCTRL   (0x6c)
#define CM_PER_UART2_CLKCTRL   (0x70)
#define CM_PER_UART3_CLKCTRL   (0x74)
#define CM_PER_UART4_CLKCTRL   (0x78)
#define CM_PER_TIMER7_CLKCTRL   (0x7c)
#define CM_PER_TIMER2_CLKCTRL   (0x80)
#define CM_PER_TIMER3_CLKCTRL   (0x84)
#define CM_PER_TIMER4_CLKCTRL   (0x88)
#define CM_PER_RNG_CLKCTRL   (0x90)
#define CM_PER_AES0_CLKCTRL   (0x94)
#define CM_PER_SHA0_CLKCTRL   (0xa0)
#define CM_PER_PKA_CLKCTRL   (0xa4)
#define CM_PER_GPIO6_CLKCTRL   (0xa8)
#define CM_PER_GPIO1_CLKCTRL   (0xac)
#define CM_PER_GPIO2_CLKCTRL   (0xb0)
#define CM_PER_GPIO3_CLKCTRL   (0xb4)
#define CM_PER_TPCC_CLKCTRL   (0xbc)
#define CM_PER_DCAN0_CLKCTRL   (0xc0)
#define CM_PER_DCAN1_CLKCTRL   (0xc4)
#define CM_PER_EPWMSS1_CLKCTRL   (0xcc)
#define CM_PER_EMIF_FW_CLKCTRL   (0xd0)
#define CM_PER_EPWMSS0_CLKCTRL   (0xd4)
#define CM_PER_EPWMSS2_CLKCTRL   (0xd8)
#define CM_PER_L3_INSTR_CLKCTRL   (0xdc)
#define CM_PER_L3_CLKCTRL   (0xe0)
#define CM_PER_IEEE5000_CLKCTRL   (0xe4)
#define CM_PER_ICSS_CLKCTRL   (0xe8)
#define CM_PER_TIMER5_CLKCTRL   (0xec)
#define CM_PER_TIMER6_CLKCTRL   (0xf0)
#define CM_PER_MMC1_CLKCTRL   (0xf4)
#define CM_PER_MMC2_CLKCTRL   (0xf8)
#define CM_PER_TPTC1_CLKCTRL   (0xfc)
#define CM_PER_TPTC2_CLKCTRL   (0x100)
#define CM_PER_SPINLOCK_CLKCTRL   (0x10c)
#define CM_PER_MAILBOX0_CLKCTRL   (0x110)
#define CM_PER_L4HS_CLKSTCTRL   (0x11c)
#define CM_PER_L4HS_CLKCTRL   (0x120)
#define CM_PER_MSTR_EXPS_CLKCTRL   (0x124)
#define CM_PER_SLV_EXPS_CLKCTRL   (0x128)
#define CM_PER_OCPWP_L3_CLKSTCTRL   (0x12c)
#define CM_PER_OCPWP_CLKCTRL   (0x130)
#define CM_PER_ICSS_CLKSTCTRL   (0x140)
#define CM_PER_CPSW_CLKSTCTRL   (0x144)
#define CM_PER_LCDC_CLKSTCTRL   (0x148)
#define CM_PER_CLKDIV32K_CLKCTRL   (0x14c)
#define CM_PER_CLK_24MHZ_CLKSTCTRL   (0x150)

/************************************************************************** 
 * Field Definition Macros
**************************************************************************/

/* L4LS_CLKSTCTRL */
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_CAN_CLK   (0x00000800u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_CAN_CLK_SHIFT   (0x0000000Bu)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_CAN_CLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_CAN_CLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_1_GDBCLK   (0x00080000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_1_GDBCLK_SHIFT   (0x00000013u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_1_GDBCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_1_GDBCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_2_GDBCLK   (0x00100000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_2_GDBCLK_SHIFT   (0x00000014u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_2_GDBCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_2_GDBCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_3_GDBCLK   (0x00200000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_3_GDBCLK_SHIFT   (0x00000015u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_3_GDBCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_GPIO_3_GDBCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_I2C_FCLK   (0x01000000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_I2C_FCLK_SHIFT   (0x00000018u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_I2C_FCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_I2C_FCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_L4LS_GCLK   (0x00000100u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_L4LS_GCLK_SHIFT   (0x00000008u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_L4LS_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_L4LS_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_LCDC_GCLK   (0x00020000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_LCDC_GCLK_SHIFT   (0x00000011u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_LCDC_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_LCDC_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_SPI_GCLK   (0x02000000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_SPI_GCLK_SHIFT   (0x00000019u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_SPI_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_SPI_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER2_GCLK   (0x00004000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER2_GCLK_SHIFT   (0x0000000Eu)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER2_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER2_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER3_GCLK   (0x00008000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER3_GCLK_SHIFT   (0x0000000Fu)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER3_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER3_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER4_GCLK   (0x00010000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER4_GCLK_SHIFT   (0x00000010u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER4_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER4_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER5_GCLK   (0x08000000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER5_GCLK_SHIFT   (0x0000001Bu)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER5_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER5_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER6_GCLK   (0x10000000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER6_GCLK_SHIFT   (0x0000001Cu)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER6_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER6_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER7_GCLK   (0x00002000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER7_GCLK_SHIFT   (0x0000000Du)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER7_GCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_TIMER7_GCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_UART_GFCLK   (0x00000400u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_UART_GFCLK_SHIFT   (0x0000000Au)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_UART_GFCLK_ACT   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKACTIVITY_UART_GFCLK_INACT   (0x0u)

#define CM_PER_L4LS_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_L4LS_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_L4LS_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_L4LS_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_L4LS_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_L4LS_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* L3S_CLKSTCTRL */
#define CM_PER_L3S_CLKSTCTRL_CLKACTIVITY_L3S_GCLK   (0x00000008u)
#define CM_PER_L3S_CLKSTCTRL_CLKACTIVITY_L3S_GCLK_SHIFT   (0x00000003u)
#define CM_PER_L3S_CLKSTCTRL_CLKACTIVITY_L3S_GCLK_ACT   (0x1u)
#define CM_PER_L3S_CLKSTCTRL_CLKACTIVITY_L3S_GCLK_INACT   (0x0u)

#define CM_PER_L3S_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_L3S_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_L3S_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_L3S_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_L3S_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_L3S_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* L4FW_CLKSTCTRL */
#define CM_PER_L4FW_CLKSTCTRL_CLKACTIVITY_L4FW_GCLK   (0x00000100u)
#define CM_PER_L4FW_CLKSTCTRL_CLKACTIVITY_L4FW_GCLK_SHIFT   (0x00000008u)
#define CM_PER_L4FW_CLKSTCTRL_CLKACTIVITY_L4FW_GCLK_ACT   (0x1u)
#define CM_PER_L4FW_CLKSTCTRL_CLKACTIVITY_L4FW_GCLK_INACT   (0x0u)

#define CM_PER_L4FW_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_L4FW_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_L4FW_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_L4FW_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_L4FW_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_L4FW_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* L3_CLKSTCTRL */
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_CPTS_RFT_GCLK   (0x00000040u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_CPTS_RFT_GCLK_SHIFT   (0x00000006u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_CPTS_RFT_GCLK_ACT   (0x1u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_CPTS_RFT_GCLK_INACT   (0x0u)

#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_EMIF_GCLK   (0x00000004u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_EMIF_GCLK_SHIFT   (0x00000002u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_EMIF_GCLK_ACT   (0x1u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_EMIF_GCLK_INACT   (0x0u)

#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_L3_GCLK   (0x00000010u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_L3_GCLK_SHIFT   (0x00000004u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_L3_GCLK_ACT   (0x1u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_L3_GCLK_INACT   (0x0u)

#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MCASP_GCLK   (0x00000080u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MCASP_GCLK_SHIFT   (0x00000007u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MCASP_GCLK_ACT   (0x1u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MCASP_GCLK_INACT   (0x0u)

#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MMC_FCLK   (0x00000008u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MMC_FCLK_SHIFT   (0x00000003u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MMC_FCLK_ACT   (0x1u)
#define CM_PER_L3_CLKSTCTRL_CLKACTIVITY_MMC_FCLK_INACT   (0x0u)

#define CM_PER_L3_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_L3_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_L3_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_L3_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_L3_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_L3_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* CPGMAC0_CLKCTRL */
#define CM_PER_CPGMAC0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_CPGMAC0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_CPGMAC0_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_CPGMAC0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_CPGMAC0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_CPGMAC0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_CPGMAC0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_CPGMAC0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_CPGMAC0_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_CPGMAC0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_CPGMAC0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_CPGMAC0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_CPGMAC0_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_CPGMAC0_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_CPGMAC0_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_CPGMAC0_CLKCTRL_STBYST_STANDBY   (0x1u)


/* LCDC_CLKCTRL */
#define CM_PER_LCDC_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_LCDC_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_LCDC_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_LCDC_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_LCDC_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_LCDC_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_LCDC_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_LCDC_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_LCDC_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_LCDC_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_LCDC_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_LCDC_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_LCDC_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_LCDC_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_LCDC_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_LCDC_CLKCTRL_STBYST_STANDBY   (0x1u)


/* USB0_CLKCTRL */
#define CM_PER_USB0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_USB0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_USB0_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_USB0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_USB0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_USB0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_USB0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_USB0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_USB0_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_USB0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_USB0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_USB0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_USB0_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_USB0_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_USB0_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_USB0_CLKCTRL_STBYST_STANDBY   (0x1u)


/* MLB_CLKCTRL */
#define CM_PER_MLB_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MLB_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MLB_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_MLB_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MLB_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MLB_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MLB_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MLB_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MLB_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_MLB_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MLB_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MLB_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_MLB_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_MLB_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_MLB_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_MLB_CLKCTRL_STBYST_STANDBY   (0x1u)


/* TPTC0_CLKCTRL */
#define CM_PER_TPTC0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TPTC0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TPTC0_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_TPTC0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TPTC0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TPTC0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TPTC0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TPTC0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TPTC0_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TPTC0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TPTC0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TPTC0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_TPTC0_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_TPTC0_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_TPTC0_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_TPTC0_CLKCTRL_STBYST_STANDBY   (0x1u)


/* EMIF_CLKCTRL */
#define CM_PER_EMIF_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_EMIF_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_EMIF_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_EMIF_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_EMIF_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_EMIF_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_EMIF_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_EMIF_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_EMIF_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_EMIF_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_EMIF_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_EMIF_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* OCMCRAM_CLKCTRL */
#define CM_PER_OCMCRAM_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_OCMCRAM_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_OCMCRAM_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_OCMCRAM_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_OCMCRAM_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_OCMCRAM_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_OCMCRAM_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_OCMCRAM_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_OCMCRAM_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_OCMCRAM_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_OCMCRAM_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_OCMCRAM_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* GPMC_CLKCTRL */
#define CM_PER_GPMC_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_GPMC_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_GPMC_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_GPMC_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_GPMC_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_GPMC_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_GPMC_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_GPMC_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_GPMC_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_GPMC_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_GPMC_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_GPMC_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* MCASP0_CLKCTRL */
#define CM_PER_MCASP0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MCASP0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MCASP0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_MCASP0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MCASP0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MCASP0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MCASP0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MCASP0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MCASP0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_MCASP0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MCASP0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MCASP0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* UART5_CLKCTRL */
#define CM_PER_UART5_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_UART5_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_UART5_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_UART5_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_UART5_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_UART5_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_UART5_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_UART5_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_UART5_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_UART5_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_UART5_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_UART5_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* MMC0_CLKCTRL */
#define CM_PER_MMC0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MMC0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MMC0_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_MMC0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MMC0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MMC0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MMC0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MMC0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MMC0_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_MMC0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MMC0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MMC0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* ELM_CLKCTRL */
#define CM_PER_ELM_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_ELM_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_ELM_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_ELM_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_ELM_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_ELM_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_ELM_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_ELM_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_ELM_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_ELM_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_ELM_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_ELM_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* I2C2_CLKCTRL */
#define CM_PER_I2C2_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_I2C2_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_I2C2_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_I2C2_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_I2C2_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_I2C2_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_I2C2_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_I2C2_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_I2C2_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_I2C2_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_I2C2_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_I2C2_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* I2C1_CLKCTRL */
#define CM_PER_I2C1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_I2C1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_I2C1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_I2C1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_I2C1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_I2C1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_I2C1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_I2C1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_I2C1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_I2C1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_I2C1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_I2C1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* SPI0_CLKCTRL */
#define CM_PER_SPI0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_SPI0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_SPI0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_SPI0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_SPI0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_SPI0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_SPI0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_SPI0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_SPI0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_SPI0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_SPI0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_SPI0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* SPI1_CLKCTRL */
#define CM_PER_SPI1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_SPI1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_SPI1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_SPI1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_SPI1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_SPI1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_SPI1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_SPI1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_SPI1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_SPI1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_SPI1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_SPI1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* L4LS_CLKCTRL */
#define CM_PER_L4LS_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_L4LS_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_L4LS_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_L4LS_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_L4LS_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_L4LS_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_L4LS_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_L4LS_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_L4LS_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_L4LS_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_L4LS_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_L4LS_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* L4FW_CLKCTRL */
#define CM_PER_L4FW_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_L4FW_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_L4FW_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_L4FW_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_L4FW_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_L4FW_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_L4FW_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_L4FW_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_L4FW_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_L4FW_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_L4FW_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_L4FW_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* MCASP1_CLKCTRL */
#define CM_PER_MCASP1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MCASP1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MCASP1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_MCASP1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MCASP1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MCASP1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MCASP1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MCASP1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MCASP1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_MCASP1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MCASP1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MCASP1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* UART1_CLKCTRL */
#define CM_PER_UART1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_UART1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_UART1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_UART1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_UART1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_UART1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_UART1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_UART1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_UART1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_UART1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_UART1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_UART1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* UART2_CLKCTRL */
#define CM_PER_UART2_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_UART2_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_UART2_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_UART2_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_UART2_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_UART2_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_UART2_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_UART2_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_UART2_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_UART2_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_UART2_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_UART2_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* UART3_CLKCTRL */
#define CM_PER_UART3_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_UART3_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_UART3_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_UART3_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_UART3_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_UART3_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_UART3_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_UART3_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_UART3_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_UART3_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_UART3_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_UART3_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* UART4_CLKCTRL */
#define CM_PER_UART4_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_UART4_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_UART4_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_UART4_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_UART4_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_UART4_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_UART4_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_UART4_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_UART4_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_UART4_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_UART4_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_UART4_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* TIMER7_CLKCTRL */
#define CM_PER_TIMER7_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TIMER7_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TIMER7_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_TIMER7_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TIMER7_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TIMER7_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TIMER7_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TIMER7_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TIMER7_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TIMER7_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TIMER7_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TIMER7_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* TIMER2_CLKCTRL */
#define CM_PER_TIMER2_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TIMER2_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TIMER2_CLKCTRL_IDLEST_DISABLDED   (0x3u)
#define CM_PER_TIMER2_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TIMER2_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TIMER2_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TIMER2_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TIMER2_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TIMER2_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TIMER2_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TIMER2_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TIMER2_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* TIMER3_CLKCTRL */
#define CM_PER_TIMER3_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TIMER3_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TIMER3_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_TIMER3_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TIMER3_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TIMER3_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TIMER3_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TIMER3_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TIMER3_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TIMER3_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TIMER3_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TIMER3_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* TIMER4_CLKCTRL */
#define CM_PER_TIMER4_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TIMER4_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TIMER4_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_TIMER4_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TIMER4_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TIMER4_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TIMER4_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TIMER4_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TIMER4_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TIMER4_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TIMER4_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TIMER4_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* RNG_CLKCTRL */
#define CM_PER_RNG_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_RNG_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_RNG_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_RNG_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_RNG_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_RNG_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_RNG_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_RNG_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_RNG_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_RNG_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_RNG_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_RNG_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* AES0_CLKCTRL */
#define CM_PER_AES0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_AES0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_AES0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_AES0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_AES0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_AES0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_AES0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_AES0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_AES0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_AES0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_AES0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_AES0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* SHA0_CLKCTRL */
#define CM_PER_SHA0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_SHA0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_SHA0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_SHA0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_SHA0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_SHA0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_SHA0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_SHA0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_SHA0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_SHA0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_SHA0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_SHA0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* PKA_CLKCTRL */
#define CM_PER_PKA_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_PKA_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_PKA_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_PKA_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_PKA_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_PKA_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_PKA_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_PKA_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_PKA_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_PKA_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_PKA_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_PKA_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* GPIO1_CLKCTRL */
#define CM_PER_GPIO1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_GPIO1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_GPIO1_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_GPIO1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_GPIO1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_GPIO1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_GPIO1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_GPIO1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_GPIO1_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_GPIO1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_GPIO1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_GPIO1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_GPIO1_CLKCTRL_OPTFCLKEN_GPIO_1_GDBCLK   (0x00040000u)
#define CM_PER_GPIO1_CLKCTRL_OPTFCLKEN_GPIO_1_GDBCLK_SHIFT   (0x00000012u)
#define CM_PER_GPIO1_CLKCTRL_OPTFCLKEN_GPIO_1_GDBCLK_FCLK_DIS   (0x0u)
#define CM_PER_GPIO1_CLKCTRL_OPTFCLKEN_GPIO_1_GDBCLK_FCLK_EN   (0x1u)


/* GPIO2_CLKCTRL */
#define CM_PER_GPIO2_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_GPIO2_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_GPIO2_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_GPIO2_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_GPIO2_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_GPIO2_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_GPIO2_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_GPIO2_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_GPIO2_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_GPIO2_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_GPIO2_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_GPIO2_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_GPIO2_CLKCTRL_OPTFCLKEN_GPIO_2_GDBCLK   (0x00040000u)
#define CM_PER_GPIO2_CLKCTRL_OPTFCLKEN_GPIO_2_GDBCLK_SHIFT   (0x00000012u)
#define CM_PER_GPIO2_CLKCTRL_OPTFCLKEN_GPIO_2_GDBCLK_FCLK_DIS   (0x0u)
#define CM_PER_GPIO2_CLKCTRL_OPTFCLKEN_GPIO_2_GDBCLK_FCLK_EN   (0x1u)


/* GPIO3_CLKCTRL */
#define CM_PER_GPIO3_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_GPIO3_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_GPIO3_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_GPIO3_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_GPIO3_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_GPIO3_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_GPIO3_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_GPIO3_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_GPIO3_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_GPIO3_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_GPIO3_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_GPIO3_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_GPIO3_CLKCTRL_OPTFCLKEN_GPIO_3_GDBCLK   (0x00040000u)
#define CM_PER_GPIO3_CLKCTRL_OPTFCLKEN_GPIO_3_GDBCLK_SHIFT   (0x00000012u)
#define CM_PER_GPIO3_CLKCTRL_OPTFCLKEN_GPIO_3_GDBCLK_FCLK_DIS   (0x0u)
#define CM_PER_GPIO3_CLKCTRL_OPTFCLKEN_GPIO_3_GDBCLK_FCLK_EN   (0x1u)


/* TPCC_CLKCTRL */
#define CM_PER_TPCC_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TPCC_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TPCC_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_TPCC_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TPCC_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TPCC_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TPCC_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TPCC_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TPCC_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TPCC_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TPCC_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TPCC_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* DCAN0_CLKCTRL */
#define CM_PER_DCAN0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_DCAN0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_DCAN0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_DCAN0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_DCAN0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_DCAN0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_DCAN0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_DCAN0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_DCAN0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_DCAN0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_DCAN0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_DCAN0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* DCAN1_CLKCTRL */
#define CM_PER_DCAN1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_DCAN1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_DCAN1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_DCAN1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_DCAN1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_DCAN1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_DCAN1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_DCAN1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_DCAN1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_DCAN1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_DCAN1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_DCAN1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* EPWMSS1_CLKCTRL */
#define CM_PER_EPWMSS1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_EPWMSS1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_EPWMSS1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_EPWMSS1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_EPWMSS1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_EPWMSS1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_EPWMSS1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_EPWMSS1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_EPWMSS1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_EPWMSS1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_EPWMSS1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_EPWMSS1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* EMIF_FW_CLKCTRL */
#define CM_PER_EMIF_FW_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_EMIF_FW_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_EMIF_FW_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_EMIF_FW_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_EMIF_FW_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_EMIF_FW_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_EMIF_FW_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_EMIF_FW_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_EMIF_FW_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_EMIF_FW_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_EMIF_FW_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_EMIF_FW_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* EPWMSS0_CLKCTRL */
#define CM_PER_EPWMSS0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_EPWMSS0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_EPWMSS0_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_EPWMSS0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_EPWMSS0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_EPWMSS0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_EPWMSS0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_EPWMSS0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_EPWMSS0_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_EPWMSS0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_EPWMSS0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_EPWMSS0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* EPWMSS2_CLKCTRL */
#define CM_PER_EPWMSS2_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_EPWMSS2_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_EPWMSS2_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_EPWMSS2_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_EPWMSS2_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_EPWMSS2_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_EPWMSS2_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_EPWMSS2_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_EPWMSS2_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_EPWMSS2_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_EPWMSS2_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_EPWMSS2_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* L3_INSTR_CLKCTRL */
#define CM_PER_L3_INSTR_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_L3_INSTR_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_L3_INSTR_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_L3_INSTR_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_L3_INSTR_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_L3_INSTR_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_L3_INSTR_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_L3_INSTR_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_L3_INSTR_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_L3_INSTR_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_L3_INSTR_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_L3_INSTR_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* L3_CLKCTRL */
#define CM_PER_L3_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_L3_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_L3_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_L3_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_L3_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_L3_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_L3_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_L3_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_L3_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_L3_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_L3_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_L3_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* IEEE5000_CLKCTRL */
#define CM_PER_IEEE5000_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_IEEE5000_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_IEEE5000_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_IEEE5000_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_IEEE5000_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_IEEE5000_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_IEEE5000_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_IEEE5000_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_IEEE5000_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_IEEE5000_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_IEEE5000_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_IEEE5000_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_IEEE5000_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_IEEE5000_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_IEEE5000_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_IEEE5000_CLKCTRL_STBYST_STANDBY   (0x1u)


/* ICSS_CLKCTRL */
#define CM_PER_ICSS_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_ICSS_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_ICSS_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_ICSS_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_ICSS_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_ICSS_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_ICSS_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_ICSS_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_ICSS_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_ICSS_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_ICSS_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_ICSS_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_ICSS_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_ICSS_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_ICSS_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_ICSS_CLKCTRL_STBYST_STANDBY   (0x1u)


/* TIMER5_CLKCTRL */
#define CM_PER_TIMER5_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TIMER5_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TIMER5_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_TIMER5_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TIMER5_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TIMER5_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TIMER5_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TIMER5_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TIMER5_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_TIMER5_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TIMER5_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TIMER5_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* TIMER6_CLKCTRL */
#define CM_PER_TIMER6_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TIMER6_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TIMER6_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_TIMER6_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TIMER6_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TIMER6_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TIMER6_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TIMER6_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TIMER6_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_TIMER6_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TIMER6_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TIMER6_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* MMC1_CLKCTRL */
#define CM_PER_MMC1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MMC1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MMC1_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_MMC1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MMC1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MMC1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MMC1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MMC1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MMC1_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_MMC1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MMC1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MMC1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* MMC2_CLKCTRL */
#define CM_PER_MMC2_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MMC2_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MMC2_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_MMC2_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MMC2_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MMC2_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MMC2_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MMC2_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MMC2_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_MMC2_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MMC2_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MMC2_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* TPTC1_CLKCTRL */
#define CM_PER_TPTC1_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TPTC1_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TPTC1_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_TPTC1_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TPTC1_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TPTC1_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TPTC1_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TPTC1_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TPTC1_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TPTC1_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TPTC1_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TPTC1_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_TPTC1_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_TPTC1_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_TPTC1_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_TPTC1_CLKCTRL_STBYST_STANDBY   (0x1u)


/* TPTC2_CLKCTRL */
#define CM_PER_TPTC2_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_TPTC2_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_TPTC2_CLKCTRL_IDLEST_DISABLED   (0x3u)
#define CM_PER_TPTC2_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_TPTC2_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_TPTC2_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_TPTC2_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_TPTC2_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_TPTC2_CLKCTRL_MODULEMODE_DISABLE   (0x0u)
#define CM_PER_TPTC2_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_TPTC2_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_TPTC2_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_TPTC2_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_TPTC2_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_TPTC2_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_TPTC2_CLKCTRL_STBYST_STANDBY   (0x1u)


/* SPINLOCK_CLKCTRL */
#define CM_PER_SPINLOCK_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_SPINLOCK_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_SPINLOCK_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_SPINLOCK_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_SPINLOCK_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_SPINLOCK_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_SPINLOCK_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_SPINLOCK_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_SPINLOCK_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_SPINLOCK_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_SPINLOCK_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_SPINLOCK_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* MAILBOX0_CLKCTRL */
#define CM_PER_MAILBOX0_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MAILBOX0_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MAILBOX0_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_MAILBOX0_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MAILBOX0_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MAILBOX0_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MAILBOX0_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MAILBOX0_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MAILBOX0_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_MAILBOX0_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MAILBOX0_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MAILBOX0_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* L4HS_CLKSTCTRL */
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_250MHZ_GCLK   (0x00000010u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_250MHZ_GCLK_SHIFT   (0x00000004u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_250MHZ_GCLK_ACT   (0x1u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_250MHZ_GCLK_INACT   (0x0u)

#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_50MHZ_GCLK   (0x00000020u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_50MHZ_GCLK_SHIFT   (0x00000005u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_50MHZ_GCLK_ACT   (0x1u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_50MHZ_GCLK_INACT   (0x0u)

#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_5MHZ_GCLK   (0x00000040u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_5MHZ_GCLK_SHIFT   (0x00000006u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_5MHZ_GCLK_ACT   (0x1u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_CPSW_5MHZ_GCLK_INACT   (0x0u)

#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_L4HS_GCLK   (0x00000008u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_L4HS_GCLK_SHIFT   (0x00000003u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_L4HS_GCLK_ACT   (0x1u)
#define CM_PER_L4HS_CLKSTCTRL_CLKACTIVITY_L4HS_GCLK_INACT   (0x0u)

#define CM_PER_L4HS_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_L4HS_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_L4HS_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_L4HS_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_L4HS_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_L4HS_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* L4HS_CLKCTRL */
#define CM_PER_L4HS_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_L4HS_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_L4HS_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_L4HS_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_L4HS_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_L4HS_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_L4HS_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_L4HS_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_L4HS_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_L4HS_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_L4HS_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_L4HS_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* MSTR_EXPS_CLKCTRL */
#define CM_PER_MSTR_EXPS_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_MSTR_EXPS_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_MSTR_EXPS_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_MSTR_EXPS_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_MSTR_EXPS_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_MSTR_EXPS_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_MSTR_EXPS_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_MSTR_EXPS_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_MSTR_EXPS_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_MSTR_EXPS_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_MSTR_EXPS_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_MSTR_EXPS_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_MSTR_EXPS_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_MSTR_EXPS_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_MSTR_EXPS_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_MSTR_EXPS_CLKCTRL_STBYST_STANDBY   (0x1u)


/* SLV_EXPS_CLKCTRL */
#define CM_PER_SLV_EXPS_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_SLV_EXPS_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_SLV_EXPS_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_SLV_EXPS_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_SLV_EXPS_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_SLV_EXPS_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_SLV_EXPS_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_SLV_EXPS_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_SLV_EXPS_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_SLV_EXPS_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_SLV_EXPS_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_SLV_EXPS_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* OCPWP_L3_CLKSTCTRL */
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L3_GCLK   (0x00000010u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L3_GCLK_SHIFT   (0x00000004u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L3_GCLK_ACT   (0x1u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L3_GCLK_INACT   (0x0u)

#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L4_GCLK   (0x00000020u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L4_GCLK_SHIFT   (0x00000005u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L4_GCLK_ACT   (0x1u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKACTIVITY_OCPWP_L4_GCLK_INACT   (0x0u)

#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_OCPWP_L3_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* OCPWP_CLKCTRL */
#define CM_PER_OCPWP_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_OCPWP_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_OCPWP_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_OCPWP_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_OCPWP_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_OCPWP_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_OCPWP_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_OCPWP_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_OCPWP_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_OCPWP_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_OCPWP_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_OCPWP_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)

#define CM_PER_OCPWP_CLKCTRL_STBYST   (0x00040000u)
#define CM_PER_OCPWP_CLKCTRL_STBYST_SHIFT   (0x00000012u)
#define CM_PER_OCPWP_CLKCTRL_STBYST_FUNC   (0x0u)
#define CM_PER_OCPWP_CLKCTRL_STBYST_STANDBY   (0x1u)


/* ICSS_CLKSTCTRL */
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_GCLK   (0x00000020u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_GCLK_SHIFT   (0x00000005u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_GCLK_ACT   (0x1u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_IEP_GCLK_INACT   (0x0u)

#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_OCP_GCLK   (0x00000010u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_OCP_GCLK_SHIFT   (0x00000004u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_OCP_GCLK_ACT   (0x1u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_OCP_GCLK_INACT   (0x0u)

#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_UART_GCLK   (0x00000040u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_UART_GCLK_SHIFT   (0x00000006u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_UART_GCLK_ACT   (0x1u)
#define CM_PER_ICSS_CLKSTCTRL_CLKACTIVITY_ICSS_UART_GCLK_INACT   (0x0u)

#define CM_PER_ICSS_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_ICSS_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_ICSS_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_ICSS_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_ICSS_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_ICSS_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* CPSW_CLKSTCTRL */
#define CM_PER_CPSW_CLKSTCTRL_CLKACTIVITY_CPSW_125MHZ_GCLK   (0x00000010u)
#define CM_PER_CPSW_CLKSTCTRL_CLKACTIVITY_CPSW_125MHZ_GCLK_SHIFT   (0x00000004u)
#define CM_PER_CPSW_CLKSTCTRL_CLKACTIVITY_CPSW_125MHZ_GCLK_ACT   (0x1u)
#define CM_PER_CPSW_CLKSTCTRL_CLKACTIVITY_CPSW_125MHZ_GCLK_INACT   (0x0u)

#define CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_CPSW_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* LCDC_CLKSTCTRL */
#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L3_OCP_GCLK   (0x00000010u)
#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L3_OCP_GCLK_SHIFT   (0x00000004u)
#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L3_OCP_GCLK_ACT   (0x1u)
#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L3_OCP_GCLK_INACT   (0x0u)

#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L4_OCP_GCLK   (0x00000020u)
#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L4_OCP_GCLK_SHIFT   (0x00000005u)
#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L4_OCP_GCLK_ACT   (0x1u)
#define CM_PER_LCDC_CLKSTCTRL_CLKACTIVITY_LCDC_L4_OCP_GCLK_INACT   (0x0u)

#define CM_PER_LCDC_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_LCDC_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_LCDC_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_LCDC_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_LCDC_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_LCDC_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)


/* CLKDIV32K_CLKCTRL */
#define CM_PER_CLKDIV32K_CLKCTRL_IDLEST   (0x00030000u)
#define CM_PER_CLKDIV32K_CLKCTRL_IDLEST_SHIFT   (0x00000010u)
#define CM_PER_CLKDIV32K_CLKCTRL_IDLEST_DISABLE   (0x3u)
#define CM_PER_CLKDIV32K_CLKCTRL_IDLEST_FUNC   (0x0u)
#define CM_PER_CLKDIV32K_CLKCTRL_IDLEST_IDLE   (0x2u)
#define CM_PER_CLKDIV32K_CLKCTRL_IDLEST_TRANS   (0x1u)

#define CM_PER_CLKDIV32K_CLKCTRL_MODULEMODE   (0x00000003u)
#define CM_PER_CLKDIV32K_CLKCTRL_MODULEMODE_SHIFT   (0x00000000u)
#define CM_PER_CLKDIV32K_CLKCTRL_MODULEMODE_DISABLED   (0x0u)
#define CM_PER_CLKDIV32K_CLKCTRL_MODULEMODE_ENABLE   (0x2u)
#define CM_PER_CLKDIV32K_CLKCTRL_MODULEMODE_RESERVED   (0x3u)
#define CM_PER_CLKDIV32K_CLKCTRL_MODULEMODE_RESERVED_1   (0x1u)


/* CLK_24MHZ_CLKSTCTRL */
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKACTIVITY_CLK_24MHZ_GCLK   (0x00000010u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKACTIVITY_CLK_24MHZ_GCLK_SHIFT   (0x00000004u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKACTIVITY_CLK_24MHZ_GCLK_ACT   (0x1u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKACTIVITY_CLK_24MHZ_GCLK_INACT   (0x0u)

#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKTRCTRL   (0x00000003u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKTRCTRL_SHIFT   (0x00000000u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKTRCTRL_HW_AUTO   (0x3u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKTRCTRL_NO_SLEEP   (0x0u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKTRCTRL_SW_SLEEP   (0x1u)
#define CM_PER_CLK_24MHZ_CLKSTCTRL_CLKTRCTRL_SW_WKUP   (0x2u)



#endif
