

/**
 *  @Component:   DMTIMER_1MS
 *
 *  @Filename:    hw_dmtimer_1ms.h
 *
 ============================================================================ */
/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/



#ifndef _HW_DMTIMER_1MS_H_
#define _HW_DMTIMER_1MS_H_

#ifdef __cplusplus
extern "C" {
#endif


/***********************************************************************\
 * Register arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundle arrays Definition
\***********************************************************************/


/***********************************************************************\
 * Bundles Definition
\***********************************************************************/



/*************************************************************************\
 * Registers Definition
\*************************************************************************/

#define DMTIMER_1MS_TIDR   (0x0)
#define DMTIMER_1MS_TIOCP_CFG   (0x10)
#define DMTIMER_1MS_TISTAT   (0x14)
#define DMTIMER_1MS_TISR   (0x18)
#define DMTIMER_1MS_TIER   (0x1c)
#define DMTIMER_1MS_TWER   (0x20)
#define DMTIMER_1MS_TCLR   (0x24)
#define DMTIMER_1MS_TCRR   (0x28)
#define DMTIMER_1MS_TLDR   (0x2c)
#define DMTIMER_1MS_TTGR   (0x30)
#define DMTIMER_1MS_TWPS   (0x34)
#define DMTIMER_1MS_TMAR   (0x38)
#define DMTIMER_1MS_TCAR(n)   (0x3c + (n * 8))
#define DMTIMER_1MS_TSICR   (0x40)
#define DMTIMER_1MS_TPIR   (0x48)
#define DMTIMER_1MS_TNIR   (0x4c)
#define DMTIMER_1MS_TCVR   (0x50)
#define DMTIMER_1MS_TOCR   (0x54)
#define DMTIMER_1MS_TOWR   (0x58)

/**************************************************************************\
 * Field Definition Macros
\**************************************************************************/

/* TIDR */
#define DMTIMER_1MS_TIDR_TID_REV   (0x000000FF)
#define DMTIMER_1MS_TIDR_TID_REV_SHIFT   (0x00000000)


/* TIOCP_CFG */
#define DMTIMER_1MS_TIOCP_CFG_AUTOIDLE   (0x00000001)
#define DMTIMER_1MS_TIOCP_CFG_AUTOIDLE_SHIFT   (0x00000000)
#define DMTIMER_1MS_TIOCP_CFG_AUTOIDLE_CLKFREE   (0x0)
#define DMTIMER_1MS_TIOCP_CFG_AUTOIDLE_CLKGATE   (0x1)

#define DMTIMER_1MS_TIOCP_CFG_CLOCKACTIVITY   (0x00000300)
#define DMTIMER_1MS_TIOCP_CFG_CLOCKACTIVITY_SHIFT   (0x00000008)
#define DMTIMER_1MS_TIOCP_CFG_CLOCKACTIVITY_CA0   (0x0)
#define DMTIMER_1MS_TIOCP_CFG_CLOCKACTIVITY_CA1   (0x1)
#define DMTIMER_1MS_TIOCP_CFG_CLOCKACTIVITY_CA2   (0x2)
#define DMTIMER_1MS_TIOCP_CFG_CLOCKACTIVITY_CA3   (0x3)

#define DMTIMER_1MS_TIOCP_CFG_EMUFREE   (0x00000020)
#define DMTIMER_1MS_TIOCP_CFG_EMUFREE_SHIFT   (0x00000005)
#define DMTIMER_1MS_TIOCP_CFG_EMUFREE_TIMER_FREE   (0x1)
#define DMTIMER_1MS_TIOCP_CFG_EMUFREE_TIMER_FROZEN   (0x0)

#define DMTIMER_1MS_TIOCP_CFG_ENAWAKEUP   (0x00000004)
#define DMTIMER_1MS_TIOCP_CFG_ENAWAKEUP_SHIFT   (0x00000002)
#define DMTIMER_1MS_TIOCP_CFG_ENAWAKEUP_ENBWAKE   (0x1)
#define DMTIMER_1MS_TIOCP_CFG_ENAWAKEUP_NOWAKE   (0x0)

#define DMTIMER_1MS_TIOCP_CFG_IDLEMODE   (0x00000018)
#define DMTIMER_1MS_TIOCP_CFG_IDLEMODE_SHIFT   (0x00000003)
#define DMTIMER_1MS_TIOCP_CFG_IDLEMODE_FIDLE   (0x0)
#define DMTIMER_1MS_TIOCP_CFG_IDLEMODE_NIDLE   (0x1)
#define DMTIMER_1MS_TIOCP_CFG_IDLEMODE_RES   (0x3)
#define DMTIMER_1MS_TIOCP_CFG_IDLEMODE_SIDLE   (0x2)

#define DMTIMER_1MS_TIOCP_CFG_SOFTRESET   (0x00000002)
#define DMTIMER_1MS_TIOCP_CFG_SOFTRESET_SHIFT   (0x00000001)
#define DMTIMER_1MS_TIOCP_CFG_SOFTRESET_NMODE   (0x0)
#define DMTIMER_1MS_TIOCP_CFG_SOFTRESET_RSTMODE   (0x1)


/* TISTAT */
#define DMTIMER_1MS_TISTAT_RESETDONE   (0x00000001)
#define DMTIMER_1MS_TISTAT_RESETDONE_SHIFT   (0x00000000)
#define DMTIMER_1MS_TISTAT_RESETDONE_RSTCOMP   (0x1)
#define DMTIMER_1MS_TISTAT_RESETDONE_RSTONGOING   (0x0)


/* TISR */
#define DMTIMER_1MS_TISR_MAT_IT_FLAG   (0x00000001)
#define DMTIMER_1MS_TISR_MAT_IT_FLAG_SHIFT   (0x00000000)
#define DMTIMER_1MS_TISR_MAT_IT_FLAG_0   (0x0)
#define DMTIMER_1MS_TISR_MAT_IT_FLAG_1   (0x1)

#define DMTIMER_1MS_TISR_OVF_IT_FLAG   (0x00000002)
#define DMTIMER_1MS_TISR_OVF_IT_FLAG_SHIFT   (0x00000001)
#define DMTIMER_1MS_TISR_OVF_IT_FLAG_0   (0x0)
#define DMTIMER_1MS_TISR_OVF_IT_FLAG_1   (0x1)

#define DMTIMER_1MS_TISR_TCAR_IT_FLAG   (0x00000004)
#define DMTIMER_1MS_TISR_TCAR_IT_FLAG_SHIFT   (0x00000002)
#define DMTIMER_1MS_TISR_TCAR_IT_FLAG_0   (0x0)
#define DMTIMER_1MS_TISR_TCAR_IT_FLAG_TACR_IT_FLAG_1   (0x1)


/* TIER */
#define DMTIMER_1MS_TIER_MAT_IT_ENA   (0x00000001)
#define DMTIMER_1MS_TIER_MAT_IT_ENA_SHIFT   (0x00000000)
#define DMTIMER_1MS_TIER_MAT_IT_ENA_DSB_MATCH   (0x0)
#define DMTIMER_1MS_TIER_MAT_IT_ENA_ENB_MATCH   (0x1)

#define DMTIMER_1MS_TIER_OVF_IT_ENA   (0x00000002)
#define DMTIMER_1MS_TIER_OVF_IT_ENA_SHIFT   (0x00000001)
#define DMTIMER_1MS_TIER_OVF_IT_ENA_DSB_OVF   (0x0)
#define DMTIMER_1MS_TIER_OVF_IT_ENA_ENB_OVF   (0x1)

#define DMTIMER_1MS_TIER_TCAR_IT_ENA   (0x00000004)
#define DMTIMER_1MS_TIER_TCAR_IT_ENA_SHIFT   (0x00000002)
#define DMTIMER_1MS_TIER_TCAR_IT_ENA_DSB_CAPT   (0x0)
#define DMTIMER_1MS_TIER_TCAR_IT_ENA_ENB_CAPT   (0x1)


/* TWER */
#define DMTIMER_1MS_TWER_MAT_WUP_ENA   (0x00000001)
#define DMTIMER_1MS_TWER_MAT_WUP_ENA_SHIFT   (0x00000000)
#define DMTIMER_1MS_TWER_MAT_WUP_ENA_DSBWUPMAT   (0x0)
#define DMTIMER_1MS_TWER_MAT_WUP_ENA_ENBWUPMAT   (0x1)

#define DMTIMER_1MS_TWER_OVF_WUP_ENA   (0x00000002)
#define DMTIMER_1MS_TWER_OVF_WUP_ENA_SHIFT   (0x00000001)
#define DMTIMER_1MS_TWER_OVF_WUP_ENA_DSBWUPOVF   (0x0)
#define DMTIMER_1MS_TWER_OVF_WUP_ENA_ENBWUPOVF   (0x1)

#define DMTIMER_1MS_TWER_TCAR_WUP_ENA   (0x00000004)
#define DMTIMER_1MS_TWER_TCAR_WUP_ENA_SHIFT   (0x00000002)
#define DMTIMER_1MS_TWER_TCAR_WUP_ENA_DSBWUPCAP   (0x0)
#define DMTIMER_1MS_TWER_TCAR_WUP_ENA_ENBWUPCAPT   (0x1)


/* TCLR */
#define DMTIMER_1MS_TCLR_AR   (0x00000002)
#define DMTIMER_1MS_TCLR_AR_SHIFT   (0x00000001)
#define DMTIMER_1MS_TCLR_AR_AUTO_REL   (0x1)
#define DMTIMER_1MS_TCLR_AR_ONE_SHOT   (0x0)

#define DMTIMER_1MS_TCLR_CAPT_MODE   (0x00002000)
#define DMTIMER_1MS_TCLR_CAPT_MODE_SHIFT   (0x0000000D)
#define DMTIMER_1MS_TCLR_CAPT_MODE_FIRST_CAPT   (0x0)
#define DMTIMER_1MS_TCLR_CAPT_MODE_SEC_CAPT   (0x1)

#define DMTIMER_1MS_TCLR_CE   (0x00000040)
#define DMTIMER_1MS_TCLR_CE_SHIFT   (0x00000006)
#define DMTIMER_1MS_TCLR_CE_DSB_CMP   (0x0)
#define DMTIMER_1MS_TCLR_CE_ENB_CMP   (0x1)

#define DMTIMER_1MS_TCLR_GPO_CFG   (0x00004000)
#define DMTIMER_1MS_TCLR_GPO_CFG_SHIFT   (0x0000000E)
#define DMTIMER_1MS_TCLR_GPO_CFG_0   (0x0)
#define DMTIMER_1MS_TCLR_GPO_CFG_1   (0x1)

#define DMTIMER_1MS_TCLR_PRE   (0x00000020)
#define DMTIMER_1MS_TCLR_PRE_SHIFT   (0x00000005)
#define DMTIMER_1MS_TCLR_PRE_NO_PRESCAL   (0x0)
#define DMTIMER_1MS_TCLR_PRE_PRESCAL_ON   (0x1)

#define DMTIMER_1MS_TCLR_PT   (0x00001000)
#define DMTIMER_1MS_TCLR_PT_SHIFT   (0x0000000C)
#define DMTIMER_1MS_TCLR_PT_PULSE   (0x0)
#define DMTIMER_1MS_TCLR_PT_TOGGLE   (0x1)

#define DMTIMER_1MS_TCLR_PTV   (0x0000001C)
#define DMTIMER_1MS_TCLR_PTV_SHIFT   (0x00000002)
#define DMTIMER_1MS_TCLR_PTV_PTV   (0x0)

#define DMTIMER_1MS_TCLR_SCPWM   (0x00000080)
#define DMTIMER_1MS_TCLR_SCPWM_SHIFT   (0x00000007)
#define DMTIMER_1MS_TCLR_SCPWM_DEF_HIGH   (0x1)
#define DMTIMER_1MS_TCLR_SCPWM_DEF_LOW   (0x0)

#define DMTIMER_1MS_TCLR_ST   (0x00000001)
#define DMTIMER_1MS_TCLR_ST_SHIFT   (0x00000000)
#define DMTIMER_1MS_TCLR_ST_CNT_START   (0x1)
#define DMTIMER_1MS_TCLR_ST_CNT_STOP   (0x0)

#define DMTIMER_1MS_TCLR_TCM   (0x00000300)
#define DMTIMER_1MS_TCLR_TCM_SHIFT   (0x00000008)
#define DMTIMER_1MS_TCLR_TCM_BOOTH_EDGES   (0x3)
#define DMTIMER_1MS_TCLR_TCM_FALL_EDGE   (0x2)
#define DMTIMER_1MS_TCLR_TCM_NO_EDGE   (0x0)
#define DMTIMER_1MS_TCLR_TCM_RISE_EDGE   (0x1)

#define DMTIMER_1MS_TCLR_TRG   (0x00000C00)
#define DMTIMER_1MS_TCLR_TRG_SHIFT   (0x0000000A)
#define DMTIMER_1MS_TCLR_TRG_NO   (0x0)
#define DMTIMER_1MS_TCLR_TRG_OVF   (0x1)
#define DMTIMER_1MS_TCLR_TRG_OVF_MAT   (0x2)
#define DMTIMER_1MS_TCLR_TRG_RESERVED   (0x3)


/* TCRR */
#define DMTIMER_1MS_TCRR_TIMER_COUNTER   (0xFFFFFFFF)
#define DMTIMER_1MS_TCRR_TIMER_COUNTER_SHIFT   (0x00000000)


/* TLDR */
#define DMTIMER_1MS_TLDR_LOAD_VALUE   (0xFFFFFFFF)
#define DMTIMER_1MS_TLDR_LOAD_VALUE_SHIFT   (0x00000000)


/* TTGR */
#define DMTIMER_1MS_TTGR_TTGR_VALUE   (0xFFFFFFFF)
#define DMTIMER_1MS_TTGR_TTGR_VALUE_SHIFT   (0x00000000)


/* TWPS */
#define DMTIMER_1MS_TWPS_W_PEND_TCLR   (0x00000001)
#define DMTIMER_1MS_TWPS_W_PEND_TCLR_SHIFT   (0x00000000)
#define DMTIMER_1MS_TWPS_W_PEND_TCLR_CLR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TCLR_CLR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TCRR   (0x00000002)
#define DMTIMER_1MS_TWPS_W_PEND_TCRR_SHIFT   (0x00000001)
#define DMTIMER_1MS_TWPS_W_PEND_TCRR_CRR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TCRR_CRR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TCVR   (0x00000080)
#define DMTIMER_1MS_TWPS_W_PEND_TCVR_SHIFT   (0x00000007)
#define DMTIMER_1MS_TWPS_W_PEND_TCVR_CVR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TCVR_CVR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TLDR   (0x00000004)
#define DMTIMER_1MS_TWPS_W_PEND_TLDR_SHIFT   (0x00000002)
#define DMTIMER_1MS_TWPS_W_PEND_TLDR_LDR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TLDR_LDR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TMAR   (0x00000010)
#define DMTIMER_1MS_TWPS_W_PEND_TMAR_SHIFT   (0x00000004)
#define DMTIMER_1MS_TWPS_W_PEND_TMAR_MAR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TMAR_MAR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TNIR   (0x00000040)
#define DMTIMER_1MS_TWPS_W_PEND_TNIR_SHIFT   (0x00000006)
#define DMTIMER_1MS_TWPS_W_PEND_TNIR_NIR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TNIR_NIR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TOCR   (0x00000100)
#define DMTIMER_1MS_TWPS_W_PEND_TOCR_SHIFT   (0x00000008)
#define DMTIMER_1MS_TWPS_W_PEND_TOCR_OCR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TOCR_OCR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TOWR   (0x00000200)
#define DMTIMER_1MS_TWPS_W_PEND_TOWR_SHIFT   (0x00000009)
#define DMTIMER_1MS_TWPS_W_PEND_TOWR_OWR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TOWR_OWR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TPIR   (0x00000020)
#define DMTIMER_1MS_TWPS_W_PEND_TPIR_SHIFT   (0x00000005)
#define DMTIMER_1MS_TWPS_W_PEND_TPIR_PIR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TPIR_PIR_PEND   (0x1)

#define DMTIMER_1MS_TWPS_W_PEND_TTGR   (0x00000008)
#define DMTIMER_1MS_TWPS_W_PEND_TTGR_SHIFT   (0x00000003)
#define DMTIMER_1MS_TWPS_W_PEND_TTGR_TGR_NPEND   (0x0)
#define DMTIMER_1MS_TWPS_W_PEND_TTGR_TGR_PEND   (0x1)


/* TMAR */
#define DMTIMER_1MS_TMAR_COMPARE_VALUE   (0xFFFFFFFF)
#define DMTIMER_1MS_TMAR_COMPARE_VALUE_SHIFT   (0x00000000)


/* TCAR1 */
#define DMTIMER_1MS_TCAR1_CAPTURE_VALUE1   (0xFFFFFFFF)
#define DMTIMER_1MS_TCAR1_CAPTURE_VALUE1_SHIFT   (0x00000000)


/* TSICR */
#define DMTIMER_1MS_TSICR_POSTED   (0x00000004)
#define DMTIMER_1MS_TSICR_POSTED_SHIFT   (0x00000002)
#define DMTIMER_1MS_TSICR_POSTED_0   (0x0)
#define DMTIMER_1MS_TSICR_POSTED_1   (0x1)

#define DMTIMER_1MS_TSICR_SFT   (0x00000002)
#define DMTIMER_1MS_TSICR_SFT_SHIFT   (0x00000001)
#define DMTIMER_1MS_TSICR_SFT_0   (0x0)
#define DMTIMER_1MS_TSICR_SFT_1   (0x1)


/* TCAR2 */
#define DMTIMER_1MS_TCAR2_CAPTURE_VALUE2   (0xFFFFFFFF)
#define DMTIMER_1MS_TCAR2_CAPTURE_VALUE2_SHIFT   (0x00000000)


/* TPIR */
#define DMTIMER_1MS_TPIR_POSITIVE_INC_VALUE   (0xFFFFFFFF)
#define DMTIMER_1MS_TPIR_POSITIVE_INC_VALUE_SHIFT   (0x00000000)


/* TNIR */
#define DMTIMER_1MS_TNIR_NEGATIVE_INV_VALUE   (0xFFFFFFFF)
#define DMTIMER_1MS_TNIR_NEGATIVE_INV_VALUE_SHIFT   (0x00000000)


/* TCVR */
#define DMTIMER_1MS_TCVR_COUNTER_VALUE   (0xFFFFFFFF)
#define DMTIMER_1MS_TCVR_COUNTER_VALUE_SHIFT   (0x00000000)


/* TOCR */
#define DMTIMER_1MS_TOCR_OVF_COUNTER_VALUE   (0x00FFFFFF)
#define DMTIMER_1MS_TOCR_OVF_COUNTER_VALUE_SHIFT   (0x00000000)


/* TOWR */
#define DMTIMER_1MS_TOWR_OVF_WRAPPING_VALUE   (0x00FFFFFF)
#define DMTIMER_1MS_TOWR_OVF_WRAPPING_VALUE_SHIFT   (0x00000000)



#ifdef __cplusplus
}
#endif

#endif
