/**
 * \file  hw_emifa2.h
 *
 * \brief EMIFA2 register definitions
 */

/*
* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
*/
/*
*  Redistribution and use in source and binary forms, with or without
*  modification, are permitted provided that the following conditions
*  are met:
*
*    Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


#ifndef _HW_EMIFA_H_
#define _HW_EMIFA_H_

#ifdef __cplusplus
extern "C" {
#endif

#define EMIFA_MIDR		(0x0)
#define EMIFA_AWCC		(0x4)
#define EMIFA_SDCR		(0x8)
#define EMIFA_SDRCR		(0xC)
#define EMIFA_CE2CFG		(0x10)
#define EMIFA_CE3CFG		(0x14)
#define EMIFA_CE4CFG		(0x18)
#define EMIFA_CE5CFG		(0x1C)
#define EMIFA_SDTIMR		(0x20)
#define EMIFA_SDSRETR		(0x3C)
#define EMIFA_INTRAW		(0x40)
#define EMIFA_INTMSK		(0x44)
#define EMIFA_INTMSKSET		(0x48)
#define EMIFA_INTMSKCLR		(0x4C)
#define EMIFA_NANDFCR		(0x60)
#define EMIFA_NANDFSR		(0x64)
#define EMIFA_PMCR		(0x68)
#define EMIFA_NANDF1ECC		(0x70)
#define EMIFA_NANDF2ECC		(0x74)
#define EMIFA_NANDF3ECC		(0x78)
#define EMIFA_NANDF4ECC		(0x7C)
#define EMIFA_NAND4BITECCLOAD	(0xBC)
#define EMIFA_NAND4BITECC1	(0xC0)
#define EMIFA_NAND4BITECC2	(0xC4)
#define EMIFA_NAND4BITECC3	(0xC8)
#define EMIFA_NAND4BITECC4	(0xCC)
#define EMIFA_NANDERRADD1	(0xD0)
#define EMIFA_NANDERRADD2	(0xD4)
#define EMIFA_NANDERRVAL1	(0xD8)
#define EMIFA_NANDERRVAL2	(0xDC)

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* REVID */

#define EMIFA_MIDR_REV         (0xFFFFFFFFu)
#define EMIFA_REVID_REV_SHIFT        (0x00000000u)

/* AWCC */


#define EMIFA_AWCC_WP1          (0x20000000u)
#define EMIFA_AWCC_WP1_SHIFT         (0x0000001Du)

#define EMIFA_AWCC_WP0          (0x10000000u)
#define EMIFA_AWCC_WP0_SHIFT         (0x0000001Cu)
#define EMIFA_AWCC_CS5_WAIT     (0x00C00000u)
#define EMIFA_AWCC_CS5_WAIT_SHIFT    (0x00000016u)
#define EMIFA_AWCC_CS4_WAIT     (0x00300000u)
#define EMIFA_AWCC_CS4_WAIT_SHIFT    (0x00000014u)
#define EMIFA_AWCC_CS3_WAIT     (0x000C0000u)
#define EMIFA_AWCC_CS3_WAIT_SHIFT    (0x00000012u)
#define EMIFA_AWCC_CS2_WAIT     (0x00030000u)
#define EMIFA_AWCC_CS2_WAIT_SHIFT    (0x00000010u)
#define EMIFA_AWCC_MAX_EXT_WAIT (0x000000FFu)
#define EMIFA_AWCC_MAX_EXT_WAIT_SHIFT (0x00000000u)


/* SDCR */

#define EMIFA_SDCR_SR           (0x80000000u)
#define EMIFA_SDCR_SR_SHIFT          (0x0000001Fu)
#define EMIFA_SDCR_PD           (0x40000000u)
#define EMIFA_SDCR_PD_SHIFT          (0x0000001Eu)
#define EMIFA_SDCR_PDWR         (0x20000000u)
#define EMIFA_SDCR_PDWR_SHIFT        (0x0000001Du)
#define EMIFA_SDCR_NM           (0x00004000u)
#define EMIFA_SDCR_NM_SHIFT          (0x0000000Eu)
#define EMIFA_SDCR_CL           (0x00000E00u)
#define EMIFA_SDCR_CL_SHIFT          (0x00000009u)
/*----CL Tokens----*/
#define EMIFA_SDCR_CL_CL2            (0x00000002u)
#define EMIFA_SDCR_CL_CL3            (0x00000003u)

#define EMIFA_SDCR_BIT11_9LOCK  (0x00000100u)
#define EMIFA_SDCR_BIT11_9LOCK_SHIFT (0x00000008u)
#define EMIFA_SDCR_IBANK        (0x00000070u)
#define EMIFA_SDCR_IBANK_SHIFT       (0x00000004u)
/*----IBANK Tokens----*/
#define EMIFA_SDCR_IBANK_1BANK       (0x00000000u)
#define EMIFA_SDCR_IBANK_2BANK       (0x00000001u)
#define EMIFA_SDCR_IBANK_4BANK       (0x00000002u)

#define EMIFA_SDCR_PAGESIZE     (0x00000007u)
#define EMIFA_SDCR_PAGESIZE_SHIFT    (0x00000000u)
/*----PAGESIZE Tokens----*/
#define EMIFA_SDCR_PAGESIZE_256WORD_PAGE (0x00000000u)
#define EMIFA_SDCR_PAGESIZE_512WORD_PAGE (0x00000001u)
#define EMIFA_SDCR_PAGESIZE_1024WORD_PAGE (0x00000002u)
#define EMIFA_SDCR_PAGESIZE_2048WORD_PAGE (0x00000003u)


/* SDRCR */

#define EMIFA_SDRCR_RR          (0x00001FFFu)
#define EMIFA_SDRCR_RR_SHIFT         (0x00000000u)


/* CE2CFG */

#define EMIFA_CE2CFG_SS         (0x80000000u)
#define EMIFA_CE2CFG_SS_SHIFT        (0x0000001Fu)

#define EMIFA_CE2CFG_EW         (0x40000000u)
#define EMIFA_CE2CFG_EW_SHIFT        (0x0000001Eu)

#define EMIFA_CE2CFG_W_SETUP    (0x3C000000u)
#define EMIFA_CE2CFG_W_SETUP_SHIFT   (0x0000001Au)

#define EMIFA_CE2CFG_W_STROBE   (0x03F00000u)
#define EMIFA_CE2CFG_W_STROBE_SHIFT  (0x00000014u)

#define EMIFA_CE2CFG_W_HOLD     (0x000E0000u)
#define EMIFA_CE2CFG_W_HOLD_SHIFT    (0x00000011u)

#define EMIFA_CE2CFG_R_SETUP    (0x0001E000u)
#define EMIFA_CE2CFG_R_SETUP_SHIFT   (0x0000000Du)

#define EMIFA_CE2CFG_R_STROBE   (0x00001F80u)
#define EMIFA_CE2CFG_R_STROBE_SHIFT  (0x00000007u)

#define EMIFA_CE2CFG_R_HOLD     (0x00000070u)
#define EMIFA_CE2CFG_R_HOLD_SHIFT    (0x00000004u)

#define EMIFA_CE2CFG_TA         (0x0000000Cu)
#define EMIFA_CE2CFG_TA_SHIFT        (0x00000002u)

#define EMIFA_CE2CFG_ASIZE      (0x00000003u)
#define EMIFA_CE2CFG_ASIZE_SHIFT     (0x00000000u)

/* CE3CFG */

#define EMIFA_CE3CFG_SS         (0x80000000u)
#define EMIFA_CE3CFG_SS_SHIFT        (0x0000001Fu)

#define EMIFA_CE3CFG_EW         (0x40000000u)
#define EMIFA_CE3CFG_EW_SHIFT        (0x0000001Eu)

#define EMIFA_CE3CFG_W_SETUP    (0x3C000000u)
#define EMIFA_CE3CFG_W_SETUP_SHIFT   (0x0000001Au)

#define EMIFA_CE3CFG_W_STROBE   (0x03F00000u)
#define EMIFA_CE3CFG_W_STROBE_SHIFT  (0x00000014u)

#define EMIFA_CE3CFG_W_HOLD     (0x000E0000u)
#define EMIFA_CE3CFG_W_HOLD_SHIFT    (0x00000011u)

#define EMIFA_CE3CFG_R_SETUP    (0x0001E000u)
#define EMIFA_CE3CFG_R_SETUP_SHIFT   (0x0000000Du)

#define EMIFA_CE3CFG_R_STROBE   (0x00001F80u)
#define EMIFA_CE3CFG_R_STROBE_SHIFT  (0x00000007u)

#define EMIFA_CE3CFG_R_HOLD     (0x00000070u)
#define EMIFA_CE3CFG_R_HOLD_SHIFT    (0x00000004u)

#define EMIFA_CE3CFG_TA         (0x0000000Cu)
#define EMIFA_CE3CFG_TA_SHIFT        (0x00000002u)

#define EMIFA_CE3CFG_ASIZE      (0x00000003u)
#define EMIFA_CE3CFG_ASIZE_SHIFT     (0x00000000u)

/* CE4CFG */

#define EMIFA_CE4CFG_SS         (0x80000000u)
#define EMIFA_CE4CFG_SS_SHIFT        (0x0000001Fu)

#define EMIFA_CE4CFG_EW         (0x40000000u)
#define EMIFA_CE4CFG_EW_SHIFT        (0x0000001Eu)

#define EMIFA_CE4CFG_W_SETUP    (0x3C000000u)
#define EMIFA_CE4CFG_W_SETUP_SHIFT   (0x0000001Au)

#define EMIFA_CE4CFG_W_STROBE   (0x03F00000u)
#define EMIFA_CE4CFG_W_STROBE_SHIFT  (0x00000014u)

#define EMIFA_CE4CFG_W_HOLD     (0x000E0000u)
#define EMIFA_CE4CFG_W_HOLD_SHIFT    (0x00000011u)

#define EMIFA_CE4CFG_R_SETUP    (0x0001E000u)
#define EMIFA_CE4CFG_R_SETUP_SHIFT   (0x0000000Du)

#define EMIFA_CE4CFG_R_STROBE   (0x00001F80u)
#define EMIFA_CE4CFG_R_STROBE_SHIFT  (0x00000007u)

#define EMIFA_CE4CFG_R_HOLD     (0x00000070u)
#define EMIFA_CE4CFG_R_HOLD_SHIFT    (0x00000004u)

#define EMIFA_CE4CFG_TA         (0x0000000Cu)
#define EMIFA_CE4CFG_TA_SHIFT        (0x00000002u)

#define EMIFA_CE4CFG_ASIZE      (0x00000003u)
#define EMIFA_CE4CFG_ASIZE_SHIFT     (0x00000000u)

/* CE5CFG */

#define EMIFA_CE5CFG_SS         (0x80000000u)
#define EMIFA_CE5CFG_SS_SHIFT        (0x0000001Fu)

#define EMIFA_CE5CFG_EW         (0x40000000u)
#define EMIFA_CE5CFG_EW_SHIFT        (0x0000001Eu)

#define EMIFA_CE5CFG_W_SETUP    (0x3C000000u)
#define EMIFA_CE5CFG_W_SETUP_SHIFT   (0x0000001Au)

#define EMIFA_CE5CFG_W_STROBE   (0x03F00000u)
#define EMIFA_CE5CFG_W_STROBE_SHIFT  (0x00000014u)

#define EMIFA_CE5CFG_W_HOLD     (0x000E0000u)
#define EMIFA_CE5CFG_W_HOLD_SHIFT    (0x00000011u)

#define EMIFA_CE5CFG_R_SETUP    (0x0001E000u)
#define EMIFA_CE5CFG_R_SETUP_SHIFT   (0x0000000Du)

#define EMIFA_CE5CFG_R_STROBE   (0x00001F80u)
#define EMIFA_CE5CFG_R_STROBE_SHIFT  (0x00000007u)

#define EMIFA_CE5CFG_R_HOLD     (0x00000070u)
#define EMIFA_CE5CFG_R_HOLD_SHIFT    (0x00000004u)

#define EMIFA_CE5CFG_TA         (0x0000000Cu)
#define EMIFA_CE5CFG_TA_SHIFT        (0x00000002u)

#define EMIFA_CE5CFG_ASIZE      (0x00000003u)
#define EMIFA_CE5CFG_ASIZE_SHIFT     (0x00000000u)

/* SDTIMR */

#define EMIFA_SDTIMR_T_RFC      (0xF8000000u)
#define EMIFA_SDTIMR_T_RFC_SHIFT     (0x0000001Bu)

#define EMIFA_SDTIMR_T_RP       (0x07000000u)
#define EMIFA_SDTIMR_T_RP_SHIFT      (0x00000018u)


#define EMIFA_SDTIMR_T_RCD      (0x00700000u)
#define EMIFA_SDTIMR_T_RCD_SHIFT     (0x00000014u)


#define EMIFA_SDTIMR_T_WR       (0x00070000u)
#define EMIFA_SDTIMR_T_WR_SHIFT      (0x00000010u)

#define EMIFA_SDTIMR_T_RAS      (0x0000F000u)
#define EMIFA_SDTIMR_T_RAS_SHIFT     (0x0000000Cu)

#define EMIFA_SDTIMR_T_RC       (0x00000F00u)
#define EMIFA_SDTIMR_T_RC_SHIFT      (0x00000008u)


#define EMIFA_SDTIMR_T_RRD      (0x00000070u)
#define EMIFA_SDTIMR_T_RRD_SHIFT     (0x00000004u)



/* SDSRETR */


#define EMIFA_SDSRETR_T_XS      (0x0000001Fu)
#define EMIFA_SDSRETR_T_XS_SHIFT     (0x00000000u)


/* INTRAW */


#define EMIFA_INTRAW_WR         (0x00000004u)
#define EMIFA_INTRAW_WR_SHIFT        (0x00000002u)

#define EMIFA_INTRAW_LT         (0x00000002u)
#define EMIFA_INTRAW_LT_SHIFT        (0x00000001u)

#define EMIFA_INTRAW_AT         (0x00000001u)
#define EMIFA_INTRAW_AT_SHIFT        (0x00000000u)


/* INTMSK */


#define EMIFA_INTMSK_WRED_MASK  (0x00000004u)
#define EMIFA_INTMSK_WRED_SHIFT (0x00000002u)

#define EMIFA_INTMSK_LTED_MASK  (0x00000002u)
#define EMIFA_INTMSK_LTED_SHIFT (0x00000001u)

#define EMIFA_INTMSK_ATED_MASK  (0x00000001u)
#define EMIFA_INTMSK_ATED_SHIFT (0x00000000u)


/* INTMSKSET */


#define EMIFA_INTMSKSET_WR_SET_MASK (0x00000004u)
#define EMIFA_INTMSKSET_WR_SET_SHIFT (0x00000002u)

#define EMIFA_INTMSKSET_LT_SET_MASK (0x00000002u)
#define EMIFA_INTMSKSET_LT_SET_SHIFT (0x00000001u)

#define EMIFA_INTMSKSET_AT_SET_MASK (0x00000001u)
#define EMIFA_INTMSKSET_AT_SET_SHIFT (0x00000000u)


/* INTMSKCLR */


#define EMIFA_INTMSKCLR_WR_CLR_MASK (0x00000004u)
#define EMIFA_INTMSKCLR_WR_CLR_SHIFT (0x00000002u)

#define EMIFA_INTMSKCLR_LT_CLR_MASK (0x00000002u)
#define EMIFA_INTMSKCLR_LT_CLR_SHIFT (0x00000001u)

#define EMIFA_INTMSKCLR_AT_CLR_MASK (0x00000001u)
#define EMIFA_INTMSKCLR_AT_CLR_SHIFT (0x00000000u)


/* NANDFCR */


#define EMIFA_NANDFCR_4BITECC_ADD_CALC_START (0x00002000u)
#define EMIFA_NANDFCR_4BITECC_ADD_CALC_START_SHIFT (0x0000000Du)

#define EMIFA_NANDFCR_4BITECC_START (0x00001000u)
#define EMIFA_NANDFCR_4BITECC_START_SHIFT (0x0000000Cu)

#define EMIFA_NANDFCR_CS5ECC    (0x00000800u)
#define EMIFA_NANDFCR_CS5ECC_SHIFT   (0x0000000Bu)

#define EMIFA_NANDFCR_CS4ECC    (0x00000400u)
#define EMIFA_NANDFCR_CS4ECC_SHIFT   (0x0000000Au)

#define EMIFA_NANDFCR_CS3ECC    (0x00000200u)
#define EMIFA_NANDFCR_CS3ECC_SHIFT   (0x00000009u)

#define EMIFA_NANDFCR_CS2ECC    (0x00000100u)
#define EMIFA_NANDFCR_CS2ECC_SHIFT   (0x00000008u)

#define EMIFA_NANDFCR_4BITECCSEL (0x00000030u)
#define EMIFA_NANDFCR_4BITECCSEL_SHIFT (0x00000004u)
/*----4BITECCSEL Tokens----*/
#define EMIFA_NANDFCR_4BITECCSEL_CS2ECC (0x00000000u)
#define EMIFA_NANDFCR_4BITECCSEL_CS3ECC (0x00000001u)
#define EMIFA_NANDFCR_4BITECCSEL_CS4ECC (0x00000002u)
#define EMIFA_NANDFCR_4BITECCSEL_CS5ECC (0x00000003u)

#define EMIFA_NANDFCR_CS5NAND   (0x00000008u)
#define EMIFA_NANDFCR_CS5NAND_SHIFT  (0x00000003u)

#define EMIFA_NANDFCR_CS4NAND   (0x00000004u)
#define EMIFA_NANDFCR_CS4NAND_SHIFT  (0x00000002u)

#define EMIFA_NANDFCR_CS3NAND   (0x00000002u)
#define EMIFA_NANDFCR_CS3NAND_SHIFT  (0x00000001u)

#define EMIFA_NANDFCR_CS2NAND   (0x00000001u)
#define EMIFA_NANDFCR_CS2NAND_SHIFT  (0x00000000u)


/* NANDFSR */


#define EMIFA_NANDFSR_ECC_ERRNUM (0x00030000u)
#define EMIFA_NANDFSR_ECC_ERRNUM_SHIFT (0x00000010u)
/*----ECC_ERRNUM Tokens----*/
#define EMIFA_NANDFSR_ECC_ERRNUM_1ERR (0x00000000u)
#define EMIFA_NANDFSR_ECC_ERRNUM_2ERR (0x00000001u)
#define EMIFA_NANDFSR_ECC_ERRNUM_3ERR (0x00000002u)
#define EMIFA_NANDFSR_ECC_ERRNUM_4ERR (0x00000003u)


#define EMIFA_NANDFSR_ECC_STATE (0x00000F00u)
#define EMIFA_NANDFSR_ECC_STATE_SHIFT (0x00000008u)
/*----ECC_STATE Tokens----*/
#define EMIFA_NANDFSR_ECC_STATE_NOERR (0x00000000u)
#define EMIFA_NANDFSR_ECC_STATE_5ERR (0x00000001u)
#define EMIFA_NANDFSR_ECC_STATE_ERR_CORRECT (0x00000002u)
#define EMIFA_NANDFSR_ECC_STATE_ERR_EXIST (0x00000003u)
#define EMIFA_NANDFSR_ECC_STATE_ERR_CALC (0x00000005u)
#define EMIFA_NANDFSR_ECC_STATE_ERRSEARCH_PREPARE1 (0x00000006u)
#define EMIFA_NANDFSR_ECC_STATE_ERRSEARCH_PREPARE2 (0x00000007u)
#define EMIFA_NANDFSR_ECC_STATE_ERRSEARCH (0x00000008u)
#define EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC1 (0x0000000cu)
#define EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC2 (0x0000000du)
#define EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC3 (0x0000000eu)
#define EMIFA_NANDFSR_ECC_STATE_ERRVALUE_CALC4 (0x0000000fu)


#define EMIFA_NANDFSR_WAITST    (0x0000000Fu)
#define EMIFA_NANDFSR_WAITST_SHIFT   (0x00000000u)

/* PMCR */

#define EMIFA_PMCR_CS5_PG_DEL   (0xFC000000u)
#define EMIFA_PMCR_CS5_PG_DEL_SHIFT  (0x0000001Au)

#define EMIFA_PMCR_CS5_PG_SIZE  (0x02000000u)
#define EMIFA_PMCR_CS5_PG_SIZE_SHIFT (0x00000019u)

#define EMIFA_PMCR_CS5_PG_MD_EN (0x01000000u)
#define EMIFA_PMCR_CS5_PG_MD_EN_SHIFT (0x00000018u)

#define EMIFA_PMCR_CS4_PG_DEL   (0x00FC0000u)
#define EMIFA_PMCR_CS4_PG_DEL_SHIFT  (0x00000012u)

#define EMIFA_PMCR_CS4_PG_SIZE  (0x00020000u)
#define EMIFA_PMCR_CS4_PG_SIZE_SHIFT (0x00000011u)

#define EMIFA_PMCR_CS4_PG_MD_EN (0x00010000u)
#define EMIFA_PMCR_CS4_PG_MD_EN_SHIFT (0x00000010u)

#define EMIFA_PMCR_CS3_PG_DEL   (0x0000FC00u)
#define EMIFA_PMCR_CS3_PG_DEL_SHIFT  (0x0000000Au)

#define EMIFA_PMCR_CS3_PG_SIZE  (0x00000200u)
#define EMIFA_PMCR_CS3_PG_SIZE_SHIFT (0x00000009u)

#define EMIFA_PMCR_CS3_PG_MD_EN (0x00000100u)
#define EMIFA_PMCR_CS3_PG_MD_EN_SHIFT (0x00000008u)

#define EMIFA_PMCR_CS2_PG_DEL   (0x000000FCu)
#define EMIFA_PMCR_CS2_PG_DEL_SHIFT  (0x00000002u)

#define EMIFA_PMCR_CS2_PG_SIZE  (0x00000002u)
#define EMIFA_PMCR_CS2_PG_SIZE_SHIFT (0x00000001u)

#define EMIFA_PMCR_CS2_PG_MD_EN (0x00000001u)
#define EMIFA_PMCR_CS2_PG_MD_EN_SHIFT (0x00000000u)


/* NANDF1ECC */


#define EMIFA_NANDF1ECC_P2048O  (0x08000000u)
#define EMIFA_NANDF1ECC_P2048O_SHIFT (0x0000001Bu)

#define EMIFA_NANDF1ECC_P1024O  (0x04000000u)
#define EMIFA_NANDF1ECC_P1024O_SHIFT (0x0000001Au)

#define EMIFA_NANDF1ECC_P512O   (0x02000000u)
#define EMIFA_NANDF1ECC_P512O_SHIFT  (0x00000019u)

#define EMIFA_NANDF1ECC_P256O   (0x01000000u)
#define EMIFA_NANDF1ECC_P256O_SHIFT  (0x00000018u)

#define EMIFA_NANDF1ECC_P128O   (0x00800000u)
#define EMIFA_NANDF1ECC_P128O_SHIFT  (0x00000017u)

#define EMIFA_NANDF1ECC_P64O    (0x00400000u)
#define EMIFA_NANDF1ECC_P64O_SHIFT   (0x00000016u)

#define EMIFA_NANDF1ECC_P32O    (0x00200000u)
#define EMIFA_NANDF1ECC_P32O_SHIFT   (0x00000015u)

#define EMIFA_NANDF1ECC_P16O    (0x00100000u)
#define EMIFA_NANDF1ECC_P16O_SHIFT   (0x00000014u)

#define EMIFA_NANDF1ECC_P8O     (0x00080000u)
#define EMIFA_NANDF1ECC_P8O_SHIFT    (0x00000013u)

#define EMIFA_NANDF1ECC_P4O     (0x00040000u)
#define EMIFA_NANDF1ECC_P4O_SHIFT    (0x00000012u)

#define EMIFA_NANDF1ECC_P2O     (0x00020000u)
#define EMIFA_NANDF1ECC_P2O_SHIFT    (0x00000011u)

#define EMIFA_NANDF1ECC_P1O     (0x00010000u)
#define EMIFA_NANDF1ECC_P1O_SHIFT    (0x00000010u)


#define EMIFA_NANDF1ECC_P2048E  (0x00000800u)
#define EMIFA_NANDF1ECC_P2048E_SHIFT (0x0000000Bu)

#define EMIFA_NANDF1ECC_P1024E  (0x00000400u)
#define EMIFA_NANDF1ECC_P1024E_SHIFT (0x0000000Au)

#define EMIFA_NANDF1ECC_P512E   (0x00000200u)
#define EMIFA_NANDF1ECC_P512E_SHIFT  (0x00000009u)

#define EMIFA_NANDF1ECC_P256E   (0x00000100u)
#define EMIFA_NANDF1ECC_P256E_SHIFT  (0x00000008u)

#define EMIFA_NANDF1ECC_P128E   (0x00000080u)
#define EMIFA_NANDF1ECC_P128E_SHIFT  (0x00000007u)

#define EMIFA_NANDF1ECC_P64E    (0x00000040u)
#define EMIFA_NANDF1ECC_P64E_SHIFT   (0x00000006u)

#define EMIFA_NANDF1ECC_P32E    (0x00000020u)
#define EMIFA_NANDF1ECC_P32E_SHIFT   (0x00000005u)

#define EMIFA_NANDF1ECC_P16E    (0x00000010u)
#define EMIFA_NANDF1ECC_P16E_SHIFT   (0x00000004u)

#define EMIFA_NANDF1ECC_P8E     (0x00000008u)
#define EMIFA_NANDF1ECC_P8E_SHIFT    (0x00000003u)

#define EMIFA_NANDF1ECC_P4E     (0x00000004u)
#define EMIFA_NANDF1ECC_P4E_SHIFT    (0x00000002u)

#define EMIFA_NANDF1ECC_P2E     (0x00000002u)
#define EMIFA_NANDF1ECC_P2E_SHIFT    (0x00000001u)

#define EMIFA_NANDF1ECC_P1E     (0x00000001u)
#define EMIFA_NANDF1ECC_P1E_SHIFT    (0x00000000u)


/* NANDF2ECC */


#define EMIFA_NANDF2ECC_P2048O  (0x08000000u)
#define EMIFA_NANDF2ECC_P2048O_SHIFT (0x0000001Bu)

#define EMIFA_NANDF2ECC_P1024O  (0x04000000u)
#define EMIFA_NANDF2ECC_P1024O_SHIFT (0x0000001Au)

#define EMIFA_NANDF2ECC_P512O   (0x02000000u)
#define EMIFA_NANDF2ECC_P512O_SHIFT  (0x00000019u)

#define EMIFA_NANDF2ECC_P256O   (0x01000000u)
#define EMIFA_NANDF2ECC_P256O_SHIFT  (0x00000018u)

#define EMIFA_NANDF2ECC_P128O   (0x00800000u)
#define EMIFA_NANDF2ECC_P128O_SHIFT  (0x00000017u)

#define EMIFA_NANDF2ECC_P64O    (0x00400000u)
#define EMIFA_NANDF2ECC_P64O_SHIFT   (0x00000016u)

#define EMIFA_NANDF2ECC_P32O    (0x00200000u)
#define EMIFA_NANDF2ECC_P32O_SHIFT   (0x00000015u)

#define EMIFA_NANDF2ECC_P16O    (0x00100000u)
#define EMIFA_NANDF2ECC_P16O_SHIFT   (0x00000014u)

#define EMIFA_NANDF2ECC_P8O     (0x00080000u)
#define EMIFA_NANDF2ECC_P8O_SHIFT    (0x00000013u)

#define EMIFA_NANDF2ECC_P4O     (0x00040000u)
#define EMIFA_NANDF2ECC_P4O_SHIFT    (0x00000012u)

#define EMIFA_NANDF2ECC_P2O     (0x00020000u)
#define EMIFA_NANDF2ECC_P2O_SHIFT    (0x00000011u)

#define EMIFA_NANDF2ECC_P1O     (0x00010000u)
#define EMIFA_NANDF2ECC_P1O_SHIFT    (0x00000010u)


#define EMIFA_NANDF2ECC_P2048E  (0x00000800u)
#define EMIFA_NANDF2ECC_P2048E_SHIFT (0x0000000Bu)

#define EMIFA_NANDF2ECC_P1024E  (0x00000400u)
#define EMIFA_NANDF2ECC_P1024E_SHIFT (0x0000000Au)

#define EMIFA_NANDF2ECC_P512E   (0x00000200u)
#define EMIFA_NANDF2ECC_P512E_SHIFT  (0x00000009u)

#define EMIFA_NANDF2ECC_P256E   (0x00000100u)
#define EMIFA_NANDF2ECC_P256E_SHIFT  (0x00000008u)

#define EMIFA_NANDF2ECC_P128E   (0x00000080u)
#define EMIFA_NANDF2ECC_P128E_SHIFT  (0x00000007u)

#define EMIFA_NANDF2ECC_P64E    (0x00000040u)
#define EMIFA_NANDF2ECC_P64E_SHIFT   (0x00000006u)

#define EMIFA_NANDF2ECC_P32E    (0x00000020u)
#define EMIFA_NANDF2ECC_P32E_SHIFT   (0x00000005u)

#define EMIFA_NANDF2ECC_P16E    (0x00000010u)
#define EMIFA_NANDF2ECC_P16E_SHIFT   (0x00000004u)

#define EMIFA_NANDF2ECC_P8E     (0x00000008u)
#define EMIFA_NANDF2ECC_P8E_SHIFT    (0x00000003u)

#define EMIFA_NANDF2ECC_P4E     (0x00000004u)
#define EMIFA_NANDF2ECC_P4E_SHIFT    (0x00000002u)

#define EMIFA_NANDF2ECC_P2E     (0x00000002u)
#define EMIFA_NANDF2ECC_P2E_SHIFT    (0x00000001u)

#define EMIFA_NANDF2ECC_P1E     (0x00000001u)
#define EMIFA_NANDF2ECC_P1E_SHIFT    (0x00000000u)


/* NANDF3ECC */


#define EMIFA_NANDF3ECC_P2048O  (0x08000000u)
#define EMIFA_NANDF3ECC_P2048O_SHIFT (0x0000001Bu)

#define EMIFA_NANDF3ECC_P1024O  (0x04000000u)
#define EMIFA_NANDF3ECC_P1024O_SHIFT (0x0000001Au)

#define EMIFA_NANDF3ECC_P512O   (0x02000000u)
#define EMIFA_NANDF3ECC_P512O_SHIFT  (0x00000019u)

#define EMIFA_NANDF3ECC_P256O   (0x01000000u)
#define EMIFA_NANDF3ECC_P256O_SHIFT  (0x00000018u)

#define EMIFA_NANDF3ECC_P128O   (0x00800000u)
#define EMIFA_NANDF3ECC_P128O_SHIFT  (0x00000017u)

#define EMIFA_NANDF3ECC_P64O    (0x00400000u)
#define EMIFA_NANDF3ECC_P64O_SHIFT   (0x00000016u)

#define EMIFA_NANDF3ECC_P32O    (0x00200000u)
#define EMIFA_NANDF3ECC_P32O_SHIFT   (0x00000015u)

#define EMIFA_NANDF3ECC_P16O    (0x00100000u)
#define EMIFA_NANDF3ECC_P16O_SHIFT   (0x00000014u)

#define EMIFA_NANDF3ECC_P8O     (0x00080000u)
#define EMIFA_NANDF3ECC_P8O_SHIFT    (0x00000013u)

#define EMIFA_NANDF3ECC_P4O     (0x00040000u)
#define EMIFA_NANDF3ECC_P4O_SHIFT    (0x00000012u)

#define EMIFA_NANDF3ECC_P2O     (0x00020000u)
#define EMIFA_NANDF3ECC_P2O_SHIFT    (0x00000011u)

#define EMIFA_NANDF3ECC_P1O     (0x00010000u)
#define EMIFA_NANDF3ECC_P1O_SHIFT    (0x00000010u)


#define EMIFA_NANDF3ECC_P2048E  (0x00000800u)
#define EMIFA_NANDF3ECC_P2048E_SHIFT (0x0000000Bu)

#define EMIFA_NANDF3ECC_P1024E  (0x00000400u)
#define EMIFA_NANDF3ECC_P1024E_SHIFT (0x0000000Au)

#define EMIFA_NANDF3ECC_P512E   (0x00000200u)
#define EMIFA_NANDF3ECC_P512E_SHIFT  (0x00000009u)

#define EMIFA_NANDF3ECC_P256E   (0x00000100u)
#define EMIFA_NANDF3ECC_P256E_SHIFT  (0x00000008u)

#define EMIFA_NANDF3ECC_P128E   (0x00000080u)
#define EMIFA_NANDF3ECC_P128E_SHIFT  (0x00000007u)

#define EMIFA_NANDF3ECC_P64E    (0x00000040u)
#define EMIFA_NANDF3ECC_P64E_SHIFT   (0x00000006u)

#define EMIFA_NANDF3ECC_P32E    (0x00000020u)
#define EMIFA_NANDF3ECC_P32E_SHIFT   (0x00000005u)

#define EMIFA_NANDF3ECC_P16E    (0x00000010u)
#define EMIFA_NANDF3ECC_P16E_SHIFT   (0x00000004u)

#define EMIFA_NANDF3ECC_P8E     (0x00000008u)
#define EMIFA_NANDF3ECC_P8E_SHIFT    (0x00000003u)

#define EMIFA_NANDF3ECC_P4E     (0x00000004u)
#define EMIFA_NANDF3ECC_P4E_SHIFT    (0x00000002u)

#define EMIFA_NANDF3ECC_P2E     (0x00000002u)
#define EMIFA_NANDF3ECC_P2E_SHIFT    (0x00000001u)

#define EMIFA_NANDF3ECC_P1E     (0x00000001u)
#define EMIFA_NANDF3ECC_P1E_SHIFT    (0x00000000u)


/* NANDF4ECC */


#define EMIFA_NANDF4ECC_P2048O  (0x08000000u)
#define EMIFA_NANDF4ECC_P2048O_SHIFT (0x0000001Bu)

#define EMIFA_NANDF4ECC_P1024O  (0x04000000u)
#define EMIFA_NANDF4ECC_P1024O_SHIFT (0x0000001Au)

#define EMIFA_NANDF4ECC_P512O   (0x02000000u)
#define EMIFA_NANDF4ECC_P512O_SHIFT  (0x00000019u)

#define EMIFA_NANDF4ECC_P256O   (0x01000000u)
#define EMIFA_NANDF4ECC_P256O_SHIFT  (0x00000018u)

#define EMIFA_NANDF4ECC_P128O   (0x00800000u)
#define EMIFA_NANDF4ECC_P128O_SHIFT  (0x00000017u)

#define EMIFA_NANDF4ECC_P64O    (0x00400000u)
#define EMIFA_NANDF4ECC_P64O_SHIFT   (0x00000016u)

#define EMIFA_NANDF4ECC_P32O    (0x00200000u)
#define EMIFA_NANDF4ECC_P32O_SHIFT   (0x00000015u)

#define EMIFA_NANDF4ECC_P16O    (0x00100000u)
#define EMIFA_NANDF4ECC_P16O_SHIFT   (0x00000014u)

#define EMIFA_NANDF4ECC_P8O     (0x00080000u)
#define EMIFA_NANDF4ECC_P8O_SHIFT    (0x00000013u)

#define EMIFA_NANDF4ECC_P4O     (0x00040000u)
#define EMIFA_NANDF4ECC_P4O_SHIFT    (0x00000012u)

#define EMIFA_NANDF4ECC_P2O     (0x00020000u)
#define EMIFA_NANDF4ECC_P2O_SHIFT    (0x00000011u)

#define EMIFA_NANDF4ECC_P1O     (0x00010000u)
#define EMIFA_NANDF4ECC_P1O_SHIFT    (0x00000010u)


#define EMIFA_NANDF4ECC_P2048E  (0x00000800u)
#define EMIFA_NANDF4ECC_P2048E_SHIFT (0x0000000Bu)

#define EMIFA_NANDF4ECC_P1024E  (0x00000400u)
#define EMIFA_NANDF4ECC_P1024E_SHIFT (0x0000000Au)

#define EMIFA_NANDF4ECC_P512E   (0x00000200u)
#define EMIFA_NANDF4ECC_P512E_SHIFT  (0x00000009u)

#define EMIFA_NANDF4ECC_P256E   (0x00000100u)
#define EMIFA_NANDF4ECC_P256E_SHIFT  (0x00000008u)

#define EMIFA_NANDF4ECC_P128E   (0x00000080u)
#define EMIFA_NANDF4ECC_P128E_SHIFT  (0x00000007u)

#define EMIFA_NANDF4ECC_P64E    (0x00000040u)
#define EMIFA_NANDF4ECC_P64E_SHIFT   (0x00000006u)

#define EMIFA_NANDF4ECC_P32E    (0x00000020u)
#define EMIFA_NANDF4ECC_P32E_SHIFT   (0x00000005u)

#define EMIFA_NANDF4ECC_P16E    (0x00000010u)
#define EMIFA_NANDF4ECC_P16E_SHIFT   (0x00000004u)

#define EMIFA_NANDF4ECC_P8E     (0x00000008u)
#define EMIFA_NANDF4ECC_P8E_SHIFT    (0x00000003u)

#define EMIFA_NANDF4ECC_P4E     (0x00000004u)
#define EMIFA_NANDF4ECC_P4E_SHIFT    (0x00000002u)

#define EMIFA_NANDF4ECC_P2E     (0x00000002u)
#define EMIFA_NANDF4ECC_P2E_SHIFT    (0x00000001u)

#define EMIFA_NANDF4ECC_P1E     (0x00000001u)
#define EMIFA_NANDF4ECC_P1E_SHIFT    (0x00000000u)


/* NAND4BITECCLOAD */


#define EMIFA_NAND4BITECCLOAD_4BITECCLOAD (0x000003FFu)
#define EMIFA_NAND4BITECCLOAD_4BITECCLOAD_SHIFT (0x00000000u)


/* NAND4BITECC1 */


#define EMIFA_NAND4BITECC1_4BITECCVAL2 (0x03FF0000u)
#define EMIFA_NAND4BITECC1_4BITECCVAL2_SHIFT (0x00000010u)


#define EMIFA_NAND4BITECC1_4BITECCVAL1 (0x000003FFu)
#define EMIFA_NAND4BITECC1_4BITECCVAL1_SHIFT (0x00000000u)


/* NAND4BITECC2 */


#define EMIFA_NAND4BITECC2_4BITECCVAL4 (0x03FF0000u)
#define EMIFA_NAND4BITECC2_4BITECCVAL4_SHIFT (0x00000010u)


#define EMIFA_NAND4BITECC2_4BITECCVAL3 (0x000003FFu)
#define EMIFA_NAND4BITECC2_4BITECCVAL3_SHIFT (0x00000000u)


/* NAND4BITECC3 */


#define EMIFA_NAND4BITECC3_4BITECCVAL6 (0x03FF0000u)
#define EMIFA_NAND4BITECC3_4BITECCVAL6_SHIFT (0x00000010u)


#define EMIFA_NAND4BITECC3_4BITECCVAL5 (0x000003FFu)
#define EMIFA_NAND4BITECC3_4BITECCVAL5_SHIFT (0x00000000u)


/* NAND4BITECC4 */


#define EMIFA_NAND4BITECC4_4BITECCVAL8 (0x03FF0000u)
#define EMIFA_NAND4BITECC4_4BITECCVAL8_SHIFT (0x00000010u)


#define EMIFA_NAND4BITECC4_4BITECCVAL7 (0x000003FFu)
#define EMIFA_NAND4BITECC4_4BITECCVAL7_SHIFT (0x00000000u)


/* NANDERRADD1 */


#define EMIFA_NANDERRADD1_4BITECCERRADD2 (0x03FF0000u)
#define EMIFA_NANDERRADD1_4BITECCERRADD2_SHIFT (0x00000010u)


#define EMIFA_NANDERRADD1_4BITECCERRADD1 (0x000003FFu)
#define EMIFA_NANDERRADD1_4BITECCERRADD1_SHIFT (0x00000000u)


/* NANDERRADD2 */


#define EMIFA_NANDERRADD2_4BITECCERRADD4 (0x03FF0000u)
#define EMIFA_NANDERRADD2_4BITECCERRADD4_SHIFT (0x00000010u)


#define EMIFA_NANDERRADD2_4BITECCERRADD3 (0x000003FFu)
#define EMIFA_NANDERRADD2_4BITECCERRADD3_SHIFT (0x00000000u)


/* NANDERRVAL1 */


#define EMIFA_NANDERRVAL1_4BITECCERRVAL2 (0x03FF0000u)
#define EMIFA_NANDERRVAL1_4BITECCERRVAL2_SHIFT (0x00000010u)


#define EMIFA_NANDERRVAL1_4BITECCERRVAL1 (0x000003FFu)
#define EMIFA_NANDERRVAL1_4BITECCERRVAL1_SHIFT (0x00000000u)


/* NANDERRVAL2 */


#define EMIFA_NANDERRVAL2_4BITECCERRVAL4 (0x03FF0000u)
#define EMIFA_NANDERRVAL2_4BITECCERRVAL4_SHIFT (0x00000010u)


#define EMIFA_NANDERRVAL2_4BITECCERRVAL3 (0x000003FFu)
#define EMIFA_NANDERRVAL2_4BITECCERRVAL3_SHIFT (0x00000000u)


#ifdef __cplusplus
}
#endif

#endif
