/*
 *  ======== main.c ========
 */

#include <xdc/std.h>

#include <xdc/runtime/Error.h>
#include <xdc/runtime/System.h>

#include <ti/sysbios/BIOS.h>

#include <ti/sysbios/knl/Task.h>

#include "osdrv_mmu.h"

extern void GpmcInitial();
extern void GPMCClkConfig(void);
extern void GpmcWriteFpga();
extern void GpmcReadFpga();

/*
 *  ======== taskFxn ========
 */
Void taskFxn(UArg a0, UArg a1)
{
   unsigned short i = 0;
	System_printf("enter taskFxn()\n");

    //GpmcWriteFpga();
    //Task_sleep(10);
    //GpmcReadFpga();
    while(1)
    {
    	System_printf("===== task loop =====\n");
    	i++;

    	(*(volatile unsigned short*)(0x0a000000 +0x0)) = i ;
    	GpmcReadFpga();

    	Task_sleep(100);
    	System_flush();

    }
    System_printf("exit taskFxn()\n");

     /* force SysMin output to console */
}

/*
 *  ======== main ========
 */
SYS_MMU_ENTRY applMmuEntries[] = {

    {(void*)0x48300000,0},  //PWM - Non bufferable| Non Cacheable
    {(void*)0x48200000,0},  //INTCPS,MPUSS - Non bufferable| Non Cacheable
    {(void*)0x48100000,0},  //I2C2,McSPI1,UART3,UART4,UART5, GPIO2,GPIO3,MMC1 - Non bufferable| Non Cacheable
    {(void*)0x48000000,0},  //UART1,UART2,I2C1,McSPI0,McASP0 CFG,McASP1 CFG,DMTIMER,GPIO1 -Non bufferable| Non Cacheable
    {(void*)0x44E00000,0},  //Clock Module, PRM, GPIO0, UART0, I2C0, - Non bufferable| Non Cacheable
    {(void*)0x4A300000,0},  //PRUSS1 - Non bufferable| Non Cacheable
    {(void*)0x49000000,0},  //EDMA3 - Non bufferable| Non Cacheable
    {(void*)0x4A100000,0},  //CPSW - Non bufferable| Non Cacheable
	{(void*)0x50000000,0},
	{(void*)0x0a000000,0},
    {(void*)0xFFFFFFFF,0xFFFFFFFF}
};

Int main()
{ 
    Task_Handle task;
    Error_Block eb;

    System_printf("enter main()\n");

    Error_init(&eb);
    task = Task_create(taskFxn, NULL, &eb);
    if (task == NULL) {
        System_printf("Task_create() failed!\n");
        BIOS_exit(0);
    }

    //MMUConfigAndEnable();
    //GPMCClkConfig();

    MMUInit(applMmuEntries);
#if 1
    GpmcInitial();
    System_printf("1 ====== %8x \n", (*(volatile unsigned short*)(0x50000000 + 0xc0)));
    System_printf("2 ====== %8x \n", (*(volatile unsigned short*)(0x50000000 + 0xc4)));
    System_printf("3 ====== %8x \n", (*(volatile unsigned short*)(0x50000000 + 0xc8)));
    System_printf("4 ====== %8x \n", (*(volatile unsigned short*)(0x50000000 + 0xcc)));
    System_printf("5 ====== %8x \n", (*(volatile unsigned short*)(0x50000000 + 0xd0)));
    System_printf("6 ====== %8x \n", (*(volatile unsigned short*)(0x50000000 + 0xd4)));
    System_printf("7 ====== %8x \n", (*(volatile unsigned short*)(0x50000000 + 0xd8)));

    System_printf("test ====== %d \n", (*(volatile unsigned short*)(0x0a000000 +0x20)));
    System_flush();

#endif
    BIOS_start();    /* does not return */
    return(0);
}
