
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <limits.h>
#include <math.h>

#include "DSPF_sp_fftSPxSP.h"
#include "DSPF_sp_fftSPxSP_opt.h"
#include "DSPF_sp_fftSPxSP_cn.h"

void tw_gen    (float *w, int n);

/* ======================================================================== */
/*  Kernel-specific alignments                                              */
/* ======================================================================== */
#pragma DATA_ALIGN(x_array, 8);
#pragma DATA_ALIGN(y_array, 8);
#pragma DATA_ALIGN(w_array, 8);
#pragma DATA_ALIGN(brev, 8);

/* ======================================================================== */
/*  Parameters of fixed dataset.                                            */
/* ======================================================================== */
#define MAXN (1024)
#define M    (2*MAXN)

/* ======================================================================== */
/*  Initialized arrays with fixed test data.                                */
/* ======================================================================== */

float x_array[M];
float y_array[M];
float w_array[M];

unsigned char brev[64] = {
    0x0, 0x20, 0x10, 0x30, 0x8, 0x28, 0x18, 0x38,
    0x4, 0x24, 0x14, 0x34, 0xc, 0x2c, 0x1c, 0x3c,
    0x2, 0x22, 0x12, 0x32, 0xa, 0x2a, 0x1a, 0x3a,
    0x6, 0x26, 0x16, 0x36, 0xe, 0x2e, 0x1e, 0x3e,
    0x1, 0x21, 0x11, 0x31, 0x9, 0x29, 0x19, 0x39,
    0x5, 0x25, 0x15, 0x35, 0xd, 0x2d, 0x1d, 0x3d,
    0x3, 0x23, 0x13, 0x33, 0xb, 0x2b, 0x1b, 0x3b,
    0x7, 0x27, 0x17, 0x37, 0xf, 0x2f, 0x1f, 0x3f
};

/* ======================================================================== */
/*  MAIN -- Top level driver for the test.                                  */
/* ======================================================================== */

int main ()
{
    int i, j,  rad, N;
    FILE *fp;
    char dump_array = 1;

    N = 1024;

    /* ---------------------------------------------------------------- */
    /* Initialize input vector temporarily.                             */
    /* ---------------------------------------------------------------- */
    for (i = 0; i < N; i++)
    {
        x_array[2 * i]     = sin (2 * 3.1415 *  50 * i / (double) N);
        x_array[2 * i + 1] = sin (2 * 3.1415 * 100 * i / (double) N);
    }

    /* ---------------------------------------------------------------- */
    /* Force uninitialized arrays to fixed values.                      */
    /* ---------------------------------------------------------------- */
    memset (y_array,  0xA5, sizeof (y_array) );

    /* ---------------------------------------------------------------- */
    /* Generate twiddle factors.                                        */
    /* ---------------------------------------------------------------- */
    j = 0;
    for (i = 0; i <= 31; i++)
        if ((N & (1 << i)) == 0)
            j++;
        else
            break;

    if (j % 2 == 0)
        rad = 4;
    else
        rad = 2;

    tw_gen (w_array, N);

    // dump input array
    if (dump_array)
    {
        fp = fopen("fft_ti_data.m","wb");
        fprintf (fp, "input_fft = [");
        for (i=0; i<N*2; i++)
            if (i != ((2*N)-1))
                fprintf (fp, "%f, ", x_array[i]);
            else
            fprintf (fp, "%f];\n", x_array[i]);
    }
    //DSPF_sp_fftSPxSP_cn (N, x_array, w_array, y_array, brev, rad, 0, N);
    //DSPF_sp_fftSPxSP_opt (N, x_array, w_array, y_array, brev, rad, 0, N);
    DSPF_sp_fftSPxSP (N, x_array, w_array, y_array, brev, rad, 0, N);

    // dump the result
    if (dump_array)
    {
        fprintf (fp, "output_fft = [");
        for (i=0; i<N*2; i++)
        {
            if (i != ((2*N)-1))
                fprintf (fp, "%f, ", y_array[i]);
            else
                fprintf (fp, "%f];\n", y_array[i]);
        }
        fclose(fp);
    }
}

/* Function for generating Specialized sequence of twiddle factors */
void tw_gen (float *w, int n)
{
    int i, j, k;
    const double PI = 3.141592654;

    for (j = 1, k = 0; j <= n >> 2; j = j << 2)
    {
        for (i = 0; i < n >> 2; i += j)
        {
#ifdef _LITTLE_ENDIAN
            w[k]     = (float) sin (2 * PI * i / n);
            w[k + 1] = (float) cos (2 * PI * i / n);
            w[k + 2] = (float) sin (4 * PI * i / n);
            w[k + 3] = (float) cos (4 * PI * i / n);
            w[k + 4] = (float) sin (6 * PI * i / n);
            w[k + 5] = (float) cos (6 * PI * i / n);
#else
            w[k]     = (float)  cos (2 * PI * i / n);
            w[k + 1] = (float) -sin (2 * PI * i / n);
            w[k + 2] = (float)  cos (4 * PI * i / n);
            w[k + 3] = (float) -sin (4 * PI * i / n);
            w[k + 4] = (float)  cos (6 * PI * i / n);
            w[k + 5] = (float) -sin (6 * PI * i / n);
#endif
            k += 6;
        }
    }
}
