/*
 * EVM5517.h
 *
 *  Created on: 201616
 *      Author: xiaoma
 */

#ifndef EVM5517_H_
#define EVM5517_H_

/* ------------------------------------------------------------------------ *
 *  MCBSP Registers                                                           *
 * ------------------------------------------------------------------------ */
//#define MCBSP_BASE             0x4000
//#define MCBSP_DRRL            *( volatile  Uint16* )( 0x4000 )
//#define MCBSP_DRRU            *( volatile  Uint16* )( 0x4001 )
//#define MCBSP_DXRL            *( volatile  Uint16* )( 0x4004 )
//#define MCBSP_DXRU            *( volatile  Uint16* )( 0x4005 )
//#define MCBSP_SPCRL           *( volatile  Uint16* )( 0x4008 )
//#define MCBSP_SPCRU           *( volatile  Uint16* )( 0x4009 )
//#define MCBSP_RCRL            *( volatile  Uint16* )( 0x400C )
//#define MCBSP_RCRU            *( volatile  Uint16* )( 0x400D )
//#define MCBSP_XCRL            *( volatile  Uint16* )( 0x4010 )
//#define MCBSP_XCRU            *( volatile  Uint16* )( 0x4011 )
//#define MCBSP_SRGRL           *( volatile  Uint16* )( 0x4014 )
//#define MCBSP_SRGRU           *( volatile  Uint16* )( 0x4015 )
//#define MCBSP_MCRL            *( volatile  Uint16* )( 0x4018 )
//#define MCBSP_MCRU            *( volatile  Uint16* )( 0x4019 )
//#define MCBSP_RCERA           *( volatile  Uint16* )( 0x401C )
//#define MCBSP_RCERB           *( volatile  Uint16* )( 0x401D )
//#define MCBSP_XCERA           *( volatile  Uint16* )( 0x4020 )
//#define MCBSP_XCERB           *( volatile  Uint16* )( 0x4021 )
//#define MCBSP_PCRL            *( volatile  Uint16* )( 0x4024 )
//#define MCBSP_PCRU            *( volatile  Uint16* )( 0x4025 )
//#define MCBSP_RCERC           *( volatile  Uint16* )( 0x4028 )
//#define MCBSP_RCERD           *( volatile  Uint16* )( 0x4029 )
//#define MCBSP_XCERC           *( volatile  Uint16* )( 0x402C )
//#define MCBSP_XCERD           *( volatile  Uint16* )( 0x402D )
//#define MCBSP_RCERE           *( volatile  Uint16* )( 0x4030 )
//#define MCBSP_RCERF           *( volatile  Uint16* )( 0x4031 )
//#define MCBSP_XCERE           *( volatile  Uint16* )( 0x4034 )
//#define MCBSP_XCERF           *( volatile  Uint16* )( 0x4035 )
//#define MCBSP_RCERG           *( volatile  Uint16* )( 0x4038 )
//#define MCBSP_RCERH           *( volatile  Uint16* )( 0x4039 )
//#define MCBSP_XCERG           *( volatile  Uint16* )( 0x403C )
//#define MCBSP_XCERH           *( volatile  Uint16* )( 0x403D )

#define MCBSP_BASE             0x4000
#define MCBSP_DRRL            *(unsigned short *)( 0x4000 )
#define MCBSP_DRRU            *(unsigned short *)( 0x4001 )
#define MCBSP_DXRL            *(unsigned short *)( 0x4004 )
#define MCBSP_DXRU            *(unsigned short *)( 0x4005 )
#define MCBSP_SPCRL           *(unsigned short *)( 0x4008 )
#define MCBSP_SPCRU           *(unsigned short *)( 0x4009 )
#define MCBSP_RCRL            *(unsigned short *)( 0x400C )
#define MCBSP_RCRU            *(unsigned short *)( 0x400D )
#define MCBSP_XCRL            *(unsigned short *)( 0x4010 )
#define MCBSP_XCRU            *(unsigned short *)( 0x4011 )
#define MCBSP_SRGRL           *(unsigned short *)( 0x4014 )
#define MCBSP_SRGRU           *(unsigned short *)( 0x4015 )
#define MCBSP_MCRL            *(unsigned short *)( 0x4018 )
#define MCBSP_MCRU            *(unsigned short *)( 0x4019 )
#define MCBSP_RCERA           *(unsigned short *)( 0x401C )
#define MCBSP_RCERB           *(unsigned short *)( 0x401D )
#define MCBSP_XCERA           *(unsigned short *)( 0x4020 )
#define MCBSP_XCERB           *(unsigned short *)( 0x4021 )
#define MCBSP_PCRL            *(unsigned short *)( 0x4024 )
#define MCBSP_PCRU            *(unsigned short *)( 0x4025 )
#define MCBSP_RCERC           *(unsigned short *)( 0x4028 )
#define MCBSP_RCERD           *(unsigned short *)( 0x4029 )
#define MCBSP_XCERC           *(unsigned short *)( 0x402C )
#define MCBSP_XCERD           *(unsigned short *)( 0x402D )
#define MCBSP_RCERE           *(unsigned short *)( 0x4030 )
#define MCBSP_RCERF           *(unsigned short *)( 0x4031 )
#define MCBSP_XCERE           *(unsigned short *)( 0x4034 )
#define MCBSP_XCERF           *(unsigned short *)( 0x4035 )
#define MCBSP_RCERG           *(unsigned short *)( 0x4038 )
#define MCBSP_RCERH           *(unsigned short *)( 0x4039 )
#define MCBSP_XCERG           *(unsigned short *)( 0x403C )
#define MCBSP_XCERH           *(unsigned short *)( 0x403D )

/* ------------------------------------------------------------------------ *
 *  System Module                                                           *
 * ------------------------------------------------------------------------ */
#define SYS_EBSR           *(unsigned short *)(0x1c00)
#define SYS_PCGCR1         *(unsigned short *)(0x1c02)
#define SYS_PCGCR2         *(unsigned short *)(0x1c03)
#define SYS_PSRCR          *(unsigned short *)(0x1c04)
#define SYS_PRCR           *(unsigned short *)(0x1c05)
#define SYS_IER0               *(unsigned short *)(0x0000)
#define SYS_IFR0               *(unsigned short *)(0x0001)
#define SYS_IER1               *(unsigned short *)(0x0045)
#define SYS_IFR1               *(unsigned short *)(0x0046)

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Variable types                                                          *
 *                                                                          *
 * ------------------------------------------------------------------------ */

//#define Uint32  unsigned int
//#define Uint16  unsigned short
//#define Uint8   unsigned char
//#define Int32   int
//#define Int16   short
//#define Int8    char

interrupt void DMA_Isr(void);

#endif /* EVM5517_H_ */
