///*
// * main.c
// */
#include "stdio.h"
#include "string.h"
#include "math.h"
#include "EVM5517.h"
#include "register_dma.h"
#include "csl_intc.h"
#include <csl_general.h>
//
unsigned int flag1=0;
unsigned int flag2=0;
#define buffersize 10240
unsigned int temptx[buffersize];
unsigned int rxtemp[buffersize];
unsigned int temptx1[buffersize];
unsigned int CurrentTxT_DMAChannel =1;
unsigned int CurrentTxR_DMAChannel =1;
extern void VECSTART(void);
interrupt void DMA_Isr(void);
//
void delay(unsigned int count)
{
    unsigned int i=0;
    for(i=0; i<count;i++) {}
}
///* ------------------------------------------------------------------------ *
// *                                                                          *
// *  Initialize SYSTEM                                                          *
// *                                                                          *
// * ------------------------------------------------------------------------ */
void InitSystem(void)
{
    unsigned short i;
    SYS_PSRCR = 0x08;  //PSRCR
    SYS_PRCR = (1 << 4 |
				1 << 6);  //Ӧ1!!!!;     // Reset
    for(i=0;i<500;i++){;}
    SYS_PCGCR2 = (0 <<5 |
                  0 <<4 |
                  0 <<3) ;   //enable the DMA controller 3 peripheral clock.
    SYS_PCGCR1 = (0 <<15 | //enable the MCBSP peripheral clock.
                  0 <<5 |
                  0 <<3);
    SYS_EBSR = 0x0300;//Ÿ
//   SYS_PSRCR = 0x08;  //Peripheral Software Reset Counter Register

}
/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Initialize DMA                                                          *
 *                                                                          *
 * ------------------------------------------------------------------------ */
void C5517_DMA_INIT()
{
    DMA_IFR = 0xFFFF;     // clear interrupt flags
    DMA_IER = 0xF000;     // enable DMA3CH3IE DMA3CH2IE DMA3CH1IE DMA3CH0IE
    DMA3_CH10_EVENT_SRC = DMA3_CH10_EVENT_SRC | 0x0001;  //DMA3 channel 0 McBSP transmit event
    DMA3_CH10_EVENT_SRC = DMA3_CH10_EVENT_SRC | 0x0200;  //DMA3 channel 1 McBSP receive event
    //transmit parameter configuration
    DMA3_CH0_SRC_LSW =(unsigned int) (& temptx[0]);
//    DMA3_CH0_SRC_MSW = (unsigned int) ((& temptx[0]) >> 15);
    DMA3_CH0_SRC_MSW = 0;                   //ַȷԲԣ
    DMA3_CH0_DST_LSW = 0x6004;
//    DMA3_CH0_DST_MSW = 0x6005;
    DMA3_CH0_DST_MSW = 0;
    DMA3_CH0_TC_LSW = 0x0400;
    DMA3_CH0_TC_MSW = ( 0 << 15   |  // Channel enable
                        1 << 14   |  // Channel status
                        1 << 13   | // CPU interrupt enable
                        1 << 12   | //Automatic reload      //дȶ
                        2 << 8    |  // Destination addressing mode Constant address
                        0 << 6    |  //Source addressing mode  Automatic post increment
                        0 << 3    | //1 double words (16 bytes)
                        1 << 2    |  //Synchronization mode
                        0 << 1    |
                        0 );

    //receive parameter configuration
    DMA3_CH1_SRC_LSW = 0x6000;
//    DMA3_CH1_SRC_MSW = 0x6001;
    DMA3_CH1_DST_LSW =(unsigned int)( &rxtemp[0]);
    DMA3_CH1_DST_MSW = 0;
    DMA3_CH1_TC_LSW = 0x0400;
    DMA3_CH1_TC_MSW = ( 0 << 15   |  // Channel enable
                        1 << 14   |  // Channel status
                        1 << 13   | // CPU interrupt enable
                        1 << 12   | //Automatic reload
                        0 << 8    |  // Destination addressing mode Constant address
                        2 << 6    |  //Source addressing mode  Automatic post increment
                        0 << 3    | //1 double words (16 bytes)
                        1 << 2    |  //Synchronization mode
                        0 << 1    |
                        0 );

    DMA3_CH1_TC_MSW |= 0x8000;//  DMA starts

}
///* ------------------------------------------------------------------------ *
// *                                                                          *
// *  Initialize MCBSP                                                        *
// *                                                                          *
// * ------------------------------------------------------------------------ */
void C5517_MCBSP_INIT()
{
//   unsigned short i;
//    for (i=0; i< 500; i++);    //!!!!!!!

    MCBSP_SPCRU = 0x0000;
    MCBSP_SPCRL = 0x0000;

    //program the control registers
    MCBSP_PCRL = (1 <<11 |  //FSXM FS is determined by FSGM in SRGR
                  1 <<10 |   // FSRM  FS is generated internally, FSR is
                  1 << 9 |   // CLKXM is output pin driven by internal
                  1 << 8 |   // CLKRM CLKR is output driven by internal
                  0 << 7 |   // SCLKME  internal clock     CLKSM=1 Input Clock for Sample Rate Generator is McBSP internal input clock
                  0 << 3 |   // FSXP    TX FS is active high
                  0 << 2 |   // FSRP    RX FS in active high
                  0 << 1 |   // CLKXP  TX data driven on rising edge of CLKX
                  0 );       // CLKRP  RX data driven on falling edge of CLKR

//    MCBSP_SPCRL |= (1 << 15); //loop ģʽ

    MCBSP_SRGRL = ( 0 << 8  |  149<< 0 );   //the McBSP internal input clock frequency is the same as the CPU frequency.
    MCBSP_SRGRU = (0 << 15 |  // sample rate generator clock is free running
                   0 << 14 |  //Rising edge CLKS generates CLKG and FSG
                   1 << 13 |  // smaple rate generator clock taken from internal
                   1 << 12 |  // FSX is driven by FSG.
                   31<< 0 );   // Frame period value +1, 2 phase *16 bit.

    MCBSP_RCRL = (0 << 8   |  // 1 word in phase 1
                  2 << 5   |  //16 bit word in phase 1
                  0 << 4   |  // no reversal
                  0   );
    MCBSP_RCRU = (1 << 15  | // dual-phase frame
                  0 << 8  |  //1 word in phase 2
                  2 << 5  |  // 16 bit word in phase 2
                  0 << 3  |  // No companding
                  1 << 2  |  // Ignor extra fs pulse
                  0 << 0  );   // 0-bit delay

    MCBSP_XCRL = (0 << 8   |  // 1 word in phase 1
                  2 << 5   |  //16 bit word in phase 1
                  0 << 4   |  // no reversal
                  0   );
    MCBSP_XCRU = (1 << 15  | // dual-phase frame
                  0 << 8  |  //1 word in phase 2
                  2 << 5  |  // 16 bit word in phase 2
                  0 << 3  |  // No companding
                  1 << 2  |  // Ignor extra fs pulse
                  0 << 0  );   // 0-bit delay

    delay (100);
    MCBSP_SPCRU |= (1 << 6); // Enable GRST
    delay (100);
    MCBSP_SPCRU |= (1 << 0); //Enabel XRST
    delay(100);
    MCBSP_SPCRU &= ~(1 << 0); //Disable XRST
    MCBSP_SPCRU |=  (1 << 0 ); //Enable RRST, XRST
    MCBSP_SPCRL |=  (1 << 0 );
    MCBSP_SPCRU |=  (1 << 7 );  //Enable FRST
}

//unsigned int temp=1;
static volatile unsigned int nxtBufToRcv = 1;
static volatile unsigned int nxtBufToTx = 1;
int main(void)
{
//    unsigned int i=0;
    InitSystem();
    C5517_MCBSP_INIT();
    C5517_DMA_INIT();
//    IER0 = 0x0100;
//
    IRQ_globalDisable();
    IRQ_clearAll();
    IRQ_disableAll();
    IRQ_setVecs((Uint32)&VECSTART);
    IRQ_clear(8);
    IRQ_plug (8, &DMA_Isr);
    IRQ_enable(8);
    IRQ_globalEnable();
//
    while(1)
    {

    }
//	return 0;
}

interrupt void DMA_Isr(void)
{
	unsigned short temp;//, dma_start;

//    temp = IFR0;
//    IFR0 = temp;

    temp = DMA_IFR;
//    DMA_IFR = temp;     // clear interrupt flags

    if(temp&0x1000)
    {
        // DMA3 Tr interrupt (channel 0)
//        if(CurrentTxT_DMAChannel ==1)
//        {
//            CurrentTxT_DMAChannel =2;
            DMA3_CH0_SRC_LSW = (unsigned int) (& temptx[(nxtBufToTx % 10)*1024]);
            DMA3_CH0_SRC_MSW = 0;
//        }
//        else
//        {
//            CurrentTxT_DMAChannel =1;
//            DMA3_CH0_SRC_LSW = (unsigned int) (& temptx[2048]);
//            DMA3_CH0_SRC_MSW = 0;
//        }
        DMA_IFR = 0x1000;     // clear interrupt flags
        nxtBufToTx++;
    }
    else if(temp&0x2000)
    {
        // DMA3 Rc interrupt (channel 1)
//        if(CurrentTxR_DMAChannel ==1)
//        {
//            CurrentTxR_DMAChannel =2;
            DMA3_CH1_DST_LSW = (unsigned int)(& rxtemp[(nxtBufToRcv % 10)*1024]);
            DMA3_CH1_DST_MSW = 0;
//        }
//        else
//        {
//            CurrentTxR_DMAChannel =1;
//            DMA3_CH1_DST_LSW = (unsigned int)( &rxtemp[2048]);
//            DMA3_CH1_DST_MSW = 0;
//        }
        DMA_IFR = 0x2000;     // clear interrupt flags
        nxtBufToRcv++;
    }
}

