/*
 * Copyright (C) 2008 Sekhar Nori, Texas Instruments, Inc <www.ti.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
 
#include "spi_flash_internal.h"
 
/* ------------------------------------------------------------------------ *
 *  Device System Controller                                                *
 * ------------------------------------------------------------------------ */
#define SYS_BASE                0x01c14000
#define SYS_KICK0				*( volatile Uint32* )( SYS_BASE + 0x38 )
#define SYS_PINMUX0             *( volatile Uint32* )( SYS_BASE + 0x120 )
#define SYS_PINMUX1             *( volatile Uint32* )( SYS_BASE + 0x124 )
#define SYS_PINMUX2             *( volatile Uint32* )( SYS_BASE + 0x128 )
#define SYS_PINMUX3             *( volatile Uint32* )( SYS_BASE + 0x12c )
#define SYS_PINMUX4             *( volatile Uint32* )( SYS_BASE + 0x130 )
#define SYS_PINMUX5             *( volatile Uint32* )( SYS_BASE + 0x134 )
#define SYS_PINMUX6             *( volatile Uint32* )( SYS_BASE + 0x138 )
#define SYS_PINMUX7             *( volatile Uint32* )( SYS_BASE + 0x13c )
#define SYS_PINMUX8             *( volatile Uint32* )( SYS_BASE + 0x140 )
#define SYS_PINMUX9             *( volatile Uint32* )( SYS_BASE + 0x144 )
#define SYS_PINMUX10            *( volatile Uint32* )( SYS_BASE + 0x148 )
#define SYS_PINMUX11            *( volatile Uint32* )( SYS_BASE + 0x14c )
#define SYS_PINMUX12            *( volatile Uint32* )( SYS_BASE + 0x150 )
#define SYS_PINMUX13            *( volatile Uint32* )( SYS_BASE + 0x154 )
#define SYS_PINMUX14            *( volatile Uint32* )( SYS_BASE + 0x158 )
#define SYS_PINMUX15            *( volatile Uint32* )( SYS_BASE + 0x15c )
#define SYS_PINMUX16            *( volatile Uint32* )( SYS_BASE + 0x160 )
#define SYS_PINMUX17            *( volatile Uint32* )( SYS_BASE + 0x164 )
#define SYS_PINMUX18            *( volatile Uint32* )( SYS_BASE + 0x168 )
#define SYS_PINMUX19            *( volatile Uint32* )( SYS_BASE + 0x16c )
#define SYS_CFGCHIP0			*( volatile Uint32* )( SYS_BASE + 0x17c )

/* ------------------------------------------------------------------------ *
 *  SPI Controller                                                          *
 * ------------------------------------------------------------------------ */
#define SPI_BASE                0x01c41000
#define SPI_SPIGCR0             *( volatile Uint32* )( SPI_BASE + 0x0 )
#define SPI_SPIGCR1             *( volatile Uint32* )( SPI_BASE + 0x4 )
#define SPI_SPIINT              *( volatile Uint32* )( SPI_BASE + 0x8 )
#define SPI_SPILVL              *( volatile Uint32* )( SPI_BASE + 0xc )
#define SPI_SPIFLG              *( volatile Uint32* )( SPI_BASE + 0x10 )
#define SPI_SPIPC0              *( volatile Uint32* )( SPI_BASE + 0x14 )
#define SPI_SPIPC2              *( volatile Uint32* )( SPI_BASE + 0x1c )
#define SPI_SPIDAT1_TOP         *( volatile Uint16* )( SPI_BASE + 0x3c )
#define SPI_SPIDAT1             *( volatile Uint32* )( SPI_BASE + 0x3c )
#define SPI_SPIDAT1_PTR16       *( volatile Uint16* )( SPI_BASE + 0x3e )
#define SPI_SPIDAT1_PTR8        *( volatile Uint8* ) ( SPI_BASE + 0x3f )
#define SPI_SPIBUF              *( volatile Uint32* )( SPI_BASE + 0x40 )
#define SPI_SPIBUF_PTR16        *( volatile Uint16* )( SPI_BASE + 0x42 )
#define SPI_SPIBUF_PTR8         *( volatile Uint8* ) ( SPI_BASE + 0x43 )
#define SPI_SPIEMU              *( volatile Uint32* )( SPI_BASE + 0x44 )
#define SPI_SPIDELAY            *( volatile Uint32* )( SPI_BASE + 0x48 )
#define SPI_SPIDEF              *( volatile Uint32* )( SPI_BASE + 0x4c )
#define SPI_SPIFMT0             *( volatile Uint32* )( SPI_BASE + 0x50 )
#define SPI_SPIFMT1             *( volatile Uint32* )( SPI_BASE + 0x54 )
#define SPI_SPIFMT2             *( volatile Uint32* )( SPI_BASE + 0x58 )
#define SPI_SPIFMT3             *( volatile Uint32* )( SPI_BASE + 0x5c )
#define SPI_INTVEC0             *( volatile Uint32* )( SPI_BASE + 0x60 )
#define SPI_INTVEC1             *( volatile Uint32* )( SPI_BASE + 0x64 )
