/*
 * SPI flash internal definitions
 *
 * Copyright (C) 2008 Atmel Corporation
 */

/* ------------------------------------------------------------------------ *
 *  Variable types                                                          *
 * ------------------------------------------------------------------------ */
#define Uint32  unsigned int
#define Uint16  unsigned short
#define Uint8   unsigned char
#define Int32   int
#define Int16   short
#define Int8    char

/* Common parameters */
#define	CFG_HZ							1000
#define SPI_FLASH_PROG_TIMEOUT			((100000 * CFG_HZ) / 1000)
#define SPI_FLASH_PAGE_ERASE_TIMEOUT	((500000 * CFG_HZ) / 1000)
#define SPI_FLASH_SECTOR_ERASE_TIMEOUT	(100000 * CFG_HZ)

/* Common commands */
#define CMD_READ_ID				0x9f

#define CMD_READ_ARRAY_SLOW		0x03
#define CMD_READ_ARRAY_FAST		0x0b
#define CMD_READ_ARRAY_LEGACY	0xe8

