/*
 * Copyright (C) 2008 Texas Instruments, Inc <www.ti.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <stdio.h>
#include "davinci_spi.h"

static Uint8 tx[512];
static Uint8 rx[512];
struct spi_slave *slave;
struct spi_flash *win_flash;

#define MAX_IMAGE_SIZE 16384
#define E_PASS 0
#define E_FAIL -1


typedef struct _SPIBOOT_HEADER_
{
	Uint32		magicNum;
	Uint32		entryPoint;	
	Uint32		appSize;
	Uint32		ldAddress;	/* Starting RAM address where image is to copied - XIP Mode */
}
SPIBOOT_HeaderObj;

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  main( )                                               		            *
 *      write to SPI flash and then verify the contents 					*
 *                                                                          *
 * ------------------------------------------------------------------------ */
Int32 main( )
{
    Int16 i;
    Uint8* p8;

    Uint16 page_size;

	FILE	*fPtr;
   	Int32	fileSize = 0;
	Int32   no_of_pages;  
	Int32   no_of_sectors;
	Int32	offset = -1;
	Int8	fileName[256], itype[20];
	Uint8 	idcode[3];
	Uint32	ret;
	struct winbond_spi_flash *sf = NULL;
	unsigned long sector_size;
	SPIBOOT_HeaderObj header = {
								0xA1ACED00,
								0xc1080000,
								0,
								0xc1080000
						};
	int write_header = 0;

	/* Initialize the SPI interface */
	slave = (struct spi_slave *)spi_setup_slave(0, 0, 25*1024*1024, 0);
	spi_claim_bus(slave);

	/* Read the ID codes */
	ret = spi_flash_cmd(slave, CMD_READ_ID, &idcode, sizeof(idcode));
	if (ret) {
		printf ( "SF: Error in reading the idcode\n");
		exit (1);
	}

	printf("SF: Got idcode %02x %02x %02x\n", idcode[0],
			idcode[1], idcode[2]);
	win_flash = (struct spi_flash *)spi_flash_probe_winbond (slave, idcode);

	if (win_flash == NULL) {
		printf ("Serial Flash not detected\n");
		exit (2);
	}

	sf = to_winbond_spi_flash(win_flash);
	page_size = sf->params->page_size;
	sector_size = sf->params->page_size * sf->params->pages_per_sector;

	printf("Flash page size: %d bytes\n", page_size);
	printf("Flash sector size: %d bytes\n", sector_size);

	printf( "Starting SPIWriter.\r\n");

#ifdef __CCSv4_BUILD__
    fPtr = fopen("C:\\spiwriter.dat", "r");
    if(!fPtr) {
      printf("\tERROR: File C:\\spiwriter.dat open failed.\n"
      	"Please create a file by this name containing the path to the"
		" AIS binary to be flashed\n");
      return E_FAIL;    	
    }
    fscanf(fPtr, "%s", fileName);
	printf("Input file: %s\n", fileName);
	fscanf(fPtr, "%d", &offset);
	printf("Flash offset in bytes (decimal): %d\n", offset);
	fclose(fPtr);    
#else
	printf("Enter the image type (one of \"dspais\" \"armubl\" \"uboot\" \"other\")\n");
	scanf("%s", itype);
	if(!strcmp(itype, "dspais")) 
		offset = 0;
	else if(!strcmp(itype, "armubl"))
		offset = 8*1024;
	else if(!strcmp(itype, "uboot")) {
		offset = 32*1024;
		write_header = 1;
	}

  	// Read the file from host
	printf("Enter the File Name\n");
	scanf("%s", fileName);
	fflush(stdin);

	// Read the offset from user
	if(offset == -1) {
		printf("Enter the Offset in bytes (decimal)\n");
		scanf("%d", &offset);
		fflush(stdin);
	}
#endif

	// Open an File from the hard drive
	fPtr = fopen(fileName, "rb");
	if(fPtr == NULL)
	{
		printf("File %s Open failed\n", fileName);
		return E_FAIL;
	}

	// Initialize the pointer
	fileSize = 0;

	// Read file size
	fseek(fPtr,0,SEEK_END);
	fileSize = ftell(fPtr);

	if(fileSize == 0)
	{
		printf("File read failed.. Closing APP\n");
		fclose (fPtr);
		return E_FAIL;
	}

	if(write_header) {
		header.appSize = fileSize;
		fileSize += sizeof(header);
	}

	fseek(fPtr,0,SEEK_SET);

	no_of_pages = fileSize/page_size + ((fileSize % page_size) ? 1 : 0);
	no_of_sectors = (fileSize/sector_size + ((fileSize % page_size) ? 1 : 0));

	/* Erase the Serial Flash */
	printf("Erasing flash at byte offset: %d, byte length: %d\n", (offset/sector_size)*sector_size, no_of_sectors*sector_size);
	win_flash->erase (win_flash, (offset/sector_size)*sector_size, no_of_sectors*sector_size);

    /* Write 1 page at a time */
	printf("Writing flash at page offset: %d, number of pages: %d\n", (offset/page_size), no_of_pages);
	
	i = (offset/page_size);

	if(write_header) {
		p8 = (Uint8*) tx;
		memcpy(p8, (Uint8*) &header, sizeof(header));
		p8 += sizeof(header);
	   	fread(p8, 1, page_size - sizeof(header), fPtr);
		win_flash->write (win_flash, i * page_size, page_size, ( Uint8 *)tx);		
		i++;
	}

    while(!feof(fPtr))
    {
		p8 = (Uint8*) tx;
	   	if(!feof(fPtr)) {
	   		fread(p8, 1, page_size, fPtr);
		}
		win_flash->write (win_flash, i * page_size, page_size, ( Uint8 *)tx);
		i++;
    }

	fseek(fPtr,0,SEEK_SET);

	printf("Reading verifying the file.. ");
	fflush(stdout);

	i = (offset/page_size);

	if(write_header) {
	   	fread(tx, 1, page_size - sizeof(header), fPtr);
		tx[page_size - sizeof(header)] = '\0';

		win_flash->read (win_flash, i * page_size, page_size, (Uint8 *)rx);
        rx[page_size] = '\0'; 
		if(strcmp(rx + sizeof(header),tx)!= 0)
			printf("Files did not match @ %d\n", i);
		i++;
	}

    while(!feof(fPtr))
    {
		unsigned int nbytes;

	   	if(!feof(fPtr)) {
			nbytes = fread(tx, 1, page_size, fPtr);
		}		
		tx[nbytes] = '\0';

		win_flash->read (win_flash, i * page_size, page_size, (Uint8 *)rx);
        rx[nbytes] = '\0'; 
		if(strcmp(rx,tx)!= 0) {
			printf("Files did not match @ %d\n", ftell(fPtr));
			goto finish;
		}
		i++;
    }

	printf("Files matched \n");

finish:
	fclose(fPtr);
    return 0;
}
