/*
 * 12864.c
 *
 *  Created on: 2016719
 *      Author: obama
 */
#include "msp432.h"
#include "12864.h"
#include "stdlib.h"


/*12864Ӧָ*/
#define CLEAR_SCREEN        0x01                    //ָACֵΪ00H
#define AC_INIT             0x02                    //ACΪ00HαƵԭλ
#define CURSE_ADD           0x06                    //趨αƵͼƶĬαƣͼ岻
#define FUN_MODE            0x30                    //ģʽ8λָ
#define DISPLAY_ON          0x0c                    //ʾ,ʾα꣬αλ÷
#define DISPLAY_OFF         0x08                    //ʾ
#define CURSE_DIR           0x14                    //αƶ:AC=AC+1
#define SET_CG_AC           0x40                    //ACΧΪ00H~3FH
//#define SET_DD_AC           0x80

#define LCD_Data_IN     P9IN           //RUݿ
#define LCD_Data_OUT    P9OUT            //ݿ

#define RS_CLR        P10OUT &=~BIT1       //RSõ
#define RS_SET        P10OUT |=BIT1        //RSø

#define RW_CLR         P10OUT &=~BIT3      //RWõ
#define RW_SET         P10OUT |=BIT3         //RWø

#define EN_CLR        P10OUT &=~BIT5        //Eõ
#define EN_SET        P10OUT |=BIT5          //Eø

//#define LCD_RST          P8DIR  |=0x01
#define Busy 0x80


void Port_init()
{
        P9DIR =0xFF;
        P10DIR|= BIT1+ BIT3 + BIT5;
        P1DIR |=BIT0;
}


void LocateXY(uint x,uint y)
{
  uchar pos;
  if(x==0)              //1
    x=0x80;
  else if(x==1)         //2
    x=0x90;
  else if(x==2)         //3
    x=0x88;
  else if(x==3)         //4
    x=0x98;
  pos=x+y;
  Lcd_WriteCMD(pos);    //дַ
}

void LCD_disp1aydat(uchar x,uchar y,uchar data)
{
    LocateXY( x, y);
    LCD_writedata(data);
}

void wr_string(uint16_t y0,uint16_t x,uchar *p)
{
  uchar pos=0;//ʼ
  uchar cnt=0;//ݹָ cntΪƫȻһַһַд롣
  switch(y0)
  {
  case 0: pos=0x80+x;break;
  case 1: pos=0x90+x;break;
  case 2: pos=0x88+x;break;
  case 3: pos=0x98+x;break;
  default: break;
  }
  Lcd_WriteCMD(pos);//дַ
  while(*(p+cnt)!='\0')
  {
	  LCD_writedata(*(p+cnt));//д
    cnt++;
  };
}

void Lcd_Init(void)
{
        Port_init();
        Lcd_WriteCMD(FUN_MODE);                        //ʾģʽ
        Delay5ms();
        Lcd_WriteCMD(FUN_MODE);                        //ʾģʽ
        Delay5ms();
        Lcd_WriteCMD(DISPLAY_ON);                        //ʾ
        Delay5ms();
        Lcd_WriteCMD(CLEAR_SCREEN);                        //
        Delay5ms();
}


//void LCD_Wait(void) //æ״̬
//{
//    int a;
//    P9DIR =0x00;
//    while(1)
//    {
//        EN_CLR;
//        RS_CLR;
//        RW_SET;
//        Delay5ms();
//        EN_SET;
//        Delay5ms();
//        Delay5ms();
//        EN_CLR;
//        a=LCD_Data_IN;
//        P9DIR =0xFF;
//        if((LCD_Data_IN&Busy)==0)
//        break;
//    }
//}

void wr_int(uint16_t y0,uint16_t x,uint16_t NUM)  //ʾ
{
    uchar a_SHOW[5];

    a_SHOW[0]=(NUM/1000)+'0';//qian   //ֻʾݵ4λ
    a_SHOW[1]=(NUM/100%10)+'0' ;//bai
    a_SHOW[2]=(NUM/10%10)+'0';//shi
    a_SHOW[3]=NUM%10+'0';//ge
    a_SHOW[4]='\0';   //ַļ־
    wr_string(y0,x,a_SHOW);
}
    /*********************************************************************************************
    8ʾ
      ãwr_float(uchar y0,uchar x,float NUM)
      uchar x,uchar y0,float NUM
    ֵ
      
      ע
    **********************************************************************************************/
//    void wr_float(uchar y0,uchar x,float NUM) //8ʾ
//    {
//        uchar a_SHOW[7];
//        long int  t;
//        t=(int)(NUM*1000);     //ȳ1000ٰʽʾʽֻΪxx.xxxԾֻܵСλ
//        a_SHOW[0]=(t/10000)+'0';//shi
//        a_SHOW[1]=(t/1000%10)+'0' ;//ge
//        a_SHOW[2]='.';               //
//        a_SHOW[3]=(t/100%10)+'0';//shi fen
//        a_SHOW[4]=(t/10%10)+'0'; //bai fen
//        a_SHOW[5]=t%10+'0';      //qian fen
//
//        a_SHOW[6]='\0';
//        wr_string(y0,x,a_SHOW);
//    }
//


void Lcd_WriteCMD(uchar cmd)
{
//    LCD_Wait();   // æź?

        RS_CLR;
        RW_CLR;
        EN_CLR;
        EN_SET;
        P9OUT = cmd;
        Delay5ms();
        EN_CLR;

}

void LCD_writedata (uchar data)
{
//    LCD_Wait();        //ȴҺæ

        RS_SET;
        RW_CLR;
        EN_CLR;
        EN_SET;
        P9OUT = data;
        Delay5ms();
        EN_CLR;

}

void LCD_clear(void)
{
        Lcd_WriteCMD(0x01);
        Delay5ms();
}

//***********************************************************************
//ƣDisplayCgrom(uchar hz)ʾCGROMĺ
//***********************************************************************
void DisplayCgrom(uchar addr,uchar *hz)
{
        Lcd_WriteCMD(addr);
        Delay5ms();
        while(*hz != '\0')
        {
                LCD_writedata(*hz);
                hz++;
                 Delay5ms();
        }

}
//****************************************************************
//ƣDisplay()ʾԽ
//****************************************************************
void Display(void)
{
        DisplayCgrom(0x80,"SUSTС  ");
        DisplayCgrom(0x90,"ֱӸ");
        DisplayCgrom(0x88,"V1:");
        DisplayCgrom(0x98,"I1:");
}


void Delay5ms(void)
{
    uint i=5;
    while (i != 0)
    {
        i--;
    }
}




