/*
 * adc.c
 *
 *  Created on: 2016719
 *      Author: obama
 */

#include "msp.h"
#include <stdint.h>

volatile uint16_t ADCvar;

int adc_getvalue(void)
{
    // Configure GPIO
    P5SEL1 |= BIT5 | BIT6;                             // Enable A/D channel A0
    P5SEL0 |= BIT5 | BIT6;

    // Configure ADC14
       ADC14->CTL0 = ADC14_CTL0_ON | ADC14_CTL0_SHP| ADC14_CTL0_SHT0_2;// Turn on ADC14, set sampling time
       ADC14->CTL1 = ADC14_CTL1_RES_2;                     // Use sampling timer, 12-bit conversion results
       ADC14->MCTL[0] = ADC14_MCTLN_VRSEL_14 | ADC14_MCTLN_INCH_0;   // Vr+ = VeREF+ (ext) and Vr-=AVss, A0
       ADC14->CTL0 |= ADC14_CTL0_ENC;                      // Enable conversions

         ADC14->CTL0 |= ADC14_CTL0_SC;                     // Start conversion-software trigger
         while (!(ADC14->IFGR0 & BIT0));
         ADCvar = ADC14->MEM[0];                       // Read conversion result
         __no_operation();                         // SET BREAKPOINT HERE
         return ADCvar;

}



