/*****************************************************************************
*
* Copyright (C) 2013 - 2016 Texas Instruments Incorporated - http://www.ti.com/
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* * Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* * Redistributions in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in the
*   documentation and/or other materials provided with the
*   distribution.
*
* * Neither the name of Texas Instruments Incorporated nor the names of
*   its contributors may be used to endorse or promote products derived
*   from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************
*
* MSP432 blink.c template - P1.0 port toggle
*
* Classic coding
*
****************************************************************************/

#include "msp.h"
#include "12864.h"
#include "dac.h"
#include "adc.h"

void main(void)
{
    volatile uint32_t i;
    volatile uint16_t adcx=2048;
    volatile float temp;
    WDTCTL = WDTPW | WDTHOLD;                    /* Stop watchdog timer */

    // The following code toggles P1.0 port
    P1DIR |= BIT0;                               /* Configure P1.0 as output */
    Lcd_Init();
    LCD_clear();
    InitDAC();
    write_da7811(0x0666);
    while(1)
    {

//    	adcx=adc_getvalue();
    	temp=(float)adcx*(2.5/4096);
    	adcx=temp;
    	temp-=adcx;
    	wr_int(2,3,adcx);
    	wr_float(3,3,temp);
    	__no_operation();
        Display();
        P1OUT ^= BIT0;                           /* Toggle P1.0 */
    }
}
