/*sdq.h*/

/*******************************************************************************/
/*This file declares the functions necessary to implement SDQ communication.   */
/*The code is written specifically for STR912 microcontroller using Port 9.3   */
/*as a push pull port. A 5k pullup resistor was used at 3.3V pullup voltage.   */
/* It is used along with the sdq.c file.                                       */
/*                                                                             */
/*Written by: Michael Vega                                                     */
/*            Applications, Battery Monitor Solutions	                       */
/*            Texas Instruments, Inc.                                          */
/*******************************************************************************/

#define RTC_TR (unsigned int *)(0x5C00B000)


void wait_us(int value);
void SendReset(void);
unsigned char TestPresence(void);
void WriteOneBit(unsigned char OneZero);
void WriteOneByte(unsigned char Data2Send);
unsigned char ReadOneBit(void);
unsigned char ReadOneByte(void);
