
//IIC˿ڶ
#include "TI_USCI_I2C_master.c"
#include "bq30z55.h"                                // Device-specific header
#define ATRATE_MA            -100           // USER CONFIG: AtRate setting (mA)
#define I2CSLAVEADDR         0x16>>1           // 7-bit slave address
#define BUFFERSIZE             32           // # of bytes for Tx & Rx buffers




unsigned char TxData[BUFFERSIZE];           // Stores data bytes to be TX'd
unsigned char RxData[BUFFERSIZE];           // Stores data bytes that are RX'd
unsigned int  temperature;                  // Stores temperature
unsigned int  voltage;                      // Stores voltage
  signed int  atrate;                       // Stores AtRate
unsigned int  artte;                        // Stores AtRate Time to Empty
unsigned int  soc;                          // Stores State of Charge
unsigned int  dcap;                         // Stores Design Capacity
unsigned int  dnamelen;                     // Stores Device Name Length

unsigned int transBytes2UnsignedInt(unsigned char msb, unsigned char lsb);
void MSP430_bq30z55_read(unsigned char cmd, unsigned int bytes);
void MSP430_bq30z55_cmdWrite(unsigned char cmd, unsigned char data);
void MSP430_bq30z55_blockWrite(unsigned char *buffer, unsigned int length);
void MSP430_bq30z55_error(void);



unsigned int transBytes2UnsignedInt(unsigned char msb, unsigned char lsb)
{
  unsigned int tmp;
  
  tmp = ((msb << 8) & 0xFF00);
  return ((unsigned int)(tmp + lsb) & 0x0000FFFF);  
}

void MSP430_bq30z55_read(unsigned char cmd, unsigned int bytes)
{
  unsigned char tx[1];
  RxData[0]=0X16;
  RxData[1]=cmd;
  RxData[2]=0x17;
  tx[0] = cmd;
  TI_USCI_I2CWrite(I2CSLAVEADDR, 1, 1, tx);
  TI_USCI_I2CRead( I2CSLAVEADDR, bytes, 0, &RxData[3]); 
}

void MSP430_bq30z55_cmdWrite(unsigned char cmd, unsigned char data)
{
  unsigned char tx[2];
  
  tx[0] = cmd;
  tx[1] = data;

  TI_USCI_I2CWrite(I2CSLAVEADDR, 2, 0, tx);
  __delay_cycles(50000);
}

void MSP430_bq30z55_blockWrite(unsigned char *buffer, unsigned int length)
{
  TI_USCI_I2CWrite(I2CSLAVEADDR, length, 0, buffer);
  __delay_cycles(50000);
}

void MSP430_bq30z55_error(void)
{
  while (1)                                 // Loop forever
  {
    P1OUT ^= BIT0;                          // Toggle LED
    __delay_cycles(50000);                  // Delay
  }
}