// SHA1Module.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "windows.h"
#include "windef.h"
#include "stdio.h"
#include "winbase.h"

unsigned int ROTL(unsigned int a, unsigned int n)
{
	unsigned int BitSize = (sizeof(unsigned int) * 8);
	n = n % BitSize;
	unsigned int Temp = a >> (BitSize - n);
	unsigned int Temp1 = a << n;
	return (Temp1 | Temp);
}

unsigned int func(unsigned int b, unsigned int c, unsigned int d, unsigned int i)
{
	if ( i >=0 && i <= 19)
	{
		return ((b & c) ^ (~b & d));
	}

	if ( i >= 20 && i <= 39)
	{
		return (b ^ c ^ d);
	}

	if ( i >= 40 && i <= 59)
	{
		return ((b & c) ^ (b & d) ^ (c & d));
	}


	if ( i >= 60 && i <= 79)
	{
		return (b ^ c ^ d);
	}

	return 0;
}

void SHA1(unsigned int Message[5], unsigned int Key[4])
{
	unsigned int Pad[7], Hash[5], K[80], Word[80], i, Temp, a, b, c, d, e;
	Word[0] = Key[0];
	Word[1] = Key[1];
	Word[2] = Key[2];
	Word[3] = Key[3];
	Word[4] = Message[0];
	Word[5] = Message[1];
	Word[6] = Message[2];
	Word[7] = Message[3];
	Word[8] = Message[4];
	Word[9] = Pad[0] = 0x80000000;
	Word[10] = Pad[1] = 0x00000000;
	Word[11] = Pad[2] = 0x00000000;
	Word[12] = Pad[3] = 0x00000000;
	Word[13] = Pad[4] = 0x00000000;
	Word[14] = Pad[5] = 0x00000000;
	Word[15] = Pad[6] = 0x00000120;
	Hash[0] = a = 0x67452301;
	Hash[1] = b = 0xEFCDAB89;
	Hash[2] = c = 0x98BADCFE;
	Hash[3] = d = 0x10325476;
	Hash[4] = e = 0xC3D2E1F0;

	for(i = 16; i < 80; i++)
	{
		Word[i] = ROTL(Word[i - 3] ^ Word[i - 8] ^ Word[i - 14] ^ Word[i - 16], 1);
	}

	for(i = 0; i < 20; i++)
	{
		K[i] = 0x5A827999;
		K[20 + i] = 0x6ED9EBA1;
		K[40 + i] = 0x8F1BBCDC;
		K[60 + i] = 0xCA62C1D6;
	}

	for(i = 0; i < 80; i++)
	{
		Temp = ROTL(a, 5) + func(b, c, d, i) + e + K[i] + Word[i];
		e = d;
		d = c;
		c = ROTL(b, 30);
		b = a;
		a = Temp;
	}
	
	Message[0] = a + Hash[0];
	Message[1] = b + Hash[1];
	Message[2] = c + Hash[2];
	Message[3] = d + Hash[3];
	Message[4] = e + Hash[4];

}

int main(int argc, char* argv[])
{
//	LARGE_INTEGER SystemFrequency;
//	LARGE_INTEGER PerformanceCount1, PerformanceCount2;
	float TimeCost = 0;
	printf("Welcome to SHA1 Demonstrating Programm\n");
	unsigned int Key[4], Message[5];
	Key[0] = 0x00000000;
	Key[1] = 0x00000000;
	Key[2] = 0x00000000;
	Key[3] = 0x00000000;
	Message[0] = 0xC82CA3CA;
	Message[1] = 0x10DEC726;
	Message[2] = 0x8E070A7C;
	Message[3] = 0xF0D1FE82;
	Message[4] = 0x20AAD3B8;

// QueryPerformanceFrequency(&SystemFrequency);
//	QueryPerformanceCounter(&PerformanceCount1);
	SHA1(Message, Key);
	SHA1(Message, Key);
//	QueryPerformanceCounter(&PerformanceCount2);
//	TimeCost = (float)(PerformanceCount2.QuadPart - PerformanceCount1.QuadPart)/(float)(SystemFrequency.QuadPart);
	printf("The digest is %08X%08X%08X%08X%08X", Message[0], Message[1], Message[2], Message[3], Message[4]);
	printf("\nThe time cost is %10.9f", TimeCost);
//	getchar();
	
	return 0;
}
