
#include <msp430.h>

#define PxSEL P1SEL                         // Port selection
#define PxDIR P1DIR                         // Port direction
#define PxOUT P1OUT                         // Port output
#define PxIN  P1IN                          // Port input

#define SDA   BIT7                          // Controls SDA line
#define SCL   BIT6                          // Controls SCL line

#define MSP430CLOCKFREQHZ 1000000           // USER CONFIG: Sys Freq
#define I2CDELAYUSEC         2500           // USER CONFIG: GPIO change delay
#define GPIODELAYCYCLES ((MSP430CLOCKFREQHZ/1000000)*I2CDELAYUSEC)

#define I2CDELAY MSP430_SWI2CMST_delay()    // Macro for GPIO change delay
#define SDA_1 PxDIR&=~(SDA)                 // Set to input [SDA = 1 via pullup]
#define SDA_0 PxDIR|=(SDA)                  // Set to output [SDA = 0]
#define SCL_1 PxDIR&=~(SCL)                 // Set to input [SCL = 1 via pullup]
#define SCL_0 PxDIR|=(SCL)                  // Set to output [SCL = 0]

#define NACK 0
#define ACK  1

void MSP430_SWI2CMST_init(void);

void MSP430_SWI2CMST_delay(void);

void MSP430_SWI2CMST_start(void);

void MSP430_SWI2CMST_stop(void);

unsigned char MSP430_SWI2CMST_txByte(unsigned char data);

unsigned char MSP430_SWI2CMST_rxByte(char ack);

void MSP430_SWI2CMST_writeBlock(unsigned char SlaveAddress,
                                unsigned int numBytes,
                                unsigned char multi, void* TxData);

void MSP430_SWI2CMST_readBlock(unsigned char SlaveAddress,
                               unsigned int numBytes, void* RxData);
