#include"bq27421.h"
extern unsigned char TxData[BUFFERSIZE];
extern unsigned char RxData[BUFFERSIZE];

unsigned int transBytes2UnsignedInt(unsigned char msb, unsigned char lsb)
{
  unsigned int tmp;

  tmp = ((msb << 8) & 0xFF00);
  return ((unsigned int)(tmp + lsb) & 0x0000FFFF);
}

void MSP430_bq27421_read(unsigned char cmd, unsigned int bytes)
{
  unsigned char tx[1];

  tx[0] = cmd;

  MSP430_SWI2CMST_writeBlock(I2CSLAVEADDR, 1, 1, tx);
  MSP430_SWI2CMST_readBlock(I2CSLAVEADDR, bytes, RxData);
}

void MSP430_bq27421_cmdWrite(unsigned char cmd, unsigned char data)
{
  unsigned char tx[2];

  tx[0] = cmd;
  tx[1] = data;

  MSP430_SWI2CMST_writeBlock(I2CSLAVEADDR, 2, 0, tx);
  __delay_cycles(50000);
}

void MSP430_bq27421_blockWrite(unsigned char *buffer, unsigned int length)
{

  MSP430_SWI2CMST_writeBlock(I2CSLAVEADDR, length, 0, buffer);
  __delay_cycles(50000);
}

void MSP430_bq27421_error(void)
{
  while (1)                                 // Loop forever
  {
    __delay_cycles(50000);                  // Delay
  }
}
