#include "Cyclone_Device.h"     // UCD30xx Headers Include File
#include "software_interrupts.h"
#include "system_defines.h"

void init_adc12(void)
{
	MiscAnalogRegs.TEMPSENCTRL.bit.TEMP_SENSE_DIS = 0;

	AdcRegs.ADCCTRL.bit.MAX_CONV = 8; //Set up to measure 8 different items

    AdcRegs.ADCCTRL.bit.SINGLE_SWEEP = 1; //Use single sweep mode

	AdcRegs.ADCSEQSEL0.bit.SEQ0  = 2; 	//VO_SENSE_1
	AdcRegs.ADCSEQSEL0.bit.SEQ1  = 13;	//IO_SENSE
	AdcRegs.ADCSEQSEL0.bit.SEQ2  = 13; //for Io_sense //2 	//Ishare
	AdcRegs.ADCSEQSEL0.bit.SEQ3  = 3; //for Ishare//8;	//VIN_MON
	AdcRegs.ADCSEQSEL1.bit.SEQ4  = 8; //for Vin_mon//7; 	//Temp
	AdcRegs.ADCSEQSEL1.bit.SEQ5  = 7; //for temp//9; 	//VO OVP
	AdcRegs.ADCSEQSEL1.bit.SEQ6  = 9; //for Vout//6; 	//Ipri
	AdcRegs.ADCSEQSEL1.bit.SEQ7  = 6; //for Ipri//14; 	//DEVICE TEMP
	AdcRegs.ADCSEQSEL2.bit.SEQ8  = 14;	//for devcie_temp //IO_SENSE

	AdcRegs.ADCAVGCTRL.bit.AVG0_EN = 1;	//Enable averaging
	AdcRegs.ADCAVGCTRL.bit.AVG1_EN = 1;	//Enable averaging 
	AdcRegs.ADCAVGCTRL.bit.AVG2_EN = 1;	//Enable averaging
	AdcRegs.ADCAVGCTRL.bit.AVG3_EN = 1;	//Enable averaging
	AdcRegs.ADCAVGCTRL.bit.AVG4_EN = 1;	//Enable averaging
	AdcRegs.ADCAVGCTRL.bit.AVG5_EN = 1;	//Enable averaging

	AdcRegs.ADCAVGCTRL.bit.AVG0_CONFIG = 0;//0-4x average, 1-8x average, 2-16x average, 3-32x average
	AdcRegs.ADCAVGCTRL.bit.AVG1_CONFIG = 3;//0-4x average, 1-8x average, 2-16x average, 3-32x average
	AdcRegs.ADCAVGCTRL.bit.AVG2_CONFIG = 3;//0-4x average, 1-8x average, 2-16x average, 3-32x average
	AdcRegs.ADCAVGCTRL.bit.AVG3_CONFIG = 3;//0-4x average, 1-8x average, 2-16x average, 3-32x average
	AdcRegs.ADCAVGCTRL.bit.AVG4_CONFIG = 3;//0-4x average, 1-8x average, 2-16x average, 3-32x average
	AdcRegs.ADCAVGCTRL.bit.AVG5_CONFIG = 3;//0-4x average, 1-8x average, 2-16x average, 3-32x average;

	AdcRegs.ADCCTRL.bit.ADC_EN = 1;		//Enable ADC

	AdcRegs.ADCCTRL.bit.SAMPLING_SEL =0;  
	AdcRegs.ADCCTRL.bit.SW_START = 1;	//Send start bit high
	AdcRegs.ADCCTRL.bit.SW_START = 0;	//Send start bit low

}
