#include "include.h"




void init_pmbus(void)
{
	int32 pmbus_address = 0x58;
	//pmbus initialization code.  Much of this is unnecessary after a reset, but is put
	//in for completeness, and in case code is entered after some other program uses
	//PMBus interface

	PMBusRegs.PMBINTM.all = 0x1FF; //disable all PMBus interrupts
	PMBusRegs.PMBCTRL2.all = PMBCTRL2_HALF0_PEC_ENA 
							 + pmbus_address 
							 + PMBCTRL2_HALF0_SLAVE_ADDRESS_MASK_DISABLE
							 + PMBCTRL2_ALL_RX_BYTE_ACK_CNT; 
	pmbus_state = PMBUS_STATE_IDLE;  //initialize state to no message in progress 
}

void init_timer_interrupt(void)
{
	TimerRegs.T16PWM0CMP0DAT.all = 1587;  //approx 10KHz. by spec
	TimerRegs.T16PWM0CMP1DAT.all = 0xffff;
	TimerRegs.T16PWM0CMPCTRL.all = 2;
	TimerRegs.T16PWM0CNTCTRL.all = 0x00c;

	disable_fast_interrupt(); //make sure fast interrupt is disabled
	disable_interrupt();
	write_firqpr (0x0A000000); //make them all irqs except FAULT_INT, DPWM2  
	write_reqmask(0x0A020000); //enable FAULT_INT and PWM0_INT, DPWM2 
	enable_interrupt();
	enable_fast_interrupt(); //make sure fast interrupt is enabled, enabled in Idle state
}

void init_light_load_configuration(void)
{
//	#if (LIGHT_LOAD_ENABLE == 1)
	Dpwm0Regs.DPWMCTRL1.bit.BURST_EN = 1; //Burst (Light Load) Mode Detection Enable
	Dpwm1Regs.DPWMCTRL1.bit.BURST_EN = 1;
	Dpwm2Regs.DPWMCTRL1.bit.BURST_EN = 1;
	Dpwm3Regs.DPWMCTRL1.bit.BURST_EN = 1;
	//  ShadowDpwmRegs.DPWMCTRL1.bit.BURST_EN = 1;
	LoopMuxRegs.LLCTRL.bit.CYCLE_CNT_EN = 0; //Enables Switching Cycle Counter for enabling constant pulse widths 
	// when configured in Light Load operation
	LoopMuxRegs.LLCTRL.bit.DPWM_ON_TIME = 0; // default, I guess this is irelevant, we don't use this in kilimanjaro approach
	LoopMuxRegs.LLCTRL.bit.LL_EN = 0;//disable burst mode for now        
	LoopMuxRegs.LLCTRL.bit.LL_FILTER_SEL = 0; // Configures source of filter data for Light Load comparisons 
	LoopMuxRegs.LLENTHRESH.bit.CYCLE_CNT_THRESH = 0; // Don't care// Disabled// Switching Cycle threshold where constant width DPWM pulses 
	// are enabled when number of switching cycles without pulses exceeds threshold
	LoopMuxRegs.LLENTHRESH.bit.TURN_ON_THRESH = pmbus_dcdc_config[0].ll_turn_on_thresh;
	// Filter data threshold where constant width DPWM pulses enabled when filter data exceeds threshold
	LoopMuxRegs.LLDISTHRESH.bit.TURN_OFF_THRESH = pmbus_dcdc_config[0].ll_turn_off_thresh;  
	// Filter data threshold where constant width DPWM pulses are disabled when filter data falls below threshold
//	LoopMuxRegs.FECTRL0MUX.bit.DPWM0_FRAME_SYNC_EN = 1;  

//	#endif
}


void init_gpio(void)
{
	// Set outputs to 0.
	MiscAnalogRegs.GLBIOVAL.all = 0;

	// 1 - GPIO, 0 - other functions
	MiscAnalogRegs.GLBIOEN.all = MASK_PGOOD | MASK_PSON | MASK_FAILURE | MASK_AC_FAIL_IN | MASK_AC_FAIL_OUT | MASK_OR_CTRL;

	// 1 - Output, 0 - Input
	MiscAnalogRegs.GLBIOOE.all = MASK_PGOOD | MASK_FAILURE | MASK_AC_FAIL_OUT | MASK_OR_CTRL;
}

void init_miscellaneous(void)
{
	enable_turn_on = 1;

	pmbus_status_word = 0;

	ishare_threshold = 1;
	ishare_center_threshold = 5000;

	master_state = 1;
	master_time_limit = 10;
	master_time_count = 0;

	ishare_threshold_ms = 1;
	ishare_center_threshold_ms = 2;
	ishare_threshold_master_enable = -60;
	ishare_threshold_slave_enable = 10;

	current_share_kp = 8000;
	current_share_ki = 5;

	error_zero = 0;

	light_load_enable = DISABLE;
	pfc_phase_2_enable = ENABLE;
	pfc_zvs_enable = DISABLE;
	pfc_os_enable = ENABLE;

	debug_buffer[0]=1;
	debug_buffer[1]=2;
	debug_buffer[2]=3;
	debug_buffer[3]=4;
	debug_buffer[4]=5;
	debug_buffer[5]=6;
	debug_buffer[6]=7;
	debug_buffer[7]=8;

	supply_state = STATE_IDLE;
}

