//init_protection
#include "include.h"

void init_ocp(void)
{
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_THRESH = pmbus_dcdc_config_translated[0].iout_oc_fault_limit;//120; //72 for 20A; 123 for 37A

	FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_EN = 1;           //disable analog comparators for now

    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_SEL = 0;        //Configures reference of analog comparator E to ACOMP_E_THRESH
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_POL = 1;        //Polarity of comparator when an event is detected.
    
    FaultMuxRegs.DPWM0FLTABDET.bit.ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM1FLTABDET.bit.ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM2FLTABDET.bit.ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM3FLTABDET.bit.ACOMP_E_EN = 1;

    Dpwm0Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1; //enable latched faults
    Dpwm0Regs.DPWMFLTCTRL.bit.AB_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
    Dpwm0Regs.DPWMFLTCTRL.bit.A_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
    Dpwm0Regs.DPWMFLTCTRL.bit.B_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
	Dpwm1Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
    Dpwm1Regs.DPWMFLTCTRL.bit.AB_MAX_COUNT = 0;
    Dpwm1Regs.DPWMFLTCTRL.bit.A_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
    Dpwm1Regs.DPWMFLTCTRL.bit.B_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
	Dpwm2Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
    Dpwm2Regs.DPWMFLTCTRL.bit.AB_MAX_COUNT = 0;
    Dpwm2Regs.DPWMFLTCTRL.bit.A_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
    Dpwm2Regs.DPWMFLTCTRL.bit.B_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
	Dpwm3Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
    Dpwm3Regs.DPWMFLTCTRL.bit.AB_MAX_COUNT = 0;
    Dpwm3Regs.DPWMFLTCTRL.bit.A_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?
    Dpwm3Regs.DPWMFLTCTRL.bit.B_MAX_COUNT = 0; //set count for latched faults to 1 event - or is it 0?


/*
	FaultMuxRegs.DPWM0FAULTDET.bit.PWMA_ACOMP_E_EN = 1;   // above code is good enought to shut down DPWMs
	FaultMuxRegs.DPWM0FAULTDET.bit.PWMB_ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM1FAULTDET.bit.PWMA_ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM1FAULTDET.bit.PWMB_ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM2FAULTDET.bit.PWMA_ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM2FAULTDET.bit.PWMB_ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM3FAULTDET.bit.PWMA_ACOMP_E_EN = 1;
	FaultMuxRegs.DPWM3FAULTDET.bit.PWMB_ACOMP_E_EN = 1;
*/

	
}

void init_cbc(void)
{
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_F_THRESH = pmbus_dcdc_config_translated[0].iin_oc_fault_limit;//0x30;

	FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_EN = 1;           //disable analog comparators for now

    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_F_SEL = 0;        //Configures reference of analog comparator F to ACOMP_F_THRESH
    FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_F_POL = 1;        //Polarity of comparator when an event is detected.

	FaultMuxRegs.DPWM0CLIM.bit.ACOMP_F_EN = 1;
	FaultMuxRegs.DPWM1CLIM.bit.ACOMP_F_EN = 1;
	FaultMuxRegs.DPWM2CLIM.bit.ACOMP_F_EN = 1;
	FaultMuxRegs.DPWM3CLIM.bit.ACOMP_F_EN = 1;

 	Dpwm0Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 1;
//  	Dpwm0Regs.DPWMFLTCTRL.bit.CBC_MAX_COUNT = 20;
//  	Dpwm0Regs.DPWMFLTCTRL.bit.CBC_FAULT_EN = 1;
 	Dpwm1Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 1;
// 	Dpwm1Regs.DPWMFLTCTRL.bit.CBC_MAX_COUNT = 20;
//  	Dpwm1Regs.DPWMFLTCTRL.bit.CBC_FAULT_EN = 1;
 	Dpwm2Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 1;
 // 	Dpwm2Regs.DPWMFLTCTRL.bit.CBC_MAX_COUNT = 20;
 // 	Dpwm2Regs.DPWMFLTCTRL.bit.CBC_FAULT_EN = 1;
  	Dpwm3Regs.DPWMCTRL0.bit.CBC_PWM_AB_EN = 1;
 // 	Dpwm3Regs.DPWMFLTCTRL.bit.CBC_MAX_COUNT = 20;
//  	Dpwm3Regs.DPWMFLTCTRL.bit.CBC_FAULT_EN = 1;
    
}

void init_ovp(void)
{
    FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_B_THRESH = pmbus_dcdc_config_translated[0].vout_ov_fault_limit;//72;//14V AD_03 62=12V

	FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_EN = 1;           //Enable analog comparators

    FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_B_SEL = 0;        //Use threshold register for trip
    FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_B_POL = 1;        //Above thresh to trip
    
    FaultMuxRegs.DPWM0FLTABDET.bit.ACOMP_B_EN = 1;  //must enable to detect
	FaultMuxRegs.DPWM1FLTABDET.bit.ACOMP_B_EN = 1;
	FaultMuxRegs.DPWM2FLTABDET.bit.ACOMP_B_EN = 1;
	FaultMuxRegs.DPWM3FLTABDET.bit.ACOMP_B_EN = 1;

	Dpwm0Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
	Dpwm1Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
	Dpwm2Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
	Dpwm3Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
} 

void init_uvp(void)
{
    FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_C_THRESH =40;//7V

	FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_EN = 1;           //Enable analog comparators

    FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_C_SEL = 0;        //Use threshold register for trip
    FaultMuxRegs.ACOMPCTRL1.bit.ACOMP_C_POL = 0;        //Above thresh to trip
    
//    FaultMuxRegs.DPWM0FLTABDET.bit.ACOMP_C_EN = 1;  //must enable to detect
//	FaultMuxRegs.DPWM1FLTABDET.bit.ACOMP_C_EN = 1;
//	FaultMuxRegs.DPWM2FLTABDET.bit.ACOMP_C_EN = 1;
//	FaultMuxRegs.DPWM3FLTABDET.bit.ACOMP_C_EN = 1;

//	Dpwm0Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
//	Dpwm1Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
//	Dpwm2Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
//	Dpwm3Regs.DPWMFLTCTRL.bit.ALL_FAULT_EN = 1;
} 

void init_protection(void)
{
	init_cbc();
	init_ocp();
	init_ovp();
	init_uvp();
}

