#include "include.h"

volatile int fir_index;

#pragma INTERRUPT(undefined_instruction_exception,UDEF)
void undefined_instruction_exception(void)
{
}

#pragma INTERRUPT(software_interrupt,SWI)
void software_interrupt(Uint32 arg1, Uint32 arg2, Uint32 arg3, Uint8 swi_number)
//void software_interrupt(Uint32 *address, Uint32 data, Uint32 more_data, Uint8 swi_number)
{
	//make sure interrupts are disabled
    asm(" MRS     r3, cpsr "); 		// get psr
    asm(" ORR     r3, r3, #0xc0 "); // set interrupt disables
    asm(" MSR     cpsr, r3"); 		// restore psr

	asm("  LDRB  R3,[R14,#-1]"); //get swi number into R3 as fourth operand

	switch (swi_number) //handle flash write/erase and ROM backdoor first
	{
		case 0: 
	//--------------------------------------------------------------------------------------
	// SWI ALIAS: erase_data_flash_segment()
	// 	Erases one segment of Data Flash and wait for erase to complete.
	//--------------------------------------------------------------------------------------
		case 1: 	
	//--------------------------------------------------------------------------------------
	// SWI ALIAS: erase_dflash_segment_no_delay()
	// 	Erase one segment of Data Flash and return without waiting for completion.
	//--------------------------------------------------------------------------------------
		{
	        union DFLASHCTRL_REG dflashctrl_shadow;	// Shadow copy of control register
			
			if (arg1 >= DATA_FLASH_NUM_SEGMENTS)	
			{
				return;		// Invalid segment number
			}
			DecRegs.FLASHILOCK.all = 0x42DC157E; //unlock flash write;
  			// Set the bits in the Data Flash Control Register to erase the indicated segment
			dflashctrl_shadow.all = DecRegs.DFLASHCTRL.all;	// Read the hardware register
			dflashctrl_shadow.bit.PAGE_ERASE = 1; 			// Erase one segment
			dflashctrl_shadow.bit.PAGE_SEL = arg1;		// Segment number
			DecRegs.DFLASHCTRL.all = dflashctrl_shadow.all;	// Write the hardware register
			if (swi_number == 1)	// 0= Wait for erase to complete, 1= return immediately
		    {
			  return;
		    }
			while(DecRegs.DFLASHCTRL.bit.BUSY != 0)
			{
				; //do nothing while it programs
			}
			return;
		
		}
		case 3: //write word to data flash

			if(((arg1) < DATA_FLASH_START_ADDRESS) ||
		   ((arg1) > DATA_FLASH_END_ADDRESS))
				{//if out of data flash range
				return;
				}

			//this clears read only bit to permit writes to data flash.
			DecRegs.FLASHILOCK.all = 0x42DC157E; //unlock flash write

			DecRegs.MFBALR2.bit.BLOCK_SIZE =2;
			DecRegs.MFBALR2.bit.ADDRESS = 0x22;
			DecRegs.MFBALR2.bit.RONLY = 0;
			 	
			//put data in word.
			*(Uint32 *)(arg1 & 0xfffffffc) = arg2 ;

 		    DecRegs.MFBALR2.bit.RONLY = 1;

			while(DecRegs.DFLASHCTRL.bit.BUSY != 0)
			{
				; //do nothing while it programs
			}
			return;

			 //handle interrupt enables/disables next
		case 4: //enable fiq
	        asm(" MRS     r0, spsr "); //get saved psr
	        asm(" BIC     r0, r0, #0x40 "); // clear fiq disable
	        asm(" MSR     spsr, r0"); //restore saved psr
			return;
		case 5: //disable fiq
	        asm(" MRS     r0, spsr "); //get saved psr
	        asm(" ORR     r0, r0, #0x40 "); // set fiq disable
	        asm(" MSR     spsr, r0"); //restore saved psr
			return;
		case 6: //enable irq
	        asm(" MRS     r0, spsr "); //get saved psr
	        asm(" BIC     r0, r0, #0x80 "); // clear irq disable
	        asm(" MSR     spsr, r0"); //restore saved psr
			return;
		case 7: //disable irq
	        asm(" MRS     r0, spsr "); //get saved psr
	        asm(" ORR     r0, r0, #0x80 "); // set irq disable
	        asm(" MSR     spsr, r0"); //restore saved psr
			return;
		case 8: //write to fiq/irq program_control_register
			CimRegs.FIRQPR.all = arg1;
			return;
		case 9: //write to fiq/irq program_control_register
			CimRegs.REQMASK.all = arg1;
			return;
 		case 10: // switch to supervisor mode
 			asm(" MRS     r0, spsr "); //get saved psr
 			asm(" BIC	  r0, r0, #0x1F "); // clear 5 lsbs.
 			asm(" ORR     r0, r0, #0x13 "); // set mode bits to 13.
 			asm(" MSR     spsr, r0"); //restore saved psr
 			return;
 		case 11: // switch to user mode
 			asm(" MRS     r0, spsr "); //get saved psr
 			asm(" BIC	  r0, r0, #0x1F "); // clear 5 lsbs.
 			asm(" ORR     r0, r0, #0x10 "); // set mode bits to 10.
 			asm(" MSR     spsr, r0"); //restore saved psr
 			return;
        case 12: // clear integrity word.
		{
		  {
		     register Uint32 * program_index = (Uint32 *) 0x19000; //store destination address for program
		     register Uint32 * source_index = (Uint32 *)zero_out_integrity_word; //Set source address of PFLASH;
		 
		     register Uint32 counter;
		 
		     for(counter=0; counter < 500; counter++) //Copy program from PFLASH to RAM
		     {
		      *(program_index++)=*(source_index++);
		     }
		   }
		   {
		     register FUNC_PTR func_ptr;
		     func_ptr=(FUNC_PTR)0x19000;     //Set func_ptr to point to function copied to RAM
		     func_ptr(); 
		     func_ptr=(FUNC_PTR)0x10000;     //Set function to invalid location to cause reset of part.
		     func_ptr(); 
		   }        //execute erase checksum
		 
		   return;
        }
	    case 13: //write block to data flash
			//--------------------------------------------------------------------------------------
		// SWI ALIAS: write_data_flash_block()
		// 	Copies a block of data from a source (typically RAM) to a destination in Data Flash.
		// Handles locking and unlocking the read-only bit.
		// Includes necessary delays while writing.
		// Assumptions:  
		//	Destination address is in Data Flash.
		//	Destination addresses start and end on word boundary.
		//	Source addresses start and end on word boundaries.
		//--------------------------------------------------------------------------------------
		{
			volatile Uint32* dest_ptr = (volatile Uint32*)(arg1 & 0xfffffffc);
			Uint32*	src_ptr =  (Uint32*)(arg2);
			int32	byte_counter = (int32)arg3;	// Use int instead of Uint in case count is not a multiple of 4
			
			// Validate that destination address is in Data Flash
			if(  ((arg1) < DATA_FLASH_START_ADDRESS)
	 	       ||((arg1) > DATA_FLASH_END_ADDRESS)  )
			{//if out of data flash range
				flash_write_status = FLASH_INVALID_ADDRESS;
				return;	// Return without writing to DFlash
			}

			// Clear read-only bit to allow writes to Data Flash.
			DecRegs.MFBALR2.bit.RONLY = 0;	
			
			// Copy a block of RAM to DFlash						     
			while (byte_counter > 0)
			{
				Uint32	temp_word = *src_ptr++;
				DecRegs.FLASHILOCK.all = 0x42DC157E; //unlock flash write
				// Write the temp word to DFlash.
				*dest_ptr = temp_word;

				// *** Should add value to checksum.
				// checksum += temp.word;

				// Wait for any previous writes to complete.
				while(DecRegs.DFLASHCTRL.bit.BUSY != 0)
				{
					; //do nothing while it programs
				}

				// Read back value from DFlash. Abort if it does not match intended value.
				if (*dest_ptr != temp_word)
				{
					// Set an error flag to indicate write failure.
					flash_write_status = FLASH_MISCOMPARE;
					return;	
				}

				dest_ptr++;
				byte_counter -= 4;
			}

			// Set read-only bit to protect Data Flash
			DecRegs.MFBALR2.bit.RONLY = 1;
			flash_write_status = FLASH_SUCCESS;
			return;
		}
		case 14: // erase entire Program Flash
		{
		  {
		     register Uint32 * program_index = (Uint32 *) 0x19000; //store destination address for program
		     register Uint32 * source_index = (Uint32 *)clear_program_flash; //Set source address of PFLASH;
		 
		     register Uint32 counter;
		 
		     for(counter=0; counter < 500; counter++) //Copy program from PFLASH to RAM
		     {
		      *(program_index++)=*(source_index++);
		     }
		   }
		   {
		     register FUNC_PTR func_ptr;
		     func_ptr=(FUNC_PTR)0x19000;     //Set function to 0x19000
		     func_ptr(); 
		   }        //execute mass erase PFLASH
		 
		   return;
        }
		default:
			break;
	}
}

#pragma INTERRUPT(abort_prefetch_exception,PABT)
void abort_prefetch_exception(void)
{
}

#pragma INTERRUPT(abort_data_fetch_exception,DABT)
void abort_data_fetch_exception(void)
{
}


#pragma INTERRUPT(fast_interrupt,FIQ)
void fast_interrupt(void)
{
	volatile int32 temp;


	fir_index = CimRegs.FIQIVEC.all;

	if(fir_index == 28)  
	{
		vloop_filter = (signed int) (Filter0Regs.FILTERYNREAD.bit.YN);
		iloop_filter = (signed int) (Filter1Regs.FILTERYNREAD.bit.YN);

		if (iloop_filter  > vloop_filter)
		{
			
			FeCtrl1Regs.EADCDAC.bit.DAC_VALUE = (pmbus_dcdc_config_translated[0].cpcc_imax +350);
		   	LoopMuxRegs.PCMCTRL.bit.PCM_FILTER_SEL =0; //select filter0 for voltage loop slope source
			Filter0Regs.FILTERCTRL.bit.KI_STALL =0;
			vv_flag =1;
			if(cc_flag ==1)
			{
				cv_trans_flag =1;
				cc_flag =0;
				start_state = START_UP;
			}

		}

		else if (iloop_filter < (vloop_filter - 0x200))
		{
			
			FeCtrl1Regs.EADCDAC.bit.DAC_VALUE  		= pmbus_dcdc_config_translated[0].cpcc_imax;
		   	LoopMuxRegs.PCMCTRL.bit.PCM_FILTER_SEL =1; //select filter1 for slope compensation source
		  	cc_flag =1;
			cp_flag =0;
			if ((vv_flag ==1) && (iloop_filter <= 0x120000))
			{
				preset_filter0(0x1A0000);
				vv_flag = 0;
				FeCtrl0Regs.RAMPCTRL.bit.FIRMWARE_START = 1; //Initiate soft start ramp 

			}
			Filter0Regs.FILTERCTRL.bit.KI_STALL =1;
			 
		}

  		Dpwm2Regs.DPWMINT.bit.PRD_INT_EN = 1; //clear interrupt flag 

		if(FaultMuxRegs.FAULTMUXRAWSTAT.bit.ACOMP_C==1) //under voltage
		//if(0) // change to this to make pwr030 power on only test
		{

			if((supply_state == STATE_REGULATED) && (vv_flag == 1))
			{
				Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;		
				LoopMuxRegs.GLBEN.all = 0;					//gloable disable all PE and DPWM
				Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 0; 		//edge enable necessary to guarantee turn off of edge enabled DPWM pins
				LoopMuxRegs.LLCTRL.bit.LL_EN = 0;			//disable burst mode
				fault_flag = 1;
				fault_type = UNDER_VOLTAGE;
				supply_state = STATE_FAULT;
			}
		}


	}
	if(fir_index == 26)   //DPWM2 interrupt

	{

		Dpwm2Regs.DPWMINT.bit.PRD_INT_EN =0;		
		LoopMuxRegs.GLBEN.all = 0;					//gloable disable all PE and DPWM
		Dpwm2Regs.DPWMEDGEGEN.bit.EDGE_EN = 0; 		//edge enable necessary to guarantee turn off of edge enabled DPWM pins
		LoopMuxRegs.EXTDACCTRL.bit.EXT_DAC0_EN = 0; //disable CPCC
		LoopMuxRegs.LLCTRL.bit.LL_EN = 0;			//disable burst mode

	
	#ifdef CURRENT_SHARING_ENABLE
		disable_current_sharing();					//disable current sharing
	#endif				

		temp = FaultMuxRegs.FAULTMUXINTSTAT.all;//read to clear the interrupt flag

		if(temp & 0x10)//OCP
		{
			pmbus_status_word |= PMBUS_STATUS_WORD_IOUT_OC | PMBUS_STATUS_WORD_OFF | 
								 PMBUS_STATUS_WORD_IOUT    | PMBUS_STATUS_WORD_HIGH_BYTE;
			
			hiccup_counter = 0;//reset counter for OCP state machine
			fault_type = OVER_CURRENT;
			FaultMuxRegs.ACOMPCTRL2.bit.ACOMP_E_INT_EN = 0;	//disable ACOMP-E interrupt
			

		
		}
		else//OVP
		{
			pmbus_status_word |= PMBUS_STATUS_WORD_VOUT_OV | PMBUS_STATUS_WORD_OFF | 
								 PMBUS_STATUS_WORD_VOUT    | PMBUS_STATUS_WORD_HIGH_BYTE;
			fault_type = OVER_VOLTAGE;
			FaultMuxRegs.ACOMPCTRL0.bit.ACOMP_B_INT_EN = 0; //disable ACOMP-B interrupt

		}
		
		fault_flag = 1;

	}

	temp = FaultMuxRegs.FAULTMUXINTSTAT.all;//read to clear the interrupt flag


}



